/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.UniGame;
import shell.Define;

public class TouchZoneManager
implements Define {
    private static final int MAX_ZONE = 20;
    private Zone[] _zones = new Zone[20];
    private int _active = -1;

    public boolean onPressed(int n, int n2) {
        for (int i = 0; i < 20; ++i) {
            if (this._zones[i] == null || !TouchZoneManager.inRect(n, n2, this._zones[i])) continue;
            UniGame.postObjectMessage(this._zones[i].id, -3, 0, n, n2);
            this._active = i;
            return true;
        }
        return false;
    }

    public boolean onMoved(int n, int n2) {
        if (this._active >= 0 && this._zones[this._active] != null && TouchZoneManager.inRect(n, n2, this._zones[this._active])) {
            UniGame.postObjectMessage(this._zones[this._active].id, -3, 1, n, n2);
            return true;
        }
        return false;
    }

    public boolean onReleased(int n, int n2) {
        if (this._active >= 0 && this._zones[this._active] != null && TouchZoneManager.inRect(n, n2, this._zones[this._active])) {
            UniGame.postObjectMessage(this._zones[this._active].id, -3, 2, n, n2);
            this._active = -1;
            return true;
        }
        return false;
    }

    public int getZoneId(int n) {
        Zone zone;
        if (n >= 0 && n < this._zones.length && (zone = this._zones[n]) != null) {
            return zone.id;
        }
        return -1;
    }

    public void registerZone(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < 20; ++i) {
            if (this._zones[i] != null) continue;
            this._zones[i] = new Zone();
            this._zones[i].x = n2;
            this._zones[i].y = n3;
            this._zones[i].w = n4;
            this._zones[i].h = n5;
            this._zones[i].id = n;
            return;
        }
    }

    public void unregisterZone(int n) {
        for (int i = 0; i < 20; ++i) {
            if (this._zones[i] == null || this._zones[i].id != n) continue;
            this._zones[i] = null;
            if (i == this._active) {
                this._active = -1;
            }
            return;
        }
    }

    public void reset() {
        for (int i = 0; i < this._zones.length; ++i) {
            this._zones[i] = null;
        }
        this._active = -1;
    }

    private static boolean inRect(int n, int n2, Zone zone) {
        return n > zone.x && n < zone.x + zone.w && n2 > zone.y && n2 < zone.y + zone.h;
    }

    private class Zone {
        public int x;
        public int y;
        public int w;
        public int h;
        public int id;

        private Zone() {
        }
    }
}

