/*
 * Decompiled with CFR 0.152.
 */
package shell;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import shell.QuickLZ;

public final class PXLoader {
    public static Image loadPX(String string) throws IOException {
        byte[] byArray = new PXLoader().getBytesFromFile(string);
        byte[] byArray2 = QuickLZ.decompress(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = PXLoader.fromARGB(255, dataInputStream.readByte() & 0xFF, dataInputStream.readByte() & 0xFF, dataInputStream.readByte() & 0xFF);
        }
        int[] nArray2 = new int[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            byte by = dataInputStream.readByte();
            if (by == 0) {
                nArray2[i] = PXLoader.fromARGB(0, 0, 0, 0);
                continue;
            }
            int n4 = by & 0x80;
            int n5 = (by & 0x7F) - 1;
            nArray2[i] = n4 == 0 ? PXLoader.alphaRGB(128, nArray[n5]) : nArray[n5];
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        Image image = Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)true);
        return image;
    }

    private byte[] getBytesFromFile(String string) throws IOException {
        int n;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        long l = inputStream.available();
        if (l > Integer.MAX_VALUE) {
            return null;
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + string);
        }
        inputStream.close();
        return byArray;
    }

    public static int fromARGB(int n, int n2, int n3, int n4) {
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public static int alphaRGB(int n, int n2) {
        int n3 = n << 24 | (n2 &= 0xFFFFFF);
        return n3;
    }
}

