/*
 * Decompiled with CFR 0.152.
 */
package hello;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GTantra {
    private static final boolean _bDebug = true;
    private static int version_no;
    private int _nModules;
    private int _nFrames;
    private int _nAniamtion;
    private int _nImagesUsed;
    private boolean _bIsCollisionInfo = false;
    public Image[][][] _module_images;
    static boolean processAlpha;
    private int[] _width;
    private int[] _height;
    private int[] _iFramesModCnt;
    private int[][] _iFrameModules;
    private int[][] _iFrameModX;
    private int[][] _iFrameModY;
    private int[] _iFrameCollX;
    private int[] _iFrameCollY;
    private int[] _iFrameCollWidth;
    private int[] _iFrameCollHeight;
    private int[] _iAnimFrameCnt;
    private int[][] _iAnimFrames;
    private int[][] _iAnimFrameX;
    private int[][] _iAnimFrameY;
    public static int _iImageFormate;
    static final int IMAGE_1 = 1;
    static final int IMAGE_4 = 2;
    static final int IMAGE_16 = 3;
    static final int IMAGE_256 = 4;
    public static int _iPixelFormate;
    static final int PIXEL_8888 = 0;
    static final int PIXEL_0888 = 1;
    static final int PIXEL_4444 = 2;
    static final int PIXEL_0333 = 3;
    static final int PIXEL_0555 = 4;
    static final int PIXEL_0565 = 5;
    byte[][][] colors = new byte[256][][];
    int _iNColors;
    int[] modulePixels;
    byte[][] module_flag;
    byte[][] frame_flag;
    byte[][] frameTimer;
    int[][][] localTimeCounter;
    byte[] pixel_locations;
    byte[] image_data;
    int[] module_data_off;
    int num_pal = 0;
    int crt_pal = 0;
    public static final byte FLAG_FLIP_X = 1;
    public static final byte FLAG_FLIP_Y = 2;
    int[][] currentFrame;
    private boolean[][] moduleUses;
    private static int NORMAL;
    private static int FLIPED_X;
    private static int FLIPED_Y;
    private static int FLIPED_XY;
    static int[] crcTable;
    public String map_char_arry = "";
    public static final int TEXT_LEFT = 1;
    public static final int TEXT_RIGHT = 2;
    public static final int TEXT_VCENTER = 3;
    public static final int TEXT_HCENTER = 4;
    public static final int TEXT_VCENTER_HCENTER = 7;
    public int _iSpaceCharWidth = 0;
    public int _iCharCommanHeight = 0;
    public static final int FONT_FRAME_ID = 0;
    public static int EXTRA_SPACE_WIDTH;
    public static int EXTRA_SPACE_HEIGHT;
    private static int MAX_LINES_ALLOWED;
    private static char[][] pageChars;
    private static int numberOfLines;
    private static int[] line_width;

    public void Load(byte[] file, boolean doCaching) {
        try {
            int x;
            int j;
            int i;
            int offset = 0;
            version_no = file[offset++];
            System.out.println("version_no:" + version_no);
            _iPixelFormate = file[offset++];
            System.out.println("_iPixelFormate:" + _iPixelFormate);
            _iImageFormate = file[offset++];
            System.out.println("_iImageFormate:" + _iImageFormate);
            this.num_pal = file[offset++];
            System.out.println("num_pal:" + this.num_pal);
            if ((file[offset++] & 0xFF) != 0) {
                this._bIsCollisionInfo = true;
                System.out.println("Collision Info present..");
            } else {
                this._bIsCollisionInfo = false;
                System.out.println("Collision Info is not present..");
            }
            this._iNColors = file[offset++] & 0xFF;
            System.out.println(" Total Colors: " + this._iNColors);
            this.num_pal = this.num_pal == 0 ? 1 : this.num_pal;
            processAlpha = false;
            for (i = 0; i < this.num_pal; ++i) {
                this.colors[i] = new byte[this._iNColors][];
                for (j = 0; j < this._iNColors; ++j) {
                    this.colors[i][j] = new byte[4];
                    if (_iPixelFormate == 0) {
                        this.colors[i][j][0] = (byte)(file[offset++] & 0xFF);
                        this.colors[i][j][1] = (byte)(file[offset++] & 0xFF);
                        this.colors[i][j][2] = (byte)(file[offset++] & 0xFF);
                        this.colors[i][j][3] = (byte)(file[offset++] & 0xFF);
                        int val = (this.colors[i][j][0] & 0xFF) + ((this.colors[i][j][1] & 0xFF) << 8) + ((this.colors[i][j][2] & 0xFF) << 16) + ((this.colors[i][j][3] & 0xFF) << 24);
                        if (val == 0xFF00FF) {
                            this.colors[i][j][0] = 0;
                            continue;
                        }
                        this.colors[i][j][0] = -1;
                        continue;
                    }
                    if (_iPixelFormate != 1) continue;
                    this.colors[i][j][0] = -1;
                    this.colors[i][j][1] = (byte)(file[offset++] & 0xFF);
                    this.colors[i][j][2] = (byte)(file[offset++] & 0xFF);
                    this.colors[i][j][3] = (byte)(file[offset++] & 0xFF);
                }
            }
            System.out.println("Pixel Format:" + _iPixelFormate);
            this._nModules = file[offset++] & 0xFF;
            System.out.println("_nModules: " + this._nModules);
            this._width = new int[this._nModules];
            this._height = new int[this._nModules];
            for (i = 0; i < this._nModules; ++i) {
                this._width[i] = file[offset++] & 0xFF;
                this._height[i] = file[offset++] & 0xFF;
                System.out.println();
            }
            this._nFrames = file[offset++] & 0xFF;
            System.out.println("_nFrames: " + this._nFrames);
            this._iFramesModCnt = new int[this._nFrames];
            this._iFrameModules = new int[this._nFrames][];
            this._iFrameModX = new int[this._nFrames][];
            this._iFrameModY = new int[this._nFrames][];
            this._iFrameCollX = new int[this._nFrames];
            this._iFrameCollY = new int[this._nFrames];
            this._iFrameCollWidth = new int[this._nFrames];
            this._iFrameCollHeight = new int[this._nFrames];
            this.module_flag = new byte[this._nFrames][];
            for (i = 0; i < this._nFrames; ++i) {
                this._iFramesModCnt[i] = file[offset++] & 0xFF;
                this._iFrameModules[i] = new int[this._iFramesModCnt[i]];
                this._iFrameModX[i] = new int[this._iFramesModCnt[i]];
                this._iFrameModY[i] = new int[this._iFramesModCnt[i]];
                this.module_flag[i] = new byte[this._iFramesModCnt[i]];
                for (j = 0; j < this._iFramesModCnt[i]; ++j) {
                    this._iFrameModules[i][j] = file[offset++] & 0xFF;
                    this._iFrameModX[i][j] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this._iFrameModY[i][j] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this.module_flag[i][j] = (byte)(file[offset++] & 0xFF);
                }
                if (this._bIsCollisionInfo) {
                    this._iFrameCollX[i] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this._iFrameCollY[i] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this._iFrameCollWidth[i] = file[offset++] & 0xFF;
                    this._iFrameCollHeight[i] = file[offset++] & 0xFF;
                    continue;
                }
                this._iFrameCollX = null;
                this._iFrameCollY = null;
                this._iFrameCollWidth = null;
                this._iFrameCollHeight = null;
            }
            this._nAniamtion = file[offset++] & 0xFF;
            this._iAnimFrameCnt = new int[this._nAniamtion];
            this._iAnimFrames = new int[this._nAniamtion][];
            this._iAnimFrameX = new int[this._nAniamtion][];
            this._iAnimFrameY = new int[this._nAniamtion][];
            this.frame_flag = new byte[this._nAniamtion][];
            this.frameTimer = new byte[this._nAniamtion][];
            for (i = 0; i < this._nAniamtion; ++i) {
                this._iAnimFrameCnt[i] = file[offset++] & 0xFF;
                this._iAnimFrameX[i] = new int[this._iAnimFrameCnt[i]];
                this._iAnimFrameY[i] = new int[this._iAnimFrameCnt[i]];
                this._iAnimFrames[i] = new int[this._iAnimFrameCnt[i]];
                this.frame_flag[i] = new byte[this._iAnimFrameCnt[i]];
                this.frameTimer[i] = new byte[this._iAnimFrameCnt[i]];
                for (j = 0; j < this._iAnimFrameCnt[i]; ++j) {
                    this._iAnimFrames[i][j] = file[offset++] & 0xFF;
                    this._iAnimFrameX[i][j] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this._iAnimFrameY[i][j] = this.byteToIntWithSign((byte)(file[offset++] & 0xFF));
                    this.frame_flag[i][j] = (byte)(file[offset++] & 0xFF);
                    this.frameTimer[i][j] = (byte)(file[offset++] & 0xFF);
                }
            }
            this._module_images = new Image[this.num_pal][this._nModules][4];
            int image_data_length = 0;
            int mod_data_length = 0;
            this.module_data_off = new int[this._nModules];
            for (x = 0; x < this._nModules; ++x) {
                mod_data_length = this._width[x] * this._height[x];
                if (_iImageFormate == 1) {
                    mod_data_length >>= 3;
                    if (this._width[x] * this._height[x] % 8 != 0) {
                        // empty if block
                    }
                } else if (_iImageFormate == 2) {
                    mod_data_length >>= 2;
                    if (this._width[x] * this._height[x] % 4 != 0) {
                        ++mod_data_length;
                    }
                } else if (_iImageFormate == 3) {
                    mod_data_length >>= 1;
                    if (this._width[x] * this._height[x] % 2 != 0) {
                        ++mod_data_length;
                    }
                } else if (_iImageFormate == 4) {
                    // empty if block
                }
                this.module_data_off[x] = ++mod_data_length;
                image_data_length += mod_data_length;
            }
            this.image_data = new byte[image_data_length];
            for (x = 0; x < image_data_length; ++x) {
                this.image_data[x] = file[offset++];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file = null;
        this.checkModuleUses();
        if (doCaching) {
            for (int i = 0; i < this.num_pal; ++i) {
                this.BuildImages(i);
            }
            this.freeImageData();
        }
        this.animInitilazation();
    }

    private void checkModuleUses() {
        int j;
        int i;
        System.out.println("VIRAT   " + this.module_flag.length);
        this.moduleUses = new boolean[this._nModules][4];
        for (i = 0; i < this.moduleUses.length; ++i) {
            this.moduleUses[i][GTantra.NORMAL] = true;
        }
        for (i = 0; i < this.module_flag.length; ++i) {
            for (j = 0; j < this.module_flag[i].length; ++j) {
                if ((this.module_flag[i][j] & 1) != 0 && (this.module_flag[i][j] & 2) != 0) {
                    this.moduleUses[this._iFrameModules[i][j]][GTantra.FLIPED_XY] = true;
                    continue;
                }
                if ((this.module_flag[i][j] & 1) != 0) {
                    this.moduleUses[this._iFrameModules[i][j]][GTantra.FLIPED_X] = true;
                    continue;
                }
                if ((this.module_flag[i][j] & 2) == 0) continue;
                this.moduleUses[this._iFrameModules[i][j]][GTantra.FLIPED_Y] = true;
            }
        }
        for (i = 0; i < this.frame_flag.length; ++i) {
            for (j = 0; j < this.frame_flag[i].length; ++j) {
                int frame = this._iAnimFrames[i][j];
                int flag = this.frame_flag[i][j];
                for (int k = 0; k < this._iFramesModCnt[frame]; ++k) {
                    if (((flag ^= this.module_flag[frame][k] & 0xF) & 1) != 0 && (flag & 2) != 0) {
                        this.moduleUses[this._iFrameModules[frame][k]][GTantra.FLIPED_XY] = true;
                        continue;
                    }
                    if ((flag & 1) != 0) {
                        this.moduleUses[this._iFrameModules[frame][k]][GTantra.FLIPED_X] = true;
                        continue;
                    }
                    if ((flag & 2) == 0) continue;
                    this.moduleUses[this._iFrameModules[frame][k]][GTantra.FLIPED_Y] = true;
                }
            }
        }
    }

    private ALLColor RetriveImageData(int pal, int moduleId, int flags) {
        int j;
        int t;
        int t2;
        int i;
        int i2;
        int _iImageLength = this._width[moduleId] * this._height[moduleId];
        this.pixel_locations = new byte[_iImageLength];
        byte _bReadingByte = 0;
        boolean _iShiftCounter = false;
        boolean _ILocationCounter = false;
        int offset = 0;
        for (i2 = 0; i2 < moduleId; ++i2) {
            offset += this.module_data_off[i2];
        }
        if (_iImageFormate == 1) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)(_bReadingByte >> 0 & 1);
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 1 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 2 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 3 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 4 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 5 & 1);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)(_bReadingByte >> 6 & 1);
                }
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)(_bReadingByte >> 7 & 1);
            }
        } else if (_iImageFormate == 2) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 0 & 3);
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 2 & 3);
                }
                if (i2 < _iImageLength) {
                    this.pixel_locations[i2++] = (byte)((_bReadingByte & 0xFF) >> 4 & 3);
                }
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)((_bReadingByte & 0xFF) >> 6 & 3);
            }
        } else if (_iImageFormate == 3) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2++] = (byte)(_bReadingByte >> 0 & 0xF);
                if (i2 >= _iImageLength) continue;
                this.pixel_locations[i2] = (byte)(_bReadingByte >> 4 & 0xF);
            }
        } else if (_iImageFormate == 4) {
            for (i2 = 0; i2 < _iImageLength; ++i2) {
                _bReadingByte = (byte)(this.image_data[offset++] & 0xFF);
                this.pixel_locations[i2] = (byte)(_bReadingByte & 0xFF);
            }
        }
        ALLColor pixels = new ALLColor(this._width[moduleId] * this._height[moduleId]);
        for (i = 0; i < this._width[moduleId] * this._height[moduleId]; ++i) {
            pixels.alpah[i] = this.colors[pal][this.pixel_locations[i] & 0xFF][0];
            pixels.red[i] = this.colors[pal][this.pixel_locations[i] & 0xFF][2];
            pixels.green[i] = this.colors[pal][this.pixel_locations[i] & 0xFF][1];
            pixels.blue[i] = this.colors[pal][this.pixel_locations[i] & 0xFF][3];
        }
        this.pixel_locations = null;
        if ((flags & 1) != 0) {
            t2 = this._width[moduleId] * this._height[moduleId];
            t = this._width[moduleId] >> 1;
            for (i = 0; i < t2; i += this._width[moduleId]) {
                j = 0;
                int j2 = this._width[moduleId] - 1;
                while (j < t) {
                    pixels.swap(i + j, i + j2);
                    ++j;
                    --j2;
                }
            }
        }
        if ((flags & 2) != 0) {
            i = 0;
            t = 0;
            t2 = this._width[moduleId] * (this._height[moduleId] - 1);
            while (i < this._height[moduleId] >> 1) {
                for (j = 0; j < this._width[moduleId]; ++j) {
                    pixels.swap(t + j, t2 + j);
                }
                ++i;
                t += this._width[moduleId];
                t2 -= this._width[moduleId];
            }
        }
        return pixels;
    }

    public void BuildImages(int pal) {
        for (int x = 0; x < this._nModules; ++x) {
            for (int i = 0; i < 4; ++i) {
                if (!this.moduleUses[x][i]) continue;
                int flag = 0;
                if (i == FLIPED_X) {
                    flag = 1;
                } else if (i == FLIPED_Y) {
                    flag = 2;
                } else if (i == FLIPED_XY) {
                    flag = 3;
                }
                ALLColor data = this.RetriveImageData(pal, x, flag);
                this._module_images[pal][x][i] = GTantra.toImage(this._width[x], this._height[x], data.alpah, data.red, data.green, data.blue);
                data.clear();
                data = null;
                System.gc();
            }
        }
    }

    public static Image toImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = GTantra.toPNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = GTantra.createHeaderChunk(width, height);
        byte[] data = GTantra.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = GTantra.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return GTantra.toChunk("IHDR", baos.toByteArray());
    }

    public static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y = 0; y < height; ++y) {
            raw[dest++] = 0;
            for (int x = 0; x < width; ++x) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
            }
        }
        return GTantra.toChunk("IDAT", GTantra.toZLIB(raw));
    }

    public static byte[] createTrailerChunk() throws IOException {
        return GTantra.toChunk("IEND", new byte[0]);
    }

    public static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = GTantra.updateCRC(crc, bid);
        crc = GTantra.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    public static void createCRCTable() {
        crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            GTantra.crcTable[i] = c;
        }
    }

    public static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            GTantra.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 5 + 6);
        DataOutputStream zlib = new DataOutputStream(baos);
        int tmp = 8;
        zlib.writeByte(tmp);
        zlib.writeByte((31 - (tmp << 8) % 31) % 31);
        zlib.writeByte(1);
        char length = (char)raw.length;
        zlib.writeByte((byte)(length & 0xFF));
        zlib.writeByte((byte)((length & 0xFF00) >> 8));
        zlib.writeByte((byte)(~length & 0xFF));
        zlib.writeByte((byte)((~length & 0xFF00) >> 8));
        zlib.write(raw);
        zlib.writeInt(GTantra.calcADLER32(raw));
        return baos.toByteArray();
    }

    public static int calcADLER32(byte[] raw) {
        int s1 = 1;
        int s2 = 0;
        for (int i = 0; i < raw.length; ++i) {
            int abs = raw[i] >= 0 ? raw[i] : raw[i] + 256;
            s1 = (s1 + abs) % 65521;
            s2 = (s2 + s1) % 65521;
        }
        return (s2 << 16) + s1;
    }

    public void freeImageData() {
        this.pixel_locations = null;
        this.image_data = null;
        this.module_data_off = null;
        System.gc();
    }

    private int byteToIntWithSign(byte val) {
        int j = val & 0x80;
        val = (byte)(val & 0x7F);
        int num = (j >>= 7) == 1 ? val * -1 : val;
        return num;
    }

    void DrawAnimation(Graphics g, int animation, int posX, int posY, int flags) {
        for (int animFrame = 0; animFrame < this._iAnimFrameCnt[animation]; ++animFrame) {
            this.DrawAnimationFrame(g, animation, animFrame, posX, posY, flags);
        }
    }

    void animInitilazation() {
        this.currentFrame = new int[this._nAniamtion][1];
        this.localTimeCounter = new int[this._nAniamtion][][];
        for (int i = 0; i < this._nAniamtion; ++i) {
            this.currentFrame[i][0] = 0;
            this.localTimeCounter = new int[this._nAniamtion][this._iAnimFrameCnt[i]][1];
            for (int j = 0; j < this._iAnimFrameCnt[i]; ++j) {
                this.localTimeCounter[i][j][0] = 0;
            }
        }
    }

    void setAnimationObjects(int animId, int value) {
        this.currentFrame[animId] = new int[value];
        for (int i = 0; i < value; ++i) {
            this.currentFrame[animId][i] = 0;
        }
        for (int j = 0; j < this._iAnimFrameCnt[animId]; ++j) {
            this.localTimeCounter[animId][j] = new int[value];
        }
    }

    void render(Graphics g, int animation, int object, int posX, int posY, int flags, boolean loop) {
        if (this._iAnimFrameCnt[animation] == 0) {
            return;
        }
        byte currentFrameTime = this.frameTimer[animation][this.currentFrame[animation][0]];
        if (currentFrameTime != 0) {
            this.DrawAnimationFrame(g, animation, this.currentFrame[animation][object], posX, posY, flags);
        }
        int[] nArray = this.localTimeCounter[animation][this.currentFrame[animation][object]];
        int n = object;
        nArray[n] = nArray[n] + 1;
        if (this.localTimeCounter[animation][this.currentFrame[animation][object]][object] >= currentFrameTime) {
            if (this.currentFrame[animation][object] < this._iAnimFrameCnt[animation]) {
                int[] nArray2 = this.currentFrame[animation];
                int n2 = object;
                nArray2[n2] = nArray2[n2] + 1;
            }
            if (loop && this.currentFrame[animation][object] == this._iAnimFrameCnt[animation]) {
                this.currentFrame[animation][object] = 0;
            }
            this.localTimeCounter[animation][this.currentFrame[animation][object]][object] = 0;
        }
    }

    boolean isAnimationOver(int animation) {
        return this._iAnimFrameCnt[animation] - 1 == this.currentFrame[animation][0];
    }

    void reset(int animation) {
        this.currentFrame[animation][0] = 0;
    }

    int getCurrentAnimFrameCnt(int animation) {
        return this.currentFrame[animation][0];
    }

    int getCurrentFrame(int animation) {
        return this._iAnimFrames[animation][this.currentFrame[animation][0]];
    }

    int getAnimationFrameX(int animation, int frameLocation) {
        return this._iAnimFrameX[animation][frameLocation];
    }

    int getAnimationFrameY(int animation, int frameLocation) {
        return this._iAnimFrameY[animation][frameLocation];
    }

    int getAnimationCurrentCycle(int animation) {
        return this.currentFrame[animation][0];
    }

    int getNumberOfFrames(int animation) {
        return this._iAnimFrameCnt[animation];
    }

    void render(Graphics g, int animation, int posX, int posY, int flags, boolean loop) {
        if (this._iAnimFrameCnt[animation] == 0) {
            return;
        }
        byte currentFrameTime = this.frameTimer[animation][this.currentFrame[animation][0]];
        if (currentFrameTime != 0) {
            this.DrawAnimationFrame(g, animation, this.currentFrame[animation][0], posX, posY, flags);
        }
        int[] nArray = this.localTimeCounter[animation][this.currentFrame[animation][0]];
        nArray[0] = nArray[0] + 1;
        if (this.localTimeCounter[animation][this.currentFrame[animation][0]][0] >= currentFrameTime) {
            if (this.currentFrame[animation][0] + 1 <= this._iAnimFrameCnt[animation]) {
                int[] nArray2 = this.currentFrame[animation];
                nArray2[0] = nArray2[0] + 1;
            }
            if (loop && this.currentFrame[animation][0] == this._iAnimFrameCnt[animation]) {
                this.currentFrame[animation][0] = 0;
            }
            if (this.localTimeCounter[animation].length < this._iAnimFrameCnt[animation]) {
                this.localTimeCounter[animation] = new int[this._iAnimFrameCnt[animation]][1];
            }
            this.localTimeCounter[animation][this.currentFrame[animation][0]][0] = 0;
        }
    }

    void DrawAnimationFrame(Graphics g, int animation, int _aframe, int posX, int posY, int flags) {
        int frame = this._iAnimFrames[animation][_aframe];
        posX = (flags & 1) != 0 ? (posX -= this._iAnimFrameX[animation][_aframe]) : (posX += this._iAnimFrameX[animation][_aframe]);
        posY = (flags & 2) != 0 ? (posY -= this._iAnimFrameY[animation][_aframe]) : (posY += this._iAnimFrameY[animation][_aframe]);
        this.DrawFrame(g, frame, posX, posY, flags ^ this.frame_flag[animation][_aframe] & 0xF);
    }

    void DrawFrame(Graphics g, int frame, int posX, int posY, int flags) {
        for (int frameModule = 0; frameModule < this._iFramesModCnt[frame]; ++frameModule) {
            this.DrawFrameModule(g, frame, frameModule, posX, posY, flags);
        }
    }

    void DrawFrameModule(Graphics g, int frame, int frameModule, int posX, int posY, int flags) {
        boolean fm_flags = false;
        int module = this._iFrameModules[frame][frameModule];
        posX = (flags & 1) != 0 ? (posX -= this._iFrameModX[frame][frameModule]) : (posX += this._iFrameModX[frame][frameModule]);
        posY = (flags & 2) != 0 ? (posY -= this._iFrameModY[frame][frameModule]) : (posY += this._iFrameModY[frame][frameModule]);
        if ((flags & 1) != 0) {
            posX -= this._width[module] & 0xFF;
        }
        if ((flags & 2) != 0) {
            posY -= this._height[module] & 0xFF;
        }
        this.DrawModule(g, module, posX, posY, flags ^ this.module_flag[frame][frameModule] & 0xF);
    }

    public int getModuleWidth(int module_id) {
        int sizeX = this._width[module_id] & 0xFF;
        int sizeY = this._height[module_id] & 0xFF;
        return sizeX;
    }

    public void DrawModule(Graphics g, int module_id, int posX, int posY, int flag) {
        Image img;
        int sizeX = this._width[module_id] & 0xFF;
        int sizeY = this._height[module_id] & 0xFF;
        boolean x = false;
        boolean y = false;
        int flag_loc = NORMAL;
        if ((flag & 1) != 0) {
            flag_loc = FLIPED_X;
            if ((flag & 2) != 0) {
                flag_loc = FLIPED_XY;
            }
        } else if ((flag & 2) != 0) {
            flag_loc = FLIPED_Y;
        }
        if ((img = this._module_images[this.crt_pal][module_id][flag_loc]) == null) {
            return;
        }
        g.drawImage(img, posX, posY, 0);
    }

    public int[] getFrameRect(int frame, int posX, int posY, int[] arry) {
        int X = this.getSmallNumber(this._iFrameModX[frame]);
        int Y = this.getSmallNumber(this._iFrameModY[frame]);
        int temp1 = 0;
        int temp2 = 0;
        temp1 = this._iFrameModX[frame][0] + this._width[this._iFrameModules[frame][0]];
        temp2 = this._iFrameModY[frame][0] + this._height[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp1 < this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]]) {
                temp1 = this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]];
            }
            if (temp2 >= this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]]) continue;
            temp2 = this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]];
        }
        arry[0] = X + posX;
        arry[1] = Y + posY;
        arry[2] = temp1 - X;
        arry[3] = temp2 - Y;
        return arry;
    }

    public int[] getCollisionRect(int frameId, int[] tmp) {
        tmp[0] = this._iFrameCollX[frameId];
        tmp[1] = this._iFrameCollY[frameId];
        tmp[2] = this._iFrameCollWidth[frameId];
        tmp[3] = this._iFrameCollHeight[frameId];
        return tmp;
    }

    public int getFrameY(int frame) {
        return this.getSmallNumber(this._iFrameModY[frame]);
    }

    public int getFrameX(int frame) {
        return this.getSmallNumber(this._iFrameModX[frame]);
    }

    public int getFrameWidth(int frame) {
        int X = this.getSmallNumber(this._iFrameModX[frame]);
        int temp1 = 0;
        temp1 = this._iFrameModX[frame][0] + this._width[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp1 >= this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]]) continue;
            temp1 = this._iFrameModX[frame][i] + this._width[this._iFrameModules[frame][i]];
        }
        return temp1 - X;
    }

    public int getFrameHeight(int frame) {
        int Y = this.getSmallNumber(this._iFrameModY[frame]);
        int temp2 = 0;
        temp2 = this._iFrameModY[frame][0] + this._height[this._iFrameModules[frame][0]];
        for (int i = 0; i < this._iFramesModCnt[frame]; ++i) {
            if (temp2 >= this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]]) continue;
            temp2 = this._iFrameModY[frame][i] + this._height[this._iFrameModules[frame][i]];
        }
        return temp2 - Y;
    }

    public void setCurrentPallete(int pal) {
        this.crt_pal = pal;
    }

    protected int getSmallNumber(int[] arry) {
        int temp = 0;
        boolean temp2 = false;
        if (arry.length != 0) {
            temp = arry[0];
            for (int i = 0; i < arry.length; ++i) {
                if (temp <= arry[i]) continue;
                temp = arry[i];
            }
        }
        return temp;
    }

    public void LoadFont(byte[] file, String char_arry, boolean caching) {
        this.map_char_arry = char_arry;
        this.Load(file, caching);
        this._iSpaceCharWidth = this._width[0];
        this._iCharCommanHeight = this._height[0] + EXTRA_SPACE_HEIGHT;
    }

    public void LoadFont(byte[] file, String char_arry, int spaceWidth, int charHeight, boolean caching) {
        this.map_char_arry = char_arry;
        this.Load(file, caching);
        this._iSpaceCharWidth = spaceWidth;
        this._iCharCommanHeight = charHeight + EXTRA_SPACE_HEIGHT;
    }

    public int getCharHeight() {
        return this._iCharCommanHeight;
    }

    public int getCharWidth(char c) {
        if (c == '^') {
            return 0;
        }
        if (c == ' ') {
            return this._iSpaceCharWidth;
        }
        int index = this.map_char_arry.indexOf(c);
        if (index < 0 || index >= this._iFramesModCnt[0]) {
            System.err.println("Invalid Charactor in GetCharWidth");
            return -1;
        }
        index = this._iFrameModules[0][index];
        return this._width[index] + EXTRA_SPACE_WIDTH;
    }

    public int getStringWidth(String str) {
        int length = 0;
        for (int i = 0; i < str.length(); ++i) {
            length += this.getCharWidth(str.charAt(i));
        }
        return length;
    }

    public void drawString(Graphics g, String str, int posX, int posY, int anchor) {
        if (anchor == 2) {
            posX -= this.getStringWidth(str);
        }
        if (anchor == 3 || anchor == 7) {
            posX -= this.getStringWidth(str) >> 1;
        }
        if (anchor == 4 || anchor == 7) {
            posY -= this._iCharCommanHeight >> 1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') {
                posX += this._iSpaceCharWidth;
                continue;
            }
            int index = this.map_char_arry.indexOf(str.charAt(i));
            if (index < 0 || index >= this._iFramesModCnt[0]) {
                System.err.println("Invalid Charactor In Draw String: " + str.charAt(i));
                return;
            }
            this.DrawFrameModule(g, 0, index, posX, posY, 0);
            posX += this.getCharWidth(str.charAt(i));
        }
    }

    public String[] getBoxString(String str, int posX, int posY, int width, int height) {
        try {
            pageChars = new char[MAX_LINES_ALLOWED][];
            int tmpWidth = 0;
            StringBuffer tmpStr = new StringBuffer("");
            StringBuffer lineStr = new StringBuffer("");
            numberOfLines = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (((tmpWidth += this.getCharWidth(str.charAt(i))) < width || str.charAt(i) == ' ') && str.charAt(i) != '^') {
                    tmpStr.append(str.charAt(i));
                    if (str.charAt(i) != ' ') continue;
                    lineStr.append((Object)tmpStr);
                    tmpStr.delete(0, tmpStr.length());
                    continue;
                }
                if (str.charAt(i) == '^') {
                    tmpStr.append('^');
                    lineStr.append((Object)tmpStr);
                    tmpStr.delete(0, tmpStr.length());
                }
                tmpWidth = 0;
                if (lineStr.length() == 0) break;
                if (lineStr.charAt(lineStr.length() - 1) == ' ') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                if (lineStr.charAt(lineStr.length() - 1) == '^') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                GTantra.pageChars[GTantra.numberOfLines] = new char[lineStr.length()];
                for (int x = 0; x < lineStr.length(); ++x) {
                    GTantra.pageChars[GTantra.numberOfLines][x] = lineStr.charAt(x);
                }
                GTantra.line_width[GTantra.numberOfLines] = this.getStringWidth(lineStr.toString());
                ++numberOfLines;
                lineStr.delete(0, lineStr.length());
                i = str.charAt(i) != '^' ? (i -= tmpStr.length() + 1) : (i -= tmpStr.length());
                tmpStr.delete(0, tmpStr.length());
            }
            lineStr.append((Object)tmpStr);
            if (lineStr.length() > 0) {
                if (lineStr.charAt(lineStr.length() - 1) == ' ') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                GTantra.line_width[GTantra.numberOfLines] = this.getStringWidth(lineStr.toString());
                GTantra.pageChars[GTantra.numberOfLines] = new char[lineStr.length()];
                for (int x = 0; x < lineStr.length(); ++x) {
                    GTantra.pageChars[GTantra.numberOfLines][x] = lineStr.charAt(x);
                }
                ++numberOfLines;
            }
            String[] tmpReturnStr = new String[numberOfLines];
            for (int i = 0; i < numberOfLines; ++i) {
                tmpReturnStr[i] = "";
                for (int j = 0; j < pageChars[i].length; ++j) {
                    int n = i;
                    tmpReturnStr[n] = tmpReturnStr[n] + pageChars[i][j];
                }
            }
            tmpStr = null;
            lineStr = null;
            return tmpReturnStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int drawPage(Graphics g, String str, int posX, int posY, int width, int height, int anchor) {
        try {
            pageChars = new char[MAX_LINES_ALLOWED][];
            int tmpWidth = 0;
            StringBuffer tmpStr = new StringBuffer("");
            StringBuffer lineStr = new StringBuffer("");
            numberOfLines = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (((tmpWidth += this.getCharWidth(str.charAt(i))) < width || str.charAt(i) == ' ') && str.charAt(i) != '^') {
                    tmpStr.append(str.charAt(i));
                    if (str.charAt(i) != ' ') continue;
                    lineStr.append((Object)tmpStr);
                    tmpStr.delete(0, tmpStr.length());
                    continue;
                }
                if (str.charAt(i) == '^') {
                    tmpStr.append('^');
                    lineStr.append((Object)tmpStr);
                    tmpStr.delete(0, tmpStr.length());
                }
                tmpWidth = 0;
                if (lineStr.length() == 0) break;
                if (lineStr.charAt(lineStr.length() - 1) == ' ') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                if (lineStr.charAt(lineStr.length() - 1) == '^') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                GTantra.pageChars[GTantra.numberOfLines] = new char[lineStr.length()];
                for (int x = 0; x < lineStr.length(); ++x) {
                    GTantra.pageChars[GTantra.numberOfLines][x] = lineStr.charAt(x);
                }
                GTantra.line_width[GTantra.numberOfLines] = this.getStringWidth(lineStr.toString());
                ++numberOfLines;
                lineStr.delete(0, lineStr.length());
                i = str.charAt(i) != '^' ? (i -= tmpStr.length() + 1) : (i -= tmpStr.length());
                tmpStr.delete(0, tmpStr.length());
            }
            lineStr.append((Object)tmpStr);
            if (lineStr.length() > 0) {
                if (lineStr.charAt(lineStr.length() - 1) == ' ') {
                    lineStr.delete(lineStr.length() - 1, lineStr.length());
                }
                GTantra.line_width[GTantra.numberOfLines] = this.getStringWidth(lineStr.toString());
                GTantra.pageChars[GTantra.numberOfLines] = new char[lineStr.length()];
                for (int x = 0; x < lineStr.length(); ++x) {
                    GTantra.pageChars[GTantra.numberOfLines][x] = lineStr.charAt(x);
                }
                ++numberOfLines;
            }
            int line_y = posY;
            for (int i = 0; i < numberOfLines; ++i) {
                int line_x = posX;
                if (anchor == 2) {
                    line_x += width - line_width[i];
                }
                if (anchor == 4 || anchor == 7) {
                    line_x += width - line_width[i] >> 1;
                }
                if (anchor == 3 || anchor == 7) {
                    line_y = i < numberOfLines >> 1 ? posY + (height + this._iCharCommanHeight >> 1) - this._iCharCommanHeight * ((numberOfLines >> 1) - i) : posY + (height + this._iCharCommanHeight >> 1) + this._iCharCommanHeight * (i - (numberOfLines >> 1));
                    line_y -= this._iCharCommanHeight >> 1;
                }
                for (int j = 0; j < pageChars[i].length; ++j) {
                    if (pageChars[i][j] == ' ') {
                        line_x += this._iSpaceCharWidth;
                        continue;
                    }
                    int index = this.map_char_arry.indexOf(pageChars[i][j]);
                    if ((index < 0 || index >= this._iFramesModCnt[0]) && pageChars[i][j] != '^') {
                        System.err.println("Invalid Charactor In Draw Page:" + pageChars[i][j] + "index:" + index + "_iFramesModCnt[FONT_FRAME_ID]:" + this._iFramesModCnt[0]);
                        return numberOfLines;
                    }
                    if (pageChars[i][j] != '^') {
                        this.DrawFrameModule(g, 0, index, line_x, line_y, 0);
                    }
                    line_x += this.getCharWidth(pageChars[i][j]);
                }
                line_y += this._iCharCommanHeight;
            }
            tmpStr = null;
            lineStr = null;
            return numberOfLines;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static byte[] getFileByteData(String path) {
        System.out.println("hi");
        int file_size = 0;
        byte[] buffer = new byte[file_size];
        try {
            InputStream _is = "".getClass().getResourceAsStream(path);
            file_size = _is.available();
            buffer = new byte[file_size];
            for (int i = 0; i < file_size; ++i) {
                buffer[i] = (byte)(_is.read() & 0xFF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    static {
        processAlpha = false;
        NORMAL = 0;
        FLIPED_X = 1;
        FLIPED_Y = 2;
        FLIPED_XY = 3;
        crcTable = null;
        EXTRA_SPACE_WIDTH = 1;
        EXTRA_SPACE_HEIGHT = 3;
        MAX_LINES_ALLOWED = 140;
        line_width = new int[MAX_LINES_ALLOWED];
    }

    class ALLColor {
        byte[] alpah;
        byte[] red;
        byte[] green;
        byte[] blue;

        public ALLColor(int length) {
            this.alpah = new byte[length];
            this.red = new byte[length];
            this.green = new byte[length];
            this.blue = new byte[length];
        }

        public void clear() {
            this.alpah = null;
            this.red = null;
            this.green = null;
            this.blue = null;
        }

        public void swap(int index1, int index2) {
            byte tmp = this.alpah[index1];
            this.alpah[index1] = this.alpah[index2];
            this.alpah[index2] = tmp;
            tmp = this.red[index1];
            this.red[index1] = this.red[index2];
            this.red[index2] = tmp;
            tmp = this.green[index1];
            this.green[index1] = this.green[index2];
            this.green[index2] = tmp;
            tmp = this.blue[index1];
            this.blue[index1] = this.blue[index2];
            this.blue[index2] = tmp;
        }
    }
}

