/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.GpOperation;
import de.exitgames.neutron.client.HttpSender;
import de.exitgames.neutron.client.NeutronGame;
import de.exitgames.neutron.client.NeutronListener;
import de.exitgames.neutron.client.NeutronSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Neutron {
    private final String footprint = "{Footprint.Client.Neutron}";
    public static byte m7_status = (byte)-1;
    public static String m7_name = "";
    public static String m7_pass = "";
    public static String m7_clientID;
    private static final int MAX_RETRIES = 3;
    private static final int MS_TO_KILL = 20000;
    static final byte OPC_NULL = 100;
    static final byte OPC_CONFIRM = 101;
    static final byte OPC_BILLTMOBILE = 102;
    static final byte OPC_BILLPSMS = 103;
    static final byte OPC_BILLING_MO_PLUS = 104;
    static final byte OPC_BILLING_SMSIDENT = 105;
    static final byte OPC_PING = 0;
    static final byte OPC_DATETIME = 1;
    static final byte OPC_SETSCORE = 2;
    static final byte OPC_GETSHADOW = 5;
    static final byte OPC_SETSHADOW = 6;
    static final byte OPC_SETSHADOWSEQ = 7;
    static final byte OPC_GETSCORESPOS = 8;
    static final byte OPC_GETSCORESID = 9;
    static final byte OPC_GETSCORESUSER = 10;
    static final byte OPC_GETSCOREPOS = 11;
    static final byte OPC_SENDTXTMSG = 12;
    static final byte OPC_NAME = 14;
    static final byte OPC_GETAS = 15;
    static final byte OPC_GETINV = 16;
    static final byte OPC_DEACTIVATE = 17;
    static final byte OPC_ACTIVATE = 18;
    static final byte OPC_LOGOUT = 20;
    static final byte OPC_RAISEEVENT = 21;
    static final byte OPC_GETEVENTS = 22;
    static final byte OPC_END = 27;
    static final byte OPC_HANDOVERTURN = 28;
    static final byte OPC_SENDDATA = 29;
    static final byte OPC_START = 30;
    static final byte OPC_QUIT = 31;
    static final byte OPC_SUBSCRIBE = 32;
    static final byte OPC_RESUBSCRIBE = 33;
    static final byte OPC_GETPACKAGES = 34;
    static final byte OPC_STATISTICS = 35;
    static final byte OPC_SETSKILL = 36;
    static final byte OPC_GETSKILL = 37;
    static final byte OPC_ABORTMATCHMAKING = 38;
    static final byte OPC_GETSCORES = 40;
    static final byte OPC_SETACTORINFO = 41;
    static final byte OPC_GETEVENTHISTORY = 42;
    static final byte OPC_FORCEAISKILL = 43;
    static final byte OPC_BUDDY_GETLIST = 44;
    static final byte OPC_BUDDY_OP = 45;
    static final byte OPC_LOGINC = 47;
    static final byte OPC_GETPACKAGESC = 48;
    static final byte OPC_RAISE_CHEV_GLOBAL = 51;
    static final byte OPC_RAISE_CHEV_GAME = 52;
    static final byte OPC_SETSCOREMULTI = 53;
    static final byte OPC_RAISE_ACTOR_EV = 54;
    static final byte OPC_GETSTATS_FOR_USER = 58;
    static final byte OPC_RATE_GAME = 59;
    static final byte OPC_REGISTER_LOBBY = 62;
    static final byte OPC_RENAMEUSER = 63;
    static final byte OPC_OPEN_GAME = 65;
    static final byte OPC_AUTOLOGIN = 68;
    static final byte OPC_SETWEBACCESS = 69;
    static final byte OPC_ANONYMOUSLOGIN = 70;
    static final byte OPC_INITPAYMENT = 72;
    static final byte OPC_INVITE = 73;
    static final byte OPC_TELLAFRIEND = 74;
    static final byte OPC_REDIRECT_TEST = 99;
    static final Byte P_ERR;
    static final Byte P_DBG;
    static final Byte P_URL;
    static final Byte P_SID;
    static final Byte P_ASID;
    static final Byte P_MAXAS;
    static final Byte P_MINAS;
    static final Byte P_NAME;
    static final Byte P_ACTORNR;
    static final Byte P_VALUES;
    static final Byte P_ACTORS;
    static final Byte P_SCORE;
    static final Byte P_SCOREID;
    static final Byte P_SERIALNO;
    static final Byte P_SUBSID;
    static final Byte P_NUMINV;
    static final Byte P_NUMAS;
    static final Byte P_NUMRUNAI;
    static final Byte P_NUMOPENAI;
    static final Byte P_NUMFULLAI;
    static final Byte P_NUMENDAI;
    static final Byte P_SHADOW;
    static final Byte P_OFFSET;
    static final Byte P_COMPLETED;
    static final Byte P_SCORETABLE;
    static final Byte P_TOTALBYTES;
    static final Byte P_COUNT;
    static final Byte P_EVENTS;
    static final Byte P_NUMINQUEUE;
    static final Byte P_EVENTID;
    static final Byte P_ACTORSESSIONS;
    static final Byte P_PACKAGEID;
    static final Byte P_POS;
    static final Byte P_COUNTRY;
    static final Byte P_TIMEFRAME;
    static final Byte P_FILTER;
    static final Byte P_SCORES;
    static final Byte P_DATA;
    static final Byte P_VERSION;
    static final Byte P_USERNAME;
    static final Byte P_PASSWORD;
    static final Byte P_PACKAGES;
    static final Byte P_APPUSER;
    static final Byte P_APPPW;
    static final Byte P_PARAMS;
    static final Byte P_MSG;
    static final Byte P_UNUSED;
    static final Byte P_AVTIME;
    static final Byte P_NUMBUD;
    static final Byte P_NUMBUDON;
    static final Byte P_STATUS;
    static final Byte P_SKILL;
    static final Byte P_INFO;
    static final Byte P_LEASETIME;
    static final Byte P_CODE;
    static final Byte P_CHANNELS;
    static final Byte P_CHANNEL;
    static final Byte P_SCOREERRORS;
    static final Byte P_CONFIRMURL;
    static final Byte P_HTTPHEADERS;
    static final Byte P_MSISDN;
    static final Byte P_SIPADDRESS;
    static final Byte P_SIPRECEIVE;
    static final Byte P_SMSRECEIVE;
    static final Byte P_PRESENCESTATUS;
    static final Byte P_SUBSCRIBERID;
    static final Byte P_DISPLAYNAME;
    static final Byte P_USERIDS;
    static final Byte P_USERLOBBIES;
    static final Byte P_POOL;
    static final Byte P_PLATFORM_ID;
    static final Byte P_LIBVERSION;
    static final Byte P_GAMEVERSION;
    static final Byte P_HANDSETID;
    static final Byte P_CNS;
    static final Byte P_ASSETSERVER;
    static final Byte P_METAPRICE;
    static final Byte P_PRICEPOINT;
    static final Byte P_ASSET;
    static final Byte P_RESERVE;
    public static final byte POOL_DEFAULT_RANDOM = 0;
    public static final byte POOL_DEFAULT_SKILL = 1;
    public static final byte POOL_DEFAULT_NAMED = 2;
    public static final byte POOL_DEFAULT_PRIVATE = 3;
    static final String P_HOST = "host";
    public static final Byte BUDDY_ADD;
    public static final Byte BUDDY_REMOVE;
    protected static final String URL_NEUTRON_SERVER_DEV = "http://dev.neutron.exitgames.com/work/router/3_1/default.ashx";
    protected static final String URL_NEUTRON_SERVER_TEST = "http://test.neutron.exitgames.com/router/";
    protected static final String URL_NEUTRON_SERVER_RUN = "http://neutron.exitgames.com/router/";
    public static final String URL_NEUTRON = "http://neutron.exitgames.com/router/";
    public static final byte BILLING_NONE = 0;
    public static final byte BILLING_VFDE = 1;
    public static final byte BILLING_TMO = 2;
    public static final byte BILLING_PSMS = 3;
    public static final byte BILLING_DUMMY = 4;
    public static final byte BILLING_S2S = 5;
    public static final byte BILLING = 3;
    public static final byte SERVER_DEV = 0;
    public static final byte SERVER_TEST = 2;
    public static final byte SERVER_RUN = 3;
    public static final byte SERVER = 3;
    public static final String LIB_VERSION = "4.0.1.J2ME";
    public static final boolean DEBUG = false;
    static Vector sendQueue;
    static HttpSender httpSender;
    static NeutronSession activeSession;
    static NeutronListener callbackListener;
    public static int retries;
    static short invocID;
    public static short operationCounter;
    public static long timeWaiting;
    public static short roundtripExecuteTime;
    public static short roundtripTime;
    public static boolean setKeepAlive;
    public static long startTime;
    static boolean working;
    static boolean networkLoss;
    public static int pollingInMenu;
    public static int pollingMatchmaking;
    public static int pollingInGame;
    public static int emptyPollsBeforeIdling;
    public static int maxWaitMultiplier;
    public static int millisecondsToWait;
    public static boolean enableAutoPolling;
    static boolean eventExecution;
    static int waitMultiplier;
    static int emptyPolls;
    static long timeOfNextPoll;
    static boolean waitForAsyncResponse;
    static Hashtable execEvent;
    static int execEventCode;
    static GpOperation evop;
    static Vector eventQueue;
    static Object optionalParam;

    public static boolean isWaiting() {
        return working;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        if (networkLoss) {
            return;
        }
        if (!working) {
            Vector vector = sendQueue;
            synchronized (vector) {
                if (sendQueue.size() > 0) {
                    retries = 0;
                    Neutron.processQueue();
                } else if (enableAutoPolling && timeOfNextPoll < System.currentTimeMillis()) {
                    Neutron.addPollingToQueue();
                }
            }
        } else if (working && Neutron.httpSender.result == -1 && (timeWaiting = System.currentTimeMillis() - startTime) > 20000L) {
            if (++retries < 3) {
                if (Neutron.httpSender.running) {
                    httpSender.setObsolete();
                }
                Neutron.processQueue();
                callbackListener.networkStatusReturn(0, retries);
            } else {
                working = false;
                networkLoss = true;
                if (Neutron.httpSender.running) {
                    httpSender.setObsolete();
                }
                if (Neutron.activeSession.sid == null) {
                    callbackListener.networkStatusReturn(202, retries);
                } else {
                    callbackListener.networkStatusReturn(200, retries);
                }
                return;
            }
        }
    }

    public static void shutDownSender() {
        if (httpSender != null) {
            httpSender.setShutDown();
        }
    }

    public static void shutDownSession(boolean bl) {
        working = false;
        if (httpSender != null) {
            httpSender.setObsolete();
        }
        if (activeSession != null) {
            Neutron.activeSession.sid = null;
        }
        sendQueue.removeAllElements();
        if (bl) {
            eventQueue.removeAllElements();
        }
        networkLoss = false;
    }

    public static int getOperationCount() {
        return 0;
    }

    private static void processQueue() {
        working = true;
        startTime = System.currentTimeMillis();
        if (NeutronSession.chActions.length > 0) {
            ((GpOperation)sendQueue.elementAt(0)).addParameter(P_CHANNELS, NeutronSession.chActions);
            NeutronSession.chActions = new byte[0];
        }
        if (httpSender == null || Neutron.httpSender.obsolete) {
            httpSender = new HttpSender();
        }
        httpSender.send((GpOperation)sendQueue.elementAt(0));
    }

    public static void addPollingToQueue() {
        if (Neutron.activeSession.sid == null) {
            return;
        }
        evop.addParameter(P_ASID, Neutron.activeSession.activeGame == null ? "" : Neutron.activeSession.activeGame.getASID());
        evop.addParameter(P_SID, Neutron.activeSession.sid);
        Neutron.evop._parameters.remove(P_CHANNELS);
        short s = invocID;
        invocID = (short)(s + 1);
        Neutron.evop.invocID = s;
        sendQueue.addElement(evop);
    }

    protected static void processEvents(Vector vector) {
        timeOfNextPoll = System.currentTimeMillis() + (long)(millisecondsToWait * waitMultiplier);
        if (waitForAsyncResponse) {
            timeOfNextPoll = System.currentTimeMillis() + (long)pollingInGame;
        }
        if (emptyPollsBeforeIdling > 0 && enableAutoPolling) {
            if (vector == null || vector.size() == 0) {
                waitMultiplier = ++emptyPolls / emptyPollsBeforeIdling + 1;
                waitMultiplier = Math.min(waitMultiplier, maxWaitMultiplier);
            } else {
                emptyPolls = 0;
                waitMultiplier = 1;
            }
        }
        if (vector != null && vector.size() > 0) {
            if (eventQueue.size() == 0) {
                eventQueue = vector;
            } else {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    eventQueue.addElement(vector.elementAt(i));
                }
                vector.removeAllElements();
                vector = null;
            }
        }
        while (eventExecution && eventQueue.size() > 0) {
            Neutron.executeEvent();
        }
    }

    public static boolean executeEvent() {
        if (eventQueue.size() == 0) {
            return false;
        }
        execEvent = (Hashtable)eventQueue.elementAt(0);
        execEventCode = ((Byte)execEvent.get("Code")).byteValue();
        if (waitForAsyncResponse && execEventCode == 70 || execEventCode == 71) {
            millisecondsToWait = pollingInMenu;
            waitForAsyncResponse = false;
        }
        if (Neutron.activeSession.activeGame != null) {
            Neutron.activeSession.activeGame.eventAction(execEventCode, execEvent);
        }
        callbackListener.eventAction(execEventCode, execEvent);
        if (eventQueue.size() > 0) {
            eventQueue.removeElementAt(0);
        }
        return eventQueue.size() > 0;
    }

    protected static void receiveResponse(GpOperation gpOperation) {
        optionalParam = gpOperation.getRetVal(P_SID);
        if (optionalParam != null) {
            Neutron.activeSession.sid = (byte[])optionalParam;
        }
        if ((optionalParam = gpOperation.getRetVal(P_URL)) != null) {
            if (gpOperation._opType == 6) {
                activeSession.setCustomServerUrl((String)optionalParam);
            } else {
                activeSession.setServerUrl((String)optionalParam);
            }
            gpOperation._url = (String)optionalParam;
        }
        if (gpOperation.returnCode == 129) {
            gpOperation.invocID = invocID = (short)(invocID + 1);
            gpOperation._returnValues.clear();
            gpOperation.returnCode = 0;
            working = false;
            return;
        }
        if (gpOperation.returnCode == 503) {
            callbackListener.networkStatusReturn(503, 0);
        }
        if (gpOperation._opType == 6) {
            callbackListener.customOpReturn(gpOperation.returnCode, gpOperation.opCode, gpOperation._returnValues);
        } else {
            switch (gpOperation.opCode) {
                case 47: 
                case 62: 
                case 68: 
                case 70: {
                    byte by;
                    activeSession.loginReturn(gpOperation);
                    byte by2 = by = gpOperation.getRetVal(P_STATUS) != null ? (Byte)gpOperation.getRetVal(P_STATUS) : (byte)0;
                    if (gpOperation.opCode == 62) {
                        by = 1;
                    }
                    millisecondsToWait = pollingInMenu;
                    if (by == 1) {
                        waitForAsyncResponse = true;
                    }
                    callbackListener.loginReturn(gpOperation.returnCode, by);
                    break;
                }
                case 20: {
                    Neutron.activeSession.activeGame = null;
                    Neutron.activeSession.sid = null;
                    callbackListener.logoutReturn(gpOperation.returnCode);
                    break;
                }
                case 63: {
                    byte by = gpOperation.getRetVal(P_STATUS) != null ? (Byte)gpOperation.getRetVal(P_STATUS) : (byte)0;
                    callbackListener.renameUserReturn(gpOperation.returnCode, by);
                    break;
                }
                case 69: {
                    callbackListener.setWebPasswordReturn(gpOperation.returnCode, (String)gpOperation.getRetVal(P_PASSWORD));
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    callbackListener.getScoresByReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_SCORES));
                    break;
                }
                case 11: {
                    callbackListener.getScorePositionReturn(gpOperation.returnCode, gpOperation.returnCode == 0 ? (Integer)gpOperation.getRetVal(P_POS) : 0);
                    break;
                }
                case 2: 
                case 6: {
                    callbackListener.setScoreReturn(gpOperation.returnCode, (String)gpOperation.getRetVal(P_SCOREID));
                    break;
                }
                case 53: {
                    callbackListener.setScoreReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_SCOREID), (int[])gpOperation.getRetVal(P_SCOREERRORS));
                    break;
                }
                case 5: {
                    callbackListener.getShadowReturn(gpOperation.returnCode, (byte[])gpOperation.getRetVal(P_SHADOW));
                    break;
                }
                case 41: {
                    callbackListener.setActorInfoReturn(gpOperation.returnCode);
                    break;
                }
                case 45: {
                    callbackListener.buddySetReturn(gpOperation.returnCode, (String)gpOperation.getRetVal(P_USERNAME), gpOperation.returnCode == 0 ? (Byte)gpOperation.getRetVal(P_STATUS) : (byte)0, (String)gpOperation.getRetVal(P_USERIDS), (String)gpOperation.getRetVal(P_USERLOBBIES), (String[])gpOperation.getRetVal(P_SCOREERRORS));
                    break;
                }
                case 44: {
                    int[] nArray;
                    byte by = 0;
                    byte by3 = 0;
                    if (gpOperation.returnCode == 0) {
                        by = (Byte)gpOperation.getRetVal(P_NUMBUD);
                        by3 = (Byte)gpOperation.getRetVal(P_NUMBUDON);
                    }
                    if ((nArray = (int[])gpOperation.getRetVal(P_SKILL)) == null) {
                        nArray = new int[by];
                    }
                    callbackListener.buddyGetListReturn(gpOperation.returnCode, by, by3, (String[])gpOperation.getRetVal(P_ACTORS), (byte[])gpOperation.getRetVal(P_STATUS), (String[])gpOperation.getRetVal(P_USERIDS), (String[])gpOperation.getRetVal(P_USERLOBBIES), nArray);
                    break;
                }
                case 36: 
                case 37: {
                    int n = gpOperation.returnCode == 0 ? (Integer)gpOperation.getRetVal(P_SKILL) : 0;
                    callbackListener.skillReturn(gpOperation.returnCode, n);
                    break;
                }
                case 38: {
                    millisecondsToWait = pollingInMenu;
                    callbackListener.abortMatchmakingReturn(gpOperation.returnCode, gpOperation.returnCode == 0 ? (Boolean)gpOperation.getRetVal(P_COMPLETED) : false);
                    break;
                }
                case 65: {
                    byte by = 0;
                    short s = 0;
                    if (gpOperation.returnCode == 0) {
                        s = (Short)gpOperation.getRetVal(P_AVTIME);
                        by = (Byte)gpOperation.getRetVal(P_STATUS);
                        if (by == 0) {
                            Neutron.activeSession.activeGame = new NeutronGame(gpOperation, activeSession);
                        } else {
                            millisecondsToWait = pollingMatchmaking;
                        }
                    }
                    callbackListener.gameCreateReturn(gpOperation.returnCode, by, s, (String[])gpOperation.getRetVal(P_SCOREERRORS));
                    break;
                }
                case 18: {
                    if (gpOperation.returnCode == 0) {
                        Neutron.activeSession.activeGame = new NeutronGame(gpOperation, activeSession);
                    }
                    callbackListener.gameCreateReturn(gpOperation.returnCode, (byte)0, (short)0, (String[])gpOperation.getRetVal(P_SCOREERRORS));
                    break;
                }
                case 17: 
                case 31: {
                    if (gpOperation.returnCode == 0) {
                        Neutron.activeSession.activeGame = null;
                        millisecondsToWait = pollingInMenu;
                    }
                    callbackListener.deactivateQuitReturn(gpOperation.returnCode);
                    break;
                }
                case 30: {
                    if (gpOperation.returnCode == 0) {
                        Neutron.activeSession.activeGame.state = (byte)2;
                    }
                    callbackListener.startEndReturn(gpOperation.returnCode);
                    break;
                }
                case 27: {
                    Neutron.activeSession.activeGame.state = (byte)3;
                    callbackListener.startEndReturn(gpOperation.returnCode);
                    break;
                }
                case 15: 
                case 16: {
                    callbackListener.gamesListReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_ACTORSESSIONS));
                    break;
                }
                case 12: 
                case 21: 
                case 28: 
                case 29: 
                case 51: 
                case 52: {
                    callbackListener.sendGameDataReturn(gpOperation.returnCode);
                    break;
                }
                case 14: {
                    Neutron.activeSession.activeGame.name = (String)gpOperation.getRetVal(P_NAME);
                    callbackListener.sendGameDataReturn(gpOperation.returnCode);
                    break;
                }
                case 42: {
                    optionalParam = gpOperation.getRetVal(P_EVENTS);
                    if (gpOperation.returnCode != 0 || ((Vector)optionalParam).size() < NeutronGame.REPLAY_COUNT) {
                        callbackListener.getEventHistoryReturn(gpOperation.returnCode);
                        break;
                    }
                    short s = invocID;
                    invocID = (short)(s + 1);
                    gpOperation.invocID = s;
                    sendQueue.addElement(gpOperation);
                    break;
                }
                case 22: {
                    if (gpOperation.returnCode != 113 && gpOperation.returnCode != 108) break;
                    callbackListener.sendGameDataReturn(gpOperation.returnCode);
                    break;
                }
                case 73: {
                    callbackListener.gameInviteReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_SCOREERRORS));
                    break;
                }
                case 72: {
                    callbackListener.billingInitReturn(gpOperation.returnCode);
                    break;
                }
                case 48: {
                    callbackListener.getPackagesReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_PACKAGES));
                    break;
                }
                case 103: {
                    callbackListener.sendSMSReturn(gpOperation.returnCode);
                    break;
                }
                case 58: {
                    if (gpOperation.returnCode == 0) {
                        callbackListener.getStatsForUserReturn(gpOperation.returnCode, (String[])gpOperation.getRetVal(P_INFO));
                        break;
                    }
                    callbackListener.getStatsForUserReturn(gpOperation.returnCode, null);
                    break;
                }
                case 59: {
                    callbackListener.rateGameReturn(gpOperation.returnCode);
                    break;
                }
                case 0: {
                    callbackListener.pingReturn(gpOperation.returnCode);
                    break;
                }
                case 54: {
                    callbackListener.sendGameDataReturn(gpOperation.returnCode);
                }
            }
        }
        Neutron.processEvents((Vector)gpOperation.getRetVal(P_EVENTS));
        if (gpOperation._opType != 5) {
            if (sendQueue.size() > 0) {
                sendQueue.removeElementAt(0);
            }
            working = false;
        }
    }

    public static byte[] serializeData(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable<Byte, Hashtable> hashtable2 = new Hashtable<Byte, Hashtable>();
        hashtable2.put(P_DATA, hashtable);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(0);
            dataOutputStream.writeShort(hashtable2.size());
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Byte by = (Byte)enumeration.nextElement();
                dataOutputStream.write(by.byteValue());
                Neutron.serialize(dataOutputStream, hashtable2.get(by), true);
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Hashtable deserializeData(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        try {
            Neutron.deserializeParameters(new ByteArrayInputStream(byArray), hashtable, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable = null;
        }
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.get(P_DATA);
    }

    protected static void setSubscriptionId(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"Neutron.Client.Lib", (boolean)true);
            int n = recordStore.getNumRecords();
            byte[] byArray = string.getBytes();
            if (n > 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected static String getSubscriptionId() {
        String string = "";
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Neutron.Client.Lib", (boolean)true);
            int n = recordStore.getNumRecords();
            if (n > 0) {
                string = new String(recordStore.getRecord(1));
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return string;
    }

    static byte[] serializeParameters(Hashtable hashtable, boolean bl, byte by, short s) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (!bl) {
                ((OutputStream)dataOutputStream).write(GpOperation.headerBytes);
                dataOutputStream.writeShort(roundtripTime);
                dataOutputStream.write(4);
                dataOutputStream.writeShort(s);
                dataOutputStream.write(255);
            } else {
                ((OutputStream)dataOutputStream).write(GpOperation.tcpHead);
            }
            dataOutputStream.write(by);
            if (bl) {
                dataOutputStream.write(0);
            }
            dataOutputStream.writeShort(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Byte by2 = (Byte)enumeration.nextElement();
                dataOutputStream.write(by2.byteValue());
                Neutron.serialize(dataOutputStream, hashtable.get(by2), true);
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static void serialize(DataOutputStream dataOutputStream, Object object, boolean bl) throws IOException {
        if (object instanceof String) {
            if (bl) {
                dataOutputStream.writeByte(115);
            }
            dataOutputStream.writeUTF((String)object);
        } else if (object instanceof String[]) {
            if (bl) {
                dataOutputStream.writeByte(97);
            }
            dataOutputStream.writeShort(((String[])object).length);
            for (int i = 0; i < ((String[])object).length; ++i) {
                dataOutputStream.writeUTF(((String[])object)[i]);
            }
        } else if (object instanceof byte[]) {
            if (bl) {
                dataOutputStream.writeByte(120);
            }
            dataOutputStream.writeInt(((byte[])object).length);
            dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
        } else if (object instanceof int[]) {
            if (bl) {
                dataOutputStream.writeByte(110);
            }
            dataOutputStream.writeInt(((int[])object).length);
            for (int i = 0; i < ((int[])object).length; ++i) {
                dataOutputStream.writeInt(((int[])object)[i]);
            }
        } else if (object instanceof Hashtable) {
            Neutron.serializeHashTable(dataOutputStream, (Hashtable)object, bl);
        } else if (object instanceof Vector) {
            Neutron.serializeVector(dataOutputStream, (Vector)object, bl);
        } else if (object instanceof Boolean) {
            if (bl) {
                dataOutputStream.writeByte(111);
            }
            dataOutputStream.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            if (bl) {
                dataOutputStream.writeByte(98);
            }
            dataOutputStream.writeByte(((Byte)object).byteValue());
        } else if (object instanceof Short) {
            if (bl) {
                dataOutputStream.writeByte(107);
            }
            dataOutputStream.writeShort(((Short)object).shortValue());
        } else if (object instanceof Integer) {
            if (bl) {
                dataOutputStream.writeByte(105);
            }
            dataOutputStream.writeInt((Integer)object);
        } else if (object instanceof Long) {
            if (bl) {
                dataOutputStream.writeByte(108);
            }
            dataOutputStream.writeLong((Long)object);
        } else {
            throw new IllegalStateException("cannot serialize(): " + object.getClass());
        }
    }

    static void serializeHashTable(DataOutputStream dataOutputStream, Hashtable hashtable, boolean bl) throws IOException {
        if (bl) {
            dataOutputStream.writeByte(104);
        }
        dataOutputStream.writeShort(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Neutron.serialize(dataOutputStream, k, true);
            Neutron.serialize(dataOutputStream, hashtable.get(k), true);
        }
    }

    static void serializeVector(DataOutputStream dataOutputStream, Vector vector, boolean bl) throws IOException {
        if (bl) {
            dataOutputStream.writeByte(118);
        }
        dataOutputStream.writeShort(vector.size());
        boolean bl2 = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Neutron.serialize(dataOutputStream, enumeration.nextElement(), bl2);
            bl2 = false;
        }
    }

    static void deserializeParameters(InputStream inputStream, Hashtable hashtable, boolean bl) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        boolean bl2 = bl ? dataInputStream.readBoolean() : false;
        if (!bl2) {
            int n = dataInputStream.readShort();
            for (int i = 0; i < n; ++i) {
                byte by = dataInputStream.readByte();
                Object object = Neutron.deserialize(dataInputStream, (char)dataInputStream.readByte());
                if (object == null) continue;
                hashtable.put(new Byte(by), object);
            }
        }
        dataInputStream.close();
        dataInputStream = null;
    }

    static Object deserialize(DataInputStream dataInputStream, char c2) throws IOException {
        switch (c2) {
            case 'i': {
                return new Integer(dataInputStream.readInt());
            }
            case 's': {
                return dataInputStream.readUTF();
            }
            case 'a': {
                int n = dataInputStream.readShort();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                return stringArray;
            }
            case 'v': {
                return Neutron.deserializeVector(dataInputStream);
            }
            case 'x': {
                int n = dataInputStream.readInt();
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                return byArray;
            }
            case 'n': {
                int n = dataInputStream.readInt();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = dataInputStream.readInt();
                }
                return nArray;
            }
            case 'h': {
                return Neutron.deserializeHashTable(dataInputStream);
            }
            case 'o': {
                return new Boolean(dataInputStream.readBoolean());
            }
            case 'k': {
                return new Short(dataInputStream.readShort());
            }
            case 'l': {
                return new Long(dataInputStream.readLong());
            }
            case 'b': {
                return new Byte(dataInputStream.readByte());
            }
        }
        throw new IllegalStateException("deserialize(): " + c2);
    }

    static Hashtable deserializeHashTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = Neutron.deserialize(dataInputStream, (char)dataInputStream.readByte());
            Object object2 = Neutron.deserialize(dataInputStream, (char)dataInputStream.readByte());
            hashtable.put(object, object2);
        }
        return hashtable;
    }

    static Vector deserializeVector(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        Vector<Object> vector = new Vector<Object>(n);
        if (n > 0) {
            char c2 = (char)dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                vector.addElement(Neutron.deserialize(dataInputStream, c2));
            }
        }
        return vector;
    }

    static {
        P_ERR = new Byte(0);
        P_DBG = new Byte(1);
        P_URL = new Byte(2);
        P_SID = new Byte(3);
        P_ASID = new Byte(4);
        P_MAXAS = new Byte(5);
        P_MINAS = new Byte(6);
        P_NAME = new Byte(8);
        P_ACTORNR = new Byte(9);
        P_VALUES = new Byte(10);
        P_ACTORS = new Byte(11);
        P_SCORE = new Byte(12);
        P_SCOREID = new Byte(13);
        P_SERIALNO = new Byte(16);
        P_SUBSID = new Byte(17);
        P_NUMINV = new Byte(18);
        P_NUMAS = new Byte(19);
        P_NUMRUNAI = new Byte(20);
        P_NUMOPENAI = new Byte(21);
        P_NUMFULLAI = new Byte(22);
        P_NUMENDAI = new Byte(23);
        P_SHADOW = new Byte(24);
        P_OFFSET = new Byte(25);
        P_COMPLETED = new Byte(26);
        P_SCORETABLE = new Byte(27);
        P_TOTALBYTES = new Byte(28);
        P_COUNT = new Byte(29);
        P_EVENTS = new Byte(30);
        P_NUMINQUEUE = new Byte(31);
        P_EVENTID = new Byte(32);
        P_ACTORSESSIONS = new Byte(33);
        P_PACKAGEID = new Byte(34);
        P_POS = new Byte(35);
        P_COUNTRY = new Byte(38);
        P_TIMEFRAME = new Byte(39);
        P_FILTER = new Byte(40);
        P_SCORES = new Byte(41);
        P_DATA = new Byte(42);
        P_VERSION = new Byte(43);
        P_USERNAME = new Byte(44);
        P_PASSWORD = new Byte(45);
        P_PACKAGES = new Byte(46);
        P_APPUSER = new Byte(47);
        P_APPPW = new Byte(48);
        P_PARAMS = new Byte(49);
        P_MSG = new Byte(51);
        P_UNUSED = new Byte(52);
        P_AVTIME = new Byte(53);
        P_NUMBUD = new Byte(54);
        P_NUMBUDON = new Byte(55);
        P_STATUS = new Byte(56);
        P_SKILL = new Byte(57);
        P_INFO = new Byte(58);
        P_LEASETIME = new Byte(59);
        P_CODE = new Byte(60);
        P_CHANNELS = new Byte(61);
        P_CHANNEL = new Byte(62);
        P_SCOREERRORS = new Byte(63);
        P_CONFIRMURL = new Byte(100);
        P_HTTPHEADERS = new Byte(101);
        P_MSISDN = new Byte(66);
        P_SIPADDRESS = new Byte(67);
        P_SIPRECEIVE = new Byte(68);
        P_SMSRECEIVE = new Byte(69);
        P_PRESENCESTATUS = new Byte(70);
        P_SUBSCRIBERID = new Byte(71);
        P_DISPLAYNAME = new Byte(72);
        P_USERIDS = new Byte(73);
        P_USERLOBBIES = new Byte(74);
        P_POOL = new Byte(75);
        P_PLATFORM_ID = new Byte(79);
        P_LIBVERSION = new Byte(81);
        P_GAMEVERSION = new Byte(82);
        P_HANDSETID = new Byte(83);
        P_CNS = new Byte(84);
        P_ASSETSERVER = new Byte(87);
        P_METAPRICE = new Byte(88);
        P_PRICEPOINT = new Byte(89);
        P_ASSET = new Byte(90);
        P_RESERVE = new Byte(91);
        BUDDY_ADD = new Byte(0);
        BUDDY_REMOVE = new Byte(1);
        sendQueue = new Vector();
        httpSender = null;
        activeSession = null;
        setKeepAlive = true;
        pollingInMenu = 30000;
        pollingMatchmaking = 8000;
        pollingInGame = 4000;
        emptyPollsBeforeIdling = 0;
        maxWaitMultiplier = 3;
        millisecondsToWait = pollingInMenu;
        enableAutoPolling = true;
        eventExecution = true;
        waitMultiplier = 1;
        eventQueue = new Vector();
    }
}

