/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.GpOperation;
import de.exitgames.neutron.client.NCommand;
import de.exitgames.neutron.client.NPeer;
import de.exitgames.neutron.client.Neutron;
import de.exitgames.neutron.client.NeutronListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.UDPDatagramConnection;

public class NConnect
implements Runnable {
    DatagramConnection udpConn;
    Datagram datagramOut;
    Datagram datagramIn;
    Thread currentThread;
    public boolean UDP_DEBUG_OUT = false;
    public String connectIP;
    public String localIP;
    public int localPort;
    public int localMTU;
    boolean obsolete;
    boolean isRunning;
    NeutronListener listener;
    byte[] data = new byte[1];
    boolean waitsForHeader = true;
    int read;
    int waitForBytes;
    int msgType;
    static final byte MSGT_INIT = 0;
    static final byte MSGT_OP = 1;
    static final byte MSGT_EV = 2;
    short invocID;
    short readInvocID;
    public byte[] inBuff;
    int bytesOut;
    int bytesIn;
    int returnCode;
    int udpError;
    Hashtable retVals = new Hashtable();
    NPeer peer;

    public NConnect(NPeer nPeer, String string) {
        if (this.UDP_DEBUG_OUT) {
            Neutron.callbackListener.debugReturn("** new NConnect.");
        }
        this.peer = nPeer;
        this.connectIP = string;
    }

    boolean createConnection() {
        this.obsolete = false;
        try {
            this.udpConn = (DatagramConnection)Connector.open((String)("datagram://" + this.connectIP));
            this.datagramOut = this.udpConn.newDatagram(256);
            this.datagramIn = this.udpConn.newDatagram(this.udpConn.getMaximumLength());
            this.localMTU = this.udpConn.getNominalLength();
            this.localIP = ((UDPDatagramConnection)this.udpConn).getLocalAddress();
            this.localPort = ((UDPDatagramConnection)this.udpConn).getLocalPort();
        }
        catch (Exception exception) {
            if (this.UDP_DEBUG_OUT) {
                Neutron.callbackListener.debugReturn("** createConnection() failed connecting to: " + this.connectIP);
                exception.printStackTrace();
            }
            this.udpConn = null;
            this.obsolete = true;
            this.peer.nl.nPeerReturn((byte)0, 1026, null, (short)0);
            return false;
        }
        return true;
    }

    boolean startConnectionThread() {
        if (this.isRunning) {
            if (this.UDP_DEBUG_OUT) {
                Neutron.callbackListener.debugReturn("startConnectionThread() failed: connection still open.");
            }
            return false;
        }
        this.obsolete = false;
        this.currentThread = new Thread(this);
        this.currentThread.start();
        return true;
    }

    void stopConnectionThread() {
        if (this.UDP_DEBUG_OUT) {
            System.out.println("stopConnectionThread()");
        }
        this.obsolete = true;
        this.currentThread = null;
        if (this.udpConn != null) {
            try {
                this.udpConn.close();
            }
            catch (Exception exception) {
                if (this.UDP_DEBUG_OUT) {
                    Neutron.callbackListener.debugReturn("** UDP stop() caused exception (as expected!!): " + exception.getMessage());
                }
                exception.printStackTrace();
            }
        }
    }

    void sendUdpPackage(byte[] byArray, int n) throws IOException {
        this.datagramOut.reset();
        this.datagramOut.setData(byArray, 0, n);
        this.udpConn.send(this.datagramOut);
        this.bytesOut += n;
    }

    byte[] serialiseOperation(Hashtable hashtable, byte by) {
        this.data = Neutron.serializeParameters(hashtable, true, by, (short)0);
        if (this.data != null) {
            this.data[3] = (byte)(this.data.length - 6 >>> 8);
            this.data[4] = (byte)(this.data.length - 6);
            this.data[1] = (byte)(this.invocID >>> 8);
            this.data[2] = (byte)this.invocID;
            this.invocID = (short)(this.invocID + 1);
        }
        return this.data;
    }

    boolean deserializeNeutron(byte[] byArray) {
        if (byArray.length < 6) {
            if (this.UDP_DEBUG_OUT) {
                System.out.println("** UDP data too short! " + byArray.length);
            }
            return false;
        }
        if (byArray[0] != -2) {
            if (this.UDP_DEBUG_OUT) {
                System.out.println("** No regular Neutron UDP message: " + byArray[0] + ". " + NConnect.datagramToString(this.datagramIn));
            }
            return false;
        }
        this.waitForBytes = 0xFF & byArray[3];
        this.waitForBytes = this.waitForBytes << 8 | 0xFF & byArray[4];
        this.bytesIn += this.waitForBytes + 6;
        this.msgType = byArray[5];
        if (this.msgType == 1) {
            this.readInvocID = (short)(0xFF & byArray[1]);
            this.readInvocID = (short)(this.readInvocID << 8 | 0xFF & byArray[2]);
            if (this.UDP_DEBUG_OUT) {
                Neutron.callbackListener.debugReturn("< read invoc: " + this.readInvocID);
            }
        }
        this.retVals.clear();
        if (this.UDP_DEBUG_OUT) {
            System.out.println("* deserializeNeutron() body: " + this.waitForBytes + " bodyBuff:" + byArray.length + " msgType: " + this.msgType + " (event = 2)");
        }
        try {
            Neutron.deserializeParameters(new ByteArrayInputStream(byArray, 6, byArray.length - 6), this.retVals, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (this.msgType == 1) {
            if (this.UDP_DEBUG_OUT) {
                Neutron.callbackListener.debugReturn("< read op " + this.retVals.toString());
            }
            this.returnCode = (Integer)this.retVals.get(Neutron.P_ERR);
            byte by = (Byte)this.retVals.get(Neutron.P_CODE);
            this.peer.nl.nPeerReturn(by, this.returnCode, this.retVals, this.readInvocID);
        } else if (this.msgType == 2) {
            if (this.UDP_DEBUG_OUT) {
                Neutron.callbackListener.debugReturn("< read ev" + this.retVals.toString());
            }
            this.peer.nl.eventAction(((Byte)this.retVals.get(Neutron.P_CODE)).byteValue(), this.retVals);
        } else if (this.msgType == 0 && this.UDP_DEBUG_OUT) {
            Neutron.callbackListener.debugReturn("< read init");
        }
        return true;
    }

    public void run() {
        block12: {
            block11: {
                if (!this.createConnection()) {
                    this.peer.nNetDisconnected();
                    return;
                }
                this.peer.queueOutgoingReliableCommand(new NCommand(this.peer, 2, null));
                System.out.println("peer OK");
                this.isRunning = true;
                try {
                    if (this.UDP_DEBUG_OUT) {
                        System.out.println("NConnect.run() starts loop. datagram buffer: " + this.datagramIn.getLength());
                    }
                    while (!this.obsolete && this.currentThread == Thread.currentThread()) {
                        this.datagramIn.reset();
                        this.datagramIn.setLength(this.localMTU);
                        this.udpConn.receive(this.datagramIn);
                        if (this.UDP_DEBUG_OUT) {
                            System.out.println("NConnect.run() in-bytes: " + this.datagramIn.getLength());
                        }
                        if (this.datagramIn.getLength() == 0) continue;
                        this.inBuff = this.datagramIn.getData();
                        this.peer.receiveIncomingCommands();
                        Thread.yield();
                    }
                }
                catch (Exception exception) {
                    if (this.obsolete) break block11;
                    if (this.UDP_DEBUG_OUT) {
                        Neutron.callbackListener.debugReturn("** NConnect.run() error '" + exception.toString() + "' " + GpOperation.debugSerCount);
                        exception.printStackTrace();
                    }
                    this.peer.nl.nPeerReturn((byte)0, 1026, null, (short)0);
                    this.udpError = 1;
                }
            }
            try {
                if (this.UDP_DEBUG_OUT) {
                    System.out.println("* closing conns [UDP]");
                }
                if (this.udpConn != null) {
                    this.udpConn.close();
                }
            }
            catch (Exception exception) {
                if (!this.UDP_DEBUG_OUT) break block12;
                exception.printStackTrace();
            }
        }
        this.udpConn = null;
        this.datagramIn = null;
        this.datagramOut = null;
        this.isRunning = false;
        this.obsolete = true;
        this.peer.nNetDisconnected();
        this.peer.nl.debugReturn("bytes out/in: " + this.bytesOut + "/" + this.bytesIn + " total: " + (this.bytesIn + this.bytesOut));
    }

    static String byteArrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + 5);
        stringBuffer.append("(" + byArray.length + ") ");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static String datagramToString(Datagram datagram) {
        String string = datagram.getAddress();
        string = string + " " + datagram.getLength() + "bytes: ";
        byte[] byArray = datagram.getData();
        for (int i = 0; i < datagram.getLength(); ++i) {
            string = string + byArray[i] + " ";
        }
        return string;
    }
}

