/*
 * Decompiled with CFR 0.152.
 */
public class Camera {
    public static int currentX;
    public static int currentY;
    public static int targetX;
    public static int targetY;
    public static int deltaX;
    public static int deltaY;
    public static int boundLeft;
    public static int boundTop;
    public static int boundRight;
    public static int boundBottom;
    public static boolean softPan;
    public static int cameraSpeed;
    public static int cameraTimer;
    public static boolean ignoreBound;

    public static void setSoftPanning(boolean soft) {
        softPan = soft;
    }

    public static void setSoftPanningSpeed(int ms) {
        cameraSpeed = ms;
        if (cameraTimer > cameraSpeed) {
            cameraTimer = cameraSpeed;
        }
    }

    public static void reset() {
        currentX = 0;
        currentY = 0;
        targetX = 0;
        targetY = 0;
        deltaX = 0;
        deltaY = 0;
    }

    public static void setCameraBound(int left, int right, int top, int bottom) {
        boundLeft = left;
        boundTop = top;
        boundRight = right;
        boundBottom = bottom;
        Camera.setCameraTargetXY(targetX, targetY);
    }

    public static void setCameraTargetXY(int x, int y) {
        targetX = x;
        targetY = y;
        Camera.limitTargetXY();
        if (softPan) {
            deltaX = targetX - currentX;
            deltaY = targetY - currentY;
            if (deltaX != 0 || deltaY != 0) {
                cameraTimer = cameraSpeed;
            }
        } else {
            currentX = targetX;
            currentY = targetY;
        }
    }

    public static boolean panCamera(int msElapsed) {
        if (cameraTimer > 0) {
            if ((cameraTimer -= msElapsed) < 0) {
                cameraTimer = 0;
            }
            if (softPan) {
                if (currentX != targetX) {
                    currentX = targetX - cameraTimer * deltaX / cameraSpeed;
                }
                if (currentY != targetY) {
                    currentY = targetY - cameraTimer * deltaY / cameraSpeed;
                }
            }
        }
        return currentX == targetX && currentY == targetY;
    }

    private static void limitTargetXY() {
        if (ignoreBound) {
            return;
        }
        if (targetX > boundRight) {
            targetX = boundRight;
        }
        if (targetX < boundLeft) {
            targetX = boundLeft;
        }
        if (targetY > boundBottom) {
            targetY = boundBottom;
        }
        if (targetY < boundTop) {
            targetY = boundTop;
        }
    }
}

