/*
 * Decompiled with CFR 0.152.
 */
import constants.AiScriptConst;
import constants.Cst;

public class Script
implements AiScriptConst,
Cst {
    private byte[] scriptBytes;
    private int offset;
    public boolean endOfScript;
    public static final int RETVAL_FAIL = -1;
    public static final int RETVAL_NONBLOCKING = 0;
    public static final int RETVAL_BLOCKING = 1;

    public Script() {
    }

    public Script(byte[] b) {
        this.setScript(b);
    }

    public void setScript(byte[] script) {
        this.scriptBytes = new byte[script.length];
        System.arraycopy(script, 0, this.scriptBytes, 0, script.length);
        this.offset = 0;
    }

    public int execute(GameCanvas canvas) {
        boolean nonBlocking = true;
        int commExecuted = 0;
        while (nonBlocking) {
            int comm = 0;
            comm = this.getNextNumber();
            if (comm == Integer.MIN_VALUE) {
                this.endOfScript = true;
                break;
            }
            int arrayLength = 1;
            if (comm == 2) {
                arrayLength += 2;
            } else if (comm == 5) {
                arrayLength += 3;
            } else if (comm == 6) {
                arrayLength += 2;
            } else if (comm == 7) {
                arrayLength += 2;
            } else if (comm == 8) {
                ++arrayLength;
            } else if (comm == 9) {
                arrayLength += 2;
            } else if (comm == 10) {
                ++arrayLength;
            } else if (comm == 11) {
                ++arrayLength;
            } else if (comm == 13) {
                arrayLength += 2;
            } else if (comm == 14) {
                ++arrayLength;
            } else if (comm == 17) {
                ++arrayLength;
            } else if (comm == 18) {
                ++arrayLength;
            } else if (comm == 19) {
                arrayLength += 4;
            } else if (comm == 20) {
                ++arrayLength;
            } else if (comm == 21) {
                ++arrayLength;
            } else if (comm == 24) {
                arrayLength += 5;
            } else if (comm == 26) {
                ++arrayLength;
            } else if (comm == 28) {
                ++arrayLength;
            } else if (comm == 29) {
                arrayLength += 2;
            } else if (comm == 30) {
                arrayLength += 2;
            } else if (comm == 31) {
                arrayLength += 2;
            } else if (comm == 34) {
                arrayLength += 4;
            } else if (comm == 36) {
                arrayLength += 3;
            }
            int[] commParams = new int[arrayLength];
            commParams[0] = comm;
            int i = 1;
            while (i < arrayLength) {
                commParams[i] = this.getNextNumber();
                ++i;
            }
            int retval = this.executeCommand(canvas, commParams);
            if (retval < 0) break;
            nonBlocking = retval == 0;
            ++commExecuted;
        }
        return commExecuted;
    }

    public int getNextNumber() {
        if (this.offset < this.scriptBytes.length - 1) {
            int num = (this.scriptBytes[this.offset] & 0xFF) << 8;
            this.offset += 2;
            return (short)(num |= this.scriptBytes[this.offset + 1] & 0xFF);
        }
        return Integer.MIN_VALUE;
    }

    private int executeCommand(GameCanvas canvas, int[] commands) {
        int comm = commands[0];
        int retval = -1;
        if (comm == 1) {
            canvas.openDialog();
            retval = 1;
        } else if (comm == 3) {
            canvas.closeDialog();
            retval = 1;
        } else if (comm == 2) {
            canvas.setDialogPortraitText(commands[1], commands[2]);
            canvas.initDialogState(2);
            retval = 1;
        } else if (comm == 5) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                canvas.setEnemyPosition(e, commands[2] * Level.tileWidth, commands[3] * Level.tileHeight);
            }
            retval = 0;
        } else if (comm == 6) {
            canvas.setGameObjectPosition(GameCanvas.player, commands[1] * Level.tileWidth, commands[2] * Level.tileHeight);
            retval = 0;
        } else if (comm == 7) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                canvas.setEnemyAnim(e, commands[2]);
                canvas.setEnemyAIState(e, 30);
            }
            retval = 0;
        } else if (comm == 8) {
            int anim = commands[1];
            if (commands[1] == 0 || commands[1] == 1) {
                anim = GameCanvas.playerIdleAnim;
            }
            canvas.setPlayerAnim(anim);
            retval = 0;
        } else if (comm == 9) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                e.setFacingRight(commands[2] == 1);
            }
            retval = 0;
        } else if (comm == 10) {
            GameCanvas.player.setFacingRight(commands[1] == 1);
            retval = 0;
        } else if (comm == 19) {
            canvas.createEnemy(commands[1], commands[2], commands[3] * Level.tileWidth, commands[4] * Level.tileHeight);
            retval = 0;
        } else if (comm == 20) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                canvas.setEnemyAIState(e, 12);
            }
            retval = 0;
        } else if (comm == 11) {
            canvas.setCameraGameMode(false);
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                Camera.setCameraTargetXY(e.getX() - GameCanvas.canvasWidthHalf, e.getY() - GameCanvas.canvasHeightHalf);
            }
            retval = 0;
        } else if (comm == 12) {
            canvas.setCameraGameMode(false);
            Camera.setCameraTargetXY(GameCanvas.player.getX() - GameCanvas.canvasWidthHalf, GameCanvas.player.getY() - GameCanvas.canvasHeightHalf);
            retval = 0;
        } else if (comm == 13) {
            canvas.setCameraGameMode(false);
            Camera.setCameraTargetXY(commands[1] * Level.tileWidth - GameCanvas.canvasWidthHalf, commands[2] * Level.tileHeight - GameCanvas.canvasHeightHalf);
            retval = 0;
        } else if (comm == 14) {
            canvas.setCameraGameMode(true);
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                canvas.setCameraLock(e);
            }
            retval = 0;
        } else if (comm == 15) {
            canvas.setCameraGameMode(true);
            canvas.setCameraLock(GameCanvas.player);
            retval = 0;
        } else if (comm == 16) {
            canvas.setCameraLock(null);
            canvas.setCameraGameMode(true);
            retval = 0;
        } else if (comm == 17) {
            Camera.setSoftPanning(commands[1] == 1);
            retval = 0;
        } else if (comm == 21) {
            canvas.endLevel(commands[1] == 1);
            retval = 1;
        } else if (comm == 22) {
            canvas.openCutscene();
            retval = 1;
        } else if (comm == 23) {
            canvas.closeCutscene();
            retval = 1;
        } else if (comm == 18) {
            canvas.setScriptWaitTimer(commands[1]);
            retval = 1;
        } else if (comm == 24) {
            canvas.createSacPit(commands[1] * Level.tileWidth, commands[3] * Level.tileWidth, commands[2] * Level.tileHeight, commands[4] * Level.tileHeight, commands[5]);
            retval = 0;
        } else if (comm == 25) {
            canvas.removeSacPit();
            retval = 0;
        } else if (comm == 26) {
            canvas.toggleDoor(commands[1]);
            retval = 0;
        } else if (comm == 29) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                canvas.setEnemyHealth(e, commands[2]);
            }
            retval = 0;
        } else if (comm == 30) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                e.respawnCount = (byte)commands[2];
            }
            retval = 0;
        } else if (comm == 31) {
            GameObject e = canvas.getEnemy(commands[1]);
            if (e != null) {
                e.respawnTimer = (short)commands[2];
            }
            retval = 0;
        } else if (comm == 28) {
            canvas.playSound(commands[1] - 1);
            retval = 0;
        } else if (comm == 27) {
            canvas.stopSound();
            GameCanvas.soundStopped = true;
            retval = 0;
        } else if (comm == 33) {
            canvas.closeScreen();
            retval = 1;
        } else if (comm == 32) {
            canvas.openScreen();
            retval = 1;
        } else if (comm == 34) {
            canvas.enableFlash(commands[1], commands[2] << 16 | commands[3] << 8 | commands[3]);
            retval = 0;
        } else if (comm == 35) {
            GameCanvas.sacPitShowCounter = false;
            retval = 0;
        } else if (comm == 36) {
            canvas.addNavArrow(commands[1], commands[2] * Level.tileWidth, commands[3] * Level.tileHeight);
            retval = 0;
        } else if (comm == 37) {
            canvas.removeNavArrow(0);
            retval = 0;
        }
        return retval;
    }
}

