/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import jg.JgCanvas;
import jg.content;

public class TextWrapper {
    private JgCanvas canvas;
    private int leading;
    private int startLine;
    private String text;
    private short[] offsets;
    private char[] lineDelimiters;
    private int maxLineWidth;
    private int fontHeight;
    private int textOffsetY;

    public TextWrapper(JgCanvas canvas) {
        this.canvas = canvas;
        this.leading = 0;
        this.fontHeight = 0;
        this.startLine = 0;
        this.maxLineWidth = 0;
        this.textOffsetY = 0;
        this.lineDelimiters = new char[]{' ', '@', '-', '_'};
    }

    public void paint(Graphics g, int x, int y, int height, int anchor) {
        int yLowerBound = y + height - this.textOffsetY;
        int currentX = x;
        int currentY = y;
        int[] clip = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
        g.setClip(x, y, this.maxLineWidth, height);
        int lineIterator = this.startLine << 1;
        int lines = this.offsets.length;
        int textX = currentX;
        if ((anchor & 1) > 0) {
            textX = currentX + (this.maxLineWidth >> 1);
        } else if ((anchor & 8) > 0) {
            textX = currentX + this.maxLineWidth;
        }
        while (lineIterator < lines && currentY <= yLowerBound) {
            short charOffset = this.offsets[lineIterator];
            short length = this.offsets[lineIterator + 1];
            if (length > 0) {
                String substr = this.text.charAt(charOffset + length - 1) == '\r' ? this.text.substring(charOffset, charOffset + length - 1) : this.text.substring(charOffset, charOffset + length);
                this.canvas.fontDrawString(g, substr, textX, currentY + this.textOffsetY, anchor);
            }
            currentY += this.fontHeight + this.leading;
            lineIterator += 2;
        }
        g.setClip(clip[0], clip[1], clip[2], clip[3]);
    }

    public int setTextToWrap(String text, int maxLineWidth) {
        System.out.println("text = " + text);
        this.text = text;
        this.maxLineWidth = maxLineWidth;
        int textLen = text.length();
        this.fontHeight = this.canvas.fontGetHeight();
        short[] result = null;
        int pass = 0;
        while (pass < 2) {
            int lineOffAndLenCount = 0;
            int lineStartPos = 0;
            while (lineStartPos < textLen) {
                int lineWidth = 0;
                int lineEndPos = lineStartPos;
                boolean skipPunctuationChar = false;
                while (lineWidth <= maxLineWidth && lineEndPos < textLen) {
                    char currentChar = text.charAt(lineEndPos);
                    while (lineStartPos == lineEndPos && currentChar == ' ') {
                        ++lineStartPos;
                        currentChar = text.charAt(++lineEndPos);
                    }
                    if (currentChar == '\n') {
                        skipPunctuationChar = true;
                        break;
                    }
                    int charWidth = this.canvas.fontCharWidth(currentChar);
                    if (lineWidth + charWidth > maxLineWidth) break;
                    lineWidth += charWidth;
                    ++lineEndPos;
                }
                if (!skipPunctuationChar && lineEndPos < textLen) {
                    int splitWordPos = -1;
                    int i = 0;
                    while (i < this.lineDelimiters.length) {
                        int tempSplitWordPos = text.lastIndexOf(this.lineDelimiters[i], lineEndPos);
                        splitWordPos = Math.max(tempSplitWordPos, splitWordPos);
                        ++i;
                    }
                    if (splitWordPos != -1 && splitWordPos > lineStartPos && splitWordPos < lineEndPos) {
                        lineEndPos = splitWordPos;
                        if (text.charAt(splitWordPos) == ' ') {
                            skipPunctuationChar = true;
                        } else {
                            ++lineEndPos;
                            skipPunctuationChar = false;
                        }
                    }
                }
                if (result != null) {
                    result[lineOffAndLenCount] = (short)lineStartPos;
                    result[lineOffAndLenCount + 1] = (short)(lineEndPos - lineStartPos);
                }
                lineOffAndLenCount += 2;
                lineStartPos = lineEndPos + (skipPunctuationChar ? 1 : 0);
            }
            if (pass == 0) {
                result = new short[lineOffAndLenCount];
            }
            ++pass;
        }
        this.offsets = result;
        return this.getLineCount();
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public int getLineCount() {
        return this.offsets.length >> 1;
    }

    public int getLineHeight() {
        return this.fontHeight + this.leading;
    }

    public int getWidth() {
        return this.maxLineWidth;
    }

    public char[] getLineDelimiters() {
        return this.lineDelimiters;
    }

    public String getLine(int line) {
        int lineIterator = line << 1;
        short charOffset = this.offsets[lineIterator];
        short length = this.offsets[lineIterator + 1];
        if (length > 0) {
            String substr = this.text.charAt(charOffset + length - 1) == '\r' ? this.text.substring(charOffset, charOffset + length - 1) : this.text.substring(charOffset, charOffset + length);
            return substr;
        }
        return "";
    }

    public void setLineDelimiters(char[] lineDelimiters) {
        this.lineDelimiters = lineDelimiters;
    }

    public void smoothScrollVertical(int pixels) {
        Object var2_2 = null;
        if (content._a1()) {
            return;
        }
        this.textOffsetY += pixels;
    }

    public void resetVerticalPosition() {
        this.startLine = 0;
        this.textOffsetY = 0;
    }
}

