/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FadingImage {
    private Image fadingImage;
    private int[] fadingRGB;
    private Graphics fadingGraphics;
    private boolean needLoop;
    private int lowAlpha;
    private int highAlpha;
    private int nowAlpha;
    private int incAlpha;

    private void createFadingImage(String string, boolean bl, int n, int n2, int n3, int n4) {
        Image image = null;
        try {
            image = Tools.createImage(string);
        }
        catch (Exception exception) {
            System.out.println("Can't create rawImage");
        }
        this.fadingRGB = new int[image.getWidth() * image.getHeight()];
        image.getRGB(this.fadingRGB, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        this.fadingImage = Image.createImage((int)image.getWidth(), (int)image.getHeight());
        this.fadingGraphics = this.fadingImage.getGraphics();
        image = null;
        System.gc();
        this.needLoop = bl;
        this.lowAlpha = n;
        this.highAlpha = n2;
        this.nowAlpha = n3;
        this.incAlpha = n4;
    }

    public FadingImage(String string, boolean bl) {
        this.createFadingImage(string, bl, 0, 255, 0, 20);
    }

    public FadingImage(String string, boolean bl, int n) {
        if (n > 0) {
            this.createFadingImage(string, bl, 0, 255, 0, n);
        } else {
            this.createFadingImage(string, bl, 0, 255, 255, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fading() {
        this.nowAlpha += this.incAlpha;
        if (this.nowAlpha >= this.highAlpha) {
            this.nowAlpha = this.highAlpha;
            if (!this.needLoop) return;
            this.incAlpha = -1 * this.incAlpha;
        } else if (this.nowAlpha <= this.lowAlpha) {
            this.nowAlpha = this.lowAlpha;
            if (!this.needLoop) return;
            this.incAlpha = -1 * this.incAlpha;
        }
        this.blend(this.nowAlpha);
        this.fadingGraphics.setColor(0xFFFFFF);
        this.fadingGraphics.fillRect(0, 0, this.fadingImage.getWidth(), this.fadingImage.getHeight());
        this.fadingGraphics.drawRGB(this.fadingRGB, 0, this.fadingImage.getWidth(), 0, 0, this.fadingImage.getWidth(), this.fadingImage.getHeight(), true);
    }

    public void draw(Graphics graphics) {
        graphics.drawImage(this.fadingImage, 0, 0, 0);
    }

    private void blend(int n, int n2, int n3) {
        int n4 = this.fadingRGB.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = 0;
            int n6 = this.fadingRGB[i] & 0xFFFFFF;
            if (n2 == n6) {
                n5 = 0;
            } else if (n3 == n6) {
                n5 = 255;
            } else if (n > 0) {
                n5 = n;
            }
            this.fadingRGB[i] = n6 += (n5 <<= 24);
        }
    }

    private void blend(int n) {
        this.blend(n, -1, -1);
    }
}

