/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicIdentix
extends GameLogic {
    private static final byte FIGURE_MAX_SIZE = 24;
    private static final int LIFE_MAX = 1;
    private static final byte FIGURE_COUNT = 3;
    private static final int[][] POSITION = new int[][]{{10, 0, 11, 1}, {13, 3, 14, 4}, {16, 6, 17, 7}};
    private static final byte SCORE_INC = 10;
    private static final byte SCORE_UP = 100;
    private int[] iArrFigureSize = new int[6];
    private int iPlayerStartingPos;
    private int iPlayerPos;
    private int iFigurePos;
    private boolean bIsMoving = false;
    private boolean figureIsHot = false;

    public GameLogicIdentix() {
        super(24, 1);
    }

    protected void load() throws Exception {
        super.load();
        this.iArrFigureSize = GUtillIo.readIntArray();
        this.iPlayerStartingPos = GUtillIo.readInt();
        this.iPlayerPos = GUtillIo.readInt();
        this.iFigurePos = GUtillIo.readInt();
        this.bIsMoving = GUtillIo.readBoolean();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeIntArray(this.iArrFigureSize);
        GUtillIo.writeInt(this.iPlayerStartingPos);
        GUtillIo.writeInt(this.iPlayerPos);
        GUtillIo.writeInt(this.iFigurePos);
        GUtillIo.writeBoolean(this.bIsMoving);
    }

    public void updateLevel(int level) {
        this.iPlayerStartingPos = (18 - level) * 10;
        GUtillArray.fill(this.figure_pos, -1);
        this.placePlayer();
    }

    protected void placePlayer() {
        int i;
        for (i = this.iPlayerStartingPos + 30; i < this.iPlayerStartingPos + 40; ++i) {
            GameField.setBrickType(i, 1);
        }
        for (i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        this.iFigurePos = 0;
        this.iPlayerPos = this.iPlayerStartingPos;
        for (i = 0; i < 6; ++i) {
            this.iArrFigureSize[i] = GUtillMath.rnd(4) + 1;
        }
        this.updatePlayer();
        this.updateFigure();
    }

    private final void updatePlayer() {
        GameFieldItem item = new GameFieldItem();
        for (int i = 0; i < 3; ++i) {
            for (int j = i * 4; j < i * 4 + 4; ++j) {
                this.figure_pos[j] = this.iPlayerPos + POSITION[i][j - i * 4 < this.iArrFigureSize[i] ? j - i * 4 : this.iArrFigureSize[i] - 1];
                item.setData(this.figure_elem[j]);
                item.setIsHotBrick(this.figureIsHot);
                this.figure_elem[j] = item.data();
            }
        }
    }

    private final void updateFigure() {
        if (!this.active) {
            return;
        }
        for (int i = 3; i < 6; ++i) {
            for (int j = i * 4; j < i * 4 + 4; ++j) {
                this.figure_pos[j] = this.iFigurePos + POSITION[i - 3][j - i * 4 < this.iArrFigureSize[i] ? j - i * 4 : this.iArrFigureSize[i] - 1];
            }
        }
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            this.iFigurePos += 10;
            this.updateFigure();
            if (this.iFigurePos == this.iPlayerStartingPos) {
                this.lifeDecr();
            }
        }
    }

    private void incSize(int i) {
        this.iArrFigureSize[i] = this.iArrFigureSize[i] < 4 ? this.iArrFigureSize[i] + 1 : 1;
    }

    public void keyClicked(int key) {
        if (!this.active && key == 7) {
            this.active = true;
            EGame.resetUpdateState();
        } else if (this.active && this.canUpdate() && !this.bIsMoving) {
            if (key == 6) {
                E.kStates[6] = false;
                this.incSize(0);
                this.updatePlayer();
            }
            if (key == 7) {
                E.kStates[7] = false;
                this.incSize(1);
                this.updatePlayer();
            }
            if (key == 8) {
                E.kStates[8] = false;
                this.incSize(2);
                this.updatePlayer();
            }
            if (key == 4) {
                E.kStates[4] = false;
                this.bIsMoving = true;
                this.figureIsHot = true;
                this.iPlayerPos -= 10;
                this.updatePlayer();
            }
        }
    }

    public boolean updateEvent() {
        if (!this.active) {
            return false;
        }
        if (this.canUpdate() && this.bIsMoving) {
            if (this.iFigurePos >= this.iPlayerPos) {
                boolean result = true;
                for (int i = 0; i < 3; ++i) {
                    if (this.iArrFigureSize[i] == this.iArrFigureSize[i + 3]) continue;
                    result = false;
                    break;
                }
                if (result) {
                    this.score += 10;
                    this.CurrentScore += 10;
                    this.placePlayer();
                    if (this.CurrentScore == 100) {
                        this.CurrentScore = 0;
                        this.gameup = true;
                    }
                }
                this.bIsMoving = false;
                this.figureIsHot = false;
                this.iPlayerPos = this.iPlayerStartingPos;
                this.updatePlayer();
            }
            if (this.bIsMoving) {
                this.iPlayerPos -= 10;
                this.updatePlayer();
            }
        }
        return false;
    }
}

