/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.Gamelet;
import com.iplay.game.PlatformRequestHandler;
import com.iplay.game.interfaces.FontInterface;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class BaseCanvas
extends PlatformRequestHandler {
    private int lifeTickCount;
    private long startFrameTime;
    private static final int FPS_METRIC = 0;
    private static final int CURRENT_MEMORY_METRIC = 1;
    private static final int TOTAL_MEMORY_METRIC = 2;
    private char[][] internalMetrics;
    private int triggeredCheatIndex = -1;
    private int maxCheatLength = 0;
    private StringBuffer cheatAccumulator;
    private Vector cheats = new Vector();
    private static final int FPS_CHEAT_INDEX = 0;
    private static final int MEM_CHEAT_INDEX = 1;
    private static final int KEY_CHEAT_INDEX = 2;
    private static final int METRICS_COUNT = 3;
    private static final int MAX_CONSOLE_LENGTH = 200;
    private String consoleDebug;
    private byte[] consoleLock;
    private boolean consoleEnabled;
    private FontInterface debugFont;
    public static final int SECOND = 1000;

    public BaseCanvas() {
        this.internalMetrics = new char[3][];
        this.initInputHandler();
        this.initTouchHandler();
        this.addCheat("#7377");
        this.addCheat("#2006");
        this.setRunning(true);
    }

    public abstract int getFrameTime();

    public final void addCheat(String cheatCode) {
        this.cheats.addElement(cheatCode);
        this.maxCheatLength = Math.max(cheatCode.length(), this.maxCheatLength);
    }

    public abstract void triggerCheat(String var1);

    final void checkCheatCode(int keyCode) {
        if (keyCode == 35) {
            this.cheatAccumulator = new StringBuffer();
        }
        if (this.cheatAccumulator != null) {
            if (this.cheatAccumulator.length() < this.maxCheatLength && keyCode >= 48 && keyCode <= 57 || keyCode == 42 || keyCode == 35) {
                this.cheatAccumulator.append((char)keyCode);
                int cheatIndex = this.cheats.indexOf(this.cheatAccumulator.toString());
                if (cheatIndex != -1) {
                    this.cheatAccumulator = null;
                    this.triggeredCheatIndex = cheatIndex;
                }
            } else {
                this.cheatAccumulator = null;
            }
        }
    }

    public final synchronized void paint(Graphics g) {
        this.render(g);
        if (this.internalMetrics[0] != null || this.internalMetrics[2] != null && this.debugFont != null) {
            g.setClip(0, 0, this.screenWidth, this.screenHeight);
            int stringHeight = this.debugFont.getHeight() + 1;
            int i = 0;
            int y = 0;
            while (i < 3) {
                char[] metric = this.internalMetrics[i];
                if (metric != null) {
                    int stringWidth = this.debugFont.charsWidth(metric, 0, metric.length);
                    g.setColor(0xFF00FF);
                    g.fillRect(0, y, stringWidth, stringHeight);
                    g.setColor(0);
                    this.debugFont.drawChars(g, metric, 0, metric.length, 0, y, 20);
                }
                ++i;
                y += stringHeight;
            }
        }
    }

    final void printToConsole(String line) {
        System.out.print(line);
    }

    public abstract void render(Graphics var1);

    public final int getLifeTickCount() {
        return this.lifeTickCount;
    }

    public final void run() {
        this.initInputHandler();
        this.startFrameTime = System.currentTimeMillis();
        long lastFPSTime = System.currentTimeMillis();
        int frameCount = 0;
        while (this.isRunning()) {
            long currentTime;
            if (this.triggeredCheatIndex != -1) {
                if (this.triggeredCheatIndex == 0) {
                    this.internalMetrics[0] = this.internalMetrics[0] == null ? "N/A".toCharArray() : null;
                } else if (this.triggeredCheatIndex == 1) {
                    this.internalMetrics[1] = this.internalMetrics[2] == null ? "N/A".toCharArray() : null;
                    this.internalMetrics[2] = this.internalMetrics[1];
                } else {
                    String triggeredCheat = (String)this.cheats.elementAt(this.triggeredCheatIndex);
                    this.triggerCheat(triggeredCheat);
                }
                this.triggeredCheatIndex = -1;
            }
            this.updateKeyStates();
            this.updateTouchState();
            int frameTime = this.getFrameTime();
            this._update(frameTime);
            this.triggerRepaint();
            ++frameCount;
            ++this.lifeTickCount;
            this.updateInterrupts();
            int sleepTime = 1;
            boolean mustSleep = true;
            while (true) {
                currentTime = System.currentTimeMillis();
                long frameDelta = currentTime - this.startFrameTime;
                sleepTime = (int)((long)frameTime - frameDelta);
                if (mustSleep) {
                    sleepTime = Math.max(1, sleepTime);
                    mustSleep = false;
                }
                if (sleepTime <= 0) break;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception e) {}
            }
            this.startFrameTime = currentTime;
            char[][] metrics = this.internalMetrics;
            if (currentTime - lastFPSTime > 1000L) {
                lastFPSTime = currentTime;
                if (metrics[0] != null) {
                    metrics[0] = Integer.toString(frameCount).toCharArray();
                }
                frameCount = 0;
            }
            if (metrics[2] == null) continue;
            metrics[2] = Integer.toString((int)Runtime.getRuntime().totalMemory()).toCharArray();
            metrics[1] = Integer.toString((int)Runtime.getRuntime().freeMemory()).toCharArray();
        }
        this.destroy();
        if (Gamelet.getGamelet() != null) {
            Gamelet.getGamelet().notifyDestroyed();
        }
    }

    private synchronized void _update(int frametime) {
        this.update(frametime);
    }

    public abstract void update(int var1);

    public final FontInterface getDebugFont() {
        return this.debugFont;
    }

    public final void setDebugFont(FontInterface debugFont) {
        this.debugFont = debugFont;
    }

    public final long getStartFrameTime() {
        return this.startFrameTime;
    }
}

