/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.BaseEffectsHandler;
import com.iplay.game.Gamelet;
import com.iplay.game.IOHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.midlet.MIDlet;

public abstract class EffectsHandler
extends BaseEffectsHandler
implements PlayerListener {
    private static final String MIDICONTROL_CLASS = "javax.microedition.media.control.MIDIControl";
    private static final int MAX_MIDICHANNELS = 16;
    private Player[] mPlayers;
    private int[] mPlayerPriority;
    private boolean[] mPlayersPaused;
    private byte[][] mLoadedSounds;
    private String[] mFormats;
    private int[] mPlayerSoundAssociation;
    private int[] mSoundVolumes;
    private int[] mSoundLoops;
    private long[] mSoundStartPosition;
    private static final int PLAYER_NONE = -1;
    private Object soundLock = null;

    public void initSound(int maxNumSounds, int dummy) {
        int i;
        this.mPlayers = new Player[1];
        this.mPlayerSoundAssociation = new int[1];
        this.mLoadedSounds = new byte[maxNumSounds][];
        this.mFormats = new String[maxNumSounds];
        for (i = 0; i < 1; ++i) {
            this.mPlayerSoundAssociation[i] = -1;
        }
        this.mSoundLoops = new int[maxNumSounds];
        for (i = 0; i < maxNumSounds; ++i) {
            this.mSoundLoops[i] = 1;
        }
        this.mPlayerPriority = new int[this.mPlayers.length];
        this.mPlayersPaused = new boolean[this.mPlayers.length];
        for (i = 0; i < this.mPlayers.length; ++i) {
            this.mPlayersPaused[i] = false;
        }
        this.soundLock = new Object();
    }

    public final boolean isSoundLoaded(int id) {
        return this.mLoadedSounds[id] != null;
    }

    public final boolean loadSound(InputStream is, String format, int id) {
        boolean ret = false;
        if (this.checkValidID(id) && is != null) {
            if (this.isSoundLoaded(id)) {
                ret = false;
            }
            try {
                this.mLoadedSounds[id] = IOHandler.readFullyStream(is);
                ret = this.mLoadedSounds[id] != null;
                this.mFormats[id] = format;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public final boolean loadSound(byte[] soundData, String format, int id) {
        return this.loadSound(new ByteArrayInputStream(soundData), format, id);
    }

    public final boolean loadSound(String soundFile, String format, int id) {
        try {
            return this.loadSound(IOHandler.getResourceAsByteArray(soundFile), format, id);
        }
        catch (Exception e) {
            return false;
        }
    }

    private final void processPlayer(int id, int manip) {
        Player p = this.getPlayer(id);
        if (p != null) {
            this.processPlayer(p, manip);
        }
    }

    private final void processPlayer(Player player, int manip) {
        try {
            if ((manip & 1) > 0) {
                player.prefetch();
            }
            if ((manip & 2) > 0) {
                player.realize();
            }
            if ((manip & 0x10) > 0) {
                player.stop();
            }
            if ((manip & 4) > 0) {
                player.deallocate();
            }
            if ((manip & 8) > 0) {
                player.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final Player createPlayer(InputStream is, String format, int id) {
        Player player;
        try {
            player = Manager.createPlayer((InputStream)is, (String)format);
            this.processPlayer(player, 1);
        }
        catch (Exception e) {
            player = null;
        }
        return player;
    }

    private final void processSoundInterrupt(boolean interrupt) {
        block4: {
            block3: {
                if (!interrupt) break block3;
                if (this.mPlayers == null) break block4;
                for (int i = 0; i < this.mPlayers.length; ++i) {
                    if (this.mPlayerSoundAssociation[i] == -1) continue;
                    this.pauseSound(this.mPlayerSoundAssociation[i]);
                }
                break block4;
            }
            if (this.mPlayers != null) {
                for (int i = 0; i < this.mPlayers.length; ++i) {
                    if (!this.mPlayersPaused[i]) continue;
                    this.playSound(this.mPlayerSoundAssociation[i], this.mPlayerPriority[i]);
                    this.mPlayersPaused[i] = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void soundInterrupt() {
        if (this.soundLock != null) {
            Object object = this.soundLock;
            synchronized (object) {
                this.processSoundInterrupt(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void soundRestored() {
        if (this.soundLock != null) {
            Object object = this.soundLock;
            synchronized (object) {
                this.processSoundInterrupt(false);
            }
        }
    }

    public abstract void loadSounds();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeSound(int id) {
        Object object = this.soundLock;
        synchronized (object) {
            if (this.checkValidID(id)) {
                this.stopSound(id);
                if (this.mLoadedSounds[id] != null) {
                    this.mLoadedSounds[id] = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void playSound(int id, int priority) {
        if (this.isEnabled(1)) {
            Object object = this.soundLock;
            synchronized (object) {
                this.processPlay(id, priority);
            }
        }
    }

    private final Player preparePlayer(int id, int priority) {
        int slot = -1;
        for (int i = 0; i < this.mPlayers.length && slot == -1; ++i) {
            if (this.mPlayers[i] == null) {
                slot = i;
                continue;
            }
            if (this.mPlayers[i].getState() != 400) {
                slot = i;
                continue;
            }
            if (this.mPlayerPriority[i] >= priority) continue;
            slot = i;
        }
        if (slot != -1 && this.mLoadedSounds[id] != null) {
            if (this.mPlayers[slot] != null) {
                this.processStop(slot, true);
            }
            this.mPlayerPriority[slot] = priority;
            this.mPlayerSoundAssociation[slot] = id;
            this.mPlayers[slot] = this.createPlayer(new ByteArrayInputStream(this.mLoadedSounds[id]), this.mFormats[id], id);
            return this.mPlayers[slot];
        }
        return null;
    }

    private final void processPlay(int id, int priority) {
        Player player = null;
        if (this.checkValidID(id) && (player = this.preparePlayer(id, priority)) != null) {
            try {
                this.processPlayer(player, 2);
                player.setLoopCount(this.mSoundLoops[id]);
                player.start();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean checkValidID(int id) {
        return id >= 0;
    }

    private Player getPlayer(int id) {
        Player player = null;
        for (int i = 0; i < this.mPlayers.length && player == null; ++i) {
            if (this.mPlayerSoundAssociation[i] != id) continue;
            player = this.mPlayers[i];
        }
        return player;
    }

    public final void stopSound(int id) {
        this.stopSound(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSound(int id, boolean resetPosition) {
        if (this.checkValidID(id)) {
            Object object = this.soundLock;
            synchronized (object) {
                this.processStop(id, resetPosition);
            }
        }
    }

    private int processFindPlayer(Player player, boolean findSoundID) {
        int ret = -1;
        for (int i = 0; i < this.mPlayers.length && ret == -1; ++i) {
            if (this.mPlayers[i] == null || !this.mPlayers[i].equals(player)) continue;
            ret = findSoundID ? this.mPlayerSoundAssociation[i] : i;
        }
        return ret;
    }

    private void processStop(int id, boolean reset) {
        Player p = this.getPlayer(id);
        if (p != null) {
            int playerid = this.processFindPlayer(p, false);
            if (p.getState() == 400) {
                if (!reset) {
                    this.soundEffect(6, id, p.getMediaTime());
                }
                this.processPlayer(p, 16);
                if (reset) {
                    this.soundEffect(6, id, 0L);
                    this.mPlayersPaused[playerid] = false;
                } else {
                    this.mPlayersPaused[playerid] = true;
                }
            }
        }
    }

    public final void stopAllSounds() {
        if (this.mPlayers != null) {
            for (int i = 0; i < this.mPlayers.length; ++i) {
                this.mPlayersPaused[i] = false;
                if (this.mPlayerSoundAssociation[i] == -1) continue;
                this.stopSound(this.mPlayerSoundAssociation[i], true);
            }
        }
    }

    public final void pauseSound(int id) {
        this.stopSound(id, false);
    }

    private final Player isPlaying(int id) {
        Player player = this.getPlayer(id);
        if (player != null && player.getState() != 400) {
            player = null;
        }
        return player;
    }

    public final long soundEffect(int effect, int id, long value) {
        long ret = -1L;
        if (this.checkValidID(id)) {
            try {
                switch (effect) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        ret = this.mSoundLoops[id];
                        break;
                    }
                    case 8: {
                        long loops = value;
                        if (loops == 0L) {
                            loops = 1L;
                        }
                        this.mSoundLoops[id] = (int)loops;
                        ret = 1L;
                        break;
                    }
                    case 101: {
                        if (this.isPlaying(id) != null) {
                            ret = 1L;
                            break;
                        }
                        ret = 0L;
                        break;
                    }
                    case 1001: {
                        break;
                    }
                    case 1002: {
                        break;
                    }
                    case 1003: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public final void startVibration(int duration) {
        Display.getDisplay((MIDlet)Gamelet.getGamelet()).vibrate(duration);
    }

    public final void stopVibration() {
        Display.getDisplay((MIDlet)Gamelet.getGamelet()).vibrate(0);
    }

    public final void flashLight(long[] flashSequence, boolean loop) {
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == "endOfMedia") {
            int id = this.processFindPlayer(player, true);
            int positionId = this.processFindPlayer(player, false);
        }
    }
}

