/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.RecordStoreHandler;
import com.iplay.game.interfaces.InterruptHandlerInterface;

public abstract class InterruptHandler
extends RecordStoreHandler
implements Runnable,
InterruptHandlerInterface {
    private volatile boolean running;
    private Thread gameThread;
    private byte[] joinLock;
    private byte[] interruptLock = new byte[0];
    private boolean redkeyExited;
    private long interruptStartTime = -1L;
    private static final int RUNNING = 0;
    private static final int PAUSING = 1;
    private static final int PAUSED = 2;
    private static final int QUICK_PAUSED = 3;
    private volatile int gameLoopState = 0;

    protected InterruptHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateInterrupts() {
        byte[] byArray = this.interruptLock;
        synchronized (this.interruptLock) {
            if (this.gameLoopState == 1) {
                this.keyInterrupt();
                this.gameLoopState = 2;
                this.applicationInterrupt();
                try {
                    this.interruptLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.applicationResumed(this.interruptStartTime, System.currentTimeMillis() - this.interruptStartTime);
                this.interruptStartTime = -1L;
                this.soundRestored();
            } else if (this.gameLoopState == 3) {
                this.keyInterrupt();
                this.applicationInterrupt();
                this.applicationResumed(this.interruptStartTime, System.currentTimeMillis() - this.interruptStartTime);
                this.interruptStartTime = -1L;
                this.soundRestored();
                this.gameLoopState = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public long getPendingInterruptStartTime() {
        return this.interruptStartTime;
    }

    public abstract void soundInterrupt();

    public abstract void keyInterrupt();

    public abstract void soundRestored();

    protected abstract long getStartFrameTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        byte[] byArray = this.interruptLock;
        synchronized (this.interruptLock) {
            if (this.gameThread == null && this.running) {
                this.gameLoopState = 0;
                this.gameThread = new Thread(this);
                this.gameThread.start();
            } else {
                this.resume();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        byte[] byArray = this.interruptLock;
        synchronized (this.interruptLock) {
            if (this.gameLoopState == 1) {
                this.gameLoopState = 3;
            } else if (this.gameLoopState != 3) {
                this.gameLoopState = 0;
                this.interruptLock.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        byte[] byArray = this.interruptLock;
        synchronized (this.interruptLock) {
            if (this.interruptStartTime == -1L) {
                this.interruptStartTime = System.currentTimeMillis();
            }
            this.soundInterrupt();
            if (this.running && this.gameLoopState != 2) {
                this.gameLoopState = 1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final void stop() {
        this.stop(false);
    }

    final void stop(boolean redkeyExited) {
        this.redkeyExited = redkeyExited;
        this.running = false;
        this.resume();
        if (Thread.currentThread() != this.gameThread) {
            try {
                this.gameThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void destroy() {
        this.applicationStop(this.redkeyExited);
    }

    public abstract void applicationInterrupt();

    public abstract void applicationResumed(long var1, long var3);

    public abstract void applicationStop(boolean var1);

    public final void showNotify() {
        this.resume();
    }

    abstract void printToConsole(String var1);

    public final void hideNotify() {
        this.pause();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    protected final Thread getGameThread() {
        return this.gameThread;
    }

    public final int getGameLoopState() {
        return this.gameLoopState;
    }

    public abstract /* synthetic */ void run();
}

