/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.image;

import com.iplay.game.math.FixedPoint12;

public class PixelArrayUtils {
    private static final int FIELD_PIXEL_FORMAT = 0;
    private static final int FIELD_WIDTH = 1;
    private static final int FIELD_HEIGHT = 2;
    private static final int ALPHA_SHORT = 61440;
    private static final int RED_SHORT = 3840;
    private static final int GREEN_SHORT = 240;
    private static final int BLUE_SHORT = 15;

    public static int getWidth(short[] sArray) {
        return sArray[1];
    }

    public static final int getHeight(short[] sArray) {
        return sArray[2];
    }

    public static final int getPixelFormat(short[] sArray) {
        return sArray[0];
    }

    public static short[] rescalePixelArray(short[] sArray, short[] sArray2, int n, int n2) {
        short s = sArray2[1];
        short s2 = sArray2[2];
        int n3 = FixedPoint12.toInt(s * n);
        int n4 = FixedPoint12.toInt(s2 * n2);
        int n5 = FixedPoint12.divide(4096, n);
        int n6 = FixedPoint12.divide(4096, n2);
        short[] sArray3 = new short[n3 * n4];
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = FixedPoint12.toInt(j * n5);
                int n9 = FixedPoint12.toInt(i * n6);
                int n10 = n9 * s + n8;
                sArray3[n7] = sArray[n10];
                ++n7;
            }
        }
        sArray2[1] = (short)n3;
        sArray2[2] = (short)n4;
        return sArray3;
    }

    public static short[] resamplePixelArray(short[] sArray, short[] sArray2, int n, int n2) {
        short s = sArray2[0];
        int n3 = 0;
        int n4 = s / 1000;
        int n5 = (s - (n3 += n4 * 1000)) / 100;
        int n6 = (s - (n3 += n5 * 100)) / 10;
        int n7 = s - (n3 += n6 * 10);
        int n8 = (1 << n7) - 1;
        int n9 = n7;
        int n10 = (1 << n6) - 1 << n9;
        int n11 = n9 + n6;
        int n12 = (1 << n5) - 1 << n11;
        int n13 = n11 + n5;
        int n14 = (1 << n4) - 1 << n13;
        short s2 = sArray2[1];
        short s3 = sArray2[2];
        int n15 = FixedPoint12.toInt(s2 * n);
        int n16 = FixedPoint12.toInt(s3 * n2);
        int n17 = FixedPoint12.toFixedPoint(s2);
        int n18 = FixedPoint12.toFixedPoint(s3);
        short[] sArray3 = new short[n15 * n16];
        int n19 = 0;
        for (int i = 0; i < n16; ++i) {
            for (int j = 0; j < n15; ++j) {
                int n20 = j * n17 / n15;
                int n21 = i * n18 / n16;
                int n22 = FixedPoint12.toInt(n20);
                int n23 = FixedPoint12.toInt(n21);
                int n24 = n20 - FixedPoint12.toFixedPoint(n22);
                int n25 = n21 - FixedPoint12.toFixedPoint(n23);
                int n26 = n22 + (n24 == 0 ? 0 : 1);
                int n27 = n23 + (n25 == 0 ? 0 : 1);
                short s4 = sArray[n23 * s2 + n22];
                short s5 = sArray[n23 * s2 + n26];
                short s6 = sArray[n27 * s2 + n22];
                short s7 = sArray[n27 * s2 + n26];
                int n28 = 4096 - n24;
                int n29 = 4096 - n25;
                int n30 = FixedPoint12.toInt(FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s4, n13, n14)), n28), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s5, n13, n14)), n24), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s6, n13, n14)), n28), n25) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s7, n13, n14)), n24), n25));
                int n31 = FixedPoint12.toInt(FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s4, n11, n12)), n28), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s5, n11, n12)), n24), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s6, n11, n12)), n28), n25) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s7, n11, n12)), n24), n25));
                int n32 = FixedPoint12.toInt(FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s4, n9, n10)), n28), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s5, n9, n10)), n24), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s6, n9, n10)), n28), n25) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s7, n9, n10)), n24), n25));
                int n33 = FixedPoint12.toInt(FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s4, 0, n8)), n28), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s5, 0, n8)), n24), n29) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s6, 0, n8)), n28), n25) + FixedPoint12.multiply(FixedPoint12.multiply(FixedPoint12.toFixedPoint(PixelArrayUtils.getSample(s7, 0, n8)), n24), n25));
                sArray3[n19] = (short)(n30 << n13 | n31 << n11 | n32 << n9 | n33 << 0);
                ++n19;
            }
        }
        sArray2[1] = (short)n15;
        sArray2[2] = (short)n16;
        return sArray3;
    }

    private static int getSample(int n, int n2, int n3) {
        int n4 = (n & n3) >>> n2;
        return n4;
    }

    public static short[] modifyPalette(short[] sArray, int n) {
        int n2 = (n & 0xFF0000) / 2;
        int n3 = (n & 0x8000) / 2;
        int n4 = (n & 0xFF) / 2;
        for (int i = 0; i < sArray.length; ++i) {
            int n5 = (sArray[i] & 0xF00) >> 8;
            n5 = n5 * n2 / 127;
            int n6 = (sArray[i] & 0xF0) >> 4;
            n6 = n6 * n3 / 127;
            int n7 = sArray[i] & 0xF;
            n7 = n7 * n4 / 127;
            sArray[i] = (short)((sArray[i] & 0xF000) + ((n5 <<= 8) & 0xF00) + ((n6 <<= 4) & 0xF0) + (n7 & 0xF));
        }
        return sArray;
    }

    public static short[] fadePalette(short[] sArray, int n, int n2) {
        int n3 = FixedPoint12.toInt(n2 * 16);
        int n4 = (n >> 16 & 0xFF) / 16 * n3;
        int n5 = (n >> 8 & 0xFF) / 16 * n3;
        int n6 = (n & 0xFF) / 16 * n3;
        for (int i = 0; i < sArray.length; ++i) {
            int n7 = (sArray[i] & 0xF00) >> 8;
            n7 = (n4 + n7 * (16 - n3)) / 16;
            n7 = (n7 & 0xF) << 8;
            int n8 = (sArray[i] & 0xF0) >> 4;
            n8 = (n5 + n8 * (16 - n3)) / 16;
            n8 = (n8 & 0xF) << 4;
            int n9 = sArray[i] & 0xF;
            n9 = (n6 + n9 * (16 - n3)) / 16;
            sArray[i] = (short)((sArray[i] & 0xF000) + (n7 & 0xF00) + (n8 & 0xF0) + ((n9 &= 0xF) & 0xF));
        }
        return sArray;
    }
}

