/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.jq2009;

import com.iplay.game.jq2009.JQ2009Game;
import com.iplay.game.util.TimerHandler;

public class MatchThreeBoard {
    public static final int MAX_SHAKE_RANGE = 3;
    public static final int MAX_RESTRICTED_TILES_COUNT = 5;
    public static final int MINIMUM_MOVES_ALLOWED = 4;
    public static final int MOVE_STRUCTURE_SIZE = 2;
    public static final int PLAYER = 0;
    public static final int NEUTRAL = 1;
    public static final int CPU = 2;
    public static final boolean SUPPORTCPU = true;
    public static final int CHANCE_CONSTANT = 1000;
    public static final int DEFAULT_MIN_ROW_LENGTH = 3;
    public static final int DEFAULT_MEDIUM_ROW_LENGTH = 4;
    public static final int DEFAULT_MAX_ROW_LENGTH = 5;
    public static final int MULTI_MATCH_1_AMOUNT = 6;
    public static final int MULTI_MATCH_2_AMOUNT = 7;
    public static final int MULTI_MATCH_1_REWARD = 500;
    public static final int MULTI_MATCH_2_REWARD = 1000;
    public static final int MULTI_MATCH_3_REWARD = 100;
    public static final int MULTI_MATCH_4_REWARD = 200;
    public static final int DEFAULT_BOARD_WIDTH = 11;
    public static final int DEFAULT_BOARD_HEIGHT = 11;
    public static final int CELL_INDEX_NONE = -1;
    public static final int CELL_ADJ_SIZE = 8;
    public static final int CELL_ADJ_VALID_SWAP_DIRECTIONS = 4;
    public static final int CELL_ADJ_LEFT = 0;
    public static final int CELL_ADJ_RIGHT = 1;
    public static final int CELL_ADJ_UP = 2;
    public static final int CELL_ADJ_DOWN = 3;
    public static final int CELL_ADJ_DIAG_UP_LEFT = 4;
    public static final int CELL_ADJ_DIAG_UP_RIGHT = 5;
    public static final int CELL_ADJ_DIAG_DOWN_RIGHT = 6;
    public static final int CELL_ADJ_DIAG_DOWN_LEFT = 7;
    public static final int CELL_NO_TILE = 7;
    public static final int CELL_INACTIVE = 3;
    public static final int CELL_NOT_BLOCKED = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int CELL_BITSHIFT_TILE_TYPE = 0;
    public static final int CELL_BITSHIFT_HEALTH = 3;
    public static final int CELL_BITSHIFT_BLOCK = 5;
    public static final int CELL_BITSHIFT_IN_ROW_H = 8;
    public static final int CELL_BITSHIFT_IN_ROW_V = 9;
    public static final int CELL_BITSHIFT_VIRGIN = 10;
    public static final int CELL_BITSHIFT_DIRTY = 11;
    public static final int CELL_BITSHIFT_SECTION = 12;
    public static final int CELL_BITSHIFT_REPLACEABLE = 15;
    public static final int CELL_BITSHIFT_BORDER = 16;
    public static final int CELL_BITSHIFT_MARKED = 20;
    public static final int CELL_BITSHIFT_ANIMATED = 21;
    public static final int CELL_BITSHIFT_MULTI_MATCH = 22;
    public static final int CELL_BITSHIFT_GREEN = 23;
    public static final int CELL_BITSHIFT_TUTORIAL = 24;
    public static final int CELL_BITSHIFT_BLUE_SPECIAL_MATCH = 25;
    public static final int CELL_BITSHIFT_SHIFT_ANIM = 26;
    public static final int CELL_BITSHIFT_SHIFT_RESET = 27;
    public static final int CELL_MASK_TILE_TYPE = 7;
    public static final int CELL_MASK_HEALTH = 24;
    public static final int CELL_MASK_BLOCK = 96;
    public static final int CELL_MASK_IN_ROW_H = 256;
    public static final int CELL_MASK_IN_ROW_V = 512;
    public static final int CELL_MASK_VIRGIN = 1024;
    public static final int CELL_MASK_DIRTY = 2048;
    public static final int CELL_MASK_SECTION = 28672;
    public static final int CELL_MASK_BORDER = 983040;
    public static final int CELL_MASK_REPLACEABLE = 32768;
    public static final int CELL_MASK_MARKED = 0x100000;
    public static final int CELL_MASK_ANIMATED = 0x200000;
    public static final int CELL_MASK_MULTI_MATCH = 0x400000;
    public static final int CELL_MASK_GREEN = 0x800000;
    public static final int CELL_MASK_TUTORIAL = 0x1000000;
    public static final int CELL_MASK_BLUE_SPECIAL_MATCH = 0x2000000;
    public static final int CELL_MASK_SHIFT_ANIM = 0x4000000;
    public static final int CELL_MASK_SHIFT_RESET = 0x8000000;
    public static final int SCREEN_COORD_SIZE = 2;
    public static final int COORD_X_OFFSET = 0;
    public static final int COORD_Y_OFFSET = 1;
    public static final int DOWN_STEP = 2;
    public static final int TILE_SPEEDS_COUNT = 3;
    public static final int SWAPPING_CELLS_COUNT = 2;
    public static final int WAS_RANDOM_GENERATED = 128;
    public static final int TILE_TYPE_RED = 0;
    public static final int TILE_TYPE_GREEN = 1;
    public static final int TILE_TYPE_WHITE = 2;
    public static final int TILE_TYPE_PURPLE = 3;
    public static final int TILE_TYPE_BLUE = 4;
    public static final int TILE_TYPE_COIN = 5;
    public static final int BLOCKED_ONCE = 1;
    public static final int BLOCKED_TWICE = 2;
    public static final int SCORE_SIMPLE_JEWEL = 5;
    public static final int SCORE_TILE_MARKED = 45;
    public static final int COMBO_PROCESSED_NUM = 2;
    public static final int NO_SPECIAL = -1;
    public static final int DESTROY_RANDOM_TIME = 150;
    public static final int MOVES_IT_CAN_CHECK = 0;
    public static final int OTHER_TERITORY_WEIGHTING = 1;
    public static final int TERITORY_WEIGHTING = 2;
    public static final int CPU_DIFFICULTY = 3;
    public static final int GAME_MODE = 4;
    public static final int TILE_WEIGHTING = 5;
    public static final int MOVE_LEFT = 1;
    public static final int MOVE_UP = 2;
    public static final int MOVE_RIGHT = 4;
    public static final int MOVE_DOWN = 8;
    public short[] weightings;
    private int m_boardWidth = 11;
    private int m_boardHeight = 11;
    private int m_boardSections = 1;
    private int m_boardCellArraySize;
    private int m_boardAdjacencyArraySize;
    private short[] m_tileOffsets;
    private boolean m_offsetsAllZero;
    public int[] m_boardCells;
    private int[] m_evaluationCells;
    private byte[] m_boardCellAdjacency;
    private short[] tileFrequency;
    private boolean evaluationMode;
    private int cpuScoring;
    public boolean m_swapInProgress;
    private byte[] m_swappingCells = new byte[2];
    private byte temSwaping;
    protected int aiMode;
    private JQ2009Game game;
    private int evaluationCpuJewels;
    private int winnerTile;
    private int winnerTile2;
    private int winnerTile3;
    private boolean existSuspendedCells;
    private int currentStep;
    private int[] shockWaveRect;
    private int shockWaveOffset;
    private boolean anyAnimatedCells;
    private int specialMatchType;
    private boolean shiftAnimStarted;
    private byte[] tileSpeeds;
    private int restrictedTileTypeCount;
    private int tempRestrictedTileTypeCount;

    public MatchThreeBoard() {
        this.initBoard();
    }

    public MatchThreeBoard(JQ2009Game jQ2009Game, int n, int n2) {
        this.game = jQ2009Game;
        this.m_boardWidth = n;
        this.m_boardHeight = n2;
        this.initBoard();
        this.m_swappingCells[0] = -1;
        this.m_swappingCells[1] = -1;
    }

    public final void setWinnerTile(int n, int n2) {
        if (n == 0) {
            this.winnerTile = n2;
        } else if (n == 1) {
            this.winnerTile2 = n2;
        } else {
            this.winnerTile3 = n2;
        }
    }

    public final int getWinnerTile(int n) {
        if (n == 0) {
            return this.winnerTile;
        }
        return this.winnerTile2;
    }

    public final void initBoard() {
        this.restrictedTileTypeCount = 0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.specialMatchType = -1;
        this.shockWaveRect = new int[4];
        this.existSuspendedCells = false;
        this.m_offsetsAllZero = true;
        this.winnerTile = Math.abs(this.game.getRandom().nextInt()) % (this.game.getJewelsRemap().length - 1);
        this.m_boardCellArraySize = this.m_boardWidth * this.m_boardHeight;
        this.m_boardAdjacencyArraySize = this.m_boardCellArraySize * 8;
        this.m_boardCells = new int[this.m_boardCellArraySize];
        this.m_evaluationCells = new int[this.m_boardCellArraySize];
        this.m_boardCellAdjacency = new byte[this.m_boardAdjacencyArraySize];
        this.m_tileOffsets = new short[this.m_boardCellArraySize * 2];
        this.tileSpeeds = new byte[this.m_boardCellArraySize * 3];
        for (int i = 0; i < this.m_boardHeight; ++i) {
            while (n < this.m_boardWidth) {
                n4 = i * this.m_boardWidth;
                n2 = n + n4;
                n3 = n2 * 8;
                this.m_boardCells[n2] = 0;
                this.setIndexedCellProperty(n2, 7, 0, 7);
                this.setIndexedCellProperty(n2, 0, 3, 24);
                this.setIndexedCellProperty(n2, 1, 11, 2048);
                this.m_boardCellAdjacency[n3 + 0] = (byte)(n2 - 1 < n4 ? -1 : n2 - 1);
                this.m_boardCellAdjacency[n3 + 1] = (byte)(n2 + 1 >= n4 + this.m_boardWidth ? -1 : n2 + 1);
                this.m_boardCellAdjacency[n3 + 2] = (byte)(i - 1 < 0 ? -1 : n2 - this.m_boardWidth);
                this.m_boardCellAdjacency[n3 + 3] = (byte)(i + 1 >= this.m_boardHeight ? -1 : n2 + this.m_boardWidth);
                this.m_boardCellAdjacency[n3 + 4] = (byte)(this.m_boardCellAdjacency[n3 + 0] > -1 && this.m_boardCellAdjacency[n3 + 2] > -1 ? this.m_boardCellAdjacency[n3 + 2] - 1 : -1);
                this.m_boardCellAdjacency[n3 + 5] = (byte)(this.m_boardCellAdjacency[n3 + 1] > -1 && this.m_boardCellAdjacency[n3 + 2] > -1 ? this.m_boardCellAdjacency[n3 + 2] + 1 : -1);
                this.m_boardCellAdjacency[n3 + 7] = (byte)(this.m_boardCellAdjacency[n3 + 0] > -1 && this.m_boardCellAdjacency[n3 + 3] > -1 ? this.m_boardCellAdjacency[n3 + 3] - 1 : -1);
                this.m_boardCellAdjacency[n3 + 6] = (byte)(this.m_boardCellAdjacency[n3 + 1] > -1 && this.m_boardCellAdjacency[n3 + 3] > -1 ? this.m_boardCellAdjacency[n3 + 3] + 1 : -1);
                ++n;
            }
            n = 0;
        }
    }

    public int getAdjacencyStartIndex(int n, int n2) {
        return (n + n2 * this.m_boardWidth) * 8;
    }

    public int getCellIndex(int n, int n2) {
        if (n > -1 && n < this.m_boardWidth && n2 > -1 && n2 < this.m_boardHeight) {
            return n + n2 * this.m_boardWidth;
        }
        return -1;
    }

    public boolean getAdjacentCells(int n, int n2, byte[] byArray) {
        if (n > -1 && n < this.m_boardWidth && n2 > -1 && n2 < this.m_boardHeight) {
            System.arraycopy(this.m_boardCellAdjacency, this.getAdjacencyStartIndex(n, n2), byArray, 0, 8);
            return true;
        }
        return false;
    }

    public boolean isValidSwap(int n, int n2) {
        int n3 = n * 8;
        for (int i = 0; i < 4; ++i) {
            if (this.m_boardCellAdjacency[n3 + i] != n2) continue;
            return true;
        }
        return false;
    }

    public int getCellProperties(int n, int n2) {
        int n3 = this.getCellIndex(n, n2);
        if (n3 > -1) {
            if (this.evaluationMode) {
                return this.m_evaluationCells[n3];
            }
            return this.m_boardCells[n3];
        }
        return -1;
    }

    public final int getIndexedCellProperty(int n, int n2, int n3) {
        if (this.evaluationMode) {
            return this.getCellProperty(this.m_evaluationCells[n], n2, n3);
        }
        return this.getCellProperty(this.m_boardCells[n], n2, n3);
    }

    public final int getCellProperty(int n, int n2, int n3) {
        return (n & n3) >> n2;
    }

    public final int getShiftedValue(int n, int n2, int n3, int n4) {
        n = (n | n3) ^ n3;
        return n |= n4 << n2 & n3;
    }

    public final void setIndexedCellProperty(int n, int n2, int n3, int n4) {
        if (n != -1) {
            if (n3 == 0) {
                if (n2 != 5 && this.getIndexedCellProperty(n, 0, 7) == 5) {
                    --this.restrictedTileTypeCount;
                }
                if (n2 == 5 && this.getIndexedCellProperty(n, 0, 7) != 5) {
                    ++this.restrictedTileTypeCount;
                }
            }
            if (this.evaluationMode) {
                this.m_evaluationCells[n] = (this.m_evaluationCells[n] | n4) ^ n4;
                int n5 = n;
                this.m_evaluationCells[n5] = this.m_evaluationCells[n5] | n2 << n3 & n4;
            } else {
                if (n3 == 21 && n2 == 1) {
                    this.setAnyAnimatedCells(true);
                }
                this.m_boardCells[n] = (this.m_boardCells[n] | n4) ^ n4;
                int n6 = n;
                this.m_boardCells[n6] = this.m_boardCells[n6] | n2 << n3 & n4;
            }
        }
    }

    public boolean isMoving(int n) {
        if (n != -1) {
            return !this.evaluationMode && (this.m_tileOffsets[n << 1] != 0 || this.m_tileOffsets[(n << 1) + 1] != 0);
        }
        return false;
    }

    public boolean getCellOffsets(int n, int n2, short[] sArray) {
        int n3 = this.getCellIndex(n, n2);
        if (n3 != -1) {
            sArray[0] = this.m_tileOffsets[n3 * 2 + 0];
            sArray[1] = this.m_tileOffsets[n3 * 2 + 1];
            return true;
        }
        return false;
    }

    public void setTileOffsets(int n, int n2, int n3, int n4) {
        this.setTileOffsets(n, n2, n3, true, false, n4);
    }

    public void setTileOffsets(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        int n5 = this.game.getTileSize();
        int n6 = n3;
        if (bl) {
            n6 *= n5;
        }
        short s = this.m_tileOffsets[(n << 1) + 0];
        short s2 = this.m_tileOffsets[(n << 1) + 1];
        if (!this.evaluationMode) {
            if (n4 == -1 || n2 != -1) {
                switch (n2) {
                    case 0: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)(-n6);
                        break;
                    }
                    case 1: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)n6;
                        break;
                    }
                    case 2: {
                        this.m_tileOffsets[(n << 1) + 1] = (short)(-n6);
                        break;
                    }
                    case 3: {
                        this.m_tileOffsets[(n << 1) + 1] = (short)n6;
                        break;
                    }
                    case 4: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)(-n6);
                        this.m_tileOffsets[(n << 1) + 1] = (short)(-n6);
                        break;
                    }
                    case 5: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)n6;
                        this.m_tileOffsets[(n << 1) + 1] = (short)(-n6);
                        break;
                    }
                    case 6: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)n6;
                        this.m_tileOffsets[(n << 1) + 1] = (short)n6;
                        break;
                    }
                    case 7: {
                        this.m_tileOffsets[(n << 1) + 0] = (short)(-n6);
                        this.m_tileOffsets[(n << 1) + 1] = (short)n6;
                        break;
                    }
                }
            } else {
                int n7 = (n4 % this.getWidth() - n % this.getHeight()) * n5;
                int n8 = (n4 / this.getWidth() - n / this.getHeight()) * n5;
                this.m_tileOffsets[(n << 1) + 0] = (short)n7;
                this.m_tileOffsets[(n << 1) + 1] = (short)n8;
            }
            this.m_offsetsAllZero = false;
            if (bl2) {
                int n9 = (n << 1) + 0;
                this.m_tileOffsets[n9] = (short)(this.m_tileOffsets[n9] + s);
                int n10 = (n << 1) + 1;
                this.m_tileOffsets[n10] = (short)(this.m_tileOffsets[n10] + s2);
            }
        }
    }

    public void setHintOffsets(int n, int n2, int n3) {
        int n4 = n - n2;
        if (n4 == -1) {
            int n5 = (n << 1) + 0;
            this.m_tileOffsets[n5] = (short)(this.m_tileOffsets[n5] + (short)n3);
            int n6 = (n2 << 1) + 0;
            this.m_tileOffsets[n6] = (short)(this.m_tileOffsets[n6] + (short)(-n3));
            this.setTileSpeedOrStep(n, 2, 0);
            this.setTileSpeedOrStep(n2, 2, 0);
        } else if (n4 == 1) {
            int n7 = (n << 1) + 0;
            this.m_tileOffsets[n7] = (short)(this.m_tileOffsets[n7] + (short)(-n3));
            int n8 = (n2 << 1) + 0;
            this.m_tileOffsets[n8] = (short)(this.m_tileOffsets[n8] + (short)n3);
            this.setTileSpeedOrStep(n, 2, 0);
            this.setTileSpeedOrStep(n2, 2, 0);
        } else if (n4 < -1) {
            int n9 = (n << 1) + 1;
            this.m_tileOffsets[n9] = (short)(this.m_tileOffsets[n9] + (short)n3);
            int n10 = (n2 << 1) + 1;
            this.m_tileOffsets[n10] = (short)(this.m_tileOffsets[n10] + (short)(-n3));
            this.setTileSpeedOrStep(n, 2, 1);
            this.setTileSpeedOrStep(n2, 2, 1);
        } else if (n4 > 1) {
            int n11 = (n << 1) + 1;
            this.m_tileOffsets[n11] = (short)(this.m_tileOffsets[n11] + (short)(-n3));
            int n12 = (n2 << 1) + 1;
            this.m_tileOffsets[n12] = (short)(this.m_tileOffsets[n12] + (short)n3);
            this.setTileSpeedOrStep(n, 2, 1);
            this.setTileSpeedOrStep(n2, 2, 1);
        }
    }

    public void clearTileOffset(int n) {
        this.m_tileOffsets[(n << 1) + 0] = 0;
        this.m_tileOffsets[(n << 1) + 1] = 0;
    }

    public void setBoardShake() {
        for (int i = 0; i < this.m_tileOffsets.length >> 1; ++i) {
            this.m_tileOffsets[(i << 1) + 0] = (short)(this.game.getRandom().nextInt() % 3 - 1);
            this.m_tileOffsets[(i << 1) + 1] = (short)(this.game.getRandom().nextInt() % 3 - 1);
        }
    }

    public int getHintOffset(int n) {
        if (this.m_tileOffsets[(n << 1) + 0] > 0) {
            return this.m_tileOffsets[(n << 1) + 0];
        }
        if (this.m_tileOffsets[(n << 1) + 1] > 0) {
            return this.m_tileOffsets[(n << 1) + 1];
        }
        return 0;
    }

    public boolean setDirtyBits(int n) {
        boolean bl = false;
        int n2 = n << 1;
        if (this.isMoving(n)) {
            this.setIndexedCellProperty(n, 1, 11, 2048);
            bl = true;
        }
        int n3 = n * 8;
        byte by = this.m_boardCellAdjacency[n3 + 2];
        byte by2 = this.m_boardCellAdjacency[n3 + 4];
        byte by3 = this.m_boardCellAdjacency[n3 + 5];
        byte by4 = this.m_boardCellAdjacency[n3 + 0];
        byte by5 = this.m_boardCellAdjacency[n3 + 1];
        byte by6 = this.m_boardCellAdjacency[n3 + 3];
        if (bl) {
            if (this.m_tileOffsets[n2 + 1] < 0) {
                this.setIndexedCellProperty(by, 1, 11, 2048);
                this.game.refreshHudIfIntersected(this.game.getTileX(by), this.game.getTileY(by), this.game.getTileSize(), this.game.getTileSize());
                if (this.m_tileOffsets[n2 + 0] < 0) {
                    this.setIndexedCellProperty(by2, 1, 11, 2048);
                    this.game.refreshHudIfIntersected(this.game.getTileX(by2), this.game.getTileY(by2), this.game.getTileSize(), this.game.getTileSize());
                    this.setIndexedCellProperty(by4, 1, 11, 2048);
                    this.game.refreshHudIfIntersected(this.game.getTileX(by4), this.game.getTileY(by4), this.game.getTileSize(), this.game.getTileSize());
                } else if (this.m_tileOffsets[n2 + 0] > 0) {
                    this.setIndexedCellProperty(by3, 1, 11, 2048);
                    this.game.refreshHudIfIntersected(this.game.getTileX(by3), this.game.getTileY(by3), this.game.getTileSize(), this.game.getTileSize());
                    this.setIndexedCellProperty(by5, 1, 11, 2048);
                    this.game.refreshHudIfIntersected(this.game.getTileX(by5), this.game.getTileY(by5), this.game.getTileSize(), this.game.getTileSize());
                }
            } else if (this.m_tileOffsets[n2 + 1] > 0) {
                this.setIndexedCellProperty(by6, 1, 11, 2048);
                this.game.refreshHudIfIntersected(this.game.getTileX(by6), this.game.getTileY(by6), this.game.getTileSize(), this.game.getTileSize());
            } else if (this.m_tileOffsets[n2 + 0] < 0) {
                this.setIndexedCellProperty(by4, 1, 11, 2048);
                this.game.refreshHudIfIntersected(this.game.getTileX(by4), this.game.getTileY(by4), this.game.getTileSize(), this.game.getTileSize());
            } else if (this.m_tileOffsets[n2 + 0] > 0) {
                this.setIndexedCellProperty(by5, 1, 11, 2048);
                this.game.refreshHudIfIntersected(this.game.getTileX(by5), this.game.getTileY(by5), this.game.getTileSize(), this.game.getTileSize());
            }
        }
        return bl;
    }

    public boolean updateOffsets(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.shockWaveOffset > 0) {
            --this.shockWaveOffset;
        }
        int n6 = n;
        int n7 = n2;
        while (n4 < this.m_tileOffsets.length) {
            n = n6;
            n2 = n7;
            if (this.tileSpeeds[n5 + 0] > 0) {
                n = this.tileSpeeds[n5 + 0];
            }
            if (this.tileSpeeds[n5 + 1] > 0) {
                n2 = this.tileSpeeds[n5 + 1];
            }
            if (this.setDirtyBits(n4 / 2)) {
                ++n3;
            }
            if (this.m_tileOffsets[n4 + 0] > 0) {
                int n8 = n4 + 0;
                this.m_tileOffsets[n8] = (short)(this.m_tileOffsets[n8] - n);
                if (this.m_tileOffsets[n4 + 0] < 0) {
                    this.m_tileOffsets[n4 + 0] = 0;
                }
            } else if (this.m_tileOffsets[n4 + 0] < 0) {
                int n9 = n4 + 0;
                this.m_tileOffsets[n9] = (short)(this.m_tileOffsets[n9] + n);
                if (this.m_tileOffsets[n4 + 0] > 0) {
                    this.m_tileOffsets[n4 + 0] = 0;
                }
            }
            if (this.m_tileOffsets[n4 + 1] < 0) {
                if (this.getIndexedCellProperty(n4 / 2, 10, 1024) == 1 && this.m_tileOffsets[n4 + 1] < -10 && this.tileSpeeds[n5 + 1] == 2) {
                    this.m_tileOffsets[n4 + 1] = -10;
                }
                int n10 = n4 + 1;
                this.m_tileOffsets[n10] = (short)(this.m_tileOffsets[n10] + n2);
                if (this.m_tileOffsets[n4 + 1] > 0) {
                    this.m_tileOffsets[n4 + 1] = 0;
                }
            }
            if (this.m_tileOffsets[n4 + 1] > 0) {
                int n11 = n4 + 1;
                this.m_tileOffsets[n11] = (short)(this.m_tileOffsets[n11] - n2);
                if (this.m_tileOffsets[n4 + 1] < 0) {
                    this.m_tileOffsets[n4 + 1] = 0;
                }
            }
            if (this.m_tileOffsets[n4 + 1] == 0) {
                this.tileSpeeds[n5 + 1] = 0;
            }
            if (this.m_tileOffsets[n4 + 0] == 0) {
                this.tileSpeeds[n5 + 0] = 0;
            }
            n4 += 2;
            n5 += 3;
        }
        this.m_offsetsAllZero = n3 == 0;
        return this.m_offsetsAllZero;
    }

    public final int getWidth() {
        return this.m_boardWidth;
    }

    public final int getHeight() {
        return this.m_boardHeight;
    }

    public void deselectCells() {
        if (this.m_swappingCells[1] != -1) {
            this.m_swappingCells[1] = -1;
        }
        if (this.m_swappingCells[0] != -1) {
            this.m_swappingCells[0] = -1;
        }
    }

    public boolean handleCellSelect(int n, int n2) {
        return this.handleCellSelect(this.getCellIndex(n, n2));
    }

    public boolean handleCellSelect(int n) {
        boolean bl = true;
        if (this.m_offsetsAllZero || this.game.hintShown) {
            if (n != -1 && this.getIndexedCellProperty(n, 5, 96) == 0) {
                if (this.m_swappingCells[0] == -1) {
                    if (this.getIndexedCellProperty(n, 0, 7) != 7) {
                        this.m_swappingCells[0] = (byte)n;
                        if (this.m_swappingCells[1] != -1) {
                            this.m_swappingCells[1] = -1;
                        }
                    } else {
                        bl = false;
                        this.deselectCells();
                    }
                } else if (JQ2009Game.affectedByPowerup2) {
                    this.m_swappingCells[1] = (byte)n;
                } else if (this.isValidSwap(this.m_swappingCells[0], n)) {
                    this.m_swappingCells[1] = (byte)n;
                } else {
                    this.m_swappingCells[0] = (byte)n;
                }
            } else {
                bl = false;
                this.deselectCells();
            }
        }
        return bl;
    }

    public int getCellAdjacencyIndex(int n, int n2) {
        if (n != -1 && n2 != -1) {
            for (int i = 0; i < 8; ++i) {
                if (this.m_boardCellAdjacency[n * 8 + i] != n2) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean doSwap(boolean bl) {
        boolean bl2 = false;
        if (this.m_swappingCells[0] != -1 && this.m_swappingCells[1] != -1) {
            int n = this.getIndexedCellProperty(this.m_swappingCells[0], 0, 7);
            if (!(this.m_swapInProgress || this.isMoving(this.m_swappingCells[0]) || this.isMoving(this.m_swappingCells[1]))) {
                this.setIndexedCellProperty(this.m_swappingCells[0], this.getIndexedCellProperty(this.m_swappingCells[1], 0, 7), 0, 7);
                this.setIndexedCellProperty(this.m_swappingCells[1], n, 0, 7);
                this.setIndexedCellProperty(this.m_swappingCells[0], this.getIndexedCellProperty(this.m_swappingCells[1], 11, 2048), 11, 2048);
                this.setIndexedCellProperty(this.m_swappingCells[1], n, 0, 7);
                this.setTileOffsets(this.m_swappingCells[0], this.getCellAdjacencyIndex(this.m_swappingCells[0], this.m_swappingCells[1]), 1, this.m_swappingCells[1]);
                this.setTileOffsets(this.m_swappingCells[1], this.getCellAdjacencyIndex(this.m_swappingCells[1], this.m_swappingCells[0]), 1, this.m_swappingCells[0]);
                this.m_swapInProgress = true;
            } else if (this.m_swapInProgress && !this.isMoving(this.m_swappingCells[0]) && !this.isMoving(this.m_swappingCells[1])) {
                boolean bl3 = this.existSuspendedCells = this.getIndexedCellProperty(this.m_swappingCells[0], 0, 7) == 7;
                if (this.findRows(this.m_swappingCells[0], true, bl) | this.findRows(this.m_swappingCells[1], true, bl) || this.existSuspendedCells) {
                    bl2 = true;
                } else if (!JQ2009Game.affectedByPowerup2) {
                    this.setIndexedCellProperty(this.m_swappingCells[0], this.getIndexedCellProperty(this.m_swappingCells[1], 0, 7), 0, 7);
                    this.setIndexedCellProperty(this.m_swappingCells[1], n, 0, 7);
                    this.setTileOffsets(this.m_swappingCells[0], this.getCellAdjacencyIndex(this.m_swappingCells[0], this.m_swappingCells[1]), 1, this.m_swappingCells[1]);
                    this.setTileOffsets(this.m_swappingCells[1], this.getCellAdjacencyIndex(this.m_swappingCells[1], this.m_swappingCells[0]), 1, this.m_swappingCells[0]);
                    if (this.game.isSoundEnabled()) {
                        this.game.playSound(8, 0);
                    }
                } else {
                    bl2 = true;
                    JQ2009Game.affectedByPowerup2 = false;
                }
                this.temSwaping = this.m_swappingCells[0];
                this.m_swappingCells[0] = -1;
                this.m_swappingCells[1] = -1;
                this.m_swapInProgress = false;
            }
        }
        return bl2;
    }

    public boolean isSwapInProgress() {
        return this.m_swapInProgress;
    }

    public boolean destroyTiles(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        int n = this.game.getEndConditionCodes();
        for (int i = 0; i < this.m_boardCellArraySize; ++i) {
            if (this.getIndexedCellProperty(i, 8, 256) != 1 && this.getIndexedCellProperty(i, 9, 512) != 1) continue;
            this.setIndexedCellProperty(i, 0, 8, 256);
            this.setIndexedCellProperty(i, 0, 9, 512);
            int n2 = this.getIndexedCellProperty(i, 5, 96);
            int n3 = this.getIndexedCellProperty(i, 3, 24);
            int n4 = this.getIndexedCellProperty(i, 0, 7);
            if (bl2) {
                if (bl) {
                    if (n2 == 0) {
                        ++JQ2009Game.playerAddJewels;
                        if (bl4) {
                            this.setIndexedCellProperty(i, 1, 21, 0x200000);
                        } else {
                            this.setIndexedCellProperty(i, 7, 0, 7);
                        }
                        if (!this.evaluationMode) {
                            ++this.game.crntLevelJewelsMatched;
                        }
                        if ((n & 0x4007) == 1 && n3 != 3 && bl3) {
                            if (n4 == this.winnerTile) {
                                this.game.setPlayerJewels(0, this.game.getPlayerJewels(0) + 1);
                            } else if (n4 == this.winnerTile2) {
                                this.game.setPlayerJewels(1, this.game.getPlayerJewels(1) + 1);
                            }
                        }
                        if (this.game.getJewelsRemap()[n4] == 5 && n3 != 3) {
                            if (bl3) {
                                this.game.setCoins(this.game.getCoins() + 1);
                            } else {
                                MatchThreeBoard matchThreeBoard = this;
                                JQ2009Game.setCPUStoryCoins(matchThreeBoard.game.getCPUCoins() + 1);
                            }
                        }
                        if (n3 != 3 && bl3 && (n & 0x4007) != 1) {
                            this.setIndexedCellProperty(i, 0, 3, 24);
                            if (this.game.getAnimAt(i) == null) {
                                if (n3 == 1) {
                                    this.game.startTileAnim(i, 0, false);
                                } else if (n3 == 2) {
                                    this.game.startTileAnim(i, 4, false);
                                }
                            }
                        }
                    } else {
                        this.setIndexedCellProperty(i, n2 - 1, 5, 96);
                    }
                } else if (n2 == 0) {
                    ++JQ2009Game.cpuAddJewels;
                    if (bl4) {
                        this.setIndexedCellProperty(i, 1, 21, 0x200000);
                    } else {
                        this.setIndexedCellProperty(i, 7, 0, 7);
                    }
                    if (bl3) {
                        if ((n & 0x4007) == 1 && n3 != 3) {
                            if (this.evaluationMode) {
                                if (n4 == this.winnerTile3) {
                                    ++this.evaluationCpuJewels;
                                }
                            } else if (n4 == this.winnerTile) {
                                this.game.setCpuJewels(0, this.game.getCpuJewels(0) + 1);
                            } else if (n4 == this.winnerTile2) {
                                this.game.setCpuJewels(1, this.game.getCpuJewels(1) + 1);
                            }
                        }
                        if (n3 != 3 && ((n & 0x4007) == 2 && n3 != 0 && n3 != 2 || (n & 0x4007) != 2 && (n & 0x4007) != 1) && n3 != 2) {
                            this.setIndexedCellProperty(i, 2, 3, 24);
                            if (this.game.getAnimAt(i) == null) {
                                if (n3 == 1 && !this.evaluationMode) {
                                    this.game.startTileAnim(i, 1, false);
                                } else if (n3 == 0 && !this.evaluationMode) {
                                    this.game.startTileAnim(i, 2, false);
                                }
                            }
                        }
                    }
                } else {
                    this.setIndexedCellProperty(i, n2 - 1, 5, 96);
                }
            } else if (n2 == 0) {
                int n5 = 0;
                if (bl4) {
                    this.setIndexedCellProperty(i, 1, 21, 0x200000);
                } else {
                    this.setIndexedCellProperty(i, 7, 0, 7);
                }
                if (!this.evaluationMode) {
                    ++this.game.crntLevelJewelsMatched;
                }
                if (this.game.IsJewelsOnePlayer()) {
                    if (bl3 && n3 != 3 && bl3 && n4 == this.winnerTile) {
                        this.game.setPlayerJewels(0, this.game.getPlayerJewels(0) + 1);
                    }
                } else if (n3 > 0 && n3 != 3 && bl3) {
                    this.setIndexedCellProperty(i, n3 - 1, 3, 24);
                    this.game.setMatchScore(this.game.getMatchScore() + 45);
                    n5 += 45;
                    if (this.game.getAnimAt(i) == null) {
                        this.game.startTileAnim(i, 0, false);
                    }
                }
                if (n4 != 7 && this.game.getJewelsRemap()[n4] == 5 && n3 != 3) {
                    if (bl3) {
                        this.game.setCoins(this.game.getCoins() + 1);
                    } else {
                        MatchThreeBoard matchThreeBoard = this;
                        JQ2009Game.setCPUStoryCoins(matchThreeBoard.game.getCPUCoins() + 1);
                    }
                }
                if (n4 != 7 && n3 != 3 && bl3) {
                    this.game.setMatchScore(this.game.getMatchScore() + 5);
                    n5 += 5;
                }
                if (n5 != 0) {
                    this.game.initFloatingText(i, n5, 0);
                }
            } else if (bl3) {
                this.setIndexedCellProperty(i, n2 - 1, 5, 96);
            }
            bl5 = true;
            this.setIndexedCellProperty(i, 1, 11, 2048);
        }
        return bl5;
    }

    private final void processSpecialMatches(int n, int n2, int n3, int n4) {
        int n5 = 1 + n3 + n4;
        int n6 = this.getIndexedCellProperty(n, 0, 7);
        if (n5 >= 4) {
            this.setSpecialMatchType(n6);
            int n7 = 2 + (n5 - 4) % 3;
            byte[] byArray = this.getCellsOfColor(this.getIndexedCellProperty(n, 0, 7));
            if (byArray != null && byArray.length - (n3 + n4 + 1) < n7) {
                n7 = byArray.length - (n3 + n4 + 1);
            }
            this.processCombo(n, n7, n2, n3, n4);
        }
    }

    private final void processCombo(int n, int n2, int n3, int n4, int n5) {
        byte[] byArray = this.generateRandomCellOfColor(n2, n, n3, n4, n5);
        if (byArray != null) {
            int n6 = -1;
            n6 = 3;
            for (int i = 0; i < byArray.length; ++i) {
                int n7 = byArray[i] / this.m_boardWidth;
                int n8 = byArray[i] % this.m_boardWidth;
                this.setRowFlag(n7, n8, n8, 25, 0x2000000, 1, true, n6, false);
                this.setRowFlag(n7, n8, n8, 20, 0x100000, 1, true, n6, false);
            }
            TimerHandler.resetTimer(6);
        }
    }

    private final byte[] generateRandomCellOfColor(int n, int n2, int n3, int n4, int n5) {
        byte[] byArray = this.getCellsOfColor(this.getIndexedCellProperty(n2, 0, 7));
        if (n4 + n5 + 1 == byArray.length) {
            return null;
        }
        if (byArray != null) {
            byte[] byArray2 = new byte[Math.min(byArray.length, n)];
            for (int i = 0; i < byArray2.length; ++i) {
                int n6 = Math.abs(this.game.getRandom().nextInt()) % byArray.length;
                while (this.isMatched(n2, n3, n4, n5, byArray[n6]) || (byArray[n6] & 0x80) != 0) {
                    n6 = Math.abs(this.game.getRandom().nextInt()) % byArray.length;
                }
                byArray2[i] = byArray[n6];
                int n7 = n6;
                byArray[n7] = (byte)(byArray[n7] | 0x80);
            }
            return byArray2;
        }
        return null;
    }

    private final boolean isMatched(int n, int n2, int n3, int n4, int n5) {
        if (n == -1) {
            return false;
        }
        int n6 = 0;
        int n7 = 0;
        if (n2 == 512) {
            n6 = n - this.m_boardWidth * n3;
            n7 = n + this.m_boardWidth * n4;
        } else {
            n6 = n - n3;
            n7 = n + n4;
        }
        for (int i = n6; i <= n7; ++i) {
            if (n5 == i) {
                return true;
            }
            if (n2 != 512) continue;
            i += this.m_boardWidth - 1;
        }
        return false;
    }

    public boolean findRows(int n, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl5 = bl3 = this.getIndexedCellProperty(n, 0, 7) == 5;
        if (this.getIndexedCellProperty(n, 8, 256) == 0 && (n2 = 1 + (n3 = this.findRow(n, 0)) + (n4 = this.findRow(n, 1))) >= 3) {
            n5 += bl2 ? n2 : 0;
            if (bl2 && !bl3) {
                this.processSpecialMatches(n, 256, n3, n4);
            }
            this.setIndexedCellProperty(n, 1, 8, 256);
            this.setInRow(n, 0);
            this.setInRow(n, 1);
            bl4 = true;
        }
        if (this.getIndexedCellProperty(n, 9, 512) == 0 && (n2 = 1 + (n3 = this.findRow(n, 2)) + (n4 = this.findRow(n, 3))) >= 3) {
            n5 += bl2 ? n2 : 0;
            if (bl4) {
                --n5;
            }
            if (bl2 && !bl3) {
                this.processSpecialMatches(n, 512, n3, n4);
            }
            this.setIndexedCellProperty(n, 1, 9, 512);
            this.setInRow(n, 2);
            this.setInRow(n, 3);
            bl4 = true;
        }
        if (n5 == 6) {
            if (!this.game.isTwoPlayerMode()) {
                this.game.setGameScore(this.game.getGameScore() + 500);
            }
            this.game.setMatchMultiSix(true);
        }
        if (n5 == 7) {
            if (!this.game.isTwoPlayerMode()) {
                this.game.setGameScore(this.game.getGameScore() + 1000);
            }
            this.game.setMatchMultiSeven(true);
        }
        if (n5 == 4) {
            if (this.game.player == 0) {
                ++this.game.match4Count;
            }
            ++this.game.crntLevelMatch4;
            if (!this.game.isTwoPlayerMode()) {
                this.game.setGameScore(this.game.getGameScore() + 100);
                this.game.initFloatingText(n, 100, -this.game.getTileSize());
            }
        }
        if (n5 == 5) {
            if (this.game.player == 0) {
                ++this.game.match5Count;
            }
            ++this.game.crntLevelMatch5;
            if (!this.game.isTwoPlayerMode()) {
                this.game.setGameScore(this.game.getGameScore() + 200);
                this.game.initFloatingText(n, 200, -this.game.getTileSize());
            }
        }
        return bl4;
    }

    public int storeMove(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            return n;
        }
        if (n > byArray.length - 2) {
            return n;
        }
        byArray[n++] = (byte)n2;
        byArray[n++] = (byte)n3;
        if (n < byArray.length) {
            byArray[n] = -1;
        }
        return n;
    }

    public boolean anyMovesLeft(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean[] blArray = new boolean[this.m_boardSections];
        int n8 = 0;
        for (n7 = 0; n7 < blArray.length; ++n7) {
            blArray[n7] = false;
        }
        if (byArray != null) {
            byArray[0] = -1;
        }
        n7 = 0;
        for (n6 = this.m_boardHeight - 1; n6 > -1; --n6) {
            while (n7 < this.m_boardWidth) {
                n5 = this.getCellIndex(n7, n6);
                n4 = this.getIndexedCellProperty(n5, 0, 7);
                n3 = this.getIndexedCellProperty(n5, 3, 24);
                if (n4 != 7 && n3 != 3) {
                    byte by;
                    int n9;
                    n2 = n5 * 8;
                    n = this.getIndexedCellProperty(n5, 12, 28672);
                    byte by2 = this.m_boardCellAdjacency[n2 + 2];
                    byte by3 = this.m_boardCellAdjacency[n2 + 3];
                    byte by4 = this.m_boardCellAdjacency[n2 + 0];
                    byte by5 = this.m_boardCellAdjacency[n2 + 1];
                    int n10 = 7;
                    int n11 = 7;
                    int n12 = 7;
                    int n13 = 7;
                    if (by2 != -1) {
                        n10 = this.getIndexedCellProperty(by2, 0, 7);
                    }
                    if (by3 != -1) {
                        n11 = this.getIndexedCellProperty(by3, 0, 7);
                    }
                    if (by4 != -1) {
                        n12 = this.getIndexedCellProperty(by4, 0, 7);
                    }
                    if (by5 != -1) {
                        n13 = this.getIndexedCellProperty(by5, 0, 7);
                    }
                    if (this.getIndexedCellProperty(n5, 5, 96) == 0) {
                        if (n11 == n10 && n11 != 7) {
                            if (n12 == n10 && this.getIndexedCellProperty(by4, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n5, by4);
                            }
                            if (n13 == n10 && this.getIndexedCellProperty(by5, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n5, by5);
                            }
                        }
                        if (n12 == n13 && n12 != 7) {
                            if (n12 == n10 && this.getIndexedCellProperty(by2, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n5, by2);
                            }
                            if (n13 == n11 && this.getIndexedCellProperty(by3, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n5, by3);
                            }
                        }
                    }
                    if (n4 == n10 && n4 != 7) {
                        if (by3 != -1 && n11 != 7 && this.getIndexedCellProperty(by3, 5, 96) == 0) {
                            n9 = this.m_boardCellAdjacency[by3 * 8 + 3];
                            if (n9 != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by3, n9);
                            }
                            if ((n9 = this.m_boardCellAdjacency[by3 * 8 + 0]) != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by3, n9);
                            }
                            if ((n9 = this.m_boardCellAdjacency[by3 * 8 + 1]) != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by3, n9);
                            }
                        }
                        n9 = -1;
                        if (by2 != -1 && n10 != 7) {
                            n9 = this.m_boardCellAdjacency[by2 * 8 + 2];
                        }
                        if (n9 != -1 && this.getIndexedCellProperty(n9, 5, 96) == 0 && this.getIndexedCellProperty(n9, 3, 24) != 3) {
                            by = this.m_boardCellAdjacency[n9 * 8 + 2];
                            if (by != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                            if ((by = this.m_boardCellAdjacency[n9 * 8 + 0]) != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                            if ((by = this.m_boardCellAdjacency[n9 * 8 + 1]) != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                        }
                    }
                    if (n4 == n12 && n4 != 7) {
                        if (by5 != -1 && n13 != 7 && this.getIndexedCellProperty(by5, 5, 96) == 0) {
                            n9 = this.m_boardCellAdjacency[by5 * 8 + 1];
                            if (n9 != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by5, n9);
                            }
                            if ((n9 = this.m_boardCellAdjacency[by5 * 8 + 2]) != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by5, n9);
                            }
                            if ((n9 = this.m_boardCellAdjacency[by5 * 8 + 3]) != -1 && n4 == this.getIndexedCellProperty(n9, 0, 7) && this.getIndexedCellProperty(n9, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, by5, n9);
                            }
                        }
                        n9 = -1;
                        if (by4 != -1 && n12 != 7) {
                            n9 = this.m_boardCellAdjacency[by4 * 8 + 0];
                        }
                        if (n9 != -1 && this.getIndexedCellProperty(n9, 5, 96) == 0 && this.getIndexedCellProperty(n9, 3, 24) != 3) {
                            by = this.m_boardCellAdjacency[n9 * 8 + 0];
                            if (by != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                            if ((by = this.m_boardCellAdjacency[n9 * 8 + 2]) != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                            if ((by = this.m_boardCellAdjacency[n9 * 8 + 3]) != -1 && n4 == this.getIndexedCellProperty(by, 0, 7) && this.getIndexedCellProperty(by, 5, 96) == 0) {
                                blArray[n] = true;
                                n8 = this.storeMove(byArray, n8, n9, by);
                            }
                        }
                    }
                }
                ++n7;
            }
            n7 = 0;
        }
        n5 = 1;
        for (n4 = 0; n4 < blArray.length; ++n4) {
            if (blArray[n4]) continue;
            if (this.areThereEmptyTiles(byArray, 0)) break;
            n7 = 0;
            for (n6 = this.m_boardHeight - 1; n6 > -1; --n6) {
                while (n7 < this.m_boardWidth) {
                    n3 = this.getCellIndex(n7, n6);
                    n2 = -1;
                    if (n3 != -1 && this.getIndexedCellProperty(n3, 3, 24) != 3 && this.getIndexedCellProperty(n3, 0, 7) != 7) {
                        n2 = this.getIndexedCellProperty(n3, 12, 28672);
                    }
                    if (n2 == n4 && (n = this.getIndexedCellProperty(n3, 15, 32768)) != 0) {
                        this.setIndexedCellProperty(n3, 1, 8, 256);
                    }
                    ++n7;
                }
                n7 = 0;
            }
            n5 = 0;
        }
        if (n5 != 0) {
            n4 = n8 >> 1;
            for (n3 = 0; n3 < n8; n3 += 2) {
                n2 = Math.abs(this.game.getRandom().nextInt() % n4) << 1;
                n = byArray[n3];
                byArray[n3] = byArray[n2];
                byArray[n2] = n;
                n = byArray[n3 + 1];
                byArray[n3 + 1] = byArray[n2 + 1];
                byArray[n2 + 1] = n;
            }
        }
        return n5 != 0;
    }

    public boolean findAllRows(boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        for (int i = this.m_boardHeight - 1; i > -1; --i) {
            while (n < this.m_boardWidth) {
                bl3 |= this.findRows(this.getCellIndex(n, i), bl, bl2);
                n += 3;
            }
            if (++n2 >= 3) {
                n2 = 0;
            }
            n = n2;
        }
        return bl3;
    }

    public int findRow(int n, int n2) {
        int n3 = this.getIndexedCellProperty(n, 0, 7);
        int n4 = n * 8;
        int n5 = 0;
        if (n3 != 7) {
            while (this.m_boardCellAdjacency[n4 + n2] != -1 && this.getIndexedCellProperty(this.m_boardCellAdjacency[n4 + n2], 0, 7) == n3) {
                n4 = this.m_boardCellAdjacency[n4 + n2] * 8;
                ++n5;
            }
        }
        return n5;
    }

    public void setInRow(int n, int n2) {
        int n3 = this.getIndexedCellProperty(n, 0, 7);
        int n4 = n * 8;
        while (this.m_boardCellAdjacency[n4 + n2] != -1 && this.getIndexedCellProperty(this.m_boardCellAdjacency[n4 + n2], 0, 7) == n3) {
            if (n2 <= 1) {
                this.setIndexedCellProperty(this.m_boardCellAdjacency[n4 + n2], 1, 8, 256);
            } else if (n2 <= 3) {
                this.setIndexedCellProperty(this.m_boardCellAdjacency[n4 + n2], 1, 9, 512);
            }
            n4 = this.m_boardCellAdjacency[n4 + n2] * 8;
        }
    }

    public boolean fillBoard(boolean bl) {
        boolean bl2 = false;
        int n = this.m_boardWidth >> 1;
        int n2 = n + 1;
        for (int i = this.m_boardHeight - 1; i > -1; --i) {
            n2 = n + 1;
            for (n = this.m_boardWidth >> 1; n > -1; --n) {
                bl2 |= this.fillCell(this.getCellIndex(n, i), bl);
            }
            while (n2 < this.m_boardWidth) {
                bl2 |= this.fillCell(this.getCellIndex(n2, i), bl);
                ++n2;
            }
        }
        return !this.evaluationMode && (!this.m_offsetsAllZero || bl2);
    }

    public boolean fillCell(int n, boolean bl) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 7;
        int n4 = n * 8;
        byte by = this.m_boardCellAdjacency[n4 + 2];
        byte by2 = this.m_boardCellAdjacency[n4 + 3];
        int n5 = this.getIndexedCellProperty(n, 0, 7);
        if (n5 == 7) {
            if (this.getIndexedCellProperty(n, 3, 24) != 3) {
                if (by != -1 && this.getIndexedCellProperty(by, 3, 24) != 3 && this.getIndexedCellProperty(by, 5, 96) == 0) {
                    n3 = this.getIndexedCellProperty(by, 0, 7);
                    if (n3 != 7) {
                        if (!this.isMoving(by)) {
                            this.setIndexedCellProperty(by, 7, 0, 7);
                            this.setIndexedCellProperty(n, n3, 0, 7);
                            this.setTileOffsets(n, 2, 1, -1);
                            bl2 = true;
                        } else {
                            bl3 = true;
                        }
                    }
                } else if (bl && !bl2 && !bl3 && this.getIndexedCellProperty(n, 10, 1024) == 1) {
                    n2 = this.getNextTile();
                    while (this.getIndexedCellProperty(n, 5, 96) != 0 && n2 == 5 || n2 == 5 && this.restrictedTileTypeCount >= 5) {
                        n2 = this.getNextTile();
                    }
                    this.setIndexedCellProperty(n, n2, 0, 7);
                    this.setTileOffsets(n, 2, 1, -1);
                    bl2 = true;
                }
            }
        } else if (!this.evaluationMode && this.isMoving(n) && this.getIndexedCellProperty(n, 26, 0x4000000) == 1) {
            bl4 = true;
        }
        if (!(n5 != 5 || by2 != -1 && this.getIndexedCellProperty(by2, 3, 24) != 3 || this.areThereActiveTilesUnderneath(by2) || this.isMoving(n))) {
            bl2 = true;
            this.setIndexedCellProperty(n, 7, 0, 7);
            if (!this.evaluationMode) {
                this.game.initAnimation(3, this.game.getTileX(n), this.game.getTileY(n), this.game.getMJewelsSpac(), this.game.getJewelsRemap()[5]);
            }
        }
        if (!this.evaluationMode) {
            if (bl2 || bl3 || bl4) {
                this.setIndexedCellProperty(n, 1, 26, 0x4000000);
                this.setTileSpeedOrStep(n, 0, 2);
            } else if (this.getIndexedCellProperty(n, 26, 0x4000000) == 1 && (n2 = (int)this.getTileSpeedOrStep(n, 2)) < 3) {
                this.setTileSpeedOrStep(n, 3, 1);
                this.setTileOffsets(n, 3, 3 * n2, false, false, -1);
                bl2 = true;
                if (n2 + 1 < 3) {
                    this.setTileSpeedOrStep(n, n2 + 1, 2);
                } else {
                    this.setIndexedCellProperty(n, 0, 26, 0x4000000);
                    this.setTileSpeedOrStep(n, 0, 2);
                }
            }
        }
        if (bl2) {
            this.setIndexedCellProperty(n, 1, 11, 2048);
        }
        return bl2 || bl3;
    }

    public void setTileFrequency(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        if (n > byArray.length) {
            n = byArray.length;
        }
        for (n2 = 0; n2 < n; ++n2) {
            n3 += byArray[n2];
        }
        this.tileFrequency = new short[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.tileFrequency[n2] = (short)(byArray[n2] * 1000 / n3);
        }
    }

    public int getNextTile() {
        int n = -1;
        if (n == -1) {
            for (int i = Math.abs(this.game.getRandom().nextInt() % 1000); i > 0 && n < this.tileFrequency.length - 1; i -= this.tileFrequency[++n]) {
            }
            n %= this.tileFrequency.length;
        }
        return n;
    }

    public boolean isCellActive(int n, int n2) {
        int n3;
        int n4 = this.getCellIndex(n, n2);
        return n4 != -1 && (n3 = this.getIndexedCellProperty(n4, 3, 24)) != 3;
    }

    public boolean isCellActive(int n) {
        int n2;
        return n != -1 && (n2 = this.getIndexedCellProperty(n, 3, 24)) != 3;
    }

    public void boardHealth(int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl = nArray3 != null;
        int n = 0;
        for (int i = 0; i < this.m_boardHeight * this.m_boardWidth; ++i) {
            int n2;
            n = this.getIndexedCellProperty(i, 3, 24);
            if (n != 3) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] < 0) {
                        int n3 = n2;
                        nArray2[n3] = nArray2[n3] + n;
                        continue;
                    }
                    if (n != nArray[n2]) continue;
                    int n4 = n2;
                    nArray2[n4] = nArray2[n4] + 1;
                }
            }
            if (!bl) continue;
            this.evaluationMode = !this.evaluationMode;
            n = this.getIndexedCellProperty(i, 3, 24);
            if (n != 3) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] < 0) {
                        int n5 = n2;
                        nArray3[n5] = nArray3[n5] + n;
                        continue;
                    }
                    if (n != nArray[n2]) continue;
                    int n6 = n2;
                    nArray3[n6] = nArray3[n6] + 1;
                }
            }
            this.evaluationMode = !this.evaluationMode;
        }
    }

    public int boardLocked() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_boardHeight; ++i) {
            while (n2 < this.m_boardWidth) {
                int n4;
                int n5 = this.getIndexedCellProperty(n3, 3, 24);
                if (n5 != 3 && (n4 = this.getIndexedCellProperty(n3, 5, 96)) != 0) {
                    n += n4;
                }
                ++n3;
                ++n2;
            }
            n2 = 0;
        }
        return n;
    }

    public boolean loadBoard(short[] sArray, int n, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.m_boardHeight * this.m_boardWidth * n;
        int n6 = 0;
        this.setTileFrequency(byArray, n2);
        for (int i = 0; i < this.m_boardHeight; ++i) {
            while (n3 < this.m_boardWidth) {
                short s = sArray[n4 + n5];
                int n7 = s & 0xF;
                int n8 = s >> 4 & 7;
                int n9 = s >> 7 & 7;
                int n10 = s >> 10 & 3;
                int n11 = s >> 12 & 0xF;
                this.setIndexedCellProperty(n4, n9, 3, 24);
                if (n9 == 3) {
                    this.setIndexedCellProperty(n4, 0, 5, 96);
                    this.setIndexedCellProperty(n4, 7, 0, 7);
                } else {
                    this.setIndexedCellProperty(n4, n10, 5, 96);
                    this.setIndexedCellProperty(n4, n8, 0, 7);
                    int n12 = n11 & 1;
                    if ((n11 >>= 1) > n6) {
                        n6 = n11;
                    }
                    this.setIndexedCellProperty(n4, n11, 12, 28672);
                    this.setIndexedCellProperty(n4, n12, 15, 32768);
                }
                this.setIndexedCellProperty(n4, n7, 16, 983040);
                this.setIndexedCellProperty(n4, 1, 11, 2048);
                ++n4;
                ++n3;
            }
            n3 = 0;
        }
        this.m_boardSections = n6 + 1;
        return true;
    }

    public final void setAI(int n) {
        this.aiMode = n;
        this.weightings = new short[this.game.aiParams[this.aiMode].length];
        System.arraycopy(this.game.aiParams[this.aiMode], 0, this.weightings, 0, this.game.aiParams[this.aiMode].length);
    }

    public void doStats(int n, int n2) {
        int n3 = n * 3;
        int n4 = n2 - 3;
        if (n4 > 2) {
            this.doStats(n, n2 - 3);
            n4 = 0;
        }
        if (this.evaluationMode) {
            this.cpuScoring += this.weightings[n3 + n4 + 5] * n2;
        }
    }

    public void startEvaluation() {
        this.tempRestrictedTileTypeCount = this.restrictedTileTypeCount;
        System.arraycopy(this.m_boardCells, 0, this.m_evaluationCells, 0, this.m_boardCells.length);
        this.evaluationMode = true;
        this.evaluationCpuJewels = 0;
        this.cpuScoring = 0;
    }

    public int stopEvaluation() {
        this.restrictedTileTypeCount = this.tempRestrictedTileTypeCount;
        int n = this.game.getEndConditionCodes();
        if ((n & 0x4007) == 1) {
            this.evaluationMode = false;
            this.cpuScoring = this.evaluationCpuJewels;
        } else {
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            this.boardHealth(new int[]{0, 2}, nArray, nArray2);
            int n2 = nArray[0];
            int n3 = nArray[1];
            this.evaluationMode = false;
            this.cpuScoring = (n3 -= nArray2[1]) - (n2 -= nArray2[0]);
        }
        return this.cpuScoring;
    }

    public int getDifficulty() {
        return this.weightings[3];
    }

    public final boolean generateABoard(boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < this.m_evaluationCells.length; ++i) {
            boolean bl3;
            boolean bl4;
            if (this.getIndexedCellProperty(i, 3, 24) == 3) continue;
            boolean bl5 = bl4 = this.getIndexedCellProperty(i, 0, 7) == 7;
            if ((!bl || !bl4) && bl) continue;
            int n = this.getNextTile();
            int n2 = i * 8;
            byte by = this.m_boardCellAdjacency[n2 + 3];
            boolean bl6 = false;
            if (n == 5 && (by == -1 || this.getIndexedCellProperty(by, 3, 24) == 3)) {
                bl6 = !this.areThereActiveTilesUnderneath(by);
            }
            boolean bl7 = bl3 = this.getCellProperty(this.m_boardCells[i], 5, 96) != 0;
            while (bl3 && n == 5 || n == 5 && (this.restrictedTileTypeCount >= 5 || bl6)) {
                n = this.getNextTile();
            }
            this.setIndexedCellProperty(i, n, 0, 7);
            bl2 = true;
        }
        return bl2;
    }

    public final void generateLevelBoard() {
        int n = 0;
        boolean bl = true;
        byte[] byArray = new byte[512];
        this.startEvaluation();
        while (bl) {
            this.generateABoard(false);
            try {
                this.findAllRows(false, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl2 = this.destroyTiles(true, true, false, false);
            while (bl2) {
                this.generateABoard(true);
                this.findAllRows(false, false);
                bl2 = this.destroyTiles(true, true, false, false);
            }
            this.anyMovesLeft(byArray);
            int n2 = 0;
            while (byArray[n2] != -1) {
                ++n2;
            }
            bl = n2 < 8;
        }
        n = this.restrictedTileTypeCount;
        this.stopEvaluation();
        this.restrictedTileTypeCount = n;
        this.reloadFlags(this.m_boardCells, this.m_evaluationCells, 1120);
        System.arraycopy(this.m_evaluationCells, 0, this.m_boardCells, 0, this.m_evaluationCells.length);
    }

    public boolean existSuspendedCells() {
        return this.existSuspendedCells;
    }

    public void setSuspendedCells(boolean bl) {
        this.existSuspendedCells = bl;
    }

    private final void reloadFlags(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            if ((0x60 & n) == 96) {
                n2 = this.getCellProperty(nArray[i], 5, 96);
                int n3 = i;
                nArray2[n3] = nArray2[n3] & 0xFFFFFF9F;
                int n4 = i;
                nArray2[n4] = nArray2[n4] | this.getShiftedValue(nArray2[i], 5, 96, n2);
            }
            if ((7 & n) == 7) {
                n2 = this.getCellProperty(nArray[i], 0, 7);
                int n5 = i;
                nArray2[n5] = nArray2[n5] & 0xFFFFFFF8;
                int n6 = i;
                nArray2[n6] = nArray2[n6] | this.getShiftedValue(nArray2[i], 0, 7, n2);
            }
            if ((0x7000 & n) == 28672) {
                n2 = this.getCellProperty(nArray[i], 12, 28672);
                int n7 = i;
                nArray2[n7] = nArray2[n7] & 0xFFFF8FFF;
                int n8 = i;
                nArray2[n8] = nArray2[n8] | this.getShiftedValue(nArray2[i], 12, 28672, n2);
            }
            if ((0x8000 & n) == 32768) {
                n2 = this.getCellProperty(nArray[i], 15, 32768);
                int n9 = i;
                nArray2[n9] = nArray2[n9] & 0xFFFF7FFF;
                int n10 = i;
                nArray2[n10] = nArray2[n10] | this.getShiftedValue(nArray2[i], 15, 32768, n2);
            }
            if ((0x18 & n) != 24) continue;
            n2 = this.getCellProperty(nArray[i], 3, 24);
            int n11 = i;
            nArray2[n11] = nArray2[n11] & 0xFFFFFFE7;
            int n12 = i;
            nArray2[n12] = nArray2[n12] | this.getShiftedValue(nArray2[i], 3, 24, n2);
        }
    }

    public final void markCellsAsVirgin() {
        int n = 0;
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || (n & 1 << i % this.m_boardWidth) != 0 || this.areThereActiveTilesAbove(i)) continue;
            this.setIndexedCellProperty(i, 1, 10, 1024);
            n |= 1 << i % this.m_boardWidth;
        }
    }

    public final int getActiveCell(int n, int n2, boolean bl) {
        int n3 = this.m_boardCellAdjacency[n * 8 + n2];
        if (bl) {
            n3 = n;
        }
        while (n3 != -1 && this.getIndexedCellProperty(n3, 3, 24) == 3) {
            n3 = this.m_boardCellAdjacency[n3 * 8 + n2];
        }
        return n3;
    }

    public final void setColorsFlag(int n, int n2, int n3, int n4, boolean bl, int n5, boolean bl2) {
        this.setFlagUponFilter(n2, n3, n4, 0, 7, n, true, bl, n5, bl2);
    }

    public final void markAllColors(int n, boolean bl) {
        if (n == 7) {
            return;
        }
        int n2 = -1;
        if (!this.evaluationMode && !bl) {
            n2 = 3;
        }
        this.setColorsFlag(n, 20, 0x100000, 1, !this.evaluationMode, n2, false);
    }

    public final void setColumnFlag(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2) {
        if (n2 > n3 || n < 0 || n >= this.m_boardWidth) {
            return;
        }
        int n8 = this.getCellIndex(n, n3);
        for (int i = this.getCellIndex(n, n2); i <= n8; i += this.m_boardWidth) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3) continue;
            this.setIndexedCellProperty(i, n6, n4, n5);
            if (bl) {
                this.setIndexedCellProperty(i, 1, 11, 2048);
            }
            if (n7 < 0) continue;
            this.game.startTileAnim(i, n7, bl2);
        }
    }

    public final void setRowFlag(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2) {
        if (n2 > n3 || n < 0 || n >= this.m_boardHeight) {
            return;
        }
        int n8 = this.getCellIndex(n3, n);
        for (int i = this.getCellIndex(n2, n); i <= n8; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3) continue;
            this.setIndexedCellProperty(i, n6, n4, n5);
            if (bl) {
                this.setIndexedCellProperty(i, 1, 11, 2048);
            }
            if (n7 < 0) continue;
            this.game.startTileAnim(i, n7, bl2);
        }
    }

    public final void markRow(int n, int n2, int n3) {
        if (n >= this.m_boardHeight || n < 0) {
            return;
        }
        int n4 = -1;
        if (!this.evaluationMode) {
            n4 = 3;
        }
        this.setRowFlag(n, Math.max(0, n2), Math.min(this.m_boardWidth - 1, n3), 20, 0x100000, 1, !this.evaluationMode, n4, false);
    }

    public final void markColumn(int n, int n2, int n3) {
        if (n >= this.m_boardWidth || n < 0) {
            return;
        }
        int n4 = -1;
        if (!this.evaluationMode) {
            n4 = 3;
        }
        this.setColumnFlag(n, Math.max(0, n2), Math.min(this.m_boardHeight - 1, n3), 20, 0x100000, 1, !this.evaluationMode, n4, false);
    }

    public final void unmarkBoard(int n, boolean bl) {
        this.setFlagUponFilter(20, 0x100000, 0, 20, 0x100000, 1, true, !this.evaluationMode, n, bl);
    }

    public final void prepareAnimFromMarked() {
        this.setFlagUponFilter(21, 0x200000, 1, 20, 0x100000, 1, true, false, -1, false);
    }

    public final boolean destroyAllAnimatedCells(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            int n;
            int n2;
            if (this.getIndexedCellProperty(i, 21, 0x200000) != 1) continue;
            int n3 = this.getIndexedCellProperty(i, 5, 96);
            int n4 = this.getIndexedCellProperty(i, 0, 7);
            this.setIndexedCellProperty(i, 0, 20, 0x100000);
            this.setIndexedCellProperty(i, 0, 21, 0x200000);
            if (!this.evaluationMode) {
                this.setIndexedCellProperty(i, 1, 11, 2048);
            }
            if (n3 != 0) {
                this.setIndexedCellProperty(i, n3 - 1, 5, 96);
                continue;
            }
            bl4 = true;
            this.setIndexedCellProperty(i, 7, 0, 7);
            if (!this.evaluationMode && n4 != 7) {
                this.game.initParticlesOnCell(i, n4);
            }
            if (bl2) {
                n2 = this.game.isCPUsTurn2();
                if (n4 == this.winnerTile) {
                    if (n2 != 0) {
                        this.game.setCpuJewels(0, this.game.getCpuJewels(0) + 1);
                    } else {
                        this.game.setPlayerJewels(0, this.game.getPlayerJewels(0) + 1);
                    }
                } else if (n4 == this.winnerTile2) {
                    if (n2 != 0) {
                        this.game.setCpuJewels(1, this.game.getCpuJewels(1) + 1);
                    } else {
                        this.game.setPlayerJewels(1, this.game.getPlayerJewels(1) + 1);
                    }
                }
            }
            if (!bl) continue;
            n2 = this.getIndexedCellProperty(i, 3, 24);
            boolean bl5 = this.game.isCPUsTurn();
            if (bl5) {
                this.setIndexedCellProperty(i, 2, 3, 24);
            } else {
                this.setIndexedCellProperty(i, 0, 3, 24);
            }
            if (this.evaluationMode || this.game.getAnimAt(i) != null || (n = this.getTileAnim(n2, bl5)) == -1) continue;
            this.game.startTileAnim(i, n, false);
        }
        this.setAnyAnimatedCells(false);
        return bl4;
    }

    private final int getTileAnim(int n, boolean bl) {
        int n2 = -1;
        if (n == 1) {
            n2 = bl ? 1 : 0;
        } else if (n == 0) {
            if (bl) {
                n2 = 2;
            }
        } else if (n == 2 && !bl) {
            n2 = 4;
        }
        return n2;
    }

    public final boolean areThereMarked() {
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || this.getIndexedCellProperty(i, 20, 0x100000) != 1) continue;
            return true;
        }
        return false;
    }

    private final byte[] getCellsOf(int n, int n2, int n3, boolean bl, boolean bl2) {
        byte[] byArray = new byte[this.m_boardCells.length];
        int n4 = 0;
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            int n5 = this.getIndexedCellProperty(i, n, n2);
            if ((n5 != n3 || !bl2) && (n5 == n3 || bl2)) continue;
            if (bl) {
                if (this.getIndexedCellProperty(i, 3, 24) == 3) continue;
                byArray[n4++] = (byte)i;
                continue;
            }
            byArray[n4++] = (byte)i;
        }
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return null;
    }

    public final byte[] getActiveCells() {
        return this.getCellsOf(3, 24, 3, false, false);
    }

    public final byte[] getNonCPUCells() {
        return this.getCellsOf(3, 24, 2, true, false);
    }

    private final byte[] getCellsOfColor(int n) {
        return this.getCellsOf(0, 7, n, true, true);
    }

    public final boolean destroyAnimatedCellsRandomly(int n, boolean bl) {
        return this.destroyCellsOfRandomly(n, 21, 0x200000, bl, true);
    }

    public final boolean destroyCellsOfRandomly(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (TimerHandler.getTimer(6) <= 150L) {
            return false;
        }
        TimerHandler.resetTimer(6);
        int n4 = 0;
        byte[] byArray = this.getCellsOf(n2, n3, 1, true, true);
        if (byArray == null) {
            if (21 == n2) {
                this.setAnyAnimatedCells(false);
            }
            return true;
        }
        if (n == -1) {
            n = byArray.length;
            this.currentStep = 0;
        }
        int n5 = n - this.currentStep;
        int n6 = Math.max(byArray.length / n5, byArray.length % n5);
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = Math.abs(this.game.getRandom().nextInt()) % byArray.length;
            while ((byArray[n7] & 0x80) != 0) {
                n7 = Math.abs(this.game.getRandom().nextInt()) % byArray.length;
            }
            int n8 = this.getIndexedCellProperty(byArray[n7], 0, 7);
            this.setIndexedCellProperty(byArray[n7], 0, 20, 0x100000);
            this.setIndexedCellProperty(byArray[n7], 0, n2, n3);
            this.setIndexedCellProperty(byArray[n7], 1, 11, 2048);
            int n9 = this.getIndexedCellProperty(byArray[n7], 5, 96);
            if (n9 != 0) {
                this.setIndexedCellProperty(byArray[n7], n9 - 1, 5, 96);
            } else {
                boolean bl3;
                this.setIndexedCellProperty(byArray[n7], 7, 0, 7);
                if (n8 != 7) {
                    this.offsetTheWaves(byArray[n7] % this.m_boardWidth, byArray[n7] / this.m_boardWidth, byArray[n7] % this.m_boardWidth, byArray[n7] / this.m_boardWidth, 1, 3, 2);
                }
                if (n8 != 7) {
                    this.game.initParticlesOnCell(byArray[n7], n8);
                }
                if (bl2) {
                    bl3 = this.game.isCPUsTurn2();
                    if (n8 == this.winnerTile) {
                        if (bl3) {
                            this.game.setCpuJewels(0, this.game.getCpuJewels(0) + 1);
                        } else {
                            this.game.setPlayerJewels(0, this.game.getPlayerJewels(0) + 1);
                        }
                    } else if (n8 == this.winnerTile2) {
                        if (bl3) {
                            this.game.setCpuJewels(1, this.game.getCpuJewels(1) + 1);
                        } else {
                            this.game.setPlayerJewels(1, this.game.getPlayerJewels(1) + 1);
                        }
                    }
                }
                if (bl) {
                    int n10;
                    int n11;
                    bl3 = this.game.isCPUsTurn();
                    if (bl3) {
                        this.setIndexedCellProperty(byArray[n7], 2, 3, 24);
                    } else {
                        this.setIndexedCellProperty(byArray[n7], 0, 3, 24);
                    }
                    if (this.game.getAnimAt(byArray[n7]) == null && (n11 = this.getTileAnim(n10 = this.getIndexedCellProperty(byArray[n7], 3, 24), bl3)) != -1) {
                        this.game.startTileAnim(byArray[n7], n11, false);
                    }
                }
            }
            int n12 = n7;
            byArray[n12] = (byte)(byArray[n12] | 0x80);
        }
        if (this.currentStep == n - 1 || n6 == byArray.length) {
            this.currentStep = 0;
            if (this.isAnyShockWaveActive()) {
                return false;
            }
            if (21 == n2) {
                this.setAnyAnimatedCells(false);
            }
            return true;
        }
        ++this.currentStep;
        return false;
    }

    private final void setFlagUponFilter(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, boolean bl3) {
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            int n8;
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || ((n8 = this.getIndexedCellProperty(i, n4, n5)) != n6 || !bl) && (n8 == n6 || bl)) continue;
            this.setIndexedCellProperty(i, n3, n, n2);
            if (bl2) {
                this.setIndexedCellProperty(i, 1, 11, 2048);
            }
            if (n7 < 0) continue;
            this.game.startTileAnim(i, n7, bl3);
        }
    }

    public final int getAdjIndex(int n, int n2) {
        int n3 = n2 * 8;
        return this.m_boardCellAdjacency[n3 + n];
    }

    public final int getLeftIndex(int n) {
        return this.getAdjIndex(0, n);
    }

    public final int getRightIndex(int n) {
        return this.getAdjIndex(1, n);
    }

    public final int getUpIndex(int n) {
        return this.getAdjIndex(2, n);
    }

    public final int getBottomIndex(int n) {
        return this.getAdjIndex(3, n);
    }

    public final int getUpLeftIndex(int n) {
        return this.getAdjIndex(4, n);
    }

    public final int getUpRightIndex(int n) {
        return this.getAdjIndex(5, n);
    }

    public final int getDownLeftIndex(int n) {
        return this.getAdjIndex(7, n);
    }

    public final int getDownRightIndex(int n) {
        return this.getAdjIndex(6, n);
    }

    public final void offsetTheLine(int n, int n2, int n3) {
        int n4 = n3 * this.getWidth();
        int n5 = n4 + this.getWidth();
        for (int i = n4; i < n5; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || this.getIndexedCellProperty(i, 5, 96) != 0) continue;
            this.setTileOffsets(i, n, n2, false, false, -1);
            this.setTileSpeedOrStep(i, 5, 1);
        }
    }

    public final boolean isLineMoving(int n) {
        int n2 = n * this.getWidth();
        int n3 = n2 + this.getWidth();
        for (int i = n2; i < n3; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || !this.isMoving(i)) continue;
            return true;
        }
        return false;
    }

    public final void offsetTheBoard(int n, int n2) {
        for (int i = 0; i < this.getHeight(); ++i) {
            this.offsetTheLine(n, n2, i);
        }
    }

    public final void destroyAnimatedZone(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (this.getIndexedCellProperty(nArray[i], 3, 24) == 3 || (n = this.getIndexedCellProperty(nArray[i], 0, 7)) == 7) continue;
            this.game.initParticlesOnCell(nArray[i], n);
            this.setIndexedCellProperty(nArray[i], 0, 20, 0x100000);
            this.setIndexedCellProperty(nArray[i], 0, 21, 0x200000);
            this.setIndexedCellProperty(nArray[i], 7, 0, 7);
            this.setIndexedCellProperty(nArray[i], 1, 11, 2048);
        }
    }

    public void resetTutorialHighlight() {
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            if (this.getIndexedCellProperty(i, 24, 0x1000000) != 1) continue;
            this.setIndexedCellProperty(i, 0, 24, 0x1000000);
            this.setIndexedCellProperty(i, 1, 27, 0x8000000);
            this.setIndexedCellProperty(i, 1, 11, 2048);
        }
    }

    public void setTutorialHighlight(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.getCellIndex(nArray[i][0], nArray[i][1]);
            if (n == -1) continue;
            this.setIndexedCellProperty(n, 1, 24, 0x1000000);
            this.setIndexedCellProperty(n, 1, 11, 2048);
        }
    }

    public final int getJewelsCount() {
        int n = 0;
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || this.getIndexedCellProperty(i, 0, 7) == 7) continue;
            ++n;
        }
        return n;
    }

    public final void offsetTheWaves(int n, int n2, int n3) {
        this.offsetTheWaves(this.shockWaveRect[0], this.shockWaveRect[1], this.shockWaveRect[2], this.shockWaveRect[3], n, n2, n3);
    }

    public final void offsetTheWaves(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.offsetTheWaves(n, n2, n3, n4, n5, n6, n7, 15);
    }

    public final void offsetTheWaves(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.shockWaveOffset = n6;
        int n9 = n6;
        for (int i = 0; i < n5; ++i) {
            this.offsetTheWave(n, n2, n3, n4, n9, n8);
            --n;
            --n2;
            ++n3;
            ++n4;
            n9 -= n7;
        }
    }

    public final void offsetTheWave(int n, int n2, int n3, int n4, int n5, int n6) {
        --n;
        --n2;
        ++n3;
        ++n4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if ((n6 & 2) != 0 && n2 >= 0) {
            n9 = Math.max(n, 0);
            n10 = Math.min(n3, this.m_boardWidth - 1);
            n7 = this.getCellIndex(n9, n2);
            for (n8 = n9; n8 <= n10; ++n8) {
                if (this.getIndexedCellProperty(n7, 3, 24) != 3 && this.getIndexedCellProperty(n7, 0, 7) != 7 && this.getIndexedCellProperty(n7, 5, 96) == 0) {
                    this.setTileOffsets(n7, 2, n5, false, false, -1);
                    this.setTileSpeedOrStep(n7, 2, 1);
                    this.setIndexedCellProperty(n7, 1, 11, 2048);
                }
                ++n7;
            }
        }
        if ((n6 & 4) != 0 && n3 < this.m_boardWidth) {
            n9 = Math.max(n2, 0);
            n10 = Math.min(n4, this.m_boardHeight - 1);
            n7 = this.getCellIndex(n3, n9);
            for (n8 = n9; n8 <= n10; ++n8) {
                if (this.getIndexedCellProperty(n7, 3, 24) != 3 && this.getIndexedCellProperty(n7, 0, 7) != 7 && this.getIndexedCellProperty(n7, 5, 96) == 0) {
                    this.setTileOffsets(n7, 1, n5, false, false, -1);
                    this.setTileSpeedOrStep(n7, 2, 0);
                    this.setIndexedCellProperty(n7, 1, 11, 2048);
                }
                n7 += this.m_boardWidth;
            }
        }
        if ((n6 & 8) != 0 && n4 < this.m_boardHeight) {
            n9 = Math.min(n3, this.m_boardWidth - 1);
            n10 = Math.max(n, 0);
            n7 = this.getCellIndex(n9, n4);
            for (n8 = n9; n8 >= n10; --n8) {
                if (this.getIndexedCellProperty(n7, 3, 24) != 3 && this.getIndexedCellProperty(n7, 0, 7) != 7 && this.getIndexedCellProperty(n7, 5, 96) == 0) {
                    this.setTileOffsets(n7, 3, n5, false, false, -1);
                    this.setTileSpeedOrStep(n7, 2, 1);
                    this.setIndexedCellProperty(n7, 1, 11, 2048);
                }
                --n7;
            }
        }
        if ((n6 & 1) != 0 && n >= 0) {
            n9 = Math.min(n4, this.m_boardHeight - 1);
            n10 = Math.max(n2, 0);
            n7 = this.getCellIndex(n, n9);
            for (n8 = n9; n8 >= n10; --n8) {
                if (this.getIndexedCellProperty(n7, 3, 24) != 3 && this.getIndexedCellProperty(n7, 0, 7) != 7 && this.getIndexedCellProperty(n7, 5, 96) == 0) {
                    this.setTileOffsets(n7, 0, n5, false, false, -1);
                    this.setTileSpeedOrStep(n7, 2, 0);
                    this.setIndexedCellProperty(n7, 1, 11, 2048);
                }
                n7 -= this.m_boardWidth;
            }
        }
    }

    public void setShockWaveRect(int n, int n2, int n3, int n4) {
        this.shockWaveRect[0] = n;
        this.shockWaveRect[1] = n2;
        this.shockWaveRect[2] = n3;
        this.shockWaveRect[3] = n4;
    }

    public final boolean isAnyShockWaveActive() {
        return this.shockWaveOffset > 0;
    }

    public boolean isAnyAnimatedCells() {
        return this.anyAnimatedCells;
    }

    public void setAnyAnimatedCells(boolean bl) {
        this.anyAnimatedCells = bl;
    }

    public int getSpecialMatchType() {
        return this.specialMatchType;
    }

    public void setSpecialMatchType(int n) {
        if (n == -1) {
            this.specialMatchType = n;
        } else {
            if (this.specialMatchType == -1) {
                this.specialMatchType = 0;
            }
            this.specialMatchType |= 1 << n;
        }
    }

    public final boolean isShiftAnimStarted() {
        return this.shiftAnimStarted;
    }

    public final void setShiftAnimStarted(boolean bl) {
        this.shiftAnimStarted = bl;
    }

    public final void resetTileSpeeds() {
        this.tileSpeeds = new byte[this.m_boardCellArraySize * 3];
    }

    public final void setTileSpeedOrStep(int n, int n2, int n3) {
        this.tileSpeeds[n * 3 + n3] = (byte)n2;
    }

    public final byte getTileSpeedOrStep(int n, int n2) {
        return this.tileSpeeds[n * 3 + n2];
    }

    public final boolean isEvaluationMode() {
        return this.evaluationMode;
    }

    public final boolean areThereEmptyTiles(byte[] byArray, int n) {
        boolean bl = false;
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            if (this.getIndexedCellProperty(i, 3, 24) == 3 || this.getIndexedCellProperty(i, 0, 7) != 7) continue;
            for (int j = 0; j < 8; ++j) {
                int n2 = this.getAdjIndex(j, i);
                if (n2 == -1 || this.getIndexedCellProperty(n2, 0, 7) == 7 || this.getIndexedCellProperty(n2, 5, 96) != 0) continue;
                if (byArray != null && n < byArray.length) {
                    n = this.storeMove(byArray, n, i, n2);
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean areThereActiveTilesUnderneath(int n) {
        if (n == -1) {
            return false;
        }
        return this.getActiveCell(n, 3, true) != -1;
    }

    private final boolean areThereActiveTilesAbove(int n) {
        if (n == -1) {
            return false;
        }
        return this.getActiveCell(n, 2, false) != -1;
    }

    public final void resetSomeFlags() {
        for (int i = 0; i < this.m_boardCells.length; ++i) {
            this.setIndexedCellProperty(i, 0, 20, 0x100000);
            this.setIndexedCellProperty(i, 0, 21, 0x200000);
            this.setIndexedCellProperty(i, 0, 25, 0x2000000);
            this.setIndexedCellProperty(i, 0, 26, 0x4000000);
            this.setIndexedCellProperty(i, 0, 27, 0x8000000);
            this.setIndexedCellProperty(i, 0, 10, 1024);
        }
    }

    public final byte[] getSwappingCells() {
        return this.m_swappingCells;
    }

    public byte getTemSwaping() {
        return this.temSwaping;
    }
}

