/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.menu;

import com.iplay.game.jq2009.TouchableHandler;

public abstract class TextEntry
extends TouchableHandler {
    private int maximumNumberLength;
    private static final int DEFAULT_MAXIMUM_NUMBER_LENGTH = 10;
    private int maximumTextLength;
    private static final int DEFAULT_MAXIMUM_TEXT_LENGTH = 15;
    private static final int NO_KEY = -1;
    private static final int KEY_ENTRY_TIME = 2000;
    char[][] keyCharacters;
    char[] keyNumbers;
    char[] QWERTY_CHARACTERS;
    public static final int CURSOR_FLASH_DURATION = 500;
    private int keyEntryCountdown;
    private boolean lowercase;
    private int currentKey;
    private int currentKeyPressCount;
    private char[] keyEntryText;
    private char[] numberEntryText;
    private boolean changingCharacter;
    private int flashCountdown;
    private boolean cursorVisible;
    private int arcadeEntryArrayPos;

    public final void enableTextEntryFunctionality() {
        this.keyNumbers = "0123456789".toCharArray();
        this.keyCharacters = new char[][]{"0".toCharArray(), "1".toCharArray(), "abc2".toCharArray(), "def3".toCharArray(), "ghi4".toCharArray(), "jkl5".toCharArray(), "mno6".toCharArray(), "pqrs7".toCharArray(), "tuv8".toCharArray(), "wxyz9".toCharArray(), null, "_".toCharArray()};
        this.keyEntryText = new char[0];
        this.numberEntryText = new char[0];
        this.currentKey = -1;
        this.setMaximumNumberLength(10);
        this.setMaximumTextLength(15);
    }

    public final char[] getTextEntryText() {
        return this.keyEntryText;
    }

    public final void setTextEntryText(char[] cArray) {
        this.keyEntryText = cArray;
    }

    public final char[] getNumberEntryText() {
        return this.numberEntryText;
    }

    public final void setNumberEntryText(char[] cArray) {
        this.numberEntryText = cArray;
    }

    public final boolean isTextEntryInputReady() {
        return !this.changingCharacter && this.keyEntryText.length < this.getMaximumTextLength();
    }

    public final boolean isNumberEntryInputReady() {
        return this.numberEntryText.length < this.getMaximumNumberLength();
    }

    public final boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public final boolean deleteTextEntryCharacter() {
        boolean bl = false;
        if (this.keyEntryText.length != 0) {
            char[] cArray = new char[this.keyEntryText.length - 1];
            System.arraycopy(this.keyEntryText, 0, cArray, 0, this.keyEntryText.length - 1);
            this.keyEntryText = cArray;
            this.keyEntryTextChanged();
            bl = true;
            this.currentKeyPressCount = 0;
            this.currentKey = -1;
        }
        return bl;
    }

    public final boolean deleteNumberEntryCharacter() {
        boolean bl = false;
        if (this.numberEntryText.length != 0) {
            char[] cArray = new char[this.numberEntryText.length - 1];
            System.arraycopy(this.numberEntryText, 0, cArray, 0, this.numberEntryText.length - 1);
            this.numberEntryText = cArray;
            this.keyEntryTextChanged();
            bl = true;
        }
        return bl;
    }

    protected final void updateKeyEntry(int n) {
        if (!this.changingCharacter && (this.flashCountdown -= n) < 0) {
            this.flashCountdown = 500;
            this.cursorVisible = !this.cursorVisible;
            this.keyEntryTextChanged();
        }
        if (this.wasKeyPressed(10)) {
            if (this.currentKey >= 0) {
                boolean bl = this.lowercase = !this.lowercase;
                if (this.changingCharacter) {
                    this.setCharacter(this.keyCharacters[this.currentKey][this.currentKeyPressCount]);
                }
                this.keyEntryCountdown = 2000;
            }
        } else if (this.wasKeyPressed(15)) {
            this.keyEntryTextUpPressed();
        } else if (this.wasKeyPressed(16)) {
            this.keyEntryTextDownPressed();
        } else if (this.wasKeyPressed(17)) {
            this.deleteTextEntryCharacter();
        } else {
            for (int i = 0; i < this.keyCharacters.length; ++i) {
                if (!this.wasKeyPressed(0 + i)) continue;
                if (this.currentKey == i && this.keyCharacters[i].length > 1) {
                    this.currentKeyPressCount = (this.currentKeyPressCount + 1) % this.keyCharacters[i].length;
                    this.setCharacter(this.keyCharacters[i][this.currentKeyPressCount]);
                } else if (this.keyEntryText.length < this.getMaximumTextLength()) {
                    this.currentKey = i;
                    this.currentKeyPressCount = 0;
                    this.changingCharacter = true;
                    this.addCharacter(this.keyCharacters[i][0]);
                    this.keyEntryTextChanged();
                }
                this.keyEntryCountdown = this.keyCharacters[i].length > 1 ? 2000 : 1;
            }
            if (this.keyEntryCountdown > 0) {
                this.keyEntryCountdown -= n;
                if (this.keyEntryCountdown <= 0) {
                    this.keyEntryCountdown = 0;
                    this.currentKey = -1;
                    this.flashCountdown = 500;
                    this.cursorVisible = true;
                    this.currentKeyPressCount = 0;
                    this.changingCharacter = false;
                    this.keyEntryTextChanged();
                }
            }
        }
    }

    protected final void updateNumberEntry(int n) {
        if (!this.changingCharacter && (this.flashCountdown -= n) < 0) {
            this.flashCountdown = 500;
            this.cursorVisible = !this.cursorVisible;
            this.keyEntryTextChanged();
        }
        if (this.wasKeyPressed(15)) {
            this.keyEntryTextUpPressed();
        } else if (this.wasKeyPressed(16)) {
            this.keyEntryTextDownPressed();
        } else if (this.wasKeyPressed(17)) {
            this.deleteNumberEntryCharacter();
        } else if (this.numberEntryText.length < this.getMaximumNumberLength()) {
            for (int i = 0; i < this.keyNumbers.length; ++i) {
                if (!this.wasKeyPressed(0 + i)) continue;
                this.addNumber(this.keyNumbers[i]);
                this.keyEntryTextChanged();
            }
        }
    }

    private void addCharacterArcade(char c) {
        char[] cArray = new char[this.keyEntryText.length + 1];
        System.arraycopy(this.keyEntryText, 0, cArray, 0, this.keyEntryText.length);
        cArray[this.keyEntryText.length] = c;
        this.keyEntryText = cArray;
    }

    private void setCharacterArcade(char c) {
        this.keyEntryText[this.keyEntryText.length - 1] = c;
        this.keyEntryTextChanged();
    }

    final void clearKeyEntry() {
        this.keyEntryText = new char[0];
        this.currentKey = -1;
        this.currentKeyPressCount = 0;
    }

    private void setCharacter(char c) {
        this.keyEntryText[this.keyEntryText.length - 1] = this.lowercase ? c : Character.toUpperCase(c);
        this.keyEntryTextChanged();
    }

    private void addCharacter(char c) {
        char[] cArray = new char[this.keyEntryText.length + 1];
        System.arraycopy(this.keyEntryText, 0, cArray, 0, this.keyEntryText.length);
        cArray[this.keyEntryText.length] = this.lowercase ? c : Character.toUpperCase(c);
        this.keyEntryText = cArray;
    }

    private void addNumber(char c) {
        char[] cArray = new char[this.numberEntryText.length + 1];
        System.arraycopy(this.numberEntryText, 0, cArray, 0, this.numberEntryText.length);
        cArray[this.numberEntryText.length] = c;
        this.numberEntryText = cArray;
    }

    public abstract void keyEntryTextChanged();

    public abstract void keyEntryTextUpPressed();

    public abstract void keyEntryTextDownPressed();

    protected final int getMaximumNumberLength() {
        return this.maximumNumberLength;
    }

    protected final void setMaximumNumberLength(int n) {
        this.maximumNumberLength = n;
    }

    protected final int getMaximumTextLength() {
        return this.maximumTextLength;
    }

    protected final void setMaximumTextLength(int n) {
        this.maximumTextLength = n;
    }
}

