/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.TouchHandler;
import com.iplay.game.interfaces.InputHandlerInterface;

public abstract class InputHandler
extends TouchHandler
implements InputHandlerInterface {
    private static final int KEYSTATE_NONE = 0;
    private static final int KEYSTATE_PRESSED = 1;
    private static final int KEYSTATE_RELEASED = 2;
    private static final int KEYSTATE_DOWN = 4;
    private static final int KEYSTATE_CLICKED = 3;
    private static final int KEYSTATE_COMPLETE = 7;
    private Object inputLock;
    private byte[] keyState;
    private long lastKeyPressTime;
    private byte[] keyStateSnapshot;

    public final void initInputHandler() {
        this.keyState = new byte[23];
        this.keyStateSnapshot = new byte[23];
        this.inputLock = new Object();
    }

    public boolean wasKeyPressed(int keyCodeAndFlag) {
        boolean wasKeyPressed;
        byte[] keyStates;
        boolean immediate = (keyCodeAndFlag & 0x8000000) != 0;
        int keyCode = keyCodeAndFlag & 0xF7FFFFFF;
        byte[] byArray = keyStates = immediate ? this.keyState : this.keyStateSnapshot;
        if (immediate && this.wasKeyPressed(keyCode)) {
            return true;
        }
        boolean bl = wasKeyPressed = (keyStates[keyCode] & 1) != 0 && (keyStates[keyCode] & 4) == 0;
        if (immediate && wasKeyPressed) {
            int n = keyCode;
            this.keyState[n] = (byte)(this.keyState[n] | 2);
        }
        return wasKeyPressed;
    }

    public final int getAlternativeKeyCode(int keyCode) {
        return -1;
    }

    public boolean isKeyDown(int keyCode) {
        boolean isKeyDown = this.keyStateSnapshot[keyCode] != 7 && ((this.keyStateSnapshot[keyCode] & 4) != 0 || (this.keyStateSnapshot[keyCode] & 1) != 0);
        return isKeyDown;
    }

    public boolean wasKeyReleased(int keyCode) {
        boolean wasKeyReleased = (this.keyStateSnapshot[keyCode] & 2) != 0;
        return wasKeyReleased;
    }

    private final int getKeyIndex(int keyCode) {
        int keyIndex;
        if (keyCode >= 48 && keyCode <= 57) {
            keyIndex = keyCode - 48;
        } else {
            switch (keyCode) {
                case 42: {
                    keyIndex = 10;
                    break;
                }
                case 35: {
                    keyIndex = 11;
                    break;
                }
                case -5: {
                    keyIndex = 14;
                    break;
                }
                case -3: {
                    keyIndex = 17;
                    break;
                }
                case -1: {
                    keyIndex = 15;
                    break;
                }
                case -4: {
                    keyIndex = 18;
                    break;
                }
                case -2: {
                    keyIndex = 16;
                    break;
                }
                case -6: {
                    keyIndex = 21;
                    break;
                }
                case -7: {
                    keyIndex = 22;
                    break;
                }
                case -98: {
                    keyIndex = 19;
                    break;
                }
                case -99: {
                    keyIndex = 20;
                    break;
                }
                default: {
                    keyIndex = -1;
                }
            }
        }
        return keyIndex;
    }

    public final void keyPressed(int keyCode) {
        this.checkCheatCode(keyCode);
        this.lastKeyPressTime = System.currentTimeMillis();
        this.processEvent(keyCode, 1);
    }

    public final void keyReleased(int keyCode) {
        this.processEvent(keyCode, 2);
    }

    abstract void printToConsole(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(int keyCode, int event) {
        int keyIndex = this.getKeyIndex(keyCode);
        Object object = this.inputLock;
        synchronized (object) {
            if (keyIndex != -1) {
                if (event == 1) {
                    this.keyState[keyIndex] = (byte)event;
                } else if (this.keyState[keyIndex] != 0) {
                    int n = keyIndex;
                    this.keyState[n] = (byte)(this.keyState[n] | event);
                }
            }
        }
    }

    public final void keyInterrupt() {
        for (int i = 0; i < 23; ++i) {
            if (this.keyState[i] == 0) continue;
            int n = i;
            this.keyState[n] = (byte)(this.keyState[n] | 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateKeyStates() {
        Object object = this.inputLock;
        synchronized (object) {
            System.arraycopy(this.keyState, 0, this.keyStateSnapshot, 0, 23);
            for (int i = 0; i < 23; ++i) {
                if (this.keyState[i] == 7 || this.keyState[i] == 3) {
                    this.keyState[i] = 0;
                    continue;
                }
                if (this.keyState[i] == 0) continue;
                int n = i;
                this.keyState[n] = (byte)(this.keyState[n] | 4);
            }
        }
    }

    private final String getKeyIndexName(int keyIndex) {
        switch (keyIndex) {
            case 0: {
                return "KEY_NUM0";
            }
            case 1: {
                return "KEY_NUM1";
            }
            case 2: {
                return "KEY_NUM2";
            }
            case 3: {
                return "KEY_NUM3";
            }
            case 4: {
                return "KEY_NUM4";
            }
            case 5: {
                return "KEY_NUM5";
            }
            case 6: {
                return "KEY_NUM6";
            }
            case 7: {
                return "KEY_NUM7";
            }
            case 8: {
                return "KEY_NUM8";
            }
            case 9: {
                return "KEY_NUM9";
            }
            case 10: {
                return "KEY_STAR";
            }
            case 11: {
                return "KEY_POUND";
            }
            case 14: {
                return "KEY_FIRE";
            }
            case 15: {
                return "KEY_UP";
            }
            case 16: {
                return "KEY_DOWN";
            }
            case 17: {
                return "KEY_LEFT";
            }
            case 18: {
                return "KEY_RIGHT";
            }
            case 19: {
                return "KEY_CLEAR";
            }
            case 20: {
                return "KEY_BACK";
            }
            case 21: {
                return "KEY_POSITIVESOFT";
            }
            case 22: {
                return "KEY_NEGATIVESOFT";
            }
        }
        return "KEY_UNSUPPORTED";
    }

    private String getKeyStateName(int keyState) {
        String keyStateString;
        switch (keyState & 3) {
            case 1: {
                keyStateString = "KEYSTATE_PRESSED";
            }
            case 2: {
                keyStateString = "KEYSTATE_RELEASED";
            }
            case 3: {
                keyStateString = "KEYSTATE_CLICKED";
            }
        }
        keyStateString = "KEYSTATE_NONE";
        if ((keyState & 4) != 0) {
            keyStateString = keyStateString + "&KEYSTATE_DOWN";
        }
        return keyStateString;
    }

    public final void printKeyStates() {
        for (int i = 0; i < 23; ++i) {
            System.out.println("key " + this.getKeyIndexName(i) + " state=" + this.getKeyStateName(this.keyState[i]));
        }
    }

    public long getLastKeyPressTime() {
        return this.lastKeyPressTime;
    }

    abstract void checkCheatCode(int var1);
}

