/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.image;

import com.iplay.game.IOHandler;
import com.iplay.game.image.PNGUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class TransformableImage {
    private Image image;
    public static final int TRANS_INVALID = -1;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int OPERATION_MOD_PALETTE = 0;
    public static final int OPERATION_SCALE_IMAGE = 1;

    public TransformableImage(String string) throws Exception {
        this(IOHandler.createImage(string));
    }

    public TransformableImage(String string, int n) {
        byte[] byArray = IOHandler.getResourceAsByteArray(string);
        PNGUtils.modifyPalette(byArray, n);
        this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public TransformableImage(String string, int n, int n2) {
        byte[] byArray = IOHandler.getResourceAsByteArray(string);
        byArray = PNGUtils.rescaleUncompressedPalettized8BPP(byArray, n, n2);
        this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public TransformableImage(String string, int n, int n2, int n3, int n4) {
        byte[] byArray = IOHandler.getResourceAsByteArray(string);
        byArray = PNGUtils.rescaleUncompressedPalettized8BPP(byArray, n, n2);
        PNGUtils.fadePalette(byArray, n3, n4);
        this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    private TransformableImage(Image image) {
        this.image = image;
    }

    public final int getWidth() {
        return this.image.getWidth();
    }

    public final int getHeight() {
        return this.image.getHeight();
    }

    public final void drawImage(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.drawRegion(this.image, n, n2, n3, n4, n5, n6, n7, 20);
    }

    public final void drawImage(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, 20);
    }
}

