/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.jq2009;

import com.iplay.game.Gamelet;
import com.iplay.game.PackHandler;
import com.iplay.game.TextHandler;
import com.iplay.game.font.ExtendedCharHandler;
import com.iplay.game.font.Font;
import com.iplay.game.jq2009.JQ2009Game;
import com.iplay.game.jq2009.MenuRenderer;
import com.iplay.game.jq2009.SpecialSymbol;
import com.iplay.game.jq2009.config.DefaultConstants;
import com.iplay.game.math.FixedPoint12;
import com.iplay.game.menu.MenuPage;
import com.iplay.game.util.TimerHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JQ2009GameCanvas
extends MenuRenderer
implements ExtendedCharHandler {
    private long gcTime = 0L;
    private int logoTime = 0;
    private static final int INITIAL_LOAD_QUEUE_SIZE = 10;
    private static final int QUEUE_SIZE_INCREMENT = 10;
    public static final int LOAD_INACTIVE = -4096;
    public static final int LOAD_START = 0;
    public static final int LOAD_COMPLETE = 4096;
    public static final int COLOR_ERROR_BG = 0xFF00FF;
    public static final int POSY_ERROR = 20;
    public static final int ONE_THOUSAND = 1000;
    public static final int ONE_HUNDRED = 100;
    public static final int LOADING_BAR_FRAME_LEFT_PERCENT = 15;
    public static final int LOADING_BAR_FRAME_WIDTH_PERCENT = 70;
    public static final int LOADING_BAR_FRAME_HEIGHT_PERCENT = 4;
    public static final int LOADING_BAR_TEXT_BOTTOM_PERCENT = 85;
    public static final int LOADING_BAR_FRAME_TOP_OFFSET = 2;
    public static final int LOADING_BAR_FRAME_LEFT_OFFSET = 2;
    public static final int LOADING_BAR_FRAME_WIDTH_OFFSET = 3;
    public static final int LOADING_BAR_FRAME_HEIGHT_OFFSET = 3;
    public static final int PAD_X = 10;
    public static final int CHEAT_GIVE_COINS_AMOUNT = 10;
    public static final int CHEAT_TIME_PERCENT = 85;
    public static final int CHEAT_INCREASE_JEWELS_MATCHED = 9000;
    public static final int CHEAT_INCREASE_SCORE_STR_MULTIPLIER_FROM_INDEX = 5;
    public static final int CHEAT_INCREASE_SCORE_AMOUNT = 10000;
    public static final int CHEAT_GOTO_STR_CHAPTER_START_INDEX = 5;
    public static final int DECIMAL_TEN = 10;
    public static final int DEFAULT_SCORE_BEN = 200000;
    public static final int DEFAULT_SCORE_PAT = 180000;
    public static final int DEFAULT_SCORE_ZAIN = 160000;
    public static final int DEFAULT_SCORE_STU = 140000;
    public static final int DEFAULT_SCORE_MARK = 120000;
    public static final int DEFAULT_SCORE_GAV = 100000;
    public static final int DEFAULT_SCORE_JON = 80000;
    public static final int DEFAULT_SCORE_PAUL = 60000;
    public static final int DEFAULT_SCORE_IAN = 40000;
    public static final int DEFAULT_SCORE_TAUF = 20000;
    private boolean loadingPaused = false;
    private int[] loadID;
    private int loadQueueHead;
    private int loadQueueSize;
    private int totalQueueSize;
    private int baseFraction;
    private boolean loadAborted;
    public static long timeLapse;
    public String errorMessage = null;
    private static final int MAX_STATE_STACK_DEPTH = 10;
    private int[] stateType = new int[10];
    private int currentStackEntry = 0;
    private static final String CHEAT_WIN = "#8946";
    private static final String CHEAT_WIN_C = "#2946";
    private static final String CHEAT_COIN = "#2646";
    private static final String RESET_UNITY_CHEAT = "#3000";
    private static final String CHEAT_LOSE = "#5673";
    private static final String CHEAT_TIME_DECREASE = "#8463";
    private static final String CHEAT_ADD_SCORE = "#7267";
    private static final String CHEAT_ADD_JEWELS = "#2335";
    private static final String CHEAT_UNLOCK_LEVELS = "#6736";
    private static final String CHEAT_UNLOCK_AWARDS = "#2973";
    private static final String CHEAT_JUMP_TO_LEVEL = "#4686";
    private static final String CHEAT_TEXT = "#8398";
    private static final String CHEAT_TOUCHSCREEN = "#8624";
    private static final String BUY_CHEAT = "#289";
    private Font sharedFont;
    private Font baseFont;
    private Font digitFont;
    private Font softkeyFont;
    private Font auxFont;
    private Image iplaySplash;
    private Image titleImage;
    protected char[] okSoftKey;
    protected char[] backSoftKey;
    protected char[] selectSoftKey;
    protected char[] yesSoftKey;
    protected char[] noSoftKey;
    protected char[] exitSoftKey;
    protected char[] pauseSoftKey;
    protected char[] deleteSoftKey;
    protected char[] menuSoftKey;
    protected char[] cancelSoftKey;
    protected char[] scrollSoftkey;
    protected char[] skipSoftkey;
    protected char[] powerupSoftkey;
    protected char[] upArrow;
    protected char[] downArrow;
    private char[] userName;
    private int pauseSplashPreviousMenuPageId;
    private Image commonSplash;
    private Random random;
    private long lastFrameTime = 0L;
    public static int __fake_state;
    int countFrames = 0;
    public static int gameStatetest;
    public static int __cheatsTS_index;
    private char[] showCheatName;
    private int showCheatCountdown;
    private static final int SHOW_CHEAT_COUNTDOWN_DURATION = 2000;
    private String cachedAppVersion;
    private String cachedAppVendor;
    private String cachedAppName;

    private final void loadTutorialProgress(DataInputStream dataInputStream) throws IOException {
        boolean[] blArray = new boolean[this.getTutorials().length];
        boolean bl = false;
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        this.setTutorials(blArray);
        bl = dataInputStream.readBoolean();
        this.setSpecialMatches(bl);
        this.setYourTurn(dataInputStream.readBoolean());
    }

    public final void loadGameStateFromRMS(DataInputStream dataInputStream) throws IOException {
        this.setUserName(dataInputStream.readUTF().toCharArray());
        int n = dataInputStream.readInt();
        this.setHighScoreNames(new char[n][]);
        this.setHighScores(new int[n]);
        for (int i = 0; i < n; ++i) {
            this.getHighScoreNames()[i] = dataInputStream.readUTF().toCharArray();
            this.getHighScores()[i] = dataInputStream.readInt();
        }
        this.setConnectedUsername(dataInputStream.readUTF().toCharArray());
        this.setPostFailedPostedHighScore(dataInputStream.readInt());
        this.setStoryCurrentLevel(dataInputStream.readInt());
        this.setQuickModeMaxLevel(dataInputStream.readInt());
        this.loadPowerups(dataInputStream);
        this.setStoryCoins(dataInputStream.readInt());
        this.setScore(dataInputStream.readInt());
        this.loadAwards(dataInputStream);
        this.loadStats(dataInputStream);
        this.loadTutorialProgress(dataInputStream);
    }

    private final void loadAwards(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < 18; ++i) {
            this.getAwards()[i] = dataInputStream.readBoolean();
        }
    }

    private final void loadStats(DataInputStream dataInputStream) throws IOException {
        this.totalJewelsMatched = dataInputStream.readInt();
        this.totalCoinsUsed = dataInputStream.readInt();
        this.totalMaxStreak = dataInputStream.readInt();
        this.totalMatch4 = dataInputStream.readInt();
        this.totalMatch5 = dataInputStream.readInt();
        this.coinsUsedInStory = dataInputStream.readBoolean();
    }

    private final void loadPowerups(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.setPowerup(i, dataInputStream.readInt());
        }
    }

    public void loadOptionsFromRMS(DataInputStream dataInputStream) throws IOException {
        this.setSoundEnabled(dataInputStream.readBoolean());
        TextHandler.setLanguage(dataInputStream.readInt());
        this.setTutorialEnabled(dataInputStream.readBoolean());
    }

    private void saveTutorialProgress(DataOutputStream dataOutputStream) throws IOException {
        boolean[] blArray = this.getTutorials();
        boolean bl = this.getSpecialMatches();
        for (int i = 0; i < blArray.length; ++i) {
            dataOutputStream.writeBoolean(blArray[i]);
        }
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeBoolean(this.isYourTurn());
    }

    public final boolean saveGameStateToRMS(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(new String(this.getUserName()));
        dataOutputStream.writeInt(this.getHighScores() == null ? 0 : this.getHighScores().length);
        for (int i = 0; i < (this.getHighScores() == null ? 0 : this.getHighScores().length); ++i) {
            dataOutputStream.writeUTF(new String(this.getHighScoreNames()[i]));
            dataOutputStream.writeInt(this.getHighScores()[i]);
        }
        dataOutputStream.writeUTF(new String(this.getConnectedUsername(false)));
        dataOutputStream.writeInt(this.getPostFailedHighScore());
        dataOutputStream.writeInt(this.getStoryCurrentLevel());
        dataOutputStream.writeInt(this.getQuickModeMaxLevel());
        this.savePowerups(dataOutputStream);
        dataOutputStream.writeInt(this.getStoryCoins());
        dataOutputStream.writeInt(this.getScore());
        this.saveAwards(dataOutputStream);
        this.saveStats(dataOutputStream);
        this.saveTutorialProgress(dataOutputStream);
        return true;
    }

    private final void saveAwards(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < this.getAwards().length; ++i) {
            dataOutputStream.writeBoolean(this.getAwards()[i]);
        }
    }

    private final void saveStats(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.totalJewelsMatched);
        dataOutputStream.writeInt(this.totalCoinsUsed);
        dataOutputStream.writeInt(this.totalMaxStreak);
        dataOutputStream.writeInt(this.totalMatch4);
        dataOutputStream.writeInt(this.totalMatch5);
        dataOutputStream.writeBoolean(this.coinsUsedInStory);
    }

    private final void savePowerups(DataOutputStream dataOutputStream) throws IOException {
        int[] nArray = this.getPowerups();
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public final boolean saveOptionsToRMS(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.isSoundEnabled());
        dataOutputStream.writeInt(TextHandler.getLanguage());
        dataOutputStream.writeBoolean(this.isTutorialEnabled());
        return true;
    }

    public final void update(int n) {
        this.preRenderUpdateImpl(n);
    }

    public final void preRenderUpdateImpl(int n) {
        if (DefaultConstants.DEVICE_WITH_LANDSCAPE_AND_PORTRAIT_MODE && (this.getWidth() < this.getHeight() || this.screenWidth < this.screenHeight)) {
            return;
        }
        int n2 = this.getGameState();
        if (!this.loadingPaused && this.loadQueueSize > 0) {
            long l = System.currentTimeMillis();
            do {
                if (!this.processLoadEvent(this.loadID[this.loadQueueHead])) {
                    throw new IllegalArgumentException("Unable to load event id = " + this.loadID[this.loadQueueHead]);
                }
                this.loadQueueHead = (this.loadQueueHead + 1) % this.loadID.length;
                if (--this.loadQueueSize > 0) continue;
                this.loadQueueSize = 0;
                this.loadID = null;
                break;
            } while (System.currentTimeMillis() - l < 100L);
        } else {
            this.totalQueueSize = 0;
        }
        switch (n2) {
            case 0: {
                if (this.logoTime == 0) {
                    this.setIplaySplash(PackHandler.createImage("/logo1.png"));
                    if (this.iplaySplash == null) {
                        this.iplaySplash = null;
                        this.setGameState(1);
                    }
                } else if (this.logoTime == 24) {
                    this.setIplaySplash(PackHandler.createImage("/logo2.png"));
                    if (this.iplaySplash == null) {
                        this.iplaySplash = null;
                        this.setGameState(1);
                    }
                } else if (this.logoTime == 48) {
                    this.setIplaySplash(PackHandler.createImage("/logo3.png"));
                    if (this.iplaySplash == null) {
                        this.iplaySplash = null;
                        this.setGameState(1);
                    }
                } else if (this.logoTime >= 72) {
                    this.iplaySplash = null;
                    this.setGameState(1);
                }
                ++this.logoTime;
                break;
            }
            case 13: {
                break;
            }
            case 1: {
                if (this.iplaySplash == null) {
                    this.setIplaySplash(PackHandler.createImage("/iplay.png"));
                }
                if (this.getLoadingProgress() == -4096) {
                    this.setGameState(2);
                }
                this.setGameMode(2);
                this.setBackBuffer(Image.createImage((int)this.screenWidth, (int)this.screenHeight));
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                if (this.getLoadingProgress() != -4096) break;
                if (this.getIplaySplash() != null) {
                    this.setIplaySplash(null);
                }
                this.setGameState(5);
                break;
            }
            case 4: {
                if (this.getLoadingProgress() != -4096) break;
                this.setGameState(6);
                break;
            }
            case 11: {
                if (this.getLoadingProgress() != -4096) break;
                this.setGameState(5);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                this.updateMenu(n);
                break;
            }
            case 8: {
                this.preRenderJQ2009Game(n);
                break;
            }
            case 9: {
                if (this.getLoadingProgress() != -4096) break;
                this.setGameState(8);
                break;
            }
        }
    }

    public final void preRenderUpdate(int n) {
        this.preRenderUpdateImpl(n);
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    public final void render(Graphics graphics) {
        this.renderImpl(graphics);
    }

    public final void renderImpl(Graphics graphics) {
        int n = this.getGameState();
        switch (n) {
            case 0: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
                if (this.getIplaySplash() == null) break;
                graphics.drawImage(this.getIplaySplash(), this.screenWidth >> 1, this.screenHeight >> 1, 3);
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                if (n != 2) {
                    graphics.setColor(16245963);
                    graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
                    JQ2009Game.mSkbarSpac.renderFrame(graphics, 3, -1, this.screenWidth >> 1, this.screenHeight >> 1);
                } else {
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
                    if (this.getIplaySplash() != null) {
                        graphics.drawImage(this.getIplaySplash(), this.screenWidth >> 1, this.screenHeight >> 1, 3);
                    }
                }
                int n2 = this.getLoadingProgress();
                if (n2 == -4096) break;
                int n3 = this.screenHeight * 1000 / 100;
                int n4 = n3 * 85 / 1000;
                if (n != 2) {
                    char[] cArray = null;
                    cArray = this.getText(0);
                    graphics.setColor(0);
                    this.getSharedFont().drawChars(graphics, cArray, 0, cArray.length, (this.screenWidth >> 1) - (this.getSharedFont().charsWidth(cArray, 0, cArray.length, true) >> 1), n4 - this.getSharedFont().getHeight(), 20, true);
                }
                int n5 = this.screenWidth * 1000 / 100;
                int n6 = n4 + 1;
                int n7 = n5 * 15 / 1000;
                int n8 = n5 * 70 / 1000;
                int n9 = n3 * 4 / 1000 + 0;
                graphics.setColor(0);
                graphics.drawRect(n7, n6, n8, n9);
                int n10 = n6 + 2;
                int n11 = n7 + 2;
                int n12 = n8 - 3;
                int n13 = n9 - 3;
                graphics.setColor(11206665);
                graphics.fillRect(n11, n10, FixedPoint12.multiply(n12 << 12, n2) >> 12, n13);
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                this.renderMenu(graphics);
                break;
            }
            case 7: {
                this.renderPauseMenu(graphics);
                break;
            }
            case 8: {
                this.renderJQ2009Game(graphics);
                break;
            }
        }
    }

    public final void applicationInterrupt() {
        this.stopAllSounds();
        int n = this.getGameState();
        this.setFullRedraw(true);
        if (n != 9) {
            if (n == 8) {
                this.setFullRedraw(true);
                int n2 = this.getJQ2009GameState();
                switch (n2) {
                    case 6: {
                        this.setTutorialRepaintMain(true);
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: {
                        break;
                    }
                    default: {
                        this.pauseJQ2009Game();
                    }
                }
                if (!this.getM_board().isSwapInProgress() && this.isPlayersTurn()) {
                    this.deselectCells();
                }
            } else if (n == 5) {
                int n3 = this.getActiveMenuPageId();
                if (n3 == 3 || n3 == 4 || n3 == 1) {
                    // empty if block
                }
                if (n3 != 21 && n3 != 22 && n3 != 23 && n3 != 60) {
                    this.setPauseSplashPreviousMenuPageId(this.getActiveMenuPageId());
                    this.pushGameState(12);
                }
            } else if (n == 2) {
                // empty if block
            }
        }
    }

    public final void applicationResumed(long l, long l2) {
        TimerHandler.interrupt(l, l2);
        this.setFullRedraw(true);
        if (JQ2009Game.gamePauseTime < 0L) {
            JQ2009Game.gamePauseTime = System.currentTimeMillis() - JQ2009Game.gameStartTime;
        }
    }

    public final void applicationStop(boolean bl) {
        this.setFullRedraw(true);
        if (JQ2009Game.gamePauseTime < 0L) {
            JQ2009Game.gamePauseTime = System.currentTimeMillis() - JQ2009Game.gameStartTime;
        }
        if (this.getGameState() == 8 && this.getJQ2009GameState() == 11 && this.getGameMode() == 2) {
            this.setCurrentLevel(this.getCurrentLevel() + 1);
        }
        this.saveGameState(-1);
        this.saveOptions(-1);
        this.flushRMSOnExit();
    }

    public int getFrameTime() {
        return 50;
    }

    public void triggerCheat(String string) {
        boolean bl = true;
        String string2 = string;
        int n = this.getEndConditionCodes();
        if (this.getGameState() == 5 && this.getActiveMenuPageId() == 5) {
            if (string.equals(CHEAT_WIN_C)) {
                int n2 = this.getChapter(this.getCurrentLevel());
                int n3 = 0;
                for (int i = 0; i <= n2; ++i) {
                    n3 += this.getChapterLevelCount(i);
                }
                this.setQuickModeMaxLevel(Math.max(n3, this.getQuickModeMaxLevel()));
                this.setCurrentLevel(n3);
                if (n2 >= this.getChaptersCount() - 1) {
                    --n3;
                }
                this.setCurrentLevel(n3);
                this.saveGameState(-1);
            } else if (string.indexOf(CHEAT_JUMP_TO_LEVEL) == 0) {
                int n4 = Integer.parseInt(string.substring(5, 6)) - 1;
                int n5 = Integer.parseInt(string.substring(6)) - 1;
                int n6 = 0;
                for (int i = 0; i < n4; ++i) {
                    n6 += this.getChapterLevelCount(i);
                }
                this.setCurrentLevel(n6 += n5);
                this.saveGameState(-1);
            } else if (string.equals(RESET_UNITY_CHEAT)) {
                this.setConnectedUsername(null);
                this.saveGameState(-1);
            } else if (string.equals(CHEAT_UNLOCK_LEVELS)) {
                this.setUnlockLevels(!this.isUnlockLevels());
            } else if (string.equals(CHEAT_UNLOCK_AWARDS)) {
                this.setUnlockAwards(true);
            }
        } else if (string.equals(CHEAT_WIN)) {
            n |= 0x2000;
        } else if (string.equals(CHEAT_COIN)) {
            this.setCoins(this.getCoins() + 10);
        } else if (string.equals(CHEAT_LOSE)) {
            n |= 0x1000;
        } else if (string.equals(CHEAT_TIME_DECREASE)) {
            this.setRoundTimer(85);
        } else if (string.indexOf(CHEAT_ADD_SCORE) == 0) {
            int n7 = Integer.parseInt(string.substring(5));
            this.setGameScore(this.getGameScore() + 10000 * n7);
        } else if (string.equals(CHEAT_ADD_JEWELS)) {
            this.totalJewelsMatched += 9000;
        } else if (this.getJQ2009GameState() == 7 && string.equals(CHEAT_TEXT)) {
            this.cheatShowText = 1;
        }
        this.setEndConditionCodes(n);
    }

    public final void loadSounds() {
        String[] stringArray = new String[]{"/menu.mid", "audio/midi", "/match.mid", "audio/midi", "/illegal.mid", "audio/midi", "/outoftime.mid", "audio/midi", "", "audio/midi", "/win.mid", "audio/midi", "/lose.mid", "audio/midi", "/selection.mid", "audio/midi", "/illegal.mid", "audio/midi", "", "audio/midi", "/nomoves.mid", "audio/midi", "/bossintro.mid", "audio/midi", "/normalintro.mid", "audio/midi", "/powerup.mid", "audio/midi", "", "audio/midi", "/fallingcoin.mid", "audio/midi"};
        this.initSound(stringArray.length >> 1, stringArray.length >> 1);
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i] == "" || this.isSoundLoaded(i >> 1)) continue;
            this.loadSound(stringArray[i], stringArray[i + 1], i >> 1);
        }
    }

    public final void setGameState(int n) {
        int n2 = this.stateType[this.currentStackEntry];
        this.stateType[this.currentStackEntry] = n;
        this.stateChanged(n2, n);
    }

    public final void pushGameState(int n) {
        int n2 = this.stateType[this.currentStackEntry];
        ++this.currentStackEntry;
        this.stateType[this.currentStackEntry] = n;
        this.stateChanged(n2, n);
    }

    public final int popGameState() {
        this.stateChanged(this.stateType[this.currentStackEntry], this.stateType[--this.currentStackEntry]);
        return this.stateType[this.currentStackEntry];
    }

    public final int getGameState() {
        return this.stateType[this.currentStackEntry];
    }

    public final int getParentGameState() {
        return this.stateType[this.currentStackEntry - 1];
    }

    public final void stateChanged(int n, int n2) {
        switch (n2) {
            case 2: {
                this.pushLoadEvent(17);
                this.pushLoadEvent(16);
                this.pushLoadEvent(12);
                this.pushLoadEvent(3);
                this.pushLoadEvent(1);
                this.pushLoadEvent(14);
                this.pushLoadEvent(13);
                this.pushLoadEvent(0);
                this.pushLoadEvent(15);
                this.pushLoadEvent(5);
                this.pushLoadEvent(2);
                this.pushLoadEvent(4);
                break;
            }
            case 10: 
            case 11: {
                this.pushLoadEvent(0);
                this.pushLoadEvent(4);
                this.stopSound(0);
                break;
            }
            case 4: {
                if (n == 7 || n == 8 || n == 9) {
                    this.destroyJQ2009Game();
                    this.destroyPauseMenu();
                }
                this.setPositiveSoftkey(null);
                this.setNegativeSoftkey(null);
                this.loadTextSection(1);
                this.pushLoadEvent(10);
                break;
            }
            case 3: {
                if (n == 7 || n == 8 || n == 9) {
                    this.destroyJQ2009Game();
                    this.destroyPauseMenu();
                }
                this.setPositiveSoftkey(null);
                this.setNegativeSoftkey(null);
                this.pushLoadEvent(4);
                break;
            }
            case 7: {
                if (n != 8 && n != 9) break;
                if (n == 8) {
                    this.stopAllSounds();
                }
                this.setActiveMenuPage(47);
                break;
            }
            case 12: {
                this.setActiveMenuPage(2);
                break;
            }
            case 6: {
                if (this.isUnityDemoModeEnabled()) break;
                this.setActiveMenuPage(19);
                break;
            }
            case 5: {
                this.setGameMode(2);
                if (n == 6) {
                    this.setActiveMenuPage(5);
                    break;
                }
                if (n == 3) {
                    if (this.isSoundEnabled()) {
                        this.playSound(0, 0);
                    }
                    this.setActiveMenuPage(5);
                    break;
                }
                if (n == 2) {
                    if (this.isMultiLanguage() && TextHandler.getLanguage() == -1 && !this.showMultiLanguageOptions() || !this.isMultiLanguage()) {
                        TextHandler.setLanguage(0);
                    }
                    if (this.isMultiLanguage() && TextHandler.getLanguage() == -1) {
                        this.setActiveMenuPage(0);
                        break;
                    }
                    this.setActiveMenuPage(1);
                    break;
                }
                if (n == 10) {
                    this.playSound(0, 0);
                    this.setActiveMenuPage(13);
                    break;
                }
                if (n == 11) {
                    this.setActiveMenuPage(1);
                    break;
                }
                if (n != 12) break;
                this.setActiveMenuPage(this.getPauseSplashPreviousMenuPageId());
                break;
            }
            case 8: {
                if (n == 9 || n != 7) break;
                this.stopSound(0);
                if (JQ2009Game.MultiPlayermode <= 0 && this.getCurrentLevel() != 0) {
                    this.setPositiveSoftkey(this.getPowerupSoftkey());
                } else {
                    this.setPositiveSoftkey(null);
                }
                this.setNegativeSoftkey(this.getPauseSoftKey());
                this.resumeJQ2009Game();
                break;
            }
            case 9: {
                if (n != 7) {
                    this.resetActiveMenuPage();
                    this.popScroll();
                    if (n == 5) {
                        this.destroyMainMenu();
                    }
                    this.pushLoadEvent(6);
                    this.pushLoadEvent(7);
                    this.pushLoadEvent(8);
                    this.pushLoadEvent(10);
                    this.pushLoadEvent(9);
                }
                this.stopSound(0);
                this.setPositiveSoftkey(null);
                this.setNegativeSoftkey(null);
                break;
            }
        }
    }

    public final void pushLoadEvent(int n) {
        int n2;
        int n3;
        this.loadAborted = false;
        if (this.loadQueueSize == 0) {
            this.stopAllSounds();
            this.loadID = new int[10];
            this.loadQueueHead = 0;
            this.totalQueueSize = 0;
        }
        if (this.loadQueueSize == (n3 = this.loadID.length)) {
            n2 = n3 - this.loadQueueHead;
            int[] nArray = new int[n3 + 10];
            System.arraycopy(this.loadID, this.loadQueueHead, nArray, 0, n2);
            System.arraycopy(this.loadID, 0, nArray, n2, this.loadQueueHead);
            this.loadID = nArray;
            this.loadQueueHead = 0;
            n3 += 10;
        }
        n2 = (this.loadQueueHead + this.loadQueueSize) % n3;
        this.loadID[n2] = n;
        ++this.loadQueueSize;
        ++this.totalQueueSize;
    }

    public final void clearLoadEvents() {
        this.baseFraction += FixedPoint12.divide(FixedPoint12.multiply(4096 - this.baseFraction, this.totalQueueSize - this.loadQueueSize << 12), this.totalQueueSize << 12);
        this.loadAborted = true;
        this.loadQueueSize = 0;
    }

    public final int getLoadingProgress() {
        if (this.totalQueueSize == 0) {
            return -4096;
        }
        int n = FixedPoint12.divide(this.totalQueueSize - this.loadQueueSize << 12, this.totalQueueSize << 12);
        if (this.baseFraction == 0) {
            return n;
        }
        if (this.loadAborted) {
            return this.baseFraction;
        }
        return this.baseFraction + FixedPoint12.multiply(4096 - this.baseFraction, n);
    }

    public final boolean isLoadingPaused() {
        return this.loadingPaused;
    }

    public final void setLoadingPaused(boolean bl) {
        this.loadingPaused = bl;
    }

    public final boolean processLoadEvent(int n) {
        boolean bl = true;
        switch (n) {
            case 0: {
                this.loadTextSection(0);
                break;
            }
            case 17: {
                this.loadData();
                break;
            }
            case 2: {
                this.loadSounds();
                break;
            }
            case 16: {
                TextHandler.loadLanguageManifest();
                this.initFonts();
                this.setDebugFont(new Font(72));
                this.setSharedFont(new Font(72));
                this.setBaseFont(new Font(74));
                this.setDigitFont(new Font(73));
                this.setSoftkeyFont(new Font(432));
                break;
            }
            case 5: {
                this.createMenu();
                break;
            }
            case 1: {
                int n2;
                this.setRandom(new Random());
                this.setSoundEnabled(false);
                this.setTutorialEnabled(true);
                this.addCheat(CHEAT_WIN);
                this.addCheat(CHEAT_WIN_C);
                this.addCheat(CHEAT_COIN);
                this.addCheat(CHEAT_LOSE);
                this.addCheat(CHEAT_TIME_DECREASE);
                this.addCheat(CHEAT_UNLOCK_LEVELS);
                this.addCheat(CHEAT_UNLOCK_AWARDS);
                for (n2 = 1; n2 < 10; ++n2) {
                    String string = CHEAT_ADD_SCORE + Integer.toString(n2);
                    this.addCheat(string);
                }
                this.addCheat(CHEAT_ADD_JEWELS);
                for (n2 = 0; n2 < this.getChaptersCount(); ++n2) {
                    for (int i = 1; i < this.getChapterLevelCount(n2) + 1; ++i) {
                        String string = CHEAT_JUMP_TO_LEVEL + (n2 + 1) + "" + (i < 10 ? "0" + Integer.toString(i) : Integer.toString(i));
                        this.addCheat(string);
                    }
                }
                this.addCheat(CHEAT_TEXT);
                this.addCheat(RESET_UNITY_CHEAT);
                TextHandler.setLanguage(-1);
                this.enableTextEntryFunctionality();
                this.setMaximumTextLength(10);
                this.resetGame();
                break;
            }
            case 15: {
                this.setOkSoftKey(SpecialSymbol.get(0));
                this.setBackSoftKey(SpecialSymbol.get(4));
                this.setSelectSoftKey(SpecialSymbol.get(0));
                this.setYesSoftKey(SpecialSymbol.get(0));
                this.setNoSoftKey(SpecialSymbol.get(1));
                this.setExitSoftKey(SpecialSymbol.get(1));
                this.setPauseSoftKey(SpecialSymbol.get(5));
                this.setDeleteSoftKey(SpecialSymbol.get(2));
                this.setMenuSoftKey(SpecialSymbol.get(10));
                this.setCancelSoftKey(SpecialSymbol.get(1));
                this.setScrollSoftkey(SpecialSymbol.get(8));
                this.setSkipSoftkey(SpecialSymbol.get(9));
                this.setPowerupSoftkey(SpecialSymbol.get(11));
                this.setUpArrow(SpecialSymbol.get(7));
                this.setDownArrow(SpecialSymbol.get(8));
                break;
            }
            case 13: {
                this.loadGameState();
                break;
            }
            case 14: {
                this.loadOptions();
                break;
            }
            case 3: {
                this.initMainMenu();
            }
            case 4: {
                bl = this.processMainMenuLoadEvent();
                break;
            }
            case 11: {
                this.saveGameState(-1);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                try {
                    bl = this.processJQ2009GameLoadEvent(n);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.errorMessage = throwable.getMessage();
                }
                break;
            }
            case 12: {
                this.processLoadEventConnectivity();
            }
        }
        return bl;
    }

    protected void resetGame() {
        this.setUnlockLevels(false);
        this.setQuickModeMaxLevel(0);
        this.setCurrentLevel(0);
        this.setCoins(0);
        this.setStoryCoins(0);
        this.setScore(0);
        this.setUnlockAwards(true);
        this.setHighScoreNames(new char[10][]);
        this.setHighScores(new int[10]);
        this.addHighScore(this.getText(65749), 200000);
        this.addHighScore(this.getText(65750), 180000);
        this.addHighScore(this.getText(65751), 160000);
        this.addHighScore(this.getText(65752), 140000);
        this.addHighScore(this.getText(65753), 120000);
        this.addHighScore(this.getText(65754), 100000);
        this.addHighScore(this.getText(65755), 80000);
        this.addHighScore(this.getText(65756), 60000);
        this.addHighScore(this.getText(65757), 40000);
        this.addHighScore(this.getText(65758), 20000);
        this.setUserName(new char[0]);
        this.resetAwards();
        this.resetStats();
        this.resetTutorial();
    }

    public void resetTutorial() {
        for (int i = 0; i < this.getTutorials().length; ++i) {
            this.setTutorials(i, true);
        }
        this.setSpecialMatches(false);
        this.setYourTurn(false);
    }

    public MenuPage menuPageChanged(int n, int n2) {
        int n3 = this.getGameState();
        MenuPage menuPage = null;
        MenuPage menuPage2 = this.getMenuPage();
        if (n3 == 2 || n3 == 3 || n3 == 4 || n3 == 5 || n3 == 6) {
            menuPage = this.mainMenuPageChanged(n, n2);
        } else if (n3 == 7 || n3 == 9) {
            menuPage = this.pauseMenuPageChanged(n, n2);
        } else if (n3 == 12) {
            this.setMenuPage(2, 2, null, null, -3, null, -3);
            int n4 = 65715;
            this.addMenuPageItem(2, 0, this.getText(n4), null, -1);
            menuPage = this.finalizeMenuPage();
        }
        this.menuRendererPageChanged(menuPage, menuPage2);
        if (n == 5 && n3 != 5) {
            this.setGameState(5);
        }
        return menuPage;
    }

    public void menuPageScrolled(MenuPage menuPage, int n) {
        int n2 = this.getGameState();
        if (n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6) {
            this.mainMenuPageScrolled(menuPage, n);
        } else if (n2 == 7 || n2 == 9) {
            this.pauseMenuPageScrolled(menuPage, n);
        }
    }

    public void menuItemPressed(MenuPage menuPage, int n) {
        int n2 = this.getGameState();
        if (n2 == 5 || n2 == 6) {
            this.mainMenuItemPressed(menuPage, n);
        } else if (n2 == 7) {
            this.pauseMenuMenuItemPressed(menuPage, n);
        } else if (n2 == 12) {
            this.popGameState();
            int n3 = this.getActiveMenuPageId();
            if (n3 != 3 && n3 != 4 && n3 != 1 && this.isSoundEnabled()) {
                this.playSound(0, 0);
            }
        }
    }

    public void menuPageTimedOut(MenuPage menuPage, int n) {
        int n2 = this.getGameState();
        if (n2 == 5 || n2 == 6) {
            this.mainMenuPageTimedOut(n);
        }
    }

    public void menuPageTimerTicked(MenuPage menuPage, int n) {
        int n2 = this.getGameState();
        if (n2 == 5 || n2 == 6) {
            this.mainMenuPageTimerTicked(n);
        }
    }

    public void menuSoftkeyPressed(MenuPage menuPage, int n, Object object) {
        int n2 = this.getGameState();
        if (n2 == 5 || n2 == 6) {
            this.mainMenuSoftkeyPressed(menuPage, n, object);
        } else if (n2 == 7) {
            this.pauseMenuMenuSoftkeyPressed(n, object);
        }
    }

    public final void initFonts() {
        Font.setExtendedCharHandler(this);
        Font.overloadFonts(new int[]{72}, "/proportionalplainlarge.font", "/proportionalplainlarge.png");
        Font.overloadFonts(new int[]{74}, "/basefont.font", "/basefont.png");
        Font.overloadFonts(new int[]{73}, "/digits2.font", "/digits2.png");
        Font.overloadFonts(new int[]{432}, "/skfont.font", "/skfont.png");
    }

    public final int drawExtendedChar(Graphics graphics, Font font, char c, int n, int n2) {
        int n3 = 0;
        return n3;
    }

    public final void renderSoftKeysBG(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5 = JQ2009Game.mSkbarSpac.getFrameRect(2)[2];
        int n6 = JQ2009Game.mSkbarSpac.getFrameRect(4)[2];
        int n7 = n3 - n6 - (n4 = JQ2009Game.mSkbarSpac.getFrameRect(5)[2]);
        if (n7 > 0) {
            for (int i = 0; i < n7 / n5 + 1; ++i) {
                JQ2009Game.mSkbarSpac.renderFrame(graphics, 2, -1, n + n6 + i * n5, n2);
            }
        }
        JQ2009Game.mSkbarSpac.renderFrame(graphics, 4, -1, n, n2);
        JQ2009Game.mSkbarSpac.renderFrame(graphics, 5, -1, n + n3, n2);
        JQ2009Game.mSkbarSpac.renderFrame(graphics, 6, -1, n + n3 / 2, n2);
    }

    public final void renderSoftKeys(Graphics graphics, char[] cArray, char[] cArray2) {
        Font font = this.getSoftkeyFont();
        int n = this.screenHeight - this.getSoftKeyBarSize() + (this.getSoftKeyBarSize() - font.getHeight() >> 1);
        int n2 = 0;
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.getGameState() == 8 && this.getJQ2009GameState() == 7) {
            graphics.setColor(227, 202, 165);
            graphics.fillRect(0, this.screenHeight - this.getSoftKeyBarSize(), this.screenWidth, this.getSoftKeyBarSize());
            if (JQ2009Game.mSkbarSpac != null) {
                this.renderSoftKeysBG(graphics, 0, this.screenHeight, this.screenWidth);
            }
            boolean bl = false;
        } else {
            graphics.setColor(227, 202, 165);
            graphics.fillRect(0, this.screenHeight - this.getSoftKeyBarSize(), this.screenWidth, this.getSoftKeyBarSize());
            if (JQ2009Game.mSkbarSpac != null) {
                this.renderSoftKeysBG(graphics, 0, this.screenHeight, this.screenWidth);
            }
        }
        if (cArray != null) {
            font.drawChars(graphics, cArray, 0, cArray.length, 10, n - n2, 20);
        }
        if (cArray2 != null) {
            font.drawChars(graphics, cArray2, 0, cArray2.length, this.screenWidth - font.charsWidth(cArray2, 0, cArray2.length) - 10, n - n2, 20);
        }
    }

    public final int renderTitle(Graphics graphics, int n) {
        int n2 = 0;
        if (this.getTitleImage() != null) {
            graphics.drawImage(this.getTitleImage(), this.screenWidth >> 1, n, 17);
            n2 = this.getTitleImage().getHeight() + 4;
        }
        return n2;
    }

    protected final String getApplicationVersion() {
        String string = Gamelet.getGamelet().getAppProperty("MIDlet-Version");
        if (string == null) {
            string = "?.?.?";
        }
        return string;
    }

    protected final String getApplicationVendor() {
        String string = Gamelet.getGamelet().getAppProperty("MIDlet-Vendor");
        if (string == null) {
            string = "??";
        }
        return string;
    }

    protected final String getApplicationName() {
        String string = Gamelet.getGamelet().getAppProperty("MIDlet-Name");
        if (string == null) {
            string = "??";
        }
        return string;
    }

    public static final DataInputStream openFile(String string) {
        return new DataInputStream(JQ2009GameCanvas.openStream(string));
    }

    public static final InputStream openStream(String string) {
        return ((Object)((Object)Gamelet.getGamelet())).getClass().getResourceAsStream(string);
    }

    protected final Font getSharedFont() {
        return this.sharedFont;
    }

    private final void setSharedFont(Font font) {
        this.sharedFont = font;
    }

    protected final Font getAuxFont() {
        return this.auxFont;
    }

    private final void setAuxFont(Font font) {
        this.auxFont = font;
    }

    protected final Font getBaseFont() {
        return this.baseFont;
    }

    private final void setBaseFont(Font font) {
        this.baseFont = font;
    }

    protected final char[] getBackSoftKey() {
        return this.backSoftKey;
    }

    private void setBackSoftKey(char[] cArray) {
        this.backSoftKey = cArray;
    }

    protected final char[] getExitSoftKey() {
        return this.exitSoftKey;
    }

    private void setExitSoftKey(char[] cArray) {
        this.exitSoftKey = cArray;
    }

    protected final char[] getNoSoftKey() {
        return this.noSoftKey;
    }

    private void setNoSoftKey(char[] cArray) {
        this.noSoftKey = cArray;
    }

    protected final char[] getOkSoftKey() {
        return this.okSoftKey;
    }

    private void setOkSoftKey(char[] cArray) {
        this.okSoftKey = cArray;
    }

    protected final char[] getSelectSoftKey() {
        return this.selectSoftKey;
    }

    private void setSelectSoftKey(char[] cArray) {
        this.selectSoftKey = cArray;
    }

    protected final char[] getYesSoftKey() {
        return this.yesSoftKey;
    }

    private void setYesSoftKey(char[] cArray) {
        this.yesSoftKey = cArray;
    }

    protected final char[] getPauseSoftKey() {
        return this.pauseSoftKey;
    }

    private void setPauseSoftKey(char[] cArray) {
        this.pauseSoftKey = cArray;
    }

    protected final char[] getUserName() {
        return this.userName;
    }

    protected final void setUserName(char[] cArray) {
        this.userName = cArray;
    }

    protected final char[] getDeleteSoftKey() {
        return this.deleteSoftKey;
    }

    private void setDeleteSoftKey(char[] cArray) {
        this.deleteSoftKey = cArray;
    }

    protected final Image getIplaySplash() {
        return this.iplaySplash;
    }

    protected final void setIplaySplash(Image image) {
        this.iplaySplash = image;
    }

    protected final char[] getMenuSoftKey() {
        return this.menuSoftKey;
    }

    private void setMenuSoftKey(char[] cArray) {
        this.menuSoftKey = cArray;
    }

    protected final char[] getCancelSoftKey() {
        return this.cancelSoftKey;
    }

    private void setCancelSoftKey(char[] cArray) {
        this.cancelSoftKey = cArray;
    }

    protected final Image getTitleImage() {
        return this.titleImage;
    }

    protected final void setTitleImage(Image image) {
        this.titleImage = image;
    }

    private int getPauseSplashPreviousMenuPageId() {
        return this.pauseSplashPreviousMenuPageId;
    }

    private void setPauseSplashPreviousMenuPageId(int n) {
        this.pauseSplashPreviousMenuPageId = n;
    }

    protected final char[] getDownArrow() {
        return this.downArrow;
    }

    private void setDownArrow(char[] cArray) {
        this.downArrow = cArray;
    }

    protected final char[] getUpArrow() {
        return this.upArrow;
    }

    private void setUpArrow(char[] cArray) {
        this.upArrow = cArray;
    }

    public char[] getScrollSoftkey() {
        return null;
    }

    public void setScrollSoftkey(char[] cArray) {
        this.scrollSoftkey = cArray;
    }

    protected Image getCommonSplash() {
        return this.commonSplash;
    }

    protected void setCommonSplash(Image image) {
        this.commonSplash = image;
    }

    protected final Random getRandom() {
        return this.random;
    }

    private void setRandom(Random random) {
        this.random = random;
    }

    public Font getDigitFont() {
        return this.digitFont;
    }

    public void setDigitFont(Font font) {
        this.digitFont = font;
    }

    public Font getSoftkeyFont() {
        return this.softkeyFont;
    }

    public void setSoftkeyFont(Font font) {
        this.softkeyFont = font;
    }

    protected final char[] getSkipSoftkey() {
        return this.skipSoftkey;
    }

    private void setSkipSoftkey(char[] cArray) {
        this.skipSoftkey = cArray;
    }

    public char[] getPowerupSoftkey() {
        return this.powerupSoftkey;
    }

    public void setPowerupSoftkey(char[] cArray) {
        this.powerupSoftkey = cArray;
    }

    public final void processClrKey() {
        int n = this.getGameState();
        block0 : switch (n) {
            case 12: {
                this.stop();
                break;
            }
            case 7: {
                int n2 = this.getActiveMenuPageId();
                switch (n2) {
                    case 47: {
                        this.resumeGame();
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 54: {
                        this.setActiveMenuPage(47);
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 60: {
                        this.setActiveMenuPage(50);
                        break;
                    }
                }
            }
            case 5: {
                int n2 = this.getActiveMenuPageId();
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 29: {
                        this.stop();
                        break block0;
                    }
                    case 5: {
                        this.setActiveMenuPage(24);
                        break block0;
                    }
                    case 28: {
                        if (this.getTextEntryText().length > 0) {
                            this.deleteTextEntryCharacter();
                            break block0;
                        }
                        this.setActiveMenuPage(5);
                        break block0;
                    }
                    case 6: 
                    case 10: 
                    case 13: 
                    case 18: 
                    case 20: 
                    case 24: 
                    case 27: 
                    case 55: {
                        this.setActiveMenuPage(5);
                        break block0;
                    }
                    case 11: 
                    case 12: {
                        this.setActiveMenuPage(10);
                        break block0;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 60: {
                        this.setActiveMenuPage(20);
                        break block0;
                    }
                    case 8: {
                        this.setActiveMenuPage(6);
                        break block0;
                    }
                    case 7: {
                        this.setActiveMenuPage(6);
                        break block0;
                    }
                    case 9: {
                        this.setActiveMenuPage(8);
                        break block0;
                    }
                    case 15: 
                    case 26: {
                        this.setActiveMenuPage(13);
                        break block0;
                    }
                }
            }
        }
    }

    public void pointerMoved(int n, int n2, short s) {
    }

    public void flushRMS() {
    }

    public void flushRMSOnExit() {
    }

    static {
        __fake_state = 0;
        gameStatetest = 0;
        __cheatsTS_index = 0;
    }
}

