/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SpriteX {
    public static final int SPX_HEADER = 1397772888;
    public static final int SPX_VERSION = 33;
    public static final int SPX_BYTE_SEQUENCE_JAVA = 1;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int ANTICLOCKWISE_90 = 0;
    public static final int DEASIL_90 = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_RIGHT = 4;
    public static final int FRAME_HEADER_SIZE = 8;
    public static final int FRAME_TILE_COUNT_BIT = 1;
    public static final int FRAME_COLLISION_COUNT_BIT = 2;
    public static final int FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final int FRAME_TOP_POS_BIT = 4;
    public static final int FRAME_BOTTOM_POS_BIT = 5;
    public static final int FRAME_LEFT_POS_BIT = 6;
    public static final int FRAME_RIGHT_POS_BIT = 7;
    public static final int ACTION_HEADER_SIZE = 4;
    public static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final int ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final int ACTION_TRANSFORM_BIT = 3;
    public static final int COLLISION_INTERSECT = 1;
    public static final int COLLISION_INCLUSION = 2;
    public static final int[][] TRANSFORM_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    public static final int[][] ROTATE_TABLE = new int[][]{{6, 5, 2, 1}, {7, 4, 3, 0}, {4, 7, 0, 3}, {5, 6, 1, 2}, {1, 2, 5, 6}, {0, 3, 4, 7}, {3, 0, 7, 4}, {2, 1, 6, 5}};
    private int[][] a;
    private int a;
    private int[][] b;
    private int b;
    private int[][] c;
    private int c;
    private int d;
    private int e;
    private Image a;
    private int f;
    private int g;
    private boolean a;
    private long a;
    private boolean b;
    private boolean c;

    public SpriteX(String string, Image image) {
        this.loadSpx(string, image);
    }

    public SpriteX(String string, String string2) {
        Image image = null;
        try {
            image = Image.createImage((String)string2);
        }
        catch (IOException iOException) {
            System.out.println("can't load spx image\n");
        }
        this.loadSpx(string, image);
    }

    public void loadSpx(String object, Image image) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            object = this.getClass().getResourceAsStream((String)object);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            int n6 = dataInputStream.readInt();
            if (n6 != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte by = dataInputStream.readByte();
            n6 = by;
            if (by != 33) {
                throw new Exception("version no matching\n");
            }
            byte by2 = dataInputStream.readByte();
            n6 = by2;
            if (by2 != 1) {
                throw new Exception("byte sequence error\n");
            }
            this.c = dataInputStream.readInt();
            this.c = new int[this.c][4];
            for (n5 = 0; n5 < this.c; ++n5) {
                this.c[n5][0] = dataInputStream.readInt();
                this.c[n5][1] = dataInputStream.readInt();
                this.c[n5][2] = dataInputStream.readInt();
                this.c[n5][3] = dataInputStream.readInt();
            }
            this.b = dataInputStream.readInt();
            this.b = new int[this.b][];
            for (n5 = 0; n5 < this.b; ++n5) {
                int n7 = dataInputStream.readInt();
                n6 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                n3 = 8 + (n7 << 2) + (n6 << 2) + (n4 << 1);
                this.b[n5] = new int[n3];
                this.b[n5][0] = n3;
                this.b[n5][1] = n7;
                this.b[n5][2] = n6;
                this.b[n5][3] = n4;
                this.b[n5][4] = dataInputStream.readInt();
                this.b[n5][5] = dataInputStream.readInt();
                this.b[n5][6] = dataInputStream.readInt();
                this.b[n5][7] = dataInputStream.readInt();
                n2 = 8;
                for (n3 = 0; n3 < n7; ++n3) {
                    this.b[n5][n2 + 0] = dataInputStream.readInt();
                    this.b[n5][n2 + 1] = dataInputStream.readInt();
                    this.b[n5][n2 + 2] = dataInputStream.readInt();
                    this.b[n5][n2 + 3] = dataInputStream.readInt();
                    n2 += 4;
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    this.b[n5][n2 + 0] = dataInputStream.readInt();
                    this.b[n5][n2 + 1] = dataInputStream.readInt();
                    this.b[n5][n2 + 2] = dataInputStream.readInt();
                    this.b[n5][n2 + 3] = dataInputStream.readInt();
                    n2 += 4;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    this.b[n5][n2 + 0] = dataInputStream.readInt();
                    this.b[n5][n2 + 1] = dataInputStream.readInt();
                    n2 += 2;
                }
            }
            this.a = dataInputStream.readInt();
            this.a = new int[this.a][];
            for (n5 = 0; n5 < this.a; ++n5) {
                n6 = dataInputStream.readInt();
                byte by3 = dataInputStream.readByte();
                n4 = by3;
                n3 = by3 == 1 ? 4 + (n6 << 1) : n6 + 4;
                this.a[n5] = new int[n3];
                this.a[n5][0] = n3;
                this.a[n5][1] = n6;
                this.a[n5][2] = n4;
                this.a[n5][3] = dataInputStream.readInt();
                n2 = 4;
                if (n4 == 1) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        this.a[n5][n2] = dataInputStream.readInt();
                        this.a[n5][n2 + 1] = dataInputStream.readInt();
                        n2 += 2;
                    }
                    continue;
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    this.a[n5][n2] = dataInputStream.readInt();
                    ++n2;
                }
            }
            this.setImage(image);
            this.a = true;
            ((InputStream)object).close();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public SpriteX(SpriteX spriteX) {
        int n2;
        int n3;
        this.a = spriteX.a;
        this.b = spriteX.b;
        this.c = spriteX.c;
        this.a = new int[this.a][];
        this.b = new int[this.b][];
        this.c = new int[this.c][];
        for (n3 = 0; n3 < this.a; ++n3) {
            n2 = spriteX.a[n3][0];
            this.a[n3] = new int[n2];
            System.arraycopy(spriteX.a[n3], 0, this.a[n3], 0, n2);
        }
        for (n3 = 0; n3 < this.b; ++n3) {
            n2 = spriteX.b[n3][0];
            this.b[n3] = new int[n2];
            System.arraycopy(spriteX.b[n3], 0, this.b[n3], 0, n2);
        }
        for (n3 = 0; n3 < this.c; ++n3) {
            this.c[n3] = new int[4];
            System.arraycopy(spriteX.c[n3], 0, this.c[n3], 0, 4);
        }
        this.d = spriteX.d;
        this.e = spriteX.e;
        this.a = spriteX.a;
        this.f = spriteX.f;
        this.g = spriteX.g;
        this.a = spriteX.a;
        this.a = spriteX.a;
        this.b = spriteX.b;
        this.c = spriteX.c;
    }

    public void enableUpdate(boolean bl) {
        if (this.c && bl) {
            this.a = System.currentTimeMillis();
        }
        this.c = !bl;
    }

    public boolean isEnableUpdate() {
        return !this.c;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.a = image;
    }

    public Image getImage() {
        return this.a;
    }

    public void setAction(int n2) {
        if (n2 < 0 || n2 >= this.a) {
            throw new IndexOutOfBoundsException();
        }
        this.d = n2;
        this.e = 0;
        this.b = false;
    }

    public int getAction() {
        return this.d;
    }

    public int getActionCount() {
        return this.a;
    }

    public void setFrame(int n2) {
        if (n2 < 0 || n2 >= this.getSequenceLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.e = n2;
        this.b = false;
    }

    public int getFrame() {
        return this.e;
    }

    public void setTransform(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException();
        }
        this.a[this.d][3] = n2;
    }

    public int getTransform() {
        return this.a[this.d][3];
    }

    public void deasilRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][1]);
    }

    public void nextFrame() {
        this.e = (this.e + 1) % this.getSequenceLength();
        this.b = false;
    }

    public void prevFrame() {
        this.e = this.e == 0 ? this.getSequenceLength() - 1 : --this.e;
        this.b = false;
    }

    public void update(long l2) {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (this.isDelay()) {
            int n2;
            if (!this.b) {
                this.b = true;
                this.a = l2;
            }
            if (l2 - this.a >= (long)(n2 = this.getDelayTime())) {
                this.nextFrame();
                this.a = l2;
            }
            return;
        }
        if (!this.b) {
            this.b = true;
            this.a = l2;
        }
        if (l2 - this.a >= 0L) {
            this.nextFrame();
            this.a = l2;
        }
    }

    public void update() {
        if (!this.isEnableUpdate()) {
            return;
        }
        this.update(System.currentTimeMillis());
    }

    public int[] getActionData(int n2) {
        return this.a[n2];
    }

    public int getSequenceFrame(int n2) {
        if (this.isDelay()) {
            return this.a[this.d][4 + (n2 << 1)];
        }
        return this.a[this.d][n2 + 4];
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.a[this.d][4 + (this.e << 1)];
        }
        return this.a[this.d][4 + this.e];
    }

    public int getSequenceLength() {
        return this.a[this.d][1];
    }

    public boolean isDelay() {
        return this.a[this.d][2] == 1;
    }

    public int getDelayTime() {
        return this.a[this.d][4 + (this.e << 1) + 1];
    }

    public int getReferencePointX(int n2) {
        int n3 = this.getSequenceFrame();
        int n4 = this.b[n3][1];
        int n5 = this.b[n3][2];
        n2 = 8 + (n4 << 2) + (n5 << 2) + (n2 << 1);
        n2 = this.b[n3][n2];
        return SpriteX.a(n2, this.getTransform()) + this.f;
    }

    public int getReferencePointY(int n2) {
        int n3 = this.getSequenceFrame();
        int n4 = this.b[n3][1];
        int n5 = this.b[n3][2];
        n2 = 8 + (n4 << 2) + (n5 << 2) + (n2 << 1);
        n2 = this.b[n3][n2 + 1];
        return SpriteX.b(n2, this.getTransform()) + this.g;
    }

    public int getReferencePointXFrame(int n2, int n3) {
        int n4 = this.b[n3][1];
        int n5 = this.b[n3][2];
        n2 = 8 + (n4 << 2) + (n5 << 2) + (n2 << 1);
        n2 = this.b[n3][n2];
        return SpriteX.a(n2, this.getTransform()) + this.f;
    }

    public int getReferencePointYFrame(int n2, int n3) {
        int n4 = this.b[n3][1];
        int n5 = this.b[n3][2];
        n2 = 8 + (n4 << 2) + (n5 << 2) + (n2 << 1);
        n2 = this.b[n3][n2 + 1];
        return SpriteX.b(n2, this.getTransform()) + this.g;
    }

    public int getReferencePointCount(int n2) {
        if (n2 < 0 && n2 >= this.b) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.b[n2][3];
        return n3;
    }

    public int getReferencePointCount() {
        int n2 = this.getSequenceFrame();
        return this.getReferencePointCount(n2);
    }

    private static int a(int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = n2;
                break;
            }
            case 2: {
                n4 = -n2;
            }
        }
        return n4;
    }

    private static int b(int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = n2;
                break;
            }
            case 2: {
                n4 = n2;
            }
        }
        return n4;
    }

    public int getCollidesX(int n2) {
        int n3 = this.getSequenceFrame();
        if (n2 < 0 || n2 >= this.b[n3][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 = 8 + (this.b[n3][1] << 2) + (n2 << 2);
        return this.b[n3][n2] + this.f;
    }

    public int getCollidesY(int n2) {
        int n3 = this.getSequenceFrame();
        if (n2 < 0 || n2 >= this.b[n3][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 = 8 + (this.b[n3][1] << 2) + (n2 << 2) + 1;
        return this.b[n3][n2] + this.g;
    }

    public int getCollidesWidth(int n2) {
        int n3 = this.getSequenceFrame();
        if (n2 < 0 || n2 >= this.b[n3][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 = 8 + (this.b[n3][1] << 2) + (n2 << 2) + 2;
        return this.b[n3][n2];
    }

    public int getCollidesHeight(int n2) {
        int n3 = this.getSequenceFrame();
        if (n2 < 0 || n2 >= this.b[n3][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 = 8 + (this.b[n3][1] << 2) + (n2 << 2) + 3;
        return this.b[n3][n2];
    }

    public int getCollidesCount(int n2) {
        return this.b[n2][2];
    }

    public int getCollidesCount() {
        return this.b[this.getSequenceFrame()][2];
    }

    public boolean collidesWith(SpriteX spriteX, int n2, int n3, int n4) {
        if (!spriteX.a || !this.a) {
            return false;
        }
        int n5 = spriteX.getCollidesX(n2);
        int n6 = spriteX.getCollidesY(n2);
        int n7 = spriteX.getCollidesWidth(n2);
        int n8 = spriteX.getCollidesHeight(n2);
        return this.collidesWith(n5, n6, n7, n8, n3, n4);
    }

    public boolean collidesWith(Image image, int n2, int n3, int n4, int n5) {
        return this.collidesWith(n2, n3, image.getWidth(), image.getHeight(), n4, n5);
    }

    public boolean collidesWith(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.a) {
            return false;
        }
        int n8 = this.getCollidesX(n6);
        int n9 = this.getCollidesY(n6);
        int n10 = this.getCollidesWidth(n6);
        int n11 = this.getCollidesHeight(n6);
        if (n7 == 1) {
            return SpriteX.intersectRect(n8, n9, n10, n11, n2, n3, n4, n5);
        }
        if (n7 == 2) {
            return SpriteX.inclusionRect(n8, n9, n10, n11, n2, n3, n4, n5);
        }
        throw new ArithmeticException();
    }

    public boolean collidesWith(SpriteX spriteX) {
        if (!spriteX.a || !this.a) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spriteX.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spriteX, 0, 0, 1);
    }

    public boolean collidesWith(Image image, int n2, int n3) {
        if (!this.a) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, n2, n3, 0, 1);
    }

    public boolean collidesWith(int n2, int n3, int n4, int n5) {
        if (!this.a) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(n2, n3, n4, n5, 0, 1);
    }

    public static boolean intersectRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return n7 + n9 >= n3 && n7 <= n3 + n5 && n6 + n8 >= n2 && n6 <= n2 + n4;
    }

    public static boolean inclusionRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return n7 >= n3 && n7 + n9 <= n3 + n5 && n6 >= n2 && n6 + n8 <= n2 + n4;
    }

    public void setPosition(int n2, int n3) {
        this.f = n2;
        this.g = n3;
    }

    public void setX(int n2) {
        this.f = n2;
    }

    public void setY(int n2) {
        this.g = n2;
    }

    public void move(int n2, int n3) {
        this.f += n2;
        this.g += n3;
    }

    public int getX() {
        return this.f;
    }

    public int getY() {
        return this.g;
    }

    public int getFrameTopPos() {
        return this.b[this.getSequenceFrame()][4] + this.g;
    }

    public int getFrameBottomPos() {
        return this.b[this.getSequenceFrame()][5] + this.g;
    }

    public int getFrameLeftPos() {
        return this.b[this.getSequenceFrame()][6] + this.f;
    }

    public int getFrameRightPos() {
        return this.b[this.getSequenceFrame()][7] + this.f;
    }

    public int getFrameWidth() {
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public int getFrameHeight() {
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    public void setVisible(boolean bl) {
        this.a = bl;
    }

    public boolean isVisible() {
        return this.a;
    }

    public void paintTile(Graphics graphics, int n2, int n3, int n4) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            SpriteX.drawRegion(graphics, this.a, this.c[n4][0], this.c[n4][1], this.c[n4][2], this.c[n4][3], 0, n2 + this.f, n3 + this.g, 20);
        }
    }

    public void paintTileInFrame(Graphics graphics, int n2, int n3, int n4) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            int n9 = this.getTransform();
            if (n9 == 0) {
                int n10 = this.getSequenceFrame();
                int n11 = this.b[n10][1];
                int n12 = 8;
                for (int i2 = 0; i2 < n11; ++i2) {
                    int n13 = this.b[n10][n12 + 0];
                    int n14 = this.b[n10][n12 + 1] + n2;
                    int n15 = this.b[n10][n12 + 2] + n3;
                    int n16 = this.b[n10][n12 + 3];
                    int n17 = this.c[n13][0];
                    int n18 = this.c[n13][1];
                    int n19 = this.c[n13][2];
                    int n20 = this.c[n13][3];
                    if (SpriteX.intersectRect(n14, n15, n19, n20, n5, n6, n7, n8) && n13 == n4) {
                        SpriteX.drawRegion(graphics, this.a, n17, n18, n19, n20, n16, n14, n15, 20);
                    }
                    n12 += 4;
                }
                return;
            }
            int n21 = this.getSequenceFrame();
            int n22 = this.b[n21][1];
            int n23 = 8;
            for (int i3 = 0; i3 < n22; ++i3) {
                int n24 = this.b[n21][n23 + 0];
                int n25 = this.b[n21][n23 + 1] + n2;
                int n26 = this.b[n21][n23 + 2] + n3;
                int n27 = this.b[n21][n23 + 3];
                int n28 = this.c[n24][0];
                int n29 = this.c[n24][1];
                int n30 = this.c[n24][2];
                int n31 = this.c[n24][3];
                int n32 = n2 - n25;
                int n33 = n3 - n26;
                n27 = TRANSFORM_TABLE[n27][n9];
                switch (n9) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n25 = n2 - (n31 - n33);
                        n26 = n3 - n32;
                        break;
                    }
                    case 3: {
                        n25 = n2 - (n30 - n32);
                        n26 = n3 - (n31 - n33);
                        break;
                    }
                    case 6: {
                        n25 = n2 - n33;
                        n26 = n3 - (n30 - n32);
                        break;
                    }
                    case 2: {
                        n25 = n2 - (n30 - n32);
                        break;
                    }
                    case 7: {
                        n25 = n2 - (n31 - n33);
                        n26 = n3 - (n30 - n32);
                        break;
                    }
                    case 1: {
                        n26 = n3 - (n31 - n33);
                        break;
                    }
                    case 4: {
                        n25 = n2 - n33;
                        n26 = n3 - n32;
                    }
                }
                if (SpriteX.intersectRect(n25, n26, n30, n31, n5, n6, n7, n8) && n24 == n4) {
                    SpriteX.drawRegion(graphics, this.a, n28, n29, n30, n31, n27, n25, n26, 20);
                }
                n23 += 4;
            }
        }
    }

    public void paintAlphaFrame(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n6 = graphics.getClipX();
            int n7 = graphics.getClipY();
            int n8 = graphics.getClipWidth();
            int n9 = graphics.getClipHeight();
            int n10 = this.getTransform();
            if (n10 == 0) {
                int n11 = n4;
                int n12 = this.b[n11][1];
                int n13 = 8;
                for (int i2 = 0; i2 < n12; ++i2) {
                    n4 = this.b[n11][n13 + 0];
                    int n14 = this.b[n11][n13 + 1] + n2;
                    int n15 = this.b[n11][n13 + 2] + n3;
                    int n16 = this.c[n4][0];
                    int n17 = this.c[n4][1];
                    int n18 = this.c[n4][2];
                    if (SpriteX.intersectRect(n14, n15, n18, n4 = this.c[n4][3], n6, n7, n8, n9)) {
                        Soul.draw.drawAlphaImage(graphics, n14, n15, n18, n4, n16, n17, this.a, 0, n5);
                    }
                    n13 += 4;
                }
                return;
            }
            int n19 = n4;
            int n20 = this.b[n19][1];
            n5 = 8;
            for (int i3 = 0; i3 < n20; ++i3) {
                n4 = this.b[n19][n5 + 0];
                int n21 = this.b[n19][n5 + 1] + n2;
                int n22 = this.b[n19][n5 + 2] + n3;
                int n23 = this.c[n4][0];
                int n24 = this.c[n4][1];
                int n25 = this.c[n4][2];
                n4 = this.c[n4][3];
                int n26 = n2 - n21;
                int n27 = n3 - n22;
                switch (n10) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - n26;
                        break;
                    }
                    case 3: {
                        n21 = n2 - (n25 - n26);
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 6: {
                        n21 = n2 - n27;
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 2: {
                        n21 = n2 - (n25 - n26);
                        break;
                    }
                    case 7: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 1: {
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 4: {
                        n21 = n2 - n27;
                        n22 = n3 - n26;
                    }
                }
                if (SpriteX.intersectRect(n21, n22, n25, n4, n6, n7, n8, n9)) {
                    Soul.draw.drawAlphaImage(graphics, n21, n22, n25, n4, n23, n24, this.a, 0, 100);
                }
                n5 += 4;
            }
        }
    }

    public void paintLightenFrame(Graphics graphics, int n2, int n3, int n4) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            int n9 = this.getTransform();
            if (n9 == 0) {
                int n10 = n4;
                int n11 = this.b[n10][1];
                int n12 = 8;
                for (int i2 = 0; i2 < n11; ++i2) {
                    n4 = this.b[n10][n12 + 0];
                    int n13 = this.b[n10][n12 + 1] + n2;
                    int n14 = this.b[n10][n12 + 2] + n3;
                    int n15 = this.c[n4][0];
                    int n16 = this.c[n4][1];
                    int n17 = this.c[n4][2];
                    if (SpriteX.intersectRect(n13, n14, n17, n4 = this.c[n4][3], n5, n6, n7, n8)) {
                        Soul.draw.drawLightenImage(ECanvas.getInstance().getOffScreenBuffer(), n13, n14, n17, n4, this.a, n15, n16);
                    }
                    n12 += 4;
                }
                return;
            }
            int n18 = this.getSequenceFrame();
            int n19 = this.b[n18][1];
            int n20 = 8;
            for (int i3 = 0; i3 < n19; ++i3) {
                n4 = this.b[n18][n20 + 0];
                int n21 = this.b[n18][n20 + 1] + n2;
                int n22 = this.b[n18][n20 + 2] + n3;
                int n23 = this.c[n4][0];
                int n24 = this.c[n4][1];
                int n25 = this.c[n4][2];
                n4 = this.c[n4][3];
                int n26 = n2 - n21;
                int n27 = n3 - n22;
                switch (n9) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - n26;
                        break;
                    }
                    case 3: {
                        n21 = n2 - (n25 - n26);
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 6: {
                        n21 = n2 - n27;
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 2: {
                        n21 = n2 - (n25 - n26);
                        break;
                    }
                    case 7: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 1: {
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 4: {
                        n21 = n2 - n27;
                        n22 = n3 - n26;
                    }
                }
                if (SpriteX.intersectRect(n21, n22, n25, n4, n5, n6, n7, n8)) {
                    Soul.draw.drawLightenImage(ECanvas.getInstance().getOffScreenBuffer(), n21, n22, n25, n4, this.a, n23, n24);
                }
                n20 += 4;
            }
        }
    }

    public void paintLighten(Graphics graphics, int n2, int n3) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = this.getTransform();
            if (n8 == 0) {
                int n9 = this.getSequenceFrame();
                int n10 = this.b[n9][1];
                int n11 = 8;
                for (int i2 = 0; i2 < n10; ++i2) {
                    int n12 = this.b[n9][n11 + 0];
                    int n13 = this.b[n9][n11 + 1] + n2;
                    int n14 = this.b[n9][n11 + 2] + n3;
                    int n15 = this.c[n12][0];
                    int n16 = this.c[n12][1];
                    int n17 = this.c[n12][2];
                    if (SpriteX.intersectRect(n13, n14, n17, n12 = this.c[n12][3], n4, n5, n6, n7)) {
                        Soul.draw.drawLightenImage(ECanvas.getInstance().getOffScreenBuffer(), n13, n14, n17, n12, this.a, n15, n16);
                    }
                    n11 += 4;
                }
                return;
            }
            int n18 = this.getSequenceFrame();
            int n19 = this.b[n18][1];
            int n20 = 8;
            for (int i3 = 0; i3 < n19; ++i3) {
                int n21 = this.b[n18][n20 + 0];
                int n22 = this.b[n18][n20 + 1] + n2;
                int n23 = this.b[n18][n20 + 2] + n3;
                int n24 = this.c[n21][0];
                int n25 = this.c[n21][1];
                int n26 = this.c[n21][2];
                n21 = this.c[n21][3];
                int n27 = n2 - n22;
                int n28 = n3 - n23;
                switch (n8) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n22 = n2 - (n21 - n28);
                        n23 = n3 - n27;
                        break;
                    }
                    case 3: {
                        n22 = n2 - (n26 - n27);
                        n23 = n3 - (n21 - n28);
                        break;
                    }
                    case 6: {
                        n22 = n2 - n28;
                        n23 = n3 - (n26 - n27);
                        break;
                    }
                    case 2: {
                        n22 = n2 - (n26 - n27);
                        break;
                    }
                    case 7: {
                        n22 = n2 - (n21 - n28);
                        n23 = n3 - (n26 - n27);
                        break;
                    }
                    case 1: {
                        n23 = n3 - (n21 - n28);
                        break;
                    }
                    case 4: {
                        n22 = n2 - n28;
                        n23 = n3 - n27;
                    }
                }
                if (SpriteX.intersectRect(n22, n23, n26, n21, n4, n5, n6, n7)) {
                    Soul.draw.drawLightenImage(ECanvas.getInstance().getOffScreenBuffer(), n22, n23, n26, n21, this.a, n24, n25);
                }
                n20 += 4;
            }
        }
    }

    public void paintAddFrame(Graphics graphics, int n2, int n3, int n4) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            int n9 = this.getTransform();
            if (n9 == 0) {
                int n10 = n4;
                int n11 = this.b[n10][1];
                int n12 = 8;
                for (int i2 = 0; i2 < n11; ++i2) {
                    n4 = this.b[n10][n12 + 0];
                    int n13 = this.b[n10][n12 + 1] + n2;
                    int n14 = this.b[n10][n12 + 2] + n3;
                    int n15 = this.c[n4][0];
                    int n16 = this.c[n4][1];
                    int n17 = this.c[n4][2];
                    if (SpriteX.intersectRect(n13, n14, n17, n4 = this.c[n4][3], n5, n6, n7, n8)) {
                        Soul.draw.drawAddImage(ECanvas.getInstance().getOffScreenBuffer(), n13, n14, n17, n4, this.a, n15, n16);
                    }
                    n12 += 4;
                }
                return;
            }
            int n18 = this.getSequenceFrame();
            int n19 = this.b[n18][1];
            int n20 = 8;
            for (int i3 = 0; i3 < n19; ++i3) {
                n4 = this.b[n18][n20 + 0];
                int n21 = this.b[n18][n20 + 1] + n2;
                int n22 = this.b[n18][n20 + 2] + n3;
                int n23 = this.c[n4][0];
                int n24 = this.c[n4][1];
                int n25 = this.c[n4][2];
                n4 = this.c[n4][3];
                int n26 = n2 - n21;
                int n27 = n3 - n22;
                switch (n9) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - n26;
                        break;
                    }
                    case 3: {
                        n21 = n2 - (n25 - n26);
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 6: {
                        n21 = n2 - n27;
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 2: {
                        n21 = n2 - (n25 - n26);
                        break;
                    }
                    case 7: {
                        n21 = n2 - (n4 - n27);
                        n22 = n3 - (n25 - n26);
                        break;
                    }
                    case 1: {
                        n22 = n3 - (n4 - n27);
                        break;
                    }
                    case 4: {
                        n21 = n2 - n27;
                        n22 = n3 - n26;
                    }
                }
                if (SpriteX.intersectRect(n21, n22, n25, n4, n5, n6, n7, n8)) {
                    Soul.draw.drawAddImage(ECanvas.getInstance().getOffScreenBuffer(), n21, n22, n25, n4, this.a, n23, n24);
                }
                n20 += 4;
            }
        }
    }

    public void paintAdd(Graphics graphics, int n2, int n3) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = this.getTransform();
            if (n8 == 0) {
                int n9 = this.getSequenceFrame();
                int n10 = this.b[n9][1];
                int n11 = 8;
                for (int i2 = 0; i2 < n10; ++i2) {
                    int n12 = this.b[n9][n11 + 0];
                    int n13 = this.b[n9][n11 + 1] + n2;
                    int n14 = this.b[n9][n11 + 2] + n3;
                    int n15 = this.c[n12][0];
                    int n16 = this.c[n12][1];
                    int n17 = this.c[n12][2];
                    if (SpriteX.intersectRect(n13, n14, n17, n12 = this.c[n12][3], n4, n5, n6, n7)) {
                        Soul.draw.drawAddImage(ECanvas.getInstance().getOffScreenBuffer(), n13, n14, n17, n12, this.a, n15, n16);
                    }
                    n11 += 4;
                }
                return;
            }
            int n18 = this.getSequenceFrame();
            int n19 = this.b[n18][1];
            int n20 = 8;
            for (int i3 = 0; i3 < n19; ++i3) {
                int n21 = this.b[n18][n20 + 0];
                int n22 = this.b[n18][n20 + 1] + n2;
                int n23 = this.b[n18][n20 + 2] + n3;
                int n24 = this.c[n21][0];
                int n25 = this.c[n21][1];
                int n26 = this.c[n21][2];
                n21 = this.c[n21][3];
                int n27 = n2 - n22;
                int n28 = n3 - n23;
                switch (n8) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n22 = n2 - (n21 - n28);
                        n23 = n3 - n27;
                        break;
                    }
                    case 3: {
                        n22 = n2 - (n26 - n27);
                        n23 = n3 - (n21 - n28);
                        break;
                    }
                    case 6: {
                        n22 = n2 - n28;
                        n23 = n3 - (n26 - n27);
                        break;
                    }
                    case 2: {
                        n22 = n2 - (n26 - n27);
                        break;
                    }
                    case 7: {
                        n22 = n2 - (n21 - n28);
                        n23 = n3 - (n26 - n27);
                        break;
                    }
                    case 1: {
                        n23 = n3 - (n21 - n28);
                        break;
                    }
                    case 4: {
                        n22 = n2 - n28;
                        n23 = n3 - n27;
                    }
                }
                if (SpriteX.intersectRect(n22, n23, n26, n21, n4, n5, n6, n7)) {
                    Soul.draw.drawAddImage(ECanvas.getInstance().getOffScreenBuffer(), n22, n23, n26, n21, this.a, n24, n25);
                }
                n20 += 4;
            }
        }
    }

    public void paintFrame(Graphics graphics, int n2, int n3, int n4) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            int n9 = this.getTransform();
            if (n9 == 0) {
                int n10 = n4;
                int n11 = this.b[n10][1];
                int n12 = 8;
                for (int i2 = 0; i2 < n11; ++i2) {
                    n4 = this.b[n10][n12 + 0];
                    int n13 = this.b[n10][n12 + 1] + n2;
                    int n14 = this.b[n10][n12 + 2] + n3;
                    int n15 = this.b[n10][n12 + 3];
                    int n16 = this.c[n4][0];
                    int n17 = this.c[n4][1];
                    int n18 = this.c[n4][2];
                    if (SpriteX.intersectRect(n13, n14, n18, n4 = this.c[n4][3], n5, n6, n7, n8)) {
                        SpriteX.drawRegion(graphics, this.a, n16, n17, n18, n4, n15, n13, n14, 20);
                    }
                    n12 += 4;
                }
                return;
            }
            int n19 = this.getSequenceFrame();
            int n20 = this.b[n19][1];
            int n21 = 8;
            for (int i3 = 0; i3 < n20; ++i3) {
                n4 = this.b[n19][n21 + 0];
                int n22 = this.b[n19][n21 + 1] + n2;
                int n23 = this.b[n19][n21 + 2] + n3;
                int n24 = this.b[n19][n21 + 3];
                int n25 = this.c[n4][0];
                int n26 = this.c[n4][1];
                int n27 = this.c[n4][2];
                n4 = this.c[n4][3];
                int n28 = n2 - n22;
                int n29 = n3 - n23;
                n24 = TRANSFORM_TABLE[n24][n9];
                switch (n9) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n22 = n2 - (n4 - n29);
                        n23 = n3 - n28;
                        break;
                    }
                    case 3: {
                        n22 = n2 - (n27 - n28);
                        n23 = n3 - (n4 - n29);
                        break;
                    }
                    case 6: {
                        n22 = n2 - n29;
                        n23 = n3 - (n27 - n28);
                        break;
                    }
                    case 2: {
                        n22 = n2 - (n27 - n28);
                        break;
                    }
                    case 7: {
                        n22 = n2 - (n4 - n29);
                        n23 = n3 - (n27 - n28);
                        break;
                    }
                    case 1: {
                        n23 = n3 - (n4 - n29);
                        break;
                    }
                    case 4: {
                        n22 = n2 - n29;
                        n23 = n3 - n28;
                    }
                }
                if (SpriteX.intersectRect(n22, n23, n27, n4, n5, n6, n7, n8)) {
                    SpriteX.drawRegion(graphics, this.a, n25, n26, n27, n4, n24, n22, n23, 20);
                }
                n21 += 4;
            }
        }
    }

    public void paint(Graphics graphics, int n2, int n3) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.a) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = this.getTransform();
            if (n8 == 0) {
                int n9 = this.getSequenceFrame();
                int n10 = this.b[n9][1];
                int n11 = 8;
                for (int i2 = 0; i2 < n10; ++i2) {
                    int n12 = this.b[n9][n11 + 0];
                    int n13 = this.b[n9][n11 + 1] + n2;
                    int n14 = this.b[n9][n11 + 2] + n3;
                    int n15 = this.b[n9][n11 + 3];
                    int n16 = this.c[n12][0];
                    int n17 = this.c[n12][1];
                    int n18 = this.c[n12][2];
                    if (SpriteX.intersectRect(n13, n14, n18, n12 = this.c[n12][3], n4, n5, n6, n7)) {
                        SpriteX.drawRegion(graphics, this.a, n16, n17, n18, n12, n15, n13, n14, 20);
                    }
                    n11 += 4;
                }
                return;
            }
            int n19 = this.getSequenceFrame();
            int n20 = this.b[n19][1];
            int n21 = 8;
            for (int i3 = 0; i3 < n20; ++i3) {
                int n22 = this.b[n19][n21 + 0];
                int n23 = this.b[n19][n21 + 1] + n2;
                int n24 = this.b[n19][n21 + 2] + n3;
                int n25 = this.b[n19][n21 + 3];
                int n26 = this.c[n22][0];
                int n27 = this.c[n22][1];
                int n28 = this.c[n22][2];
                n22 = this.c[n22][3];
                int n29 = n2 - n23;
                int n30 = n3 - n24;
                n25 = TRANSFORM_TABLE[n25][n8];
                switch (n8) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        n23 = n2 - (n22 - n30);
                        n24 = n3 - n29;
                        break;
                    }
                    case 3: {
                        n23 = n2 - (n28 - n29);
                        n24 = n3 - (n22 - n30);
                        break;
                    }
                    case 6: {
                        n23 = n2 - n30;
                        n24 = n3 - (n28 - n29);
                        break;
                    }
                    case 2: {
                        n23 = n2 - (n28 - n29);
                        break;
                    }
                    case 7: {
                        n23 = n2 - (n22 - n30);
                        n24 = n3 - (n28 - n29);
                        break;
                    }
                    case 1: {
                        n24 = n3 - (n22 - n30);
                        break;
                    }
                    case 4: {
                        n23 = n2 - n30;
                        n24 = n3 - n29;
                    }
                }
                if (SpriteX.intersectRect(n23, n24, n28, n22, n4, n5, n6, n7)) {
                    SpriteX.drawRegion(graphics, this.a, n26, n27, n28, n22, n25, n23, n24, 20);
                }
                n21 += 4;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.f, this.g);
    }

    public static void drawRegion(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        graphics.drawRegion(image, n2, n3, n4, n5, n6, n7, n8, n9);
    }
}

