/*
 * Decompiled with CFR 0.152.
 */
package mappy;

import mappy.AnimBlock;
import mappy.Block;
import mappy.Map;
import mappy.MapHeader;
import mappy.ParameterChecker;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Layer {
    private final MapHeader a;
    private final short[][] a;
    private final Block[] a;
    private final AnimBlock[] a;
    private final int a;
    private final int b;
    private final int c;
    private final int d;

    public Layer(Map map, short[][] sArray) {
        this(map.getMapHeader(), sArray, map.getBlocks(), map.getAnimBlocks());
    }

    public Layer(MapHeader mapHeader, short[][] sArray, Block[] blockArray, AnimBlock[] animBlockArray) {
        ParameterChecker.checkNotNull(mapHeader, "mapHeader");
        ParameterChecker.checkNotNull(sArray, "layerData");
        ParameterChecker.checkNotNull(blockArray, "blocks");
        ParameterChecker.checkNotNull(animBlockArray, "animBlocks");
        this.a = mapHeader;
        this.a = sArray;
        this.a = blockArray;
        this.a = animBlockArray;
        this.a = sArray.length > 0 ? sArray[0].length : 0;
        this.b = sArray.length;
        this.c = mapHeader.getMapPixelWidth();
        this.d = mapHeader.getMapPixelHeight();
    }

    public MapHeader getMapHeader() {
        return this.a;
    }

    public int getWidthInBlocks() {
        return this.a;
    }

    public int getHeightInBlocks() {
        return this.b;
    }

    public int getWidthInPixels() {
        return this.c;
    }

    public int getHeightInPixels() {
        return this.d;
    }

    public short[][] getLayerData() {
        return this.a;
    }

    public Block[] getBlocks() {
        return this.a;
    }

    public AnimBlock[] getAnimBlocks() {
        return this.a;
    }

    public int getBlockIndex(int n2, int n3) {
        ParameterChecker.checkMinMax(n2, "blockX", 0, this.a - 1);
        ParameterChecker.checkMinMax(n3, "blockY", 0, this.b - 1);
        return this.a[n3][n2];
    }

    public void setBlockIndex(int n2, int n3, int n4) {
        ParameterChecker.checkMinMax(n2, "blockX", 0, this.a - 1);
        ParameterChecker.checkMinMax(n3, "blockY", 0, this.b - 1);
        ParameterChecker.checkMinMax(n4, "blockIndex", -this.a.length, this.a.length - 1);
        this.a[n3][n2] = (short)n4;
    }

    public Block getBlock(int n2, int n3) {
        ParameterChecker.checkMinMax(n2, "blockX", 0, this.a - 1);
        ParameterChecker.checkMinMax(n3, "blockY", 0, this.b - 1);
        n2 = this.a[n3][n2];
        if (n2 < 0) {
            AnimBlock animBlock = this.a[-n2 - 1];
            n2 = animBlock.getCurrentFrame();
        }
        ParameterChecker.checkMinMax(n2, "blockIndex", 0, this.a.length - 1);
        return this.a[n2];
    }

    public AnimBlock getAnimBlock(int n2, int n3) {
        int n4 = this.getBlockIndex(n2, n3);
        if (n4 >= 0) {
            throw new IllegalArgumentException("The block at coors [" + n2 + "][" + n3 + "] is not an AnimBlock");
        }
        return this.a[-n4 - 1];
    }

    public boolean isAnimBlock(int n2, int n3) {
        ParameterChecker.checkMinMax(n2, "blockX", 0, this.a - 1);
        ParameterChecker.checkMinMax(n3, "blockY", 0, this.b - 1);
        short s = this.a[n3][n2];
        return s < 0;
    }

    public boolean isCollisionAt(int n2, int n3) {
        return this.getCollisionAt(n2, n3) != -1;
    }

    public int getCollisionAt(int n2, int n3) {
        int n4 = 0;
        int n5 = ((Layer)((Object)block)).a.getBlockWidth();
        int n6 = ((Layer)((Object)block)).a.getBlockHeight();
        n4 = n2 / n5;
        int n7 = n3 / n6;
        Block block = ((Layer)((Object)block)).getBlock(n4, n7);
        n4 = (n2 %= n5) >= n5 / 2 ? 8 : 4;
        n4 = (n3 %= n6) >= n6 / 2 ? (n4 |= 0x20) : (n4 |= 0x10);
        if (!block.getCollisionFlag(n4)) {
            n4 = -1;
        }
        return n4;
    }

    public int getTopCollisionCoor(int n2, int n3, int n4, int n5) {
        ParameterChecker.checkMinMax(n2, "pixelX", 0, this.c - n4);
        ParameterChecker.checkMinMax(n3, "pixelY", 0, this.d - n5);
        ParameterChecker.checkMin(n4, "width", 1);
        ParameterChecker.checkMin(n5, "height", 1);
        int n6 = this.a.getBlockWidth();
        int n7 = this.a.getBlockHeight();
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = n2;
        int n11 = n3;
        n4 = n2 + n4;
        n5 = n3 + n5;
        int n12 = n10 / n6;
        int n13 = n11 / n7;
        int n14 = n4 / n6;
        n2 = n5 / n7;
        n3 = n2 * n7 + n9;
        for (int i2 = n2; i2 >= n13; --i2) {
            int n15 = -1;
            n2 = n12 * n6 + n8;
            for (int i3 = n12; i3 <= n14; ++i3) {
                int n16 = this.a[i2][i3];
                if (n16 < 0) {
                    n16 = this.a[-n16 - 1].getCurrentFrame();
                }
                Block block = this.a[n16];
                if (n5 > n3) {
                    if (n10 < n2 && block.getCollisionFlag(36)) {
                        return n3 + n9;
                    }
                    if (n4 > n2 && block.getCollisionFlag(40)) {
                        return n3 + n9;
                    }
                }
                if (n15 == -1 && n11 < n3) {
                    if (n10 < n2 && block.getCollisionFlag(20)) {
                        n15 = n3;
                    }
                    if (n4 > n2 && block.getCollisionFlag(24)) {
                        n15 = n3;
                    }
                }
                n2 += n6;
            }
            if (n15 != -1) {
                return n15;
            }
            n3 -= n7;
        }
        return -1;
    }

    public int getBottomCollisionCoor(int n2, int n3, int n4, int n5) {
        ParameterChecker.checkMinMax(n2, "pixelX", 0, this.c - n4);
        ParameterChecker.checkMinMax(n3, "pixelY", 0, this.d - n5);
        ParameterChecker.checkMin(n4, "width", 1);
        ParameterChecker.checkMin(n5, "height", 1);
        int n6 = this.a.getBlockWidth();
        int n7 = this.a.getBlockHeight();
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = n2;
        int n11 = n3;
        n4 = n2 + n4;
        n5 = n3 + n5;
        int n12 = n10 / n6;
        n2 = n11 / n7;
        int n13 = n4 / n6;
        int n14 = n5 / n7;
        n3 = n2 * n7 + n9;
        for (int i2 = n2; i2 <= n14; ++i2) {
            int n15 = -1;
            n2 = n12 * n6 + n8;
            for (int i3 = n12; i3 <= n13; ++i3) {
                int n16 = this.a[i2][i3];
                if (n16 < 0) {
                    n16 = this.a[-n16 - 1].getCurrentFrame();
                }
                Block block = this.a[n16];
                if (n11 < n3) {
                    if (n10 < n2 && block.getCollisionFlag(20)) {
                        return n3 - n9;
                    }
                    if (n4 > n2 && block.getCollisionFlag(24)) {
                        return n3 - n9;
                    }
                }
                if (n15 == -1 && n5 > n3) {
                    if (n10 < n2 && block.getCollisionFlag(36)) {
                        n15 = n3;
                    }
                    if (n4 > n2 && block.getCollisionFlag(40)) {
                        n15 = n3;
                    }
                }
                n2 += n6;
            }
            if (n15 != -1) {
                return n15;
            }
            n3 += n7;
        }
        return -1;
    }

    public int getLeftCollisionCoor(int n2, int n3, int n4, int n5) {
        ParameterChecker.checkMinMax(n2, "pixelX", 0, this.c - n4);
        ParameterChecker.checkMinMax(n3, "pixelY", 0, this.d - n5);
        ParameterChecker.checkMin(n4, "width", 1);
        ParameterChecker.checkMin(n5, "height", 1);
        int n6 = this.a.getBlockWidth();
        int n7 = this.a.getBlockHeight();
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = n2;
        int n11 = n3;
        n4 = n2 + n4;
        n5 = n3 + n5;
        int n12 = n10 / n6;
        int n13 = n11 / n7;
        n3 = n4 / n6;
        int n14 = n5 / n7;
        n2 = n3 * n6 + n8;
        for (int i2 = n3; i2 >= n12; --i2) {
            int n15 = -1;
            n3 = n13 * n7 + n9;
            for (int i3 = n13; i3 <= n14; ++i3) {
                int n16 = this.a[i3][i2];
                if (n16 < 0) {
                    n16 = this.a[-n16 - 1].getCurrentFrame();
                }
                Block block = this.a[n16];
                if (n4 > n2) {
                    if (n11 < n3 && block.getCollisionFlag(24)) {
                        return n2 + n8;
                    }
                    if (n5 > n3 && block.getCollisionFlag(40)) {
                        return n2 + n8;
                    }
                }
                if (n15 == -1 && n10 < n2) {
                    if (n11 < n3 && block.getCollisionFlag(20)) {
                        n15 = n2;
                    }
                    if (n5 > n3 && block.getCollisionFlag(36)) {
                        n15 = n2;
                    }
                }
                n3 += n7;
            }
            if (n15 != -1) {
                return n15;
            }
            n2 -= n6;
        }
        return -1;
    }

    public int getRightCollisionCoor(int n2, int n3, int n4, int n5) {
        ParameterChecker.checkMinMax(n2, "pixelX", 0, this.c - n4);
        ParameterChecker.checkMinMax(n3, "pixelY", 0, this.d - n5);
        ParameterChecker.checkMin(n4, "width", 1);
        ParameterChecker.checkMin(n5, "height", 1);
        int n6 = this.a.getBlockWidth();
        int n7 = this.a.getBlockHeight();
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = n2;
        int n11 = n3;
        n4 = n2 + n4;
        n5 = n3 + n5;
        n3 = n10 / n6;
        int n12 = n11 / n7;
        int n13 = n4 / n6;
        int n14 = n5 / n7;
        n2 = n3 * n6 + n8;
        for (int i2 = n3; i2 <= n13; ++i2) {
            int n15 = -1;
            n3 = n12 * n7 + n9;
            for (int i3 = n12; i3 <= n14; ++i3) {
                n8 = this.a[i3][i2];
                if (n8 < 0) {
                    n8 = this.a[-n8 - 1].getCurrentFrame();
                }
                Block block = this.a[n8];
                if (n10 < n2) {
                    if (n11 < n3 && block.getCollisionFlag(20)) {
                        return n2 - n9;
                    }
                    if (n5 > n3 && block.getCollisionFlag(36)) {
                        return n2 - n9;
                    }
                }
                if (n15 == -1 && n4 > n2) {
                    if (n11 < n3 && block.getCollisionFlag(24)) {
                        n15 = n2;
                    }
                    if (n5 > n3 && block.getCollisionFlag(40)) {
                        n15 = n2;
                    }
                }
                n3 += n7;
            }
            if (n15 != -1) {
                return n15;
            }
            n2 += n6;
        }
        return -1;
    }
}

