/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.Cannon;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Shot;
import com.eternity.castlelords.Wall;
import com.eternity.castlelords.Warlord;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ArcherShot
extends Shot {
    int x;
    int y;
    int g;
    int vx;
    int vy;
    int lx;
    int ly;
    int lpx;
    int lpy;
    int hpx;
    int hpy;
    static final int COL_BROWN1 = 6373415;
    static final int COL_BROWN2 = 4335897;
    static final int COL_GRAY1 = 12300455;
    static final int COL_GRAY2 = 0x262126;
    public static final int[] TYPE_BY_RACE;
    public static final int SPEAR_LENGTH = 59;
    public static final int POINT_HEIGHT = 7;
    public static final int POINT_LENGTH = 10;
    private static int G;

    static {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        TYPE_BY_RACE = nArray;
        G = 0;
    }

    public ArcherShot(int x, int y, int pp, int level, boolean ownedByPlayer, GameObjects gameObjects, CLImageTracker tracker, int vx, int vy, int archerAbilities) {
        super(x >> 8, y >> 8, pp, ownedByPlayer, gameObjects, tracker);
        this.abilities = archerAbilities;
        this.level = level;
        Warlord w = this.isOwnedByBlue() ? gameObjects.blueWarlord : gameObjects.redWarlord;
        this.type = TYPE_BY_RACE[w.race];
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.g = ArcherShot.getG();
        if (this.type == 2) {
            this.vy = 0;
        }
        if (this.type == 0) {
            this.calcSpearParams();
        }
    }

    public static int getG() {
        if (G == 0) {
            int t2 = 700 / XCanvas.DT << 8;
            t2 = t2 * t2 >> 8;
            G = (WarlordsCastles.imageTracker.getImageForStronghold(2).getHeight() << 17) / t2;
        }
        return G;
    }

    public void doStep() {
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if (temp instanceof Person && !(temp instanceof Wall) && temp.isOwnedByBlue() == !this.isOwnedByBlue() && this.getPositionY() >= temp.getPositionY() && this.getPositionY() < 213 && this.getPositionX() > temp.getPositionX() - temp.width() / 2 && this.getPositionX() < temp.getPositionX() + temp.width() / 2 && !this.isAttackOver()) {
                int damage = this.gameObjects.combatTurn(this, (Person)temp);
                ((Person)temp).subHitPoints(damage);
                ((Person)temp).addLastDamage(damage);
                this.gameObjects.addFlyingText("-" + ((Person)temp).lastDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                if (((Person)temp).hitPoints > 0) {
                    int type = 0;
                    if (temp instanceof Cannon) {
                        type = 3;
                    } else if (temp instanceof Wall) {
                        type = 1;
                    } else if (temp.race == 2) {
                        type = 2;
                    }
                    CLGameCanvas.addHitAnim(this.positionX, this.positionY, (byte)type);
                }
                this.setAttackOver(true);
            }
            ++i;
        }
        if (!this.isAttackOver()) {
            int damage;
            if (this.isOwnedByBlue()) {
                if (this.getPositionX() > 708) {
                    damage = this.gameObjects.combatCastleTurn(this);
                    this.gameObjects.redWarlord.castlePower -= damage;
                    this.gameObjects.addFlyingText("-" + damage, 10, this.getPositionX(), this.getPositionY() - 5, 1);
                    this.setAttackOver(true);
                }
            } else if (this.getPositionX() < 12) {
                damage = this.gameObjects.combatCastleTurn(this);
                this.gameObjects.blueWarlord.castlePower -= damage;
                this.gameObjects.addFlyingText("-" + damage, 10, this.getPositionX(), this.getPositionY() - 5, 1);
                this.setAttackOver(true);
            }
        }
        if (!this.isAttackOver() && this.getPositionY() > 213) {
            this.setAttackOver(true);
        }
        if (!this.isAttackOver()) {
            switch (this.type) {
                case 2: {
                    this.vy += this.g;
                    this.y += this.vy;
                    this.x += this.vx;
                    break;
                }
                default: {
                    this.x += this.vx;
                    this.y += this.vy;
                }
            }
            this.positionX = this.x >> 8;
            this.positionY = this.y >> 8;
        }
    }

    public Image getImage() {
        return null;
    }

    public void paintSprite(Graphics g, boolean nextFrame) {
        int x = this.positionX;
        int y = this.positionY;
        if (this.type != 0) {
            x = this.positionX - (CLImageTracker.shots.getWidth() >> 1);
            y = this.positionY - (CLImageTracker.shots.getHeight() >> 1);
        }
        x = this.positionX - CLGameCanvas.viewport;
        switch (this.type) {
            case 4: {
                CLImageTracker.shots.drawSubImage(g, x, y, 0, 0);
                break;
            }
            case 0: {
                this.drawSpear(g, x, y);
                break;
            }
            case 2: {
                CLImageTracker.shots.drawSubImage(g, x, y, 0, 1);
                break;
            }
            case 3: {
                CLImageTracker.shots.drawSubImage(g, x, y, 0, 2);
            }
        }
    }

    public void setAttackOver(boolean attack) {
        if (this.ownedByBlue) {
            System.out.println("Attack Over :( " + this.ownedByBlue);
        }
        super.setAttackOver(attack);
    }

    int[] calcLineLenghtHeight(int l, long dir_x, long dir_y) {
        int[] result = new int[2];
        long ly = XCanvas.sqrt(((long)(l * l) * dir_y * dir_y << 16) / (dir_x * dir_x + dir_y * dir_y)) >> 8;
        long lx = (dir_x * ly << 8) / dir_y >> 8;
        result[0] = (int)Math.abs(lx);
        result[1] = (int)Math.abs(ly);
        return result;
    }

    void calcSpearParams() {
        int[] result = this.calcLineLenghtHeight(59, this.vx, this.vy);
        this.lx = result[0];
        this.ly = result[1];
        result = this.calcLineLenghtHeight(7, this.vy, this.vx);
        this.hpx = result[0] >> 1;
        this.hpy = result[1] >> 1;
        result = this.calcLineLenghtHeight(10, this.vx, this.vy);
        this.lpx = result[0];
        this.lpy = result[1];
        if (this.ownedByBlue) {
            this.lx = -this.lx;
        } else {
            this.hpx = -this.hpx;
            this.lpx = -this.lpx;
        }
    }

    void drawSpear(Graphics g, int x, int y) {
        g.setColor(6373415);
        g.drawLine(x, y, x + this.lx, y - this.ly);
        g.setColor(4335897);
        g.drawLine(x, y + 1, x + this.lx, y - this.ly + 1);
        g.setColor(12300455);
        g.fillTriangle(x, y, x + this.hpx, y - this.hpy, x + this.lpx, y + this.lpy);
        g.setColor(0x262126);
        g.fillTriangle(x, y, x - this.hpx, y + this.hpy, x + this.lpx, y + this.lpy);
    }
}

