/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Patch;
import com.impossible.util.ByteStringBuffer;
import com.impossible.util.ImLoader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class CLLocales {
    private static CLLocales instance = null;
    private static Hashtable messages;
    private static Hashtable messages_byte;
    public static String[] SPELL_DESCRIPTIONS;
    public static byte[][] SPELL_DESCRIPTIONS_BYTE;
    public static byte[][] TIPS;

    static {
        SPELL_DESCRIPTIONS = null;
        SPELL_DESCRIPTIONS_BYTE = null;
        TIPS = null;
    }

    public static CLLocales getInstance(String language) {
        if (instance == null) {
            instance = new CLLocales(language);
        }
        return instance;
    }

    public CLLocales(String language) {
        ImLoader.jpackOpen("/t");
        Patch patch = new Patch();
        byte[] data = ImLoader.jpackRead();
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
            if (CLLocales.isStoredPatch()) {
                System.out.println("-Read from RS-");
                patch.loadPatchFromRS();
            } else {
                System.out.println("-Read from DataFile-");
                patch.readInPatch(din, true);
            }
            System.out.println("Debug value from patch (load RMS) " + GameObjects.BUILDINGS_PRICES[0][0]);
            din.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        patch = null;
        data = ImLoader.jpackRead();
        messages = new Hashtable();
        messages_byte = new Hashtable();
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(data);
                boolean done = false;
                byte[] buffer = new byte[1];
                StringBuffer line = new StringBuffer();
                while (!done) {
                    int bytesRead = is.read(buffer);
                    if (bytesRead != -1) {
                        if (buffer[0] == 10) {
                            String s = line.toString().trim();
                            if (!s.startsWith("#") && s.length() > 2 && s.indexOf("=") != -1) {
                                String key = s.substring(0, s.indexOf("=")).trim().toLowerCase();
                                String value = s.substring(s.indexOf("=") + 1).trim();
                                messages.put(key, value);
                                messages_byte.put(key, GameObjects.convertToByteString(value, false));
                            }
                            line.setLength(0);
                            continue;
                        }
                        line.append((char)buffer[0]);
                        continue;
                    }
                    done = true;
                }
                data = ImLoader.jpackRead();
                is = new ByteArrayInputStream(data);
                CLLocales.readSpellDescriptions(is);
                data = ImLoader.jpackRead();
                is = new ByteArrayInputStream(data);
                CLLocales.readTips(is);
            }
            catch (IOException io) {
                System.out.println("Error loading resources: " + io);
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ImLoader.jpackClose();
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            ImLoader.jpackClose();
        }
    }

    public static boolean isStoredPatch() {
        boolean exist = false;
        String[] names = RecordStore.listRecordStores();
        if (names != null) {
            int i = 0;
            while (i < names.length && !exist) {
                exist = names[i].equals("patch");
                ++i;
            }
        }
        return exist;
    }

    public static final void readSpellDescriptions(InputStream is) {
        Vector<String> lines = new Vector<String>();
        InputStreamReader reader = null;
        try {
            try {
                int c;
                reader = new InputStreamReader(is);
                StringBuffer line = new StringBuffer();
                boolean title = true;
                while ((c = reader.read()) != -1) {
                    switch (c) {
                        case 10: {
                            if (!title) {
                                lines.addElement(line.toString());
                            }
                            title = !title;
                            line = new StringBuffer();
                            break;
                        }
                        case 13: {
                            break;
                        }
                        default: {
                            line.append((char)c);
                        }
                    }
                }
                if (!title && line.length() > 0) {
                    lines.addElement(line.toString());
                }
                SPELL_DESCRIPTIONS = new String[lines.size()];
                lines.copyInto(SPELL_DESCRIPTIONS);
                SPELL_DESCRIPTIONS_BYTE = new byte[SPELL_DESCRIPTIONS.length][];
                CLLocales.updateSpellDescriptions(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void readTips(InputStream is) {
        Vector<String> lines = new Vector<String>();
        InputStreamReader reader = null;
        try {
            int c;
            reader = new InputStreamReader(is);
            StringBuffer line = new StringBuffer();
            while ((c = reader.read()) != -1) {
                switch (c) {
                    case 10: {
                        lines.addElement(line.toString());
                        line = new StringBuffer();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        line.append((char)c);
                    }
                }
            }
            if (line.length() > 0) {
                lines.addElement(line.toString());
            }
            TIPS = new byte[lines.size()][];
            int i = 0;
            while (i < TIPS.length) {
                CLLocales.TIPS[i] = GameObjects.convertToByteString((String)lines.elementAt(i), false);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getString(String key) {
        String s = (String)messages.get(key.toLowerCase());
        if (s != null) {
            return s;
        }
        return key;
    }

    public static byte[] getByteString(String key) {
        byte[] s = (byte[])messages_byte.get(key.toLowerCase());
        if (s != null) {
            return s;
        }
        return GameObjects.convertToByteString(key, false);
    }

    public static void updateSpellDescriptions(int level) {
        ByteStringBuffer buf = new ByteStringBuffer();
        int i = 0;
        while (i < 24) {
            buf.delete(0, buf.length());
            String description = SPELL_DESCRIPTIONS[i];
            int j = 0;
            while (j < description.length()) {
                char c = description.charAt(j);
                if (c == '\\') {
                    int idx = Integer.parseInt(description.substring(j + 1, j + 2));
                    buf.appendNum(GameObjects.ALL_SPELLS_CHAR[level * 24 + i][idx]);
                    ++j;
                } else {
                    buf.append(GameObjects.convertCharToByte(c));
                }
                ++j;
            }
            CLLocales.SPELL_DESCRIPTIONS_BYTE[i] = buf.toByteString();
            ++i;
        }
    }
}

