/*
 * Decompiled with CFR 0.152.
 */
package com.bluebeck.mobile.framework;

import com.bluebeck.mobile.framework.MobileCanvas;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MobileSprite {
    Image[] frames;
    protected int framesMax;
    public int framesCurrent = 0;
    protected int framesCounter = 0;
    public int framesSpeed = 3;
    protected Image imageStrip;
    protected boolean useImageStrip;
    public int animState = 65535;
    public boolean drawFlipped = false;
    protected int imgWidth;
    protected int imgHeight;
    public int frameWidth;
    public int frameHeight;
    public int vx = 0;
    public int vy = 0;
    public int x = 0;
    public int y = 0;
    public int[][] animation;
    protected int animationFrameOffset = 0;

    public MobileSprite() {
        this.frames = new Image[this.framesMax];
        this.useImageStrip = false;
    }

    public MobileSprite(Image aImageStrip, int aNumFrames) {
        this.framesMax = aNumFrames;
        this.imageStrip = aImageStrip;
        this.useImageStrip = true;
        this.imgWidth = this.imageStrip.getWidth();
        this.imgHeight = this.imageStrip.getHeight();
        this.frameWidth = this.imgWidth / this.framesMax;
        this.frameHeight = this.imgHeight;
        this.drawFlipped = false;
        this.frames = new Image[this.framesMax];
        this.changeAnim(65535, true, true, true, this.animation);
        this.vx = 0;
        this.vy = 0;
        this.framesSpeed = 3;
    }

    public void doAnim() {
        if (this.animState != 65535) {
            switch (this.animState) {
                case 65530: {
                    if (this.framesCounter >= this.framesSpeed) {
                        this.framesCounter = 0;
                        ++this.framesCurrent;
                        if (this.framesCurrent < this.framesMax) break;
                        this.framesCurrent = 0;
                        break;
                    }
                    ++this.framesCounter;
                }
            }
        }
    }

    public void drawFrame(int frame, int ax, int ay, Graphics g) {
        int offsetx = frame * this.frameWidth;
        if (ax < MobileCanvas.canvasWidth && ax + this.frameWidth > 0 && ay + this.frameHeight > 0 && ay < MobileCanvas.canvasHeight) {
            g.setClip(ax, ay, this.frameWidth, this.frameHeight);
            g.drawImage(this.imageStrip, ax - offsetx, ay, 0);
            g.setClip(0, 0, MobileCanvas.canvasWidth, MobileCanvas.canvasHeight);
        }
    }

    public void drawSprite(Graphics g) {
        if (this.animState != 65535) {
            if (this.useImageStrip) {
                int offsetx = this.framesCurrent * this.frameWidth;
                if (this.x < MobileCanvas.canvasWidth && this.x + this.frameWidth > 0 && this.y + this.frameHeight > 0 && this.y < MobileCanvas.canvasHeight) {
                    if (this.drawFlipped) {
                        g.setClip(this.x, this.y, this.frameWidth, this.frameHeight);
                        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                        dg.drawImage(this.imageStrip, this.x - (this.imgWidth - offsetx - this.frameWidth), this.y, 20, 8192);
                        g.setClip(0, 0, MobileCanvas.canvasWidth, MobileCanvas.canvasHeight);
                    } else {
                        g.setClip(this.x, this.y, this.frameWidth, this.frameHeight);
                        g.drawImage(this.imageStrip, this.x - offsetx, this.y, 0);
                        g.setClip(0, 0, MobileCanvas.canvasWidth, MobileCanvas.canvasHeight);
                    }
                }
            } else {
                g.drawImage(this.frames[this.framesCurrent], this.x, this.y, 0x20 | 1);
            }
        }
    }

    protected void changeAnim(int aAnim, boolean aResetFrameOffset, boolean aResetAnimOffset, boolean aResetFrameCounter, int[][] anim) {
        this.animState = aAnim;
        if (aResetAnimOffset) {
            this.animationFrameOffset = 0;
        }
        if (this.animState != 65535 && aResetAnimOffset) {
            this.framesCurrent = anim[this.animState][0];
        }
        if (aResetFrameCounter) {
            this.framesCounter = 0;
        }
    }

    public void reset() {
        this.animState = 65535;
    }

    protected boolean updateAnim(int[][] anim) {
        boolean ret = false;
        if (this.animState != 65535) {
            if (this.framesCounter >= this.framesSpeed) {
                ret = true;
                this.framesCounter = 0;
                ++this.animationFrameOffset;
                if (this.animationFrameOffset > anim[this.animState].length - 2) {
                    this.animState = anim[this.animState][anim[this.animState].length - 1];
                    if (this.animState != 65535) {
                        this.framesCurrent = anim[this.animState][0];
                    }
                    this.animationFrameOffset = 0;
                } else {
                    this.framesCurrent = anim[this.animState][this.animationFrameOffset];
                }
            } else {
                ++this.framesCounter;
            }
        }
        return ret;
    }
}

