/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.jq2009;

import com.iplay.game.PackHandler;
import com.iplay.game.TextHandler;
import com.iplay.game.font.Font;
import com.iplay.game.jq2009.Animations;
import com.iplay.game.jq2009.InputHandlerExtensions;
import com.iplay.game.jq2009.JQ2009GameCanvas;
import com.iplay.game.jq2009.MainMenu;
import com.iplay.game.jq2009.MatchThreeBoard;
import com.iplay.game.jq2009.MenuRenderer;
import com.iplay.game.jq2009.config.DefaultConstants;
import com.iplay.game.spac.SpacFile;
import com.iplay.game.spac.SpacSprite;
import com.iplay.game.util.TimerHandler;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class JQ2009Game
extends Animations {
    public char[][] logText = new char[2][];
    public static final int TUTORIAL_TIME2 = 5000;
    public static final int TIMER_STEP1 = 0;
    public static final int TIMER_STEP2 = 1;
    public static final int TIMER_STEP3 = 2;
    public static final int TIMER_STEP4 = 3;
    public static final int TIMER_STEP5 = 4;
    public static final int HUD_JEWEL_BACKGROUND_THICK = 3;
    public static final int A_QUARTER = 4;
    public static final int COMMON_LEVEL_SPAC_IMAGES_COUNT = 17;
    public static final int LOCALE_IMAGES_COUNT = 3;
    public static final int MAX_DEMO_MODE_LEVELS = 2;
    public static final int DSCORE = 100;
    public static final int INITIAL_BOSS_SCORE = 7000;
    public static final int FIRST_NON_BOSS_LEVEL = 0;
    private static final int COORDINATE_2D_COUNT = 2;
    private static final int CURRENT_AWARDS_COUNT = 5;
    private static final int TUTORIAL_MOVES_ARRAY_SIZE = 4;
    private static final int TUTORIAL_MOVES_ARRAY_1ST_MOVE_X = 0;
    private static final int TUTORIAL_MOVES_ARRAY_1ST_MOVE_Y = 1;
    private static final int TUTORIAL_MOVES_ARRAY_2ND_MOVE_X = 2;
    private static final int TUTORIAL_MOVES_ARRAY_2ND_MOVE_Y = 3;
    public static final String BOSS_ARROW_LEFT = "<";
    public static final String BOSS_ARROW_RIGHT = ">";
    private static final int TUTORIAL_TIME = 5000;
    private static final int PERCENT = 100;
    public static final int LEFT_START_COLUMN_BORDER = 1;
    public static final int START_ROW_BORDER = 6;
    public static final int END_ROW_BORDER = 11;
    public static final int RIGHT_START_COLUMN_BORDER = 10;
    public static final int TILE_FRAMES = 15;
    public static final int TILE_DIRTY = 16;
    public static final int FIRST_BOSS_POWERUP = 2;
    public static final int NUM_BOSS_POWERUPS = 2;
    public static final int BOSS_POWERUP_TRESHOLD = 30;
    public static final int BOSS_POWERUP_MAX_TRESHOLD = 23;
    public static final int FIRST_POWERUP_PROBABILITY = 50;
    public static final int NUM_PUZZLES_PER_CHAPTER = 3;
    public static final int NUM_PUZZLES = 9;
    public static final int FIRST_FREE_PLAY_LEVEL = 300000;
    public static final int SECOND_FREE_PLAY_LEVEL = 500000;
    public static final int THIRD_FREE_PLAY_LEVEL = 1000000;
    public static final int PLAYED_LEVELS_MODE = 0;
    public static final int BOSS_BATTLES_MODE = 1;
    public static final int STORY_MODE = 2;
    public static final int NO_TILE = -1;
    public static final int NORMAL_GAME_HAPPY_TRESHOLD = 30;
    public static final int GAIN_JEWEL_LEVELS = 9;
    public static final int NO_LOSE_GROUND_LEVELS = 29;
    public static final int ONE_HUNDRED_PERCENT = 100;
    public static final int DEGREES_90 = 90;
    public static final int DEGREES_180 = 180;
    public static final int DEGREES_360 = 360;
    public static final int MAX_MOVES_PER_CELL = 4;
    public static final int MAX_BOARD_SIZE = 8;
    public static final int MAX_BOARD_HEIGHT = 8;
    public static final int POPUP_DIALOG = 0;
    public static final int WELCOME_STORY = 1;
    public static final int WELCOME_CHAPTER = 2;
    public static final int WELCOME_LEVEL = 3;
    public static final int START_LEVEL = 4;
    public static final int LEVEL_OBJECTIVE = 5;
    public static final int LEVEL_TUTORIAL = 6;
    public static final int GAME_MAIN = 7;
    public static final int INLEVEL_AWARD = 8;
    public static final int END_LEVEL_AWARD = 9;
    public static final int CHEAT_SHOW_TEXTS = 10;
    public static final int LEVEL_WON = 11;
    public static final int LEVEL_LOST = 12;
    public static final int CHAPTER_FINISHED = 13;
    public static final int CHOOSE_POWERUP = 14;
    public static final int GAME_END = 15;
    private static final int SWAP = 0;
    private static final int DESTROY_TILES = 1;
    private static final int HANDLE_POWERUPS = 2;
    private static final int HANDLE_ANIMS = 3;
    private static final int FILL_BOARD = 4;
    private static final int CHECK_END_LEVEL = 5;
    private static final int CHECK_ANY_MOVES_LEFT = 6;
    private static final int WAIT = 7;
    private static final int SWITCH_PLAYER = 8;
    private static final int CHOOSE_A_MOVE = 9;
    private static final int MAKE_A_MOVE = 10;
    private static final int CHOOSE_A_HINT = 11;
    private static final int END_LEVEL_ANIMATION = 12;
    public static final int HINT_OFFSET = 4;
    public static final int MAX_HINT_FLASHES = 4;
    public static final int HINT_TIME = 4000;
    public static final int HINT_FLASH_TIME = 200;
    public static final int TIME_TURN_GREEN_TO_GOLD = 500;
    public static final int TIME_BOSS_POWERUP = 1000;
    public static final int TIMER_ANIMATION_RANGE = 150;
    public static final int TIME_BOARD_SHAKE = 500;
    public static final int TIME_END_LEVEL_ANIM = 200;
    public static final int TIME_END_LEVEL_ANIM2 = 1000;
    public static final int PLAYER_1 = 0;
    public static final int PLAYER_2 = 1;
    public static final int GAME_MASK = 16391;
    public static final int NORMAL_GAME = 8;
    public static final int NO_LOSE_GROUND_GAME = 2;
    public static final int GAIN_JEWELS_GAME = 1;
    public static final int LOSE_GROUND = 4;
    public static final int NORMAL_MOVE = 64;
    public static final int CHEAT_MOVE = 32;
    public static final int WIN = 8192;
    public static final int WIN_C = 16384;
    public static final int WIN_GOTO = 32768;
    public static final int LOSE = 4096;
    public static final int MAX_CPU_SCORE = 100;
    public static final int LEVELS_BETWEEN_BOSSES = 3;
    public static final int FIRST_BOSS = 2;
    public static final int SECOND_BOSS = 5;
    public static final int INACTIVE_CELL_COLOR = 0xFFFFFF;
    public static final int HILIGHT_FRAME = 3;
    public static final int ONE_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int ONE_MINUTE = 60000;
    public static final int THREE_QUARTERS_OF_ONE_MINUTE = 45000;
    public static final int ONE_QUARTER_OF_ONE_MINUTE = 15000;
    public static final int LEVELDATA_BOARD = 0;
    public static final int LEVELDATA_AIMODE = 1;
    public static final int LEVELDATA_TIME = 2;
    public static final int LEVELDATA_COIN = 3;
    public static final int LEVELDATA_BOSSID = 4;
    public static final int LEVELDATA_WINJEWELS = 5;
    public static final int LEVELDATA_BOSS_FIRST = 6;
    public static final int LEVELDATA_PUZZLE = 7;
    public static final int LEVELDATA_SIZE = 8;
    public static final int INDEX_LEVEL_LENGTH = 0;
    public static final int INDEX_LEVEL_COUNT = 1;
    public static final int INDEX_LEVELS_OFFSET = 2;
    public static final int INDEX_AI_LENGTH = 3;
    public static final int INDEX_AI_COUNT = 4;
    public static final int INDEX_AI_OFFSET = 5;
    public static final int INDEX_BOARD_SIDE_LENGTH = 6;
    public static final int INDEX_BOARD_HEIGHT_LENGTH = 7;
    public static final int INDEX_BOARD_COUNT = 8;
    public static final int INDEX_BOARD_OFFSET = 9;
    public static final int INDEX_CHAPTER_LENGTH = 10;
    public static final int INDEX_CHAPTER_COUNT = 11;
    public static final int INDEX_CHAPTER_OFFSET = 12;
    public static final int INDEX_ANIM_COUNT = 13;
    public static final int INDEX_ANIM_OFFSET = 14;
    public static final int INDEX_AWARD_OFFSET = 15;
    public static final int BIN_DATA_OFFSET = 16;
    public static final int INDEX_LEVEL_BOARD_OFFSET = 0;
    public static final int INDEX_LEVEL_AI_OFFSET = 1;
    public static final int INDEX_LEVEL_TIME_OFFSET = 2;
    public static final int INDEX_LEVEL_COIN_OFFSET = 3;
    public static final int INDEX_LEVEL_BOSSID_OFFSET = 4;
    public static final int INDEX_LEVEL_WIN_JEWEL_OFFSET = 5;
    public static final int INDEX_LEVEL_BOSS_FIRST_OFFSET = 6;
    public static final int INDEX_LEVEL_PUZZLE_OFFSET = 7;
    public static final int POWERUP_STATE_CHOOSE = 0;
    public static final int POWERUP_STATE_POSITION = 1;
    public static final int FIRST_POWERUP_LEVEL = 0;
    public static final int SECOND_POWERUP_LEVEL = 1;
    public static final int THIRD_POWERUP_LEVEL = 2;
    public static final int FOURTH_POWERUP_LEVEL = 3;
    public static final int POWERUPS_LEVELS_COUNT = 4;
    public static final int FIRST_POWERUP_LEVEL_COST = 1;
    public static final int SECOND_POWERUP_LEVEL_COST = 2;
    public static final int THIRD_POWERUP_LEVEL_COST = 3;
    public static final int FOURTH_POWERUP_LEVEL_COST = 6;
    public static final int NO_POWERUP = -1;
    public static final int JEWELER_HAMMER_POWERUP = 0;
    public static final int BLAZE_POWERUP = 1;
    public static final int WHIRLWIND_POWERUP = 2;
    public static final int BREAK_COLOR_POWERUP = 3;
    public static final int POWERUPS_COUNT = 4;
    public static final int BLAST_WAVE_RADIUS = 1;
    public static final int RANDOM_DESTROYED_CELLS = 10;
    public static final int NUM_STEPS_TO_DESTROY_CELL = 5;
    public static final int FIRST_TIMER_ROUND_PERCENT = 5;
    public static final int SECOND_TIMER_ROUND_PERCENT = 10;
    public static final int LINE_SPACING = 2;
    public static final int LINE_SPACING_BASEFONT = 0;
    public static final int STOPED = 0;
    public static final int NUM_PARTICLES = 15;
    public static final int AWARD_MATCH_STREAK_5 = 0;
    public static final int AWARD_10_MATCH_4 = 1;
    public static final int AWARD_5_MATCH_5 = 2;
    public static final int AWARD_BOARD_5000_POINTS = 3;
    public static final int AWARD_MATCH_6 = 4;
    public static final int AWARD_MATCH_7 = 5;
    public static final int AWARD_1000_JEWELS = 6;
    public static final int AWARD_10000_JEWELS = 7;
    public static final int AWARD_INLEVEL_COUNT = 8;
    public static final int AWARD_FIRST_CHAPTER = 8;
    public static final int AWARD_ABOVE_HALF_TIME = 9;
    public static final int AWARD_COMPLETE_ALL_BOARDS = 10;
    public static final int AWARD_COMPLETE_ALL_BOSSES = 11;
    public static final int AWARD_FAIL_3_TIMES = 12;
    public static final int AWARD_FINISH_UNDER_5_PERCENT_TIME = 13;
    public static final int AWARD_LOSE_BOSS_30_PERCENT = 14;
    public static final int AWARD_NO_COINS_USED = 15;
    public static final int AWARD_PLUS_WIN_25_PERCENT = 16;
    public static final int AWARD_PLUS_WIN_DOUBLE = 17;
    public static final int AWARD_TOTAL_COUNT = 18;
    public static final int AWARD_MORE_THAN_25_PERCENT_TIME = 25;
    public static final int AWARD_MORE_25_PERCENT_THAN_CPU = 25;
    public static final int AWARD_DOUBLE = 2;
    public static final int AWARD_PLUS_PERCENT_25 = 25;
    private boolean bCpuWrong;
    private final int TENTH;
    private final int AI8_USE_POWERUP;
    private final int AI6_USE_POWERUP;
    private final int AI2_USE_POWERUP;
    private final int AI_WHO_MATCH_MORE;
    public static final int AWARD_FINISH_UNDER_5_PERCENT_TIME_PERCENT = 5;
    public static final int AWARD_ABOVE_HALF_TIME_PERCENT = 50;
    public static final int AWARD_MORE_THAN_60_PERCENT = 60;
    public static final int AWARD_60_PERCENT = 60;
    public static final int AWARD_10_MATCH_4_VALUE = 12;
    public static final int AWARD_5_MATCH_5_VALUE = 5;
    public static final int AWARD_MATCH_STREAK_5_VALUE = 10;
    public static final int AWARD_1000_JEWELS_VALUE = 10000;
    public static final int AWARD_10000_JEWELS_VALUE = 100000;
    public static final int AWARD_10000_POINTS = 8000;
    public static final int AWARD_TEXT_ID = 0;
    public static final int AWARD_CAPS_TITLE_ID = 1;
    public static final int AWARD_TITLE_ID = 2;
    public static final int AWARD_SCORE_ID = 3;
    public static final int AWARD_TEXT = 49;
    public static final int AWARD_TITLE = 67;
    public static final int AWARD_CAPS_TITLE = 85;
    public static final int AWARD_ANIM_TIME = 200;
    public static final int JEWEL_REMOVE_LEVEL = 0;
    public static final int JEWEL_REMOVE_INDEX = 2;
    public static final int DIALOG_TITLE_ANIM_TIME = 300;
    public static final int CHAR_INIT_TIME = 500;
    public static final int CHAR_MOVE_TIME = 640;
    public static final int CHAR_DELAY_TIME = 420;
    public static final int CHAR_X = 0;
    public static final int CHAR_Y = 1;
    public static final int CHAR_OLD_X = 2;
    public static final int CHAR_OLD_Y = 3;
    public static final int CHAR_NEW_X = 4;
    public static final int CHAR_NEW_Y = 5;
    public static final int CHAR_DELAY = 6;
    public static final int CHAR_TIME = 7;
    public static final int CHAR_POS_SIZE = 8;
    public static final int MC_POS = 0;
    public static final int NPC_POS = 1;
    public static final int CHAR_COUNT = 2;
    public static final int TUTORIAL_HARDCODED_LEVELS = 2;
    private static final int TUTORIAL_LEVEL_1 = 0;
    private static final int TUTORIAL_LEVEL_2 = 1;
    private static final int TUTORIAL_LEVEL_3 = 10;
    private static final int TUTORIAL_LEVEL_4 = 17;
    private static final int TUTORIAL_POWERUP_LEVEL_1 = 12;
    private static final int TUTORIAL_POWERUP_LEVEL_2 = 20;
    private static final int TUTORIAL_POWERUP_LEVEL_3 = 29;
    private static final int TUTORIAL_POWERUP_LEVEL_4 = 1;
    private static final int TUTORIAL_MOVES_INDEX_1 = 0;
    private static final int TUTORIAL_MOVES_INDEX_2 = 1;
    private static final int TUTORIAL_MOVES_INDEX_3 = 2;
    public static final int TUTORIAL_NONE = -1;
    public static final int TUTORIAL_FIRST_MOVE = 0;
    public static final int TUTORIAL_SELECT_MATCH3 = 1;
    public static final int TUTORIAL_MOVE_MATCH3 = 2;
    public static final int TUTORIAL_SHOW_SCORE = 3;
    public static final int TUTORIAL_SHOW_TIME = 4;
    public static final int TUTORIAL_SHOW_COINS = 5;
    public static final int TUTORIAL_SHOW_POWERUP = 6;
    public static final int TUTORIAL_SHOW_JEWELS = 7;
    public static final int TUTORIAL_SHOW_COINS_MOVE = 8;
    public static final int TUTORIAL_SHOW_BURRIED = 9;
    public static final int TUTORIAL_SHOW_EMPTY = 10;
    private static final int TUTORIAL_SHOW_POWERUP1 = 11;
    private static final int TUTORIAL_SHOW_POWERUP2 = 12;
    private static final int TUTORIAL_SHOW_POWERUP3 = 13;
    private static final int TUTORIAL_SHOW_POWERUP4 = 14;
    public static final int TUTORIAL_SHOW_BURRIED2 = 15;
    public static final int MIN_TUTORIAL_FIRST_MOVE = 0;
    public static final int MIN_TUTORIAL_SELECT_MATCH3 = 1;
    public static final int MIN_TUTORIAL_SHOW_COINS = 2;
    public static final int MIN_TUTORIAL_SHOW_EMPTY = 3;
    public static final int MIN_TUTORIAL_SHOW_BURRIED = 4;
    public static final int TUTORIAL_SELECT_MATCH3_PRESS_5 = 100;
    public static final int TUTORIAL_SHOW_COINS_MOVE_PRESS_5 = 101;
    public static final int MAX_GATHERED_COINS = 99;
    public static final int IMAGE_1 = 0;
    public static final int IMAGE_2 = 1;
    public static final int IMAGE_3 = 2;
    public static final int IMAGE_4 = 3;
    public static final int IMAGE_5 = 4;
    public static final int IMAGE_6 = 5;
    public static final int IMAGE_7 = 6;
    public static final int IMAGE_8 = 7;
    public static final int IMAGE_9 = 8;
    public static final int IMAGE_10 = 9;
    public static final int IMAGE_11 = 10;
    public static final int IMAGE_12 = 11;
    public static final int IMAGE_13 = 12;
    public static final byte[] STORY_IMAGE = new byte[]{1, 2, 3, 4, 5, 3, 6, 7, 3, 8, 9, 10, 12, 12, 13, 12, 14, 15, 16, 17, 18, 19, 20, 21, 12, 23, 23, 23, 24, 25, 26, 27, 28, 29, 30, 31, 13};
    public static final byte[] STORY_IMAGE2 = new byte[]{0, 11, 22};
    public static final int TUTORIAL_EMPTY_TILES_MAX_COUNT = 4;
    public boolean fillWhite = false;
    private byte[] tutorialEmptyMoves;
    private int lastChapterPage = 0;
    private int tutorialHintBoxWidth;
    private int tutorialHintTextID;
    private byte[] cellRemap;
    private byte[] jewelsRemap;
    private byte[] hazardRemap;
    private int[] awardsScores;
    private int[] backgroundTiles;
    private int[][] animationZones;
    private boolean[] awards;
    private int[] currentAwards;
    public int currentAwardCount;
    public int crntLevelJewelsMatched;
    private int crntLevelCoinsUsed;
    private int crntLevelMaxStreak;
    public int crntLevelMatch4;
    public int crntLevelMatch5;
    public boolean coinsUsedInLevel;
    public boolean coinsUsedInStory;
    public int totalJewelsMatched;
    public int totalCoinsUsed;
    public int totalMaxStreak;
    public int totalMatch4;
    public int totalMatch5;
    private int boardFailureCounter;
    private int matchStreak;
    public int match4Count;
    public int match5Count;
    private int levelAwardPoints;
    private boolean matchMulti6;
    private boolean matchMulti7;
    private int[] charPos;
    private boolean unlockLevels;
    private boolean unlockAwards;
    public int cheatShowText;
    private int[] powerups;
    private int currentPowerup;
    private int currentPowerup2;
    private int powerUpState;
    private MatchThreeBoard m_board;
    private byte[] moves;
    private int boardStartX;
    private int boardStartY;
    private int movingCellsCount;
    private int[] movingCells;
    private static SpacFile mCommonLevelSpac;
    private static SpacFile mSpecificLevelSpac;
    private SpacFile mJewelsSpac;
    private static SpacFile mRupertSpac;
    private static SpacFile mBossSpac;
    private static SpacFile mHudSpac;
    public static SpacFile mMenuInGameSpac;
    public static SpacFile mStorySpac;
    public static SpacFile mSkbarSpac;
    public static SpacFile mPowerupSpac;
    public static SpacFile mEffectSpac;
    public static SpacFile mSpecialCursorSpac;
    private int quickModeMaxLevel;
    private int quickCurrentLevel;
    private int currentLevel;
    private int xPos;
    private int yPos;
    private boolean selected;
    private int jq2009GameState;
    private boolean fullRedraw = true;
    public int player;
    private int hintFlashes;
    public boolean hintShown;
    private int[] hintChoice;
    private boolean player1Human = true;
    private boolean player2Human;
    private int cpuChosenMove;
    private byte cionsIndex;
    private byte cionsIndex2;
    private int[] cpuMoveScores;
    private int cpuEvaluation;
    private boolean cpuSelectedTile;
    private boolean waitForNextMove;
    private boolean playerSwap;
    private boolean twoPlayerMode;
    private boolean creditForMatches = true;
    private int p1Score;
    private int p2Score;
    private int endConditionsCodes = 8;
    private int playerJewels;
    private int playerJewels2;
    private int cpuJewels;
    private int cpuJewels2;
    public static int playerAddJewels;
    public static int cpuAddJewels;
    private int Round;
    private boolean stateChangedThisTick;
    private Image backBuffer;
    private Graphics gBuffer;
    private int gameSubstate;
    private short[] boardData;
    private byte[] distributions;
    public static byte[] levelData;
    public byte[] levelData2;
    public short[][] aiParams;
    private short[] chapterData;
    public int bgEffectX;
    private int bgEffectY;
    private boolean affectedByPowerup;
    public static boolean affectedByPowerup2;
    private boolean powerupAnimsHandled;
    private int score;
    private byte[] backgroundRemap;
    private int matchScore;
    private int gameScore;
    private int cellSize;
    private int borderHeight;
    private int bossHudLeftTextX;
    private int bossHudLeftTextY;
    private int bossHudRightTextX;
    private int bossHudRightTextY;
    private int hudLeftTextX;
    private int hudLeftTextY;
    private int hudRightTextX;
    private int hudRightTextY;
    private boolean refreshHudCenter;
    private boolean refreshHud;
    private boolean refreshMiddleRect;
    private boolean resetClip;
    private int clipX1;
    private int clipY1;
    private int clipX2;
    private int clipY2;
    private char[][] storyTextLines;
    private int storyTextLineIndex;
    private int storyTextPageHeight;
    private Font storyFont;
    private boolean levelObjectiveShown;
    private char[][] popUpTextLines;
    private int popUpFrame;
    private int beginLevelAnimationStarted;
    private int currentAnimatedLine;
    private int currentZone;
    private int nextState;
    private SpacSprite cursorAnimation;
    private SpacSprite flameAnimation;
    private SpacSprite hammerAnimation;
    private SpacSprite[] JewelsAnimation;
    private SpacSprite[] mEffectAnimation;
    private SpacSprite[] tileAnimations;
    public static SpacSprite mRupertSpacAnimation;
    public static SpacSprite mBossSpacAnimation;
    private SpacSprite[] mPowerupAnimation;
    private SpacSprite mIconAnimation;
    public static int RupertState;
    public static int BossState;
    private byte[] JewelsAnimationXY;
    private int[] EffectAnimationXY;
    private int gameMode;
    private int bossPowerup;
    private byte[] powerupMoves;
    private int bossMovesCount;
    private int bossPowerupsCount;
    private int tutorialStep = -1;
    private boolean[] tutorials;
    private boolean specialMatches = false;
    private boolean tutorialTime = true;
    private boolean notDisplayYourTurn = false;
    private int tutorialTextPositionX;
    private int tutorialTextPositionY;
    private boolean tutorialTextClear = true;
    private int[][] tutorialMoves;
    private boolean tutorialMode;
    private boolean tutorialRenderDialog;
    private boolean tutorialRepaintMain;
    private boolean tutorialEnabled;
    private int tutorialText = -1;
    private int tutorialCurrentStep;
    private boolean renderCoinPointer;
    private int specialMenuItemWidth;
    private boolean timeWarningIssued;
    private int[] hudRect;
    private int[] hudCenterRect;
    private boolean drawMarked;
    private boolean drawAnimatedTile;
    public static int iClock;
    private static byte wonAnimationTimes;
    private static byte PowerupCells1;
    private static byte PowerupCells2;
    private static byte bossPowerup2X;
    private static byte bossPowerup2Y;
    private static byte bossPowerup3X;
    private static byte bossPowerup3Y;
    public static long gameStartTime;
    public static long gamePauseTime;
    public static long gameTutorialTime;
    public static byte gameTutorialshow;
    public static byte MultiPlayermode;
    public static byte MultiPlayerChallenge;
    public static byte MultiPlayerChallenge2;
    public static byte MultiPlayer1Win;
    public static byte MultiPlayer2Win;
    public static boolean MultiPlayerEnd;
    public static int MultiPlayer1Time;
    public static int MultiPlayer2Time;
    public static boolean MultiPlayer1Ready;
    public static boolean MultiPlayer2Ready;
    public static boolean MultiPlayerGame3Note;
    public static boolean MultiPlayerEnd2;
    public static byte[] MultiPlayerModeTyte;
    public static boolean MultiPlayer1move;
    public static boolean MultiPlayer2move;
    public static boolean MultiPlayerTimeReady;
    public static boolean MultiPlayerReadyGo;
    public static boolean BossPowerup;
    public static boolean isPreRenderMP;
    public static final byte gameWinShow = 5;
    private byte fullPlayer = 0;
    byte[] JewelsType = new byte[6];
    byte soundplay = (byte)40;
    byte bossPower = (byte)-1;
    byte[] winjewels2;
    private static Image imgPad_left;
    private static Image imgPad_right;
    private static int storyCoins;
    private static int levelCoins;
    private static int levelCPUCoins;
    int m_boardWidth = 8;
    int m_boardHeight = 8;

    public JQ2009Game() {
        this.TENTH = 10;
        this.AI8_USE_POWERUP = 5;
        this.AI6_USE_POWERUP = 4;
        this.AI2_USE_POWERUP = 7;
        this.AI_WHO_MATCH_MORE = 6;
        this.tutorials = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        this.tutorialEmptyMoves = new byte[4];
        this.charPos = new int[16];
        this.hazardRemap = new byte[]{3, 4};
        this.jewelsRemap = new byte[]{0, 1, 2, 3, 4, 5};
        this.cellRemap = new byte[]{2, 0, 1, 16};
        this.bgEffectY = this.screenHeight >> 1;
        this.hintChoice = new int[2];
        this.powerups = new int[]{0, 1, 2, 3};
        this.currentAwards = new int[5];
        this.awards = new boolean[18];
        this.movingCells = new int[121];
        this.backgroundRemap = new byte[]{13, 14, 15, 16};
        this.charPos = new int[16];
    }

    public final int[] getPowerups() {
        return this.powerups;
    }

    public final void setPowerup(int n, int n2) {
        this.powerups[n] = n2;
    }

    public void loadData2ToData() {
        if (this.levelData2[0] == -1) {
            return;
        }
        JQ2009Game.levelData[this.levelData2[0] * 8 + 0] = this.levelData2[1];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 1] = this.levelData2[2];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 2] = this.levelData2[3];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 3] = this.levelData2[4];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 4] = this.levelData2[5];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 5] = this.levelData2[6];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 6] = this.levelData2[7];
        JQ2009Game.levelData[this.levelData2[0] * 8 + 7] = this.levelData2[8];
        this.winjewels2[this.levelData2[0]] = this.levelData2[9];
        this.levelData2[0] = -1;
    }

    public void loadDataToData2(int n) {
        if (this.levelData2[0] != -1) {
            this.loadData2ToData();
        }
        this.levelData2[0] = (byte)n;
        this.levelData2[1] = levelData[n * 8 + 0];
        this.levelData2[2] = levelData[n * 8 + 1];
        this.levelData2[3] = levelData[n * 8 + 2];
        this.levelData2[4] = levelData[n * 8 + 3];
        this.levelData2[5] = levelData[n * 8 + 4];
        this.levelData2[6] = levelData[n * 8 + 5];
        this.levelData2[7] = levelData[n * 8 + 6];
        this.levelData2[8] = levelData[n * 8 + 7];
        this.levelData2[9] = this.winjewels2[n];
    }

    public void loadData() {
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = PackHandler.getResourceAsDataStream("/data.bin");
            int[] nArray = new int[16];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = dataInputStream.readInt();
            }
            this.chapterData = new short[nArray[11]];
            for (n3 = 0; n3 < nArray[11]; ++n3) {
                this.chapterData[n3] = (short)dataInputStream.readInt();
            }
            this.distributions = new byte[this.jewelsRemap.length];
            levelData = new byte[nArray[1] * 8];
            this.levelData2 = new byte[10];
            this.levelData2[0] = -1;
            this.winjewels2 = new byte[nArray[1]];
            for (n3 = 0; n3 < nArray[1]; ++n3) {
                int[] nArray2 = new int[nArray[0]];
                for (n2 = 0; n2 < nArray[0]; ++n2) {
                    nArray2[n2] = dataInputStream.readInt();
                }
                JQ2009Game.levelData[n3 * 8 + 0] = (byte)nArray2[0];
                JQ2009Game.levelData[n3 * 8 + 1] = (byte)nArray2[1];
                JQ2009Game.levelData[n3 * 8 + 2] = (byte)(nArray2[2] + 0);
                JQ2009Game.levelData[n3 * 8 + 3] = (byte)nArray2[3];
                JQ2009Game.levelData[n3 * 8 + 4] = (byte)nArray2[4];
                if (nArray2[5] > 100) {
                    this.winjewels2[n3] = (byte)(nArray2[5] / 100);
                }
                JQ2009Game.levelData[n3 * 8 + 5] = (byte)(nArray2[5] % 100);
                JQ2009Game.levelData[n3 * 8 + 6] = (byte)nArray2[6];
                JQ2009Game.levelData[n3 * 8 + 7] = (byte)nArray2[7];
                if (levelData[n3 * 8 + 4] != 0) continue;
                JQ2009Game.levelData[n3 * 8 + 2] = (byte)(levelData[n3 * 8 + 2] + 0);
            }
            this.aiParams = new short[nArray[4]][nArray[3]];
            for (n3 = 0; n3 < nArray[4]; ++n3) {
                for (int i = 0; i < nArray[3]; ++i) {
                    this.aiParams[n3][i] = (short)dataInputStream.readInt();
                }
            }
            this.boardData = new short[nArray[8] * nArray[6] * nArray[7]];
            for (n3 = 0; n3 < this.boardData.length; ++n3) {
                this.boardData[n3] = (short)dataInputStream.readInt();
            }
            this.animationZones = new int[nArray[13]][];
            for (n3 = 0; n3 < this.animationZones.length; ++n3) {
                int n4 = dataInputStream.readInt();
                this.animationZones[n3] = new int[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    this.animationZones[n3][n2] = dataInputStream.readInt();
                }
            }
            n3 = dataInputStream.readInt();
            this.awardsScores = new int[n3];
            for (n = 0; n < this.awardsScores.length; ++n) {
                this.awardsScores[n] = dataInputStream.readInt();
            }
            n3 = dataInputStream.readInt();
            this.backgroundTiles = new int[n3];
            for (n = 0; n < this.backgroundTiles.length; ++n) {
                this.backgroundTiles[n] = dataInputStream.readInt();
            }
            n3 = dataInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                dataInputStream.readInt();
            }
            n3 = dataInputStream.readInt();
            this.tutorialMoves = new int[n3][];
            for (n = 0; n < this.tutorialMoves.length; ++n) {
                this.tutorialMoves[n] = new int[4];
                for (n2 = 0; n2 < this.tutorialMoves[n].length; ++n2) {
                    this.tutorialMoves[n][n2] = dataInputStream.readInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPowerupsLevel(int n) {
        if (n >= 29) {
            return 3;
        }
        if (n >= 20) {
            return 2;
        }
        if (n >= 12) {
            return 1;
        }
        if (n >= 0) {
            return 0;
        }
        return -1;
    }

    public int getChapter(int n) {
        int n2 = 0;
        for (int i = 0; i < this.chapterData.length; ++i) {
            if (n >= (n2 += this.chapterData[i])) continue;
            return i;
        }
        return -1;
    }

    public int getChaptersCount() {
        return this.chapterData.length;
    }

    public int getChapterLevelCount(int n) {
        return this.chapterData[n];
    }

    public int getStoryLevelsCount() {
        int n = 0;
        for (int i = 0; i < this.chapterData.length; ++i) {
            n += this.chapterData[i];
        }
        return n;
    }

    public boolean isFirstLevelInChapter(int n) {
        if (n < this.getStoryLevelsCount()) {
            int n2 = 0;
            for (int i = 0; i < this.chapterData.length; ++i) {
                if (n == n2) {
                    return true;
                }
                n2 += this.chapterData[i];
            }
        }
        return false;
    }

    private final void setSubstate(int n) {
        int n2 = this.gameSubstate;
        this.gameSubstate = n;
        this.substateChanged(n2, n);
    }

    private final void substateChanged(int n, int n2) {
        switch (n2) {
            case 7: {
                TimerHandler.resetTimer(10);
                break;
            }
            case 12: {
                this.m_board.deselectCells();
                this.selected = false;
                TimerHandler.resetTimer(3);
                this.currentZone = 0;
                this.m_board.destroyAnimatedZone(this.animationZones[this.currentZone]);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                TimerHandler.resumeTimer(0);
            }
        }
    }

    private final int getSubstate() {
        return this.gameSubstate;
    }

    public final int getEndConditionCodes() {
        return this.endConditionsCodes;
    }

    public final void setEndConditionCodes(int n) {
        this.endConditionsCodes = n;
    }

    public final boolean IsJewelsTwoTypes() {
        return this.getJewelsToWinCount(1) > 0;
    }

    public final boolean IsJewelsOnePlayer() {
        return this.getJewelsToWinCount(0) > 0;
    }

    public final int getPlayerJewels(int n) {
        if (n == 0) {
            return this.playerJewels;
        }
        return this.playerJewels2;
    }

    public final void setPlayerJewels(int n, int n2) {
        if (n == 0) {
            this.playerJewels = n2;
            if (this.playerJewels > this.getJewelsToWinCount(0)) {
                this.playerJewels = this.getJewelsToWinCount(0);
            }
        } else {
            this.playerJewels2 = n2;
            if (this.playerJewels2 > this.getJewelsToWinCount(1)) {
                this.playerJewels2 = this.getJewelsToWinCount(1);
            }
        }
    }

    public final void setCpuJewels(int n, int n2) {
        if (n == 0) {
            this.cpuJewels = n2;
            if (this.cpuJewels > this.getJewelsToWinCount(0)) {
                this.cpuJewels = this.getJewelsToWinCount(0);
            }
        } else {
            this.cpuJewels2 = n2;
            if (this.cpuJewels2 > this.getJewelsToWinCount(1)) {
                this.cpuJewels2 = this.getJewelsToWinCount(1);
            }
        }
    }

    public final int getCpuJewels(int n) {
        if (n == 0) {
            return this.cpuJewels;
        }
        return this.cpuJewels2;
    }

    public final byte getJewelsType(int n) {
        return this.JewelsType[n];
    }

    public final int getLevelAI(int n) {
        return levelData[n * 8 + 1];
    }

    public final int getCurrentBossFrame() {
        int n = levelData[this.getCurrentLevel() * 8 + 4] - 1;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected final boolean processJQ2009GameLoadEvent(int n) {
        switch (n) {
            case 6: {
                this.loadTextSection(2);
                this.gBuffer = this.backBuffer.getGraphics();
                break;
            }
            case 7: {
                this.player = 0;
                this.cpuChosenMove = -1;
                this.fullRedraw = true;
                break;
            }
            case 8: {
                int n2;
                this.m_board = new MatchThreeBoard(this, 8, 8);
                if (this.isTutorialEnabled() && this.getCurrentLevel() == 0) {
                    this.m_board.setWinnerTile(0, 0);
                } else {
                    this.m_board.setWinnerTile(0, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                    if (this.getCurrentLevel() <= 0) {
                        while (this.m_board.getWinnerTile(0) == 2) {
                            this.m_board.setWinnerTile(0, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                        }
                    }
                    if (this.IsJewelsTwoTypes()) {
                        this.m_board.setWinnerTile(1, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                        while (this.m_board.getWinnerTile(1) == 2 || this.m_board.getWinnerTile(1) == this.m_board.getWinnerTile(0)) {
                            this.m_board.setWinnerTile(1, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                        }
                    }
                    this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(0));
                }
                if (MultiPlayermode == 2) {
                    this.m_board.setWinnerTile(0, this.jewelsRemap.length - 1);
                }
                int n3 = this.getCurrentLevel() + 1;
                for (n2 = 0; n2 < this.getChaptersCount() - 1 && (n3 -= this.getChapterLevelCount(n2)) > 0; ++n2) {
                }
                for (int i = 0; i < this.JewelsType.length - 1; ++i) {
                    this.JewelsType[i] = (byte)n2;
                }
                this.moves = new byte[512];
                this.loadGameState();
                break;
            }
            case 10: {
                int n4 = 0;
                try {
                    n4 = this.getChapter(this.getCurrentLevel()) + 1;
                    mStorySpac = null;
                    int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE[this.getCurrentLevel()]};
                    if (this.isFirstLevelInChapter(this.getCurrentLevel())) {
                        nArray = 6 + STORY_IMAGE2[n4 - 1] < 6 + STORY_IMAGE[this.getCurrentLevel()] ? new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE2[n4 - 1], 6 + STORY_IMAGE[this.getCurrentLevel()]} : new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE[this.getCurrentLevel()], 6 + STORY_IMAGE2[n4 - 1]};
                    } else if (this.isFirstLevelInChapter(this.getCurrentLevel() + 1)) {
                        nArray = 6 + STORY_IMAGE2[n4] < 6 + STORY_IMAGE[this.getCurrentLevel()] ? new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE2[n4], 6 + STORY_IMAGE[this.getCurrentLevel()]} : new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE[this.getCurrentLevel()], 6 + STORY_IMAGE2[n4]};
                    }
                    if (this.getCurrentLevel() == levelData.length / 8 - 1) {
                        nArray = new int[]{0, 1, 2, 3, 4, 5, 6 + STORY_IMAGE[this.getCurrentLevel()], 38, 39};
                    }
                    mStorySpac = SpacFile.loadSpac("/story.uspac", "/storycorners.png,/storydirt1.png,/storyhoriz.png,/storyvert.png,/gamemap.png,/goldenroad.png,/Stage1.png,/Level1-1.png,/Level1-2.png,/Level1-3.png,/Level1-4.png,/Level1-5.png,/Level1-7.png,/Level1-8.png,/Level1-10.png,/Level1-11.png,/Level1-12.png,/Stage1end.png,/Level2-1.png,/Level2-2.png,/Level2-4.png,/Level2-5.png,/Level2-7.png,/Level2-8.png,/Level2-9.png,/Level2-10.png,/Level2-11.png,/Level2-12.png,/Stage2end.png,/Level3-2.png,/Level3-5.png,/Level3-6.png,/Level3-7.png,/Level3-8.png,/Level3-9.png,/Level3-10.png,/Level3-11.png,/Level3-12.png,/Stage3end.png,/Gameend.png", null, 40, nArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (mCommonLevelSpac == null) {
                    int n5 = TextHandler.getLanguage() * 3;
                    int[] nArray = new int[]{0, 1, 2 + n5, 3 + n5, 4 + n5};
                    mCommonLevelSpac = SpacFile.loadSpac("/commonlevelgraphics.uspac", "/tiles.png,/cursor.png,/newaward.png,/youlose.png,/youwin.png,/newawardfrench.png,/youlosefrench.png,/youwinfrench.png,/newawarditalian.png,/youloseitalian.png,/youwinitalian.png,/newawardgerman.png,/youlosegerman.png,/youwingerman.png,/newawardspanish.png,/youlosespanish.png,/youwinspanish.png", null, 17, nArray);
                }
                if (mSpecificLevelSpac == null) {
                    mSpecificLevelSpac = SpacFile.loadSpac("/specificlevelgraphics.uspac", "/background" + n4 + ".png" + "," + "/borders" + n4 + ".png" + "," + "/bckgtile" + n4 + ".png", null);
                }
                if (this.mJewelsSpac == null) {
                    this.mJewelsSpac = SpacFile.loadSpac("/jewels.uspac", "/jewels.png,/jewelssmall.png,/coin1.png", null);
                }
                this.mIconAnimation = new SpacSprite(this.mJewelsSpac, 17, true);
                this.mIconAnimation.setSequence(17, 1, 0, true);
                if (this.JewelsAnimation == null) {
                    this.JewelsAnimation = new SpacSprite[8];
                    for (int i = 0; i < 8; ++i) {
                        this.JewelsAnimation[i] = new SpacSprite(this.mJewelsSpac, 0, true);
                        this.JewelsAnimation[i].setSequence(0, 0, 0, true);
                    }
                }
                this.JewelsAnimationXY = new byte[24];
                if (mPowerupSpac == null) {
                    mPowerupSpac = SpacFile.loadSpac("/powerup.uspac", "/powerup.png,/powerup_1.png", null);
                }
                if (this.mPowerupAnimation == null) {
                    this.mPowerupAnimation = new SpacSprite[this.powerups.length + 2];
                    this.mPowerupAnimation[0] = new SpacSprite(mPowerupSpac, 1, true);
                    this.mPowerupAnimation[0].setSequence(1, 0, 0, true);
                    for (int i = 1; i < this.powerups.length + 1; ++i) {
                        this.mPowerupAnimation[i] = new SpacSprite(mPowerupSpac, 6 + (i - 1), true);
                        this.mPowerupAnimation[i].setSequence(6 + (i - 1), 1, 0, true);
                    }
                    this.mPowerupAnimation[this.powerups.length + 1] = new SpacSprite(mPowerupSpac, 14, true);
                    this.mPowerupAnimation[this.powerups.length + 1].setSequence(14, 1, 0, true);
                }
                if (mEffectSpac == null) {
                    mEffectSpac = SpacFile.loadSpac("/effect.uspac", "/effect1.png,/effect2.png,/effect3.png,/effect4.png,/effect5.png,/effect6.png", null);
                    this.mEffectAnimation = new SpacSprite[10];
                    for (int i = 0; i < 10; ++i) {
                        this.mEffectAnimation[i] = new SpacSprite(mEffectSpac, 0, true);
                        this.mEffectAnimation[i].setSequence(0, 0, 0, true);
                    }
                }
                this.EffectAnimationXY = new int[30];
                if (mHudSpac == null) {
                    mHudSpac = SpacFile.loadSpac("/interface.uspac", "/interface.png,/coin.png,/interface2.png", null);
                }
                if (mMenuInGameSpac == null) {
                    mMenuInGameSpac = SpacFile.loadSpac("/menuingame.uspac", "/menuglow.png,/menuingameraster.png,/storycorners.png,/storyhoriz.png,/storyvert.png,/storyhoriz_2.png,/storydirt1.png", null);
                }
                if (this.isTutorialEnabled() && mSpecialCursorSpac == null) {
                    mSpecialCursorSpac = SpacFile.loadSpac("/specialcursor.uspac", "/specialcursor.png,/tutorialmessages.png", null);
                }
                if (this.getLevelAI(this.getCurrentLevel()) != 0) {
                    if (mRupertSpac == null) {
                        mRupertSpac = SpacFile.loadSpac("/rupert.uspac", "/rupert.png", null);
                        mRupertSpacAnimation = new SpacSprite(mRupertSpac, 1, true);
                        mRupertSpacAnimation.setSequence(1, 1, 0, true);
                    }
                    RupertState = 2;
                    BossState = 2;
                    if (mBossSpac == null) {
                        int[] nArray = new int[]{this.getCurrentBossFrame()};
                        mBossSpac = SpacFile.loadSpac("/boss.uspac", "/boss" + (nArray[0] + 1) + ".png", null, 79, nArray);
                    }
                    if (mBossSpac != null) {
                        mBossSpacAnimation = new SpacSprite(mBossSpac, 1, true);
                        mBossSpacAnimation.setSequence(1 + this.getCurrentBossFrame() * 7, 1, 0, true);
                    }
                }
                this.loadAnimationsData();
                break;
            }
            case 9: {
                int[] nArray;
                this.cellSize = mCommonLevelSpac.getFrameRect(0)[2];
                this.borderHeight = mSpecificLevelSpac.getFrameRect(5)[3];
                if (MultiPlayermode == 0 && this.IsJewelsTwoTypes()) {
                    nArray = mHudSpac.getFrameRect(11);
                    this.bossHudLeftTextX = nArray[0] - (nArray[2] >> 2);
                    this.bossHudLeftTextY = nArray[1] + (nArray[3] - this.getSharedFont().getHeight() >> 1);
                    this.bossHudRightTextX = nArray[0] + (nArray[2] >> 2) + nArray[2];
                    this.bossHudRightTextY = nArray[1] + (nArray[3] - this.getSharedFont().getHeight() >> 1);
                } else {
                    nArray = mHudSpac.getFrameRect(4);
                    this.bossHudLeftTextX = nArray[0] + (nArray[2] >> 1);
                    this.bossHudLeftTextY = nArray[1] + (nArray[3] - this.getSharedFont().getHeight() >> 1);
                    nArray = mHudSpac.getFrameRect(5);
                    this.bossHudRightTextX = nArray[0] + (nArray[2] >> 1);
                    this.bossHudRightTextY = nArray[1] + (nArray[3] - this.getSharedFont().getHeight() >> 1);
                }
                int n6 = this.m_board.getWidth() * this.cellSize;
                int n7 = this.m_board.getHeight() * this.cellSize;
                this.boardStartX = this.screenWidth - n6 >> 1;
                this.boardStartY = this.screenHeight - n7 - this.getSoftKeyBarSize() - this.borderHeight;
                nArray = mHudSpac.getFrameRect(6);
                this.hudLeftTextX = nArray[0];
                this.hudLeftTextY = nArray[1];
                nArray = mHudSpac.getFrameRect(7);
                this.hudRightTextX = nArray[0] + (nArray[2] >> 1);
                this.hudRightTextY = nArray[1] + (nArray[3] - this.getSharedFont().getHeight() >> 1);
                TimerHandler.initTimers(12);
                if (this.getGameMode() == 2) {
                    if (this.getCurrentLevel() == 0) {
                        this.setJQ2009GameState(1);
                        break;
                    }
                    if (this.isFirstLevelInChapter(this.getCurrentLevel())) {
                        this.setJQ2009GameState(2);
                        break;
                    }
                    this.setJQ2009GameState(3);
                    break;
                }
                this.setJQ2009GameState(4);
                break;
            }
        }
        return true;
    }

    public final void sortCpuScores() {
        int n;
        int[] nArray = new int[100];
        byte[] byArray = new byte[200];
        for (n = 0; n < this.cpuMoveScores.length; ++n) {
            int n2 = this.cpuMoveScores[n];
            nArray[n2] = nArray[n2] + 1;
            if (this.getBossPowerup() == -1) {
                byArray[this.cpuMoveScores[n] << 1] = this.moves[n << 1];
                byArray[(this.cpuMoveScores[n] << 1) + 1] = this.moves[(n << 1) + 1];
                continue;
            }
            byArray[this.cpuMoveScores[n]] = this.powerupMoves[n];
        }
        n = 0;
        for (int i = 0; i < 100; ++i) {
            if (nArray[i] == 0) continue;
            for (int j = 0; j < nArray[i]; ++j) {
                if (this.getBossPowerup() == -1) {
                    this.cpuMoveScores[n >> 1] = i;
                    this.moves[n++] = byArray[i << 1];
                    this.moves[n++] = byArray[(i << 1) + 1];
                    continue;
                }
                this.cpuMoveScores[n] = i;
                this.powerupMoves[n++] = byArray[i];
            }
        }
        if (this.getBossPowerup() != -1) {
            this.moves[n] = -1;
        }
    }

    public final int firstNonZeroScore() {
        for (int i = 0; i < this.cpuMoveScores.length; ++i) {
            if (this.cpuMoveScores[i] == 0) continue;
            return i;
        }
        return -1;
    }

    protected final void preRenderJQ2009Game(int n) {
        try {
            this.stateChangedThisTick = false;
            int n2 = this.getJQ2009GameState();
            if (++iClock > 20000) {
                iClock = 0;
            }
            switch (n2) {
                case 10: {
                    if (!this.wasKeyPressed(21) && !this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) break;
                    if (this.cheatShowText - 1 < this.awards.length + 1) {
                        ++this.cheatShowText;
                        break;
                    }
                    this.cheatShowText = 0;
                    TimerHandler.resumeTimer(0);
                    this.setJQ2009GameState(7);
                    break;
                }
                case 0: {
                    if (!this.wasKeyPressed(21) && !this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) break;
                    TimerHandler.resumeTimer(0);
                    if (this.isTwoPlayerMode()) {
                        TimerHandler.resumeTimer(7);
                    }
                    this.setJQ2009GameState(7);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 13: {
                    this.preRenderWelcomeScreen();
                    break;
                }
                case 5: {
                    if (MultiPlayermode != 0 && this.isTwoPlayerMode()) {
                        this.updateCharPos((int)TimerHandler.getTimer(7));
                    }
                    this.preRenderLevelObjective();
                    break;
                }
                case 6: {
                    this.preRenderTutorialDialog(n);
                    break;
                }
                case 4: {
                    this.preRenderStartLevel();
                    break;
                }
                case 8: {
                    this.preRenderInLevelAwards();
                    break;
                }
                case 9: {
                    this.preRenderEndLevelAwards();
                    break;
                }
                case 11: {
                    if (iClock % 5 == 0) {
                        int n3 = Math.abs(this.getRandom().nextInt()) % this.screenWidth;
                        int n4 = Math.abs(this.getRandom().nextInt()) % (this.screenHeight >> 2);
                        int[] nArray = new int[]{15, Math.abs(this.getRandom().nextInt()) % this.jewelsRemap.length};
                        this.initAnimation(0, n3, n4, nArray);
                    }
                    this.updateAnimations(n);
                    if (MultiPlayermode == 0) {
                        this.preRenderLevelWonOrLost(true, n);
                    } else if (MultiPlayer1Win > MultiPlayer2Win) {
                        this.preRenderLevelWonOrLost(true, n);
                    } else if (MultiPlayer2Win > MultiPlayer1Win) {
                        this.preRenderLevelWonOrLost(false, n);
                    }
                    this.preRenderLevelWon();
                    break;
                }
                case 12: {
                    this.preRenderLevelWonOrLost(false, n);
                    this.preRenderLevelLost();
                    break;
                }
                case 15: {
                    this.preRenderGameEnd();
                    break;
                }
                case 7: {
                    this.preRenderGameMain(n);
                    break;
                }
                case 14: {
                    this.preRenderPowerup(n);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void preRenderStartLevel() {
        this.initRound();
        this.preRenderChooseAHint();
        this.setJQ2009GameState(7);
        if (this.isSoundEnabled()) {
            if (this.getLevelAI(this.getCurrentLevel()) != 0) {
                this.playSound(11, 0);
            } else {
                this.playSound(12, 0);
            }
        }
        this.soundplay = (byte)70;
    }

    private final boolean managePowerupAnims() {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = !this.isTwoPlayerMode() || (this.endConditionsCodes & 0x4007) != 1;
        if (!this.isTwoPlayerMode() && this.IsJewelsOnePlayer()) {
            bl = false;
        }
        switch (this.powerups[this.currentPowerup]) {
            case 0: {
                int n = this.m_board.getIndexedCellProperty(this.m_board.getCellIndex(this.xPos, this.yPos), 0, 7);
                boolean bl4 = this.m_board.destroyAllAnimatedCells(bl, true, false);
                if (!bl4 || n == 7) break;
                this.m_board.offsetTheWaves(2, 8, 2);
                break;
            }
            case 2: {
                affectedByPowerup2 = true;
                this.m_board.handleCellSelect(PowerupCells1);
                this.m_board.handleCellSelect(PowerupCells2);
                PowerupCells1 = (byte)-1;
                PowerupCells2 = (byte)-1;
                this.m_board.unmarkBoard(-1, false);
                break;
            }
            case 3: {
                bl2 = this.m_board.destroyAnimatedCellsRandomly(5, bl);
                break;
            }
            case 1: {
                int n = this.m_board.getIndexedCellProperty(this.m_board.getCellIndex(this.xPos, this.yPos), 0, 7);
                boolean bl5 = this.m_board.destroyAllAnimatedCells(bl, true, true);
                if (!bl5 || n == 7) break;
                this.m_board.offsetTheWaves(2, 8, 2);
                break;
            }
        }
        return bl2;
    }

    private int[] getBlazeShape(int n) {
        int n2 = n % this.m_board.getWidth();
        int n3 = n / this.m_board.getWidth();
        int n4 = Math.max(n2 - 1, 0);
        int n5 = Math.min(n2 + 1, this.m_board.getWidth() - 1);
        int n6 = Math.max(n3 - 1, 0);
        int n7 = Math.min(n3 + 1, this.m_board.getHeight() - 1);
        int[] nArray = new int[]{n4, n6, n5, n7};
        return nArray;
    }

    private final void markBlaze(int n) {
        int[] nArray = this.getBlazeShape(n);
        this.m_board.markRow(this.yPos, nArray[0], nArray[2]);
        this.m_board.markColumn(this.xPos, nArray[1], nArray[3]);
    }

    private final void firePowerup() {
        this.affectedByPowerup = true;
        this.m_board.prepareAnimFromMarked();
        this.setJQ2009GameState(7);
        if (this.powerups[this.currentPowerup] == 3) {
            TimerHandler.resetTimer(6);
        }
        this.powerupAnimsHandled = false;
        if (this.isSoundEnabled()) {
            this.playSound(13, 0);
        }
    }

    private final void markSelectedTile(int n) {
        this.m_board.setIndexedCellProperty(n, 1, 20, 0x100000);
        if (!this.m_board.isEvaluationMode()) {
            this.m_board.setIndexedCellProperty(n, 1, 11, 2048);
        }
        if (!this.m_board.isEvaluationMode()) {
            this.startTileAnim(n, 3, false);
        }
        if (!this.m_board.isEvaluationMode()) {
            this.m_board.setShockWaveRect(n % this.m_board.getWidth(), n / this.m_board.getWidth(), n % this.m_board.getWidth(), n / this.m_board.getWidth());
        }
    }

    private final void markBreakColor(int n, boolean bl) {
        this.m_board.markAllColors(this.m_board.getIndexedCellProperty(n, 0, 7), bl);
    }

    private final void prePowerupAnimation(int n) {
        for (int i = 1; i < this.powerups.length + 1; ++i) {
            if (this.getBossPowerup() != -1 || this.getCoins() >= this.getPowerupCost(i - 1)) {
                this.mPowerupAnimation[i].setSequence(10 + (i - 1), 1, 0, true);
                continue;
            }
            this.mPowerupAnimation[i].setSequence(6 + (i - 1), 1, 0, true);
        }
        if (this.mPowerupAnimation[n + 1].getSequence() == 10 + n) {
            this.mPowerupAnimation[n + 1].setSequence(2 + n, 1, 0, true);
        }
        this.mPowerupAnimation[this.powerups.length + 1].setSequence(14 + n, 1, 0, true);
    }

    private final void preChoosePowerup(int n, boolean bl) {
        if (!(this.getBossPowerup() == -1 && (bl && this.currentPowerup == n || this.powerups[n] <= -1 || bl && !this.mPowerupAnimation[0].isAnimationComplete()))) {
            this.currentPowerup2 = n;
            this.mPowerupAnimation[0].setSequence(1, 0, 0, true);
            this.prePowerupAnimation(n);
        }
    }

    private final boolean prePowerupPosition(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.powerups[this.currentPowerup] == 1) {
            n5 = this.m_board.getCellProperties(this.xPos, this.yPos);
            n4 = this.m_board.getCellProperty(n5, 5, 96);
            if (n4 == 0) {
                if (this.hammerAnimation != null && this.hammerAnimation.getSequence() != 13) {
                    this.hammerAnimation.setSequence(13, 1, 0, true);
                }
                return false;
            }
            if (this.hammerAnimation != null && this.hammerAnimation.getSequence() != 9) {
                this.hammerAnimation.setSequence(9, 1, 0, true);
            }
        } else if (this.powerups[this.currentPowerup] == 0) {
            n5 = this.m_board.getCellProperties(this.xPos, this.yPos);
            n4 = this.m_board.getCellProperty(n5, 5, 96);
            if (n4 != 0) {
                if (this.hammerAnimation != null && this.hammerAnimation.getSequence() != 12) {
                    this.hammerAnimation.setSequence(12, 1, 0, true);
                }
                return false;
            }
            if (this.hammerAnimation != null && this.hammerAnimation.getSequence() != 8) {
                this.hammerAnimation.setSequence(8, 1, 0, true);
            }
        } else if (this.powerups[this.currentPowerup] == 2 && PowerupCells1 != -1) {
            n5 = PowerupCells1 % 8;
            n4 = PowerupCells1 / 8;
            if (n5 == this.xPos ? Math.abs(n4 - this.yPos) == 1 : n4 == this.yPos && Math.abs(n5 - this.xPos) == 1) {
                return false;
            }
        }
        return (n4 = this.m_board.getCellProperty(n5 = this.m_board.getCellProperties(this.xPos, this.yPos), 0, 7)) >= 0 && n4 <= 5;
    }

    private final void preRenderPowerup(int n) {
        boolean bl;
        this.m_board.setIndexedCellProperty(this.hintChoice[0], 1, 11, 2048);
        this.m_board.setIndexedCellProperty(this.hintChoice[1], 1, 11, 2048);
        this.updateTiles(n);
        boolean bl2 = this.wasKeyPressed(2) || this.wasKeyPressed(15);
        boolean bl3 = this.wasKeyPressed(8) || this.wasKeyPressed(16);
        boolean bl4 = this.wasKeyPressed(4) || this.wasKeyPressed(17);
        boolean bl5 = this.wasKeyPressed(6) || this.wasKeyPressed(18);
        boolean bl6 = bl = this.wasKeyPressed(5) || this.wasKeyPressed(14);
        if ((this.getBossPowerup() != -1 || gameTutorialTime > 0L) && this.wasKeyPressed(22)) {
            this.pauseJQ2009Game();
        }
        if (this.getBossPowerup() != -1) {
            bl2 = false;
            bl3 = false;
            bl4 = false;
            bl5 = false;
            bl = false;
        }
        if (gameTutorialTime > 0L) {
            if (System.currentTimeMillis() - gameTutorialTime > 5000L) {
                this.m_board.unmarkBoard(-1, false);
                this.setJQ2009GameState(7);
                gameTutorialTime = -1L;
            } else {
                return;
            }
        }
        switch (this.powerUpState) {
            case 0: {
                int n2;
                if (this.getBossPowerup() != -1 && TimerHandler.getTimer(8) >= 1000L) {
                    if (this.currentPowerup == -1 || this.currentPowerup2 != this.getBossPowerup()) {
                        switch (this.getBossPowerup()) {
                            case 0: {
                                bl4 = true;
                                break;
                            }
                            case 1: {
                                bl2 = true;
                                break;
                            }
                            case 2: {
                                bl5 = true;
                                break;
                            }
                            case 3: {
                                bl3 = true;
                            }
                        }
                    } else {
                        this.currentPowerup = this.currentPowerup2;
                        if (this.powerups[this.currentPowerup] == -1) {
                            this.powerups[this.currentPowerup] = this.currentPowerup;
                            this.bossPower = (byte)this.currentPowerup;
                        }
                        bl = true;
                    }
                    TimerHandler.resetTimer(8);
                }
                if (this.mPowerupAnimation != null) {
                    for (n2 = 0; n2 < this.powerups.length + 2; ++n2) {
                        if (!this.mPowerupAnimation[n2].isAnimationComplete()) {
                            this.mPowerupAnimation[n2].updateSprite(n);
                            continue;
                        }
                        switch (this.mPowerupAnimation[n2].getSequence()) {
                            case 1: {
                                this.currentPowerup = this.currentPowerup2;
                                this.mPowerupAnimation[n2].setSequence(0, 0, 0, true);
                            }
                        }
                    }
                }
                n2 = this.currentPowerup;
                if (bl3) {
                    this.preChoosePowerup(3, true);
                    break;
                }
                if (bl2) {
                    this.preChoosePowerup(1, true);
                    break;
                }
                if (bl4) {
                    this.preChoosePowerup(0, true);
                    break;
                }
                if (bl5) {
                    this.preChoosePowerup(2, true);
                    break;
                }
                if ((bl || this.getBossPowerup() == -1 && this.wasKeyPressed(21)) && this.currentPowerup != -1) {
                    if (this.getBossPowerup() == -1 && this.mPowerupAnimation != null && !this.mPowerupAnimation[0].isAnimationComplete()) break;
                    boolean bl7 = false;
                    this.currentPowerup = this.currentPowerup2;
                    if (this.getBossPowerup() != -1) {
                        bl7 = true;
                        JQ2009Game.setCPUStoryCoins(JQ2009Game.getCPUCoins() - this.getPowerupCost(this.bossPowerup));
                    } else if (this.currentPowerup == 0 && this.getCoins() >= 1) {
                        bl7 = true;
                    } else if (this.currentPowerup == 1 && this.getCoins() >= 2) {
                        bl7 = true;
                    } else if (this.currentPowerup == 2 && this.getCoins() >= 3) {
                        bl7 = true;
                    } else if (this.currentPowerup == 3 && this.getCoins() >= 6) {
                        bl7 = true;
                    } else if (this.currentPowerup == -1) {
                        if (this.getBossPowerup() == -1) {
                            this.m_board.unmarkBoard(-1, false);
                            this.setPositiveSoftkey(this.getPowerupSoftkey());
                            this.setJQ2009GameState(7);
                        }
                    } else {
                        TimerHandler.resetTimer(11);
                    }
                    if (bl7) {
                        if (this.getBossPowerup() != -1) {
                            this.changePowerup(-1, -1, this.currentPowerup);
                        } else {
                            this.changePowerup(-1, -1, this.currentPowerup == -1 ? this.currentPowerup : this.powerups[this.currentPowerup]);
                        }
                    }
                    if (!this.m_board.areThereMarked() && this.powerups[this.currentPowerup] != 3 || !bl7) break;
                    TimerHandler.setTimer(8, 600L);
                    PowerupCells1 = (byte)-1;
                    PowerupCells2 = (byte)-1;
                    if (this.hammerAnimation != null) {
                        this.hammerAnimation.setSequence(8 + this.currentPowerup, 1, 0, true);
                    }
                    this.fullRedraw = true;
                    this.powerUpState = 1;
                    this.m_board.deselectCells();
                    this.selected = false;
                    this.setPositiveSoftkey(this.getPowerupSoftkey());
                    this.setNegativeSoftkey(this.getBackSoftKey());
                    break;
                }
                if (!this.wasKeyPressed(22) && (!this.wasKeyPressed(14) && !this.wasKeyPressed(21) && !this.wasKeyPressed(5) || this.currentPowerup != -1) || this.getBossPowerup() != -1) break;
                this.m_board.unmarkBoard(-1, false);
                this.setPositiveSoftkey(this.getPowerupSoftkey());
                this.setJQ2009GameState(7);
                break;
            }
            case 1: {
                int n3;
                boolean bl8 = this.prePowerupPosition(n, this.xPos, this.yPos);
                if (bl) {
                    n3 = this.m_board.getCellIndex(this.xPos, this.yPos);
                    if (this.powerups[this.currentPowerup] == 0 && this.m_board.getIndexedCellProperty(n3, 0, 7) == 7 && this.m_board.getIndexedCellProperty(n3, 3, 24) == 0) {
                        bl = false;
                    }
                    if (this.powerups[this.currentPowerup] == 3 && this.m_board.getIndexedCellProperty(n3, 0, 7) == 7) {
                        bl = false;
                    }
                }
                n3 = 0;
                if (this.getBossPowerup() != -1 && TimerHandler.getTimer(8) >= 1000L) {
                    TimerHandler.setTimer(8, 600L);
                    if (Math.abs(this.getRandom().nextInt()) % 100 > 49) {
                        if (bossPowerup2Y > this.yPos) {
                            bl3 = true;
                        } else if (bossPowerup2Y < this.yPos) {
                            bl2 = true;
                        } else if (bossPowerup2X > this.xPos) {
                            bl5 = true;
                        } else if (bossPowerup2X < this.xPos) {
                            bl4 = true;
                        }
                    } else if (bossPowerup2X > this.xPos) {
                        bl5 = true;
                    } else if (bossPowerup2X < this.xPos) {
                        bl4 = true;
                    } else if (bossPowerup2Y > this.yPos) {
                        bl3 = true;
                    } else if (bossPowerup2Y < this.yPos) {
                        bl2 = true;
                    }
                    if (bossPowerup2Y == this.yPos && bossPowerup2X == this.xPos) {
                        if (this.powerups[this.currentPowerup] == 2 && PowerupCells1 == -1) {
                            bl = true;
                            bossPowerup2X = bossPowerup3X;
                            bossPowerup2Y = bossPowerup3Y;
                        } else {
                            bl = true;
                            n3 = 1;
                        }
                    }
                }
                int n4 = this.m_board.getCellIndex(this.xPos, this.yPos);
                this.moveCursor(bl2, bl3, bl4, bl5, false);
                this.hammerAnimation.updateSprite(n);
                if (bl2 || bl3 || bl4 || bl5) {
                    this.changePowerup(n4, -1, this.powerups[this.currentPowerup]);
                }
                if (bl && bl8) {
                    boolean bl9 = true;
                    if (this.currentPowerup == 2) {
                        if (PowerupCells1 == -1) {
                            PowerupCells1 = (byte)this.m_board.getCellIndex(this.xPos, this.yPos);
                            int n5 = this.m_board.getCellProperties(this.xPos, this.yPos);
                            int n6 = this.m_board.getCellProperty(n5, 5, 96);
                            if (n6 != 0) {
                                PowerupCells1 = (byte)-1;
                            }
                            bl9 = false;
                        } else {
                            bl9 = false;
                            PowerupCells2 = (byte)this.m_board.getCellIndex(this.xPos, this.yPos);
                            int n7 = this.m_board.getCellProperties(this.xPos, this.yPos);
                            int n8 = this.m_board.getCellProperty(n7, 5, 96);
                            if (n8 != 0) {
                                PowerupCells2 = (byte)-1;
                            }
                            if (PowerupCells1 == PowerupCells2) {
                                PowerupCells1 = (byte)-1;
                                PowerupCells2 = (byte)-1;
                            }
                            if (PowerupCells1 != -1 && PowerupCells2 != -1) {
                                bl9 = true;
                            }
                        }
                    }
                    if (bl9) {
                        if (this.getBossPowerup() == -1) {
                            if (this.currentPowerup == 0) {
                                this.setCoins(this.getCoins() - 1);
                            } else if (this.currentPowerup == 1) {
                                this.setCoins(this.getCoins() - 2);
                            } else if (this.currentPowerup == 2) {
                                this.setCoins(this.getCoins() - 3);
                            } else if (this.currentPowerup == 3) {
                                this.setCoins(this.getCoins() - 6);
                            }
                        }
                        this.firePowerup();
                    }
                } else if (this.wasKeyPressed(21)) {
                    if (this.getBossPowerup() == -1) {
                        this.powerUpState = 0;
                        this.setPositiveSoftkey(this.getSelectSoftKey());
                    }
                } else if (this.wasKeyPressed(22) && this.getBossPowerup() == -1) {
                    this.m_board.unmarkBoard(-1, false);
                    this.setJQ2009GameState(7);
                }
                if (this.getBossPowerup() == -1 || n3 == 0) break;
                this.setBossPowerup(-1);
                TimerHandler.resetTimer(8);
                this.m_board.deselectCells();
                this.selected = false;
            }
        }
    }

    private final void changePowerup(int n, int n2, int n3) {
        this.drawMarked = true;
        int n4 = this.m_board.getCellIndex(this.xPos, this.yPos);
        boolean bl = this.m_board.getIndexedCellProperty(n4, 5, 96) == 2;
        boolean bl2 = n != -1 && this.m_board.getIndexedCellProperty(n, 5, 96) == 2;
        int n5 = -1;
        this.m_board.unmarkBoard(n5, !this.m_board.isEvaluationMode());
        if (this.m_board.isEvaluationMode()) {
            n4 = this.powerupMoves[this.cpuEvaluation];
        }
        switch (n3) {
            case 1: {
                this.markSelectedTile(n4);
                break;
            }
            case 0: {
                this.markSelectedTile(n4);
                break;
            }
            case 2: {
                this.markSelectedTile(n4);
                break;
            }
            case 3: {
                this.markBreakColor(n4, bl);
                this.drawMarked = !bl;
                break;
            }
        }
    }

    private final void SetObjectiveState() {
        if (MultiPlayermode == 0) {
            if (gameTutorialTime > 0L) {
                this.setJQ2009GameState(14);
            } else {
                this.setJQ2009GameState(7);
            }
        } else {
            if (MultiPlayerEnd) {
                gameStartTime = -1L;
                if ((MultiPlayerChallenge2 = (byte)(MultiPlayerChallenge2 + 1)) >= MultiPlayerChallenge) {
                    this.setJQ2009GameState(11);
                } else {
                    TimerHandler.resumeTimer(0);
                    this.setJQ2009GameState(4);
                }
                MultiPlayerEnd = false;
            } else {
                this.setJQ2009GameState(7);
            }
            if (MultiPlayerTimeReady) {
                MultiPlayerReadyGo = true;
                gamePauseTime = -1L;
                gameStartTime = System.currentTimeMillis();
                TimerHandler.resumeTimer(0);
            }
            isPreRenderMP = true;
        }
    }

    private final void preRenderLevelObjective() {
        if (MultiPlayermode != 0) {
            gameStartTime = -1L;
            TimerHandler.resetTimer(0);
        }
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            TimerHandler.resetTimer(0);
            TimerHandler.resumeTimer(0);
            if (this.isTutorialEnabled()) {
                if (this.getCurrentLevel() == 0) {
                    if (this.setTutorialStep(0)) {
                        this.initSpriteAnimation(mSpecialCursorSpac, 4, 1, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize, 0);
                    }
                } else if (this.getCurrentLevel() == 1) {
                    if (this.setTutorialStep(5)) {
                        int n = this.getCurrentLevel();
                        int[][] nArrayArray = new int[][]{{this.tutorialMoves[n][0], this.tutorialMoves[n][1]}};
                        this.m_board.setTutorialHighlight(nArrayArray);
                        this.initSpriteAnimation(mSpecialCursorSpac, 0, 1, this.boardStartX + this.tutorialMoves[n][0] * this.cellSize + (this.cellSize >> 1), this.boardStartY + this.tutorialMoves[n][1] * this.cellSize + this.cellSize, 5);
                    }
                } else if (this.getCurrentLevel() == 10) {
                    if (this.setTutorialStep(9)) {
                        int n = 2;
                        this.initSpriteAnimation(mSpecialCursorSpac, 8, 1, this.boardStartX + this.tutorialMoves[n][0] * this.cellSize + (this.cellSize >> 1), this.boardStartY + this.tutorialMoves[n][1] * this.cellSize + this.cellSize, 9, this.getText(131357));
                        TimerHandler.resetTimer(9);
                    }
                } else if (this.getCurrentLevel() == 17 && this.setTutorialStep(15)) {
                    this.initSpriteAnimation(mSpecialCursorSpac, 8, 1, this.boardStartX + 3 * this.cellSize + (this.cellSize >> 1), this.boardStartY + 3 * this.cellSize + this.cellSize, 9, this.getText(131357));
                    TimerHandler.resetTimer(9);
                }
                this.SetObjectiveState();
            } else {
                this.SetObjectiveState();
            }
            if (MultiPlayer1move && this.player == 0) {
                if (MultiPlayermode != 0) {
                    this.setCharPos(0, 0, 0, false, 0, 1280, false);
                    this.setCharPos(1, this.screenWidth + 18 + (this.screenWidth >> 1), 18, false, 0, 1280, false);
                } else {
                    this.setCharPos(0, 0, 0, false, 0, 320, false);
                    this.setCharPos(1, this.screenWidth + 18, 18, false, 0, 320, false);
                }
                MultiPlayer1move = false;
            } else if (MultiPlayer2move && this.player == 1) {
                if (MultiPlayermode != 0) {
                    this.setCharPos(0, -18 - (this.screenWidth >> 1), 18, false, 0, 1280, false);
                    this.setCharPos(1, this.screenWidth, 0, false, 0, 1280, false);
                } else {
                    this.setCharPos(0, -18, 18, false, 0, 320, false);
                    this.setCharPos(1, this.screenWidth, 0, false, 0, 320, false);
                }
                MultiPlayer2move = false;
            }
            TimerHandler.resetTimer(7);
            if (this.isTutorialEnabled() && !this.notDisplayYourTurn && this.getJQ2009GameState() == 7 && this.getCurrentLevel() == 0) {
                this.setPopUpDialog(this.getText(131366));
            }
        }
    }

    private final void preRenderTutorialDialog(int n) {
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            TimerHandler.resumeTimer(0);
            this.setJQ2009GameState(this.nextState);
            if (this.renderCoinPointer) {
                this.renderCoinPointer = false;
            }
            this.tutorialRepaintMain = false;
            if (this.getTutorialStep() == 10) {
                int n2 = this.getTileX(this.tutorialEmptyMoves[0]) + (this.getTileSize() >> 1);
                int n3 = this.getTileY(this.tutorialEmptyMoves[0]);
                this.initSpriteAnimation(mSpecialCursorSpac, 1, 1, n2, n3, 10, this.getText(131363));
                TimerHandler.resetTimer(9);
                this.updateAnimations(n);
            }
        }
    }

    private final void preRenderWelcomeScreen() {
        boolean bl = false;
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            if (this.storyTextLineIndex >= this.storyTextLines.length - this.storyTextPageHeight) {
                bl = true;
            } else if (this.storyTextLineIndex < this.storyTextLines.length - this.storyTextPageHeight) {
                ++this.storyTextLineIndex;
            }
        } else if (this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_UP_OR_NUM2)) {
            if (this.storyTextLineIndex > 0) {
                --this.storyTextLineIndex;
            }
        } else if (this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_DOWN_OR_NUM8)) {
            if (this.storyTextLineIndex < this.storyTextLines.length - this.storyTextPageHeight) {
                ++this.storyTextLineIndex;
            }
        } else if (this.wasKeyPressed(22) && this.getNegativeSoftkey() == this.getSkipSoftkey() && this.storyTextLineIndex <= this.storyTextLines.length - this.storyTextPageHeight) {
            bl = true;
        }
        if (bl) {
            switch (this.getJQ2009GameState()) {
                case 1: {
                    this.setJQ2009GameState(2);
                    break;
                }
                case 2: {
                    this.setJQ2009GameState(3);
                    break;
                }
                case 3: {
                    this.setJQ2009GameState(4);
                    break;
                }
                case 13: {
                    if (this.lastChapterPage == 0 && this.getChapter(this.getCurrentLevel()) == -1) {
                        ++this.lastChapterPage;
                        this.setJQ2009GameState(13);
                        break;
                    }
                    if (this.getChapter(this.getCurrentLevel()) == -1) {
                        this.setJQ2009GameState(15);
                    } else {
                        this.setGameState(9);
                    }
                    this.lastChapterPage = 0;
                }
            }
        }
    }

    public final void changeRoundTimer(int n) {
        int n2 = (int)TimerHandler.getTimer(0);
        if ((n2 -= n * (levelData[this.getCurrentLevel() * 8 + 2] * 60000) / 100) < 0) {
            n2 = 0;
        }
        TimerHandler.setTimer(0, n2);
    }

    public final void setRoundTimer(int n) {
        int n2 = n * (levelData[this.getCurrentLevel() * 8 + 2] * 60000) / 100;
        TimerHandler.setTimer(0, n2);
    }

    private final void preRenderGameMain(int n) {
        Object object;
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cheatShowText > 0) {
            this.setJQ2009GameState(10);
        }
        if (!(MultiPlayermode == 0 || this.isCharAnimFinished() && this.beginLevelAnimationStarted == 0)) {
            this.resetHint();
        } else if (!this.levelObjectiveShown && this.beginLevelAnimationStarted == 0) {
            Object object2;
            boolean bl = false;
            if (!this.isTwoPlayerMode()) {
                TimerHandler.resetTimer(0);
                if (this.getCurrentLevel() == 10 || this.getCurrentLevel() == 17) {
                    this.setPopUpText(this.getText(112), null);
                    bl = true;
                } else if (this.IsJewelsOnePlayer()) {
                    object = null;
                    object = new char[][]{Integer.toString(this.getJewelsToWinCount(0)).toCharArray(), this.getText(128 + this.m_board.getWinnerTile(0) + this.getJewelsType(this.m_board.getWinnerTile(0)) * 5)};
                    this.setPopUpText(this.getText(113), (char[][])object);
                    bl = true;
                } else {
                    this.setPopUpText(this.getText(111), null);
                    bl = true;
                }
            } else if (MultiPlayermode != 0) {
                object2 = null;
                MultiPlayer1Ready = true;
                switch (MultiPlayermode) {
                    case 1: {
                        String string;
                        object2 = new char[4][];
                        object2[0] = Integer.toString(1).toCharArray();
                        object2[1] = this.getText(128 + this.m_board.getWinnerTile(0) + this.getJewelsType(this.m_board.getWinnerTile(0)) * 5);
                        object2[2] = Integer.toString(30).toCharArray();
                        object2[3] = Integer.toString(MultiPlayerChallenge2 + 1).toCharArray();
                        if (MultiPlayerChallenge > 1) {
                            object = new String(this.getText(115));
                            string = new String(this.getText(120));
                            object = (String)object + "\n" + string;
                        } else {
                            object = "";
                            string = new String(this.getText(120));
                            object = string;
                        }
                        this.setPopUpText(object.toCharArray(), (char[][])object2);
                        break;
                    }
                    case 2: {
                        String string;
                        object2 = new char[4][];
                        object2[0] = Integer.toString(1).toCharArray();
                        object2[3] = Integer.toString(MultiPlayerChallenge2 + 1).toCharArray();
                        if (MultiPlayerChallenge > 1) {
                            object = new String(this.getText(115));
                            string = new String(this.getText(119));
                            object = (String)object + "\n" + string;
                        } else {
                            object = "";
                            string = new String(this.getText(119));
                            object = string;
                        }
                        this.setPopUpText(object.toCharArray(), (char[][])object2);
                        break;
                    }
                    case 3: {
                        String string;
                        object2 = new char[4][];
                        object2[0] = Integer.toString(1).toCharArray();
                        object2[1] = this.getText(117);
                        object2[3] = Integer.toString(MultiPlayerChallenge2 + 1).toCharArray();
                        if (MultiPlayerChallenge > 1) {
                            object = new String(this.getText(115));
                            string = new String(this.getText(116));
                            object = (String)object + "\n" + string;
                        } else {
                            object = "";
                            string = new String(this.getText(116));
                            object = string;
                        }
                        this.setPopUpText(object.toCharArray(), (char[][])object2);
                    }
                }
                bl = true;
            } else {
                Object object3;
                Object object4;
                object = new byte[]{0, 1, 3, 2, 2, 2, 4, 6, 8, 9};
                byte by = levelData[this.getCurrentLevel() * 8 + 4];
                object2 = new String(this.getText(146 + object[by - 1]));
                if ((this.endConditionsCodes & 0x4007) == 1) {
                    object4 = null;
                    if (this.IsJewelsTwoTypes()) {
                        object3 = new String(this.getText(175));
                        object4 = new char[4][];
                        object4[0] = Integer.toString(this.getJewelsToWinCount(0)).toCharArray();
                        object4[1] = this.getText(128 + this.m_board.getWinnerTile(0) + this.getJewelsType(this.m_board.getWinnerTile(0)) * 5);
                        object4[2] = Integer.toString(this.getJewelsToWinCount(1)).toCharArray();
                        object4[3] = this.getText(128 + this.m_board.getWinnerTile(1) + this.getJewelsType(this.m_board.getWinnerTile(1)) * 5);
                        this.setPopUpText(((String)object2 + "\n\n" + (String)object3).toCharArray(), (char[][])object4);
                    } else {
                        object3 = new String(this.getText(113));
                        object4 = new char[2][];
                        object4[0] = Integer.toString(this.getJewelsToWinCount(0)).toCharArray();
                        object4[1] = this.getText(128 + this.m_board.getWinnerTile(0) + this.getJewelsType(this.m_board.getWinnerTile(0)) * 5);
                        this.setPopUpText(((String)object2 + "\n\n" + (String)object3).toCharArray(), (char[][])object4);
                    }
                } else {
                    object4 = new String(this.getText(114));
                    object3 = null;
                    object3 = new char[1][];
                    object3[0] = Integer.toString(levelData[this.getCurrentLevel() * 8 + 2]).toCharArray();
                    this.setPopUpText(((String)object2 + "\n\n" + (String)object4).toCharArray(), (char[][])object3);
                }
                bl = true;
            }
            if (bl) {
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            }
            this.levelObjectiveShown = true;
        } else if (MultiPlayermode != 0) {
            if (MultiPlayerGame3Note) {
                String string = new String(this.getText(116));
                MultiPlayerGame3Note = false;
                object = new char[][]{Integer.toString(2).toCharArray(), this.getText(118)};
                this.setPopUpText(string.toCharArray(), (char[][])object);
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            } else if (MultiPlayer2Ready) {
                MultiPlayerTimeReady = true;
                String string = new String(this.getText(121));
                MultiPlayer2Ready = false;
                object = new char[][]{"2 ".toCharArray(), this.getText(118)};
                this.setPopUpText(string.toCharArray(), (char[][])object);
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            } else if (MultiPlayer1Ready) {
                MultiPlayerTimeReady = true;
                MultiPlayer1Ready = false;
                char[][] cArrayArray = new char[][]{"1 ".toCharArray()};
                this.setPopUpText(this.getText(121), cArrayArray);
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            } else if (MultiPlayerEnd2) {
                Object object5;
                if (MultiPlayermode == 1) {
                    if (this.playerJewels > this.cpuJewels) {
                        object5 = null;
                        object5 = new char[][]{Integer.toString(1).toCharArray()};
                        this.setPopUpText(this.getText(124), (char[][])object5);
                    } else if (this.cpuJewels > this.playerJewels) {
                        object5 = null;
                        object5 = new char[][]{Integer.toString(2).toCharArray()};
                        this.setPopUpText(this.getText(124), (char[][])object5);
                    } else {
                        object5 = null;
                        object5 = new char[][]{Integer.toString(2).toCharArray()};
                        this.setPopUpText(this.getText(125), (char[][])object5);
                    }
                } else if (MultiPlayer1Time < MultiPlayer2Time) {
                    object5 = new char[][]{Integer.toString(1).toCharArray()};
                    this.setPopUpText(this.getText(124), (char[][])object5);
                } else {
                    object5 = new char[][]{Integer.toString(2).toCharArray()};
                    this.setPopUpText(this.getText(124), (char[][])object5);
                }
                MultiPlayerEnd2 = false;
                MultiPlayerEnd = true;
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            }
        } else if (this.beginLevelAnimationStarted == 0 && (this.getCurrentLevel() == 12 && this.tutorials[11] || this.getCurrentLevel() == 20 && this.tutorials[12] || this.getCurrentLevel() == 29 && this.tutorials[13] || this.getCurrentLevel() == 1 && this.tutorials[14])) {
            Object object6 = null;
            object6 = new char[1][];
            object = "";
            switch (this.getCurrentLevel()) {
                case 12: {
                    this.setTutorials(11, false);
                    object = new String(this.getText(44));
                    break;
                }
                case 20: {
                    this.setTutorials(12, false);
                    object = new String(this.getText(45));
                    break;
                }
                case 29: {
                    this.setTutorials(13, false);
                    object = new String(this.getText(46));
                    break;
                }
                case 1: {
                    this.setTutorials(14, false);
                    object = new String(this.getText(43));
                }
            }
            String string = new String(this.getText(42));
            object6[0] = Integer.toString(2).toCharArray();
            this.setPopUpText((string + " " + (String)object).toCharArray(), (char[][])object6);
            this.setNegativeSoftkey(null);
            this.setJQ2009GameState(5);
            gameTutorialTime = System.currentTimeMillis();
            gameTutorialshow = 0;
        }
        if (this.wasKeyPressed(22)) {
            this.pauseJQ2009Game();
        } else {
            if (this.isSoundEnabled() && !this.timeWarningIssued && TimerHandler.getTimer(0) > (long)(levelData[this.getCurrentLevel() * 8 + 2] * 45000) && !this.twoPlayerMode) {
                if (this.isSoundEnabled()) {
                    this.playSound(3, 0);
                }
                this.timeWarningIssued = true;
            }
            if (!this.twoPlayerMode && TimerHandler.getTimer(0) >= (long)(levelData[this.getCurrentLevel() * 8 + 2] * 60000) && this.getSubstate() != 12) {
                this.switchToEndLevel(12);
            }
            if (this.isTutorialEnabled() && !this.twoPlayerMode && TimerHandler.getTimer(0) >= (long)(levelData[this.getCurrentLevel() * 8 + 2] * 15000) && this.getSubstate() != 12 && this.tutorialTime && this.getTutorialStep() == -1 && this.setTutorialStep(4)) {
                int[] nArray = mHudSpac.getFrameRect(2);
                int n2 = this.screenWidth >> 1;
                int n3 = this.boardStartY - this.borderHeight >> 1;
                this.initSpriteAnimation(mSpecialCursorSpac, 8, 1, n2 + 0, n3 + (nArray[3] >> 1) + 0, 4, this.getText(131356));
                TimerHandler.resetTimer(9);
                this.tutorialTime = false;
            }
            this.m_board.updateOffsets(10, 10);
            int n4 = this.getSubstate();
            if (this.beginLevelAnimationStarted == 0 && this.getSubstate() != 12 && (this.player == 0 && this.player1Human || this.player == 1 && this.player2Human) && (this.twoPlayerMode && n4 == 0 && !this.m_board.isSwapInProgress() || !this.twoPlayerMode || MultiPlayermode != 0) && (MultiPlayermode == 0 || MultiPlayerReadyGo)) {
                boolean bl;
                boolean bl2 = this.wasKeyPressed(2) || this.wasKeyPressed(15);
                boolean bl3 = this.wasKeyPressed(8) || this.wasKeyPressed(16);
                boolean bl4 = this.wasKeyPressed(4) || this.wasKeyPressed(17);
                boolean bl5 = this.wasKeyPressed(6) || this.wasKeyPressed(18);
                boolean bl6 = bl = this.wasKeyPressed(5) || this.wasKeyPressed(14);
                if (this.waitForNextMove) {
                    bl = false;
                }
                if (!this.twoPlayerMode && (n4 != 0 || this.m_board.isSwapInProgress())) {
                    bl = false;
                }
                this.moveCursor(bl2, bl3, bl4, bl5, bl);
            }
            if (this.isTutorialEnabled() && TimerHandler.getTimer(9) > 5000L) {
                if (this.getTutorialStep() == 3) {
                    this.stopSpriteAnimation(3);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                } else if (this.getTutorialStep() == 7) {
                    this.stopSpriteAnimation(7);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                } else if (this.getTutorialStep() == 9 || this.getTutorialStep() == 15) {
                    this.stopSpriteAnimation(9);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                } else if (this.getTutorialStep() == 6) {
                    this.stopSpriteAnimation(6);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                } else if (this.getTutorialStep() == 4) {
                    this.stopSpriteAnimation(4);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                } else if (this.getTutorialStep() == 10) {
                    this.stopSpriteAnimation(10);
                    this.setTutorialTextClear(true);
                    this.setTutorialStep(-1);
                    this.fullRedraw = true;
                }
            }
            JQ2009GameCanvas.gameStatetest = n4;
            switch (n4) {
                case 0: {
                    this.preRenderSwap();
                    break;
                }
                case 1: {
                    this.preRenderCheckEndLevel2();
                    this.preRenderDestroyTiles();
                    break;
                }
                case 3: {
                    this.preRenderHandleAnims();
                    break;
                }
                case 4: {
                    this.preRenderFillBoard();
                    break;
                }
                case 5: {
                    this.preRenderCheckEndLevel();
                    break;
                }
                case 6: {
                    this.preRenderCheckAnyMoves();
                    break;
                }
                case 7: {
                    this.preRenderWait();
                    break;
                }
                case 8: {
                    this.preRenderSwitchPlayer(false);
                    break;
                }
                case 9: {
                    this.preRenderChooseAMove();
                    break;
                }
                case 10: {
                    this.preRenderMakeAMove();
                    break;
                }
                case 11: {
                    this.preRenderChooseAHint();
                    break;
                }
                case 12: {
                    this.preRenderEndLevelAnim();
                    break;
                }
            }
            this.updateAnimations(n);
            if (this.beginLevelAnimationStarted != 0 && (!this.isTwoPlayerMode() || this.isTwoPlayerMode() && this.isCharAnimFinished())) {
                this.updateBeginLevelAnimation();
            }
            if (this.isTwoPlayerMode()) {
                this.updateCharPos((int)TimerHandler.getTimer(7));
            }
            this.updateTiles(n);
            this.cursorAnimation.updateSprite(n);
            if (this.flameAnimation != null) {
                if (!this.flameAnimation.isAnimationComplete()) {
                    this.flameAnimation.updateSprite(n);
                } else {
                    this.flameAnimation = null;
                }
            }
            if (this.JewelsAnimation != null) {
                for (int i = 0; i < 8; ++i) {
                    if (!this.JewelsAnimation[i].isAnimationComplete()) {
                        this.JewelsAnimation[i].updateSprite(n);
                        continue;
                    }
                    if (this.JewelsAnimationXY[i * 3] == 1) {
                        this.JewelsAnimationXY[i * 3] = 2;
                        this.addJewelCoinsEffects(this.JewelsAnimationXY[i * 3 + 1], this.JewelsAnimationXY[i * 3 + 2]);
                        continue;
                    }
                    this.JewelsAnimationXY[i * 3] = 0;
                }
            }
            if (this.mEffectAnimation != null) {
                for (int i = 0; i < 10; ++i) {
                    if (!this.mEffectAnimation[i].isAnimationComplete()) {
                        this.mEffectAnimation[i].updateSprite(n);
                        continue;
                    }
                    this.EffectAnimationXY[i * 3] = 0;
                }
            }
            if (this.mIconAnimation != null) {
                this.mIconAnimation.updateSprite(n);
            }
            if (this.twoPlayerMode) {
                if (mRupertSpacAnimation != null) {
                    this.getPlayerCPUFrame(1, n4);
                    if (!mRupertSpacAnimation.isAnimationComplete()) {
                        if (this.fullPlayer > 0) {
                            this.fullPlayer = (byte)(this.fullPlayer - 1);
                        }
                        mRupertSpacAnimation.updateSprite(n);
                    } else {
                        switch (RupertState) {
                            case 1: {
                                mRupertSpacAnimation.setSequence(4, 0, 0, true);
                                RupertState = 2;
                                break;
                            }
                            case 2: {
                                this.fullPlayer = 1;
                                mRupertSpacAnimation.setSequence(1, 1, 0, true);
                                break;
                            }
                            case 3: {
                                mRupertSpacAnimation.setSequence(6, 0, 0, true);
                                RupertState = 2;
                            }
                        }
                    }
                }
                if (mBossSpacAnimation != null) {
                    this.getPlayerCPUFrame(2, n4);
                    if (!mBossSpacAnimation.isAnimationComplete()) {
                        mBossSpacAnimation.updateSprite(n);
                    } else {
                        switch (BossState) {
                            case 1: {
                                mBossSpacAnimation.setSequence(4 + this.getCurrentBossFrame() * 7, 0, 0, true);
                                BossState = 2;
                                break;
                            }
                            case 2: {
                                mBossSpacAnimation.setSequence(1 + this.getCurrentBossFrame() * 7, 1, 0, true);
                                break;
                            }
                            case 3: {
                                mBossSpacAnimation.setSequence(6 + this.getCurrentBossFrame() * 7, 0, 0, true);
                                BossState = 2;
                                break;
                            }
                            case 4: {
                                mBossSpacAnimation.setSequence(1 + this.getCurrentBossFrame() * 7, 1, 0, true);
                                BossState = 2;
                            }
                        }
                    }
                }
            } else {
                this.fullPlayer = 0;
            }
        }
    }

    private final void preRenderEndLevelAnim() {
        if (TimerHandler.getTimer(3) > 200L) {
            ++this.currentZone;
            if (this.currentZone < this.animationZones.length) {
                TimerHandler.resetTimer(3);
                this.m_board.destroyAnimatedZone(this.animationZones[this.currentZone]);
                if (this.currentZone == this.animationZones.length - 1) {
                    this.m_board.setAnyAnimatedCells(false);
                }
            } else if (MultiPlayermode != 0) {
                if (TimerHandler.getTimer(3) > 1000L) {
                    this.resetAnimations();
                    this.preRenderMP();
                    TimerHandler.resetTimer(3);
                }
            } else {
                TimerHandler.resetTimer(3);
                if (this.isAnimFinished(0)) {
                    if (this.checkEndLevelAwards(this.nextState == 11)) {
                        this.setJQ2009GameState(9);
                    } else {
                        this.setJQ2009GameState(this.nextState);
                    }
                }
            }
        }
    }

    private final void preRenderChooseAHint() {
        int n;
        TimerHandler.resetTimer(1);
        this.hintChoice[0] = this.moves[0];
        this.hintChoice[1] = this.moves[1];
        boolean bl = false;
        if ((this.endConditionsCodes & 0x4007) == 1) {
            for (n = 0; this.moves[n] != -1 && n < this.moves.length && !bl; n += 2) {
                int n2;
                int n3 = this.m_board.getIndexedCellProperty(this.moves[n], 0, 7);
                int n4 = this.m_board.getIndexedCellProperty(this.moves[n + 1], 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n], n4, 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n + 1], n3, 0, 7);
                if (n3 == this.m_board.getWinnerTile(0)) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        if (this.m_board.findRow(this.moves[n + 1], n2) < 2) continue;
                        this.hintChoice[0] = this.moves[n];
                        this.hintChoice[1] = this.moves[n + 1];
                        bl = true;
                    }
                }
                if (n4 == this.m_board.getWinnerTile(0)) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        if (this.m_board.findRow(this.moves[n], n2) < 2) continue;
                        this.hintChoice[0] = this.moves[n];
                        this.hintChoice[1] = this.moves[n + 1];
                        bl = true;
                    }
                }
                this.m_board.setIndexedCellProperty(this.moves[n], n3, 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n + 1], n4, 0, 7);
            }
        } else {
            while (this.moves[n] != -1 && n < this.moves.length && !bl) {
                int n5 = 0;
                int n6 = 0;
                int n7 = this.m_board.getIndexedCellProperty(this.moves[n], 0, 7);
                int n8 = this.m_board.getIndexedCellProperty(this.moves[n + 1], 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n], n8, 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n + 1], n7, 0, 7);
                for (int i = 0; i < 2; ++i) {
                    int n9;
                    int n10;
                    byte by = this.moves[n + i];
                    n5 = 0;
                    if (this.m_board.findRow(by, 0) >= 2) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by - n10, 3, 24);
                            if (n9 == 0) continue;
                            ++n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                    }
                    if (this.m_board.findRow(by, 1) >= 2) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by + n10, 3, 24);
                            if (n9 == 0) continue;
                            ++n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                    }
                    if (this.m_board.findRow(by, 2) >= 2) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by - this.m_board.getWidth() * n10, 3, 24);
                            if (n9 == 0) continue;
                            ++n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                    }
                    if (this.m_board.findRow(by, 3) >= 2) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by + this.m_board.getWidth() * n10, 3, 24);
                            if (n9 == 0) continue;
                            ++n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                    }
                    if (this.m_board.findRow(by, 0) >= 1 && this.m_board.findRow(by, 1) >= 1) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by + n10 - 1, 3, 24);
                            if (n9 == 0) continue;
                            ++n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                    }
                    if (this.m_board.findRow(by, 3) >= 1 && this.m_board.findRow(by, 2) >= 1) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            n9 = this.m_board.getIndexedCellProperty(by + this.m_board.getWidth() * (n10 - 1), 3, 24);
                            if (n9 != 0) {
                                ++n5;
                            }
                            if (n5 <= n6) continue;
                            n6 = n5;
                        }
                    }
                    if (n6 <= 0) continue;
                    this.hintChoice[0] = this.moves[n];
                    this.hintChoice[1] = this.moves[n + 1];
                    bl = true;
                    break;
                }
                this.m_board.setIndexedCellProperty(this.moves[n], n7, 0, 7);
                this.m_board.setIndexedCellProperty(this.moves[n + 1], n8, 0, 7);
                n += 2;
            }
        }
        this.setSubstate(0);
    }

    private void resetHint() {
        this.hintShown = false;
        this.hintFlashes = 0;
        TimerHandler.resetTimer(1);
    }

    private final void preRenderSwap() {
        if (gameStartTime != -1L && MultiPlayermode == 1 && TimerHandler.getTimer(0) > 30000L) {
            this.switchToEndLevel(11);
        }
        playerAddJewels = 0;
        cpuAddJewels = 0;
        if (this.player == 0 && this.player1Human || this.player == 1 && this.player2Human) {
            if (TimerHandler.getTimer(1) >= (long)(4000 + 200 * this.hintFlashes)) {
                if (this.hintFlashes != 0 || this.isSoundEnabled()) {
                    // empty if block
                }
                if (this.hintFlashes >= 4) {
                    TimerHandler.resetTimer(1);
                    this.hintFlashes = 0;
                    this.hintShown = false;
                } else {
                    ++this.hintFlashes;
                    this.hintShown = true;
                }
            }
            if (this.hintShown && TimerHandler.getTimer(1) < (long)(4000 + 200 * (this.hintFlashes - 1) + 100)) {
                this.m_board.setHintOffsets(this.hintChoice[0], this.hintChoice[1], 4);
            }
            if (this.m_board.doSwap(true) || this.affectedByPowerup) {
                if (!this.affectedByPowerup) {
                    this.playerSwap = true;
                    if (this.isTutorialEnabled()) {
                        if (this.getTutorialStep() == 2) {
                            this.stopSpriteAnimation(2);
                            this.setTutorialTextClear(true);
                            this.setTutorialStep(-1);
                        } else if (this.getTutorialStep() == 1) {
                            this.stopSpriteAnimation(1);
                            this.setTutorialTextClear(true);
                            this.setTutorialStep(-1);
                        } else if (this.getTutorialStep() == 8) {
                            this.stopSpriteAnimation(8);
                            this.setTutorialTextClear(true);
                            this.setTutorialStep(-1);
                        } else if (this.getTutorialStep() == 5) {
                            this.stopSpriteAnimation(5);
                            this.setTutorialTextClear(true);
                            this.setTutorialStep(-1);
                        }
                    }
                }
                this.waitForNextMove = true;
                if (this.affectedByPowerup) {
                    this.setSubstate(3);
                } else {
                    this.setSubstate(1);
                }
            } else if (this.beginLevelAnimationStarted == 0 && !this.m_board.isSwapInProgress() && !this.m_board.isMoving(this.m_board.getTemSwaping()) && this.wasKeyPressed(21) && MultiPlayermode <= 0 && this.getCurrentLevel() != 0) {
                this.setJQ2009GameState(14);
                if (this.isTutorialEnabled()) {
                    if (this.getTutorialStep() == 6) {
                        this.stopSpriteAnimation(6);
                        this.setTutorialTextClear(true);
                        this.setTutorialStep(-1);
                        int n = 131349;
                        this.triggerTutorialDialog(n, true);
                    } else if (this.tutorials[6]) {
                        this.tutorials[6] = false;
                        this.triggerTutorialDialog(131348);
                    }
                }
            }
        } else if (this.waitForNextMove || this.affectedByPowerup) {
            if (this.m_board.doSwap(true) || this.affectedByPowerup) {
                this.waitForNextMove = true;
                if (this.m_board.existSuspendedCells()) {
                    this.m_board.setSuspendedCells(false);
                    this.setSubstate(4);
                } else if (this.affectedByPowerup) {
                    this.setSubstate(3);
                } else {
                    this.setSubstate(1);
                }
            } else if (!this.m_board.isSwapInProgress()) {
                this.setSubstate(9);
                this.bCpuWrong = false;
            }
        } else {
            this.setSubstate(9);
        }
        if (this.waitForNextMove || this.m_board.isSwapInProgress()) {
            TimerHandler.resetTimer(1);
            this.hintShown = false;
        }
    }

    private final void preRenderDestroyTiles() {
        boolean bl = false;
        bl = this.player == 0 && this.player1Human;
        if (!bl) {
            // empty if block
        }
        this.m_board.findAllRows(true, true);
        if (!this.m_board.destroyTiles(bl, this.twoPlayerMode, this.creditForMatches, true)) {
            if (this.m_board.existSuspendedCells()) {
                this.m_board.setSuspendedCells(false);
                this.setSubstate(4);
            } else {
                this.setSubstate(5);
            }
        } else {
            this.playerSwap = false;
            int n = this.getMatchScore();
            this.setGameScore(this.getGameScore() + n);
            this.setMatchScore(0);
            if (this.isSoundEnabled()) {
                this.playSound(1, 0);
            }
            this.setSubstate(3);
            if (this.twoPlayerMode) {
                this.refreshHud = true;
            }
            ++this.matchStreak;
            ++this.crntLevelMaxStreak;
            if (this.isTutorialEnabled() && this.m_board.getSpecialMatchType() != -1 && !this.specialMatches) {
                this.triggerTutorialDialog(131351);
                this.specialMatches = true;
            }
        }
    }

    private final void preRenderHandleAnims() {
        if (this.affectedByPowerup && !this.powerupAnimsHandled) {
            if (this.managePowerupAnims()) {
                this.powerupAnimsHandled = true;
                this.setSubstate(4);
            }
            if (this.powerups[this.currentPowerup] == 2) {
                this.setSubstate(0);
                this.affectedByPowerup = false;
                affectedByPowerup2 = true;
            }
        } else {
            int n = this.m_board.getSpecialMatchType();
            if (n != -1) {
                boolean bl = true;
                if (this.m_board.isAnyAnimatedCells()) {
                    this.m_board.destroyAllAnimatedCells(false, false, false);
                }
                boolean bl2 = bl = bl && this.m_board.destroyCellsOfRandomly(-1, 25, 0x2000000, false, true);
                if (bl) {
                    this.m_board.setSpecialMatchType(-1);
                    this.setSubstate(4);
                }
            } else {
                if (this.m_board.isAnyAnimatedCells()) {
                    this.m_board.destroyAllAnimatedCells(false, false, false);
                }
                this.setSubstate(4);
            }
        }
    }

    private final void preRenderFillBoard() {
        if (!this.m_board.fillBoard(true)) {
            this.setSubstate(1);
        }
    }

    private final void switchToEndLevel(int n) {
        this.fullRedraw = true;
        if (this.gameMode == 2) {
            this.applyStats();
        }
        if (this.gameMode == 2 && n == 11) {
            this.setStoryCoins(this.getCoins());
        }
        this.nextState = n;
        this.setSubstate(12);
    }

    private final void preRenderMP() {
        switch (MultiPlayermode) {
            case 1: {
                if (this.player == 0) {
                    this.waitForNextMove = true;
                    this.m_board.loadBoard(this.boardData, levelData[this.getCurrentLevel() * 8 + 0], this.distributions, this.jewelsRemap.length);
                    this.m_board.generateLevelBoard();
                    this.startBeginLevelAnimation();
                    this.preRenderSwitchPlayer(true);
                    Object object = null;
                    object = new char[3][];
                    object[0] = Integer.toString(2).toCharArray();
                    object[1] = Integer.toString(1).toCharArray();
                    object[2] = Integer.toString(this.playerJewels).toCharArray();
                    this.setPopUpText(this.getText(123), (char[][])object);
                    MultiPlayer2Ready = true;
                } else {
                    MultiPlayerEnd2 = true;
                    if (this.isSoundEnabled()) {
                        this.playSound(5, 0);
                    }
                    if (this.playerJewels > this.cpuJewels) {
                        MultiPlayer1Win = (byte)(MultiPlayer1Win + 1);
                    } else if (this.cpuJewels > this.playerJewels) {
                        MultiPlayer2Win = (byte)(MultiPlayer2Win + 1);
                    }
                    Object object = null;
                    object = new char[3][];
                    object[0] = Integer.toString(2).toCharArray();
                    object[1] = Integer.toString(2).toCharArray();
                    object[2] = Integer.toString(this.cpuJewels).toCharArray();
                    this.setPopUpText(this.getText(123), (char[][])object);
                }
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
                break;
            }
            case 2: {
                if (this.player == 0) {
                    JQ2009Game.levelData[this.getCurrentLevel() * 8 + 3] = 0;
                    this.distributions[this.jewelsRemap.length - 1] = levelData[this.getCurrentLevel() * 8 + 3];
                    this.m_board.loadBoard(this.boardData, levelData[this.getCurrentLevel() * 8 + 0], this.distributions, this.jewelsRemap.length);
                    this.m_board.setTileFrequency(this.distributions, this.jewelsRemap.length);
                    this.m_board.generateLevelBoard();
                    JQ2009Game.levelData[this.getCurrentLevel() * 8 + 3] = 40;
                    this.distributions[this.jewelsRemap.length - 1] = levelData[this.getCurrentLevel() * 8 + 3];
                    this.m_board.setTileFrequency(this.distributions, this.jewelsRemap.length);
                    this.m_board.setIndexedCellProperty(35, this.jewelsRemap.length - 1, 0, 7);
                    this.startBeginLevelAnimation();
                    this.preRenderSwitchPlayer(true);
                    MultiPlayer1Time = (int)TimerHandler.getTimer(0);
                    Object object = null;
                    object = new char[4][];
                    object[0] = Integer.toString(2).toCharArray();
                    object[1] = Integer.toString(1).toCharArray();
                    object[2] = (MultiPlayer1Time / 60000 + ":").toCharArray();
                    object[3] = MultiPlayer1Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer1Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer1Time / 1000 % 60).toCharArray();
                    String string = new String(this.getText(122));
                    MultiPlayer2Ready = true;
                    this.setPopUpText(string.toCharArray(), (char[][])object);
                    this.setNegativeSoftkey(null);
                    this.setJQ2009GameState(5);
                } else if (this.player == 1) {
                    MultiPlayer2Time = (int)TimerHandler.getTimer(0);
                    MultiPlayerEnd2 = true;
                    if (this.isSoundEnabled()) {
                        this.playSound(5, 0);
                    }
                    if (MultiPlayer1Time < MultiPlayer2Time) {
                        Object object = null;
                        object = new char[4][];
                        object[0] = Integer.toString(1).toCharArray();
                        object[1] = Integer.toString(2).toCharArray();
                        object[2] = (MultiPlayer2Time / 60000 + ":").toCharArray();
                        object[3] = MultiPlayer2Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer2Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer2Time / 1000 % 60).toCharArray();
                        String string = new String(this.getText(122));
                        this.setPopUpText(string.toCharArray(), (char[][])object);
                        MultiPlayer1Win = (byte)(MultiPlayer1Win + 1);
                    } else {
                        Object object = null;
                        object = new char[4][];
                        object[0] = Integer.toString(2).toCharArray();
                        object[1] = Integer.toString(2).toCharArray();
                        object[2] = (MultiPlayer2Time / 60000 + ":").toCharArray();
                        object[3] = MultiPlayer2Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer2Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer2Time / 1000 % 60).toCharArray();
                        String string = new String(this.getText(122));
                        this.setPopUpText(string.toCharArray(), (char[][])object);
                        MultiPlayer2Win = (byte)(MultiPlayer2Win + 1);
                    }
                }
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
                break;
            }
            case 3: {
                if (this.player == 0) {
                    this.m_board.loadBoard(this.boardData, levelData[this.getCurrentLevel() * 8 + 0], this.distributions, this.jewelsRemap.length);
                    this.m_board.generateLevelBoard();
                    this.startBeginLevelAnimation();
                    this.preRenderSwitchPlayer(true);
                    MultiPlayer1Time = (int)TimerHandler.getTimer(0);
                    Object object = null;
                    object = new char[4][];
                    object[0] = Integer.toString(2).toCharArray();
                    object[1] = Integer.toString(1).toCharArray();
                    object[2] = (MultiPlayer1Time / 60000 + ":").toCharArray();
                    object[3] = MultiPlayer1Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer1Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer1Time / 1000 % 60).toCharArray();
                    String string = new String(this.getText(122));
                    MultiPlayer2Ready = true;
                    MultiPlayerGame3Note = true;
                    this.setPopUpText(string.toCharArray(), (char[][])object);
                    this.setNegativeSoftkey(null);
                    this.setJQ2009GameState(5);
                } else {
                    MultiPlayer2Time = (int)TimerHandler.getTimer(0);
                    MultiPlayerEnd2 = true;
                    if (this.isSoundEnabled()) {
                        this.playSound(5, 0);
                    }
                    if (MultiPlayer1Time < MultiPlayer2Time) {
                        Object object = null;
                        object = new char[4][];
                        object[0] = Integer.toString(1).toCharArray();
                        object[1] = Integer.toString(2).toCharArray();
                        object[2] = (MultiPlayer2Time / 60000 + ":").toCharArray();
                        object[3] = MultiPlayer2Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer2Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer2Time / 1000 % 60).toCharArray();
                        String string = new String(this.getText(122));
                        this.setPopUpText(string.toCharArray(), (char[][])object);
                        MultiPlayer1Win = (byte)(MultiPlayer1Win + 1);
                    } else {
                        Object object = null;
                        object = new char[4][];
                        object[0] = Integer.toString(2).toCharArray();
                        object[1] = Integer.toString(2).toCharArray();
                        object[2] = (MultiPlayer2Time / 60000 + ":").toCharArray();
                        object[3] = MultiPlayer2Time / 1000 % 60 < 10 ? ("0" + Integer.toString(MultiPlayer2Time / 1000 % 60)).toCharArray() : Integer.toString(MultiPlayer2Time / 1000 % 60).toCharArray();
                        String string = new String(this.getText(122));
                        this.setPopUpText(string.toCharArray(), (char[][])object);
                        MultiPlayer2Win = (byte)(MultiPlayer2Win + 1);
                    }
                }
                this.setNegativeSoftkey(null);
                this.setJQ2009GameState(5);
            }
        }
        if (MultiPlayerEnd2) {
            this.setCharPos(0, 0, 0, false, 0, 1280, false);
            this.setCharPos(1, this.screenWidth, 0, false, 0, 1280, false);
            TimerHandler.resetTimer(7);
        }
        if (MultiPlayermode != 0 && this.getCurrentLevel() == 11) {
            this.m_board.setIndexedCellProperty(44, 0, 5, 96);
        }
        MultiPlayerTimeReady = false;
    }

    private final void preRenderCheckEndLevel() {
        boolean bl = false;
        if (!this.twoPlayerMode) {
            Object[] objectArray;
            Object[] objectArray2;
            if (this.isTutorialEnabled()) {
                if (this.getCoins() > 0 && this.setTutorialStep(6)) {
                    objectArray = objectArray2 = this.getPositiveSoftkey();
                    int n = this.getSoftkeyFont().charsWidth((char[])objectArray, 0, objectArray.length, true);
                    this.initSpriteAnimation(mSpecialCursorSpac, 1, 1, 10 + n / 2, this.screenHeight - this.getSoftKeyBarSize(), 6, this.getText(131354));
                    TimerHandler.resetTimer(9);
                } else if (this.m_board.areThereEmptyTiles(this.tutorialEmptyMoves, 0) && this.getTutorialStep() == -1 && this.setTutorialStep(10)) {
                    this.triggerTutorialDialog(131361);
                } else if (this.getTutorialStep() == -1 && this.setTutorialStep(3)) {
                    int n = this.screenWidth >> 1;
                    int n2 = this.boardStartY - this.borderHeight >> 1;
                    this.initSpriteAnimation(mSpecialCursorSpac, 8, 1, n + this.hudRightTextX + 0, n2 + this.hudRightTextY + this.getSharedFont().getHeight() + 0, 3, this.getText(131355));
                    TimerHandler.resetTimer(9);
                }
            }
            if (!this.IsJewelsOnePlayer()) {
                objectArray2 = new int[]{-1};
                objectArray = new int[objectArray2.length];
                this.m_board.boardHealth((int[])objectArray2, (int[])objectArray, null);
                if (objectArray[0] == '\u0000' && this.m_board.boardLocked() == 0) {
                    bl = true;
                    this.switchToEndLevel(11);
                }
            } else if (this.playerJewels >= this.getJewelsToWinCount(0)) {
                bl = true;
                this.switchToEndLevel(11);
            }
        } else {
            switch (this.endConditionsCodes & 0x4007) {
                case 4: {
                    int[] nArray = new int[]{0, 1, 2};
                    int[] nArray2 = new int[nArray.length];
                    this.m_board.boardHealth(nArray, nArray2, null);
                    int n = nArray2[0];
                    int n3 = nArray2[1];
                    int n4 = nArray2[2];
                    int n5 = 100 * n / (n + n4 + n3);
                    int n6 = 100 * n4 / (n + n4 + n3);
                    if (MultiPlayermode == 3) {
                        if (n3 != 0) break;
                        bl = true;
                        this.switchToEndLevel(11);
                        break;
                    }
                    ++this.Round;
                    if (this.Round / 2 < levelData[this.getCurrentLevel() * 8 + 2]) break;
                    if (n5 > n6) {
                        bl = true;
                        this.switchToEndLevel(11);
                        break;
                    }
                    bl = true;
                    this.switchToEndLevel(12);
                    break;
                }
                case 1: {
                    if (this.isTutorialEnabled() && this.getPlayerJewels(0) > 0 && this.setTutorialStep(7)) {
                        this.initSpriteAnimation(mSpecialCursorSpac, 8, 1, (this.screenWidth >> 1) + this.bossHudLeftTextX, (this.boardStartY - this.borderHeight >> 1) + this.bossHudLeftTextY + this.getBaseFont().getHeight() + (this.getBaseFont().getHeight() >> 1), 7, this.getText(131352));
                        TimerHandler.resetTimer(9);
                    }
                    if (this.playerJewels >= this.getJewelsToWinCount(0) && this.playerJewels2 >= this.getJewelsToWinCount(1)) {
                        if (MultiPlayermode == 2) {
                            if (this.player == 0) {
                                bl = true;
                                this.switchToEndLevel(11);
                            }
                        } else {
                            bl = true;
                            this.switchToEndLevel(11);
                        }
                    }
                    if (this.cpuJewels < this.getJewelsToWinCount(0) || this.cpuJewels2 < this.getJewelsToWinCount(1)) break;
                    if (MultiPlayermode == 2) {
                        if (this.player != 1) break;
                        bl = true;
                        this.switchToEndLevel(11);
                        break;
                    }
                    bl = true;
                    this.switchToEndLevel(12);
                }
            }
        }
        if ((this.endConditionsCodes & 0x2000) != 0) {
            this.endConditionsCodes &= 0xFFFFDFFF;
            bl = true;
            this.switchToEndLevel(11);
        }
        if ((this.endConditionsCodes & 0x1000) != 0) {
            this.endConditionsCodes &= 0xFFFFEFFF;
            bl = true;
            this.switchToEndLevel(12);
        }
        if (!bl) {
            this.setSubstate(6);
        } else {
            TimerHandler.pauseTimer(0);
            if (gamePauseTime < 0L) {
                gamePauseTime = System.currentTimeMillis() - gameStartTime;
            }
        }
    }

    private final void preRenderCheckEndLevel2() {
        boolean bl = false;
        if (!this.twoPlayerMode) {
            if (!this.IsJewelsOnePlayer()) {
                int[] nArray = new int[]{-1};
                int[] nArray2 = new int[nArray.length];
                this.m_board.boardHealth(nArray, nArray2, null);
                if (nArray2[0] == 0 && this.m_board.boardLocked() == 0) {
                    bl = true;
                }
            } else if (this.playerJewels >= this.getJewelsToWinCount(0)) {
                bl = true;
            }
        } else {
            switch (this.endConditionsCodes & 0x4007) {
                case 4: {
                    int[] nArray = new int[]{0, 1, 2};
                    int[] nArray3 = new int[nArray.length];
                    this.m_board.boardHealth(nArray, nArray3, null);
                    int n = nArray3[0];
                    int n2 = nArray3[1];
                    int n3 = nArray3[2];
                    int n4 = 100 * n / (n + n3 + n2);
                    int n5 = 100 * n3 / (n + n3 + n2);
                    if (MultiPlayermode != 3 || n2 != 0) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (this.playerJewels >= this.getJewelsToWinCount(0) && this.playerJewels2 >= this.getJewelsToWinCount(1)) {
                        if (MultiPlayermode == 2) {
                            if (this.player == 0) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    }
                    if (this.cpuJewels < this.getJewelsToWinCount(0) || this.cpuJewels2 < this.getJewelsToWinCount(1)) break;
                    if (MultiPlayermode == 2) {
                        if (this.player != 1) break;
                        bl = true;
                        break;
                    }
                    bl = true;
                }
            }
        }
        if ((this.endConditionsCodes & 0x2000) != 0) {
            bl = true;
        }
        if ((this.endConditionsCodes & 0x1000) != 0) {
            bl = true;
        }
        if (bl) {
            if (gamePauseTime < 0L) {
                gamePauseTime = System.currentTimeMillis() - gameStartTime;
            }
            TimerHandler.pauseTimer(0);
        }
    }

    private final void preRenderCheckAnyMoves() {
        this.creditForMatches = true;
        if (!this.m_board.anyMovesLeft(this.moves)) {
            this.setSubstate(7);
            if (this.isSoundEnabled()) {
                this.playSound(10, 0);
            }
        } else {
            this.setSubstate(8);
        }
    }

    private final void preRenderWait() {
        if (TimerHandler.getTimer(10) < 500L) {
            this.m_board.setBoardShake();
        } else {
            this.creditForMatches = false;
            this.setSubstate(1);
            this.setPopUpDialog(this.getText(131304));
        }
    }

    private final boolean preRenderSwitchPlayer(boolean bl) {
        boolean bl2 = false;
        this.creditForMatches = true;
        if (this.waitForNextMove) {
            if (this.twoPlayerMode && (MultiPlayermode == 0 || bl)) {
                int[] nArray = new int[]{0, 1, 2};
                int[] nArray2 = new int[nArray.length];
                this.m_board.boardHealth(nArray, nArray2, null);
                int n = nArray2[0];
                int n2 = nArray2[1];
                int n3 = nArray2[2];
                int n4 = n * 100 / (n + n2 + n3);
                int n5 = n3 * 100 / (n + n2 + n3);
                this.p1Score += n4;
                this.p2Score += n5;
                if (this.player == 0) {
                    this.player = 1;
                    int n6 = levelData[this.getCurrentLevel() * 8 + 4];
                    if (this.player1Human) {
                        int n7;
                        if (n6 == 10) {
                            if (JQ2009Game.getCPUCoins() >= this.getPowerupCost(0 + this.getPowerupsLevel(this.getCurrentLevel()))) {
                                this.setBossMovesCount(this.getBossMovesCount() + 1);
                                int n8 = Math.abs(this.getRandom().nextInt()) % 10;
                                if (n8 > 5) {
                                    this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                                    this.setBossPowerup(0 + this.getPowerupsLevel(this.getCurrentLevel()));
                                }
                            }
                        } else if (n6 == 7) {
                            if (JQ2009Game.getCPUCoins() >= this.getPowerupCost(0 + this.getPowerupsLevel(this.getCurrentLevel()))) {
                                this.setBossMovesCount(this.getBossMovesCount() + 1);
                                int n9 = Math.abs(this.getRandom().nextInt()) % 10;
                                if (n9 > 4) {
                                    this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                                    this.setBossPowerup(0 + this.getPowerupsLevel(this.getCurrentLevel()));
                                }
                            }
                        } else if (n6 == 2) {
                            if (JQ2009Game.getCPUCoins() >= this.getPowerupCost(0)) {
                                this.setBossMovesCount(this.getBossMovesCount() + 1);
                                int n10 = Math.abs(this.getRandom().nextInt()) % 10;
                                if (n10 > 7) {
                                    this.setBossPowerupsCount(this.getBossPowerupsCount() + 1);
                                    this.setBossPowerup(0);
                                }
                            }
                        } else if (n6 == 9) {
                            if (this.getPlayerJewels(0) > this.getCpuJewels(0) + 10 && JQ2009Game.getCPUCoins() >= this.getPowerupCost(0 + this.getPowerupsLevel(this.getCurrentLevel()))) {
                                this.setBossMovesCount(this.getBossMovesCount() + 1);
                                this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                                this.setBossPowerup(0 + this.getPowerupsLevel(this.getCurrentLevel()));
                            }
                        } else if (BossPowerup && this.getCurrentLevel() == 11) {
                            int n11 = this.m_board.getIndexedCellProperty(this.m_board.getCellIndex(4, 5), 0, 7);
                            if (n11 != 7) {
                                BossPowerup = false;
                                this.setBossMovesCount(this.getBossMovesCount() + 1);
                                this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                                this.setBossPowerup(1 + this.getPowerupsLevel(this.getCurrentLevel()));
                            } else {
                                BossPowerup = false;
                            }
                        } else if (this.getGameMode() == 2 && BossPowerup && this.getCurrentLevel() == 19) {
                            BossPowerup = false;
                            this.setBossMovesCount(this.getBossMovesCount() + 1);
                            this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                            this.setBossPowerup(1 + this.getPowerupsLevel(this.getCurrentLevel()));
                        } else if (this.getGameMode() == 2 && BossPowerup && this.getCurrentLevel() == 28) {
                            BossPowerup = false;
                            this.setBossMovesCount(this.getBossMovesCount() + 1);
                            this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                            this.setBossPowerup(1 + this.getPowerupsLevel(this.getCurrentLevel()));
                        } else if (JQ2009Game.getCPUCoins() >= this.getPowerupCost(0 + this.getPowerupsLevel(this.getCurrentLevel())) && (n7 = Math.abs(this.getRandom().nextInt()) % 10) > 7) {
                            this.setBossMovesCount(this.getBossMovesCount() + 1);
                            this.setBossPowerupsCount(this.getBossPowerupsCount() + 2);
                            this.setBossPowerup(0 + this.getPowerupsLevel(this.getCurrentLevel()));
                        }
                    }
                    this.setCharPos(0, -18, 18, false, 420, 640, false);
                    this.setCharPos(1, this.screenWidth, 0, false, 0, 640, false);
                    this.cursorAnimation = new SpacSprite(mCommonLevelSpac, 6, true);
                    this.cursorAnimation.setPlaybackMode(1);
                    this.flameAnimation = new SpacSprite(mCommonLevelSpac, 7, true);
                    this.flameAnimation.setPlaybackMode(0);
                    TimerHandler.resetTimer(7);
                    if (this.isTutorialEnabled() && !this.notDisplayYourTurn && this.getCurrentLevel() == 0) {
                        this.setPopUpDialog(this.getText(131367));
                        this.notDisplayYourTurn = true;
                    }
                    this.bCpuWrong = false;
                    if (this.getCurrentLevel() == 0 && (n6 = Math.abs(this.getRandom().nextInt()) % 10) > 6) {
                        this.bCpuWrong = true;
                    }
                } else if (this.player == 1) {
                    this.player = 0;
                    this.setCharPos(0, 0, 0, false, 0, 640, false);
                    this.setCharPos(1, this.screenWidth + 18, 18, false, 420, 640, false);
                    this.cursorAnimation = new SpacSprite(mCommonLevelSpac, 5, true);
                    this.cursorAnimation.setPlaybackMode(1);
                    this.flameAnimation = new SpacSprite(mCommonLevelSpac, 7, true);
                    this.flameAnimation.setPlaybackMode(0);
                    TimerHandler.resetTimer(7);
                }
            }
            this.waitForNextMove = false;
        }
        if (this.isAnimFinished(0)) {
            this.fullRedraw = true;
            if (MultiPlayermode == 0 && this.checkInLevelAwards()) {
                this.setJQ2009GameState(8);
            }
            this.setSubstate(11);
            bl2 = true;
        }
        affectedByPowerup2 = false;
        this.affectedByPowerup = false;
        return bl2;
    }

    private final void preRenderChooseAMove() {
        if (this.IsJewelsTwoTypes()) {
            if (this.cpuJewels >= this.getJewelsToWinCount(0)) {
                this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(1));
            } else if (this.cpuJewels2 >= this.getJewelsToWinCount(1)) {
                this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(0));
            } else if (Math.abs(this.getRandom().nextInt()) % 100 >= 50) {
                this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(1));
            } else {
                this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(0));
            }
        }
        if (!this.levelObjectiveShown) {
            return;
        }
        if (this.cpuMoveScores == null) {
            if (this.getBossPowerup() == -1) {
                int n = 0;
                for (int i = 0; this.moves[i] != -1 && i < this.moves.length; i += 2) {
                    ++n;
                }
                this.cpuMoveScores = new int[n];
                this.cpuEvaluation = 0;
            } else {
                this.powerupMoves = this.m_board.getActiveCells();
                this.cpuMoveScores = new int[this.powerupMoves.length];
                this.cpuEvaluation = 0;
            }
        } else {
            int n;
            int n2;
            int n3 = this.getLevelAI(this.getCurrentLevel());
            this.cionsIndex = (byte)-1;
            while (this.cpuEvaluation < this.cpuMoveScores.length) {
                if (this.getBossPowerup() == -1) {
                    this.m_board.startEvaluation();
                    this.m_board.handleCellSelect(this.moves[this.cpuEvaluation << 1]);
                    this.m_board.handleCellSelect(this.moves[(this.cpuEvaluation << 1) + 1]);
                    this.m_board.doSwap(false);
                    if (this.m_board.doSwap(false)) {
                        n2 = this.m_board.destroyTiles(this.player == 0 && this.player1Human || this.player == 1 && this.player2Human, this.twoPlayerMode, this.creditForMatches, false) ? 1 : 0;
                        while (n2 != 0) {
                            if (this.m_board.fillBoard(false)) continue;
                            this.m_board.findAllRows(true, false);
                            n2 = this.m_board.destroyTiles(this.player == 0 && this.player1Human || this.player == 1 && this.player2Human, this.twoPlayerMode, this.creditForMatches, false) ? 1 : 0;
                        }
                    }
                    if (n3 == 3) {
                        n2 = this.m_board.getCellProperty(this.m_board.m_boardCells[this.moves[this.cpuEvaluation << 1]], 0, 7);
                        n = this.m_board.getCellProperty(this.m_board.m_boardCells[this.moves[(this.cpuEvaluation << 1) + 1]], 0, 7);
                        if (n2 == 5 || n == 5) {
                            this.cionsIndex = this.moves[this.cpuEvaluation << 1];
                            this.cionsIndex2 = this.moves[(this.cpuEvaluation << 1) + 1];
                        }
                    }
                    this.cpuMoveScores[this.cpuEvaluation] = this.m_board.stopEvaluation();
                    ++this.cpuEvaluation;
                    continue;
                }
                this.m_board.startEvaluation();
                this.changePowerup(-1, -1, this.getBossPowerup());
                this.m_board.prepareAnimFromMarked();
                this.m_board.destroyAllAnimatedCells(true, false, false);
                n2 = 1;
                while (n2 != 0) {
                    if (this.m_board.fillBoard(false)) continue;
                    this.m_board.findAllRows(true, false);
                    n2 = this.m_board.destroyTiles(this.player == 0 && this.player1Human || this.player == 1 && this.player2Human, this.twoPlayerMode, this.creditForMatches, false) ? 1 : 0;
                }
                this.cpuMoveScores[this.cpuEvaluation] = this.m_board.stopEvaluation();
                ++this.cpuEvaluation;
            }
            if (n3 != 6) {
                this.sortCpuScores();
            }
            if (this.getBossPowerup() == -1) {
                this.cpuChosenMove = this.m_board.getDifficulty() * (this.cpuMoveScores.length - 1) / 100 << 1;
                if ((this.endConditionsCodes & 0x4007) == 1) {
                    n2 = this.firstNonZeroScore();
                    n = Math.abs(this.getRandom().nextInt()) % 100;
                    this.cpuChosenMove = n <= 100 - this.m_board.getDifficulty() || n2 < 0 ? 0 : (n - (100 - this.m_board.getDifficulty())) * (this.cpuMoveScores.length - n2) / this.m_board.getDifficulty() + n2 << 1;
                }
            } else if (this.getBossMovesCount() == 2) {
                byte[] byArray = this.m_board.getNonCPUCells();
                this.cpuChosenMove = Math.abs(this.getRandom().nextInt()) % byArray.length;
                this.powerupMoves[this.cpuChosenMove] = byArray[this.cpuChosenMove];
            } else if (this.getBossPowerup() == 0) {
                this.cpuChosenMove = this.cpuMoveScores.length - 1;
            } else {
                int[] nArray = new int[]{2, 0};
                int[] nArray2 = new int[nArray.length];
                this.m_board.boardHealth(nArray, nArray2, null);
                int n4 = Math.abs(nArray2[0] - nArray2[1]);
                this.cpuChosenMove = n4 * this.cpuMoveScores.length / 23;
                if (this.cpuChosenMove >= this.cpuMoveScores.length) {
                    this.cpuChosenMove = this.cpuMoveScores.length - 1;
                }
            }
            this.cpuSelectedTile = false;
            this.cpuMoveScores = null;
            this.setSubstate(10);
        }
    }

    private final void preRenderMakeAMove() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        boolean bl = false;
        int n7 = -1;
        int n8 = this.getLevelAI(this.getCurrentLevel());
        if (this.getBossPowerup() == -1) {
            if (n8 == 6) {
                block20: for (n5 = 0; n5 < this.moves.length - 2 && this.moves[n5] != -1 && this.moves[n5 + 1] != -1; n5 += 2) {
                    if (this.moves[n5] <= 0 || this.moves[n5 + 1] <= 0 || bl) continue;
                    for (n4 = n5 + 2; n4 < this.moves.length && this.moves[n4] != -1 && this.moves[n4 + 1] != -1; n4 += 2) {
                        if (this.moves[n4] <= 0 || this.moves[n4 + 1] <= 0 || this.moves[n5] != this.moves[n4] || this.moves[n5 + 1] != this.moves[n4 + 1]) continue;
                        n6 = this.moves[n5];
                        n7 = this.moves[n5 + 1];
                        try {
                            int n9;
                            if (Math.abs(n6 - n7) > 6) {
                                n9 = this.m_board.getCellProperties(n6 / 8, n6 % 8);
                                n3 = this.m_board.getCellProperty(n9, 3, 24);
                                n9 = this.m_board.getCellProperties((n6 - 1) / 8, (n6 - 1) % 8);
                                n2 = this.m_board.getCellProperty(n9, 3, 24);
                                n9 = this.m_board.getCellProperties((n6 + 1) / 8, (n6 + 1) % 8);
                                n = this.m_board.getCellProperty(n9, 3, 24);
                                if (n3 != 2 || n2 != 2 || n != 2) {
                                    bl = true;
                                }
                            } else {
                                n9 = this.m_board.getCellProperties(n6 / 8, n6 % 8);
                                n3 = this.m_board.getCellProperty(n9, 3, 24);
                                n9 = this.m_board.getCellProperties((n6 - 8) / 8, (n6 - 8) % 8);
                                n2 = this.m_board.getCellProperty(n9, 3, 24);
                                n9 = this.m_board.getCellProperties((n6 + 8) / 8, (n6 + 8) % 8);
                                n = this.m_board.getCellProperty(n9, 3, 24);
                                if (n3 != 2 || n2 != 2 || n != 2) {
                                    bl = true;
                                }
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        if (bl) continue block20;
                    }
                }
            }
            if (!bl) {
                n6 = this.cionsIndex != -1 ? (int)this.cionsIndex : this.moves[this.cpuChosenMove];
            }
        } else {
            n6 = this.moves[0];
        }
        if (n6 < 0) {
            this.cpuChosenMove = -1;
            n6 = 0;
        }
        n5 = -1;
        if (this.getBossPowerup() == -1) {
            n5 = bl ? n7 : (this.cionsIndex != -1 ? (int)this.cionsIndex2 : this.moves[this.cpuChosenMove + 1]);
        }
        n4 = n6 % this.m_board.getWidth();
        int n10 = n6 / this.m_board.getWidth();
        if (n4 < this.xPos) {
            n3 = this.xPos;
            this.moveCursor(false, false, true, false, false);
            if (this.xPos > n3 || this.xPos < n4) {
                this.xPos = n3 - 1;
            }
        } else if (n4 > this.xPos) {
            n3 = this.xPos;
            this.moveCursor(false, false, false, true, false);
            if (this.xPos < n3 || this.xPos > n4) {
                this.xPos = n3 + 1;
            }
        } else if (n10 < this.yPos) {
            n3 = this.yPos;
            this.moveCursor(true, false, false, false, false);
            if (this.yPos > n3 || this.yPos < n10) {
                this.yPos = n3 - 1;
            }
        } else if (n10 > this.yPos) {
            n3 = this.yPos;
            this.moveCursor(false, true, false, false, false);
            if (this.yPos < n3 || this.yPos > n10) {
                this.yPos = n3 + 1;
            }
        } else if (this.cpuSelectedTile) {
            byte[] byArray = new byte[8];
            this.m_board.getAdjacentCells(this.xPos, this.yPos, byArray);
            if (this.bCpuWrong) {
                n = n2 = Math.abs(this.getRandom().nextInt()) % 4;
                int n11 = this.xPos;
                int n12 = this.yPos;
                switch (n2) {
                    case 0: {
                        --n11;
                        break;
                    }
                    case 1: {
                        ++n11;
                        break;
                    }
                    case 2: {
                        --n12;
                        break;
                    }
                    case 3: {
                        ++n12;
                    }
                }
                while (!this.m_board.isCellActive(n11, n12) || byArray[n2] == n5) {
                    switch (n2) {
                        case 0: {
                            --n11;
                            break;
                        }
                        case 1: {
                            ++n11;
                            break;
                        }
                        case 2: {
                            --n12;
                            break;
                        }
                        case 3: {
                            ++n12;
                        }
                    }
                    if (++n2 > 3) {
                        n2 = 0;
                    }
                    if (n2 != n) continue;
                    return;
                }
                switch (n2) {
                    case 0: {
                        this.moveCursor(false, false, true, false, false);
                        break;
                    }
                    case 1: {
                        this.moveCursor(false, false, false, true, false);
                        break;
                    }
                    case 2: {
                        this.moveCursor(true, false, false, false, false);
                        break;
                    }
                    case 3: {
                        this.moveCursor(false, true, false, false, false);
                    }
                }
                this.bCpuWrong = false;
            } else {
                if (byArray[0] == n5) {
                    this.moveCursor(false, false, true, false, false);
                }
                if (byArray[1] == n5) {
                    this.moveCursor(false, false, false, true, false);
                }
                if (byArray[2] == n5) {
                    this.moveCursor(true, false, false, false, false);
                }
                if (byArray[3] == n5) {
                    this.moveCursor(false, true, false, false, false);
                }
            }
            this.m_board.doSwap(false);
            this.waitForNextMove = true;
            this.cpuChosenMove = -1;
            this.setSubstate(0);
        } else if (this.getBossPowerup() == -1) {
            this.moveCursor(false, false, false, false, true);
            this.cpuSelectedTile = true;
        } else {
            this.waitForNextMove = true;
            this.cpuChosenMove = -1;
            this.setSubstate(0);
            this.setJQ2009GameState(14);
            TimerHandler.resetTimer(8);
        }
    }

    private final int getJewelsToWinCount(int n) {
        if (n == 0) {
            return levelData[this.getCurrentLevel() * 8 + 5];
        }
        return this.winjewels2[this.getCurrentLevel()];
    }

    private final boolean checkEndLevelAwards(boolean bl) {
        int n = this.getGameMode();
        boolean bl2 = false;
        if (n == 2) {
            int n2;
            int n3;
            int n4;
            int[] nArray;
            int[] nArray2;
            int n5;
            int n6;
            int n7;
            int n8;
            this.boardFailureCounter = bl ? 0 : ++this.boardFailureCounter;
            if (!this.awards[3] && this.getGameScore() - this.levelAwardPoints >= 8000) {
                this.giveAward(3);
                bl2 = true;
            }
            if (!this.awards[8] && bl && this.getChapter(n8 = this.getCurrentLevel()) != this.getChapter(n8 + 1)) {
                this.giveAward(8);
                bl2 = true;
            }
            if (!this.awards[9] && bl && !this.isTwoPlayerMode()) {
                n8 = (int)TimerHandler.getTimer(0);
                n7 = levelData[this.getCurrentLevel() * 8 + 2] * 60000;
                n6 = (n7 - n8) * 100 / n7;
                if (n6 > 50) {
                    this.giveAward(9);
                    bl2 = true;
                }
            }
            if (!this.awards[13] && bl && !this.isTwoPlayerMode()) {
                n8 = (int)TimerHandler.getTimer(0);
                n7 = levelData[this.getCurrentLevel() * 8 + 2] * 60000;
                n6 = (n7 - n8) * 100 / n7;
                if (n6 < 5) {
                    this.giveAward(13);
                    bl2 = true;
                }
            }
            if (!this.awards[12] && !bl && this.boardFailureCounter > 2) {
                this.giveAward(12);
                bl2 = true;
            }
            if (!this.awards[14] && this.isTwoPlayerMode()) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                if ((this.endConditionsCodes & 0x4007) == 1) {
                    n6 = this.playerJewels;
                    n5 = this.cpuJewels;
                    n8 = this.playerJewels * 100 / this.getJewelsToWinCount(0);
                    n7 = this.cpuJewels * 100 / this.getJewelsToWinCount(0);
                } else {
                    nArray2 = new int[]{0, 1, 2};
                    nArray = new int[nArray2.length];
                    this.m_board.boardHealth(nArray2, nArray, null);
                    n4 = nArray[0];
                    n3 = nArray[1];
                    n2 = nArray[2];
                    n6 = n4;
                    n5 = n2;
                    n8 = n4 * 100 / (n4 + n3 + n2);
                    n7 = n2 * 100 / (n4 + n3 + n2);
                }
                if (n5 > n6 && n6 * 160 / 100 <= n5) {
                    this.giveAward(14);
                    bl2 = true;
                }
            }
            if (!this.awards[10] && bl) {
                n8 = 0;
                n7 = 0;
                for (n6 = 0; n6 < this.getStoryLevelsCount(); ++n6) {
                    if (levelData[n6 * 8 + 1] != 0) continue;
                    ++n8;
                    if (this.getCurrentLevel() != n6) continue;
                    n7 = n8;
                }
                if (n7 == n8) {
                    this.giveAward(10);
                    bl2 = true;
                }
            }
            if (!(this.awards[11] && this.awards[15] || !bl)) {
                n8 = 0;
                n7 = 0;
                for (n6 = 0; n6 < this.getStoryLevelsCount(); ++n6) {
                    if (levelData[n6 * 8 + 1] <= 0) continue;
                    ++n8;
                    if (this.getCurrentLevel() != n6) continue;
                    n7 = n8;
                }
                if (n7 == n8) {
                    if (!this.awards[11]) {
                        this.giveAward(11);
                        bl2 = true;
                    }
                    if (!(this.awards[15] || this.coinsUsedInStory || this.coinsUsedInLevel)) {
                        this.coinsUsedInStory = false;
                        this.giveAward(15);
                        bl2 = true;
                    }
                }
            }
            if (!this.awards[16] && this.isTwoPlayerMode() && (this.endConditionsCodes & 0x4007) != 1) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                nArray2 = new int[]{0, 1, 2};
                nArray = new int[nArray2.length];
                this.m_board.boardHealth(nArray2, nArray, null);
                n4 = nArray[0];
                n3 = nArray[1];
                n2 = nArray[2];
                n6 = n4;
                n5 = n2;
                n8 = n4 * 100 / (n4 + n3 + n2);
                n7 = n2 * 100 / (n4 + n3 + n2);
                if (n6 > n5 && n8 - n7 >= 25) {
                    this.giveAward(16);
                    int n9 = 0;
                    int n10 = this.getCurrentLevel();
                    if (this.getLevelAI(n10) != 0) {
                        n9 = this.getGameScore() + (n10 + 1) * 100 + 7000;
                    }
                    this.awardsScores[this.currentAwards[this.currentAwardCount - 1]] = n4 = n9 * 25 / 100;
                    bl2 = true;
                }
            }
            if (!this.awards[17] && this.isTwoPlayerMode() && (this.endConditionsCodes & 0x4007) == 1 && this.playerJewels > this.cpuJewels * 2) {
                this.giveAward(17);
                n8 = 0;
                n7 = this.getCurrentLevel();
                if (this.getLevelAI(n7) != 0) {
                    n8 = this.getGameScore() + (n7 + 1) * 100 + 7000;
                }
                this.awardsScores[this.currentAwards[this.currentAwardCount - 1]] = n6 = n8 * 25 / 100;
                bl2 = true;
            }
            bl2 = bl2 || this.checkInLevelAwards();
        }
        return bl2;
    }

    private final boolean checkInLevelAwards() {
        if (this.isTwoPlayerMode() && !this.isCPUsTurn()) {
            return false;
        }
        boolean bl = false;
        if (this.getGameMode() == 2) {
            if (!this.awards[4] && this.matchMulti6) {
                this.giveAward(4);
                bl = true;
            }
            if (!this.awards[5] && this.matchMulti7) {
                this.giveAward(5);
                bl = true;
            }
            if (!this.awards[1] && this.match4Count >= 12) {
                this.giveAward(1);
                bl = true;
            }
            if (!this.awards[2] && this.match5Count >= 5) {
                this.giveAward(2);
                bl = true;
            }
            if (!this.awards[0] && this.matchStreak >= 10) {
                this.giveAward(0);
                bl = true;
            }
            this.matchStreak = 0;
            this.crntLevelMaxStreak = 0;
            if (!this.awards[6] && this.totalJewelsMatched + this.crntLevelJewelsMatched >= 10000) {
                this.giveAward(6);
                bl = true;
            }
            if (!this.awards[7] && this.totalJewelsMatched + this.crntLevelJewelsMatched >= 100000) {
                this.giveAward(7);
                bl = true;
            }
        }
        return bl;
    }

    private final void giveAward(int n) {
        this.awards[n] = true;
        this.currentAwards[this.currentAwardCount] = n;
        ++this.currentAwardCount;
    }

    private final void preRenderInLevelAwards() {
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            this.setGameScore(this.getGameScore() + this.awardsScores[this.currentAwards[this.currentAwardCount - 1]]);
            this.levelAwardPoints += this.awardsScores[this.currentAwards[this.currentAwardCount - 1]];
            TimerHandler.resetTimer(4);
            if (this.currentAwardCount > 1) {
                --this.currentAwardCount;
                this.fullRedraw = true;
            } else {
                this.currentAwardCount = 0;
                TimerHandler.resumeTimer(0);
                this.setJQ2009GameState(7);
                TimerHandler.resetTimer(7);
            }
        }
    }

    private final void preRenderEndLevelAwards() {
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            this.setScore(this.getScore() + this.awardsScores[this.currentAwards[this.currentAwardCount - 1]]);
            TimerHandler.resetTimer(4);
            if (this.currentAwardCount > 1) {
                --this.currentAwardCount;
                this.fullRedraw = true;
            } else {
                this.currentAwardCount = 0;
                TimerHandler.resumeTimer(0);
                this.setJQ2009GameState(this.nextState);
            }
        }
    }

    private final void preRenderLevelWonOrLost(boolean bl, int n) {
        SpacSprite spacSprite;
        SpacSprite spacSprite2;
        if (mRupertSpacAnimation == null || mBossSpacAnimation == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            spacSprite2 = mRupertSpacAnimation;
            spacSprite = mBossSpacAnimation;
            this.setCharPos(1, this.getCharX(1) < this.screenWidth * 2 ? this.getCharX(1) + 5 : this.getCharX(1), this.getCharY(1), true, 0, 640, true);
            n2 = 1;
            n3 = 3;
            n4 = 4;
            n5 = 1 + this.getCurrentBossFrame() * 7;
        } else {
            spacSprite2 = mBossSpacAnimation;
            spacSprite = mRupertSpacAnimation;
            this.setCharPos(0, this.getCharX(0) > -this.screenWidth ? this.getCharX(0) - 5 : this.getCharX(0), this.getCharY(0), true, 0, 640, true);
            n2 = 1 + this.getCurrentBossFrame() * 7;
            n3 = 3 + this.getCurrentBossFrame() * 7;
            n4 = 4 + this.getCurrentBossFrame() * 7;
            n5 = 1;
        }
        if (!spacSprite2.isAnimationComplete()) {
            spacSprite2.updateSprite(n);
            if (wonAnimationTimes > 0 && spacSprite2.getSequence() == n2) {
                spacSprite2.setSequence(n3, 0, 0, true);
                RupertState = 1;
                wonAnimationTimes = (byte)(wonAnimationTimes - 1);
            }
        } else {
            switch (RupertState) {
                case 1: {
                    spacSprite2.setSequence(n4, 0, 0, true);
                    RupertState = 2;
                    break;
                }
                case 2: {
                    spacSprite2.setSequence(n2, 1, 0, true);
                }
            }
        }
        try {
            if (!spacSprite.isAnimationComplete()) {
                spacSprite.updateSprite(n);
            } else {
                spacSprite.setSequence(n5, 1, 0, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void preRenderLevelWon() {
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            this.resetAnimations();
            TimerHandler.resumeTimer(0);
            if (this.getGameMode() == 2) {
                this.setCurrentLevel(this.getCurrentLevel() + 1);
                if (!this.coinsUsedInStory && this.coinsUsedInLevel) {
                    this.coinsUsedInStory = true;
                }
                int n = this.getChapter(this.getCurrentLevel());
                int n2 = this.getChapter(this.getCurrentLevel() - 1);
                if (!this.isUnityDemoModeEnabled() && this.getGameScore() != 0) {
                    this.postNewHighScore(this.getUserName(), this.getScore());
                }
                if (n2 != n) {
                    mSpecificLevelSpac = null;
                    mRupertSpac = null;
                    mBossSpac = null;
                    mRupertSpacAnimation = null;
                    mBossSpacAnimation = null;
                    this.setJQ2009GameState(13);
                } else if (this.getLevelAI(this.getCurrentLevel()) != 0) {
                    mBossSpac = null;
                    this.setGameState(9);
                } else {
                    mRupertSpac = null;
                    mBossSpac = null;
                    mRupertSpacAnimation = null;
                    mBossSpacAnimation = null;
                    this.setGameState(9);
                    if (!this.isUnityDemoModeEnabled()) {
                        // empty if block
                    }
                }
            } else {
                this.setGameState(3);
            }
            this.setGameScore(0);
        }
    }

    private final void preRenderLevelLost() {
        this.resetAnimations();
        if (this.wasKeyPressed(22)) {
            TimerHandler.resumeTimer(0);
            this.setGameState(3);
        }
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            TimerHandler.resumeTimer(0);
            this.setJQ2009GameState(4);
        }
    }

    public final void endGameReset() {
        this.coinsUsedInStory = false;
        this.setCurrentLevel(0);
        this.setCoins(0);
        this.setStoryCoins(0);
        this.setScore(0);
        this.setUserName(new char[0]);
    }

    private final void preRenderGameEnd() {
        if (this.wasKeyPressed(21) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
            this.endGameReset();
            this.setUserName(new char[0]);
            this.saveGameState(-1);
            this.setGameState(3);
        }
    }

    protected abstract void resetGame();

    protected final void renderPageBg(Graphics graphics) {
        if (mStorySpac != null) {
            graphics.setColor(0);
        } else {
            graphics.setColor(227, 202, 165);
        }
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (mStorySpac != null) {
            MenuRenderer.renderMenuBookground(graphics, mStorySpac, 0, 0, this.screenWidth, this.screenHeight - this.getSoftKeyBarSize(), -1);
        }
    }

    protected final void renderJQ2009Game(Graphics graphics) {
        try {
            int n = this.getJQ2009GameState();
            switch (n) {
                case 4: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 13: 
                case 15: {
                    int n2;
                    int n3;
                    int n4;
                    Object object;
                    int n5;
                    this.renderPageBg(graphics);
                    int n6 = this.storyFont.getHeight();
                    n6 = mStorySpac.getFrameRect(0)[3];
                    if (n == 3) {
                        n5 = this.getChapter(this.getCurrentLevel());
                        object = new char[2][];
                        object[0] = Integer.toString(n5 + 1).toCharArray();
                        n4 = this.getCurrentLevel();
                        for (int i = 0; i < n5; ++i) {
                            n4 -= this.getChapterLevelCount(i);
                        }
                        object[1] = Integer.toString(n4 + 1).toCharArray();
                        char[] cArray = TextHandler.tokenizeString(this.getText(144), object);
                        char[][] cArray2 = Font.formatString(this.storyFont, cArray, this.screenWidth - 20);
                        this.renderTextLines(graphics, cArray2, 0, cArray2.length, this.storyFont, this.screenWidth >> 1, n6 + 0, 2, 17, true);
                        n6 += this.storyFont.getHeight();
                    }
                    n5 = -1;
                    switch (n) {
                        case 3: {
                            n5 = 14 + this.getCurrentLevel();
                            break;
                        }
                        case 1: {
                            n5 = 51 + this.getChapter(this.getCurrentLevel());
                            break;
                        }
                        case 13: {
                            int n7 = this.getChapter(this.getCurrentLevel() - 1);
                            if (n7 < this.getChaptersCount() - 1) {
                                n5 = 51 + this.getChapter(this.getCurrentLevel());
                                break;
                            }
                            if (this.lastChapterPage == 0) {
                                n5 = 54;
                                break;
                            }
                            n5 = 55;
                            break;
                        }
                        case 2: {
                            n5 = 11 + this.getChapter(this.getCurrentLevel());
                        }
                    }
                    if (n5 > -1) {
                        object = mStorySpac.getFrameRect(n5);
                        mStorySpac.renderFrame(graphics, n5, -1, this.screenWidth >> 1, n6 - object[1] + 0);
                        n6 += object[3];
                    }
                    n5 = this.screenHeight - n6 - this.getSoftKeyBarSize();
                    n6 += 2;
                    n6 += (n5 -= mStorySpac.getFrameRect(2)[3]) >> 1;
                    int n8 = 0;
                    n4 = 0;
                    if (mStorySpac != null) {
                        n8 = mStorySpac.getFrameRect(3)[2];
                        n4 = mStorySpac.getFrameRect(1)[2];
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    if (n != 2) {
                        n3 = n5;
                        this.storyTextPageHeight = n5 / (2 + this.storyFont.getHeight());
                        bl = this.storyTextLineIndex > 0;
                        boolean bl3 = bl2 = this.storyTextLineIndex + this.storyTextPageHeight < this.storyTextLines.length;
                        if (bl || bl2) {
                            this.storyTextPageHeight = (n5 - this.storyFont.getHeight()) / (2 + this.storyFont.getHeight());
                            bl = this.storyTextLineIndex > 0;
                            bl2 = this.storyTextLineIndex + this.storyTextPageHeight < this.storyTextLines.length;
                        }
                    } else {
                        bl = this.storyTextLineIndex > 0;
                        bl2 = this.storyTextLineIndex + this.storyTextPageHeight < this.storyTextLines.length;
                    }
                    this.renderTextLines(graphics, this.storyTextLines, this.storyTextLineIndex, this.storyTextLineIndex + this.storyTextPageHeight, this.storyFont, n8 + (this.screenWidth - n8 - n4 >> 1), n6, 2, 3, true);
                    n3 = this.storyFont.getHeight() + 2;
                    if (bl) {
                        n2 = n6 - (n3 * this.storyTextPageHeight >> 1);
                        mSkbarSpac.renderFrame(graphics, 0, -1, this.screenWidth >> 1, n2);
                    }
                    if (bl2) {
                        n2 = n6 + (n3 * this.storyTextPageHeight >> 1);
                        mSkbarSpac.renderFrame(graphics, 1, -1, this.screenWidth >> 1, n2);
                    }
                    char[] cArray = this.getPositiveSoftkey();
                    Object object2 = bl || bl2 ? this.getNegativeSoftkey() : null;
                    this.renderSoftKeys(graphics, cArray, (char[])object2);
                    break;
                }
                case 6: {
                    if (this.tutorialRepaintMain) {
                        this.renderMain(graphics);
                    }
                    char[][] cArray = Font.formatString(this.getSharedFont(), this.getText(this.tutorialText), this.screenWidth - 20);
                    this.renderInGameDialog(graphics, cArray, (int)TimerHandler.getTimer(4), -1);
                    break;
                }
                case 0: 
                case 5: {
                    this.fullRedraw = true;
                    this.renderMain(graphics);
                    this.renderInGameDialog(graphics, this.popUpTextLines, (int)TimerHandler.getTimer(4), this.popUpFrame);
                    break;
                }
                case 8: 
                case 9: {
                    String string = "";
                    string = string + new String(this.getText(85 + this.currentAwards[this.currentAwardCount - 1])) + "\n" + new String(this.getText(49 + this.currentAwards[this.currentAwardCount - 1])) + "\n" + new String(this.getText(103));
                    Object object = null;
                    object = new char[1][];
                    object[0] = Integer.toString(this.awardsScores[this.currentAwards[this.currentAwardCount - 1]]).toCharArray();
                    char[] cArray = TextHandler.tokenizeString(string.toCharArray(), object);
                    char[][] cArray3 = Font.formatString(this.getSharedFont(), cArray, this.screenWidth - 20);
                    this.renderMain(graphics);
                    this.renderInGameDialog(graphics, cArray3, (int)TimerHandler.getTimer(4), 31 + TextHandler.getLanguage());
                    break;
                }
                case 10: {
                    String string = null;
                    Object object = null;
                    if (this.cheatShowText - 1 < this.awards.length) {
                        string = new String(this.getText(85 + (this.cheatShowText - 1))) + "\n" + new String(this.getText(49 + (this.cheatShowText - 1))) + "\n";
                        string = string + new String(this.getText(103));
                        object = null;
                        object = new char[1][];
                        object[0] = Integer.toString(this.awardsScores[this.cheatShowText - 1]).toCharArray();
                    } else {
                        string = new String(this.getText(131304));
                    }
                    char[] cArray = TextHandler.tokenizeString(string.toCharArray(), object);
                    char[][] cArray4 = Font.formatString(this.getSharedFont(), cArray, this.screenWidth - 20);
                    this.renderMain(graphics);
                    this.renderInGameDialog(graphics, cArray4, (int)TimerHandler.getTimer(4), this.cheatShowText - 1 < this.awards.length ? 31 + TextHandler.getLanguage() : -1);
                    break;
                }
                case 11: 
                case 12: {
                    String string = null;
                    Object object = null;
                    int n9 = -1;
                    if (n == 11) {
                        if (MultiPlayermode == 0) {
                            n9 = 41 + TextHandler.getLanguage();
                            boolean bl = this.getGameMode() == 2 || this.getGameMode() == 0;
                            int n10 = this.getScore();
                            if (this.getGameMode() != 2) {
                                n10 = this.getGameScore();
                            }
                            object = new char[1][];
                            object[0] = Integer.toString(n10).toCharArray();
                            string = new String(this.getText(131305)) + "\n" + new String(this.getText(131306)) + "\n" + (bl ? new String(this.getText(143)) : "");
                        } else if (MultiPlayer1Win > MultiPlayer2Win) {
                            object = new char[3][];
                            object[0] = Integer.toString(1).toCharArray();
                            object[1] = Integer.toString(MultiPlayer1Win).toCharArray();
                            object[2] = Integer.toString(MultiPlayerChallenge).toCharArray();
                            string = new String(this.getText(126));
                        } else if (MultiPlayer2Win > MultiPlayer1Win) {
                            object = new char[3][];
                            object[0] = Integer.toString(2).toCharArray();
                            object[1] = Integer.toString(MultiPlayer2Win).toCharArray();
                            object[2] = Integer.toString(MultiPlayerChallenge).toCharArray();
                            string = new String(this.getText(126));
                        } else {
                            object = new char[3][];
                            object[0] = Integer.toString(MultiPlayer1Win).toCharArray();
                            object[1] = Integer.toString(MultiPlayerChallenge).toCharArray();
                            object[2] = Integer.toString(MultiPlayerChallenge - MultiPlayer1Win - MultiPlayer2Win).toCharArray();
                            string = new String(this.getText(127));
                        }
                    } else {
                        n9 = 36 + TextHandler.getLanguage();
                        string = new String(this.getText(131307)) + "\n" + new String(this.getText(131308));
                    }
                    char[] cArray = TextHandler.tokenizeString(string.toCharArray(), object);
                    char[][] cArray5 = Font.formatString(this.getSharedFont(), cArray, this.screenWidth - 20);
                    this.fullPlayer = 1;
                    this.renderMain(graphics);
                    this.renderInGameDialog(graphics, cArray5, (int)TimerHandler.getTimer(4), n9);
                    break;
                }
                case 7: {
                    this.renderMain(graphics);
                    break;
                }
                case 14: {
                    this.renderPowerups(graphics);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void renderDialog(Graphics graphics, int n, int n2, int n3, int n4, char[][] cArray) {
        graphics.setColor(16245963);
        graphics.fillRect(n, n2 - 2, n3, n4 + 4);
        if (mMenuInGameSpac != null) {
            int n5;
            int[] nArray = mMenuInGameSpac.getFrameRect(13);
            for (n5 = 0; n5 < n3 / nArray[2] + 1; ++n5) {
                mMenuInGameSpac.renderFrame(graphics, 13, -1, n + n5 * nArray[2], n2);
            }
            nArray = mMenuInGameSpac.getFrameRect(14);
            for (n5 = 0; n5 < n3 / nArray[2] + 1; ++n5) {
                mMenuInGameSpac.renderFrame(graphics, 14, -1, n + n5 * nArray[2], n2 + n4 + nArray[3]);
            }
        }
        if (cArray != null) {
            this.renderTextLines(graphics, cArray, 0, cArray.length, this.getBaseFont(), n + (n3 >> 1), n2 + (n4 >> 1), 0, 3, true);
        }
    }

    private final void renderInGameDialog(Graphics graphics, char[][] cArray, int n, int n2) {
        int n3;
        int n4 = this.getSharedFont().getHeight();
        int n5 = cArray.length;
        int n6 = this.screenWidth;
        int n7 = n4 * n5 - (n4 >> 1);
        int n8 = 0;
        int n9 = this.screenHeight - this.getSoftKeyBarSize();
        n9 = n9 - n9 * 25 / 100 - n7;
        if (n2 >= 0 && (n3 = n9 + -10 - 10 + mCommonLevelSpac.getFrameRect(n2)[1]) < 0) {
            n9 -= n3;
        }
        if (n < 200) {
            n9 += n7 >> 1;
            n7 = n * (n4 * n5) / 200 - (n4 >> 1);
            this.renderDialog(graphics, n8, n9 -= n7 >> 1, n6, n7, null);
            this.renderSoftKeys(graphics, null, null);
        } else {
            if (n2 >= 0) {
                n3 = n9 + -10 - 10;
                if (n - 200 < 300) {
                    n3 = n9 + -10 - 10 * (n - 200) / 300;
                }
                mCommonLevelSpac.renderFrame(graphics, n2, -1, this.screenWidth >> 1, n3);
            }
            this.renderDialog(graphics, n8, n9, n6, n7, cArray);
            char[] cArray2 = this.getPositiveSoftkey();
            char[] cArray3 = this.getNegativeSoftkey();
            this.renderSoftKeys(graphics, cArray2, cArray3);
        }
    }

    private void renderBgPart(Graphics graphics, int[] nArray) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.renderBgImage(graphics);
        if (this.twoPlayerMode) {
            this.renderCharacters(graphics);
        }
        graphics.setClip(n, n2, n3, n4);
    }

    protected final void renderHud(Graphics graphics, boolean bl) {
        graphics = this.gBuffer;
        int n = this.screenWidth >> 1;
        int n2 = this.boardStartY - this.borderHeight >> 1;
        if (this.isTwoPlayerMode()) {
            n2 += this.cellSize >> 1;
        }
        Font font = this.getSoftkeyFont();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (MultiPlayermode != 0) {
            this.refreshHud = true;
        }
        if (this.refreshHud || this.fullRedraw || this.refreshHudCenter) {
            int[] nArray;
            if (this.fullPlayer != 0 || this.fullRedraw) {
                nArray = this.getUpperRect();
                this.renderBgPart(graphics, nArray);
            }
            if (bl) {
                Object[] objectArray;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                if ((this.refreshHud || this.fullRedraw) && !this.IsJewelsTwoTypes()) {
                    mHudSpac.renderFrame(graphics, 0, -1, n, n2);
                }
                if ((this.endConditionsCodes & 0x4007) == 1) {
                    if (MultiPlayermode != 1) {
                        n7 = this.playerJewels;
                        n8 = this.playerJewels2;
                        n9 = this.cpuJewels;
                        n10 = this.cpuJewels2;
                        if (this.IsJewelsTwoTypes()) {
                            n3 = this.playerJewels * 90 / this.getJewelsToWinCount(0);
                            n4 = this.cpuJewels * 90 / this.getJewelsToWinCount(0);
                            n5 = this.playerJewels2 * 90 / this.getJewelsToWinCount(1);
                            n6 = this.cpuJewels2 * 90 / this.getJewelsToWinCount(1);
                        } else {
                            n3 = this.playerJewels * 180 / this.getJewelsToWinCount(0);
                            n4 = this.cpuJewels * 180 / this.getJewelsToWinCount(0);
                        }
                    } else {
                        n7 = this.playerJewels;
                        n9 = this.cpuJewels;
                        if (this.player == 0) {
                            n3 = (int)((30000L - TimerHandler.getTimer(0)) * 180L / 30000L);
                            n4 = 180;
                        } else {
                            n3 = 0;
                            n4 = (int)((30000L - TimerHandler.getTimer(0)) * 180L / 30000L);
                        }
                    }
                } else {
                    int[] nArray2 = new int[]{0, 1, 2};
                    objectArray = new int[nArray2.length];
                    this.m_board.boardHealth(nArray2, (int[])objectArray, null);
                    int n11 = objectArray[0];
                    int n12 = objectArray[1];
                    int n13 = objectArray[2];
                    n7 = n11 * 100 / (n11 + n12 + n13);
                    n9 = n13 * 100 / (n11 + n12 + n13);
                    n3 = n11 * 360 / (n11 + n12 + n13);
                    n4 = n13 * 360 / (n11 + n12 + n13);
                }
                if (this.refreshHudCenter || this.fullRedraw || this.refreshHud) {
                    this.refreshHudCenter = false;
                    this.renderRoundPart(graphics, n, n2, n3, n4, n5, n6);
                }
                if (this.refreshHud || this.fullRedraw) {
                    int n14 = n2 + 2;
                    if (this.IsJewelsTwoTypes()) {
                        n14 = n2 + font.getHeight() / 2 + 2;
                        objectArray = (this.endConditionsCodes & 0x4007) == 1 && n8 >= this.getJewelsToWinCount(1) ? (Object[])this.getOkSoftKey() : (Object[])Integer.toString(this.getJewelsToWinCount(1) - n8).toCharArray();
                        font.drawChars(graphics, (char[])objectArray, 0, objectArray.length, n + this.bossHudLeftTextX, n14 + this.bossHudLeftTextY + 0, 3);
                        objectArray = (this.endConditionsCodes & 0x4007) == 1 && n10 >= this.getJewelsToWinCount(1) ? (Object[])this.getOkSoftKey() : (Object[])Integer.toString(this.getJewelsToWinCount(1) - n10).toCharArray();
                        font.drawChars(graphics, (char[])objectArray, 0, objectArray.length, n + this.bossHudRightTextX, n14 + this.bossHudRightTextY + 0, 3);
                        n14 = n2 - font.getHeight() / 2 + 0;
                    }
                    objectArray = MultiPlayermode == 1 ? (Object[])Integer.toString(n7).toCharArray() : ((this.endConditionsCodes & 0x4007) == 1 && n7 >= this.getJewelsToWinCount(0) ? (Object[])this.getOkSoftKey() : (Object[])Integer.toString(Math.abs(this.getJewelsToWinCount(0) - n7)).toCharArray());
                    font.drawChars(graphics, (char[])objectArray, 0, objectArray.length, n + this.bossHudLeftTextX, n14 + this.bossHudLeftTextY + (this.IsJewelsTwoTypes() ? 0 : 0), 3);
                    objectArray = MultiPlayermode == 1 ? (Object[])Integer.toString(n9).toCharArray() : ((this.endConditionsCodes & 0x4007) == 1 && n9 >= this.getJewelsToWinCount(0) ? (Object[])this.getOkSoftKey() : (Object[])Integer.toString(Math.abs(this.getJewelsToWinCount(0) - n9)).toCharArray());
                    font.drawChars(graphics, (char[])objectArray, 0, objectArray.length, n + this.bossHudRightTextX, n14 + this.bossHudRightTextY + (this.IsJewelsTwoTypes() ? 0 : 0), 3);
                }
            } else {
                mHudSpac.renderFrame(graphics, 1, -1, n, n2);
                char[][] cArrayArray = new char[1][];
                char[][] cArrayArray2 = new char[1][];
                int n15 = mHudSpac.getFrameRect(6)[2];
                cArrayArray2[0] = Integer.toString(this.getCoins()).toCharArray();
                int n16 = font.charsWidth(cArrayArray2[0], 0, cArrayArray2[0].length);
                nArray = mHudSpac.getFrameRect(8);
                if (this.isTutorialEnabled() && this.renderCoinPointer) {
                    mSpecialCursorSpac.renderFrame(graphics, 26, -1, n + this.hudLeftTextX + (n15 >> 1) - (-n16 - 2 >> 1), n2 + this.hudLeftTextY + this.getSharedFont().getHeight());
                }
                int n17 = 0;
                if (this.IsJewelsOnePlayer()) {
                    char[] cArray = this.playerJewels >= this.getJewelsToWinCount(0) ? this.getOkSoftKey() : Integer.toString(this.getJewelsToWinCount(0) - this.playerJewels).toCharArray();
                    font.drawChars(graphics, cArray, 0, cArray.length, n + this.hudLeftTextX + (n15 >> 1) + (n15 >> 2) + (n16 >> 1) - 4, n2 + this.hudLeftTextY + (this.hudRect[3] - this.getSharedFont().getHeight() >> 1) + 0, 1);
                } else {
                    n17 = mHudSpac.getFrameRect(8)[2] / 2;
                }
                font.drawChars(graphics, cArrayArray2[0], 0, cArrayArray2[0].length, n + this.hudLeftTextX + (n15 >> 1) - (n15 >> 3) - (n16 + nArray[2] + 2 >> 1) + n17, n2 + this.hudLeftTextY + (this.hudRect[3] - this.getSharedFont().getHeight() >> 1) + 0, 4);
                mHudSpac.renderFrame(graphics, 8, -1, n + this.hudLeftTextX + (n15 >> 1) - (n15 >> 3) - (-n16 + nArray[2] - 2 >> 1) + n17, n2 + 0 + (-nArray[3] >> 1));
                int n18 = this.getScore();
                if (this.getGameMode() == 0) {
                    n18 = 0;
                }
                int n19 = this.getGameScore();
                if ((this.getJQ2009GameState() == 12 || this.getJQ2009GameState() == 11) && this.getGameMode() == 2) {
                    n19 = 0;
                }
                cArrayArray2[0] = Integer.toString(n19 + n18).toCharArray();
                font.drawChars(graphics, cArrayArray2[0], 0, cArrayArray2[0].length, n + this.hudRightTextX, n2 + this.hudRightTextY + 0, 1);
            }
            this.refreshHud = false;
        }
    }

    private final void renderRoundPart(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        int[] nArray2;
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.IsJewelsTwoTypes()) {
            nArray = nArray2 = mHudSpac.getFrameRect(11);
            nArray[0] = nArray[0] + 0;
            nArray[1] = nArray[1] + 0;
            nArray[2] = nArray[2] + 0;
            nArray[3] = nArray[3] + 0;
        } else {
            nArray = nArray2 = mHudSpac.getFrameRect(3);
        }
        graphics.setColor(1247767);
        graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, 0, 360);
        if (this.IsJewelsTwoTypes()) {
            nArray2 = new int[4];
            if (n3 >= 90) {
                n3 = 90;
                nArray2[0] = DefaultConstants.TIMER_PLAYER_COLOUR[6];
            } else {
                if (n3 > 4) {
                    n3 -= 3;
                }
                nArray2[0] = DefaultConstants.TIMER_PLAYER_COLOUR[this.m_board.getWinnerTile(0)];
            }
            if (n5 >= 90) {
                n5 = 90;
                nArray2[1] = DefaultConstants.TIMER_PLAYER_COLOUR[6];
            } else {
                if (n5 > 4) {
                    n5 -= 3;
                }
                nArray2[1] = DefaultConstants.TIMER_PLAYER_COLOUR[this.m_board.getWinnerTile(1)];
            }
            if (n4 >= 90) {
                n4 = 90;
                nArray2[2] = DefaultConstants.TIMER_CPU_COLOUR[6];
            } else {
                if (n4 > 4) {
                    n4 -= 3;
                }
                nArray2[2] = DefaultConstants.TIMER_CPU_COLOUR[this.m_board.getWinnerTile(0)];
            }
            if (n6 >= 90) {
                n6 = 90;
                nArray2[3] = DefaultConstants.TIMER_CPU_COLOUR[6];
            } else {
                if (n6 > 4) {
                    n6 -= 3;
                }
                nArray2[3] = DefaultConstants.TIMER_CPU_COLOUR[this.m_board.getWinnerTile(1)];
            }
            graphics.setColor(nArray2[0]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, -180, -n3);
            graphics.setColor(nArray2[1]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, -180, n5);
            graphics.setColor(nArray2[2]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, 0, n4);
            graphics.setColor(nArray2[3]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, 0, -n6);
        } else {
            nArray2 = new int[2];
            if ((this.endConditionsCodes & 0x4007) == 1) {
                nArray2[0] = DefaultConstants.TIMER_PLAYER_COLOUR[this.m_board.getWinnerTile(0)];
                nArray2[1] = DefaultConstants.TIMER_CPU_COLOUR[this.m_board.getWinnerTile(0)];
            } else {
                nArray2[0] = DefaultConstants.TIMER_PLAYER_COLOUR[5];
                nArray2[1] = DefaultConstants.TIMER_CPU_COLOUR[5];
            }
            graphics.setColor(nArray2[0]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, -90, -n3);
            graphics.setColor(nArray2[1]);
            graphics.fillArc(n + nArray[0] + 1, n2 + nArray[1] + 1, nArray[2] - 2, nArray[3] - 2, -90, n4);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (MultiPlayermode != 2 && (this.endConditionsCodes & 0x4007) == 1) {
            byte by;
            int n7;
            if (this.IsJewelsTwoTypes()) {
                mHudSpac.renderFrame(graphics, 11, -1, n, n2);
            } else {
                mHudSpac.renderFrame(graphics, 9, -1, n, n2);
            }
            int n8 = n2;
            int n9 = 0;
            if (this.IsJewelsTwoTypes()) {
                n7 = this.jewelsRemap[this.m_board.getWinnerTile(1)];
                by = this.getJewelsType(this.m_board.getWinnerTile(1));
                n7 = 83 + by * (this.jewelsRemap.length - 1) + this.m_board.getWinnerTile(1);
                by = this.getJewelsType(this.m_board.getWinnerTile(0));
                n9 = 83 + by * (this.jewelsRemap.length - 1) + this.m_board.getWinnerTile(0);
                nArray = this.mJewelsSpac.getFrameRect(n7);
                n8 = n2 + nArray[3] / 2 + 2 + nArray[1];
                this.mJewelsSpac.renderFrame(graphics, n7, -1, n - nArray[0] - (nArray[2] >> 1), n8 + 0 - nArray[1] - (nArray[3] >> 1));
                n8 = n2 - nArray[3] / 2 - 2 + nArray[1];
            }
            n7 = this.jewelsRemap[this.m_board.getWinnerTile(0)];
            if (!this.IsJewelsTwoTypes()) {
                // empty if block
            }
            if (n9 > 0) {
                n7 = n9;
            } else {
                by = this.getJewelsType(this.m_board.getWinnerTile(0));
                if (by > 0) {
                    n7 = 25 + this.jewelsRemap.length - 1 + (by - 1) * 25 + this.jewelsRemap[this.m_board.getWinnerTile(0)];
                }
            }
            nArray = this.mJewelsSpac.getFrameRect(n7);
            this.mJewelsSpac.renderFrame(graphics, n7, -1, n - nArray[0] - (nArray[2] >> 1), n8 + (!this.IsJewelsTwoTypes() ? 0 : 0) - nArray[1] - (nArray[3] >> 1));
        } else {
            Font font = this.getDigitFont();
            mHudSpac.renderFrame(graphics, 9, -1, n, n2);
            String string = "";
            if (MultiPlayermode == 3 || MultiPlayermode == 2) {
                boolean bl5 = true;
                if (gameStartTime == -1L) {
                    string = "0:00";
                } else {
                    int n10 = 0;
                    n10 = (int)TimerHandler.getTimer(0) / 1000;
                    if (n10 > 599) {
                        if (n10 % 2 == 0) {
                            bl5 = false;
                        }
                        n10 = 599;
                    }
                    string = n10 / 60 + ":";
                    if (n10 % 60 < 10) {
                        string = string + "0";
                    }
                    string = string + n10 % 60;
                }
                if (bl5) {
                    font.drawChars(graphics, string.toCharArray(), 0, string.length(), n, n2 - font.getHeight() / 2, 17);
                }
            } else {
                char[] cArray = Integer.toString(levelData[this.getCurrentLevel() * 8 + 2] - this.Round / 2).toCharArray();
                font.drawChars(graphics, cArray, 0, cArray.length, n, n2 - font.getHeight() / 2, 17);
            }
        }
    }

    protected final void renderTimer(Graphics graphics) {
        int n;
        int n2 = this.screenWidth >> 1;
        int n3 = this.boardStartY - this.borderHeight >> 1;
        int n4 = 0;
        n4 = (int)TimerHandler.getTimer(0) * 352 / (levelData[this.getCurrentLevel() * 8 + 2] * 60000);
        int n5 = 0;
        n5 = (int)((long)(levelData[this.getCurrentLevel() * 8 + 2] * 60000) - TimerHandler.getTimer(0));
        if (n5 < levelData[this.getCurrentLevel() * 8 + 2] * 15000) {
            n = (int)TimerHandler.getTimer(2) / 150;
            switch (n) {
                case 0: {
                    graphics.setColor(0xAE0000);
                    break;
                }
                case 1: {
                    graphics.setColor(6160128);
                    break;
                }
                case 2: {
                    graphics.setColor(0xFFFFFF);
                    break;
                }
                case 3: {
                    graphics.setColor(6160128);
                    break;
                }
                case 4: {
                    graphics.setColor(0xAE0000);
                    break;
                }
                default: {
                    TimerHandler.resetTimer(2);
                    graphics.setColor(0xAE0000);
                    break;
                }
            }
        } else {
            graphics.setColor(6160128);
        }
        graphics.fillArc(this.hudCenterRect[0] + 1, this.hudCenterRect[1] + 1, this.hudCenterRect[2] - 2, this.hudCenterRect[3] - 2, 0, 360);
        graphics.setColor(1247767);
        graphics.fillArc(this.hudCenterRect[0] + 1, this.hudCenterRect[1] + 1, this.hudCenterRect[2] - 2, this.hudCenterRect[3] - 2, 94, -(n4 + 8));
        if (this.IsJewelsOnePlayer()) {
            mHudSpac.renderFrame(graphics, 10, -1, n2, n3);
            n = n3;
            int n6 = this.jewelsRemap[this.m_board.getWinnerTile(0)];
            byte by = this.getJewelsType(this.m_board.getWinnerTile(0));
            if (by > 0) {
                n6 = 25 + this.jewelsRemap.length - 1 + (by - 1) * 25 + this.jewelsRemap[this.m_board.getWinnerTile(0)];
            }
            int[] nArray = this.mJewelsSpac.getFrameRect(n6);
            this.mJewelsSpac.renderFrame(graphics, n6, -1, n2 - nArray[0] - (nArray[2] >> 1), n - nArray[1] - (nArray[3] >> 1));
        } else {
            mHudSpac.renderFrame(graphics, 2, -1, n2, n3);
        }
        if (this.isTutorialEnabled()) {
            this.changeSpritePosition(4, n2, n3 + (this.hudCenterRect[3] >> 1));
            if (this.getTutorialStep() == 4) {
                // empty if block
            }
        }
    }

    public void renderMain(Graphics graphics) {
        try {
            if (this.stateChangedThisTick) {
                this.fullRedraw = true;
            }
            this.renderBackground(graphics);
            this.renderBoard(graphics, true);
            this.renderHud(graphics, this.twoPlayerMode);
            this.renderBackbuffer(graphics);
            if (this.getJQ2009GameState() == 7) {
                char[] cArray = this.getPositiveSoftkey();
                char[] cArray2 = this.getNegativeSoftkey();
                if (MultiPlayermode <= 0 && this.getCurrentLevel() != 0 && this.player == 0) {
                    this.renderSoftKeys(graphics, cArray, cArray2);
                } else {
                    this.renderSoftKeys(graphics, null, cArray2);
                }
            }
            this.renderMovingJewels(graphics);
            if (!this.twoPlayerMode) {
                this.renderTimer(graphics);
            }
            this.fullRedraw = false;
            this.JewelCoinsEffects(graphics);
            this.renderSelectedJewel(graphics);
            this.Effects(graphics);
            if (this.getJQ2009GameState() != 9 && this.getJQ2009GameState() != 8) {
                this.renderAnimations(graphics);
            }
            this.renderCursor(graphics);
            this.renderBlacBoxes(graphics);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public final void renderBlacBoxes(Graphics graphics) {
    }

    private final int getPowerupsMaxWidth() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char[] cArray = this.getText(38 + this.powerups[i]);
            int n2 = this.getSharedFont().charsWidth(cArray, 0, cArray.length, true);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private final char[][] getPowerupItemsTexts() {
        char[][] cArrayArray = new char[this.getPowerupsLevel(this.getCurrentLevel()) + (this.getPowerupsLevel(this.getCurrentLevel()) < 3 ? 2 : 1)][];
        for (int i = 0; i < cArrayArray.length; ++i) {
            cArrayArray[i] = this.getText(38 + i);
        }
        return cArrayArray;
    }

    private final void renderItem(Graphics graphics, int n, int n2, int n3, char[] cArray, int n4, boolean bl, boolean bl2, int n5) {
        Font font = this.getSharedFont();
        int n6 = font.charsWidth(cArray, 0, cArray.length, true);
        n6 += 7;
        char[] cArray2 = Integer.toString(n4).toCharArray();
        int n7 = font.charsWidth(cArray2, 0, cArray2.length, true);
        int n8 = 0;
        if (bl2) {
            n8 = n7 + (n7 << 1) + mHudSpac.getFrameRect(8)[2];
        }
        if (bl) {
            this.renderSelectionGlow(graphics, mMenuInGameSpac, n6 + n8, n, n2 - n3, false, false, false);
        }
        font.drawChars(graphics, cArray, 0, cArray.length, n + 0, n2 - n3 + 0, 20, true);
        if (bl2) {
            font.drawChars(graphics, cArray2, 0, cArray2.length, n + n6 + 0, n2 - n3 + 0, 20, true);
            mHudSpac.renderFrame(graphics, 8, -1, n + n6 + n7 + (n7 << 1) + 0, n2 - (n3 >> 1) - (mHudSpac.getFrameRect(8)[3] >> 1));
        }
    }

    public final void calculateSpecialMenuItemWidth() {
        Font font = this.getSharedFont();
        int n = this.getPowerupsMaxWidth();
        int n2 = mHudSpac.getFrameRect(8)[2];
        char[] cArray = Integer.toString(3).toCharArray();
        int n3 = font.charsWidth(cArray, 0, cArray.length, true);
        this.specialMenuItemWidth = n + (n3 << 1) + n3 + n2 + 0;
    }

    private int getPowerupCost(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 6;
            }
        }
        return n2;
    }

    private final void renderPowerupsTitle(Graphics graphics, int n, int n2, int n3, int n4) {
        Font font = this.getSharedFont();
        int n5 = 0;
        n5 = mMenuInGameSpac.getFrameRect(0)[3];
        char[][] cArrayArray = new char[][]{this.getBossPowerup() == -1 ? (" " + this.getCoins()).toCharArray() : (" " + JQ2009Game.getCPUCoins()).toCharArray()};
        char[] cArray = TextHandler.tokenizeString(this.getText(48), cArrayArray);
        char[][] cArray2 = Font.formatString(font, cArray, this.screenWidth);
        int n6 = font.charsWidth(cArray2[0], 0, cArray2[0].length, true);
        int n7 = 0;
        long l = TimerHandler.getTimer(11);
        if (l < 1000L) {
            n7 = l % 100L < 50L ? -2 : 2;
        }
        int n8 = 0;
        n8 = mHudSpac.getFrameRect(8)[2];
        mHudSpac.renderFrame(graphics, 8, -1, n3 + (n + n2 + this.specialMenuItemWidth - (n8 + n6) >> 1) - 4, n4 + n7 - ((font.getHeight() >> 1) + 0) - (n8 >> 1) - n5 / 4);
        font.drawChars(graphics, cArray2[0], 0, cArray2[0].length, n3 + (n + n2 + this.specialMenuItemWidth - (n6 - n8) >> 1), n4 - (font.getHeight() + 1) - n5 / 4, 20, true);
    }

    private final int[] getFontNum(Font font, char[] cArray) {
        int[] nArray = new int[15];
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ' ') continue;
            nArray[n * 3] = i - (i - n2 - 1);
            nArray[n * 3 + 1] = i - n2 - 1;
            nArray[n * 3 + 2] = font.charsWidth(cArray, nArray[n * 3], nArray[n * 3 + 1], true);
            n2 = i;
            ++n;
            bl = true;
        }
        if (bl) {
            nArray[n * 3] = nArray[(n - 1) * 3] + nArray[(n - 1) * 3 + 1] + 1;
            nArray[n * 3 + 1] = cArray.length - nArray[n * 3];
            nArray[n * 3 + 2] = font.charsWidth(cArray, nArray[n * 3], nArray[n * 3 + 1], true);
        } else {
            nArray[0] = 0;
            nArray[1] = cArray.length;
            nArray[2] = font.charsWidth(cArray, nArray[0], nArray[1], true);
        }
        return nArray;
    }

    private final int[] getFontNum2(Font font, int n, char[] cArray) {
        int[] nArray = this.getFontNum(font, cArray);
        int n2 = nArray[2];
        for (int i = 1; i < nArray.length / 3 && nArray[i * 3] > 0; ++i) {
            if ((n2 += nArray[i * 3]) > n) {
                n2 = nArray[i * 3];
                continue;
            }
            int n3 = (i - 1) * 3 + 1;
            nArray[n3] = nArray[n3] + (nArray[i * 3 + 1] + 1);
            for (int j = i + 1; j < nArray.length / 3; ++j) {
                nArray[(j - 1) * 3] = nArray[j * 3];
                nArray[(j - 1) * 3 + 1] = nArray[j * 3 + 1];
                nArray[(j - 1) * 3 + 2] = nArray[j * 3 + 2];
            }
            nArray[12] = 0;
            nArray[13] = 0;
            nArray[14] = 0;
            --i;
        }
        return nArray;
    }

    private final void renderPowerups(Graphics graphics) {
        this.renderMain(graphics);
        switch (this.powerUpState) {
            case 0: {
                int n;
                int n2;
                Font font = this.getSharedFont();
                int n3 = this.boardStartY + this.m_board.getHeight() * this.cellSize / 2;
                Object[] objectArray = mPowerupSpac.getFrameRect(27);
                for (n2 = 0; n2 < this.screenWidth / objectArray[2] + 1; ++n2) {
                    for (int i = 0; i < this.screenHeight / objectArray[3] + 1; ++i) {
                        mPowerupSpac.renderFrame(graphics, 27, -1, n2 * objectArray[2], i * objectArray[3]);
                    }
                }
                objectArray = mPowerupSpac.getFrameRect(2);
                mPowerupSpac.renderFrame(graphics, 2, -1, this.screenWidth / 2, n3);
                n2 = 0;
                long l = TimerHandler.getTimer(11);
                if (l < 1000L) {
                    n2 = l % 100L < 50L ? -2 : 2;
                }
                mPowerupSpac.renderFrame(graphics, 32, -1, this.screenWidth / 2, n3);
                mPowerupSpac.renderFrame(graphics, 3, -1, this.screenWidth / 2, n3 + n2);
                try {
                    char[][] cArray = this.getPowerupItemsTexts();
                    if (this.currentPowerup >= 0) {
                        Object[] objectArray2;
                        n = font.charsWidth(cArray[this.currentPowerup], 0, cArray[this.currentPowerup].length, true);
                        if (n > objectArray[2]) {
                            objectArray2 = this.getFontNum2(font, objectArray[2], cArray[this.currentPowerup]);
                            for (int i = 0; i < objectArray2.length / 3 && objectArray2[i * 3 + 2] > 0; ++i) {
                                font.drawChars(graphics, cArray[this.currentPowerup], objectArray2[i * 3], objectArray2[i * 3 + 1], objectArray[0] + objectArray[2] / 2 + this.screenWidth / 2, objectArray[1] + n3 + i * font.getHeight(), 17, true);
                            }
                        } else {
                            font.drawChars(graphics, cArray[this.currentPowerup], 0, cArray[this.currentPowerup].length, objectArray[0] + objectArray[2] / 2 + this.screenWidth / 2, objectArray[1] + n3, 17, true);
                        }
                        objectArray2 = Integer.toString(this.getPowerupCost(this.currentPowerup)).toCharArray();
                        font.drawChars(graphics, (char[])objectArray2, 0, objectArray2.length, objectArray[0] + objectArray[2] / 3 + this.screenWidth / 2, objectArray[1] + objectArray[3] + n3 + 2, 17);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mPowerupAnimation[0].renderSprite(graphics, this.screenWidth / 2, n3);
                mPowerupSpac.renderFrame(graphics, 0, -1, this.screenWidth / 2, n3);
                mPowerupSpac.renderFrame(graphics, 1, -1, this.screenWidth / 2, n3);
                for (int i = 1; i < this.powerups.length + 1 && (this.powerups[i - 1] >= 0 || this.getBossPowerup() != -1 && i - 1 == this.currentPowerup); ++i) {
                    n = 1;
                    if (gameTutorialTime > 0L && (i == this.powerups.length || this.powerups[i] < 0)) {
                        gameTutorialshow = (byte)(gameTutorialshow + 1);
                        n = System.currentTimeMillis() - gameTutorialTime < 1500L ? 0 : (System.currentTimeMillis() - gameTutorialTime > 3500L ? 1 : (gameTutorialshow / 5 % 2 == 0 ? 1 : 0));
                    }
                    if (n == 0) continue;
                    this.mPowerupAnimation[i].renderSprite(graphics, this.screenWidth / 2, n3);
                }
                if (gameTutorialTime < 0L) {
                    this.mPowerupAnimation[this.powerups.length + 1].renderSprite(graphics, this.screenWidth / 2, n3);
                }
                objectArray = mPowerupSpac.getFrameRect(1);
                font = this.getDigitFont();
                char[] cArray = this.getBossPowerup() == -1 ? Integer.toString(this.getCoins()).toCharArray() : Integer.toString(JQ2009Game.getCPUCoins()).toCharArray();
                font.drawChars(graphics, cArray, 0, cArray.length, objectArray[0] + this.screenWidth / 2, objectArray[1] + n3, 20);
                cArray = new char[]{'x'};
                font.drawChars(graphics, cArray, 0, cArray.length, objectArray[0] - font.charsWidth(cArray, 0, cArray.length, true) - 4 + this.screenWidth / 2, objectArray[1] + n3, 20);
                font = this.getSharedFont();
                if (this.getBossPowerup() == -1 && gameTutorialTime <= 0L) {
                    char[] cArray2 = this.getPositiveSoftkey();
                    objectArray = this.getNegativeSoftkey();
                    this.renderSoftKeys(graphics, cArray2, (char[])objectArray);
                    break;
                }
                this.renderSoftKeys(graphics, null, this.getPauseSoftKey());
                break;
            }
            case 1: {
                if (this.getBossPowerup() == -1 && gameTutorialTime <= 0L) {
                    char[] cArray = this.getPositiveSoftkey();
                    char[] cArray3 = this.getNegativeSoftkey();
                    this.renderSoftKeys(graphics, cArray, cArray3);
                    break;
                }
                this.renderSoftKeys(graphics, null, this.getPauseSoftKey());
            }
        }
    }

    protected final void destroyJQ2009Game() {
        TextHandler.unloadTextSection(2);
        this.moves = null;
        this.m_board = null;
        mCommonLevelSpac = null;
        mSpecificLevelSpac = null;
        mRupertSpac = null;
        mBossSpac = null;
        mHudSpac = null;
        this.mJewelsSpac = null;
        mStorySpac = null;
        mEffectSpac = null;
        mPowerupSpac = null;
        this.mPowerupAnimation = null;
        this.JewelsAnimation = null;
        this.mEffectAnimation = null;
        this.mIconAnimation = null;
        this.cursorAnimation = null;
        this.hammerAnimation = null;
        this.flameAnimation = null;
        mRupertSpacAnimation = null;
        mBossSpacAnimation = null;
        System.gc();
    }

    protected final void resetJQ2009Game() {
        this.setJQ2009GameState(4);
    }

    protected final void resetJQ2009Chapter() {
        this.setCurrentLevelToFirstFromChapter();
        this.setJQ2009GameState(2);
    }

    protected final void resumeJQ2009Game() {
        TimerHandler.resumeTimer(0);
        this.resetHint();
        TimerHandler.resumeTimer(2);
        TimerHandler.resumeTimer(6);
        TimerHandler.resumeTimer(8);
        TimerHandler.resumeTimer(3);
    }

    private void setJQ2009GameState(int n) {
        int n2 = this.jq2009GameState;
        this.jq2009GameState = n;
        this.jq2009GameStateChanged(this.jq2009GameState, n2);
    }

    private void jq2009GameStateChanged(int n, int n2) {
        if (n2 != n) {
            this.stateChangedThisTick = true;
        }
        switch (n) {
            case 4: {
                break;
            }
            case 0: 
            case 5: {
                if (gamePauseTime < 0L) {
                    gamePauseTime = System.currentTimeMillis() - gameStartTime;
                }
                this.fullRedraw = true;
                TimerHandler.resetTimer(4);
                this.popUpFrame = -1;
                TimerHandler.pauseTimer(0);
                if (this.isTwoPlayerMode()) {
                    TimerHandler.pauseTimer(7);
                }
                this.setPositiveSoftkey(this.getOkSoftKey());
                this.setNegativeSoftkey(null);
                if (!this.isSoundEnabled()) break;
                break;
            }
            case 1: {
                this.setupStoryPage(this.getText(47));
                break;
            }
            case 2: {
                this.storyFont = this.getSharedFont();
                int n3 = this.getChapter(this.getCurrentLevel());
                char[][] cArrayArray = new char[][]{Integer.toString(n3 + 1).toCharArray()};
                char[] cArray = TextHandler.tokenizeString(this.getText(168), cArrayArray);
                char[][] cArray2 = Font.formatString(this.storyFont, cArray, this.screenWidth - 20);
                cArray2[0] = (new String(cArray2[0]) + "\n" + new String(this.getText(161 + this.getChapter(this.getCurrentLevel())))).toCharArray();
                this.setupStoryPage(cArray2[0]);
                break;
            }
            case 13: {
                if (this.getChapter(this.getCurrentLevel()) == -1) {
                    this.setupStoryPage(this.getText(166 + this.lastChapterPage));
                    break;
                }
                this.setupStoryPage(this.getText(164 + this.getChapter(this.getCurrentLevel()) - 1));
                break;
            }
            case 3: {
                this.setupStoryPage(this.getText(131311 + this.getCurrentLevel()));
                break;
            }
            case 15: {
                this.setupStoryPage(this.getText(131305));
                this.setPositiveSoftkey(this.getOkSoftKey());
                this.setNegativeSoftkey(null);
                break;
            }
            case 6: {
                TimerHandler.pauseTimer(0);
                TimerHandler.resetTimer(4);
                this.fullRedraw = true;
                this.setPositiveSoftkey(this.getOkSoftKey());
                this.setNegativeSoftkey(null);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                TimerHandler.pauseTimer(0);
                this.fullRedraw = true;
                TimerHandler.resumeTimer(4);
                TimerHandler.resetTimer(4);
                this.setPositiveSoftkey(this.getOkSoftKey());
                this.setNegativeSoftkey(null);
                break;
            }
            case 11: {
                if (gamePauseTime < 0L) {
                    gamePauseTime = System.currentTimeMillis() - gameStartTime;
                }
                this.fullRedraw = true;
                TimerHandler.pauseTimer(0);
                TimerHandler.resetTimer(4);
                int n4 = this.getCurrentLevel();
                if (this.getLevelAI(n4) != 0) {
                    this.setGameScore(this.getGameScore() + (n4 + 1) * 100 + 7000);
                    if (this.getGameMode() == 2) {
                        this.setScore(this.getScore() + this.getGameScore());
                    }
                } else if (this.getGameMode() == 2) {
                    this.setScore(this.getScore() + this.getGameScore());
                }
                this.setCurrentLevel(n4 + 1);
                if (this.getGameMode() == 2 && this.getQuickModeMaxLevel() < this.getCurrentLevel()) {
                    int n5 = this.getCurrentLevel();
                    if (n5 >= levelData.length / 8) {
                        --n5;
                    }
                    this.setQuickModeMaxLevel(n5);
                }
                this.saveGameState(-1);
                this.setCurrentLevel(n4);
                this.setPositiveSoftkey(this.getOkSoftKey());
                this.setNegativeSoftkey(null);
                if (!this.isSoundEnabled()) break;
                this.playSound(5, 0);
                break;
            }
            case 12: {
                TimerHandler.pauseTimer(0);
                TimerHandler.resetTimer(4);
                this.setPositiveSoftkey(this.getYesSoftKey());
                this.setNegativeSoftkey(this.getNoSoftKey());
                if (!this.isSoundEnabled()) break;
                this.playSound(6, 0);
                break;
            }
            case 7: {
                if (n2 != 6 && n2 != 0 && n2 != 8) {
                    this.setSubstate(0);
                }
                if (MultiPlayermode <= 0 && this.getCurrentLevel() != 0) {
                    this.setPositiveSoftkey(this.getPowerupSoftkey());
                } else {
                    this.setPositiveSoftkey(null);
                }
                this.setNegativeSoftkey(this.getPauseSoftKey());
                break;
            }
            case 14: {
                if (this.bossPower != -1) {
                    this.powerups[this.bossPower] = -1;
                }
                this.powerUpState = 0;
                this.flameAnimation = null;
                int n6 = 0;
                for (n6 = 0; n6 < this.powerups.length && this.powerups[n6] != -1; ++n6) {
                }
                if (gameTutorialTime > 0L) {
                    if (n6 <= 0) {
                        n6 = 1;
                    }
                    this.currentPowerup = n6 - 1;
                    if (this.mPowerupAnimation != null) {
                        this.preChoosePowerup(n6 - 1, false);
                        this.mPowerupAnimation[this.currentPowerup + 1].setSequence(10 + this.currentPowerup, 1, 0, true);
                    }
                } else {
                    if (this.mPowerupAnimation != null) {
                        this.preChoosePowerup(0, false);
                    }
                    this.currentPowerup = 0;
                }
                if (this.mPowerupAnimation != null) {
                    this.mPowerupAnimation[0].setSequence(0, 0, 0, true);
                }
                this.setPositiveSoftkey(this.getSelectSoftKey());
                this.setNegativeSoftkey(this.getBackSoftKey());
                break;
            }
        }
    }

    public int getJQ2009GameState() {
        return this.jq2009GameState;
    }

    protected final void pauseJQ2009Game() {
        if (gamePauseTime < 0L) {
            gamePauseTime = System.currentTimeMillis() - gameStartTime;
        }
        TimerHandler.pauseTimer(0);
        TimerHandler.pauseTimer(1);
        TimerHandler.pauseTimer(2);
        TimerHandler.pauseTimer(6);
        TimerHandler.pauseTimer(8);
        TimerHandler.pauseTimer(3);
        this.pushGameState(7);
    }

    private final void moveCursor(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int[][] nArrayArray;
        int n;
        if (bl) {
            --this.yPos;
            if (this.yPos < 0 && !this.selected) {
                this.yPos += this.m_board.getHeight();
            }
            if (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                if (this.selected) {
                    this.yPos = (this.yPos + 1) % this.m_board.getHeight();
                } else {
                    while (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                        --this.yPos;
                        if (this.yPos >= 0) continue;
                        this.yPos += this.m_board.getHeight();
                    }
                }
            } else if (this.selected) {
                this.selected = false;
                this.m_board.handleCellSelect(this.xPos, this.yPos);
            }
        }
        if (bl2) {
            ++this.yPos;
            if (this.yPos >= this.m_board.getHeight() && !this.selected) {
                this.yPos -= this.m_board.getHeight();
            }
            if (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                if (this.selected) {
                    --this.yPos;
                } else {
                    while (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                        ++this.yPos;
                        if (this.yPos < this.m_board.getHeight()) continue;
                        this.yPos -= this.m_board.getHeight();
                    }
                }
            } else if (this.selected) {
                this.selected = false;
                this.m_board.handleCellSelect(this.xPos, this.yPos);
            }
        }
        if (bl3) {
            --this.xPos;
            if (this.xPos < 0 && !this.selected) {
                this.xPos += this.m_board.getWidth();
            }
            if (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                if (this.selected) {
                    ++this.xPos;
                } else {
                    while (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                        --this.xPos;
                        if (this.xPos >= 0) continue;
                        this.xPos += this.m_board.getWidth();
                    }
                }
            } else if (this.selected) {
                this.selected = false;
                this.m_board.handleCellSelect(this.xPos, this.yPos);
            }
        }
        if (bl4) {
            ++this.xPos;
            if (this.xPos >= this.m_board.getWidth() && !this.selected) {
                this.xPos -= this.m_board.getWidth();
            }
            if (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                if (this.selected) {
                    --this.xPos;
                } else {
                    while (!this.m_board.isCellActive(this.xPos, this.yPos)) {
                        ++this.xPos;
                        if (this.xPos < this.m_board.getWidth()) continue;
                        this.xPos -= this.m_board.getWidth();
                    }
                }
            } else if (this.selected) {
                this.selected = false;
                this.m_board.handleCellSelect(this.xPos, this.yPos);
            }
        }
        boolean bl6 = bl5 = bl5 && !bl && !bl2 && !bl3 && !bl4;
        if (bl5) {
            if (this.selected) {
                this.m_board.deselectCells();
            } else if (!this.m_board.handleCellSelect(this.xPos, this.yPos)) {
                this.selected = !this.selected;
            } else {
                if (this.isSoundEnabled()) {
                    this.playSound(7, 0);
                }
                if (this.isTutorialEnabled()) {
                    if (this.getTutorialStep() == 1) {
                        if (this.isTutorialMove(this.getCurrentLevel(), this.xPos, this.yPos)) {
                            this.stopSpriteAnimation(1);
                            this.setTutorialTextClear(true);
                            if (this.setTutorialStep(2)) {
                                n = this.getCurrentLevel();
                                nArrayArray = new int[][]{{this.tutorialMoves[n][2], this.tutorialMoves[n][3]}};
                                this.m_board.setTutorialHighlight(nArrayArray);
                                this.initSpriteAnimation(mSpecialCursorSpac, 5, 1, this.boardStartX + this.tutorialMoves[n][2] * this.cellSize + (this.cellSize >> 1), this.boardStartY + this.tutorialMoves[n][3] * this.cellSize + this.cellSize, 2);
                            }
                        }
                    } else if (this.getTutorialStep() == 5 && this.isTutorialMove(this.getCurrentLevel(), this.xPos, this.yPos)) {
                        this.stopSpriteAnimation(5);
                        this.setTutorialTextClear(true);
                        if (this.setTutorialStep(8)) {
                            n = this.getCurrentLevel();
                            nArrayArray = new int[][]{{this.tutorialMoves[n][2], this.tutorialMoves[n][3]}};
                            this.m_board.setTutorialHighlight(nArrayArray);
                            this.initSpriteAnimation(mSpecialCursorSpac, 5, 1, this.boardStartX + this.tutorialMoves[n][2] * this.cellSize + (this.cellSize >> 1), this.boardStartY + this.tutorialMoves[n][3] * this.cellSize + this.cellSize, 8);
                        }
                    }
                }
            }
            boolean bl7 = this.selected = !this.selected;
        }
        if (bl || bl2 || bl3 || bl4 || bl5) {
            this.resetHint();
            if (this.isTutorialEnabled() && this.getTutorialStep() == 0) {
                this.stopSpriteAnimation(0);
                this.setTutorialTextClear(true);
                if (this.setTutorialStep(1)) {
                    n = this.getCurrentLevel();
                    nArrayArray = new int[][]{{this.tutorialMoves[n][0], this.tutorialMoves[n][1]}};
                    this.m_board.setTutorialHighlight(nArrayArray);
                    this.initSpriteAnimation(mSpecialCursorSpac, 0, 1, this.boardStartX + this.tutorialMoves[n][0] * this.cellSize + (this.cellSize >> 1), this.boardStartY + this.tutorialMoves[n][1] * this.cellSize + this.cellSize, 1);
                }
            }
        }
    }

    public void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
    }

    public void renderBoard(Graphics graphics, boolean bl) {
        if (this.isTwoPlayerMode() && !this.isCharAnimFinished() && this.beginLevelAnimationStarted != 0) {
            bl = false;
        }
        this.movingCellsCount = 0;
        if (this.m_board != null) {
            int n = 0;
            short[] sArray = new short[2];
            for (int i = 0; i < this.m_board.getHeight(); ++i) {
                while (n < this.m_board.getWidth()) {
                    int n2 = this.m_board.getCellProperties(n, i);
                    boolean bl2 = false;
                    int n3 = this.m_board.getCellProperty(n2, 3, 24);
                    if (this.fullPlayer != 0 && n3 == 3) {
                        bl2 = true;
                    }
                    if (bl2 || this.fullRedraw || this.m_board.getCellProperty(n2, 11, 2048) == 1) {
                        int n4;
                        graphics = this.gBuffer;
                        this.m_board.setIndexedCellProperty(this.m_board.getCellIndex(n, i), 0, 11, 2048);
                        if (n3 == 3) {
                            this.renderInactiveCell(graphics, n, i);
                            this.refreshHud = true;
                        } else {
                            n4 = this.m_board.getCellIndex(n, i);
                            if (this.drawMarked && this.m_board.getIndexedCellProperty(n4, 20, 0x100000) == 1) {
                                n3 = 3;
                            }
                            if (this.drawAnimatedTile) {
                                if (this.tileAnimations[n4] != null) {
                                    this.tileAnimations[n4].renderSprite(graphics, this.boardStartX + n * this.cellSize, this.boardStartY + i * this.cellSize);
                                } else if (this.cellRemap[n3] != -1) {
                                    mCommonLevelSpac.renderFrame(graphics, this.cellRemap[n3], -1, this.boardStartX + n * this.cellSize, this.boardStartY + i * this.cellSize);
                                }
                            } else if (this.cellRemap[n3] != -1) {
                                mCommonLevelSpac.renderFrame(graphics, this.cellRemap[n3], -1, this.boardStartX + n * this.cellSize, this.boardStartY + i * this.cellSize);
                            }
                        }
                        if (bl) {
                            n4 = this.m_board.getCellProperty(n2, 0, 7);
                            int n5 = this.m_board.getCellProperty(n2, 5, 96);
                            if (n4 != 7) {
                                this.m_board.getCellOffsets(n, i, sArray);
                                int n6 = this.jewelsRemap[n4];
                                byte by = this.getJewelsType(n4);
                                if (by > 0) {
                                    n6 = 25 + this.jewelsRemap.length - 1 + (by - 1) * 25 + this.jewelsRemap[n4];
                                }
                                if (sArray[0] == 0 && sArray[1] == 0) {
                                    this.mJewelsSpac.renderFrame(graphics, n6, -1, this.boardStartX + n * this.cellSize + sArray[0] + 0, this.boardStartY + i * this.cellSize + sArray[1] + 0);
                                } else if (n5 == 0) {
                                    this.movingCells[this.movingCellsCount] = this.m_board.getCellIndex(n, i);
                                    ++this.movingCellsCount;
                                } else {
                                    this.mJewelsSpac.renderFrame(graphics, n6, -1, this.boardStartX + n * this.cellSize + 0, this.boardStartY + i * this.cellSize + 0);
                                }
                            }
                            if (n5 != 0) {
                                mCommonLevelSpac.renderFrame(graphics, this.hazardRemap[n5 - 1], -1, this.boardStartX + n * this.cellSize, this.boardStartY + i * this.cellSize);
                            }
                        }
                        if (n3 != 3) {
                            this.renderCellBorder(graphics, n, i);
                        }
                    }
                    ++n;
                }
                n = 0;
            }
        }
    }

    private final void renderMovingJewels(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        short[] sArray = new short[2];
        for (int i = 0; i < this.movingCellsCount; ++i) {
            int n5 = this.movingCells[i];
            int n6 = n5 / this.m_board.getWidth();
            int n7 = n5 - n6 * this.m_board.getWidth();
            int n8 = this.m_board.getCellProperties(n7, n6);
            int n9 = this.m_board.getCellProperty(n8, 0, 7);
            if (n9 == 7) continue;
            this.m_board.getCellOffsets(n7, n6, sArray);
            int n10 = this.jewelsRemap[n9];
            byte by = this.getJewelsType(n9);
            if (by > 0) {
                n10 = 25 + this.jewelsRemap.length - 1 + (by - 1) * 25 + this.jewelsRemap[n9];
            }
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
            if (this.m_board.getCellProperty(n8, 10, 1024) != 0) {
                graphics.setClip(0, this.boardStartY + n6 * this.cellSize, this.screenWidth, this.screenHeight);
            }
            this.mJewelsSpac.renderFrame(graphics, n10, -1, this.boardStartX + n7 * this.cellSize + sArray[0] + 0, this.boardStartY + n6 * this.cellSize + sArray[1] + 0);
            graphics.setClip(n, n2, n3, n4);
        }
    }

    private final void renderInactiveCell(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int[] nArray = new int[4];
        nArray = mSpecificLevelSpac.getFrameRect(5);
        graphics.setClip(this.boardStartX - nArray[3], this.boardStartY, this.m_board.getWidth() * this.cellSize + (nArray[3] << 1), this.m_board.getHeight() * this.cellSize + (nArray[3] << 1));
        int n7 = this.boardStartX + n * this.cellSize;
        int n8 = this.boardStartY + n2 * this.cellSize;
        byte by = this.backgroundRemap[this.getTileBits(n7, n8) & 0xF];
        if (by > 0) {
            mSpecificLevelSpac.renderFrame(graphics, by, -1, n7, n8);
        }
        graphics.setClip(n7, n8, this.cellSize, this.cellSize);
        this.renderBackgroundAndCharactersIfIntersects(graphics, n7, n8, this.cellSize, this.cellSize);
        graphics.setClip(this.boardStartX - nArray[3], this.boardStartY, this.m_board.getWidth() * this.cellSize + (nArray[3] << 1), this.m_board.getHeight() * this.cellSize + (nArray[3] << 1));
        this.renderInactiveCellBorder(graphics, n, n2, false);
        graphics.setClip(n3, n4, n5, n6);
    }

    private final void renderInactiveCellBorder(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = -1;
        if (!bl) {
            n3 = this.m_board.getCellIndex(n, n2);
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (bl) {
            n5 = n;
            n6 = n2;
            n -= this.boardStartX;
            n2 -= this.boardStartY;
        } else {
            n5 = this.boardStartX + n * this.cellSize;
            n6 = this.boardStartY + n2 * this.cellSize;
        }
        n4 = bl ? this.m_board.getCellIndex((n - this.cellSize) / this.cellSize, n2 / this.cellSize) : this.m_board.getLeftIndex(n3);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n4 != -1 && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 8) != 0) {
            mSpecificLevelSpac.renderFrame(graphics, 7, -1, n5, n6);
            bl2 = true;
        }
        if ((n4 = bl ? this.m_board.getCellIndex((n + this.cellSize) / this.cellSize, n2 / this.cellSize) : this.m_board.getRightIndex(n3)) != -1 && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 4) != 0) {
            mSpecificLevelSpac.renderFrame(graphics, 8, -1, n5 + this.cellSize, n6);
            bl4 = true;
        }
        if ((n4 = bl ? this.m_board.getCellIndex(n / this.cellSize, (n2 + this.cellSize) / this.cellSize) : this.m_board.getBottomIndex(n3)) != -1 && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 1) != 0) {
            mSpecificLevelSpac.renderFrame(graphics, 5, -1, n5, n6 + this.cellSize);
            bl5 = true;
        }
        if ((n4 = bl ? this.m_board.getCellIndex(n / this.cellSize, (n2 - this.cellSize) / this.cellSize) : this.m_board.getUpIndex(n3)) != -1 && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 2) != 0) {
            mSpecificLevelSpac.renderFrame(graphics, 6, -1, n5, n6);
            bl3 = true;
        }
        if (bl2 && bl3) {
            mSpecificLevelSpac.renderFrame(graphics, 9, -1, n5, n6);
        }
        if (bl3 && bl4) {
            mSpecificLevelSpac.renderFrame(graphics, 10, -1, n5 + this.cellSize, n6);
        }
        if (bl4 && bl5) {
            mSpecificLevelSpac.renderFrame(graphics, 12, -1, n5 + this.cellSize, n6 + this.cellSize);
        }
        if (bl5 && bl2) {
            mSpecificLevelSpac.renderFrame(graphics, 11, -1, n5, n6 + this.cellSize);
        }
        if (this.m_board.isCellActive(n4 = bl ? this.m_board.getCellIndex((n - this.cellSize) / this.cellSize, (n2 - this.cellSize) / this.cellSize) : this.m_board.getUpLeftIndex(n3)) && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 0xA) == 10) {
            mSpecificLevelSpac.renderFrame(graphics, 4, -1, n5, n6);
        }
        if (this.m_board.isCellActive(n4 = bl ? this.m_board.getCellIndex((n + this.cellSize) / this.cellSize, (n2 - this.cellSize) / this.cellSize) : this.m_board.getUpRightIndex(n3)) && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 6) == 6) {
            mSpecificLevelSpac.renderFrame(graphics, 3, -1, n5 + this.cellSize, n6);
        }
        if (this.m_board.isCellActive(n4 = bl ? this.m_board.getCellIndex((n + this.cellSize) / this.cellSize, (n2 + this.cellSize) / this.cellSize) : this.m_board.getDownRightIndex(n3)) && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 5) == 5) {
            mSpecificLevelSpac.renderFrame(graphics, 1, -1, n5 + this.cellSize, n6 + this.cellSize);
        }
        if (this.m_board.isCellActive(n4 = bl ? this.m_board.getCellIndex((n - this.cellSize) / this.cellSize, (n2 + this.cellSize) / this.cellSize) : this.m_board.getDownLeftIndex(n3)) && (this.m_board.getIndexedCellProperty(n4, 16, 983040) & 9) == 9) {
            mSpecificLevelSpac.renderFrame(graphics, 2, -1, n5, n6 + this.cellSize);
        }
    }

    public void addToTopClip(int n, int n2, int n3, int n4) {
        if (this.resetClip) {
            this.clipX1 = n;
            this.clipY1 = n2;
            this.clipX2 = n + n3;
            this.clipY2 = n2 + n4;
            this.resetClip = false;
        } else {
            if (n < this.clipX1) {
                this.clipX1 = n;
            }
            if (n + n3 > this.clipX2) {
                this.clipX2 = n + n3;
            }
            if (n2 < this.clipY1) {
                this.clipY1 = n2;
            }
            if (n2 + n4 > this.clipY2) {
                this.clipY2 = n2 + n4;
            }
        }
    }

    public void setTopClip(Graphics graphics) {
        if (!this.resetClip) {
            graphics.setClip(this.clipX1, this.clipY1, this.clipX2 - this.clipX1, this.clipY2 - this.clipY1);
            this.resetClip = true;
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(this.clipX1, this.clipY1, this.clipX2 - this.clipX1, this.clipY2 - this.clipY1);
        }
    }

    private final boolean intersectRects(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n <= n5 + n7 && n + n3 >= n5 && n6 + n8 >= n2 && n2 + n4 >= n6;
    }

    private final void setTilesDirty(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.intersectRects(n, n2, n3, n4, n5, n6, n7, n8)) {
            return;
        }
        int n9 = Math.max(n, n5);
        int n10 = Math.max(n2, n6);
        int n11 = Math.min(n + n3, n5 + n7);
        int n12 = Math.min(n2 + n4, n6 + n8);
        int n13 = this.getTileIndex(n9, n10);
        int n14 = this.getTileIndex(n11, n10) - n13 + 1;
        int n15 = this.getTileIndex(n9, n12);
        int n16 = n10;
        for (int i = n13; i <= n15; i += 12) {
            int n17 = n9;
            for (int j = i; j < i + n14; ++j) {
                this.setTileBits(j, 16, false);
                n17 += this.cellSize;
            }
            n16 += this.cellSize;
        }
    }

    private int[] getUpperRect() {
        int[] nArray = this.getMiddleRect();
        nArray[3] = nArray[1];
        nArray[1] = 0;
        nArray[0] = 0;
        return nArray;
    }

    private int[] getMiddleRect() {
        int[] nArray = new int[4];
        nArray[1] = this.hudRect[1] + this.hudRect[3];
        if (this.isTwoPlayerMode()) {
            nArray[1] = nArray[1] - (this.cellSize >> 1);
        }
        nArray[0] = 0;
        nArray[2] = this.screenWidth;
        nArray[3] = this.boardStartY - nArray[1] - this.borderHeight;
        return nArray;
    }

    public void setDirtyRect(int n, int n2, int n3, int n4) {
        if (n + n3 < this.boardStartX - this.borderHeight || n >= this.boardStartX + this.m_board.getWidth() * this.cellSize + this.borderHeight || n2 + n4 < this.boardStartY - this.borderHeight || n2 >= this.boardStartY + this.m_board.getHeight() * this.cellSize + this.borderHeight) {
            return;
        }
        int n5 = (n -= this.boardStartX) / this.cellSize;
        int n6 = (n + n3) / this.cellSize;
        int n7 = (n2 -= this.boardStartY) / this.cellSize;
        int n8 = (n2 + n4) / this.cellSize;
        n5 = n5 < 0 ? 0 : n5;
        n5 = n5 >= this.m_board.getWidth() ? this.m_board.getWidth() - 1 : n5;
        n6 = n6 >= this.m_board.getWidth() ? this.m_board.getWidth() - 1 : n6;
        n6 = n6 < 0 ? 0 : n6;
        n7 = n7 < 0 ? 0 : n7;
        n7 = n7 >= this.m_board.getHeight() ? this.m_board.getHeight() - 1 : n7;
        n8 = n8 >= this.m_board.getHeight() ? this.m_board.getHeight() - 1 : n8;
        n8 = n8 < 0 ? 0 : n8;
        for (int i = n7; i <= n8; ++i) {
            for (int j = n5; j <= n6; ++j) {
                this.m_board.setIndexedCellProperty(i * this.m_board.getWidth() + j, 1, 11, 2048);
            }
        }
    }

    public int setTileClip(Graphics graphics, int n, int n2, int n3) {
        int n4;
        block11: {
            boolean bl = false;
            n4 = 0;
            if (n3 == 0) break block11;
            int n5 = n3 / this.cellSize;
            int n6 = n3 % this.cellSize;
            if (n6 < 0) {
                --n5;
            }
            int n7 = n + n5;
            boolean bl2 = this.m_board.isCellActive(n7, n2);
            boolean bl3 = this.m_board.isCellActive(n7 + 1, n2);
            if (!bl2 && bl3) {
                graphics.setClip(this.boardStartX + (n7 + 1) * this.cellSize, this.boardStartY + n2 * this.cellSize, this.cellSize, this.cellSize);
                bl = true;
            } else if (bl2 && !bl3) {
                graphics.setClip(this.boardStartX + n7 * this.cellSize, this.boardStartY + n2 * this.cellSize, this.cellSize, this.cellSize);
                bl = true;
            } else if (bl2 || !bl3) {
                // empty if block
            }
            bl = true;
            if (bl) {
                if (n3 > 0) {
                    while (n7 + n4 < this.m_board.getWidth() && !this.m_board.isCellActive(n7 + n4, n2)) {
                        ++n4;
                    }
                } else {
                    while (n7 + n4 < this.m_board.getWidth() && !this.m_board.isCellActive(n7 + n4, n2)) {
                        --n4;
                    }
                }
            }
        }
        return n4;
    }

    private final void renderCellBorder(Graphics graphics, int n, int n2) {
        int n3 = this.m_board.getCellIndex(n, n2);
        int n4 = this.m_board.getIndexedCellProperty(n3, 16, 983040);
        int n5 = this.boardStartX + n * this.cellSize;
        int n6 = this.boardStartY + n2 * this.cellSize;
        int n7 = 0;
        if (n4 != 0) {
            if ((n4 & 1) != 0) {
                mSpecificLevelSpac.renderFrame(graphics, 5, -1, n5, n6);
                if (!this.m_board.isCellActive(this.m_board.getUpIndex(n3))) {
                    n7 = this.m_board.getUpLeftIndex(n3);
                    if (this.m_board.isCellActive(n7)) {
                        mSpecificLevelSpac.renderFrame(graphics, 11, -1, n5, n6);
                    }
                    if (this.m_board.isCellActive(n7 = this.m_board.getUpRightIndex(n3))) {
                        mSpecificLevelSpac.renderFrame(graphics, 12, -1, n5 + this.cellSize, n6);
                    }
                }
            }
            if ((n4 & 2) != 0) {
                mSpecificLevelSpac.renderFrame(graphics, 6, -1, n5, n6 + this.cellSize);
                if (!this.m_board.isCellActive(this.m_board.getBottomIndex(n3))) {
                    n7 = this.m_board.getDownLeftIndex(n3);
                    if (this.m_board.isCellActive(n7)) {
                        mSpecificLevelSpac.renderFrame(graphics, 9, -1, n5, n6 + this.cellSize);
                    }
                    if (this.m_board.isCellActive(n7 = this.m_board.getDownRightIndex(n3))) {
                        mSpecificLevelSpac.renderFrame(graphics, 10, -1, n5 + this.cellSize, n6 + this.cellSize);
                    }
                }
            }
            if ((n4 & 4) != 0) {
                mSpecificLevelSpac.renderFrame(graphics, 8, -1, n5, n6);
                if (!this.m_board.isCellActive(this.m_board.getLeftIndex(n3))) {
                    n7 = this.m_board.getDownLeftIndex(n3);
                    if (this.m_board.isCellActive(n7)) {
                        mSpecificLevelSpac.renderFrame(graphics, 12, -1, n5, n6 + this.cellSize);
                    }
                    if (this.m_board.isCellActive(n7 = this.m_board.getUpLeftIndex(n3))) {
                        mSpecificLevelSpac.renderFrame(graphics, 10, -1, n5, n6);
                    }
                }
            }
            if ((n4 & 8) != 0) {
                mSpecificLevelSpac.renderFrame(graphics, 7, -1, n5 + this.cellSize, n6);
                if (!this.m_board.isCellActive(this.m_board.getRightIndex(n3))) {
                    n7 = this.m_board.getDownRightIndex(n3);
                    if (this.m_board.isCellActive(n7)) {
                        mSpecificLevelSpac.renderFrame(graphics, 11, -1, n5 + this.cellSize, n6 + this.cellSize);
                    }
                    if (this.m_board.isCellActive(n7 = this.m_board.getUpRightIndex(n3))) {
                        mSpecificLevelSpac.renderFrame(graphics, 9, -1, n5 + this.cellSize, n6);
                    }
                }
            }
            if ((n4 & 5) == 5) {
                mSpecificLevelSpac.renderFrame(graphics, 1, -1, n5, n6);
            }
            if ((n4 & 9) == 9) {
                mSpecificLevelSpac.renderFrame(graphics, 2, -1, n5 + this.cellSize, n6);
            }
            if ((n4 & 6) == 6) {
                mSpecificLevelSpac.renderFrame(graphics, 3, -1, n5, n6 + this.cellSize);
            }
            if ((n4 & 0xA) == 10) {
                mSpecificLevelSpac.renderFrame(graphics, 4, -1, n5 + this.cellSize, n6 + this.cellSize);
            }
        }
    }

    public void renderCharacters(Graphics graphics) {
        JQ2009Game.setClip(graphics, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight(), this.boardStartX - mSpecificLevelSpac.getFrameRect(7)[2], 0, this.m_board.getWidth() * this.cellSize + mSpecificLevelSpac.getFrameRect(7)[2] * 2, this.screenHeight);
        mRupertSpacAnimation.renderSprite(graphics, this.getCharX(0), this.getCharY(0));
        mBossSpacAnimation.renderSprite(graphics, this.getCharX(1), this.getCharY(1));
    }

    private final void getPlayerCPUFrame(int n, int n2) {
        if (BossState == 4) {
            return;
        }
        if (n2 == 3 || n2 == 4) {
            if (n == 1) {
                int n3 = this.getRupertFrame() == 1 ? 3 : 6;
                if (playerAddJewels >= n3) {
                    this.fullPlayer = (byte)-1;
                    mRupertSpacAnimation.setSequence(3, 0, 0, true);
                    RupertState = 1;
                    mBossSpacAnimation.setSequence(5 + this.getCurrentBossFrame() * 7, 0, 0, true);
                    BossState = 3;
                    playerAddJewels = -6;
                }
            } else {
                int n4 = this.getRupertFrame() == -1 ? 3 : 6;
                if (cpuAddJewels >= n4) {
                    this.fullPlayer = (byte)-1;
                    mRupertSpacAnimation.setSequence(5, 0, 0, true);
                    RupertState = 3;
                    mBossSpacAnimation.setSequence(3 + this.getCurrentBossFrame() * 7, 0, 0, true);
                    BossState = 1;
                    cpuAddJewels = -6;
                }
            }
        }
    }

    private final int getRupertFrame() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if ((this.endConditionsCodes & 0x4007) == 1) {
            if (this.IsJewelsTwoTypes()) {
                n = this.playerJewels + this.playerJewels2;
                n2 = this.cpuJewels + this.cpuJewels2;
                n3 = this.getJewelsToWinCount(0) + this.getJewelsToWinCount(1);
            } else {
                n = this.playerJewels;
                n2 = this.cpuJewels;
                n3 = this.getJewelsToWinCount(0);
            }
        } else {
            n3 = 100;
            int[] nArray = new int[]{0, 1, 2};
            int[] nArray2 = new int[nArray.length];
            this.m_board.boardHealth(nArray, nArray2, null);
            int n4 = nArray2[0];
            int n5 = nArray2[1];
            int n6 = nArray2[2];
            n = n4 * 100 / (n4 + n5 + n6);
            n2 = n6 * 100 / (n4 + n5 + n6);
        }
        if (n * 100 / n3 > n2 * 100 / n3 + 30) {
            return 1;
        }
        if (n2 * 100 / n3 > n * 100 / n3 + 30) {
            return -1;
        }
        return 0;
    }

    private final void addEffects(int n, int n2, int n3) {
        for (int i = 0; i < 10; ++i) {
            if (!this.mEffectAnimation[i].isAnimationComplete()) continue;
            if (this.EffectAnimationXY[i * 3] != 0) break;
            this.mEffectAnimation[i].setSequence(n, 0, 0, true);
            this.EffectAnimationXY[i * 3] = 1;
            this.EffectAnimationXY[i * 3 + 1] = n2;
            this.EffectAnimationXY[i * 3 + 2] = n3;
            break;
        }
    }

    private final void Effects(Graphics graphics) {
        for (int i = 0; i < 10; ++i) {
            if (this.EffectAnimationXY[i * 3] == 0 || this.mEffectAnimation[i].isAnimationComplete()) continue;
            this.mEffectAnimation[i].renderSprite(graphics, this.EffectAnimationXY[i * 3 + 1], this.EffectAnimationXY[i * 3 + 2]);
        }
    }

    private final void addJewelCoinsEffects(int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < 8; ++n4) {
            if (this.JewelsAnimationXY[n4 * 3] == 0 || this.JewelsAnimationXY[n4 * 3] == 2 || this.JewelsAnimationXY[n4 * 3 + 1] != n || this.JewelsAnimationXY[n4 * 3 + 2] != n2) continue;
            return;
        }
        n4 = this.m_board.getCellProperties(n, n2);
        int n5 = this.m_board.getCellProperty(n4, 0, 7);
        if (n5 != 7 && (n3 = this.m_board.getCellProperty(n4, 5, 96)) == 0) {
            byte by = this.getJewelsType(n5);
            if (by > 0) {
                n5 = n5 + this.jewelsRemap.length + (by - 1) * (this.jewelsRemap.length - 1);
            }
            for (int i = 0; i < 8; ++i) {
                if (!this.JewelsAnimation[i].isAnimationComplete()) continue;
                if (this.JewelsAnimationXY[i * 3] == 0) {
                    this.JewelsAnimation[i].setSequence(n5, 0, 0, true);
                    this.JewelsAnimationXY[i * 3] = 1;
                    this.JewelsAnimationXY[i * 3 + 1] = (byte)n;
                    this.JewelsAnimationXY[i * 3 + 2] = (byte)n2;
                    break;
                }
                if (this.JewelsAnimationXY[i * 3] != 2) break;
                this.JewelsAnimation[i].setSequence(16, 0, 0, true);
                this.JewelsAnimationXY[i * 3] = 3;
                this.JewelsAnimationXY[i * 3 + 1] = (byte)n;
                this.JewelsAnimationXY[i * 3 + 2] = (byte)n2;
                break;
            }
        }
    }

    private final void JewelCoinsEffects(Graphics graphics) {
        if (this.getSubstate() == 0) {
            if (iClock % 60 > 52 && Math.abs(this.getRandom().nextInt()) % 100 < 60) {
                this.addJewelCoinsEffects(Math.abs(this.getRandom().nextInt()) % 8, Math.abs(this.getRandom().nextInt()) % 8);
            }
            short[] sArray = new short[2];
            for (int i = 0; i < 8; ++i) {
                if (this.JewelsAnimationXY[i * 3] == 0 || this.JewelsAnimation[i].isAnimationComplete()) continue;
                this.m_board.getCellOffsets(this.JewelsAnimationXY[i * 3 + 1], this.JewelsAnimationXY[i * 3 + 2], sArray);
                if (sArray[0] == 0 && sArray[1] == 0) {
                    this.JewelsAnimation[i].renderSprite(graphics, this.boardStartX + this.JewelsAnimationXY[i * 3 + 1] * this.cellSize + sArray[0], this.boardStartY + this.JewelsAnimationXY[i * 3 + 2] * this.cellSize + sArray[1]);
                    continue;
                }
                this.movingCells[this.movingCellsCount] = this.m_board.getCellIndex(this.JewelsAnimationXY[i * 3 + 1], this.JewelsAnimationXY[i * 3 + 2]);
                ++this.movingCellsCount;
            }
        }
    }

    private final void renderSelectedJewel(Graphics graphics) {
        if (this.m_board.getSwappingCells()[0] == -1 && this.selected) {
            this.selected = false;
        }
        if (this.m_board.getSwappingCells()[0] != -1 && !this.m_board.isSwapInProgress()) {
            if (this.selected) {
                this.renderSelectedJewel(graphics, this.xPos, this.yPos);
            }
        } else if (this.getJQ2009GameState() == 14 && this.currentPowerup != -1 && this.powerups[this.currentPowerup] == 2 && PowerupCells1 > -1) {
            this.renderSelectedJewel(graphics, PowerupCells1 % this.m_board.getWidth(), PowerupCells1 / this.m_board.getHeight());
        }
    }

    private final void renderSelectedJewel(Graphics graphics, int n, int n2) {
        int n3 = this.m_board.getCellProperties(n, n2);
        int n4 = this.m_board.getCellProperty(n3, 0, 7);
        short[] sArray = new short[2];
        this.m_board.getCellOffsets(n, n2, sArray);
        if (n4 < 0 || n4 >= this.jewelsRemap.length) {
            return;
        }
        byte by = this.getJewelsType(n4);
        int n5 = this.jewelsRemap[n4] + this.jewelsRemap.length;
        if (by > 0) {
            n5 = 35 + (by - 1) * 25 + this.jewelsRemap[n4];
        }
        if (sArray[0] == 0 && sArray[1] == 0) {
            this.mJewelsSpac.renderFrame(graphics, n5, -1, this.boardStartX + n * this.cellSize + sArray[0], this.boardStartY + n2 * this.cellSize + sArray[1]);
        }
    }

    public void renderCursor(Graphics graphics) {
        boolean bl = false;
        if (this.m_board.getSwappingCells()[0] != -1) {
            short[] sArray = new short[2];
            this.m_board.getCellOffsets(this.xPos, this.yPos, sArray);
            if (this.getJQ2009GameState() == 14 && this.powerUpState == 1) {
                this.hammerAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            } else {
                this.cursorAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            }
            if (this.flameAnimation != null && !this.flameAnimation.isAnimationComplete()) {
                this.flameAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            }
        } else {
            if (this.getJQ2009GameState() == 14 && this.powerUpState == 1) {
                this.hammerAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            } else {
                this.cursorAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            }
            if (this.flameAnimation != null && !this.flameAnimation.isAnimationComplete()) {
                this.flameAnimation.renderSprite(graphics, this.boardStartX + this.xPos * this.cellSize, this.boardStartY + this.yPos * this.cellSize);
            }
        }
    }

    public void renderTutorial(Graphics graphics) {
        if (this.tutorialStep == -1) {
            return;
        }
        switch (this.tutorialStep) {
            case 7: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case -1: {
                return;
            }
            default: {
                return;
            }
        }
        if (!this.tutorialTextClear) {
            Font font = this.getSharedFont();
            char[] cArray = this.getText(this.tutorialHintTextID);
            int n = font.charsWidth(cArray, 0, cArray.length, true);
            int n2 = mSpecialCursorSpac.getFrameRect(27)[2];
            int n3 = mSpecialCursorSpac.getFrameRect(28)[2];
            int n4 = mSpecialCursorSpac.getFrameRect(29)[2];
            int n5 = mSpecialCursorSpac.getFrameRect(27)[3];
            int n6 = this.tutorialHintBoxWidth / 2;
            mSpecialCursorSpac.renderFrame(graphics, 27, -1, this.tutorialTextPositionX - n6, this.tutorialTextPositionY);
            int n7 = 0;
            while (n2 + n7 * n3 + n4 < this.tutorialHintBoxWidth) {
                mSpecialCursorSpac.renderFrame(graphics, 28, -1, this.tutorialTextPositionX - n6 + n2 + n7 * n3, this.tutorialTextPositionY);
                ++n7;
            }
            mSpecialCursorSpac.renderFrame(graphics, 29, -1, this.tutorialTextPositionX - n6 + this.tutorialHintBoxWidth, this.tutorialTextPositionY);
            font.drawChars(graphics, cArray, 0, cArray.length, this.tutorialTextPositionX - n6 + (this.tutorialHintBoxWidth - n >> 1), this.tutorialTextPositionY + (n5 - font.getHeight() >> 1), 20, true);
        }
    }

    private final void setCursorDirtyRect() {
        int[] nArray = null;
        if (this.m_board.getSwappingCells()[0] != -1) {
            SpacSprite spacSprite = this.cursorAnimation;
            if (this.getJQ2009GameState() == 14 && this.powerUpState == 1) {
                spacSprite = this.hammerAnimation;
            }
            nArray = mCommonLevelSpac.getFrameRect(spacSprite.getFrameIndex());
            nArray[0] = nArray[0] + (this.boardStartX + this.xPos * this.cellSize);
            nArray[1] = nArray[1] + (this.boardStartY + this.yPos * this.cellSize);
        } else {
            SpacSprite spacSprite = this.cursorAnimation;
            if (this.getJQ2009GameState() == 14 && this.powerUpState == 1) {
                spacSprite = this.hammerAnimation;
            }
            nArray = mCommonLevelSpac.getFrameRect(spacSprite.getFrameIndex());
            nArray[0] = nArray[0] + (this.boardStartX + this.xPos * this.cellSize);
            nArray[1] = nArray[1] + (this.boardStartY + this.yPos * this.cellSize);
        }
    }

    public void initRound() {
        int n;
        MainMenu.meunSound = true;
        this.bossPower = (byte)-1;
        this.setMatchMultiSix(false);
        this.setMatchMultiSeven(false);
        int n2 = this.getCurrentLevel();
        if (n2 > 30) {
            JQ2009Game.setCPUStoryCoins(n2 * 2 / 3);
        } else {
            JQ2009Game.setCPUStoryCoins(n2 / 2);
        }
        isPreRenderMP = true;
        BossPowerup = true;
        gamePauseTime = -1L;
        MultiPlayer1move = true;
        MultiPlayer2move = true;
        if (MultiPlayermode != 0) {
            MultiPlayermode = MultiPlayerChallenge == 1 ? (byte)(Math.abs(this.getRandom().nextInt()) % 3 + 1) : MultiPlayerModeTyte[MultiPlayerChallenge2];
            gameStartTime = -1L;
            MultiPlayerReadyGo = false;
            MultiPlayerTimeReady = false;
            MultiPlayer1Ready = false;
            MultiPlayer2Ready = false;
            MultiPlayerEnd2 = false;
            this.loadDataToData2(n2);
            if (MultiPlayermode == 1) {
                this.m_board.setWinnerTile(0, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                if (this.getCurrentLevel() <= 0) {
                    while (this.m_board.getWinnerTile(0) == 2) {
                        this.m_board.setWinnerTile(0, Math.abs(this.getRandom().nextInt()) % (this.jewelsRemap.length - 1));
                    }
                }
                this.m_board.setWinnerTile(2, this.m_board.getWinnerTile(0));
            } else if (MultiPlayermode == 2) {
                this.m_board.setWinnerTile(0, this.jewelsRemap.length - 1);
            }
            switch (MultiPlayermode) {
                case 1: 
                case 2: {
                    if (MultiPlayermode == 1) {
                        JQ2009Game.levelData[n2 * 8 + 3] = 0;
                        JQ2009Game.levelData[n2 * 8 + 5] = 99;
                    } else {
                        JQ2009Game.levelData[n2 * 8 + 3] = 0;
                        JQ2009Game.levelData[n2 * 8 + 5] = 3;
                    }
                    JQ2009Game.levelData[n2 * 8 + 1] = 2;
                    JQ2009Game.levelData[n2 * 8 + 6] = 0;
                    this.winjewels2[n2] = 0;
                    break;
                }
                case 3: {
                    JQ2009Game.levelData[n2 * 8 + 3] = 0;
                    JQ2009Game.levelData[n2 * 8 + 1] = 7;
                    JQ2009Game.levelData[n2 * 8 + 2] = 5;
                    JQ2009Game.levelData[n2 * 8 + 5] = 0;
                    JQ2009Game.levelData[n2 * 8 + 6] = 0;
                    this.winjewels2[n2] = 0;
                }
            }
        } else {
            this.loadData2ToData();
        }
        for (n = 0; n < this.m_board.getWidth() * this.m_board.getHeight(); ++n) {
            this.m_board.clearTileOffset(n);
        }
        this.m_board.resetSomeFlags();
        this.drawMarked = true;
        this.drawAnimatedTile = true;
        this.resetLevelStats();
        this.setBossMovesCount(0);
        this.setBossPowerupsCount(0);
        this.setBossPowerup(-1);
        this.levelAwardPoints = 0;
        this.match4Count = 0;
        this.match5Count = 0;
        this.matchStreak = 0;
        this.levelObjectiveShown = false;
        this.tutorialRenderDialog = false;
        if (this.gameMode == 2) {
            this.setCoins(this.getStoryCoins());
        } else {
            this.setCoins(0);
        }
        this.coinsUsedInLevel = false;
        this.refreshHud = true;
        this.refreshMiddleRect = true;
        this.timeWarningIssued = false;
        this.affectedByPowerup = false;
        affectedByPowerup2 = false;
        this.playerJewels = 0;
        this.cpuJewels = 0;
        this.playerJewels2 = 0;
        this.cpuJewels2 = 0;
        this.Round = 0;
        for (n = 0; n < 4; ++n) {
            this.powerups[n] = n <= this.getPowerupsLevel(n2) ? 0 + n : -1;
        }
        this.resetDistributions();
        if (this.getCurrentLevel() <= 0 && MultiPlayermode == 0) {
            this.distributions[2] = 0;
        }
        this.distributions[this.jewelsRemap.length - 1] = levelData[n2 * 8 + 3];
        this.m_board.loadBoard(this.boardData, levelData[n2 * 8 + 0], this.distributions, this.jewelsRemap.length);
        if (n2 == 0 || n2 == 1) {
            this.setTutorialMode(true);
            this.tutorialCurrentStep = n2;
        }
        this.p1Score = 0;
        this.p2Score = 0;
        wonAnimationTimes = (byte)3;
        this.creditForMatches = true;
        this.fullRedraw = true;
        n = 0;
        n = this.getLevelAI(n2);
        this.twoPlayerMode = n != 0;
        this.player1Human = true;
        this.player2Human = MultiPlayermode > 0;
        this.player = 0;
        if (this.twoPlayerMode) {
            if (levelData[this.getCurrentLevel() * 8 + 6] > 0) {
                this.player = 1;
                this.setBossMovesCount(this.getBossMovesCount() + 1);
            } else {
                this.player = 0;
            }
            this.setCharPos(0, -18, 9, true, 0, 0, false);
            this.setCharPos(0, 0, 9, false, 0, 500, false);
            this.setCharPos(1, 36 + this.screenWidth, 9, true, 0, 0, false);
            this.setCharPos(1, 18 + this.screenWidth, 9, false, 0, 500, false);
            TimerHandler.resetTimer(7);
            TimerHandler.resetTimer(8);
            this.m_board.setAI(n - 1);
        }
        this.endConditionsCodes &= 0xFFFFDFFF;
        this.endConditionsCodes |= 8;
        if (this.twoPlayerMode) {
            this.endConditionsCodes &= 0xFFFFBFF8;
            this.endConditionsCodes |= this.aiParams[n - 1][4];
        }
        if (!(this.isTutorialHardcodedLevel(this.getCurrentLevel()) || MultiPlayermode == 0 && this.getCurrentLevel() == 11)) {
            this.m_board.generateLevelBoard();
        }
        if (MultiPlayermode == 2) {
            JQ2009Game.levelData[n2 * 8 + 3] = 40;
            this.distributions[this.jewelsRemap.length - 1] = levelData[n2 * 8 + 3];
            this.m_board.setTileFrequency(this.distributions, this.jewelsRemap.length);
            this.m_board.setIndexedCellProperty(35, this.jewelsRemap.length - 1, 0, 7);
        }
        this.m_board.markCellsAsVirgin();
        this.m_board.anyMovesLeft(this.moves);
        this.waitForNextMove = false;
        this.m_board.m_swapInProgress = false;
        int n3 = this.m_board.getCellIndex(this.m_board.getWidth() >> 1, this.m_board.getHeight() >> 1);
        n3 = this.m_board.getActiveCell(n3, 0, true);
        this.xPos = n3 % this.m_board.getWidth();
        this.yPos = n3 / this.m_board.getWidth();
        TimerHandler.resetTimer(0);
        TimerHandler.resetTimer(1);
        TimerHandler.resetTimer(2);
        TimerHandler.resetTimer(6);
        TimerHandler.resetTimer(3);
        this.setGameScore(0);
        this.setMatchScore(0);
        this.selected = false;
        this.m_board.deselectCells();
        this.startBeginLevelAnimation();
        this.resetAnimations();
        this.m_board.resetTutorialHighlight();
        this.tileAnimations = new SpacSprite[this.m_board.getWidth() * this.m_board.getHeight()];
        this.cursorAnimation = new SpacSprite(mCommonLevelSpac, 5, true);
        this.cursorAnimation.setPlaybackMode(1);
        this.hammerAnimation = new SpacSprite(mCommonLevelSpac, 8, true);
        this.hammerAnimation.setPlaybackMode(1);
        this.m_board.resetTileSpeeds();
        this.calculateSpecialMenuItemWidth();
        if (this.isTwoPlayerMode()) {
            this.hudRect = mHudSpac.getFrameRect(0);
            this.hudRect[0] = (this.screenWidth >> 1) + this.hudRect[0];
            this.hudRect[1] = (this.boardStartY - this.borderHeight >> 1) + this.hudRect[1] + (this.cellSize >> 1);
            this.hudCenterRect = mHudSpac.getFrameRect(3);
            this.hudCenterRect[0] = (this.screenWidth >> 1) + this.hudCenterRect[0];
            this.hudCenterRect[1] = (this.boardStartY - this.borderHeight >> 1) + this.hudCenterRect[1] + (this.cellSize >> 1);
        } else {
            this.hudRect = mHudSpac.getFrameRect(1);
            this.hudRect[0] = (this.screenWidth >> 1) + this.hudRect[0];
            this.hudRect[1] = (this.boardStartY - this.borderHeight >> 1) + this.hudRect[1];
            this.hudCenterRect = mHudSpac.getFrameRect(2);
            this.hudCenterRect[0] = (this.screenWidth >> 1) + this.hudCenterRect[0];
            this.hudCenterRect[1] = (this.boardStartY - this.borderHeight >> 1) + this.hudCenterRect[1];
        }
        if (MultiPlayermode != 0 && this.getCurrentLevel() == 11) {
            this.m_board.setIndexedCellProperty(44, 0, 5, 96);
        }
        if (this.getGameMode() != 2) {
            if (n2 > 23) {
                this.setCoins(5);
            } else {
                this.setCoins(3);
            }
        }
    }

    public void resetLevelStats() {
        this.crntLevelJewelsMatched = 0;
        this.crntLevelCoinsUsed = 0;
        this.crntLevelMaxStreak = 0;
        this.crntLevelMatch4 = 0;
        this.crntLevelMatch5 = 0;
    }

    public void applyStats() {
        this.totalJewelsMatched += this.crntLevelJewelsMatched;
        this.totalCoinsUsed += this.crntLevelCoinsUsed;
        this.totalMatch4 += this.crntLevelMatch4;
        this.totalMatch5 += this.crntLevelMatch5;
        if (this.crntLevelMaxStreak > this.totalMaxStreak) {
            this.totalMaxStreak = this.crntLevelMaxStreak;
        }
    }

    private void setTileBits(int n, int n2, boolean bl) {
        if (n != -1) {
            if (bl) {
                int n3 = n;
                this.backgroundTiles[n3] = this.backgroundTiles[n3] & n2;
            } else {
                int n4 = n;
                this.backgroundTiles[n4] = this.backgroundTiles[n4] | n2;
            }
        }
    }

    private void setTileBits(int n, int n2, int n3, boolean bl) {
        int n4 = this.getTileIndex(n, n2);
        this.setTileBits(n4, n3, bl);
    }

    private int getTileIndex(int n, int n2) {
        int n3 = 0;
        int n4 = this.boardStartX - 2 * this.cellSize;
        int n5 = this.boardStartY - 3 * this.cellSize;
        n3 = (n - n4) / this.cellSize + (n2 - n5) / this.cellSize * 12;
        if (n3 < 0 || n3 >= this.backgroundTiles.length) {
            return -1;
        }
        return n3;
    }

    private int getTileBits(int n, int n2) {
        int n3 = this.getTileIndex(n, n2);
        return n3 != -1 ? this.backgroundTiles[n3] : -1;
    }

    static void setClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (Math.abs((n - n5 << 1) + n3 - n7) < n3 + n7 && Math.abs((n2 - n6 << 1) + n4 - n8) < n4 + n8) {
            int[] nArray = new int[]{0, 0, 0, 0};
            if (n < n5) {
                nArray[0] = n5;
                nArray[2] = n + n3 < n5 + n7 ? n3 - (n5 - n) : n7;
            } else {
                nArray[0] = n;
                nArray[2] = n + n3 < n5 + n7 ? n3 : n7 - (n - n5);
            }
            if (n2 < n6) {
                nArray[1] = n6;
                nArray[3] = n2 + n4 < n6 + n8 ? n4 - (n6 - n2) : n8;
            } else {
                nArray[1] = n2;
                nArray[3] = n2 + n4 < n6 + n8 ? n4 : n8 - (n2 - n6);
            }
            graphics.setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
        } else {
            graphics.setClip(0, 0, 0, 0);
        }
    }

    private final void renderBackgroundAndCharactersIfIntersects(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = null;
        nArray = mSpecificLevelSpac.getFrameRect(0);
        if (this.intersectRects(n, n2, n3, n4, 0, this.boardStartY + this.cellSize - nArray[3], nArray[2], nArray[3])) {
            this.renderBgImage(graphics);
        }
        if (this.isTwoPlayerMode()) {
            JQ2009Game.setClip(graphics, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight(), this.boardStartX - mSpecificLevelSpac.getFrameRect(7)[2], 0, this.m_board.getWidth() * this.cellSize + mSpecificLevelSpac.getFrameRect(7)[2] * 2, this.screenHeight);
            nArray = mBossSpac.getFrameRect(0 + this.getCurrentBossFrame());
            int n5 = this.getCharX(1) + nArray[0];
            int n6 = this.getCharY(1) + nArray[1];
            if (this.intersectRects(n, n2, n3, n4, n5, n6, nArray[2], nArray[3])) {
                mBossSpacAnimation.renderSprite(graphics, this.getCharX(1), this.getCharY(1));
            }
            nArray = mRupertSpac.getFrameRect(0);
            n5 = this.getCharX(0) + nArray[0];
            if (this.intersectRects(n, n2, n3, n4, n5, n6 = this.getCharY(0) + nArray[1], nArray[2], nArray[3])) {
                mRupertSpacAnimation.renderSprite(graphics, this.getCharX(0), this.getCharY(0));
            }
        }
    }

    private final void renderTile(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        int n3 = this.getTileBits(n, n2);
        if (n3 != -1 && (bl || (n3 & 0x10) != 0)) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = n;
            int n9 = n2;
            int n10 = this.cellSize;
            int n11 = this.cellSize;
            n8 = Math.max(n, n4);
            n9 = Math.max(n2, n5);
            n11 = Math.min(n + this.cellSize, n4 + n6) - n8;
            n10 = Math.min(n2 + this.cellSize, n5 + n7) - n9;
            this.setTileBits(n, n2, -17, true);
            graphics.setClip(n8, n9, n11, n10);
            mSpecificLevelSpac.renderFrame(graphics, this.backgroundRemap[n3 & 0xF], -1, n, n2);
            this.renderBackgroundAndCharactersIfIntersects(graphics, n8, n9, n11, n10);
            this.renderInactiveCellBorder(graphics, n, n2, true);
            graphics.setClip(n4, n5, n6, n7);
        } else if (bl2 && this.backgroundRemap[0] > 0) {
            mSpecificLevelSpac.renderFrame(graphics, this.backgroundRemap[0], -1, n, n2);
        }
    }

    private final void renderTiles(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        graphics.setClip(n, n2, n3, n4);
        int n9 = n + n3;
        int n10 = n2 + n4;
        int n11 = n - (n - (this.boardStartX - 2 * this.cellSize)) % this.cellSize;
        if (!bl2) {
            n2 -= (n2 - this.boardStartY + 3 * this.cellSize) % this.cellSize;
        }
        while (n2 < n10) {
            for (n = n11; n < n9; n += this.cellSize) {
                this.renderTile(graphics, n, n2, bl, bl2);
            }
            n2 += this.cellSize;
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    private final void renderBgImage(Graphics graphics) {
        int[] nArray = mSpecificLevelSpac.getFrameRect(0);
        mSpecificLevelSpac.renderFrame(graphics, 0, -1, (this.screenWidth - nArray[2]) / 2, 0);
    }

    public final void renderBackground(Graphics graphics) {
        graphics = this.gBuffer;
        int n = this.boardStartY;
        int n2 = 3 * this.cellSize;
        int n3 = (this.m_board.getHeight() - 3) * this.cellSize;
        int n4 = this.m_board.getWidth() * this.cellSize;
        if (this.fullPlayer != 0 || this.fullRedraw) {
            if (this.fullRedraw) {
                graphics.setColor(DefaultConstants.BG_COLOR[this.getChapter(this.getCurrentLevel())]);
                graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
            }
            this.refreshMiddleRect = false;
            int[] nArray = this.getMiddleRect();
            this.renderBgPart(graphics, nArray);
            int[] nArray2 = mSpecificLevelSpac.getFrameRect(0);
            if (this.boardStartY > nArray2[3]) {
                this.renderTiles(graphics, 0, nArray2[3], this.screenWidth, this.boardStartY - nArray2[3], this.twoPlayerMode || this.fullRedraw, false);
            } else {
                this.renderTiles(graphics, 0, this.boardStartY - this.borderHeight, this.screenWidth, this.borderHeight, this.twoPlayerMode || this.fullRedraw, false);
            }
            this.renderTiles(graphics, 0, n, this.boardStartX, n2, this.twoPlayerMode || this.fullRedraw, false);
            this.renderTiles(graphics, this.boardStartX + n4, n, this.screenWidth - (this.boardStartX + n4), n2, this.twoPlayerMode || this.fullRedraw, false);
            this.renderTiles(graphics, 0, n + n2, this.boardStartX, n3, this.fullRedraw, false);
            this.renderTiles(graphics, this.boardStartX + n4, n + n2, this.screenWidth - (this.boardStartX + n4), n3, this.fullRedraw, false);
            this.renderTiles(graphics, 0, n + n2 + n3, this.screenWidth, this.screenHeight - (n + n2 + n3 + this.getSoftKeyBarSize()), this.fullRedraw, false);
            if (nArray2[2] < this.screenWidth - 2) {
                this.renderTiles(graphics, 0, 0, this.screenWidth - nArray2[2] >> 1, nArray2[3], this.fullRedraw, true);
                this.renderTiles(graphics, this.screenWidth - (this.screenWidth - nArray2[2] >> 1), 0, this.screenWidth - nArray2[2] >> 1, nArray2[3], this.fullRedraw, true);
            }
        }
    }

    public void renderBackbuffer(Graphics graphics) {
        graphics.drawImage(this.backBuffer, 0, 0, 0);
    }

    public int getStoryCurrentLevel() {
        return this.currentLevel;
    }

    public void setStoryCurrentLevel(int n) {
        this.currentLevel = n;
    }

    public int getQuickModeMaxLevel() {
        return this.quickModeMaxLevel;
    }

    public void setQuickModeMaxLevel(int n) {
        this.quickModeMaxLevel = n;
    }

    public int getCurrentLevel() {
        if (this.getGameMode() == 2) {
            return this.currentLevel;
        }
        return this.quickCurrentLevel;
    }

    public void setCurrentLevel(int n) {
        if (this.getGameMode() == 2) {
            this.currentLevel = n;
        } else {
            this.quickCurrentLevel = n;
        }
    }

    public final boolean isTwoPlayerMode() {
        return this.twoPlayerMode;
    }

    private void setCurrentLevelToFirstFromChapter() {
        int n = this.getCurrentLevel();
        n = this.getFirstLevelFromChapter(this.getChapter(n));
        this.setCurrentLevel(n);
    }

    public int getFirstLevelFromChapter(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.chapterData[i];
        }
        return n2;
    }

    protected abstract void postNewHighScore(char[] var1, int var2);

    protected abstract int[] getHighScores();

    public abstract int renderTextLines(Graphics var1, char[][] var2, int var3, int var4, Font var5, int var6, int var7, int var8, int var9, boolean var10);

    protected abstract void renderSoftKeys(Graphics var1, char[] var2, char[] var3);

    protected abstract Font getBaseFont();

    protected abstract Font getDigitFont();

    protected abstract Font getSoftkeyFont();

    protected abstract char[] getUserName();

    public void setStoryCoins(int n) {
        if (n > 99) {
            n = 99;
        }
        storyCoins = n;
    }

    public int getStoryCoins() {
        return storyCoins;
    }

    public int getCoins() {
        return levelCoins;
    }

    public static void setCPUStoryCoins(int n) {
        if (n > 99) {
            n = 99;
        }
        levelCPUCoins = n;
    }

    public static int getCPUCoins() {
        return levelCPUCoins;
    }

    public void setCoins(int n) {
        if (n > 99) {
            n = 99;
        }
        if (levelCoins > n) {
            this.crntLevelCoinsUsed += levelCoins - n;
            this.coinsUsedInLevel = true;
        }
        if (!this.twoPlayerMode) {
            this.refreshHud = true;
        }
        levelCoins = n;
    }

    public final int getTileSize() {
        return this.cellSize;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int n) {
        this.score = n;
    }

    public int getMatchScore() {
        return this.matchScore;
    }

    public void setMatchScore(int n) {
        this.matchScore = n;
    }

    public int getGameScore() {
        return this.gameScore;
    }

    public void setGameScore(int n) {
        if (!this.twoPlayerMode) {
            this.refreshHud = true;
        }
        this.gameScore = n;
    }

    public int getSoftKeyBarSize() {
        if (mSkbarSpac != null) {
            return mSkbarSpac.getFrameRect(2)[3];
        }
        return this.getBaseFont().getHeight();
    }

    public void setRefreshHud() {
        this.refreshHud = true;
    }

    public final void initFloatingText(int n, int n2, int n3) {
        int n4 = n % this.m_board.getWidth();
        int n5 = n / this.m_board.getWidth();
        n4 = this.boardStartX + n4 * this.cellSize + (this.cellSize >> 1);
        n5 = this.boardStartY + n5 * this.cellSize + (this.cellSize >> 1);
        this.initAnimation(1, n4, n5 + n3, new Integer(n2));
    }

    public final void initParticlesOnCell(int n, int n2) {
        int n3 = n % this.m_board.getWidth();
        int n4 = n / this.m_board.getWidth();
        n3 = this.boardStartX + n3 * this.cellSize + (this.cellSize >> 1);
        n4 = this.boardStartY + n4 * this.cellSize + (this.cellSize >> 1);
        int[] nArray = new int[]{15, n2};
        this.initAnimation(0, n3, n4, nArray);
        this.addEffects(n2, n3, n4);
    }

    public final void initParticlesAt(int n, int n2, int n3) {
        int[] nArray = new int[]{15, n3};
        this.initAnimation(0, n, n2, nArray);
        this.addEffects(n3, n, n2);
    }

    public final void initTimerParticles() {
        this.initParticlesAt(this.screenWidth >> 1, this.boardStartY - this.borderHeight >> 1, 0);
        this.initParticlesAt((this.screenWidth >> 1) - 5, this.boardStartY - this.borderHeight >> 1, 0);
        this.initParticlesAt((this.screenWidth >> 1) + 5, this.boardStartY - this.borderHeight >> 1, 0);
    }

    private final void startBeginLevelAnimation() {
        this.beginLevelAnimationStarted = 2;
        this.hintShown = false;
        this.hintFlashes = 0;
        this.m_board.clearTileOffset(this.hintChoice[0]);
        this.m_board.clearTileOffset(this.hintChoice[1]);
        int n = this.getHeight() / 5 + 1;
        this.m_board.offsetTheBoard(2, n * 5 + 3 * n * 5);
        this.currentAnimatedLine = this.m_board.getHeight() - 1;
        this.m_board.offsetTheLine(2, this.beginLevelAnimationStarted * 5, this.currentAnimatedLine);
    }

    private final void updateBeginLevelAnimation() {
        TimerHandler.resetTimer(1);
        if (this.beginLevelAnimationStarted > 0) {
            if (!this.m_board.isLineMoving(this.currentAnimatedLine)) {
                this.beginLevelAnimationStarted = -1;
                this.m_board.offsetTheLine(3, -this.beginLevelAnimationStarted * 5, this.currentAnimatedLine);
            }
        } else if (this.beginLevelAnimationStarted > -1) {
            --this.beginLevelAnimationStarted;
            this.m_board.offsetTheLine(3, -this.beginLevelAnimationStarted * 5, this.currentAnimatedLine);
        } else if (!this.m_board.isLineMoving(this.currentAnimatedLine)) {
            --this.currentAnimatedLine;
            if (this.currentAnimatedLine < 0) {
                this.beginLevelAnimationStarted = 0;
            } else {
                this.beginLevelAnimationStarted = 2;
                this.m_board.offsetTheLine(2, this.beginLevelAnimationStarted * 5, this.currentAnimatedLine);
            }
        }
    }

    public final void startTileAnim(int n, int n2, boolean bl) {
        this.tileAnimations[n] = new SpacSprite(mCommonLevelSpac, n2, true);
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            n3 = 3;
            n4 = 2;
        }
        this.tileAnimations[n].setSequence(n2, n3, n4, true);
    }

    public final SpacSprite getAnimAt(int n) {
        return this.tileAnimations[n];
    }

    private final void updateTiles(int n) {
        int n2 = this.m_board.getWidth() * this.m_board.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (this.isTutorialEnabled() && this.m_board.getIndexedCellProperty(i, 24, 0x1000000) == 1) {
                if (this.getTutorialStep() == 1 || this.getTutorialStep() == 2 || this.getTutorialStep() == 5 || this.getTutorialStep() == 8) {
                    if (this.tileAnimations[i] == null) {
                        this.tileAnimations[i] = new SpacSprite(mCommonLevelSpac, 3, true);
                        this.tileAnimations[i].setSequence(3, 1, 0, true);
                    } else {
                        this.tileAnimations[i].updateSprite(n);
                    }
                    this.m_board.setIndexedCellProperty(i, 1, 11, 2048);
                }
            } else if (this.tileAnimations[i] != null) {
                this.tileAnimations[i].updateSprite(n);
                if (this.tileAnimations[i].isAnimationComplete()) {
                    this.tileAnimations[i] = null;
                }
                this.m_board.setIndexedCellProperty(i, 1, 11, 2048);
            }
            if (this.m_board.getIndexedCellProperty(i, 27, 0x8000000) != 1) continue;
            this.m_board.setIndexedCellProperty(i, 0, 27, 0x8000000);
            this.tileAnimations[i] = null;
        }
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(int n) {
        this.gameMode = n;
    }

    public boolean isTutorialMove(int n, int n2, int n3) {
        if (n >= 2) {
            return false;
        }
        if (n2 == this.tutorialMoves[n][0] && n3 == this.tutorialMoves[n][1]) {
            return true;
        }
        return n2 == this.tutorialMoves[n][2] && n3 == this.tutorialMoves[n][3];
    }

    public boolean isTutorialMode() {
        if (!this.isTutorialEnabled()) {
            this.tutorialMode = false;
        }
        return this.tutorialMode;
    }

    public void setTutorialMode(boolean bl) {
        if (!this.isTutorialEnabled()) {
            this.tutorialMode = false;
        }
        this.tutorialMode = bl;
    }

    public boolean isTutorialEnabled() {
        if (this.getGameMode() != 2) {
            return false;
        }
        return this.tutorialEnabled;
    }

    public void setTutorialEnabled(boolean bl) {
        this.tutorialEnabled = bl;
    }

    public void triggerTutorialDialog(int n, boolean bl) {
        this.tutorialText = n;
        this.nextState = this.getJQ2009GameState();
        this.setJQ2009GameState(6);
        this.tutorialRenderDialog = true;
        this.tutorialRepaintMain = bl;
        this.setNegativeSoftkey(null);
    }

    public void triggerTutorialDialog(int n) {
        this.triggerTutorialDialog(n, false);
    }

    public boolean isTutorialHardcodedLevel(int n) {
        if (!this.isTutorialEnabled()) {
            return false;
        }
        return n < 2;
    }

    private void resetDistributions() {
        for (int i = 0; i < this.jewelsRemap.length; ++i) {
            this.distributions[i] = 100;
        }
    }

    public void setCharPos(int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2) {
        int n6 = this.boardStartY - 58;
        int n7 = this.boardStartX - 12;
        if (n != 0) {
            n7 = -n7;
        }
        if (bl2) {
            n6 = 0;
            n7 = 0;
        }
        if (bl) {
            this.charPos[n * 8 + 0] = n2 + n7;
            this.charPos[n * 8 + 1] = n3 + n6;
            this.charPos[n * 8 + 6] = 0;
            this.charPos[n * 8 + 7] = -1;
        } else {
            this.charPos[n * 8 + 2] = this.charPos[n * 8 + 0];
            this.charPos[n * 8 + 3] = this.charPos[n * 8 + 1];
            this.charPos[n * 8 + 4] = n2 + n7;
            this.charPos[n * 8 + 5] = n3 + n6;
            this.charPos[n * 8 + 6] = n4;
            this.charPos[n * 8 + 7] = n5;
        }
    }

    public final int getLeftOffset() {
        int n = this.borderHeight;
        int n2 = this.boardStartX - n;
        return n2;
    }

    public int getCharX(int n) {
        return this.charPos[n * 8 + 0];
    }

    public int getCharY(int n) {
        return this.charPos[n * 8 + 1];
    }

    public boolean isCharAnimFinished() {
        for (int i = 0; i < 2; ++i) {
            if (this.charPos[i * 8 + 7] == -1) continue;
            return false;
        }
        return true;
    }

    public void updateCharPos(int n) {
        for (int i = 0; i < 2; ++i) {
            if (this.charPos[i * 8 + 7] == -1) continue;
            if (n >= this.charPos[i * 8 + 6] + this.charPos[i * 8 + 7]) {
                this.charPos[i * 8 + 0] = this.charPos[i * 8 + 4];
                this.charPos[i * 8 + 1] = this.charPos[i * 8 + 5];
                this.charPos[i * 8 + 7] = -1;
                this.fullRedraw = true;
                continue;
            }
            if (n - this.charPos[i * 8 + 6] <= 0) continue;
            int n2 = n - this.charPos[i * 8 + 6];
            int n3 = this.charPos[i * 8 + 4] - this.charPos[i * 8 + 2];
            int n4 = n2 * n3 / this.charPos[i * 8 + 7];
            this.charPos[i * 8 + 0] = this.charPos[i * 8 + 2] + n4;
            n3 = this.charPos[i * 8 + 5] - this.charPos[i * 8 + 3];
            n4 = n2 * n3 / this.charPos[i * 8 + 7];
            this.charPos[i * 8 + 1] = this.charPos[i * 8 + 3] + n4;
            this.fullRedraw = true;
        }
    }

    public int getTutorialStep() {
        return this.tutorialStep;
    }

    public boolean setTutorialStep(int n) {
        if (n != -1 && !this.tutorials[n]) {
            return false;
        }
        if (n != this.tutorialStep && this.tutorialStep >= 0) {
            this.tutorials[this.tutorialStep] = false;
        }
        this.tutorialStep = n;
        this.m_board.resetTutorialHighlight();
        return true;
    }

    public final int getPlayer() {
        return this.player;
    }

    public int getBossPowerup() {
        return this.bossPowerup;
    }

    public void setBossPowerup(int n) {
        try {
            if (n == 1) {
                if (this.getCurrentLevel() != 11) {
                    n = 0;
                } else {
                    bossPowerup2X = (byte)4;
                    bossPowerup2Y = (byte)5;
                }
            }
            if (n == 2) {
                int[] nArray = new int[]{0, 0};
                if ((this.endConditionsCodes & 0x4007) == 1) {
                    if (this.IsJewelsTwoTypes()) {
                        this.getWhirlWindTarget(this.m_board.m_boardCells, nArray, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, this.m_board.getWinnerTile(1), this.getJewelsToWinCount(1) - this.cpuJewels2);
                    } else {
                        this.getWhirlWindTarget(this.m_board.m_boardCells, nArray, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, -1, 0);
                    }
                } else {
                    this.getWhirlWindTarget(this.m_board.m_boardCells, nArray, -1, 0, -1, 0);
                }
                if (nArray[0] < 0) {
                    return;
                }
                bossPowerup2X = (byte)(nArray[0] % 8);
                bossPowerup2Y = (byte)(nArray[0] / 8);
                bossPowerup3X = (byte)(nArray[1] % 8);
                bossPowerup3Y = (byte)(nArray[1] / 8);
            } else if (n == 0) {
                int n2 = 0;
                n2 = (this.endConditionsCodes & 0x4007) == 1 ? (this.IsJewelsTwoTypes() ? this.getHammerTarget(this.m_board.m_boardCells, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, this.m_board.getWinnerTile(1), this.getJewelsToWinCount(1) - this.cpuJewels2) : this.getHammerTarget(this.m_board.m_boardCells, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, -1, 0)) : this.getHammerTarget(this.m_board.m_boardCells, -1, 0, -1, 0);
                if (n2 < 0) {
                    return;
                }
                bossPowerup2X = (byte)(n2 % 8);
                bossPowerup2Y = (byte)(n2 / 8);
            } else if (n == 3) {
                int n3 = 0;
                n3 = (this.endConditionsCodes & 0x4007) == 1 ? (this.IsJewelsTwoTypes() ? this.getBreakColorTarget(this.m_board.m_boardCells, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, this.m_board.getWinnerTile(1), this.getJewelsToWinCount(1) - this.cpuJewels2) : this.getBreakColorTarget(this.m_board.m_boardCells, this.m_board.getWinnerTile(0), this.getJewelsToWinCount(0) - this.cpuJewels, -1, 0)) : this.getBreakColorTarget(this.m_board.m_boardCells, -1, 0, -1, 0);
                if (n3 < 0) {
                    bossPowerup2X = (byte)(Math.abs(this.getRandom().nextInt()) % 8);
                    bossPowerup2Y = (byte)(Math.abs(this.getRandom().nextInt()) % 5 + 3);
                } else {
                    bossPowerup2X = (byte)(n3 % 8);
                    bossPowerup2Y = (byte)(n3 / 8);
                }
            }
            this.bossPowerup = n;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public final boolean isCPUsTurn() {
        return !(this.player == 0 && this.player1Human || this.player == 1 && this.player2Human);
    }

    public final boolean isCPUsTurn2() {
        return this.player != 0;
    }

    public int getBossMovesCount() {
        return this.bossMovesCount;
    }

    public void setBossMovesCount(int n) {
        this.bossMovesCount = n;
    }

    public int getBossPowerupsCount() {
        return this.bossPowerupsCount;
    }

    public void setBossPowerupsCount(int n) {
        this.bossPowerupsCount = n;
    }

    public boolean[] getTutorials() {
        return this.tutorials;
    }

    public void setTutorials(boolean[] blArray) {
        this.tutorials = blArray;
    }

    public void setTutorials(int n, boolean bl) {
        this.tutorials[n] = bl;
    }

    public boolean getSpecialMatches() {
        return this.specialMatches;
    }

    public void setSpecialMatches(boolean bl) {
        this.specialMatches = bl;
    }

    public void setTutorialTextPosition(int n, int n2) {
        this.tutorialTextPositionX = n;
        this.tutorialTextPositionY = n2;
        this.tutorialTextClear = false;
    }

    public void setTutorialTextClear(boolean bl) {
        this.tutorialTextClear = bl;
    }

    private void setPopUpDialog(char[] cArray) {
        this.setPopUpText(cArray, null);
        this.setJQ2009GameState(0);
    }

    public byte[] getJewelsRemap() {
        return this.jewelsRemap;
    }

    private final void renderUpperBorder(Graphics graphics) {
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        mSpecificLevelSpac.renderFrame(graphics, 17, -1, 3, 3 * this.cellSize + this.boardStartY);
        mSpecificLevelSpac.renderFrame(graphics, 18, -1, this.screenWidth - 2 - 1, 3 * this.cellSize + this.boardStartY);
    }

    private void setPopUpText(char[] cArray, char[][] cArray2) {
        char[] cArray3 = TextHandler.tokenizeString(cArray, cArray2);
        this.popUpTextLines = Font.formatString(this.getSharedFont(), cArray3, this.screenWidth - 20);
    }

    private void setupStoryPage(char[] cArray) {
        this.storyFont = this.getSharedFont();
        int n = 0;
        int n2 = 0;
        if (mStorySpac != null) {
            n = mStorySpac.getFrameRect(3)[2];
            n2 = mStorySpac.getFrameRect(1)[2];
        }
        this.storyTextLines = Font.formatString(this.storyFont, cArray, this.screenWidth - n - n2);
        this.storyTextLineIndex = 0;
        this.storyTextPageHeight = 120 / (2 + this.storyFont.getHeight());
        this.setPositiveSoftkey(this.getOkSoftKey());
        if (this.storyTextLineIndex + this.storyTextPageHeight < this.storyTextLines.length) {
            this.setNegativeSoftkey(this.getSkipSoftkey());
        } else {
            this.setNegativeSoftkey(null);
        }
    }

    public abstract void renderSelectionGlow(Graphics var1, SpacFile var2, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8);

    public SpacFile getSpecialCursorSpac() {
        return mSpecialCursorSpac;
    }

    public SpacSprite getMJewelsSpac() {
        return this.mIconAnimation;
    }

    public final int getTileX(int n) {
        return this.boardStartX + n % this.m_board.getWidth() * this.cellSize;
    }

    public final int getTileY(int n) {
        return this.boardStartY + n / this.m_board.getWidth() * this.cellSize;
    }

    protected int getPowerupMenuWidth() {
        int n = mMenuInGameSpac.getFrameRect(3)[2];
        int n2 = mMenuInGameSpac.getFrameRect(1)[2];
        return n + n2 + this.specialMenuItemWidth;
    }

    public final void processGameClrKey(int n) {
        switch (n) {
            case 2: {
                if (this.getCurrentLevel() == 0) {
                    this.setJQ2009GameState(1);
                    break;
                }
                this.setGameState(3);
                break;
            }
            case 3: {
                if (this.isFirstLevelInChapter(this.getCurrentLevel())) {
                    this.setJQ2009GameState(2);
                    break;
                }
                this.setGameState(3);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: {
                this.setGameState(3);
                break;
            }
            case 11: {
                if (this.getCurrentLevel() == levelData.length / 8 - 1) {
                    this.setCurrentLevel(this.getCurrentLevel() + 1);
                }
                this.setGameState(3);
                break;
            }
            default: {
                this.pauseJQ2009Game();
            }
        }
    }

    public final void refreshHudIfIntersected(int n, int n2, int n3, int n4) {
        if (this.intersectRects(n, n2, n3, n4, this.hudRect[0], this.hudRect[1], this.hudRect[2], this.hudRect[3])) {
            this.refreshHud = true;
            this.refreshHudCenter = true;
        } else if (this.hudCenterRect != null && this.intersectRects(n, n2, n3, n4, this.hudCenterRect[0], this.hudCenterRect[1], this.hudCenterRect[2], this.hudCenterRect[3])) {
            this.refreshHudCenter = true;
        }
    }

    public void setAwards(boolean[] blArray) {
        this.awards = blArray;
    }

    public boolean[] getAwards() {
        return this.awards;
    }

    public int getBoardFailureCounter() {
        return this.boardFailureCounter;
    }

    public void setBoardFailureCounter(int n) {
        this.boardFailureCounter = n;
    }

    public void resetAwards() {
        for (int i = 0; i < this.getAwards().length; ++i) {
            this.getAwards()[i] = false;
        }
        this.match4Count = 0;
        this.match5Count = 0;
        this.matchStreak = 0;
        this.setBoardFailureCounter(0);
        this.coinsUsedInStory = false;
    }

    public void resetStats() {
        this.totalJewelsMatched = 0;
        this.totalCoinsUsed = 0;
        this.totalMaxStreak = 0;
        this.totalMatch4 = 0;
        this.totalMatch5 = 0;
    }

    public void setUnlockLevels(boolean bl) {
        this.unlockLevels = bl;
    }

    public boolean isUnlockLevels() {
        return this.unlockLevels;
    }

    public void setUnlockAwards(boolean bl) {
        this.unlockAwards = bl;
    }

    public boolean isUnlockAwards() {
        return this.unlockAwards;
    }

    public void setFullRedraw(boolean bl) {
        this.fullRedraw = bl;
    }

    public void setFillWhite(boolean bl) {
        this.fillWhite = bl;
    }

    protected abstract void setUserName(char[] var1);

    public void setTutorialRepaintMain(boolean bl) {
        this.tutorialRepaintMain = bl;
    }

    public boolean isDrawAnimatedTile() {
        return this.drawAnimatedTile;
    }

    public void setDrawAnimatedTile(boolean bl) {
        this.drawAnimatedTile = bl;
    }

    public boolean isYourTurn() {
        return this.notDisplayYourTurn;
    }

    public void setYourTurn(boolean bl) {
        this.notDisplayYourTurn = bl;
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public void setBackBuffer(Image image) {
        this.backBuffer = image;
    }

    public final void deselectCells() {
        this.m_board.deselectCells();
        this.selected = false;
    }

    public void setMatchMultiSix(boolean bl) {
        this.matchMulti6 = bl;
    }

    public void setMatchMultiSeven(boolean bl) {
        this.matchMulti7 = bl;
    }

    public int getPowerUpState() {
        return this.powerUpState;
    }

    public MatchThreeBoard getM_board() {
        return this.m_board;
    }

    public final boolean isPlayersTurn() {
        return this.player == 0 && this.player1Human || this.player == 1 && this.player2Human;
    }

    public int getCellType(int n) {
        return (n & 7) >> 0;
    }

    public int getCellState(int n) {
        return (n & 0x60) >> 5;
    }

    public int setCellType(int n, int n2) {
        n = (n | 7) ^ 7;
        return n |= n2 << 0 & 7;
    }

    public int setCellState(int n, int n2) {
        n = (n | 0x18) ^ 0x18;
        return n |= n2 << 3 & 0x18;
    }

    public int getHammerTarget(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = -1;
        boolean bl = false;
        int n8 = -1;
        int n9 = 0;
        int[] nArray2 = new int[nArray.length / 3];
        int[] nArray3 = new int[nArray.length / 3];
        for (n6 = nArray.length - 1; n6 >= 0; --n6) {
            n5 = this.getCellType(nArray[n6]);
            if (n5 == 7) {
                bl = false;
                continue;
            }
            if (n6 % this.m_boardWidth == this.m_boardWidth - 1) {
                if (n == -1 && n3 == -1 || n5 == n && n2 > 0 || n5 == n3 && n4 > 0) {
                    bl = true;
                    n7 = n5;
                    continue;
                }
                bl = false;
                continue;
            }
            if (bl) {
                if (n5 != n7) {
                    if (n6 % this.m_boardWidth > 0 && n6 >= this.m_boardWidth && (n5 = this.getCellType(nArray[n6 - 1])) == n7 && (n5 = this.getCellType(nArray[n6 - this.m_boardWidth])) == n7) {
                        n9 = this.createGreatPoint(n6, n9, nArray2, nArray3);
                    }
                } else {
                    if (n8 == -1) {
                        n8 = n6;
                    }
                    if (n6 % this.m_boardWidth > 0 && n6 >= this.m_boardWidth && this.getCellType(nArray[n6 - 1]) != 7 && (n5 = this.getCellType(nArray[n6 - 1 - this.m_boardWidth])) == n7) {
                        n9 = this.createGreatPoint(n6 - 1, n9, nArray2, nArray3);
                    }
                    if (n6 % this.m_boardWidth < this.m_boardWidth - 2 && n6 >= this.m_boardWidth && this.getCellType(nArray[n6 + 2]) != 7 && (n5 = this.getCellType(nArray[n6 + 2 - this.m_boardWidth])) == n7) {
                        n9 = this.createGreatPoint(n6 + 2, n9, nArray2, nArray3);
                    }
                }
                bl = false;
                continue;
            }
            if (!(n == -1 && n3 == -1 || n5 == n && n2 > 0) && (n5 != n3 || n4 <= 0)) continue;
            bl = true;
            n7 = n5;
        }
        for (n6 = this.m_boardWidth - 1; n6 >= 0; --n6) {
            for (int i = this.m_boardHeight - 1; i >= 0; --i) {
                n5 = this.getCellType(nArray[i * this.m_boardWidth + n6]);
                if (n5 == 7) {
                    bl = false;
                    continue;
                }
                if (i == this.m_boardHeight - 1) {
                    if (n == -1 && n3 == -1 || n5 == n && n2 > 0 || n5 == n3 && n4 > 0) {
                        bl = true;
                        n7 = n5;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (bl) {
                    if (n5 == n7) {
                        if (n8 == -1) {
                            n8 = i * this.m_boardWidth + n6;
                        }
                        if (i > 1 && this.getCellType(nArray[(i - 1) * this.m_boardWidth + n6]) != 7 && (n5 = this.getCellType(nArray[(i - 2) * this.m_boardWidth + n6])) == n7) {
                            n9 = this.createGreatPoint((i - 1) * this.m_boardWidth + n6, n9, nArray2, nArray3);
                        }
                        if (i < this.m_boardHeight - 3 && this.getCellType(nArray[(i + 2) * this.m_boardWidth + n6]) != 7 && (n5 = this.getCellType(nArray[(i + 3) * this.m_boardWidth + n6])) == n7) {
                            n9 = this.createGreatPoint((i + 2) * this.m_boardWidth + n6, n9, nArray2, nArray3);
                        }
                    }
                    bl = false;
                    continue;
                }
                if (!(n == -1 && n3 == -1 || n5 == n && n2 > 0) && (n5 != n3 || n4 <= 0)) continue;
                bl = true;
                n7 = n5;
            }
        }
        if (n9 == 0) {
            if (n8 > -1) {
                return n8;
            }
            if (n > -1 || n3 > -1) {
                for (n6 = nArray.length - 1; n6 >= 0; --n6) {
                    n5 = this.getCellType(nArray[n6]);
                    if ((n5 != n || n2 <= 0) && (n5 != n3 || n4 <= 0)) continue;
                    return n6;
                }
            }
            return -1;
        }
        n8 = -1;
        for (n6 = n9 - 1; n6 >= 0; --n6) {
            if (n8 != -1 && nArray3[n6] <= nArray3[n8]) continue;
            n8 = n6;
        }
        return nArray2[n8];
    }

    public int getHammerTarget(int[] nArray) {
        return this.getHammerTarget(nArray, -1, 0, -1, 0);
    }

    public int createGreatPoint(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            if (nArray[n3] != n) continue;
            int n4 = n3;
            nArray2[n4] = nArray2[n4] + 1;
            break;
        }
        if (n3 == -1) {
            nArray[n2] = n;
            nArray2[n2] = 1;
            ++n2;
        }
        return n2;
    }

    public void getWhirlWindTarget(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = -1;
        boolean bl = false;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int[][] nArray3 = new int[nArray.length / 3][4];
        nArray2[0] = -1;
        nArray2[1] = -1;
        for (n8 = nArray.length - 1; n8 >= 0; --n8) {
            n7 = this.getCellType(nArray[n8]);
            if (n7 == 7) {
                bl = false;
            }
            if (n8 % this.m_boardWidth == this.m_boardWidth - 1) {
                if (n == -1 && n3 == -1 || n7 == n && n2 > 0 || n7 == n3 && n4 > 0) {
                    bl = true;
                    n9 = n7;
                    continue;
                }
                bl = false;
                continue;
            }
            if (bl) {
                if (n7 != n9) {
                    if (n8 % this.m_boardWidth > 0 && (n6 = this.getCellType(nArray[n8 - 1])) == n9) {
                        n13 = this.createGreatPoint(n8, n7, n9, n13, nArray3);
                    }
                } else {
                    if (n8 % this.m_boardWidth < this.m_boardWidth - 2 && (n6 = this.getCellType(nArray[n8 + 2])) != 7) {
                        n13 = this.createGreatPoint(n8 + 2, n6, n7, n13, nArray3);
                    }
                    if (n8 % this.m_boardWidth > 0 && (n6 = this.getCellType(nArray[n8 - 1])) != 7) {
                        n13 = this.createGreatPoint(n8 - 1, n6, n7, n13, nArray3);
                    }
                }
                bl = false;
                continue;
            }
            if (!(n == -1 && n3 == -1 || n7 == n && n2 > 0) && (n7 != n3 || n4 <= 0)) continue;
            bl = true;
            n9 = n7;
        }
        for (n8 = this.m_boardWidth - 1; n8 >= 0; --n8) {
            for (n5 = this.m_boardHeight - 1; n5 >= 0; --n5) {
                n7 = this.getCellType(nArray[n5 * this.m_boardWidth + n8]);
                if (n7 == 7) {
                    bl = false;
                    continue;
                }
                if (n5 == this.m_boardHeight - 1) {
                    if (n == -1 && n3 == -1 || n7 == n && n2 > 0 || n7 == n3 && n4 > 0) {
                        bl = true;
                        n9 = n7;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (bl) {
                    if (n7 != n9) {
                        if (n5 > 0 && (n6 = this.getCellType(nArray[(n5 - 1) * this.m_boardWidth + n8])) == n9) {
                            n13 = this.createGreatPoint(n5 * this.m_boardWidth + n8, n7, n9, n13, nArray3);
                        }
                    } else {
                        if (n5 > 0 && (n6 = this.getCellType(nArray[(n5 - 1) * this.m_boardWidth + n8])) != 7) {
                            n13 = this.createGreatPoint((n5 - 1) * this.m_boardWidth + n8, n6, n7, n13, nArray3);
                        }
                        if (n5 < this.m_boardHeight - 2 && (n6 = this.getCellType(nArray[(n5 + 2) * this.m_boardWidth + n8])) != 7) {
                            n13 = this.createGreatPoint((n5 + 2) * this.m_boardWidth + n8, n6, n7, n13, nArray3);
                        }
                    }
                    bl = false;
                    continue;
                }
                if (!(n == -1 && n3 == -1 || n7 == n && n2 > 0) && (n7 != n3 || n4 <= 0)) continue;
                bl = true;
                n9 = n7;
            }
        }
        if (n13 == 0) {
            if (n > -1 && n3 > -1) {
                this.getWhirlWindTarget(nArray, nArray2, -1, 0, -1, 0);
            }
        } else {
            n12 = 0;
            int n14 = 0;
            for (n8 = n13 - 1; n8 >= 0; --n8) {
                if (nArray3[n8][3] > n14) {
                    n11 = n8;
                    n14 = nArray3[n8][3];
                }
                for (n5 = n8 - 1; n5 >= 0; --n5) {
                    if (Math.abs(nArray3[n8][0] - nArray3[n5][0]) == 1 || Math.abs(nArray3[n8][0] - nArray3[n5][0]) == this.m_boardWidth) continue;
                    n10 = 0;
                    if (nArray3[n5][1] == nArray3[n8][2]) {
                        n10 += (nArray3[n8][3] << 1) + 1;
                    } else if (nArray3[n5][2] == nArray3[n8][1]) {
                        n10 += (nArray3[n5][3] << 1) + 1;
                    }
                    if (n10 <= n12) continue;
                    nArray2[0] = nArray3[n8][0];
                    nArray2[1] = nArray3[n5][0];
                    n10 = n12;
                }
            }
            if (n12 == 0) {
                for (n8 = nArray.length - 1; n8 >= 0; --n8) {
                    if (this.getCellType(nArray[n8]) != nArray3[n11][2] || Math.abs(n8 - nArray3[n11][0]) == 1 || Math.abs(n8 - nArray3[n11][0]) == this.m_boardWidth) continue;
                    nArray2[0] = n8;
                    nArray2[1] = nArray3[n11][0];
                    return;
                }
                if (n > -1 && n3 > -1) {
                    this.getWhirlWindTarget(nArray, nArray2, -1, 0, -1, 0);
                }
            }
        }
    }

    public int createGreatPoint(int n, int n2, int n3, int n4, int[][] nArray) {
        int n5;
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            if (nArray[n5][0] != n || nArray[n5][2] != n3) continue;
            int[] nArray2 = nArray[n5];
            nArray2[3] = nArray2[3] + 1;
            break;
        }
        if (n5 == -1) {
            nArray[n4][0] = n;
            nArray[n4][1] = n2;
            nArray[n4][2] = n3;
            nArray[n4][3] = 1;
            ++n4;
        }
        return n4;
    }

    public int getBreakColorTarget(int[] nArray) {
        return this.getBreakColorTarget(nArray, -1, 0, -1, 0);
    }

    public int getBreakColorTarget(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        if (n > -1 && n2 > 0) {
            for (n5 = nArray.length - 1; n5 >= 0; --n5) {
                if (this.getCellType(nArray[n5]) != n) continue;
                if (n6 == -1) {
                    n6 = n5;
                }
                --n2;
                ++n8;
            }
        }
        if (n3 > -1 && n4 > 0) {
            for (n5 = nArray.length - 1; n5 >= 0; --n5) {
                if (this.getCellType(nArray[n5]) != n3) continue;
                if (n7 == -1) {
                    n7 = n5;
                }
                --n4;
                ++n9;
            }
        }
        if (n > -1 || n3 > -1) {
            if (n8 > n9) {
                return n6;
            }
            return n7;
        }
        int[] nArray2 = new int[this.jewelsRemap.length];
        int[] nArray3 = new int[this.jewelsRemap.length];
        for (n5 = nArray2.length - 1; n5 >= 0; --n5) {
            nArray2[n5] = 0;
            nArray3[n5] = -1;
        }
        for (n5 = nArray.length - 1; n5 >= 0; --n5) {
            int n10 = this.getCellType(nArray[n5]);
            if (n10 >= nArray2.length || n10 < 0) continue;
            int n11 = n10;
            nArray2[n11] = nArray2[n11] + 1;
            if (nArray3[n10] != -1) continue;
            nArray3[n10] = n5;
        }
        n6 = -1;
        for (n5 = nArray2.length - 1; n5 >= 0; --n5) {
            if (n6 != -1 && nArray2[n5] <= nArray2[n6]) continue;
            n6 = n5;
        }
        return nArray3[n6];
    }

    static {
        affectedByPowerup2 = false;
        wonAnimationTimes = (byte)3;
        PowerupCells1 = (byte)-1;
        PowerupCells2 = (byte)-1;
        bossPowerup2X = 0;
        bossPowerup2Y = 0;
        bossPowerup3X = 0;
        bossPowerup3Y = 0;
        gameStartTime = -1L;
        gamePauseTime = -1L;
        gameTutorialTime = -1L;
        gameTutorialshow = 0;
        MultiPlayermode = 0;
        MultiPlayerChallenge = 1;
        MultiPlayerChallenge2 = 0;
        MultiPlayer1Win = 0;
        MultiPlayer2Win = 0;
        MultiPlayerEnd = false;
        MultiPlayer1Time = 0;
        MultiPlayer2Time = 0;
        MultiPlayer1Ready = false;
        MultiPlayer2Ready = false;
        MultiPlayerGame3Note = false;
        MultiPlayerEnd2 = false;
        MultiPlayerModeTyte = new byte[]{1, 2, 3, 1, 2, 3};
        MultiPlayer1move = true;
        MultiPlayer2move = true;
        MultiPlayerTimeReady = false;
        MultiPlayerReadyGo = false;
        BossPowerup = true;
        isPreRenderMP = true;
        imgPad_left = null;
        imgPad_right = null;
    }
}

