/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.math;

import com.iplay.game.math.FixedPoint12;

public final class VectorManager {
    public static final int VECTOR_3D = 3;
    public static final int VECTOR_3D_X = 0;
    public static final int VECTOR_3D_Y = 1;
    public static final int VECTOR_3D_Z = 2;
    private static int[][] temporaryVector3DStack;
    private static int stackPosition;

    private VectorManager() {
    }

    public static int[] createVector3d() {
        return new int[3];
    }

    public static int[] createVector3d(int[] nArray) {
        int[] nArray2 = new int[3];
        System.arraycopy(nArray, 0, nArray2, 0, 3);
        return nArray2;
    }

    public static int[] createVector3d(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        return nArray;
    }

    public static void initTemporaryVector3DStack(int n) {
        temporaryVector3DStack = new int[n][];
        for (int i = 0; i < temporaryVector3DStack.length; ++i) {
            VectorManager.temporaryVector3DStack[i] = new int[3];
        }
        stackPosition = temporaryVector3DStack.length - 1;
    }

    public static int[] getTemporaryVector3D() {
        int[] nArray = temporaryVector3DStack[stackPosition];
        nArray = VectorManager.resetVector3d(nArray);
        --stackPosition;
        return nArray;
    }

    public static int[] getTemporaryVector3D(int n, int n2, int n3) {
        int[] nArray = VectorManager.getTemporaryVector3D();
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        return nArray;
    }

    public static int[] getTemporaryVector3D(int[] nArray) {
        int[] nArray2 = VectorManager.getTemporaryVector3D();
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        return nArray2;
    }

    public static void releaseTemporaryVector3D(int[] nArray) {
        VectorManager.temporaryVector3DStack[++VectorManager.stackPosition] = nArray;
    }

    public static int[] resetVector3d(int[] nArray) {
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        return nArray;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        return nArray[0] == nArray2[0] & nArray[1] == nArray2[1] & nArray[2] == nArray2[2];
    }

    public static int length(int[] nArray) {
        int n = 0;
        n = FixedPoint12.multiply(nArray[0], nArray[0]) + FixedPoint12.multiply(nArray[1], nArray[1]) + FixedPoint12.multiply(nArray[2], nArray[2]);
        n = n != 0 ? FixedPoint12.sqrt(n) : 0;
        return n;
    }

    public static int[] unit(int[] nArray, int[] nArray2) {
        int n = VectorManager.length(nArray);
        if (n != 0) {
            nArray2 = VectorManager.divide(nArray, n, nArray2);
        }
        return nArray2;
    }

    public static int[] add(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] + nArray2[0];
        nArray3[1] = nArray[1] + nArray2[1];
        nArray3[2] = nArray[2] + nArray2[2];
        return nArray3;
    }

    public static int[] subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] - nArray2[0];
        nArray3[1] = nArray[1] - nArray2[1];
        nArray3[2] = nArray[2] - nArray2[2];
        return nArray3;
    }

    public static int[] multiply(int[] nArray, int n, int[] nArray2) {
        nArray2[0] = FixedPoint12.multiply(nArray[0], n);
        nArray2[1] = FixedPoint12.multiply(nArray[1], n);
        nArray2[2] = FixedPoint12.multiply(nArray[2], n);
        return nArray2;
    }

    public static int[] multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = FixedPoint12.multiply(nArray[0], nArray2[0]);
        nArray3[1] = FixedPoint12.multiply(nArray[1], nArray2[1]);
        nArray3[2] = FixedPoint12.multiply(nArray[2], nArray2[2]);
        return nArray3;
    }

    public static int[] divide(int[] nArray, int n, int[] nArray2) {
        nArray2[0] = FixedPoint12.divide(nArray[0], n);
        nArray2[1] = FixedPoint12.divide(nArray[1], n);
        nArray2[2] = FixedPoint12.divide(nArray[2], n);
        return nArray2;
    }

    public static int dotProduct(int[] nArray, int[] nArray2) {
        int n = FixedPoint12.multiply(nArray[0], nArray2[0]) + FixedPoint12.multiply(nArray[1], nArray2[1]) + FixedPoint12.multiply(nArray[2], nArray2[2]);
        return n;
    }

    public static int[] crossProduct(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray == nArray3) {
            nArray = VectorManager.createVector3d(nArray);
        }
        if (nArray2 == nArray3) {
            nArray2 = VectorManager.createVector3d(nArray2);
        }
        nArray3[0] = FixedPoint12.multiply(nArray[1], nArray2[2]) - FixedPoint12.multiply(nArray[2], nArray2[1]);
        nArray3[1] = FixedPoint12.multiply(nArray[2], nArray2[0]) - FixedPoint12.multiply(nArray[0], nArray2[2]);
        nArray3[2] = FixedPoint12.multiply(nArray[0], nArray2[1]) - FixedPoint12.multiply(nArray[1], nArray2[0]);
        return nArray3;
    }

    public static int rayIntersection(int[] nArray, int[] nArray2, int[] nArray3, int n, int[] nArray4) {
        int n2 = 0;
        int n3 = VectorManager.dotProduct(nArray2, nArray3);
        if (n3 == 0) {
            nArray4 = null;
        } else {
            int n4 = n - VectorManager.dotProduct(nArray, nArray3);
            n2 = FixedPoint12.divide(n4, n3);
            if (n2 <= 0) {
                nArray4 = null;
            } else {
                nArray4[0] = nArray[0] + FixedPoint12.multiply(nArray2[0], n2);
                nArray4[1] = nArray[1] + FixedPoint12.multiply(nArray2[1], n2);
                nArray4[2] = nArray[2] + FixedPoint12.multiply(nArray2[2], n2);
            }
        }
        return n2;
    }

    public static int exitsAABB(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n;
        int[] nArray6 = VectorManager.getTemporaryVector3D();
        boolean[] blArray = new boolean[]{true, true, true};
        int n2 = 0;
        boolean bl = true;
        for (n = 0; n < 3; ++n) {
            int n3 = 0;
            if (nArray2[n] < 0) {
                nArray6[n] = FixedPoint12.divide(nArray3[n] - nArray[n], nArray2[n]);
                n3 = nArray6[n];
                nArray5[n] = nArray3[n];
                blArray[n] = false;
            } else if (nArray2[n] > 0) {
                nArray6[n] = FixedPoint12.divide(nArray4[n] - nArray[n], nArray2[n]);
                n3 = nArray6[n];
                nArray5[n] = nArray4[n];
                blArray[n] = false;
            }
            if (bl && !blArray[n]) {
                n2 = n3;
                bl = false;
                continue;
            }
            if (blArray[n] || n3 >= n2 || n3 < 0) continue;
            n2 = n3;
        }
        for (n = 0; n < nArray5.length; ++n) {
            if (!(blArray[n] || nArray6[n] <= n2 && nArray6[n] >= 0)) {
                nArray5[n] = nArray[n] + FixedPoint12.multiply(n2, nArray2[n]);
                continue;
            }
            if (!blArray[n]) continue;
            nArray5[n] = nArray[n];
        }
        VectorManager.releaseTemporaryVector3D(nArray6);
        return n2;
    }

    public static int entersAABB(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int n;
        boolean bl = true;
        int[] nArray7 = VectorManager.createVector3d(-4096, -4096, -4096);
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            if (nArray[n] < nArray3[n]) {
                nArray5[n] = nArray3[n];
                nArray6[n] = -4096;
                bl = false;
                if (nArray2[n] == 0) continue;
                nArray7[n] = FixedPoint12.divide(nArray3[n] - nArray[n], nArray2[n]);
                continue;
            }
            if (nArray[n] <= nArray4[n]) continue;
            nArray5[n] = nArray4[n];
            nArray6[n] = 4096;
            bl = false;
            if (nArray2[n] == 0) continue;
            nArray7[n] = FixedPoint12.divide(nArray4[n] - nArray[n], nArray2[n]);
        }
        if (bl) {
            System.arraycopy(nArray, 0, nArray5, 0, nArray5.length);
            n2 = -1;
        } else {
            n = 2;
            if (nArray7[1] > nArray7[n]) {
                n = 1;
            }
            if (nArray7[0] > nArray7[n]) {
                n = 0;
            }
            if ((n2 = nArray7[n]) >= 0) {
                for (int i = 0; i < 3; ++i) {
                    if (i == n) continue;
                    nArray5[i] = nArray[i] + FixedPoint12.multiply(nArray7[n], nArray2[i]);
                    nArray6[i] = 0;
                    if (nArray5[i] >= nArray3[i] && nArray5[i] <= nArray4[i]) continue;
                    n2 = 0;
                    break;
                }
            } else {
                n2 = 0;
            }
        }
        return n2;
    }

    public static int entersAACylinder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int[] nArray4, int[] nArray5) {
        int[] nArray6;
        int n4 = 0;
        int[] nArray7 = new int[3];
        int[] nArray8 = new int[3];
        int n5 = 0;
        if (nArray[n] > nArray3[n] + n3) {
            nArray7[n] = nArray3[n] + n3;
            nArray8[n] = 4096;
            if (nArray2[n] != 0) {
                n5 = FixedPoint12.divide(nArray3[n] + n3 - nArray[n], nArray2[n]);
            }
        } else if (nArray[n] < nArray3[n]) {
            nArray7[n] = nArray3[n];
            nArray8[n] = -4096;
            if (nArray2[n] != 0) {
                n5 = FixedPoint12.divide(nArray3[n] - nArray[n], nArray2[n]);
            }
        }
        if (n5 > 0) {
            for (int i = 0; i < 3; ++i) {
                if (i == n) continue;
                nArray7[i] = nArray[i] + FixedPoint12.multiply(n5, nArray2[i]);
                nArray8[i] = 0;
            }
            nArray6 = new int[3];
            nArray6 = VectorManager.subtract(nArray3, nArray7, nArray6);
            nArray6[n] = 0;
            if (VectorManager.length(nArray6) > n2) {
                n5 = 0;
            }
        }
        nArray6 = new int[3];
        int[] nArray9 = new int[3];
        int n6 = 0;
        int[] nArray10 = new int[3];
        if (n == 0) {
            nArray10 = VectorManager.createVector3d(4096, 0, 0);
        } else if (n == 1) {
            nArray10 = VectorManager.createVector3d(0, 4096, 0);
        }
        if (n == 2) {
            nArray10 = VectorManager.createVector3d(0, 0, 4096);
        }
        if (Math.abs(VectorManager.dotProduct(nArray10, nArray2)) != 4096) {
            int n7 = 0;
            int n8 = 1;
            if (n == 0) {
                n7 = 1;
                n8 = 2;
            } else if (n == 1) {
                n7 = 0;
                n8 = 2;
            }
            int[] nArray11 = new int[3];
            nArray11 = VectorManager.subtract(nArray, nArray3, nArray11);
            int n9 = FixedPoint12.multiply(nArray2[n7], nArray2[n7]) + FixedPoint12.multiply(nArray2[n8], nArray2[n8]);
            int n10 = FixedPoint12.multiply(FixedPoint12.multiply(nArray2[n7], nArray11[n7]) + FixedPoint12.multiply(nArray2[n8], nArray11[n8]), 8192);
            int n11 = FixedPoint12.multiply(nArray3[n7], nArray3[n7]) + FixedPoint12.multiply(nArray3[n8], nArray3[n8]) + FixedPoint12.multiply(nArray[n7], nArray[n7]) + FixedPoint12.multiply(nArray[n8], nArray[n8]) - FixedPoint12.multiply(FixedPoint12.multiply(nArray3[n7], nArray[n7]) + FixedPoint12.multiply(nArray3[n8], nArray[n8]), 8192) - FixedPoint12.multiply(n2, n2);
            int n12 = FixedPoint12.multiply(n10, n10) - FixedPoint12.multiply(FixedPoint12.multiply(16384, n9), n11);
            if (n12 < 0) {
                n6 = 0;
            } else if (n12 == 0) {
                n6 = FixedPoint12.divide(-n10, FixedPoint12.multiply(2, n9));
                nArray6 = VectorManager.multiply(nArray2, n6, nArray6);
                nArray6 = VectorManager.add(nArray, nArray6, nArray6);
                nArray9 = VectorManager.subtract(nArray6, nArray3, nArray9);
                nArray9[n] = 0;
                nArray9 = VectorManager.unit(nArray9, nArray9);
            } else if (n12 > 0) {
                n6 = FixedPoint12.divide(-n10 + FixedPoint12.sqrt(n12), FixedPoint12.multiply(8192, n9));
                int n13 = FixedPoint12.divide(-n10 - FixedPoint12.sqrt(n12), FixedPoint12.multiply(8192, n9));
                if (n13 < n6) {
                    n6 = n13;
                }
                nArray6 = VectorManager.multiply(nArray2, n6, nArray6);
                nArray6 = VectorManager.add(nArray, nArray6, nArray6);
                nArray9 = VectorManager.subtract(nArray6, nArray3, nArray9);
                nArray9[n] = 0;
                nArray9 = VectorManager.unit(nArray9, nArray9);
            }
            if (n6 > 0 && (nArray6[n] < nArray3[n] || nArray6[n] > nArray3[n] + n3)) {
                n6 = 0;
            }
        }
        if (n5 <= 0 && n6 <= 0) {
            n4 = 0;
        } else if (n5 <= 0 && n6 > 0) {
            System.arraycopy(nArray6, 0, nArray4, 0, nArray4.length);
            System.arraycopy(nArray9, 0, nArray5, 0, nArray5.length);
            n4 = n6;
        } else if (n5 > 0 && n6 <= 0) {
            System.arraycopy(nArray7, 0, nArray4, 0, nArray4.length);
            System.arraycopy(nArray8, 0, nArray5, 0, nArray5.length);
            n4 = n5;
        } else if (n5 > n6) {
            System.arraycopy(nArray7, 0, nArray4, 0, nArray4.length);
            System.arraycopy(nArray8, 0, nArray5, 0, nArray5.length);
            n4 = n5;
        } else {
            System.arraycopy(nArray6, 0, nArray4, 0, nArray4.length);
            System.arraycopy(nArray9, 0, nArray5, 0, nArray5.length);
            n4 = n6;
        }
        return n4;
    }

    public static boolean overlaps(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        boolean bl = true;
        for (int i = 0; i < 3; ++i) {
            if (nArray[i] < nArray3[i]) {
                bl &= nArray3[i] - nArray[i] <= nArray2[i] - nArray[i];
                continue;
            }
            bl &= nArray[i] - nArray3[i] <= nArray4[i] - nArray3[i];
        }
        return bl;
    }

    public static int[] rotateZ(int[] nArray, int n, int[] nArray2) {
        int n2 = FixedPoint12.sin(n);
        int n3 = FixedPoint12.cos(n);
        int n4 = FixedPoint12.multiply(nArray[0], n3) - FixedPoint12.multiply(nArray[1], n2);
        nArray2[1] = FixedPoint12.multiply(nArray[0], n2) + FixedPoint12.multiply(nArray[1], n3);
        nArray2[0] = n4;
        return nArray2;
    }

    public static int[] rotateX(int[] nArray, int n, int[] nArray2) {
        int n2 = FixedPoint12.sin(n);
        int n3 = FixedPoint12.cos(n);
        int n4 = FixedPoint12.multiply(nArray[1], n3) - FixedPoint12.multiply(nArray[2], n2);
        nArray2[2] = FixedPoint12.multiply(nArray[1], n2) + FixedPoint12.multiply(nArray[2], n3);
        nArray2[1] = n4;
        return nArray2;
    }

    public static int[] rotateY(int[] nArray, int n, int[] nArray2) {
        int n2 = FixedPoint12.sin(n);
        int n3 = FixedPoint12.cos(n);
        int n4 = FixedPoint12.multiply(nArray[2], n3) - FixedPoint12.multiply(nArray[0], n2);
        nArray2[0] = FixedPoint12.multiply(nArray[2], n2) + FixedPoint12.multiply(nArray[0], n3);
        nArray2[2] = n4;
        return nArray2;
    }

    public static String toString(int[] nArray) {
        return "[" + FixedPoint12.toString(nArray[0]) + "," + FixedPoint12.toString(nArray[1]) + "," + FixedPoint12.toString(nArray[2]) + "] length=" + FixedPoint12.toString(VectorManager.length(nArray));
    }
}

