/*
 * Decompiled with CFR 0.152.
 */
public class GameField {
    public static final byte EMPTY = 0;
    public static final byte FULL = 1;
    public static final byte BLINK = 2;
    public static final byte BORDER_NONE = -1;
    public static final byte BORDER_TOP = 0;
    public static final byte BORDER_LEFT = 1;
    public static final byte BORDER_RIGHT = 2;
    public static final byte BORDER_BOTTOM = 3;
    public static final int size = 200;
    public static final byte width = 10;
    public static final byte height = 20;
    public static final byte STEP_LEFT = 0;
    public static final byte STEP_RIGHT = 1;
    public static final byte STEP_UP = 2;
    public static final byte STEP_DOWN = 3;
    public static final short[] step = new short[]{-1, 1, -10, 10};
    private static final byte[] bArrField = new byte[200];
    public static final int last = 199;
    public static final int last_row = 190;
    public static final int last_in_line = 9;
    public static final short[] fill = new short[200];

    public static final void init() {
        GameField.initFillWay();
    }

    public static final void clear() {
        GUtillArray.fill(bArrField, (byte)0);
    }

    public static final void save() throws Exception {
        GUtillIo.writeArray(bArrField);
    }

    public static final void load() throws Exception {
        GUtillIo.read(bArrField);
    }

    public static final byte get(short[] pos) {
        int index = pos[1] * 10 + pos[0];
        return GameField.get(index);
    }

    public static final byte get(int x, int y) {
        int index = y * 10 + x;
        return GameField.get(index);
    }

    public static final byte get(int index) {
        byte result = 1;
        if (index >= 0 && index < 200) {
            result = bArrField[index];
        }
        return result;
    }

    public static final void set(int x, int y, byte state) {
        int index = y * 10 + x;
        GameField.set(index, state);
    }

    public static final void set(short[] pos, byte state) {
        int index = pos[1] * 10 + pos[0];
        GameField.set(index, state);
    }

    public static final void set(int index, byte state) {
        if (index >= 0 && index < 200) {
            GameField.bArrField[index] = state;
        }
    }

    public static final byte[] border(short[] pos) {
        int index = pos[1] * 10 + pos[0];
        return GameField.border(index);
    }

    public static final byte[] border(int index) {
        byte[] result = new byte[]{};
        if ((index + 1) % 10 == 0) {
            result = GUtillArray.add(result, (byte)2);
        } else if (index % 10 == 0) {
            result = GUtillArray.add(result, (byte)1);
        }
        if (index < 10) {
            result = GUtillArray.add(result, (byte)0);
        } else if (index + 10 >= 200) {
            result = GUtillArray.add(result, (byte)3);
        }
        return result;
    }

    private static final void initFillWay() {
        boolean[] state = new boolean[200];
        GUtillArray.fill(state, false);
        GUtillArray.fill(fill, (short)0);
        int index = 0;
        int direction = 1;
        int next = 0;
        for (int cur = 0; cur < 200; ++cur) {
            next = index + step[direction];
            switch (direction) {
                case 0: {
                    if (next >= 0 && (next + 1) % 10 != 0 && !state[next]) break;
                    direction = 2;
                    break;
                }
                case 1: {
                    if (next <= 199 && next % 10 != 0 && !state[next]) break;
                    direction = 3;
                    break;
                }
                case 3: {
                    if (next <= 199 && !state[next]) break;
                    direction = 0;
                    break;
                }
                case 2: {
                    if (next >= 0 && !state[next]) break;
                    direction = 1;
                }
            }
            state[index] = true;
            GameField.fill[cur] = (short)index;
            index += step[direction];
        }
    }
}

