/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicBrodilka
extends GameLogic {
    private static final int LIFE_MAX = 4;
    private static final byte SCORE_INC = 100;
    private static final int PLAYER_SIZE = 1;
    private static final int FIRST_LINE = 8;
    private static final int LAST_LINE = 19;
    private static final int[][] BRIKS_PER_LINE = new int[][]{{3, 3}, {5}, {2, 3}, {4}, {3}};
    private static final int[] LINE_SPEED = new int[]{2, 3, 1, 2, 3};
    private static final int[] COLLISION_FIGURE = new int[]{0, 3, 11, 12, 21, 22, 30, 33};
    private static final byte SPEED_COUNT = 3;
    private byte bCurUpdate;
    private byte bShowCollision = 0;
    private int[] iBriksPlacedPos;
    private byte bBricksPlaced;

    public GameLogicBrodilka() {
        super(1, 4);
    }

    protected void load() throws Exception {
        super.load();
        this.bCurUpdate = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bCurUpdate);
        GUtillIo.writeByte(this.bShowCollision);
    }

    public void updateLevel(int level) {
        this.clear();
        this.iBriksPlacedPos = new int[10];
        this.bBricksPlaced = 0;
        this.placePlayer();
        this.bShowCollision = 0;
    }

    protected void placePlayer() {
        int i;
        this.active = false;
        GameField.clear();
        for (i = 0; i < this.bBricksPlaced; ++i) {
            GameField.set(this.iBriksPlacedPos[i], (byte)1);
        }
        for (i = 8; i < 19; i += 2) {
            this.fillLine(i);
        }
        for (i = 0; i < BRIKS_PER_LINE.length; ++i) {
            this.fillBarrier(i);
        }
        this.figure_pos[0] = 190 + GUtillMath.rnd(10);
        this.figure_elem[0] = 2;
        this.bCurUpdate = 1;
    }

    private void fillLine(int index) {
        for (int i = index * 10; i < index * 10 + 10; ++i) {
            GameField.set(i, (byte)1);
        }
    }

    private void fillBarrier(int index) {
        int fill_index = (9 + 2 * index) * 10 + GUtillMath.rnd(3);
        for (int i = 0; i < BRIKS_PER_LINE[index].length; ++i) {
            for (int j = 0; j < BRIKS_PER_LINE[index][i]; ++j) {
                GameField.set(fill_index, (byte)1);
                ++fill_index;
            }
            fill_index += 2;
        }
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = 0; i < LINE_SPEED.length; ++i) {
                    if (this.bCurUpdate % LINE_SPEED[i] != 0) continue;
                    this.cycleLine(i);
                }
                this.checkCollision();
                this.bCurUpdate = this.bCurUpdate != 3 ? (byte)(this.bCurUpdate + 1) : (byte)1;
            }
        }
    }

    private void cycleLine(int index) {
        if (index % 2 == 0) {
            int first = (9 + 2 * index) * 10;
            int last = first + 10;
            byte temp = GameField.get(first);
            for (int i = first + 1; i < last; ++i) {
                if (i == this.figure_pos[0]) {
                    GameField.set(i - 1, (byte)0);
                }
                GameField.set(i - 1, GameField.get(i));
            }
            GameField.set(last - 1, temp);
        } else {
            int first = (9 + 2 * index) * 10 + 9;
            int last = first - 10;
            byte temp = GameField.get(first);
            for (int i = first - 1; i > last; --i) {
                if (i == this.figure_pos[0]) {
                    GameField.set(i + 1, (byte)0);
                }
                GameField.set(i + 1, GameField.get(i));
            }
            GameField.set(last + 1, temp);
        }
    }

    public boolean updateEvent() {
        if (E.kStates[7] && !this.active) {
            this.active = true;
        }
        if (this.active && this.bShowCollision == 0) {
            if (E.kStates[6]) {
                E.kStates[6] = false;
                if (this.figure_pos[0] % 10 != 0) {
                    this.figure_pos[0] = this.figure_pos[0] - 1;
                    this.checkCollision();
                }
            } else if (E.kStates[8]) {
                E.kStates[8] = false;
                if (this.figure_pos[0] % 10 != 9) {
                    this.figure_pos[0] = this.figure_pos[0] + 1;
                    this.checkCollision();
                }
            } else if (E.kStates[4]) {
                E.kStates[4] = false;
                this.figure_pos[0] = this.figure_pos[0] - 20;
                this.checkCollision();
                if (this.bShowCollision == 0) {
                    this.checkIfLast();
                }
            } else if (E.kStates[10]) {
                E.kStates[10] = false;
                if (this.figure_pos[0] / 10 != 19) {
                    this.figure_pos[0] = this.figure_pos[0] + 20;
                    this.checkCollision();
                }
            }
        }
        return false;
    }

    private final void checkIfLast() {
        if (this.figure_pos[0] / 10 < 8) {
            this.bBricksPlaced = (byte)(this.bBricksPlaced + 1);
            this.iBriksPlacedPos[this.bBricksPlaced - 1] = this.figure_pos[0];
            GameField.set(this.figure_pos[0], (byte)1);
            this.figure_pos[0] = 190 + GUtillMath.rnd(10);
            this.score += 100;
            this.checkVictory();
        }
    }

    private final void checkVictory() {
        if (this.bBricksPlaced == 10) {
            this.bBricksPlaced = 0;
            this.gameup = true;
            this.placePlayer();
        }
    }

    private final void showCollision() {
        int i = 0;
        int collision_pos = (this.figure_pos[0] / 10 > 16 ? 16 : this.figure_pos[0] / 10) * 10 + (this.figure_pos[0] % 10 > 6 ? 6 : this.figure_pos[0] % 10);
        this.figure_elem[0] = 0;
        for (i = 0; i < COLLISION_FIGURE.length; ++i) {
            GameField.set(collision_pos + COLLISION_FIGURE[i], (byte)2);
        }
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 1, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 2, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 10, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 20, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 13, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 23, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 31, (byte)0);
        GameField.set(collision_pos + COLLISION_FIGURE[0] + 32, (byte)0);
        this.bShowCollision = (byte)(this.bShowCollision + 1);
    }

    private final void checkCollision() {
        if (GameField.get(this.figure_pos[0]) == 1) {
            this.showCollision();
        }
    }
}

