/*
 * Decompiled with CFR 0.152.
 */
package xqwlight;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import xqwlight.Position;
import xqwlight.Search;
import xqwlight.XQWLight;

public class MainForm
extends Canvas
implements CommandListener {
    private static final int PHASE_STARTING = 0;
    private static final int PHASE_WAITING = 1;
    private static final int PHASE_THINKING = 2;
    private static final int PHASE_EXITTING = 3;
    private static Image imgBackground;
    private static Image imgThinking;
    private Image imgBoard;
    private static final String[] IMAGE_NAME;
    private static int widthBackground;
    private static int heightBackground;
    private static Font font;
    private static int fontWidth;
    private static int fontHeight;
    private XQWLight midlet;
    private Search search;
    private Image imgSelected;
    private Image imgSelected2;
    private Image imgCursor;
    private Image imgCursor2;
    private Image[] imgPieces = new Image[24];
    private int squareSize;
    private int squareShift;
    private int width;
    private int height;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int cursorX;
    private int cursorY;
    private int sqSelected;
    private int mvLast;
    private String message;
    private int phase;
    private Command cmdRetract;
    private Command cmdBack;

    static {
        String[] stringArray = new String[24];
        stringArray[9] = "rk";
        stringArray[10] = "ra";
        stringArray[11] = "rb";
        stringArray[12] = "rn";
        stringArray[13] = "rr";
        stringArray[14] = "rc";
        stringArray[15] = "rp";
        stringArray[17] = "bk";
        stringArray[18] = "ba";
        stringArray[19] = "bb";
        stringArray[20] = "bn";
        stringArray[21] = "br";
        stringArray[22] = "bc";
        stringArray[23] = "bp";
        IMAGE_NAME = stringArray;
        font = Font.getFont((int)0, (int)3, (int)16);
        fontWidth = font.charWidth('\u3000');
        fontHeight = font.getHeight();
        try {
            imgBackground = Image.createImage((String)"/images/background.png");
            imgThinking = Image.createImage((String)"/images/thinking.png");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        widthBackground = imgBackground.getWidth();
        heightBackground = imgBackground.getHeight();
    }

    public MainForm(XQWLight midlet) {
        this.midlet = midlet;
        this.search = new Search();
        this.search.pos = new Position();
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        String imagePath = "/images/";
        if (this.width >= 320 && this.height >= 356) {
            imagePath = String.valueOf(imagePath) + "large/";
            this.squareSize = 36;
            this.squareShift = 2;
        } else if (this.width >= 232 && this.height >= 258) {
            imagePath = String.valueOf(imagePath) + "medium/";
            this.squareSize = 26;
            this.squareShift = 1;
        } else {
            imagePath = String.valueOf(imagePath) + "small/";
            this.squareSize = 18;
            this.squareShift = 1;
        }
        try {
            this.imgBoard = Image.createImage((String)(String.valueOf(imagePath) + "board.png"));
            this.imgSelected = Image.createImage((String)(String.valueOf(imagePath) + "selected.png"));
            this.imgSelected2 = Image.createImage((String)(String.valueOf(imagePath) + "selected2.png"));
            this.imgCursor = Image.createImage((String)(String.valueOf(imagePath) + "cursor.png"));
            this.imgCursor2 = Image.createImage((String)(String.valueOf(imagePath) + "cursor2.png"));
            int pc = 0;
            while (pc < 24) {
                this.imgPieces[pc] = IMAGE_NAME[pc] == null ? null : Image.createImage((String)(String.valueOf(imagePath) + IMAGE_NAME[pc] + ".png"));
                ++pc;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        int boardWidth = this.imgBoard.getWidth();
        int boardHeight = this.imgBoard.getHeight();
        this.left = (this.width - boardWidth) / 2;
        this.top = (this.height - boardHeight) / 2;
        this.right = this.left + boardWidth - 32;
        this.bottom = this.top + boardHeight - 32;
        this.cmdBack = new Command("\u8fd4\u56de", 2, 1);
        this.addCommand(this.cmdBack);
        this.setCommandListener(this);
    }

    public void reset() {
        this.setFullScreenMode(true);
        this.search.pos.loadBoard(this.midlet.handicap);
        this.cursorY = 7;
        this.cursorX = 7;
        this.mvLast = 0;
        this.sqSelected = 0;
        this.phase = 0;
    }

    public void commandAction(Command c, Displayable d) {
        if ((this.phase == 1 || this.phase == 3) && c != this.cmdRetract && c == this.cmdBack) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.startUp);
        }
    }

    protected void paint(Graphics g) {
        if (this.phase == 0) {
            this.phase = 1;
            if (this.midlet.flipped) {
                this.responseMove();
                return;
            }
        }
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                g.drawImage(imgBackground, x, y, 20);
                y += heightBackground;
            }
            x += widthBackground;
        }
        g.drawImage(this.imgBoard, this.left, this.top, 20);
        int sq = 0;
        while (sq < 256) {
            byte pc;
            if (Position.IN_BOARD(sq) && (pc = this.search.pos.squares[sq]) > 0) {
                this.drawPiece(g, this.imgPieces[pc], sq);
            }
            ++sq;
        }
        int sqSrc = 0;
        int sqDst = 0;
        if (this.mvLast > 0) {
            sqSrc = Position.SRC(this.mvLast);
            sqDst = Position.DST(this.mvLast);
            this.drawPiece(g, (this.search.pos.squares[sqSrc] & 8) == 0 ? this.imgSelected : this.imgSelected2, sqSrc);
            this.drawPiece(g, (this.search.pos.squares[sqDst] & 8) == 0 ? this.imgSelected : this.imgSelected2, sqDst);
        } else if (this.sqSelected > 0) {
            this.drawPiece(g, (this.search.pos.squares[this.sqSelected] & 8) == 0 ? this.imgSelected : this.imgSelected2, this.sqSelected);
        }
        int sq2 = Position.COORD_XY(this.cursorX + 3, this.cursorY + 3);
        if (this.midlet.flipped) {
            sq2 = Position.SQUARE_FLIP(sq2);
        }
        if (sq2 == sqSrc || sq2 == sqDst || sq2 == this.sqSelected) {
            this.drawCursor(g, (this.search.pos.squares[sq2] & 8) == 0 ? this.imgCursor2 : this.imgCursor, sq2);
        } else {
            this.drawCursor(g, (this.search.pos.squares[sq2] & 8) == 0 ? this.imgCursor : this.imgCursor2, sq2);
        }
        if (this.phase == 2) {
            int y;
            int x2;
            if (this.midlet.flipped) {
                x2 = Position.FILE_X(sqDst) < 8 ? this.left : this.right;
                y = Position.RANK_Y(sqDst) < 8 ? this.top : this.bottom;
            } else {
                x2 = Position.FILE_X(sqDst) < 8 ? this.right : this.left;
                y = Position.RANK_Y(sqDst) < 8 ? this.bottom : this.top;
            }
            g.drawImage(imgThinking, x2, y, 20);
        } else if (this.phase == 3) {
            g.setFont(font);
            g.setColor(255);
            g.drawString(this.message, (this.width - this.message.length() * fontWidth) / 2, (this.height - fontHeight) / 2, 20);
        }
    }

    protected void keyPressed(int code) {
        if (this.phase == 3) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.startUp);
            return;
        }
        int deltaX = 0;
        int deltaY = 0;
        int action = this.getGameAction(code);
        if (action == 8 || code == 53) {
            byte pc;
            int sq = Position.COORD_XY(this.cursorX + 3, this.cursorY + 3);
            if (this.midlet.flipped) {
                sq = Position.SQUARE_FLIP(sq);
            }
            if (((pc = this.search.pos.squares[sq]) & Position.SIDE_TAG(this.search.pos.sdPlayer)) != 0) {
                this.mvLast = 0;
                this.sqSelected = sq;
            } else if (this.sqSelected > 0 && this.addMove(Position.MOVE(this.sqSelected, sq)) && !this.responseMove()) {
                this.mvLast = 0;
                this.phase = 3;
                this.repaint();
                this.serviceRepaints();
                return;
            }
        } else {
            block0 : switch (action) {
                case 1: {
                    deltaY = -1;
                    break;
                }
                case 2: {
                    deltaX = -1;
                    break;
                }
                case 5: {
                    deltaX = 1;
                    break;
                }
                case 6: {
                    deltaY = 1;
                    break;
                }
                default: {
                    switch (code) {
                        case 49: {
                            deltaX = -1;
                            deltaY = -1;
                            break block0;
                        }
                        case 50: {
                            deltaY = -1;
                            break block0;
                        }
                        case 51: {
                            deltaX = 1;
                            deltaY = -1;
                            break block0;
                        }
                        case 52: {
                            deltaX = -1;
                            break block0;
                        }
                        case 54: {
                            deltaX = 1;
                            break block0;
                        }
                        case 55: {
                            deltaX = -1;
                            deltaY = 1;
                            break block0;
                        }
                        case 56: {
                            deltaY = 1;
                            break block0;
                        }
                        case 57: {
                            deltaX = 1;
                            deltaY = 1;
                        }
                    }
                }
            }
            this.cursorX = (this.cursorX + deltaX + 9) % 9;
            this.cursorY = (this.cursorY + deltaY + 10) % 10;
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void drawCursor(Graphics g, Image image, int sq) {
        this.drawSquare(g, image, sq, true);
    }

    private void drawPiece(Graphics g, Image image, int sq) {
        this.drawSquare(g, image, sq, false);
    }

    private void drawSquare(Graphics g, Image image, int sq, boolean cursor) {
        int shift = cursor ? 0 : this.squareShift;
        int sqLocal = this.midlet.flipped ? Position.SQUARE_FLIP(sq) : sq;
        int sqX = this.left + (Position.FILE_X(sqLocal) - 3) * this.squareSize + shift;
        int sqY = this.top + (Position.RANK_Y(sqLocal) - 3) * this.squareSize + shift;
        g.drawImage(image, sqX, sqY, 20);
    }

    private boolean getResult(boolean computer) {
        if (this.search.pos.isMate()) {
            this.message = computer ? "\u8bf7\u518d\u63a5\u518d\u5389\uff01" : "\u795d\u8d3a\u4f60\u53d6\u5f97\u80dc\u5229\uff01";
            return true;
        }
        int vlRep = this.search.pos.repStatus(3);
        if (vlRep > 0) {
            int n = vlRep = computer ? -this.search.pos.repValue(vlRep) : this.search.pos.repValue(vlRep);
            this.message = vlRep > 900 ? "\u957f\u6253\u4f5c\u8d1f\uff0c\u8bf7\u4e0d\u8981\u6c14\u9981\uff01" : (vlRep < -900 ? "\u7535\u8111\u957f\u6253\u4f5c\u8d1f\uff0c\u795d\u8d3a\u4f60\u53d6\u5f97\u80dc\u5229\uff01" : "\u53cc\u65b9\u4e0d\u53d8\u4f5c\u548c\uff0c\u8f9b\u82e6\u4e86\uff01");
            return true;
        }
        if (this.search.pos.moveNum == 100) {
            this.message = "\u8d85\u8fc7\u81ea\u7136\u9650\u7740\u4f5c\u548c\uff0c\u8f9b\u82e6\u4e86\uff01";
            return true;
        }
        return false;
    }

    private boolean addMove(int mv) {
        if (this.search.pos.legalMove(mv)) {
            byte pc = this.search.pos.squares[Position.DST(mv)];
            if (this.search.pos.makeMove(mv)) {
                if (pc > 0) {
                    this.search.pos.setIrrev();
                }
                this.sqSelected = 0;
                this.mvLast = mv;
                return true;
            }
        }
        return false;
    }

    public boolean responseMove() {
        if (this.getResult(false)) {
            return false;
        }
        this.phase = 2;
        this.repaint();
        this.serviceRepaints();
        this.search.searchMain(1 << (this.midlet.level << 1));
        byte pc = this.search.pos.squares[Position.DST(this.search.mvResult)];
        this.search.pos.makeMove(this.search.mvResult);
        if (pc > 0) {
            this.search.pos.setIrrev();
        }
        this.mvLast = this.search.mvResult;
        int sq = Position.DST(this.mvLast);
        if (this.midlet.flipped) {
            sq = Position.SQUARE_FLIP(sq);
        }
        this.cursorX = Position.FILE_X(sq) - 3;
        this.cursorY = Position.RANK_Y(sq) - 3;
        this.phase = 1;
        this.repaint();
        this.serviceRepaints();
        return !this.getResult(true);
    }
}

