/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class LoadScene
extends Scene {
    private final byte LOAD_IN;
    private final byte LOAD_RES;
    public final byte LOAD_MAIN_MENU;
    public final byte LOAD_MAIN_GAME;
    public final byte LOAD_NEXT_MISSION = (byte)2;
    public final byte LOAD_GAME_OVER = (byte)3;
    private Scene out_scene = null;
    public byte out_scene_state = 0;
    private int load_tip = 0;
    private int load_line = 0;
    private final int loadtip_width;
    private final int loadtip_height;
    private boolean is_1stRun = true;
    private final int SQUARE_SIZE;
    private final int SQUARE_LINE;
    private final int SQUARE_COL;
    private final int SQUARE_ROW;
    private final int SQUARE_QUEUE;
    public boolean is_square_over = false;
    private boolean[][] square_state = new boolean[21][15];
    private int[][] square_size = new int[21][15];

    public LoadScene(MainCanvas mc) {
        super(mc);
        this.LOAD_IN = 0;
        this.LOAD_RES = 1;
        this.LOAD_MAIN_MENU = 0;
        this.LOAD_MAIN_GAME = 1;
        this.loadtip_width = 10;
        this.loadtip_height = 5;
        this.SQUARE_SIZE = 16;
        this.SQUARE_LINE = 21;
        this.SQUARE_COL = 15;
        this.SQUARE_ROW = 10;
        this.SQUARE_QUEUE = 7;
        this.resetLoadScene();
        this.load_line = 216;
    }

    public void resetLoadScene() {
        this.load_tip = 0;
        this.Scene_state = 0;
        this.out_scene = null;
    }

    public void render(Graphics g) {
        switch (this.Scene_state) {
            case 0: {
                this.square_draw_in(g);
                break;
            }
            case 1: {
                g.setColor(0xFFFFFF);
                GraphicsTool.restClip(g);
                g.drawString("\u52a0\u8f7d\u4e2d...", 120, 160, 17);
                GraphicsTool.fillRect(g, 12540432, 10, 299, 220, 7);
                GraphicsTool.fillRect(g, 16771717, 10, 300, 220, 5);
                GraphicsTool.fillRect(g, 0, 12, 301, 216, 3);
                GraphicsTool.fillRect(g, 15860740, 12, 301, this.load_tip, 3);
            }
        }
    }

    public void run() {
        switch (this.Scene_state) {
            case 0: {
                if (this.square_end_in()) {
                    this.Scene_state = 1;
                    break;
                }
                this.square();
                break;
            }
            case 1: {
                if (this.load_tip < this.load_line) {
                    this.loadScene();
                    break;
                }
                this.clearScene();
            }
        }
    }

    public void loadScene() {
        switch (this.out_scene_state) {
            case 0: {
                this.Scene_canvas.surface = new SurfaceScene(this.Scene_canvas);
                if (this.is_1stRun) {
                    SurfaceScene.is_flash = true;
                    this.is_1stRun = false;
                } else {
                    SurfaceScene.is_flash = false;
                }
                this.out_scene = this.Scene_canvas.surface;
                this.out_scene.loadScene();
                break;
            }
            case 1: {
                this.Scene_canvas.gs = new GameScene(this.Scene_canvas);
                this.out_scene = this.Scene_canvas.gs;
                this.out_scene.loadScene();
                break;
            }
            case 2: {
                this.out_scene = this.Scene_canvas.gs;
                this.out_scene.loadScene();
                this.refreshLoad(100);
                break;
            }
            case 3: {
                this.out_scene = this.Scene_canvas.gs;
                this.refreshLoad(100);
            }
        }
        this.square_init_out();
        this.refreshLoad(this.load_line);
    }

    public void clearScene() {
        this.Scene_canvas.scene = this.out_scene;
        this.out_scene = null;
        System.gc();
        MainCanvas.sleep();
    }

    public void refreshLoad(int tmp_tip) {
        this.load_tip = tmp_tip == this.load_line ? this.load_line : tmp_tip % this.load_line;
        this.Scene_canvas.refresh();
    }

    public void keyPressed(int key) {
    }

    public void keyReleased(int key) {
    }

    public void square_draw_in(Graphics g) {
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 15; ++j) {
                int n;
                if (!this.square_state[i][j]) continue;
                g.setColor(0);
                int[] nArray = this.square_size[i];
                if (this.square_size[i][j] >= 16) {
                    n = 16;
                } else {
                    int[] nArray2 = this.square_size[i];
                    int n2 = j;
                    n = nArray2[n2] = nArray2[n2] + 1;
                }
                nArray[j] = n;
                g.setClip(j * 16, i * 16, this.square_size[i][j], this.square_size[i][j]);
                g.fillRect(j * 16, i * 16, this.square_size[i][j], this.square_size[i][j]);
            }
        }
    }

    public void square_draw_out(Graphics g) {
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 15; ++j) {
                g.setColor(0);
                if (this.square_state[i][j]) {
                    int n;
                    int[] nArray = this.square_size[i];
                    if (this.square_size[i][j] <= 0) {
                        n = 0;
                    } else {
                        int[] nArray2 = this.square_size[i];
                        int n2 = j;
                        n = nArray2[n2] = nArray2[n2] - 1;
                    }
                    nArray[j] = n;
                }
                g.setClip(j * 16, i * 16, this.square_size[i][j], this.square_size[i][j]);
                g.fillRect(j * 16, i * 16, this.square_size[i][j], this.square_size[i][j]);
            }
        }
    }

    public void square_init_in() {
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.square_state[i][j] = false;
                this.square_size[i][j] = 0;
            }
        }
        this.is_square_over = false;
    }

    public void square_init_out() {
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.square_state[i][j] = false;
                this.square_size[i][j] = 16;
            }
        }
        this.is_square_over = false;
    }

    public boolean square_end_in() {
        return this.square_size[0][0] >= 16;
    }

    public boolean square_end_out() {
        return this.square_size[0][0] <= 0;
    }

    public void square() {
        if (this.is_square_over) {
            this.Scene_canvas.refresh(10);
        } else {
            int j;
            int i;
            for (i = 0; i <= 7; ++i) {
                this.square_state[10][7 - i] = true;
                this.square_state[10][7 + i] = true;
                this.square_state[10 - i][7] = true;
                this.square_state[10 + i][7] = true;
                for (j = i - 1; j > 0; --j) {
                    this.square_state[10 - j][7 - (i - j)] = true;
                    this.square_state[10 - j][7 + (i - j)] = true;
                    this.square_state[10 + j][7 - (i - j)] = true;
                    this.square_state[10 + j][7 + (i - j)] = true;
                }
                this.Scene_canvas.refresh(10);
            }
            for (i = 1; i <= 10; ++i) {
                for (j = 0; j <= 7; ++j) {
                    if (10 - i - j <= 0) {
                        this.square_state[0][j] = true;
                        this.square_state[0][14 - j] = true;
                    } else {
                        this.square_state[10 - i - j][j] = true;
                        this.square_state[10 - i - j][14 - j] = true;
                    }
                    if (10 + i + j >= 21) {
                        this.square_state[20][j] = true;
                        this.square_state[20][14 - j] = true;
                        continue;
                    }
                    this.square_state[10 + i + j][j] = true;
                    this.square_state[10 + i + j][14 - j] = true;
                }
                this.Scene_canvas.refresh(10);
            }
            this.is_square_over = true;
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }
}

