/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Util {
    public static final Random ran = new Random();
    public static Font font = Font.getFont((int)64, (int)0, (int)8);
    public static final byte INVERTED_AXES = 4;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TRANS_MIRROR_ROT270 = 4;

    public static final int getIntRandom(int min, int max) {
        int value = ran.nextInt() >>> 1;
        value = value % (max - min + 1) + min;
        return value;
    }

    public static final void drawImage(Graphics g, Image img, int x, int y, int w, int h, int offx, int offy) {
        g.setClip(x, y, w, h);
        g.drawImage(img, x + offx, y + offy, 0);
    }

    public static final Image loadImageUserDe(String binfile) {
        byte[] data;
        try {
            InputStream is = "".getClass().getResourceAsStream("/image/" + binfile + ".png");
            data = new byte[4];
            is.read(data);
            int value = data[0] << 24 & 0xFF000000;
            value |= data[1] << 16 & 0xFF0000;
            value |= data[2] << 8 & 0xFF00;
            value |= data[3] & 0xFF;
            data = new byte[value - 4];
            is.read(data, 0, data.length);
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception e) {
            byte[] data2 = null;
            e.printStackTrace();
            System.out.println("Load Data Error");
            System.gc();
            return null;
        }
        return Image.createImage((byte[])data, (int)0, (int)data.length);
    }

    public static final Image loadImage(String url) {
        try {
            return Image.createImage((String)("/image/" + url + ".png"));
        }
        catch (IOException e) {
            System.out.println("\u56fe\u7247\u88c5\u8f7d\u51fa\u9519\uff1a" + url);
            e.printStackTrace();
            return null;
        }
    }

    public static final Image loadImageAtOtherPackage(String url) {
        try {
            return Image.createImage((String)url);
        }
        catch (IOException e) {
            System.out.println("\u56fe\u7247\u88c5\u8f7d\u51fa\u9519\uff1a" + url);
            e.printStackTrace();
            return null;
        }
    }

    public static final void drawStroke(Graphics g, String str, int x, int y, int color1, int color2, int anchor) {
        g.setColor(color1);
        byte[] byArray = new byte[3];
        byArray[1] = 17;
        byArray[2] = 24;
        byte[] ANCHOR = byArray;
        g.drawSubstring(str, 0, str.length(), x - 1, y, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x + 1, y, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x, y - 1, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x, y + 1, (int)ANCHOR[anchor]);
        g.setColor(color2);
        g.drawSubstring(str, 0, str.length(), x, y, (int)ANCHOR[anchor]);
    }

    public static final void drawNumberL(Graphics g, int number, int x, int y, int cellW, int cellH, int offsetY, Image img) {
        String strScore = String.valueOf(number);
        int i = 0;
        while (i < strScore.length()) {
            g.setClip(x + cellW * i, y, cellW, cellH);
            g.drawImage(img, x + cellW * i - Integer.parseInt(String.valueOf(strScore.charAt(i))) * cellW, y + offsetY, 0);
            ++i;
        }
    }

    public static final void drawNumberM(Graphics g, int number, int x, int y, int cellW, int cellH, int offsetY, Image img) {
        String strScore = String.valueOf(number);
        int tWidth = strScore.length() * cellW;
        int i = 0;
        while (i < strScore.length()) {
            g.setClip(x + cellW * i - tWidth / 2, y, cellW, cellH);
            g.drawImage(img, x + cellW * i - tWidth / 2 - Integer.parseInt(String.valueOf(strScore.charAt(i))) * cellW, y + offsetY, 0);
            ++i;
        }
    }

    public static final void drawNumberR(Graphics g, int number, int x, int y, int cellW, int cellH, int offsetY, Image img) {
        String strScore = String.valueOf(number);
        int k = 0;
        int i = strScore.length() - 1;
        while (i >= 0) {
            g.setClip(x - cellW * k, y, cellW, cellH);
            g.drawImage(img, x - cellW * k - Integer.parseInt(String.valueOf(strScore.charAt(i))) * cellW, y + offsetY, 0);
            --i;
            ++k;
        }
    }

    public static final int sqrt(int value) {
        if (value == 0) {
            return 0;
        }
        int half = 0;
        int low = 1;
        int high = value >> 1;
        while (low + 1 < high) {
            int sum = low + high;
            half = sum >> 1;
            if (half * half < value) {
                low = half;
                continue;
            }
            if (half * half == value) {
                return half;
            }
            high = half;
        }
        return low;
    }

    public static final void drawCovering(Graphics g, int x, int y, int w, int h, int color, int alpha) {
        g.setClip(x, y, w, h);
        if (alpha == 0 || alpha > 255) {
            return;
        }
        int[] data = new int[w * h];
        int i = 0;
        while (i < data.length) {
            data[i] = color | alpha << 24;
            ++i;
        }
        g.drawRGB(data, 0, w, x, y, w, h, true);
    }

    public static final void debug(String text) {
    }

    public static final void debug(long value) {
    }

    public static final int abs(int value) {
        return value >= 0 ? value : -value;
    }

    public static final void drawText(Graphics g, String text, int width, int x, int y, int color1, int color2) {
        Font font = g.getFont();
        int length = text.length();
        int tempW = 0;
        int pos = 0;
        int lines = 0;
        int space = font.getHeight() + 4;
        int i = 0;
        while (i < length) {
            if ((tempW += font.stringWidth(text.substring(i, i + 1))) >= width || i == length - 1) {
                int count = i - pos;
                if (i == length - 1) {
                    ++count;
                }
                String sub = text.substring(pos, pos + count);
                Util.drawStroke(g, sub, x, y + space * lines, color1, color2, 0);
                pos = i;
                tempW = 0;
                ++lines;
            }
            ++i;
        }
    }

    public static final void drawText(Graphics g, String text, int width, int x, int y) {
        Font font = g.getFont();
        int length = text.length();
        int tempW = 0;
        int pos = 0;
        int lines = 0;
        int space = font.getHeight() + 4;
        int i = 0;
        while (i < length) {
            if ((tempW += font.stringWidth(text.substring(i, i + 1))) >= width || i == length - 1) {
                int count = i - pos;
                if (i == length - 1) {
                    ++count;
                }
                String sub = text.substring(pos, pos + count);
                tempW = font.stringWidth(sub);
                g.drawSubstring(sub, 0, sub.length(), x, y + space * lines, 0);
                pos = i;
                tempW = 0;
                ++lines;
            }
            ++i;
        }
    }

    public static final String loadText(String url) {
        InputStream is = "".getClass().getResourceAsStream(url);
        if (is == null) {
            return "";
        }
        try {
            byte[] array = new byte[is.available()];
            is.read(array);
            is.close();
            return new String(array, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static final String loadText(String adress, String enc) {
        String msg = null;
        try {
            InputStream is = "".getClass().getResourceAsStream(adress);
            byte[] temp = new byte[is.available()];
            is.read(temp);
            msg = enc != null ? new String(temp, enc) : new String(temp);
            is.close();
            is = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static final void drawMesh(Graphics g, int x, int y, int w, int h, int style) {
        int i = 0;
        g.setClip(x, y, w, h);
        g.translate(x, y);
        switch (style) {
            case 0: {
                i = 0;
                while (i < w / 2) {
                    g.drawLine(i * 2, 0, i * 2, h);
                    ++i;
                }
                i = 0;
                while (i < h / 2) {
                    g.drawLine(0, i * 2, w, i * 2);
                    ++i;
                }
                break;
            }
            case 1: {
                i = w / 2;
                while (i > 0) {
                    g.drawLine(i * 2, 0, 0, i * 2);
                    g.drawLine(w - i * 2, h, w, h - i * 2);
                    --i;
                }
                i = Math.abs(h - w) / 2;
                while (i > 0) {
                    g.drawLine(w, i * 2, 0, i * 2 + w);
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
    }

    public static final String[] cutMoreLines(String text, int width, Font font) {
        Vector<String> v = new Vector<String>();
        String[] str = null;
        int position = 0;
        int totalLen = text.length();
        int text_line = 0;
        int offsetW = 0;
        try {
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\r') {
                    ++i;
                }
                if (text.charAt(i) == '\n' || i == totalLen - 1) {
                    if (text.charAt(position) == ' ') {
                        ++position;
                    }
                    if (++text_line == 1 && text.charAt(0) == '\ufeff') {
                        ++position;
                    }
                    int wordEnd = i - 1;
                    wordEnd = text.charAt(i) != '\n' ? i + 1 : i - 1;
                    String sub = text.substring(position, wordEnd);
                    int lenth = sub.length();
                    while (!sub.equals("")) {
                        int substrWidth = font.substringWidth(sub, 0, lenth);
                        if (substrWidth > width + offsetW) {
                            int n = (substrWidth - (width + offsetW)) / font.stringWidth("\u5bbd");
                            if (n > 0) {
                                lenth -= n;
                                continue;
                            }
                            --lenth;
                            continue;
                        }
                        offsetW = 0;
                        v.addElement(sub.substring(0, lenth));
                        sub = sub.substring(lenth, sub.length());
                        lenth = sub.length();
                    }
                    position = i + 1;
                }
                ++i;
            }
            str = new String[v.size()];
            i = 0;
            while (i < str.length) {
                str[i] = (String)v.elementAt(i);
                ++i;
            }
            v = null;
        }
        catch (Exception e) {
            System.out.println("Load_cutMoreLines error.........." + e);
        }
        return str;
    }

    public static final Image getRegionImageMIDP1_0(Image img, int tile_x, int tile_y, int tile_w, int tile_h, int transform, int x, int y, int anchor) {
        int[] data = new int[tile_w * tile_h];
        img.getRGB(data, 0, tile_w, x, y, tile_w, tile_h);
        int i = 0;
        while (i < tile_h) {
            int j = 0;
            while (j < tile_w / 2) {
                int temp = data[j + i * tile_w];
                data[j + i * tile_w] = data[tile_w - 1 - j + i * tile_w];
                data[tile_w - 1 - j + i * tile_w] = temp;
                ++j;
            }
            ++i;
        }
        return Image.createRGBImage((int[])data, (int)tile_w, (int)tile_h, (boolean)true);
    }

    public static final void createCutImage() {
    }
}

