/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class _ClientPay
implements _Config,
Runnable {
    public static final byte CP_CLEW_MENU = 1;
    public static final byte CP_SENDING = 2;
    public static final byte CP_SEND_SUCCESS = 3;
    public static final byte CP_SEND_FAIL = 4;
    public static final byte CP_SEND_FAIL_MORE = 5;
    public static final byte CP_SEND_CANCEL = 6;
    public static final byte CP_DICTATE_PORT_ERROR = 7;
    public static int SCREEN_W;
    public static int SCREEN_H;
    public static byte CURRENT_STATE;
    public static boolean POP_CLEW_MENU;
    public static byte needSendCount;
    public static byte sentCount;
    public static byte eachCost;
    public static int totalCost;
    public static boolean updateClewWords;
    public static String strClewWords;
    public static String showClewWords;
    public static String[] showLines;
    public static String saveName;
    public static final byte NONE_PAY = -1;
    public static final byte ONE_PAY = 0;
    public static final byte PROPS_PAY = 1;
    public static byte payMode;
    public static Font font;
    private static int isConsumeTime;
    private static String preName;
    private static long startTime;
    private static int value;
    private static int isColorA;
    private static int isColorB;

    static {
        CURRENT_STATE = 1;
        POP_CLEW_MENU = false;
        needSendCount = 0;
        sentCount = 0;
        eachCost = 0;
        totalCost = 0;
        updateClewWords = true;
        strClewWords = null;
        showClewWords = null;
        showLines = null;
        saveName = "OnePay";
        payMode = (byte)-1;
        font = Util.font;
        isConsumeTime = 60;
        preName = "";
        startTime = -1L;
        value = 0;
    }

    public static final void init() {
        _ClientPay.deleteAllRMS();
        SCREEN_W = 240;
        SCREEN_H = 320;
    }

    public static final void deleteAllRMS() {
        String str = System.getProperty("microedition.platform");
        if (str.equals("SunMicrosystems_wtk")) {
            String[] name = RecordStore.listRecordStores();
            if (name == null) {
                return;
            }
            int i = 0;
            while (i < name.length) {
                try {
                    RecordStore.deleteRecordStore((String)name[i]);
                    System.out.println(String.valueOf(name[i]) + "\u8bb0\u5f55\u5df2\u88ab\u5220\u9664");
                }
                catch (RecordStoreNotFoundException e) {
                    e.printStackTrace();
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static final void loadFile(String index, String clew) {
        if (preName == index) {
            return;
        }
        preName = index;
        String content = Util.loadText(index);
        String[] lines = Util.cutMoreLines(content, 1000, Font.getDefaultFont());
        String port = _ClientPay.decode(lines[0]);
        String dictate = _ClientPay.decode(lines[1]);
        System.out.println("PORT = " + port + " DICTATE = " + dictate);
        needSendCount = (byte)Integer.parseInt(_ClientPay.decode(lines[2]));
        eachCost = (byte)Integer.parseInt(_ClientPay.decode(lines[3]));
        System.out.println("needSendCount = " + needSendCount + " eachCost = " + eachCost);
        IsSMSPay.setPortDictate(port, dictate);
        totalCost = needSendCount * eachCost;
        strClewWords = Util.loadText(clew);
        updateClewWords = true;
    }

    public static final void setPayMode(byte mode, String sName) {
        if (payMode == mode && saveName == sName) {
            return;
        }
        payMode = mode;
        _ClientPay.setSaveName(sName);
        switch (payMode) {
            case 0: {
                _ClientPay.loadFile("/index.class_", "/one_pay.txt");
                break;
            }
            case 1: {
                _ClientPay.loadFile("/index2.class_", "/props_pay.txt");
            }
        }
    }

    public static final String parsePayClew(String str) {
        int index;
        char c = str.charAt(0);
        if (c == '\ufeff') {
            str = str.substring(1, str.length());
        }
        if ((index = str.indexOf("NSC")) != -1) {
            str = String.valueOf(str.substring(0, index)) + needSendCount + str.substring(index + 3, str.length());
        }
        if ((index = str.indexOf("StC")) != -1) {
            str = String.valueOf(str.substring(0, index)) + sentCount + str.substring(index + 3, str.length());
        }
        if ((index = str.indexOf("EC")) != -1) {
            str = String.valueOf(str.substring(0, index)) + eachCost + str.substring(index + 2, str.length());
        }
        if ((index = str.indexOf("TC")) != -1) {
            str = String.valueOf(str.substring(0, index)) + totalCost + str.substring(index + 2, str.length());
        }
        Util.debug(str);
        return str;
    }

    protected static final boolean paint(Graphics g) {
        if (!POP_CLEW_MENU) {
            return false;
        }
        switch (CURRENT_STATE) {
            case 1: {
                _ClientPay.menuClewMenu(g);
                break;
            }
            case 2: {
                _ClientPay.menuSending(g);
                break;
            }
            case 4: {
                _ClientPay.menuSendFail(g);
                break;
            }
            case 5: {
                _ClientPay.menuSendFailMore(g);
                break;
            }
            case 3: {
                _ClientPay.menuSendSuccess(g);
                break;
            }
            case 6: {
                _ClientPay.menuUserCancel(g);
                break;
            }
            case 7: {
                _ClientPay.clewPortDictError(g);
            }
        }
        return POP_CLEW_MENU;
    }

    protected static final boolean keyPressed(int keyCode) {
        if (!POP_CLEW_MENU) {
            return false;
        }
        switch (CURRENT_STATE) {
            case 1: {
                _ClientPay.keyClewMenu(keyCode);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                _ClientPay.keySendFail(keyCode);
                break;
            }
            case 5: {
                _ClientPay.keySendFailMore(keyCode);
                break;
            }
            case 3: {
                _ClientPay.keySendSuccess(keyCode);
                break;
            }
            case 6: {
                _ClientPay.keyUserCancel(keyCode);
                break;
            }
            case 7: {
                _ClientPay.keyClewPortDictError(keyCode);
            }
        }
        return true;
    }

    public static final boolean checkPayTime() {
        if (isConsumeTime <= 0) {
            return true;
        }
        if (startTime == -1L) {
            startTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - startTime >= 1000L) {
            startTime = -1L;
            System.out.println(--isConsumeTime);
            if (isConsumeTime <= 0) {
                startTime = -1L;
                _ClientPay.saveConsumeTime();
                return true;
            }
        }
        return false;
    }

    public static final void checkPayKey(int keyCode, String name) {
        if (_ClientPay.checkPayTime()) {
            _ClientPay.setSaveName(name);
            if (!_ClientPay.checkPayState()) {
                return;
            }
        }
    }

    public static final void saveConsumeTime() {
        IsSMSPay.saveDataToRMS("time", String.valueOf(isConsumeTime).getBytes());
    }

    public static final void readConsumeTime() {
        DataInputStream dos = IsSMSPay.readDataFromRMS("time");
        try {
            if (dos != null) {
                byte[] arr = new byte[dos.available()];
                dos.read(arr);
                isConsumeTime = Integer.parseInt(new String(arr));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final boolean checkPayState() {
        byte state = IsSMSPay.getPayState(saveName);
        if (state == needSendCount) {
            return true;
        }
        sentCount = state;
        POP_CLEW_MENU = true;
        return false;
    }

    public static final boolean justCheckState() {
        byte state = IsSMSPay.getPayState(saveName);
        return state == needSendCount;
    }

    public static final void setSaveName(String name) {
        saveName = name;
    }

    public static final String getSaveName() {
        return saveName;
    }

    private static final void menuClewMenu(Graphics g) {
        g.setColor(0xFFFFFF);
        g.setStrokeStyle(0);
        Util.drawMesh(g, 0, 0, SCREEN_W, SCREEN_H, 1);
        g.setColor(16493811);
        if (updateClewWords) {
            totalCost = eachCost * needSendCount;
            showClewWords = _ClientPay.parsePayClew(strClewWords);
            showLines = Util.cutMoreLines(showClewWords, SCREEN_W - 20, Util.font);
            updateClewWords = false;
        }
        int i = 0;
        while (i < showLines.length) {
            Util.drawStroke(g, showLines[i], SCREEN_W - font.stringWidth(showLines[i]) >> 1, i * 25 + (SCREEN_H - showLines.length * 25 >> 1), 0, 0xFFFFFF, 0);
            ++i;
        }
        Util.drawStroke(g, "\u53d1\u9001", 3, SCREEN_H - 23, 0, 0xFFFFFF, 0);
        Util.drawStroke(g, "\u9000\u51fa", SCREEN_W - 3 - font.stringWidth("\u9000\u51fa"), SCREEN_H - 23, 0, 0xFFFFFF, 0);
    }

    private static final void menuSending(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        g.drawString("\u6b63\u5728\u53d1\u9001\u4fe1\u606f...", SCREEN_W / 2, SCREEN_H / 2 - 8, 17);
        _ClientPay.schedule(g, value, (SCREEN_W - 100) / 2, SCREEN_H - 10, 100, 5, 0xFFFFFF, 15896053, 0xFF0000);
        ++value;
    }

    private static final void schedule(Graphics g, int value, int x, int y, int lenW, int lenH, int color1, int color2, int color3) {
        _ClientPay.value = value = value > lenW ? 0 : value;
        g.setColor(0xFFFFF0);
        g.fillRect(x, y, lenW, 4);
        g.setColor(color1);
        g.fillRect(x, y, lenW, 4);
        g.setColor(color2);
        g.drawRect(x, y, lenW, 4);
        g.setColor(color3);
        g.fillRect(x + 2, y + 2, value - 3, 1);
    }

    private static final void menuSendFail(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        g.drawString("\u53d1\u9001\u5931\u8d25", SCREEN_W / 2, SCREEN_H / 2 - g.getFont().getHeight() / 2, 17);
        g.drawString("\u66f4\u591a", 2, SCREEN_H - 2, 36);
        g.drawString("\u8fd4\u56de", SCREEN_W - 2, SCREEN_H - 2, 40);
    }

    private static final void menuSendFailMore(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        String content = "\u5bfc\u81f4\u53d1\u9001\u5931\u8d25\u7684\u539f\u56e0\u6709\u53ef\u80fd\u662f:\u624b\u673a\u5361\u8fc7\u671f,\u975e\u79fb\u52a8\u7684\u7535\u8bdd\u5361,\u6216\u4f59\u989d\u4e0d\u8db3\u8ba2\u8d2d\u8d39\u7528,\u60a8\u53ef\u4ee5\u8054\u7cfb\u5ba2\u670d\u54a8\u8be2.";
        _ClientPay.drawText(g, content, SCREEN_W - 20);
        g.drawString("\u8fd4\u56de", SCREEN_W - 2, SCREEN_H - 2, 40);
    }

    private static final void menuUserCancel(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        String text = "\u7531\u4e8e\u60a8\u53d6\u6d88\u4e86\u53d1\u9001\u4fe1\u606f,\u4e0e\u76ee\u6807\u7aef\u53e3\u5931\u53bb\u8fde\u63a5,\u5982\u679c\u60a8\u60f3\u4ed8\u8d39\u9700\u8981\u91cd\u65b0\u542f\u52a8\u4e00\u6b21\u6e38\u620f!";
        _ClientPay.drawText(g, text, SCREEN_W - 20);
        g.drawString("\u8fd4\u56de", SCREEN_W - 2, SCREEN_H - 2, 40);
    }

    private static final void menuSendSuccess(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        g.drawString("\u53d1\u9001\u6210\u529f", SCREEN_W / 2, SCREEN_H / 2, 17);
        g.drawString("\u8fd4\u56de", SCREEN_W - 2, SCREEN_H - 2, 40);
    }

    private static final void clewPortDictError(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, SCREEN_W, SCREEN_H);
        g.fillRect(0, 0, SCREEN_W, SCREEN_H);
        g.setColor(0xFFFFFF);
        totalCost = eachCost * needSendCount;
        strClewWords = "\u6587\u672c\u4e2d\u7684\u6307\u4ee4\u53ca\u7aef\u53e3\u88ab\u4fee\u6539,\u5bfc\u81f4\u65e0\u6cd5\u4ed8\u8d39,\u8bf7\u52a1\u5fc5\u8fd8\u539f\u6587\u672c\u4e2d\u7684\u5185\u5bb9,\u591a\u8c22\u60a8\u7684\u5408\u4f5c!";
        _ClientPay.drawText(g, strClewWords, SCREEN_W - 20);
        g.drawString("\u8fd4\u56de", SCREEN_W - 2, SCREEN_H - 2, 40);
    }

    public static final void isSendSms() {
        if (IsSMSPay.checkPort("\u5bc6\u6587\u4e0d\u5bf9,\u8bf7\u66f4\u6b63")) {
            CURRENT_STATE = (byte)7;
            return;
        }
        if (IsSMSPay.checkDictate("\u5bc6\u6587\u4e0d\u5bf9,\u8bf7\u66f4\u6b63")) {
            CURRENT_STATE = (byte)7;
            return;
        }
        CURRENT_STATE = (byte)2;
        new Thread(new _ClientPay()).start();
    }

    public final void run() {
        byte result = IsSMSPay.sendMessage();
        switch (result) {
            case 0: {
                sentCount = (byte)(sentCount + 1);
                IsSMSPay.savePayState(saveName, sentCount);
                byte state = IsSMSPay.getPayState(saveName);
                if (state == needSendCount) {
                    CURRENT_STATE = (byte)3;
                    if (payMode == 1) {
                        IsSMSPay.deleteRecordStore(saveName);
                    }
                } else {
                    CURRENT_STATE = 1;
                }
                updateClewWords = true;
                break;
            }
            case 1: {
                CURRENT_STATE = (byte)4;
                break;
            }
            case 2: {
                CURRENT_STATE = (byte)6;
            }
        }
    }

    private static final void keyClewMenu(int keyCode) {
        switch (keyCode) {
            case -6: {
                _ClientPay.isSendSms();
                break;
            }
            case -7: {
                _ClientPay.backToGame();
            }
        }
    }

    private static final void keySendFail(int keyCode) {
        if (keyCode == -6) {
            CURRENT_STATE = (byte)5;
        }
        if (keyCode == -7) {
            CURRENT_STATE = 1;
        }
    }

    private static final void keySendFailMore(int keyCode) {
        switch (keyCode) {
            case -7: {
                CURRENT_STATE = 1;
            }
        }
    }

    private static final void keyUserCancel(int keyCode) {
        if (keyCode == -7) {
            CURRENT_STATE = 1;
        }
    }

    private static final void keySendSuccess(int keyCode) {
        if (keyCode == -7) {
            _ClientPay.backToGame();
        }
    }

    private static final void keyClewPortDictError(int keyCode) {
        if (keyCode == -7) {
            CURRENT_STATE = 1;
        }
    }

    private static final void backToGame() {
        CURRENT_STATE = 1;
        POP_CLEW_MENU = false;
    }

    public static final void drawText(Graphics g, String text, int width) {
        Font font = g.getFont();
        int length = text.length();
        int tempW = 0;
        int pos = 0;
        int lines = 0;
        int toLines = font.stringWidth(text) / width + 1;
        int space = font.getHeight() + 4;
        int i = 0;
        while (i < length) {
            if ((tempW += font.stringWidth(text.substring(i, i + 1))) >= width || i == length - 1) {
                int count = i - pos;
                if (i == length - 1) {
                    ++count;
                }
                String sub = text.substring(pos, pos + count);
                tempW = font.stringWidth(sub);
                g.drawSubstring(sub, 0, sub.length(), SCREEN_W - tempW >> 1, (SCREEN_H - toLines * space >> 1) + space * lines, 0);
                pos = i;
                tempW = 0;
                ++lines;
            }
            ++i;
        }
    }

    public static final void setColor(int isColorA, int isColorB) {
        _ClientPay.isColorA = isColorA;
        _ClientPay.isColorA = isColorA;
    }

    public static final void drawSubString(Graphics g, String str, int x, int y, int anchor) {
        g.setColor(isColorA);
        byte[] byArray = new byte[3];
        byArray[1] = 17;
        byArray[2] = 24;
        byte[] ANCHOR = byArray;
        g.drawSubstring(str, 0, str.length(), x - 1, y, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x + 1, y, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x, y - 1, (int)ANCHOR[anchor]);
        g.drawSubstring(str, 0, str.length(), x, y + 1, (int)ANCHOR[anchor]);
        g.setColor(isColorB);
        g.drawSubstring(str, 0, str.length(), x, y, (int)ANCHOR[anchor]);
    }

    public static final String decode(String cipher) {
        if (cipher.equals("")) {
            return "";
        }
        byte[] array = null;
        try {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < cipher.length()) {
                sb.append(cipher.charAt(i) - 33);
                ++i;
            }
            cipher = sb.toString();
            int totalLen = cipher.length();
            int value = Integer.parseInt(cipher.substring(totalLen - 5, totalLen));
            String type = cipher.substring(totalLen - 5 - value, totalLen - 5);
            String byteCode = cipher.substring(0, totalLen - 5 - value);
            array = new byte[type.length() >> 1];
            int bFlag = 0;
            int pos = 0;
            int i2 = 0;
            while (i2 < type.length()) {
                byte bCode;
                int num;
                int isType = Integer.parseInt(String.valueOf(type.charAt(i2)));
                if (isType == 0) {
                    num = Integer.parseInt(String.valueOf(type.charAt(++i2)));
                    bCode = (byte)Integer.parseInt(byteCode.substring(pos, pos + num));
                    pos += num;
                    array[bFlag++] = -bCode;
                } else {
                    num = Integer.parseInt(String.valueOf(type.charAt(++i2)));
                    bCode = (byte)Integer.parseInt(byteCode.substring(pos, pos + num));
                    pos += num;
                    array[bFlag++] = bCode;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            return "\u5bc6\u6587\u4e0d\u5bf9,\u8bf7\u66f4\u6b63";
        }
        return new String(array);
    }
}

