/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.ActionAdapter;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Button;
import com.jarbull.efw.ui.BuyText;
import com.jarbull.efw.ui.ImageView;
import com.jarbull.efw.ui.Layout;
import com.jarbull.efw.ui.ProgressBar;
import com.jarbull.efw.ui.Screen;
import com.jarbull.efw.ui.ScreenHolder;

class ScreenFactory {
    private ScreenFactory() {
    }

    public static Screen createLoadingScreen() {
        Screen screen = new Screen("loadingscreen");
        Layout layout = new Layout();
        layout.setType(2);
        screen.setLayout(layout);
        ProgressBar progressBar = new ProgressBar("loading_bar");
        progressBar.setColorMode(100);
        screen.addChild(progressBar);
        ScreenHolder.getInstance().addScreen(screen, false);
        return screen;
    }

    public static Screen createDemoIntroScreen() {
        Screen screen = new Screen("demointro");
        screen.setWriterType(2);
        Layout layout = new Layout();
        layout.setType(2);
        layout.setArea(0, ResolutionHandler.getInstance().getCurrentHeight() / 2, ResolutionHandler.getInstance().getCurrentWidth(), ResolutionHandler.getInstance().getCurrentHeight() / 3);
        screen.setLayout(layout);
        ImageView jarbull = new ImageView("logo", "/res/jarbull.png");
        jarbull.setBorderSize(0);
        jarbull.setSize(ResolutionHandler.getInstance().getCurrentWidth(), jarbull.getHeight());
        jarbull.setAutoPos(false);
        jarbull.setPosition(0, ResolutionHandler.getInstance().getCurrentHeight() / 3);
        screen.addChild(jarbull);
        Button buyButton = new Button("buy");
        buyButton.setSize(buyButton.getWidth() * 3 / 2, buyButton.getHeight());
        buyButton.setText(EMidlet.getInstance().getProperties().getBuyGame());
        buyButton.setSelectedBgColor(0x800000);
        buyButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                ScreenFactory.createActivationScreen();
                ScreenHolder.getInstance().setActiveScreenId("activationscreen");
            }
        });
        screen.addChild(buyButton);
        Button playButton = new Button("play");
        playButton.setSize(playButton.getWidth() * 3 / 2, playButton.getHeight());
        playButton.setText(EMidlet.getInstance().getProperties().getBuyPlayDemo());
        playButton.setSelectedBgColor(0x800000);
        playButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                ScreenHolder.getInstance().setActiveScreenId("intro");
            }
        });
        screen.addChild(playButton);
        Button quitButton = new Button("quit");
        quitButton.setSize(quitButton.getWidth() * 3 / 2, quitButton.getHeight());
        quitButton.setText(EMidlet.getInstance().getProperties().getBuyQuit());
        quitButton.setSelectedBgColor(0x800000);
        quitButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                Action action = new Action(this, "EXIT", null);
                action.doAction();
            }
        });
        screen.addChild(quitButton);
        ScreenHolder.getInstance().addScreen(screen, true);
        return screen;
    }

    public static Screen createActivationScreen() {
        Screen screen = new Screen("activationscreen");
        screen.setWriterType(2);
        screen.setActionListener(new ActionAdapter(){

            public void onShown() {
                Action setSelected = new Action(this, "SETSELECTED", "activationscreen|continue");
                setSelected.doAction();
            }
        });
        Layout layout = new Layout();
        layout.setType(2);
        screen.setLayout(layout);
        ImageView jarbull = new ImageView("logo", "/res/jarbull.png");
        jarbull.setBorderSize(0);
        jarbull.setSize(ResolutionHandler.getInstance().getCurrentWidth(), jarbull.getHeight());
        screen.addChild(jarbull);
        BuyText nameLabel = new BuyText("name");
        nameLabel.setText(EMidlet.getInstance().getProperties().getGameName());
        nameLabel.setSize(ResolutionHandler.getInstance().getCurrentWidth(), TextWriter.getInstance().getTextHeight(EMidlet.getInstance().getProperties().getGameName()));
        nameLabel.setBgColor(-1);
        nameLabel.setFgColor(0xFFFFFF);
        nameLabel.setBorderSize(0);
        screen.addChild(nameLabel);
        Button continueButton = new Button("continue");
        continueButton.setText(EMidlet.getInstance().getProperties().getBuyContinue());
        continueButton.setBgColor(-1);
        continueButton.setSelectedBgColor(0x800000);
        continueButton.setFgColor(0xFFFFFF);
        continueButton.setBorderSize(0);
        continueButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                Action action = new Action(this, "BUY", null);
                action.doAction();
            }
        });
        screen.addChild(continueButton);
        BuyText desc1Label = new BuyText("desc1");
        desc1Label.setText(EMidlet.getInstance().getProperties().getBuyDesc());
        desc1Label.setSize(ResolutionHandler.getInstance().getCurrentWidth() - 20, ResolutionHandler.getInstance().getCurrentHeight() / 4);
        desc1Label.setBgColor(-1);
        desc1Label.setFgColor(0xFFFFFF);
        desc1Label.setBorderSize(0);
        screen.addChild(desc1Label);
        BuyText priceLabel = new BuyText("price");
        priceLabel.setText(EMidlet.getInstance().getProperties().getBuyPrice());
        priceLabel.setSize(ResolutionHandler.getInstance().getCurrentWidth(), 40);
        priceLabel.setBgColor(-1);
        priceLabel.setFgColor(0xFFFFFF);
        priceLabel.setBorderSize(0);
        screen.addChild(priceLabel);
        Button quitButton = new Button("quit");
        quitButton.setAutoPos(false);
        quitButton.setText(EMidlet.getInstance().getProperties().getBuyQuit());
        quitButton.setBgColor(-1);
        quitButton.setSelectedBgColor(0x800000);
        quitButton.setFgColor(0xFFFFFF);
        quitButton.setPosition(ResolutionHandler.getInstance().getCurrentWidth() - quitButton.getWidth(), ResolutionHandler.getInstance().getCurrentHeight() - quitButton.getHeight());
        quitButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                Action action = new Action(this, "EXIT", null);
                action.doAction();
            }
        });
        screen.addChild(quitButton);
        ScreenHolder.getInstance().addScreen(screen, true);
        return screen;
    }

    public static Screen createActivatedScreen(final boolean activated) {
        Screen screen = new Screen("activatedscreen");
        screen.setWriterType(2);
        Layout layout = new Layout();
        layout.setType(2);
        screen.setLayout(layout);
        ImageView jarbull = new ImageView("logo", "/res/jarbull.png");
        jarbull.setBorderSize(0);
        screen.addChild(jarbull);
        BuyText label = new BuyText("activatedlabel");
        label.setText(activated ? EMidlet.getInstance().getProperties().getBuySuccess() : EMidlet.getInstance().getProperties().getBuyFail());
        label.setSize(ResolutionHandler.getInstance().getCurrentWidth() - 20, activated ? 30 : 100);
        label.setBgColor(-1);
        label.setFgColor(0xFFFFFF);
        label.setBorderSize(0);
        screen.addChild(label);
        if (activated) {
            BuyText label2 = new BuyText("activatedlabel2");
            label2.setText(EMidlet.getInstance().getProperties().getBuySuccess2());
            label2.setSize(ResolutionHandler.getInstance().getCurrentWidth() - 20, 60);
            label2.setBgColor(-1);
            label2.setFgColor(0xFFFFFF);
            label2.setBorderSize(0);
            screen.addChild(label2);
        }
        Button okButton = new Button("startgame");
        okButton.setText(EMidlet.getInstance().getProperties().getBuyOK());
        okButton.setBgColor(-1);
        okButton.setSelectedBgColor(0x800000);
        okButton.setFgColor(0xFFFFFF);
        okButton.setActionListener(new ActionAdapter(){

            public void actionPerformed() {
                Action action = new Action(this, "CHANGESCREENTO", activated ? "intro" : "activationscreen");
                action.doAction();
                ScreenHolder.getInstance().removeScreen("activatedscreen");
                if (activated) {
                    ScreenHolder.getInstance().removeScreen("activationscreen");
                }
            }
        });
        screen.addChild(okButton);
        if (activated) {
            BuyText label3 = new BuyText("activatedlabel3");
            label3.setText(EMidlet.getInstance().getProperties().getBuySuccess3());
            label3.setSize(ResolutionHandler.getInstance().getCurrentWidth() - 20, 40);
            label3.setBgColor(-1);
            label3.setFgColor(0xFFFFFF);
            label3.setBorderSize(0);
            screen.addChild(label3);
        }
        ScreenHolder.getInstance().addScreen(screen, true);
        return screen;
    }
}

