/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.connection.HTTPConnection;
import com.jarbull.efw.connection.ISmsListener;
import com.jarbull.efw.connection.SmsSender;
import com.jarbull.efw.controller.Animation;
import com.jarbull.efw.controller.AnimationHolder;
import com.jarbull.efw.controller.IMemoryListener;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.SoundHandler;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.io.RecordHandler;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.manager.GameModeHandler;
import com.jarbull.efw.manager.GameXmlReader;
import com.jarbull.efw.manager.InternalProcessor;
import com.jarbull.efw.manager.ScreenFactory;
import com.jarbull.efw.manager.Settings;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Button;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import com.jarbull.efw.ui.Label;
import com.jarbull.efw.ui.OptionButton;
import com.jarbull.efw.ui.ProgressBar;
import com.jarbull.efw.ui.Screen;
import com.jarbull.efw.ui.ScreenHolder;
import com.jarbull.efw.ui.TextBox;
import com.jarbull.efw.util.Debug;
import com.jarbull.efw.util.StringEx;
import com.jarbull.efw.util.TEA;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Image;

public class Action {
    private static final Hashtable ACTIONS = new Hashtable();
    Object sender;
    String action;
    String param;
    boolean enabled;

    public Action(Object sender, String action, String param) {
        this.sender = sender;
        this.action = action;
        this.param = param;
    }

    private int getAction(String action) {
        return (Integer)ACTIONS.get(action);
    }

    public void doAction() {
        block5 : switch (this.getAction(this.action)) {
            case 0: {
                ((ProgressBar)((Screen)ScreenHolder.getInstance().getScreen("loadingscreen")).getChild("loading_bar")).setValue(0);
                EMidlet.getInstance().canvas.loading = true;
                EMidlet.getInstance().settings = new Settings();
                EMidlet.getInstance().settings.load();
                IMemoryListener listener = new IMemoryListener(){

                    public void onHandlerLoaded() {
                        AnimationHolder.getInstance().suspendAnimations();
                        EMidlet.getInstance().processor = new InternalProcessor(EMidlet.getInstance());
                        EMidlet.getInstance().canvas.setState(1);
                        new Thread(EMidlet.getInstance().processor).start();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        EMidlet.getInstance().canvas.loading = false;
                    }
                };
                ImageHandler.getInstance().setListener(listener);
                LevelHolder.getInstance().setCurrentLevel(0, true);
                break;
            }
            case 1: {
                EMidlet.getInstance().resume();
                EMidlet.getInstance().processor.setPaused(false);
                break;
            }
            case 2: {
                if (this.param == null || this.param.equals("")) {
                    this.param = "mainmenuscreen";
                }
                EMidlet.getInstance().canvas.setPaused(true);
                EMidlet.getInstance().processor.setPaused(true);
                ImageHandler.getInstance().clear();
                ((ProgressBar)((Screen)ScreenHolder.getInstance().getScreen("loadingscreen")).getChild("loading_bar")).setValue(0);
                EMidlet.getInstance().canvas.loading = true;
                AnimationHolder.getInstance().removeAllAnimations();
                AnimationHolder.getInstance().restoreSuspended();
                EMidlet.getInstance().canvas.setState(0);
                EMidlet.getInstance().canvas.setPaused(false);
                EMidlet.getInstance().destroyGame();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                SoundHandler.getInstance().clear();
                SoundHandler.getInstance().load(GameXmlReader.getMenuSounds());
                IMemoryListener listener = new IMemoryListener(){

                    public void onHandlerLoaded() {
                        if (Action.this.param.equals("activationscreen")) {
                            ScreenFactory.createActivationScreen();
                        }
                        ScreenHolder.getInstance().setActiveScreenId(Action.this.param);
                        EMidlet.getInstance().canvas.loading = false;
                        try {
                            String id = ScreenHolder.getInstance().getActiveScreenId();
                            Screen screen = (Screen)ScreenHolder.getInstance().getScreen(id);
                            if (screen.getActionListener() != null) {
                                screen.getActionListener().onShown();
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                };
                ImageHandler.getInstance().setListener(listener);
                ImageHandler.getInstance().load(GameXmlReader.getMenuImages());
                break;
            }
            case 3: {
                EMidlet.getInstance().destroyApp(true);
                EMidlet.getInstance().notifyDestroyed();
                break;
            }
            case 4: {
                ((ProgressBar)((Screen)ScreenHolder.getInstance().getScreen("loadingscreen")).getChild("loading_bar")).setValue(0);
                EMidlet.getInstance().canvas.loading = true;
                EMidlet.getInstance().canvas.setState(0);
                EMidlet.getInstance().canvas.setPaused(false);
                EMidlet.getInstance().processor.setPaused(true);
                IMemoryListener listener = new IMemoryListener(){

                    public void onHandlerLoaded() {
                        EMidlet.getInstance().processor.setPaused(false);
                        EMidlet.getInstance().canvas.setState(1);
                        EMidlet.getInstance().canvas.loading = false;
                    }
                };
                ImageHandler.getInstance().setListener(listener);
                if (this.param.equals("next")) {
                    LevelHolder.getInstance().nextLevel();
                    break;
                }
                LevelHolder.getInstance().setCurrentLevel(Integer.parseInt(this.param), false);
                break;
            }
            case 5: {
                ((ProgressBar)((Screen)ScreenHolder.getInstance().getScreen("loadingscreen")).getChild("loading_bar")).setValue(0);
                EMidlet.getInstance().canvas.loading = true;
                EMidlet.getInstance().canvas.setState(0);
                EMidlet.getInstance().canvas.setPaused(false);
                EMidlet.getInstance().processor.setPaused(true);
                IMemoryListener listener = new IMemoryListener(){

                    public void onHandlerLoaded() {
                        EMidlet.getInstance().processor.setPaused(false);
                        EMidlet.getInstance().canvas.setState(1);
                        EMidlet.getInstance().canvas.loading = false;
                    }
                };
                ImageHandler.getInstance().setListener(listener);
                LevelHolder.getInstance().setCurrentLevel(LevelHolder.getInstance().getCurrentLevel(), false);
                break;
            }
            case 6: {
                EMidlet.getInstance().destroyGame();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                Action a = new Action(this.sender, "START", null);
                a.doAction();
                break;
            }
            case 7: {
                if (!EMidlet.getInstance().getProperties().isMoreGamesEnabled()) {
                    return;
                }
                try {
                    String url = EMidlet.getInstance().getProperties().getMoreGamesBase() + "&vj=" + EMidlet.getInstance().gameId + "&vg=" + EMidlet.getInstance().gameVersion + "&id=" + EMidlet.getInstance().gameId + "&gameid=" + EMidlet.getInstance().gameId + "&p=" + EMidlet.getInstance().getProperties().getPartnerId() + "&u=" + EMidlet.getInstance().getProperties().getUserId() + "&producer=" + EMidlet.getInstance().getProperties().getProducer();
                    EMidlet.getInstance().platformRequest(url);
                    Debug.log("More Games: " + url);
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                EMidlet.getInstance().destroyApp(true);
                EMidlet.getInstance().notifyDestroyed();
                break;
            }
            case 8: {
                try {
                    EMidlet.getInstance().platformRequest(this.param);
                    EMidlet.getInstance().destroyApp(true);
                    EMidlet.getInstance().notifyDestroyed();
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 9: {
                if (this.param.equals("activationscreen")) {
                    ScreenFactory.createActivationScreen();
                }
                ScreenHolder.getInstance().setActiveScreenId(this.param);
                break;
            }
            case 10: {
                Label label;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (label = (Label)screen.getChild(params[1])) == null) break;
                label.setText(params[2], !LocalizationSupport.getMessage(params[2]).equals("???"));
                break;
            }
            case 11: {
                String[] params = StringEx.split(this.param, "|");
                Animation anim = AnimationHolder.getInstance().getAnimation(params[0]);
                if (anim == null) break;
                anim.setEnabled(params[1].equals("true"));
                break;
            }
            case 12: {
                AnimationHolder.getInstance().animate(Integer.parseInt(this.param));
                break;
            }
            case 13: {
                TextBox textBox;
                String[] links = new String[]{"http://77.75.35.241:80/", "http://77.75.35.242:80/", "http://77.75.35.243:80/"};
                String[] params = StringEx.split(this.param, "|");
                if (params.length == 3) {
                    TextBox textBox2;
                    Screen screens = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                    if (screens == null || (textBox2 = (TextBox)screens.getChild(params[1])) == null || textBox2.getText().trim().equals("")) break;
                    String textToEnc = EMidlet.getInstance().gameId + ":" + "10" + ":" + textBox2.getText() + ":" + LevelHolder.getInstance().getBestTotalScore() + ":" + "0" + ":" + EMidlet.getInstance().efwVersion + ":" + "1" + ":" + "1" + ":" + "0";
                    RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
                    RecordHandler.getInstance().saveRecord(new KeyValuePair("HighScore", textBox2.getText() + ":" + LevelHolder.getInstance().getBestTotalScore()));
                    RecordHandler.getInstance().closeRecordStore();
                    String[] addresses = new String[3];
                    for (int i = 0; i < links.length; ++i) {
                        addresses[i] = links[i] + "submit_new.jsp?en=" + this.crypt(textToEnc);
                    }
                    this.linkChecker(addresses, 0, (Label)screens.getChild(params[2]), 13);
                }
                if (params.length != 4) break;
                Screen screen1 = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                Screen screen2 = (Screen)ScreenHolder.getInstance().getScreen(params[2]);
                if (screen1 == null || screen2 == null || (textBox = (TextBox)screen1.getChild(params[1])) == null || textBox.getText().trim().equals("")) break;
                String textToEnc = EMidlet.getInstance().gameId + ":" + "10" + ":" + textBox.getText() + ":" + LevelHolder.getInstance().getBestTotalScore() + ":" + "0" + ":" + EMidlet.getInstance().efwVersion + ":" + "1" + ":" + "1" + ":" + "0";
                RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
                RecordHandler.getInstance().saveRecord(new KeyValuePair("HighScore", textBox.getText() + ":" + LevelHolder.getInstance().getBestTotalScore()));
                RecordHandler.getInstance().closeRecordStore();
                String[] addresses = new String[3];
                for (int i = 0; i < links.length; ++i) {
                    addresses[i] = links[i] + "submit_new.jsp?en=" + this.crypt(textToEnc);
                }
                this.linkChecker(addresses, 0, (Label)screen2.getChild(params[3]), 13);
                break;
            }
            case 14: {
                String[] links = new String[]{"http://77.75.35.241:80/", "http://77.75.35.242:80/", "http://77.75.35.243:80/"};
                String[] params = StringEx.split(this.param, "|");
                Screen screens = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screens == null) break;
                RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
                KeyValuePair highScoreData = RecordHandler.getInstance().getRecord("HighScore");
                RecordHandler.getInstance().closeRecordStore();
                String[] scoreParams = new String[2];
                if (highScoreData != null) {
                    String data = highScoreData.getValue();
                    scoreParams = StringEx.split(data, ":");
                } else {
                    scoreParams[0] = "noname";
                    scoreParams[1] = "0";
                }
                String textToEnc = EMidlet.getInstance().gameId + ":" + "10" + ":" + scoreParams[1] + ":" + scoreParams[0];
                String[] addresses = new String[3];
                for (int i = 0; i < links.length; ++i) {
                    addresses[i] = links[i] + "topScore.jsp?high=" + this.crypt(textToEnc);
                }
                this.linkChecker(addresses, 0, (Label)screens.getChild(params[1]), 14);
                break;
            }
            case 17: {
                String[] params = StringEx.split(this.param, "|");
                if (this.sender instanceof OptionButton) {
                    int selectedIndex = ((OptionButton)this.sender).getSelectedValueIndex();
                    String writerType = params[2 * selectedIndex];
                    if (writerType.equals("hex")) {
                        TextWriter.getInstance().setWriterType(0);
                    } else if (writerType.equals("wex")) {
                        TextWriter.getInstance().setWriterType(1);
                    } else if (writerType.equals("string")) {
                        TextWriter.getInstance().setWriterType(2);
                    }
                    LocalizationSupport._MESSAGES_BUNDLE = params[2 * selectedIndex + 1];
                }
                LocalizationSupport.initLocalizationSupport();
                Enumeration screens = ScreenHolder.getInstance().getScreens();
                while (screens.hasMoreElements()) {
                    Object object = screens.nextElement();
                    if (!(object instanceof Screen)) continue;
                    Screen screen = (Screen)object;
                    for (int i = 0; i < screen.getChildrenCount(); ++i) {
                        Component c = screen.getChild(i);
                        if (c instanceof OptionButton) {
                            OptionButton ob = (OptionButton)c;
                            ob.setValues(ob.getValuesKeys(), true);
                            ob.setText(ob.getPlainTextKey(), true);
                            continue;
                        }
                        if (c instanceof Button) {
                            Button b = (Button)c;
                            if (b.getTextKey() == null) continue;
                            b.setText(b.getTextKey(), true);
                            continue;
                        }
                        if (!(c instanceof Label)) continue;
                        Label l = (Label)c;
                        l.setText(l.getTextKey(), true);
                    }
                }
                break;
            }
            case 19: {
                if (this.param == null || this.param.equals("")) {
                    OptionButton button = (OptionButton)this.sender;
                    boolean option = button.getValuesKeys()[button.getSelectedValueIndex()].indexOf("on") > -1;
                    SoundHandler.getInstance().setEnabled(option);
                    return;
                }
                SoundHandler.getInstance().setEnabled(this.param.equals("true"));
                break;
            }
            case 20: {
                if (SoundHandler.getInstance().isPlaying()) break;
                SoundHandler.getInstance().play(this.param);
                break;
            }
            case 21: {
                OptionButton button;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (button = (OptionButton)screen.getChild(params[1])) == null) break;
                for (int i = 0; i < button.getValues().length; ++i) {
                    if (!SoundHandler.getInstance().isPlaying() || button.getValues()[i].toLowerCase().indexOf("on") == -1) continue;
                    button.setSelectedValueIndex(i);
                    break block5;
                }
                break;
            }
            case 22: {
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null) break;
                Label label = (Label)screen.getChild(params[1]);
                String bestScore = "Best Score: " + LevelHolder.getInstance().getBestTotalScore();
                if (label == null) break;
                label.setText(bestScore, false);
                break;
            }
            case 23: {
                OptionButton button;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (button = (OptionButton)screen.getChild(params[1])) == null) break;
                if (button.getSelectedValueIndex() == 0) {
                    SoundHandler.getInstance().setVolume(50);
                    break;
                }
                if (button.getSelectedValueIndex() == 1) {
                    SoundHandler.getInstance().setVolume(100);
                    break;
                }
                SoundHandler.getInstance().setVolume(33);
                break;
            }
            case 24: {
                if (this.sender instanceof OptionButton) {
                    OptionButton button = (OptionButton)this.sender;
                    EMidlet.getInstance().settings.add(new KeyValuePair(button.getId(), String.valueOf(button.getSelectedValueIndex())));
                    break;
                }
                String[] params = StringEx.split(this.param, "|");
                EMidlet.getInstance().settings.add(new KeyValuePair(params[0], params[1]));
                break;
            }
            case 25: {
                EMidlet.getInstance().settings.remove(this.param);
                break;
            }
            case 26: {
                OptionButton button;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (button = (OptionButton)screen.getChild(params[1])) == null) break;
                String value = EMidlet.getInstance().settings.get(button.getId());
                button.setSelectedValueIndex(Integer.parseInt(value));
                break;
            }
            case 27: {
                Label label;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (label = (Label)screen.getChild(params[1])) == null) break;
                label.setText(String.valueOf(LevelHolder.getInstance().getCurrentTotalScore()), false);
                break;
            }
            case 28: {
                Button button;
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null || (button = (Button)screen.getChild(params[1])) == null) break;
                button.setText(params[4], true);
                int actionType = 0;
                if (params[2].equals("action_performed")) {
                    actionType = 1;
                } else if (params[2].equals("on_selected")) {
                    actionType = 2;
                } else if (params[2].equals("on_deselected")) {
                    actionType = 3;
                } else if (params[2].equals("on_value_change")) {
                    actionType = 4;
                } else if (params[2].equals("on_shown")) {
                    actionType = 5;
                } else if (params[2].equals("on_close")) {
                    actionType = 6;
                }
                String actionName = params[3];
                String targetScreen = params[5];
                Action action = new Action(button, actionName, targetScreen);
                button.getActionListener().addAction(actionType, action);
                break;
            }
            case 29: {
                String[] params = StringEx.split(this.param, "|");
                Screen screen = (Screen)ScreenHolder.getInstance().getScreen(params[0]);
                if (screen == null) {
                    return;
                }
                int compSize = screen.getChildrenCount();
                for (int i = 0; i < compSize; ++i) {
                    Component comp = screen.getChild(i);
                    if (comp == null || !(comp instanceof IFocusable)) continue;
                    IFocusable focusable = (IFocusable)((Object)comp);
                    focusable.setSelected(false);
                }
                Component comp = screen.getChild(params[1]);
                if (comp == null) {
                    return;
                }
                if (!(comp instanceof IFocusable)) break;
                IFocusable focusable = (IFocusable)((Object)comp);
                focusable.setSelected(true);
                for (int i = 0; i < compSize; ++i) {
                    Component c = screen.getChild(i);
                    if (c == null || !c.equals(comp)) continue;
                    screen.setSelectedIndex(i);
                }
                if (focusable.isSelected()) break;
                screen.selectNext();
                break;
            }
            case 30: {
                if (EMidlet.getInstance().getProperties().getBuyMessage() == null || EMidlet.getInstance().getProperties().getBuyPhone() == null) {
                    return;
                }
                SmsSender smsSender = new SmsSender();
                smsSender.setListener(new ISmsListener(){

                    public void failed() {
                        ScreenFactory.createActivatedScreen(false);
                        Action action = new Action(this, "CHANGESCREENTO", "activatedscreen");
                        action.doAction();
                    }

                    public void success() {
                        RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
                        RecordHandler.getInstance().saveRecord(new KeyValuePair("Mode", "f"));
                        RecordHandler.getInstance().closeRecordStore();
                        GameModeHandler.getInstance().mode = 1;
                        ScreenFactory.createActivatedScreen(true);
                        Action action = new Action(this, "CHANGESCREENTO", "activatedscreen");
                        action.doAction();
                    }
                });
                smsSender.send(EMidlet.getInstance().getProperties().getBuyMessage(), EMidlet.getInstance().getProperties().getBuyPhone(), EMidlet.getInstance().getProperties().getBuyTryCount());
                break;
            }
            case 31: {
                try {
                    StringBuffer shareAddress = new StringBuffer("http://ttsy.org/social.jsp?s=").append(this.param).append("&id=").append(EMidlet.getInstance().gameId);
                    EMidlet.getInstance().platformRequest(shareAddress.toString());
                    Debug.log("Social: " + shareAddress);
                    EMidlet.getInstance().destroyApp(true);
                    EMidlet.getInstance().notifyDestroyed();
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 32: {
                LevelHolder.getInstance().resetAllLevels();
            }
        }
    }

    private String crypt(String text) {
        if (text == null || text.equals("")) {
            text = "NA";
        }
        TEA tea = new TEA("kumburgazlikelebek".getBytes());
        byte[] crypt = tea.encrypt(text.getBytes());
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < crypt.length; ++i) {
            result.append(crypt[i]);
            if (i == crypt.length - 1) continue;
            result.append(":");
        }
        return result.toString();
    }

    private void linkChecker(final String[] addresses, final int depth, final Label label, final int caseNo) {
        if (depth >= addresses.length) {
            return;
        }
        HTTPConnection http = new HTTPConnection(){

            public void onTextReceived(String text) {
                if (text == null) {
                    Action.this.linkChecker(addresses, depth + 1, label, caseNo);
                } else {
                    if (caseNo == 13) {
                        if (label != null) {
                            label.setText(text);
                        }
                        if (text == null || text.equals("")) {
                            label.setText("An Error Occured. \n Please check your connection");
                        }
                    }
                    if (caseNo == 14) {
                        int index = text.indexOf("1.");
                        if (index == -1 && label != null) {
                            label.setText("An Error Occured. \n Please check your connection");
                        } else {
                            text = text.substring(index);
                            text = text.substring(0, text.length() - 2);
                            String[] lines = StringEx.split(text, "@");
                            StringBuffer buffer = new StringBuffer(lines[0]);
                            for (int i = 1; i < lines.length; ++i) {
                                buffer.append(" \n ").append(lines[i]);
                            }
                            if (label != null) {
                                label.setText(buffer.toString());
                            }
                        }
                    }
                }
            }

            public void onImageReceived(Image image) {
            }
        };
        http.askRemoteText(addresses[depth]);
        Debug.log("Link Checker: " + addresses[depth]);
    }

    static {
        ACTIONS.put("START", new Integer(0));
        ACTIONS.put("RESUME", new Integer(1));
        ACTIONS.put("OPENMENU", new Integer(2));
        ACTIONS.put("EXIT", new Integer(3));
        ACTIONS.put("SETCURRENTLEVEL", new Integer(4));
        ACTIONS.put("RESTARTLEVEL", new Integer(5));
        ACTIONS.put("RESTARTGAME", new Integer(6));
        ACTIONS.put("MOREGAMES", new Integer(7));
        ACTIONS.put("OPENURL", new Integer(8));
        ACTIONS.put("CHANGESCREENTO", new Integer(9));
        ACTIONS.put("SETLABELTEXT", new Integer(10));
        ACTIONS.put("SETANIMATIONENABLED", new Integer(11));
        ACTIONS.put("SETANIMATIONTIME", new Integer(12));
        ACTIONS.put("SUBMITSCORE", new Integer(13));
        ACTIONS.put("GETTOPSCORES", new Integer(14));
        ACTIONS.put("CHANGELANGUAGE", new Integer(17));
        ACTIONS.put("SETSOUND", new Integer(19));
        ACTIONS.put("PLAYSOUND", new Integer(20));
        ACTIONS.put("GETSOUNDSTATE", new Integer(21));
        ACTIONS.put("SETSCORETEXT", new Integer(22));
        ACTIONS.put("SETVOLUME", new Integer(23));
        ACTIONS.put("ADDSETTING", new Integer(24));
        ACTIONS.put("REMOVESETTING", new Integer(25));
        ACTIONS.put("GETSETTINGTO", new Integer(26));
        ACTIONS.put("GETCURRENTSCORE", new Integer(27));
        ACTIONS.put("ROUTEACTION", new Integer(28));
        ACTIONS.put("SETSELECTED", new Integer(29));
        ACTIONS.put("BUY", new Integer(30));
        ACTIONS.put("SHARE", new Integer(31));
        ACTIONS.put("RESETALLLEVELS", new Integer(32));
    }
}

