/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.Keyboard;
import com.dvidearts.jengine.MyScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class KeyboardScreen
extends MyScreen {
    private Game game;
    private Keyboard kb;
    public boolean isActive;
    private byte exit;
    private static final byte EXIT_ACCEPT = 1;

    public KeyboardScreen(Game midlet) {
        this.game = midlet;
        this.kb = null;
        this.isActive = false;
        this.Load();
        this.exit = 0;
    }

    public void Load() {
        if (this.kb == null) {
            this.kb = new Keyboard(this.game.cfont2, this.game.wcenter, this.game.hcenter, this.game.resw, this.game.resh);
        }
    }

    public void Free() {
        this.kb = null;
    }

    public void Show() {
        this.game.popup.setMinWidth(this.game.resw - this.game.FONTW);
        this.game.wipe.reset();
        this.kb.reset();
        this.kb.clearTextbox();
        this.isActive = true;
        this.game.cmdY = (short)(this.game.y + this.game.render.getOriginalResHeight() - this.game.COMMANDH);
    }

    public void Hide() {
        this.isActive = false;
    }

    public void Render(Graphics g) {
        if (!this.game.wipe.IsActive() && this.exit > 0) {
            switch (this.exit) {
                case 1: {
                    this.doNext();
                }
            }
            return;
        }
        this.game.popup.drawBackground = true;
        this.game.popup.drawBorder = true;
        this.game.popup.center = true;
        g.drawImage(this.game.imgBg, this.game.wcenter - this.game.imgBg.getWidth() / 2, this.game.hcenter - this.game.imgBg.getHeight() / 2, 20);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y);
        this.game.sprTextbar.paint(g);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y + this.game.resh - this.game.sprTextbar.getHeight());
        this.game.sprTextbar.paint(g);
        this.game.sprOptions.setFrame(6);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.game.y + this.game.sprTextbar.getHeight() / 2);
        this.game.sprOptions.paint(g);
        if (this.game.popup.isActive) {
            return;
        }
        this.kb.paint(g);
        this.game.drawCommand(g, (byte)3, (byte)0);
        this.game.drawCommand(g, (byte)1, (byte)2);
        g.setColor(0, 0, 0);
        int fx = this.game.wcenter - this.game.smallfont.stringWidth(this.game.strUseKeyboard) / 2;
        int fy = this.game.y + this.game.resh / 20 * 17;
        g.fillRect(fx - 2, fy - 2, this.game.smallfont.stringWidth(this.game.strUseKeyboard) + 2, this.game.smallfont.getHeight() + 2);
        this.game.smallfont.drawString(g, this.game.strUseKeyboard, fx, fy);
        if (this.game.isDemo) {
            if (this.game.currframe % 10 != 0) {
                g.setColor(255, 0, 0);
            }
            fx = this.game.wcenter - this.game.smallfont.stringWidth(Text.txtNoSaveDemo) / 2;
            g.fillRect(fx - 2, (fy -= this.game.smallfont.getHeight() + 1) - 2, this.game.smallfont.stringWidth(Text.txtNoSaveDemo) + 2, this.game.smallfont.getHeight() + 2);
            this.game.smallfont.drawString(g, Text.txtNoSaveDemo, fx, fy);
        }
        this.game.showFPS(g);
    }

    public void keyReleased(int gameAction) {
        if (this.game.wipe.IsActive() || this.game.popup.isActive || !this.isActive || this.exit > 0) {
            return;
        }
        this.kb.keyReleased(gameAction);
        switch (gameAction) {
            default: 
        }
        switch (this.game.render.getInput()) {
            case '*': {
                this.Hide();
                break;
            }
            case '0': {
                break;
            }
            case '#': {
                this.exit = 1;
            }
        }
    }

    void doNext() {
        if (this.kb.getTextboxValue().trim().length() > 0) {
            boolean error = false;
            String tempName = this.kb.getTextboxValue().trim();
            for (int i2 = 0; i2 < 3; ++i2) {
                if (!this.game.sinfo[i2].name.equals(tempName)) continue;
                error = true;
                this.game.popup.clearText();
                this.game.popup.addLineText("");
                this.game.temp = "Name Already";
                this.game.popup.addLineText(this.game.temp);
                this.game.temp = "exist";
                this.game.popup.addLineText(this.game.temp);
                this.game.popup.addLineText("");
                this.game.popup.flash(20);
                this.exit = 0;
                break;
            }
            if (!error) {
                boolean found = false;
                for (int i3 = 0; i3 < 3; i3 = (int)((byte)(i3 + 1))) {
                    if (this.game.sinfo[i3].name.trim().length() != 0) continue;
                    this.game.infoSlot = (byte)i3;
                    this.game.sinfo[i3].name = tempName;
                    this.game.SaveSettings();
                    found = true;
                    break;
                }
                if (found) {
                    this.game.loader.Start((byte)4);
                } else {
                    this.game.popup.clearText();
                    this.game.popup.addLineText("");
                    this.game.temp = "Game Full";
                    this.game.popup.addLineText(this.game.temp, false);
                    this.game.popup.addLineText("");
                    this.game.popup.flash(20);
                    this.exit = 0;
                }
            }
        } else {
            this.game.popup.clearText();
            this.game.popup.addLineText("");
            this.game.popup.addLineText(Text.txtBLANK_NAME);
            this.game.popup.addLineText("");
            this.game.popup.flash(20);
            this.kb.clearTextbox();
            this.exit = 0;
        }
    }

    public void Process(int arg0) {
    }

    public void keyPressed(int arg0) {
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }
}

