/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import com.dvidearts.jengine.CustomFont;
import com.dvidearts.jengine.MyColor;
import com.dvidearts.jengine.MyPoint;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utils {
    public Integer INT = new Integer(0);
    private Calendar CAL = Calendar.getInstance();
    private static Random rand;
    public static final byte JUSTIFY_LEFT = 0;
    public static final byte JUSTIFY_CENTER = 1;
    public static final byte JUSTIFY_RIGHT = 2;
    public static final byte VALIGN_TOP = 0;
    public static final byte VALIGN_CENTER = 1;
    public static final byte VALIGN_BOTTOM = 2;

    public Utils() {
        rand = new Random();
    }

    public void pause(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image[] readBinary(String binfile, boolean reverseOrder) {
        int i2;
        Vector<Image> v2 = new Vector<Image>();
        try {
            int data;
            InputStream is = this.getClass().getResourceAsStream(binfile);
            if (is == null) {
                return null;
            }
            int len = 0;
            while ((data = is.read()) >= 0) {
                len = (data & 0xFF) << 24;
                len |= (is.read() & 0xFF) << 16;
                len |= (is.read() & 0xFF) << 8;
                byte[] buffer = new byte[len |= is.read() & 0xFF];
                is.read(buffer, 0, buffer.length);
                v2.addElement(Image.createImage((byte[])buffer, (int)0, (int)buffer.length));
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception e) {
            byte[] buffer = null;
            System.gc();
            return null;
        }
        Image[] img = new Image[v2.size()];
        Enumeration e = v2.elements();
        if (reverseOrder) {
            i2 = v2.size() - 1;
            while (e.hasMoreElements()) {
                img[i2] = (Image)e.nextElement();
                --i2;
            }
        } else {
            i2 = 0;
            while (e.hasMoreElements()) {
                img[i2] = (Image)e.nextElement();
                ++i2;
            }
        }
        return img;
    }

    public static String replace(String str, String pattern, String replace) {
        int s2 = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s2)) >= 0) {
            result.append(str.substring(s2, e));
            result.append(replace);
            s2 = e + pattern.length();
        }
        result.append(str.substring(s2));
        return result.toString();
    }

    public static String RemoveTrailingCharacters(String str, char c2, int places) {
        if (str == null) {
            return "";
        }
        if (str.length() <= places) {
            return str;
        }
        int len = str.length();
        int i2 = str.length() - 1;
        while (i2 >= 0) {
            if (str.charAt(i2) != c2 || --len <= places) break;
            --i2;
        }
        if (len <= 0) {
            return "";
        }
        return str.substring(0, len);
    }

    public int getYear() {
        return this.CAL.get(1);
    }

    public int getMonth() {
        return this.CAL.get(2) + 1;
    }

    public int getDay() {
        return this.CAL.get(5);
    }

    public int getHour() {
        return this.CAL.get(10);
    }

    public int getMinute() {
        return this.CAL.get(12);
    }

    public int getSecond() {
        return this.CAL.get(13);
    }

    public void refreshCalender() {
        this.CAL = null;
        this.CAL = Calendar.getInstance();
    }

    public static int RandNum(int min, int max) {
        return Math.abs(rand.nextInt() % (max - min + 1)) + min;
    }

    public static void drawProgress(Graphics g, int x2, int y2, int w, int h, int percentage, int max, MyColor background, MyColor bar, MyColor border) {
        int pct = w * percentage / max;
        g.setColor(background.r, background.g, background.b);
        g.fillRect(x2, y2, w, h);
        g.setColor(bar.r, bar.g, bar.b);
        g.fillRect(x2, y2, pct, h);
        g.setColor(border.r, border.g, border.b);
        g.drawRect(x2, y2, w, h);
    }

    public static void drawProgress(Graphics g, Image imgBackground, Image imgBar, int x2, int y2, int max, int percentage) {
        g.drawImage(imgBackground, x2, y2, 20);
        int w = imgBackground.getWidth();
        int h = imgBackground.getHeight();
        if (max < 1) {
            return;
        }
        int pct = w * percentage / max;
        if (pct < 1) {
            return;
        }
        g.drawImage(Image.createImage((Image)imgBar, (int)0, (int)0, (int)pct, (int)h, (int)0), x2, y2, 20);
    }

    public static String printCommas(long val) {
        String strVal = "" + val;
        String str = "";
        int place = 0;
        place = strVal.charAt(0) == '-' ? (strVal.length() - 1) % 3 : strVal.length() % 3;
        if (place == 0) {
            place = 3;
        }
        if (strVal.charAt(0) == '-') {
            ++place;
        }
        int i2 = 0;
        while (i2 < strVal.length()) {
            if (place == i2 && i2 > 0 && i2 + 1 < strVal.length()) {
                str = String.valueOf(str) + ",";
                place += 3;
            }
            str = String.valueOf(str) + strVal.charAt(i2);
            ++i2;
        }
        return str;
    }

    public static void drawTextbox(Graphics g, String text, CustomFont cf, byte justify, byte valign, int x2, int y2, MyColor bgc, MyColor bdc, int borderSize) {
        int textlength = cf.stringWidth(text);
        int boxlen = textlength + cf.getWidth() * 2;
        int boxX = 0;
        int boxY = 0;
        int borderH = borderSize * 2;
        int boxHeight = borderH + cf.getHeight();
        switch (valign) {
            case 0: {
                boxY = y2;
                break;
            }
            case 1: {
                boxY = y2 - boxHeight / 2;
                break;
            }
            case 2: {
                boxY = y2 - boxHeight;
            }
        }
        --boxY;
        switch (justify) {
            case 0: {
                boxX = x2;
                break;
            }
            case 1: {
                boxX = x2 - boxlen / 2;
                break;
            }
            case 2: {
                boxX = x2 - boxlen - 1;
            }
        }
        if (bgc != null) {
            g.setColor(bgc.r, bgc.g, bgc.b);
            g.fillRect(boxX, boxY, boxlen, boxHeight);
        }
        if (bdc != null) {
            g.setColor(bdc.r, bdc.g, bdc.b);
            g.drawRect(boxX, boxY, boxlen, boxHeight);
        }
        cf.drawString(g, text, boxX + boxlen / 2 - textlength / 2, boxY + boxHeight / 2 - cf.getHeight() / 2 + 1);
    }

    public MyPoint ParametricLine2D(MyPoint start, MyPoint end, int pos) {
        MyPoint New = new MyPoint();
        New.x = start.x + pos * (end.x - start.x) / 10;
        New.y = start.y + pos * (end.y - start.y) / 10;
        return New;
    }

    public static boolean linesIntersect(int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4) {
        return Utils.relativeCCW(X1, Y1, X2, Y2, X3, Y3) * Utils.relativeCCW(X1, Y1, X2, Y2, X4, Y4) <= 0 && Utils.relativeCCW(X3, Y3, X4, Y4, X1, Y1) * Utils.relativeCCW(X3, Y3, X4, Y4, X2, Y2) <= 0;
    }

    private static int relativeCCW(int X1, int Y1, int X2, int Y2, int PX, int PY) {
        int ccw = (PX -= X1) * (Y2 -= Y1) - (PY -= Y1) * (X2 -= X1);
        if (ccw == 0 && (ccw = PX * X2 + PY * Y2) > 0 && (ccw = (PX -= X2) * X2 + (PY -= Y2) * Y2) < 0) {
            ccw = 0;
        }
        return ccw < 0 ? -1 : (ccw > 0 ? 1 : 0);
    }
}

