/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvBufferedReader;
import com.dvidearts.dvj2me.dvSprite;
import com.dvidearts.dvj2me.dvStringTokenizer;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;

public class dvTile {
    private dvSprite sprite;
    private short cols;
    private short rows;
    private short cellw;
    private short cellh;
    private int x;
    private int y;
    private short[] cell;
    private boolean visible;
    public boolean showgrid;

    private void initDefaults(int numcolumns, int numrows, dvSprite spr) {
        this.cols = (short)numcolumns;
        this.rows = (short)numrows;
        this.sprite = spr;
        this.cell = new short[this.cols * this.rows];
        this.cellw = (short)this.sprite.getWidth();
        this.cellh = (short)this.sprite.getHeight();
        this.visible = true;
        this.x = 0;
        this.y = 0;
        this.showgrid = false;
        System.gc();
    }

    public dvTile(int numcolumns, int numrows, dvSprite spr, short[] cellIndex) {
        this.initDefaults(numcolumns, numrows, spr);
        this.setTileOrder(cellIndex);
    }

    public dvTile(int numcolumns, int numrows, dvSprite spr) {
        this.initDefaults(numcolumns, numrows, spr);
    }

    public dvTile(int numcolumns, int numrows, dvSprite spr, String filename) {
        this.initDefaults(numcolumns, numrows, spr);
        this.setTileOrder(this.loadTile(filename, numcolumns, numrows));
    }

    public void free() {
        this.cell = null;
    }

    private short[] loadTile(String filename, int wide, int high) {
        short[] array = new short[wide * high];
        try {
            dvBufferedReader bufRdr = null;
            InputStream is = this.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println("Can not load: " + filename);
                return array;
            }
            bufRdr = new dvBufferedReader(new InputStreamReader(is));
            String line = null;
            int count = 0;
            while ((line = bufRdr.readLine()) != null) {
                dvStringTokenizer st = new dvStringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (t == null || t.trim().length() <= 0) continue;
                    array[count] = Short.parseShort(t.trim());
                    ++count;
                }
            }
            bufRdr.close();
        }
        catch (Exception e) {
            System.out.println("error: " + e);
        }
        return array;
    }

    public short getCell(int col, int row) {
        if (col >= this.cols || row >= this.rows) {
            return 0;
        }
        short val = this.cell[col + row * this.cols];
        val = (short)(val + 1);
        return val;
    }

    public short getCellHeight() {
        return this.cellh;
    }

    public short getCellWidth() {
        return this.cellw;
    }

    public short getColumns() {
        return this.cols;
    }

    public int getColumn(int xp) {
        int w = this.getWidth();
        if (xp > w) {
            xp = w;
        } else if (xp < 0) {
            xp = 0;
        }
        return xp / this.cellw;
    }

    public short getRows() {
        return this.rows;
    }

    public int getRow(int yp) {
        int y = this.getHeight();
        if (yp > y) {
            yp = y;
        } else if (yp < 0) {
            yp = 0;
        }
        return yp / this.cellh;
    }

    public void paint(Graphics g, int xp, int yp, int resw, int resh) {
        if (this.visible) {
            int i = 0;
            int startcol = 0;
            if (this.x < 0) {
                startcol = this.getColumn(Math.abs(this.x));
            }
            int startrow = 0;
            if (this.y < 0) {
                startrow = this.getRow(Math.abs(this.y));
            }
            int c = 0;
            int r = 0;
            i = (short)(i + startrow * this.cols);
            r = startrow;
            while (r < this.rows) {
                i = (short)(i + startcol);
                c = startcol;
                while (c < this.cols) {
                    if (this.cell[i] >= 0) {
                        int fx = xp + this.x + this.cellw * c;
                        int fy = yp + this.y + this.cellh * r;
                        if (fy > yp + resh) {
                            return;
                        }
                        if (fx > xp + resw) {
                            i = (short)(i + (this.cols - c));
                            break;
                        }
                        this.sprite.setPosition(fx, fy);
                        this.sprite.setFrame(this.cell[i]);
                        this.sprite.paint(g);
                        if (this.showgrid) {
                            g.setColor(255, 255, 0);
                            g.drawRect(fx, fy, (int)this.cellw, (int)this.cellh);
                        }
                    }
                    i = (short)(i + 1);
                    ++c;
                }
                ++r;
            }
        }
    }

    public void setCell(int col, int row, short tileIndex) {
        this.cell[col + row * this.cols] = tileIndex = (short)(tileIndex - 1);
    }

    public short[] getCellOrder() {
        return this.cell;
    }

    public int getHeight() {
        return this.cellh * this.rows;
    }

    public int getWidth() {
        return this.cellw * this.cols;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.x;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean value) {
        this.visible = value;
    }

    public void setPosition(int nx, int ny) {
        this.x = nx;
        this.y = ny;
    }

    public void move(int dx, int dy) {
        this.setPosition(this.x + dx, this.y + dy);
    }

    public void setTileOrder(short[] tileOrder) {
        int i = 0;
        while (i < tileOrder.length) {
            int column = i % this.getColumns();
            int row = (i - column) / this.getColumns();
            this.setCell(column, row, tileOrder[i]);
            ++i;
        }
    }
}

