/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ShowContent {
    private int MAXLINES = 0;
    private int skipLineNumber = 0;
    private boolean outOfBox = false;
    private int MESSAGE_LINE_NUMBER = 0;
    private String[] context = null;
    private int x;
    private int y;
    private int w;
    private int h;
    byte LT = (byte)20;
    byte LB = (byte)36;
    byte RT = (byte)24;
    byte RB = (byte)40;
    byte LV = (byte)6;
    byte RV = (byte)10;
    byte HT = (byte)17;
    byte HV = (byte)3;
    byte HB = (byte)33;

    public ShowContent(String file, int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.context = Utils.fileToStringArray(file);
    }

    public void paint(Graphics g) {
        g.setColor(0);
        this.drawMessage(g, this.context, this.x + 10, this.y + 10, this.w, this.h);
        if (this.outOfBox) {
            g.setColor(255, 0, 0);
            if (this.skipLineNumber > 0) {
                g.drawLine(this.w / 2, this.y - 3, this.w / 2 - 2, this.y - 1);
                g.drawLine(this.w / 2, this.y - 3, this.w / 2 + 2, this.y - 1);
            }
            if (this.skipLineNumber + this.MAXLINES <= this.MESSAGE_LINE_NUMBER) {
                g.drawLine(this.w / 2, this.y + this.h - 1, this.w / 2 - 2, this.y + this.h - 3);
                g.drawLine(this.w / 2, this.y + this.h - 1, this.w / 2 + 2, this.y + this.h - 3);
            }
        }
        g.setColor(220, 220, 220);
        g.setColor(0xFFFFFF);
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -2: 
            case 56: {
                if (!this.outOfBox || this.skipLineNumber + this.MAXLINES > this.MESSAGE_LINE_NUMBER) break;
                ++this.skipLineNumber;
                break;
            }
            case -1: 
            case 50: {
                if (!this.outOfBox || this.skipLineNumber <= 0) break;
                --this.skipLineNumber;
            }
        }
    }

    public void drawMessage(Graphics g, String[] strs, int x, int y, int w, int h) {
        Font currentFont = g.getFont();
        g.setFont(currentFont);
        int lineHeight = currentFont.getHeight();
        this.MAXLINES = h / lineHeight;
        int lineNumber = 0;
        int offsetX = x;
        int k = 0;
        int j = 0;
        int i = 0;
        while (i < strs.length) {
            offsetX = x;
            j = 0;
            while (j < strs[i].length()) {
                k = currentFont.charWidth(strs[i].charAt(j));
                if (offsetX + k > w) {
                    if (++lineNumber - this.skipLineNumber >= this.MAXLINES) {
                        this.outOfBox = true;
                        break;
                    }
                    offsetX = x;
                }
                if (lineNumber - this.skipLineNumber >= 0) {
                    g.drawChar(strs[i].charAt(j), offsetX, y + (lineNumber - this.skipLineNumber) * lineHeight, (int)this.LT);
                }
                offsetX += k;
                ++j;
            }
            if (++lineNumber - this.skipLineNumber >= this.MAXLINES) {
                this.outOfBox = true;
                break;
            }
            ++i;
        }
        if (lineNumber > this.MESSAGE_LINE_NUMBER) {
            this.MESSAGE_LINE_NUMBER = lineNumber;
        }
    }
}

