/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Event {
    static final byte up = 0;
    static final byte right = 1;
    static final byte down = 2;
    static final byte left = 3;
    static final byte add = 9;
    static final short S_IF = 255;
    static final short S_ENDIF = 254;
    static final short S_LOOP = 253;
    static final short S_ENDLOOP = 252;
    static final short S_LEFT = 251;
    static final short S_RIGHT = 250;
    static final short S_SYNC = 239;
    static final short S_ENDSYNC = 238;
    static final short S_ELSE = 237;
    static final short T_IEXP = 0;
    static final short T_BEXP = 1;
    static final short T_STR = 2;
    static final short T_ARRAY = 3;
    static final short T_INT_B = 4;
    static final short T_INT = 5;
    static final short T_INT_M = 6;
    static final short T_BOOL = 7;
    static String[] exp;
    static int[] bInt;
    static short[][] array;
    static final byte ORDER_READY = 0;
    static final byte ORDER_GO = 1;
    static final byte ORDER_END = 2;
    static Vector path;
    static final int BLOCK_SYNC = 0;
    static final int BLOCK_STEP = 1;
    private Vector vRoot = new Vector();
    public String typeName;
    public int id;
    static int waitTime;
    short[] prop;
    boolean isReturn = false;
    static byte curSprite;
    static byte isMotion;
    static int index;
    static byte frameTimes;
    static byte curStates;
    static byte nextStates;
    static int sDir;
    static int nextDir;
    static int faceDir;
    static int nextFaceDir;
    public static final int OCCUR_ERROR = -1;
    public static final int OCCUR_AREA = 0;
    public static final int OCCUR_SPRITE = 1;
    public static final int OCCUR_NULL = 2;
    public static final int OCCUR_NEXT_AREA = 3;
    public static final int OCCUR_EXPRESSION = 4;
    private int occurType;
    private int[] occurNpcs;
    private int[] area;
    private String expression;
    boolean eventIsAlive;
    boolean inEventArea = true;
    public boolean isKeyAlive;
    static final short o_complete = 1;
    static final short o_setScene = 2;
    static final short o_changeItem = 3;
    static final short o_showText = 4;
    static final short o_ctrl = 5;
    static final short o_set = 6;
    static final short o_break = 7;
    static final short o_move = 8;
    static final short o_wait = 9;
    static final short o_npcAppear = 10;
    static final short o_npcDisappear = 11;
    static final short o_setDir = 12;
    static final short o_setFace = 13;
    static final short o_step = 14;
    static final short o_showAction = 15;
    static final short o_showChoice = 16;
    static final short o_setCamera = 17;
    static final short o_gameOver = 18;
    static final short o_setTeam = 19;
    static final short o_initEmy = 20;
    static final short o_setBattle = 21;
    static final short o_breakBattle = 22;
    static final short o_addLog = 23;
    static final short o_delLog = 24;
    static final short o_changeSkill = 25;
    static final short o_changeEquip = 26;
    static final short o_changeMat = 27;
    static final short o_changeGod = 28;
    static final short o_getSoul = 29;
    static final short o_changeExp = 30;
    static final short o_changeMoney = 31;
    static final short o_showEffect = 32;
    static final short o_showEffectEx = 33;
    static final short o_removeEffectEx = 34;
    static final short o_random = 35;
    static final short o_showCG = 36;
    static final short o_aside = 37;
    static final short o_changeSpeed = 38;
    static final short o_changeFrequency = 39;
    static final short o_buyEquip = 40;
    static final short o_buyItem = 41;
    static final short o_sellItem = 42;
    static final short o_sellEquip = 43;
    static final short o_rest = 44;
    static final short o_save = 45;
    static final short o_changeLevel = 46;
    static final short o_changeBGM = 47;
    static final short o_chargePoint = 48;
    static final short o_showGame = 49;
    static final short o_screenFlash = 50;
    static final short o_setStatus = 51;
    static final short o_changeBomb = 52;
    static final short o_screenWhite = 53;
    static final short o_shake = 54;
    static final short o_stopBattle = 55;
    static final short o_fullHp = 56;
    static final short o_setRunXY = 57;
    static final short o_changeModle = 58;
    static final short o_filmStart = 59;
    static final short o_filmEnd = 60;
    static final short o_setNpcStatus = 61;
    static final short o_setInfo = 62;
    static final short o_refresh = 63;
    static final short o_stop = 64;
    static final short o_flash = 65;
    static final short o_refine = 66;
    static final short o_blackBG = 67;
    static final short o_lookMode = 68;
    static final short o_showHead = 69;
    static final short o_setWeather = 70;
    static final short o_showLight = 71;
    static final short o_closeLight = 72;
    static final short o_showHole = 73;
    static final short o_setMotion = 74;
    static final short o_savePos = 75;
    static final short o_loadPos = 76;
    static final short o_setEquips = 77;
    static final short o_soulRefine = 78;
    static final short o_teach = 79;
    static final short o_showBlackText = 80;
    static final short o_return = 81;
    static final short o_FZ1Start = 82;
    static final short o_FZ1End = 83;
    static final short o_FZ2Start = 84;
    static final short o_FZ2End = 85;
    static final short o_jump = 86;
    static final short o_changeSkBook = 87;
    static final short o_changeEgg = 88;
    static final short o_setCurMusic = 89;
    static final short o_setPayPoint = 90;
    static final short o_roleIsMagicOff = 91;
    static final short o_roleIsMagicOn = 92;
    static final short o_CGEnd = 93;
    static final short o_isAppear = 94;
    static final short o_snakeAppID = 95;
    static final short o_isCurIndex = 96;
    static final short o_isSleep = 97;
    static final short o_fighterState = 98;
    static final short o_isDelayEfft = 99;
    static final short o_aside1 = 100;
    static final short o_isCloseScreen = 101;
    static final short o_isCloseScreen1 = 102;
    static final short o_changeMakeEquip = 103;
    static final short o_resetLevel = 104;
    static final short o_addOtherTask = 105;
    static final short o_addFinishTask = 106;
    static final short o_addFinishAchieve = 107;
    static final short o_buyMat = 108;
    static final short o_smallGame = 109;
    static final short o_addTotalPoint = 110;
    static final short o_changeGameStatus = 111;
    static final short o_saveReadProp = 112;
    static final short o_teachSkill = 113;
    static final short p_0 = 3;
    static final short p_1 = 4;
    static final short p_2 = 5;
    static final short p_3 = 6;
    static final short p_4 = 7;
    static final short p_5 = 8;
    static boolean isTeach;
    static int roleHp;
    static short roleMp;
    static byte roleLev;
    static int roleExp;
    static int roleMoney;
    static int lastMap;
    static int lastX;
    static int lastY;
    static int lastDir;
    static int mapID;
    static int posX;
    static int posY;
    static int dir;
    static boolean isChangeMap;
    static boolean isVisible;
    static boolean isBreakBattle;
    private static boolean isNot;
    private static boolean minus;

    int getOrder(short order) {
        return order;
    }

    int getOrderLen(short order) {
        return order & 0xFF;
    }

    static int getInt(short param) {
        int type = Event.getParamType(param);
        int value = Event.getParamValue(param);
        switch (type) {
            case 5: {
                return value;
            }
            case 6: {
                return -value;
            }
            case 4: {
                return bInt[value];
            }
            case 0: {
                return Event.getIntValue(exp[value]);
            }
        }
        return Integer.MAX_VALUE;
    }

    static boolean getBool(short param) {
        int type = Event.getParamType(param);
        int value = Event.getParamValue(param);
        switch (type) {
            case 7: {
                return value == 0;
            }
            case 1: {
                return Event.conditionIsTrue(exp[value]);
            }
        }
        return false;
    }

    static String getString(short param) {
        int index = Event.getParamValue(param);
        if (index == 8191) {
            return "null";
        }
        return Event.parseStr(exp[index]);
    }

    static short[] getArray(short param) {
        int index = Event.getParamValue(param);
        if (index == 8191) {
            return null;
        }
        return array[index];
    }

    static int getParamType(short param) {
        return param >> 13 & 7;
    }

    static int getParamValue(short param) {
        return param & 0x1FFF;
    }

    static void free() {
        path.removeAllElements();
        exp = null;
        bInt = null;
        array = null;
    }

    public void init(short[][] contents) {
        this.vRoot = this.parseOrderGroup(contents, 0, contents.length, "", 1);
    }

    public void endInit() {
        for (int i = 0; i < this.prop.length; ++i) {
            int type = Event.getParamType(this.prop[i]);
            int n = Event.getParamValue(this.prop[i]);
        }
        this.id = Event.getInt(this.prop[1]);
        this.setCondition(Event.getString(this.prop[2]));
        this.isKeyAlive = Event.getBool(this.prop[3]);
        this.prop = null;
    }

    public void run() {
        if (this.id >= 0 && Script.scriptVar[this.id] != 0) {
            return;
        }
        if (!this.eventIsAlive) {
            this.checkEventCondition();
        }
        if (this.eventIsAlive) {
            this.runOrder(this.vRoot);
            if (Event.sToi((String)this.vRoot.elementAt(1)) == 2) {
                this.setLastSpriteState();
                this.eventIsAlive = false;
                if (this.id < 0 || Script.scriptVar[this.id] == 0) {
                    this.initVector(this.vRoot);
                    Script.isUserCtrl = true;
                }
            }
        }
        if (this.isReturn) {
            if (this.id < 0 || Script.scriptVar[this.id] == 0) {
                this.initVector(this.vRoot);
            }
            Script.isUserCtrl = true;
            this.isReturn = false;
            this.setLastSpriteState();
        }
    }

    public static void saveState(GameSprite s) {
        isMotion = s.isMotion;
        index = s.index;
        frameTimes = s.frameTimes;
        curStates = s.curStates;
        nextStates = s.nextStates;
        sDir = s.dir;
        nextDir = s.nextDir;
        faceDir = s.faceDir;
        nextFaceDir = s.nextFaceDir;
        Event.setSpriteDir(s);
    }

    public static void setSpriteDir(GameSprite s) {
        if (s.isMotion != -1) {
            s.isMotion = 0;
        }
        int mirrorDir = Event.getMirrorDir(GameEngine.sprite[GameEngine.spriteIndex].dir);
        if (s.curStates == -1 || s.curStates == -2) {
            s.curStates = (byte)-1;
            s.nextStates = (byte)-1;
            s.frameTimes = 0;
            s.index = 0;
        }
    }

    static int getMirrorDir(int dir) {
        return dir ^ 2;
    }

    private void setLastSpriteState() {
        if (curSprite != -1) {
            GameSprite s = GameEngine.sprite[curSprite];
            s.isMotion = isMotion;
            if (s.curStates == -1) {
                s.curStates = curStates;
                s.nextStates = nextStates;
                s.index = index;
                s.frameTimes = frameTimes;
                s.dir = sDir;
                s.nextDir = nextDir;
                s.faceDir = faceDir;
                s.nextFaceDir = nextFaceDir;
            }
            curSprite = (byte)-1;
        }
    }

    public void runBattle() {
        if (this.id >= 0 && Script.scriptVar[this.id] != 0) {
            return;
        }
        this.runOrder(this.vRoot);
        if (Event.sToi((String)this.vRoot.elementAt(1)) == 2) {
            this.eventIsAlive = false;
            if (this.id < 0 || Script.scriptVar[this.id] == 0) {
                this.initVector(this.vRoot);
            }
        }
    }

    private void setCondition(String str) {
        String condition = str.substring(str.indexOf(32) + 1, str.length());
        String[] param = Event.getParams(condition, ",");
        String type = param[0];
        if (type.equals("area")) {
            this.occurType = 0;
            this.area = new int[]{Event.sToi(param[1]) - 1, Event.sToi(param[2]), Event.sToi(param[3]), Event.sToi(param[4])};
        } else if (type.equals("nextArea")) {
            this.occurType = 3;
            this.area = new int[]{Event.sToi(param[1]) - 1, Event.sToi(param[2]), Event.sToi(param[3]), Event.sToi(param[4])};
        } else if (type.equals("sprite")) {
            this.occurNpcs = new int[param.length - 1];
            for (int i = 0; i < this.occurNpcs.length; ++i) {
                this.occurNpcs[i] = Event.sToi(param[i + 1]);
            }
            this.occurType = 1;
            this.isKeyAlive = false;
        } else if (type.equals("null")) {
            this.occurType = 2;
        } else if (type.equals("expression")) {
            this.occurType = 4;
            this.expression = param[1];
        } else {
            this.occurType = -1;
        }
    }

    private void checkEventCondition() {
        if (!Script.isUserCtrl) {
            return;
        }
        int posX = GameEngine.sprite[GameEngine.spriteIndex].ax;
        int posY = GameEngine.sprite[GameEngine.spriteIndex].ay;
        if (GameEngine.sprite[GameEngine.spriteIndex].x != posX || GameEngine.sprite[GameEngine.spriteIndex].y != posY + 1) {
            return;
        }
        if (this.occurType == 1 || this.occurType == 3) {
            switch (GameEngine.sprite[GameEngine.spriteIndex].dir) {
                case 2: {
                    posX += 8;
                    posY += 8;
                    break;
                }
                case 0: {
                    posX += 8;
                    posY -= 24;
                    break;
                }
                case 1: {
                    posX += 24;
                    posY -= 8;
                    break;
                }
                case 3: {
                    posX -= 8;
                    posY -= 8;
                }
            }
        }
        block6 : switch (this.occurType) {
            case 4: {
                if (!Event.conditionIsTrue(this.expression)) break;
                this.eventIsAlive = true;
                break;
            }
            case 2: {
                this.eventIsAlive = true;
                break;
            }
            case 0: 
            case 3: {
                if (this.inEventArea) {
                    if (Tools.hit(posX, posY, 0, 0, this.area[0], this.area[1], this.area[2], this.area[3])) break;
                    this.inEventArea = false;
                    break;
                }
                if (!Tools.hit(posX, posY, 0, 0, this.area[0], this.area[1], this.area[2], this.area[3])) break;
                if (!this.isKeyAlive) {
                    this.inEventArea = true;
                    this.eventIsAlive = true;
                    break;
                }
                if (!MyGameCanvas.confirmKey) break;
                this.eventIsAlive = true;
                break;
            }
            case 1: {
                if (this.occurNpcs == null) {
                    return;
                }
                if (!MyGameCanvas.confirmKey) {
                    return;
                }
                for (int i = 0; i < this.occurNpcs.length; ++i) {
                    if (!GameEngine.sprite[this.occurNpcs[i]].visible || !Tools.hit(posX, posY, 0, 0, GameEngine.sprite[this.occurNpcs[i]].x, GameEngine.sprite[this.occurNpcs[i]].y, 16, 16)) continue;
                    this.eventIsAlive = true;
                    curSprite = (byte)this.occurNpcs[i];
                    Event.saveState(GameEngine.sprite[this.occurNpcs[i]]);
                    if (GameEngine.sprite[this.occurNpcs[i]].modle != 33) break block6;
                    GameEngine.sprite[this.occurNpcs[i]].setStates(7);
                    break block6;
                }
                break;
            }
        }
    }

    private static String trim(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    short setPath(String orderPath) {
        path.addElement(orderPath);
        return (short)(path.size() - 1);
    }

    void addElement(Vector v, short state, String path, short[] s) {
        short[] temp = new short[s.length + 2];
        temp[0] = state;
        temp[1] = this.setPath(path);
        System.arraycopy(s, 0, temp, 2, s.length);
        v.addElement(temp);
    }

    private Vector parseOrderGroup(short[][] s, int start, int end, String parentName, int type) {
        int count = 3;
        Vector<Object> v = new Vector<Object>();
        v.addElement("" + type);
        v.addElement("0");
        v.addElement("3");
        if (start > 0) {
            this.addElement(v, (short)0, parentName + "|" + count++, s[start - 1]);
        }
        block6: for (int i = start; i < end; ++i) {
            String name = parentName + "|" + count++;
            int command = this.getOrder(s[i][0]);
            switch (command) {
                case 251: {
                    int endIndex = this.getEndIndex(s, i, (short)251, (short)250);
                    v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                    i = endIndex;
                    continue block6;
                }
                case 255: {
                    int endIndex = this.getEndIndex(s, i, (short)255, (short)254);
                    v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                    i = endIndex;
                    continue block6;
                }
                case 253: {
                    int endIndex = this.getEndIndex(s, i, (short)253, (short)252);
                    v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                    i = endIndex;
                    continue block6;
                }
                case 239: {
                    int endIndex = this.getEndIndex(s, i, (short)239, (short)238);
                    v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 0));
                    i = endIndex;
                    continue block6;
                }
                default: {
                    this.addElement(v, (short)0, name, s[i]);
                }
            }
        }
        return v;
    }

    private int getElseIndex(Vector v) {
        for (int i = 3; i < v.size(); ++i) {
            int command;
            Object obj = v.elementAt(i);
            if (obj instanceof Vector || (command = this.getCommand((short[])obj)) != 237) continue;
            return i;
        }
        return -1;
    }

    private int getEndIndex(short[][] str, int cLine, short begin, short end) {
        int level = 0;
        for (int i = cLine; i < str.length; ++i) {
            int command = this.getOrder(str[i][0]);
            if (command == begin) {
                ++level;
                continue;
            }
            if (command != end || --level != 0) continue;
            return i;
        }
        return -1;
    }

    public void setEnd(int pathIndex) {
        String orderPath = (String)path.elementAt(pathIndex);
        this.getOrderEnd(this.vRoot, orderPath);
    }

    private short getOrderEnd(Vector vector, String orderPath) {
        int len = vector.size();
        if (len <= 0) {
            return 2;
        }
        int end = orderPath.indexOf(124, 1);
        if (end == -1) {
            end = orderPath.length();
        }
        int type = Event.sToi((String)vector.elementAt(0));
        int curLine = Event.sToi(orderPath.substring(1, end));
        switch (type) {
            case 1: {
                Object obj = vector.elementAt(curLine);
                if (obj instanceof Vector) {
                    Vector subclass = (Vector)obj;
                    String subName = orderPath.substring(end, orderPath.length());
                    short state = this.getOrderEnd(subclass, subName);
                    if (state == 2) {
                        String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                        vector.setElementAt(sCurLine, 2);
                        if (curLine == vector.size() - 1) {
                            vector.setElementAt("2", 1);
                            return 2;
                        }
                        return 0;
                    }
                    return 0;
                }
                String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                vector.setElementAt(sCurLine, 2);
                short[] tmp = (short[])vector.elementAt(curLine);
                tmp[0] = 2;
                if (curLine == vector.size() - 1) {
                    vector.setElementAt("2", 1);
                    return 2;
                }
                return 0;
            }
            case 0: {
                short result = 2;
                for (int i = 4; i < vector.size() - 1; ++i) {
                    Object obj = vector.elementAt(i);
                    if (obj instanceof Vector) {
                        Vector subclass = (Vector)obj;
                        if (i == curLine) {
                            String subName = orderPath.substring(end, orderPath.length());
                            short state = this.getOrderEnd(subclass, subName);
                            if (state == 2) continue;
                            result = 0;
                            continue;
                        }
                        int state = Event.sToi((String)subclass.elementAt(1));
                        if (state == 2) continue;
                        result = 0;
                        continue;
                    }
                    short[] tmp = (short[])obj;
                    if (i == curLine) {
                        tmp[0] = 2;
                    }
                    if (tmp[0] == 2) continue;
                    result = 0;
                }
                vector.setElementAt("" + result, 1);
                return result;
            }
        }
        return 2;
    }

    private void runOrder(Vector vector) {
        if (vector.size() <= 0) {
            return;
        }
        if (Event.sToi((String)vector.elementAt(1)) == 2) {
            return;
        }
        int type = Event.sToi((String)vector.elementAt(0));
        block0 : switch (type) {
            case 1: {
                int curLine = Event.sToi((String)vector.elementAt(2));
                Object obj = vector.elementAt(curLine);
                if (obj instanceof Vector) {
                    Vector subclass = (Vector)obj;
                    this.runOrder(subclass);
                    break;
                }
                short[] order = (short[])obj;
                int command = this.getCommand(order);
                switch (command) {
                    case 253: {
                        String condition = this.getCondition(exp[Event.getParamValue(order[3])]);
                        if (!Event.conditionIsTrue(Event.trim(condition))) {
                            curLine = vector.size() - 1;
                            vector.setElementAt("" + curLine, 2);
                            obj = vector.elementAt(curLine);
                            this.setEnd(((short[])obj)[1]);
                            return;
                        }
                        this.initVector(vector);
                        vector.setElementAt("" + ++curLine, 2);
                        this.runOrder(vector);
                        break block0;
                    }
                    case 255: {
                        String condition = this.getCondition(exp[Event.getParamValue(order[3])]);
                        String sCurLine = "";
                        if (Event.conditionIsTrue(Event.trim(condition))) {
                            ++curLine;
                        } else {
                            int elseIndex = this.getElseIndex(vector);
                            if (elseIndex != -1) {
                                curLine = elseIndex + 1;
                            } else {
                                curLine = vector.size() - 1;
                                sCurLine = "" + curLine;
                                vector.setElementAt(sCurLine, 2);
                                obj = vector.elementAt(curLine);
                                this.setEnd(((short[])obj)[1]);
                                return;
                            }
                        }
                        vector.setElementAt("" + curLine, 2);
                        this.runOrder(vector);
                        break block0;
                    }
                    case 239: 
                    case 251: {
                        String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                        vector.setElementAt(sCurLine, 2);
                        this.runOrder(vector);
                        break block0;
                    }
                    case 237: {
                        curLine = vector.size() - 1;
                        vector.setElementAt("" + curLine, 2);
                        obj = vector.elementAt(curLine);
                        this.setEnd(((short[])obj)[1]);
                        break block0;
                    }
                    case 238: 
                    case 250: 
                    case 254: {
                        String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                        vector.setElementAt(sCurLine, 2);
                        this.setEnd(((short[])obj)[1]);
                        break block0;
                    }
                    case 252: {
                        curLine = 3;
                        vector.setElementAt("" + curLine, 2);
                        this.runOrder(vector);
                        break block0;
                    }
                }
                this.parseOrder((short[])obj);
                break;
            }
            case 0: {
                for (int i = 4; i < vector.size() - 1; ++i) {
                    Object obj = vector.elementAt(i);
                    if (obj instanceof Vector) {
                        Vector subclass = (Vector)obj;
                        this.runOrder(subclass);
                        continue;
                    }
                    this.parseOrder((short[])obj);
                }
                break;
            }
        }
    }

    private void initVector(Vector v) {
        block5: for (int i = 0; i < v.size(); ++i) {
            Object obj = v.elementAt(i);
            switch (i) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    v.setElementAt("0", 1);
                    continue block5;
                }
                case 2: {
                    v.setElementAt("3", 2);
                    continue block5;
                }
                default: {
                    if (obj instanceof Vector) {
                        this.initVector((Vector)obj);
                        continue block5;
                    }
                    short[] order = (short[])obj;
                    order[0] = 0;
                }
            }
        }
    }

    private void parseOrder(short[] order) {
        if (order[0] != 0) {
            return;
        }
        order[0] = 1;
        int command = this.getCommand(order);
        block0 : switch (command) {
            case 1: {
                int result = Event.getInt(order[3]);
                if (this.id >= 0) {
                    Script.scriptVar[this.id] = (byte)result;
                    if (result > 0) {
                        this.eventIsAlive = false;
                    }
                }
                if (isChangeMap) {
                    Event.changeMap();
                }
                if (!isBreakBattle) break;
                isBreakBattle = false;
                break;
            }
            case 2: {
                int mapID = Event.getInt(order[3]);
                int x = Event.getInt(order[4]);
                int y = Event.getInt(order[5]);
                int dir = Event.getInt(order[6]);
                boolean visible = Event.getBool(order[7]);
                Event.toMap(mapID, x, y, dir, visible);
                GameEngine.stopCurSprite();
                if (Script.scriptVar[15] != 1) break;
                MyGameCanvas.isChange = true;
                break;
            }
            case 3: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int id = Event.getInt(order[4]);
                int val = Event.getInt(order[5]);
                if (isAdd) {
                    GameEngine.getItem_jb(id, val);
                    break;
                }
                GameEngine.delItem_jb(id, val);
                break;
            }
            case 4: {
                int iconID = Event.getInt(order[3]);
                int derection = Event.getInt(order[4]);
                String title = Event.getString(order[5]);
                String text = Event.getString(order[6]);
                MyGameCanvas.initTalk((byte)iconID, (byte)derection, title, text, false, false);
                GameEngine.stopCurSprite();
                break;
            }
            case 5: {
                Script.isUserCtrl = Event.getBool(order[3]);
                if (!Script.isUserCtrl) {
                    GameEngine.sprite[0].nextSpeed = 4;
                    GameEngine.sprite[0].speed = 4;
                }
                GameEngine.stopCurSprite();
                for (int i = 0; i < GameEngine.sprite.length; ++i) {
                    if (GameEngine.sprite[i].modle != 3) continue;
                    GameEngine.sprite[i].changeModle(0);
                    GameEngine.stopYujian();
                    GameEngine.isYuJian = false;
                    GameEngine.sprite[0].nextSpeed = 4;
                    GameEngine.sprite[0].speed = 4;
                }
                break;
            }
            case 6: {
                String str1 = Event.getString(order[3]);
                String str2 = Event.getString(order[4]);
                this.set(str1, str2);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                int id = Event.getInt(order[3]);
                int x = Event.getInt(order[4]);
                int y = Event.getInt(order[5]);
                GameEngine.sprite[id].sender(this, order[1]);
                GameEngine.sprite[id].setNextPoint(x, y);
                return;
            }
            case 9: {
                waitTime = Event.getInt(order[4]);
                break;
            }
            case 10: {
                int npcId = Event.getInt(order[3]);
                int x = Event.getInt(order[5]);
                int y = Event.getInt(order[6]);
                int dir = Event.getInt(order[7]);
                GameEngine.sprite[npcId].setStates(-1);
                GameEngine.sprite[npcId].setVisible(x, y, dir);
                break;
            }
            case 11: {
                int npcId = Event.getInt(order[3]);
                GameEngine.sprite[npcId].setUnVisible();
                break;
            }
            case 12: {
                int npcId = Event.getInt(order[3]);
                int dir = Event.getInt(order[4]);
                GameEngine.sprite[npcId].setDir(dir);
                break;
            }
            case 13: {
                int face = Event.getInt(order[4]);
                if (face >= 0 && face <= 6) {
                    GameEngine.sprite[Event.getInt(order[3])].showFace(face);
                    GameEngine.sprite[Event.getInt(order[3])].sender(this, order[1]);
                    return;
                }
                GameEngine.sprite[Event.getInt(order[3])].showFace(face);
                break;
            }
            case 14: {
                int npcId = Event.getInt(order[3]);
                boolean isBack = Event.getBool(order[4]);
                int steps = Event.getInt(order[5]);
                boolean isCurSprite = Event.getBool(order[6]);
                npcId = isCurSprite ? GameEngine.spriteIndex : npcId;
                GameEngine.sprite[npcId].step(isBack, steps);
                GameEngine.sprite[npcId].sender(this, order[1]);
                return;
            }
            case 15: {
                return;
            }
            case 16: {
                boolean isBack = Event.getBool(order[3]);
                String title = Event.getString(order[4]);
                String[] options = Event.getParams(Event.getString(order[5]), ",");
                GameEngine.toChooseStatus(title, options, isBack);
                GameEngine.stopCurSprite();
                break;
            }
            case 17: {
                GameEngine.isToPoint = false;
                String[] params = Event.getParams(Event.getString(order[3]), ",");
                if (params.length == 1) {
                    int spriteID = Event.sToi(params[0]);
                    GameEngine.spriteIndex = (byte)spriteID;
                } else {
                    int x = Event.sToi(params[0]);
                    int y = Event.sToi(params[1]);
                    GameEngine.posX = x;
                    GameEngine.posY = y;
                    GameEngine.isToPoint = true;
                }
                GameEngine.map.sender(this, order[1]);
                GameMap.isMoveScreen = true;
                GameEngine.stopCurSprite();
                return;
            }
            case 18: {
                GameEngine.setGameFinish();
                break;
            }
            case 19: {
                short[] team = Event.getArray(order[3]);
                GameEngine.roleTeam = new byte[team.length];
                for (int i = 0; i < team.length; ++i) {
                    GameEngine.roleTeam[i] = (byte)team[i];
                }
                break;
            }
            case 20: {
                int type = Event.getInt(order[3]);
                int pec = Event.getInt(order[4]);
                int lv = Event.getInt(order[5]);
                String name = Event.getString(order[6]);
                GameEngine.addEnemy(type, pec, lv, name);
                break;
            }
            case 21: {
                boolean isBoss = Event.getBool(order[3]);
                boolean isLost = Event.getBool(order[4]);
                String str = Event.getString(order[5]);
                if (str.equals("null")) {
                    Script.curBattleEvent = null;
                } else {
                    String[] params = Event.getParams(str, ",");
                    Script.curBattleEvent = new int[params.length];
                    for (int i = 0; i < Script.curBattleEvent.length; ++i) {
                        Script.curBattleEvent[i] = Event.sToi(params[i]);
                    }
                }
                GameEngine.toBattle(isBoss, isLost);
                GameEngine.stopCurSprite();
                break;
            }
            case 22: {
                Event.breakBattle();
                break;
            }
            case 23: {
                MyGameCanvas.curTask = (short)Event.getInt(order[3]);
                break;
            }
            case 105: {
                for (int i = 0; i < MyGameCanvas.branchTask[0].length; ++i) {
                    if (MyGameCanvas.branchTask[0][i] != -1) continue;
                    MyGameCanvas.branchTask[0][i] = (byte)Event.getInt(order[3]);
                    break;
                }
                MyGameCanvas.otherTaskLength = (byte)(MyGameCanvas.otherTaskLength + 1);
                break;
            }
            case 106: {
                for (int i = 0; i < MyGameCanvas.branchTask[0].length; ++i) {
                    if (MyGameCanvas.branchTask[0][i] != (byte)Event.getInt(order[3])) continue;
                    MyGameCanvas.branchTask[1][i] = (byte)Event.getInt(order[4]);
                    break block0;
                }
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                boolean isAdd = Event.getString(order[3]).equals("true");
                int id = Event.getInt(order[4]);
                int skillId = Event.getInt(order[5]);
                if (!isAdd) break;
                GameEngine.getSkill(GameEngine.role[id], skillId);
                break;
            }
            case 26: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int id = Event.getInt(order[4]);
                int val = Event.getInt(order[5]);
                if (isAdd) {
                    GameEngine.getEqu_jb(id, 1);
                    break;
                }
                GameEngine.delEqu_jb(id, 1);
                break;
            }
            case 103: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int id = Event.getInt(order[4]);
                int val = Event.getInt(order[5]);
                byte level = (byte)Event.getInt(order[6]);
                byte goal = (byte)Event.getInt(order[7]);
                byte randomAss = (byte)Event.getInt(order[8]);
                if (isAdd) {
                    GameEngine.getMakeEqu_jb((byte)id, (byte)1, (byte)0, level, goal, randomAss);
                    break;
                }
                GameEngine.delMakeEqu_jb((byte)id, (byte)1, level, goal, randomAss);
                break;
            }
            case 27: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int id = Event.getInt(order[4]);
                int val = Event.getInt(order[5]);
                if (isAdd) {
                    GameEngine.getMaterial_jb(id, val);
                    break;
                }
                GameEngine.delMaterial_jb(id, val);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int id = Event.getInt(order[4]);
                int exp = Event.getInt(order[5]);
                if (!isAdd) break;
                GameEngine.role[id].exp += exp;
                break;
            }
            case 31: {
                boolean isAdd = Event.getString(order[3]).equals("add");
                int num = Event.getInt(order[4]);
                GameEngine.getMoney(isAdd ? num : -num);
                break;
            }
            case 32: {
                int type = Event.getInt(order[3]);
                int x = Event.getInt(order[4]) + GameMap.tileWidth / 2;
                int y = Event.getInt(order[5]) - GameMap.tileWidth / 2;
                int isMirror = Event.getInt(order[6]) == 0 ? 0 : 1;
                Effect.AddEffectList(x, y, type, isMirror, y + 40);
                break;
            }
            case 33: {
                break;
            }
            case 35: {
                int value = GameEngine.nextInt(Event.getInt(order[4]), Event.getInt(order[5]));
                this.set(Event.getString(order[3]), value + "");
                break;
            }
            case 36: {
                Tools.removeAllSinleImage(new int[]{232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273});
                GameMap.CGId = (byte)Event.getInt(order[3]);
                GameMap.isShowCG = true;
                GameEngine.me.weatherIndex = 0;
                break;
            }
            case 37: {
                String text = Event.getString(order[3]);
                MyGameCanvas.ToAside(MyGameCanvas.changeString(text, 9));
                break;
            }
            case 38: {
                int npcId = Event.getInt(order[3]);
                int speedLev = Event.getInt(order[4]);
                GameEngine.sprite[npcId].changeSpeed(speedLev);
                break;
            }
            case 39: {
                int npcId = Event.getInt(order[3]);
                int freqLev = Event.getInt(order[4]);
                GameEngine.sprite[npcId].changeFreq(freqLev);
                break;
            }
            case 40: {
                short[] equips = Event.getArray(order[3]);
                byte[] gods = new byte[equips.length];
                for (int i = 0; i < equips.length; ++i) {
                    gods[i] = (byte)equips[i];
                }
                MyGameCanvas.me.initEquipMentBuyData(gods);
                MyGameCanvas.setST((byte)55);
                GameEngine.stopCurSprite();
                break;
            }
            case 41: {
                short[] items = Event.getArray(order[3]);
                byte[] gods = new byte[items.length];
                for (int i = 0; i < items.length; ++i) {
                    gods[i] = (byte)items[i];
                }
                MyGameCanvas.me.initItemBuyData(gods);
                MyGameCanvas.setST((byte)53);
                GameEngine.stopCurSprite();
                break;
            }
            case 108: {
                short[] items = Event.getArray(order[3]);
                byte[] gods = new byte[items.length];
                for (int i = 0; i < items.length; ++i) {
                    gods[i] = (byte)items[i];
                }
                MyGameCanvas.me.initMaterialBuyData(gods);
                MyGameCanvas.setST((byte)67);
                GameEngine.stopCurSprite();
                break;
            }
            case 42: {
                MyGameCanvas.initSale();
                GameEngine.stopCurSprite();
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                GameEngine.setMaxMotives(GameEngine.roleTeam);
                break;
            }
            case 45: {
                MyGameCanvas.setST((byte)12);
                MyGameCanvas.me.isSave = true;
                break;
            }
            case 46: {
                int roleId = Event.getInt(order[3]);
                int lev = Event.getInt(order[4]);
                GameEngine.role[roleId].setLevel(lev);
                if (lev != 60) break;
                GameEngine.addItem(1, (byte)2, (byte)1);
                GameEngine.addItem(1, (byte)7, (byte)1);
                GameEngine.addItem(1, (byte)14, (byte)1);
                break;
            }
            case 47: {
                int music = Event.getInt(order[3]);
                int loop = Event.getInt(order[4]);
                GameMap.curMusic = (byte)music;
                if (loop == 0) {
                    SoundPlayerUtil.stopCurMusic();
                    break;
                }
                SoundPlayerUtil.playmusic(GameMap.curMusic, loop);
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                GameEngine.isShowGame = Event.getBool(order[3]);
                break;
            }
            case 50: {
                GameEngine.isScreenFlash = Event.getBool(order[3]);
                break;
            }
            case 51: {
                int npcId = Event.getInt(order[3]);
                byte statusID = (byte)Event.getInt(order[4]);
                GameEngine.sprite[npcId].setStates(statusID);
                break;
            }
            case 52: {
                GameEngine.stopBomb = !Event.getBool(order[3]);
                break;
            }
            case 53: {
                int time = Event.getInt(order[3]);
                int colorIndex = Event.getInt(order[4]);
                int[] colorType = new int[]{0xFFFFFF, 0xFF0000, 255, 0xFFFF00, 65280, 0};
                GameEngine.setScreenFlash(time, colorType[colorIndex]);
                break;
            }
            case 54: {
                int time = Event.getInt(order[3]);
                if (time == -1) {
                    time = 999999;
                }
                GameEngine.shakeTime = time;
                break;
            }
            case 55: {
                Battle.stopBattle = Event.getBool(order[3]);
                break;
            }
            case 56: {
                GameEngine.setMaxMotives(GameEngine.roleTeam);
                break;
            }
            case 57: {
                int npcId = Event.getInt(order[3]);
                GameEngine.sprite[npcId].setRunXY(Event.getArray(order[4]));
                break;
            }
            case 58: {
                int id = Event.getInt(order[3]);
                int modle = Event.getInt(order[4]);
                System.out.println("ddddddddddddddddddddddddddddd");
                GameEngine.sprite[id].changeModle(modle);
                break;
            }
            case 61: {
                break;
            }
            case 62: {
                String[] params = Event.getParams(Event.getString(order[3]), ",");
                if (params[0].equals("null")) {
                    GameMap.infoMapId = -1;
                    break;
                }
                GameMap.infoMapId = Event.sToi(params[0]);
                GameMap.infoX = Event.sToi(params[1]);
                GameMap.infoY = Event.sToi(params[2]);
                break;
            }
            case 63: {
                return;
            }
            case 64: {
                return;
            }
            case 65: {
                break;
            }
            case 67: {
                GameMap.blackBG = Event.getBool(order[3]);
                break;
            }
            case 74: {
                int npcId = Event.getInt(order[3]);
                int isMotion = Event.getInt(order[4]);
                GameEngine.sprite[npcId].isMotion = (byte)isMotion;
                break;
            }
            case 75: {
                lastMap = GameEngine.gameRank;
                lastX = GameEngine.sprite[GameEngine.spriteIndex].x;
                lastY = GameEngine.sprite[GameEngine.spriteIndex].y;
                lastDir = GameEngine.sprite[GameEngine.spriteIndex].dir;
                break;
            }
            case 76: {
                int mapID = lastMap;
                int x = lastX;
                int y = lastY;
                int dir = lastDir;
                boolean visible = true;
                Event.toMap(mapID, x, y, dir, visible);
                GameEngine.stopCurSprite();
                break;
            }
            case 77: {
                break;
            }
            case 80: {
                String title = Event.getString(order[3]);
                String text = Event.getString(order[4]);
                MyGameCanvas.initTalk(0, 0, title, text, false, true);
                GameEngine.stopCurSprite();
                break;
            }
            case 81: {
                int result = Event.getInt(order[3]);
                if (this.id >= 0 && !GameEngine.isBattle) {
                    Script.scriptVar[this.id] = (byte)result;
                }
                this.eventIsAlive = false;
                this.isReturn = true;
                if (isChangeMap) {
                    Event.changeMap();
                }
                if (!isBreakBattle) break;
                isBreakBattle = false;
                GameEngine.me.battle.battleOverClear();
                MyGameCanvas.setST((byte)14);
                break;
            }
            case 82: {
                short[] tmp = Event.getArray(order[3]);
                GameMap.fzType1 = (byte)tmp[0];
                GameMap.fzXY1 = new short[2];
                GameMap.fzXY1[0] = (short)(tmp[1] + GameMap.tileWidth / 2);
                GameMap.fzXY1[1] = (short)(tmp[2] - GameMap.tileWidth / 2);
                GameMap.isDrawFZ1 = true;
                break;
            }
            case 83: {
                GameMap.fzXY1 = null;
                GameMap.isDrawFZ1 = false;
                break;
            }
            case 84: {
                short[] tmp = Event.getArray(order[3]);
                GameMap.fzType2 = (byte)tmp[0];
                GameMap.fzXY2 = new short[2];
                GameMap.fzXY2[0] = (short)(tmp[1] + GameMap.tileWidth / 2);
                GameMap.fzXY2[1] = (short)(tmp[2] - GameMap.tileWidth / 2);
                GameMap.isDrawFZ2 = true;
                break;
            }
            case 85: {
                GameMap.fzXY2 = null;
                GameMap.isDrawFZ2 = false;
                break;
            }
            case 86: {
                int id = Event.getInt(order[3]);
                GameEngine.sprite[id].setStates(16);
                GameEngine.sprite[id].sender(this, order[1]);
                return;
            }
            case 87: {
                int id = Event.getInt(order[3]);
                break;
            }
            case 88: {
                int id = Event.getInt(order[3]);
                break;
            }
            case 89: {
                byte music = (byte)Event.getInt(order[3]);
                GameMap.curMusic = music;
                break;
            }
            case 90: {
                int id = Event.getInt(order[3]);
                MyMessage cfr_ignored_0 = MyGameCanvas.me.msg;
                if (!MyMessage.canSendAgian(id)) break;
                MyGameCanvas.me.msg.toSendState(0);
                break;
            }
            case 91: {
                GameEngine.roleIsMagicOff();
                break;
            }
            case 92: {
                GameEngine.roleIsMagicOn(false);
                break;
            }
            case 93: {
                GameMap.isShowCG = false;
                GameMap.index = 0;
                GameEngine.me.cgFree();
                break;
            }
            case 96: {
                GameSprite.isCurIndex = Event.getBool(order[3]);
                GameSprite.spriteCurIndex = (byte)Event.getInt(order[4]);
                break;
            }
            case 97: {
                GameSprite.isSleep = Event.getBool(order[3]);
                break;
            }
            case 94: {
                GameSprite.isAppear = Event.getBool(order[3]);
                break;
            }
            case 95: {
                GameSprite.snakeAppID = (byte)Event.getInt(order[3]);
                break;
            }
            case 98: {
                GameEngine.sprite[GameEngine.sprite.length - 1].fighterState = (byte)Event.getInt(order[3]);
                GameEngine.sprite[GameEngine.sprite.length - 1].curIndex = 0;
                if (GameEngine.sprite[GameEngine.sprite.length - 1].fighterState != 1) break;
                GameEngine.sprite[GameEngine.sprite.length - 1].sender(this, order[1]);
                return;
            }
            case 99: {
                Effect.curEfftId = (byte)Event.getInt(order[3]);
                Effect.isDelayEfft = Event.getBool(order[4]);
                break;
            }
            case 100: {
                MyGameCanvas.isSpecial = Event.getBool(order[3]);
                String text = Event.getString(order[4]);
                MyGameCanvas.ToAside(MyGameCanvas.changeString(text, 9));
                break;
            }
            case 101: {
                GameEngine.isCloseScreen = Event.getBool(order[3]);
                GameEngine.whichWord = (byte)Event.getInt(order[4]);
                break;
            }
            case 102: {
                GameEngine.isCloseScreen1 = Event.getBool(order[3]);
                break;
            }
            case 104: {
                GameEngine.role[0].level = (byte)Event.getInt(order[3]);
                GameEngine.role[0].activeIndex = (byte)Event.getInt(order[4]);
                GameEngine.role[0].updateRoleProperty();
                if (GameEngine.role[0].level != 50) break;
                GameEngine.addItem(1, (byte)2, (byte)1);
                GameEngine.addItem(1, (byte)7, (byte)1);
                GameEngine.addItem(1, (byte)14, (byte)1);
                break;
            }
            case 107: {
                byte aId = (byte)Event.getInt(order[3]);
                MyGameCanvas.AchieveMentID[aId] = 1;
                MyGameCanvas.setFinish(MyGameCanvas.achieveMent[aId][0]);
                GameEngine.sprite[0].sender(this, order[1]);
                MyGameCanvas.isSender = true;
                return;
            }
            case 109: {
                boolean isRun;
                GameMap.isRunGame = isRun = Event.getBool(order[3]);
                break;
            }
            case 110: {
                for (int i = 0; i < GameEngine.roleTeam.length; ++i) {
                    byte addIndex = (byte)Event.getInt(order[3]);
                    GameEngine.role[GameEngine.roleTeam[i]].totalIndex = (byte)(GameEngine.role[GameEngine.roleTeam[i]].totalIndex + addIndex);
                    MyGameCanvas.ToAside(MyGameCanvas.changeString("\u83b7\u5f97" + addIndex + "\u6280\u80fd\u70b9", 9));
                }
                break;
            }
            case 111: {
                GameEngine.divideBag();
                MyGameCanvas.bagKindIndex = 1;
                GameEngine.stopCurSprite();
                MyGameCanvas.setST((byte)Event.getInt(order[3]));
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                isTeach = true;
                MyGameCanvas.setST((byte)50);
                MyGameCanvas.me.mainMenuIndex = (byte)3;
            }
        }
        this.setEnd(order[1]);
    }

    public static void stopCurSprite() {
        if (GameEngine.sprite[GameEngine.spriteIndex].curStates == -2) {
            GameEngine.sprite[GameEngine.spriteIndex].setStates(-1);
            GameEngine.sprite[GameEngine.spriteIndex].index = 0;
        }
    }

    public static void toMap(int id, int x, int y, int direct, boolean visible) {
        mapID = id;
        posX = x;
        posY = y;
        dir = direct;
        isChangeMap = true;
        isVisible = visible;
        GameEngine.isCloseScreen1 = false;
        GameEngine.tempIndex = 0;
    }

    public static void changeMap() {
        GameEngine.setPlayXY(posX, posY, dir, isVisible);
        GameEngine.setRankEnd(mapID);
    }

    public static void breakBattle() {
        isBreakBattle = true;
        Battle.battleResult = 1;
    }

    public static String[] splitString(String src, String key) {
        Vector<String> vt = new Vector<String>();
        int w = 0;
        boolean end = false;
        while (!end) {
            String s;
            int pos = src.indexOf(key, w);
            if (pos == -1) {
                pos = src.length();
                end = true;
            }
            int endIndex = pos;
            if (pos > 0 && src.charAt(pos - 1) == '\r') {
                endIndex = pos - 1;
            }
            if (!(s = src.substring(w, endIndex).trim()).equals("")) {
                vt.addElement(s);
            }
            w = pos + 1;
        }
        Object[] cs = new String[vt.size()];
        vt.copyInto(cs);
        vt = null;
        return cs;
    }

    private String getCommand(String script) {
        String s = script.indexOf(32) != -1 ? script.substring(0, script.indexOf(32)) : script.substring(0, script.length());
        return s;
    }

    private int getCommand(short[] script) {
        return this.getOrder(script[2]);
    }

    public static String[] getParams(String order, String key) {
        String[] s = Event.splitString(order, key);
        return s;
    }

    public boolean runInitEvent() {
        this.runOrder(this.vRoot);
        return Event.sToi((String)this.vRoot.elementAt(1)) == 2;
    }

    public static int sToi(String s) {
        return Event.getIntValue(s);
    }

    public static short sTos(String s) {
        return Short.parseShort(s);
    }

    private String getCondition(String script) {
        return script;
    }

    private static int getFlagIndex(String string) {
        int level = 0;
        for (int i = 0; i < string.length(); ++i) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (i <= 0 || level != 0 || tempChar != '&' && tempChar != '@') continue;
            return i;
        }
        return -1;
    }

    private static boolean getCompValue(String string) {
        int flagIndex = -1;
        for (int i = 0; i < string.length(); ++i) {
            char tempChar = string.charAt(i);
            if (tempChar != '>' && tempChar != '<' && tempChar != '=' && tempChar != '~') continue;
            flagIndex = i;
        }
        if (flagIndex == -1) {
            boolean notIsExist;
            boolean bl = notIsExist = string.indexOf(33) != -1;
            return notIsExist ? !Event.getBoolValue(string.substring(1, string.length())) : Event.getBoolValue(string);
        }
        String first = string.substring(0, flagIndex);
        String second = string.substring(flagIndex + 1, string.length());
        boolean result = false;
        switch (string.charAt(flagIndex)) {
            case '>': {
                result = Event.getIntValue(first) > Event.getIntValue(second);
                break;
            }
            case '<': {
                result = Event.getIntValue(first) < Event.getIntValue(second);
                break;
            }
            case '=': {
                result = Event.getIntValue(first) == Event.getIntValue(second);
                break;
            }
            case '~': {
                result = Event.getIntValue(first) != Event.getIntValue(second);
            }
        }
        return result;
    }

    private static String getSubString(String string, int start, int end) {
        int i;
        String tempString = string.substring(start, end);
        int level = 0;
        isNot = false;
        int flagStart = 0;
        for (i = 0; i < tempString.length() && tempString.charAt(i) == '!' && i == flagStart; ++flagStart, ++i) {
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            for (i = flagStart + 1; i < tempString.length(); ++i) {
                char tempChar = tempString.charAt(i);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level != 0 || i >= tempString.length() - 1) continue;
                return tempString;
            }
            boolean bl = isNot = flagStart % 2 != 0;
            if (isNot) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        return tempString;
    }

    public static synchronized boolean conditionIsTrue(String condition) {
        int operator = 0;
        boolean result = false;
        int flag = 120;
        boolean isTmpNot = false;
        String allSub = condition;
        allSub = Event.getSubString(allSub, 0, allSub.length());
        isTmpNot = isNot;
        operator = Event.getFlagIndex(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            for (int i = 0; i < allSub.length(); ++i) {
                char tempChar = allSub.charAt(i);
                if (tempChar != '&' && tempChar != '@' && tempChar != '(') continue;
                isExpression = true;
                break;
            }
            if (isExpression) {
                if (isTmpNot) {
                    return !Event.conditionIsTrue(allSub);
                }
                return Event.conditionIsTrue(allSub);
            }
            if (isTmpNot) {
                return !Event.getCompValue(allSub);
            }
            return Event.getCompValue(allSub);
        }
        boolean first = Event.conditionIsTrue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        boolean second = Event.conditionIsTrue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 38: {
                result = first && second;
                break;
            }
            case 64: {
                result = first || second;
            }
        }
        return result;
    }

    private static String getSubString_Var(String string, int start, int end) {
        int i;
        String tempString = string.substring(start, end);
        int level = 0;
        minus = false;
        int flagStart = 0;
        for (i = 0; i < tempString.length() && tempString.charAt(i) == '^' && i == flagStart; ++flagStart, ++i) {
            minus = true;
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            for (i = flagStart + 1; i < tempString.length(); ++i) {
                char tempChar = tempString.charAt(i);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level != 0 || i >= tempString.length() - 1) continue;
                return tempString;
            }
            if (minus) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        if (minus) {
            return tempString.substring(flagStart, tempString.length());
        }
        return tempString;
    }

    private static int getFlag4Index(String string) {
        int level = 0;
        for (int i = 0; i < string.length(); ++i) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (level != 0 || tempChar != '+' && tempChar != '-' && tempChar != '*' && tempChar != '/' && tempChar != '%') continue;
            return i;
        }
        return -1;
    }

    private static synchronized int arithValue(String expression) {
        int operator = 0;
        int first = 0;
        int second = 0;
        int result = 0;
        int flag = 120;
        boolean isTmpminus = false;
        String allSub = expression;
        allSub = Event.getSubString_Var(allSub, 0, allSub.length());
        isTmpminus = minus;
        operator = Event.getFlag4Index(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            for (int i = 0; i < allSub.length(); ++i) {
                char tempChar = allSub.charAt(i);
                if (tempChar != '+' && tempChar != '-' && tempChar != '*' && tempChar != '/' && tempChar != '%' && tempChar != '^' && tempChar != '(') continue;
                isExpression = true;
                break;
            }
            if (isExpression) {
                if (isTmpminus) {
                    return -Event.arithValue(allSub);
                }
                return Event.arithValue(allSub);
            }
            if (isTmpminus) {
                return -Event.getIntValue(allSub);
            }
            return Event.getIntValue(allSub);
        }
        first = Event.arithValue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        second = Event.arithValue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 43: {
                result = first + second;
                break;
            }
            case 45: {
                result = first - second;
                break;
            }
            case 42: {
                result = first * second;
                break;
            }
            case 47: {
                result = first / second;
                break;
            }
            case 37: {
                result = first % second;
            }
        }
        return result;
    }

    static boolean getBoolValue(String paramName) {
        block8: {
            String param;
            block7: {
                param = paramName.trim();
                if (param.equals("true")) {
                    return true;
                }
                if (param.equals("false")) {
                    return false;
                }
                if (param.equals("KEY_OK")) {
                    return MyGameCanvas.confirmKey;
                }
                if (param.equals("isWin")) {
                    return Battle.battleResult == 1;
                }
                if (param.equals("checkModle")) {
                    System.out.println("GameEngine.checkModle(3) = " + GameEngine.checkModle(3));
                    return GameEngine.checkModle(3);
                }
                if (!param.equals("checkEquip")) break block7;
                GameEngine.divideBag();
                for (int i = 0; i < MyGameCanvas.equDat.length; ++i) {
                    if (MyGameCanvas.equDat[i] == null || MyGameCanvas.equDat[i][1] != 1 || MyGameCanvas.equDat[i][3] != 2 || MyGameCanvas.equDat[i][4] != 0) continue;
                    return true;
                }
                break block8;
            }
            if (!param.equals("checkTaskItem")) break block8;
            GameEngine.divideBag();
            for (int i = 0; i < MyGameCanvas.itemDat.length; ++i) {
                if (MyGameCanvas.itemDat[i] == null || MyGameCanvas.itemDat[i][1] != 17) continue;
                return true;
            }
        }
        return false;
    }

    public static String getStrValue(String paramName) {
        String param = paramName.trim();
        return "!!!error string!!!";
    }

    public static String[] parseArray(String paramName) {
        int index = paramName.indexOf("[");
        if (index == -1) {
            return null;
        }
        String[] buff = new String[]{paramName.substring(0, index), paramName.substring(index + 1, paramName.indexOf("]"))};
        return buff;
    }

    private static int getArrayValue(String[] param) {
        String name = param[0];
        int id = Event.sToi(param[1]);
        if (name.equals("event")) {
            return Script.scriptVar[id];
        }
        if (name.equals("level")) {
            return GameEngine.role[id].level;
        }
        if (name.equals("point")) {
            return MyMessage.canSendAgian(id) ? 0 : 1;
        }
        System.out.println("get array value error !!!   " + name);
        return Integer.MAX_VALUE;
    }

    public static int getNum(Vector v, int id) {
        if (v == null) {
            return 0;
        }
        for (int i = 0; i < v.size(); ++i) {
            short[] temp = (short[])v.elementAt(i);
            if (temp[0] != id) continue;
            return temp[1];
        }
        return 0;
    }

    private void setArrayValue(String[] param, int val) {
        String name = param[0];
        int id = Event.sToi(param[1]);
        if (name.equals("event")) {
            Script.scriptVar[id] = (byte)val;
        } else {
            System.out.println("set array value error !!!    " + name);
        }
    }

    private static int getIntValue(String paramName) {
        String param = paramName.trim();
        try {
            return Integer.parseInt(paramName);
        }
        catch (NumberFormatException e) {
            String[] array = Event.parseArray(param);
            if (array != null) {
                return Event.getArrayValue(array);
            }
            if (param.equals("temp")) {
                return Script.temp;
            }
            if (param.toLowerCase().equals("choice")) {
                return MyGameCanvas.choice;
            }
            if (param.equals("battleResult")) {
                return Battle.battleResult;
            }
            if (param.equals("money")) {
                return GameEngine.money;
            }
            if (param.equals("roleLevel")) {
                return GameEngine.role[0].level;
            }
            System.out.println("get int value error !!!     " + paramName);
            return Integer.MAX_VALUE;
        }
    }

    private void set(String varName, String expression) {
        String[] array = Event.parseArray(varName);
        int val = Event.arithValue(expression);
        if (array != null) {
            this.setArrayValue(array, val);
            return;
        }
        if (varName.equals("temp")) {
            Script.temp = Event.arithValue(expression);
        }
    }

    public static String parseStr(String str) {
        StringBuffer buff = new StringBuffer();
        boolean isTxt = true;
        StringBuffer varName = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                isTxt = false;
                continue;
            }
            if (c == '>') {
                isTxt = true;
                String[] s = Event.getParams(varName.toString(), " ");
                if (s[0].equals("int")) {
                    buff.append(Event.getIntValue(s[1]));
                } else if (s[0].equals("str")) {
                    buff.append(Event.getStrValue(s[1]));
                }
                varName = new StringBuffer();
                continue;
            }
            if (isTxt) {
                buff.append(c);
                continue;
            }
            varName.append(c);
        }
        return buff.toString();
    }

    static {
        path = new Vector();
        curSprite = (byte)-1;
        isMotion = 0;
        index = 0;
        frameTimes = 0;
        roleHp = 0;
        roleMp = 0;
        roleLev = 0;
        roleExp = 0;
        roleMoney = 0;
        isNot = false;
        minus = false;
    }
}

