/*
 * Decompiled with CFR 0.152.
 */
package JAMine.solver;

import JAMine.JAgamecanvas;
import java.util.Vector;

public final class MineAI {
    private int rows;
    private int cols;
    private byte level;
    private static final int ADJ_MINES = 15;
    private static final int FLAGP1 = 32;
    private static final int FLAGP2 = 64;
    private static final int UNCOVERED = 128;
    byte[][] mineField;
    private static final int NOFLAG = 15;
    private static final int FLAG1C = 1;
    private static final int FLAG1U = 2;
    private static final int FLAG2C = 4;
    private static final int FLAG2U = 8;
    private static final int SAFE = 32;
    byte[][] status;
    short[][] riskProbs;
    public int x;
    public int y;
    Vector moves;

    public MineAI(byte[][] pMineField, int pRows, int pCols, byte pLevel) {
        this.rows = pRows;
        this.cols = pCols;
        this.level = pLevel;
        this.mineField = pMineField;
        this.status = new byte[this.rows][this.cols];
        this.riskProbs = new short[this.rows][this.cols];
        Object var5_5 = null;
        long l = 0L;
        Object var8_7 = null;
        l = JAgamecanvas._n();
        JAgamecanvas.rand.setSeed(l);
        this.moves = new Vector(8, 1);
    }

    public boolean play(int pRemainingMines) {
        int c;
        int r;
        int j;
        int j2;
        this.x = -1;
        this.y = -1;
        boolean found = false;
        int i = 0;
        while (i < this.rows) {
            j2 = 0;
            while (j2 < this.cols) {
                byte[] byArray = this.status[i];
                int n = j2++;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFDF);
            }
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            j2 = 0;
            while (j2 < this.cols) {
                if (JAgamecanvas.testFlag(this.mineField[i][j2], 32) && this.noFlag(this.status[i][j2])) {
                    byte[] byArray = this.status[i];
                    int n = j2;
                    byArray[n] = (byte)(byArray[n] | 2);
                }
                if (!JAgamecanvas.testFlag(this.mineField[i][j2], 32) && !JAgamecanvas.testFlag(this.mineField[i][j2], 64)) {
                    byte[] byArray = this.status[i];
                    int n = j2;
                    byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                }
                ++j2;
            }
            ++i;
        }
        int adjMines = 0;
        int adjCPUFlags = 0;
        int adjPlayerFlags = 0;
        int adjEmptyCells = 0;
        int adjSafeCells = 0;
        byte curValue = 0;
        byte curSubValue = 0;
        int globalEmptyCells = 0;
        this.moves.removeAllElements();
        int i2 = 0;
        while (i2 < this.rows) {
            j = 0;
            while (j < this.cols) {
                curValue = this.mineField[i2][j];
                if (!JAgamecanvas.testFlag(curValue, 128)) {
                    if (this.noFlag(this.status[i2][j])) {
                        ++globalEmptyCells;
                    }
                } else {
                    adjMines = JAgamecanvas.getAdjMines(curValue);
                    if (adjMines != 0) {
                        adjEmptyCells = 0;
                        adjCPUFlags = 0;
                        adjPlayerFlags = 0;
                        this.x = -1;
                        this.y = -1;
                        r = i2 - 1;
                        while (r <= i2 + 1) {
                            c = j - 1;
                            while (c <= j + 1) {
                                if (r >= 0 && c >= 0 && r < this.rows && c < this.cols && !JAgamecanvas.testFlag(curSubValue = this.mineField[r][c], 128)) {
                                    if (!JAgamecanvas.testFlag(curSubValue, 32) && !JAgamecanvas.testFlag(curSubValue, 64)) {
                                        ++adjEmptyCells;
                                        this.moves.addElement(new int[]{r, c});
                                    } else if (JAgamecanvas.testFlag(this.status[r][c], 2) || JAgamecanvas.testFlag(this.status[r][c], 8)) {
                                        ++adjPlayerFlags;
                                        this.moves.addElement(new int[]{r, c});
                                    } else if (JAgamecanvas.testFlag(this.status[r][c], 4) || JAgamecanvas.testFlag(this.status[r][c], 1)) {
                                        ++adjCPUFlags;
                                    }
                                }
                                ++c;
                            }
                            ++r;
                        }
                        if (this.checkMoves(i2, j, this.moves, adjMines, pRemainingMines, adjEmptyCells, adjCPUFlags, adjPlayerFlags)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (this.level > 0) {
            this.moves.removeAllElements();
            i2 = 0;
            while (i2 < this.rows) {
                j = 0;
                while (j < this.cols) {
                    curValue = this.mineField[i2][j];
                    if (JAgamecanvas.testFlag(curValue, 128) && (adjMines = JAgamecanvas.getAdjMines(curValue)) != 0) {
                        adjEmptyCells = 0;
                        adjCPUFlags = 0;
                        adjPlayerFlags = 0;
                        this.x = -1;
                        this.y = -1;
                        r = i2 - 1;
                        while (r <= i2 + 1) {
                            c = j - 1;
                            while (c <= j + 1) {
                                if (r >= 0 && c >= 0 && r < this.rows && c < this.cols) {
                                    curSubValue = this.mineField[r][c];
                                    if (!JAgamecanvas.testFlag(curSubValue, 32) && !JAgamecanvas.testFlag(curSubValue, 64)) {
                                        if (!JAgamecanvas.testFlag(curSubValue, 128) && !JAgamecanvas.testFlag(this.status[r][c], 32)) {
                                            ++adjEmptyCells;
                                            this.moves.addElement(new int[]{r, c});
                                        } else if (!JAgamecanvas.testFlag(curSubValue, 128) && JAgamecanvas.testFlag(this.status[r][c], 32)) {
                                            ++adjSafeCells;
                                        }
                                    } else if (JAgamecanvas.testFlag(this.status[r][c], 2) || JAgamecanvas.testFlag(this.status[r][c], 8)) {
                                        ++adjPlayerFlags;
                                        this.moves.addElement(new int[]{r, c});
                                    } else if (JAgamecanvas.testFlag(this.status[r][c], 1) || JAgamecanvas.testFlag(this.status[r][c], 4)) {
                                        ++adjCPUFlags;
                                    }
                                }
                                ++c;
                            }
                            ++r;
                        }
                        if (adjEmptyCells != 0 && this.checkMoves(i2, j, this.moves, adjMines, pRemainingMines, adjEmptyCells, adjCPUFlags, adjPlayerFlags)) {
                            return true;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.rows) {
            j = 0;
            while (j < this.cols) {
                curValue = this.mineField[i2][j];
                if (JAgamecanvas.testFlag(this.status[i2][j], 32) && !JAgamecanvas.testFlag(curValue, 128) && this.noFlag(this.status[i2][j])) {
                    this.x = i2;
                    this.y = j;
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rows) {
            j = 0;
            while (j < this.cols) {
                this.riskProbs[i2][j] = -256;
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rows) {
            j = 0;
            while (j < this.cols) {
                adjSafeCells = 0;
                adjEmptyCells = 0;
                adjCPUFlags = 0;
                adjPlayerFlags = 0;
                curValue = this.mineField[i2][j];
                if (!JAgamecanvas.testFlag(curValue, 128)) {
                    r = i2 - 1;
                    block18: while (r <= i2 + 1) {
                        c = j - 1;
                        while (c <= j + 1) {
                            if (r >= 0 && c >= 0 && r < this.rows && c < this.cols) {
                                curSubValue = this.mineField[r][c];
                                if (!JAgamecanvas.testFlag(curSubValue, 128)) break block18;
                                ++adjSafeCells;
                                break block18;
                            }
                            ++c;
                        }
                        ++r;
                    }
                    if (adjSafeCells != 0) {
                        this.riskProbs[i2][j] = 2560;
                    }
                } else {
                    adjMines = JAgamecanvas.getAdjMines(curValue);
                    r = i2 - 1;
                    while (r <= i2 + 1) {
                        c = j - 1;
                        while (c <= j + 1) {
                            if (!(r < 0 || c < 0 || r >= this.rows || c >= this.cols || JAgamecanvas.testFlag(curSubValue = this.mineField[r][c], 128) || !this.noFlag(this.status[r][c]) && JAgamecanvas.testFlag(this.status[r][c], 1) && JAgamecanvas.testFlag(this.status[r][c], 4))) {
                                ++adjEmptyCells;
                            }
                            ++c;
                        }
                        ++r;
                    }
                    if (adjEmptyCells != 0) {
                        short[] sArray = this.riskProbs[i2];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + (short)((adjMines << 16) / adjEmptyCells * 256 / 65535));
                    }
                }
                ++j;
            }
            ++i2;
        }
        int min = 0x640000;
        int i3 = 0;
        while (i3 < this.rows) {
            int j3 = 0;
            while (j3 < this.cols) {
                int prob;
                if (!JAgamecanvas.testFlag(this.mineField[i3][j3], 128) && this.noFlag(this.status[i3][j3]) && (prob = (this.riskProbs[i3][j3] << 16) / 256 / 65535) != -1 && prob < min) {
                    min = prob;
                    this.x = i3;
                    this.y = j3;
                }
                ++j3;
            }
            ++i3;
        }
        if (this.x != -1 && this.y != -1) {
            return false;
        }
        if (this.x == -1 && globalEmptyCells != 0) {
            int r2 = Math.abs(JAgamecanvas.rand.nextInt() % globalEmptyCells);
            int i4 = 0;
            while (i4 < this.rows) {
                int j4 = 0;
                while (j4 < this.cols) {
                    if (r2 < 0) break;
                    curValue = this.mineField[i4][j4];
                    if (!JAgamecanvas.testFlag(curValue, 128) && this.noFlag(this.status[i4][j4]) && --r2 <= 0) {
                        this.x = i4;
                        this.y = j4;
                        return false;
                    }
                    ++j4;
                }
                ++i4;
            }
        }
        this.x = 0;
        this.y = 0;
        return false;
    }

    private boolean noFlag(byte value) {
        return (value & 1) == 0 && (value & 2) == 0 && (value & 4) == 0 && (value & 8) == 0;
    }

    private boolean checkMoves(int i, int j, Vector moves, int adjMines, int pRemainingMines, int adjEmptyCells, int adjCPUFlags, int adjPlayerFlags) {
        int[] curMove;
        int m;
        if (pRemainingMines > 0 && adjEmptyCells > 0 && adjEmptyCells <= adjMines - (adjCPUFlags + adjPlayerFlags)) {
            m = 0;
            while (m < moves.size()) {
                curMove = (int[])moves.elementAt(m);
                if (this.noFlag(this.status[curMove[0]][curMove[1]])) {
                    this.x = curMove[0];
                    this.y = curMove[1];
                } else if (JAgamecanvas.testFlag(this.status[curMove[0]][curMove[1]], 2) && this.verifyFlag(curMove[0], curMove[1])) {
                    byte[] byArray = this.status[curMove[0]];
                    int n = curMove[1];
                    byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                    byte[] byArray2 = this.status[curMove[0]];
                    int n2 = curMove[1];
                    byArray2[n2] = (byte)(byArray2[n2] | 1);
                    ++adjCPUFlags;
                } else if (JAgamecanvas.testFlag(this.status[curMove[0]][curMove[1]], 8) && this.verifyFlag(curMove[0], curMove[1])) {
                    byte[] byArray = this.status[curMove[0]];
                    int n = curMove[1];
                    byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                    byte[] byArray3 = this.status[curMove[0]];
                    int n3 = curMove[1];
                    byArray3[n3] = (byte)(byArray3[n3] | 4);
                    ++adjCPUFlags;
                }
                ++m;
            }
            if (this.x != -1 && this.y != -1) {
                byte[] byArray = this.status[this.x];
                int n = this.y;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                byte[] byArray4 = this.status[this.x];
                int n4 = this.y;
                byArray4[n4] = (byte)(byArray4[n4] | 4);
                return true;
            }
        }
        if (adjEmptyCells == 0 && moves.size() != 0) {
            m = 0;
            while (m < moves.size()) {
                curMove = (int[])moves.elementAt(m);
                if (JAgamecanvas.testFlag(this.status[curMove[0]][curMove[1]], 2) && this.verifyFlag(curMove[0], curMove[1])) {
                    byte[] byArray = this.status[curMove[0]];
                    int n = curMove[1];
                    byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                    byte[] byArray5 = this.status[curMove[0]];
                    int n5 = curMove[1];
                    byArray5[n5] = (byte)(byArray5[n5] | 1);
                    ++adjCPUFlags;
                } else if (JAgamecanvas.testFlag(this.status[curMove[0]][curMove[1]], 8) && this.verifyFlag(curMove[0], curMove[1])) {
                    byte[] byArray = this.status[curMove[0]];
                    int n = curMove[1];
                    byArray[n] = (byte)(byArray[n] & 0xFFFFFFF0);
                    byte[] byArray6 = this.status[curMove[0]];
                    int n6 = curMove[1];
                    byArray6[n6] = (byte)(byArray6[n6] | 4);
                    ++adjCPUFlags;
                }
                ++m;
            }
        }
        if (adjCPUFlags == adjMines) {
            int r = i - 1;
            while (r <= i + 1) {
                int c = j - 1;
                while (c <= j + 1) {
                    byte curSubValue;
                    if (r >= 0 && c >= 0 && r < this.rows && c < this.cols && !JAgamecanvas.testFlag(curSubValue = this.mineField[r][c], 128) && (this.noFlag(this.status[r][c]) || JAgamecanvas.testFlag(this.status[r][c], 2) || JAgamecanvas.testFlag(this.status[r][c], 8))) {
                        byte[] byArray = this.status[r];
                        int n = c;
                        byArray[n] = (byte)(byArray[n] | 0x20);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return false;
    }

    private boolean verifyFlag(int fX, int fY) {
        int adjMines = 0;
        int r = fX - 1;
        while (r <= fX + 1) {
            int c = fY - 1;
            while (c <= fY + 1) {
                byte value;
                if (r >= 0 && c >= 0 && r < this.rows && c < this.cols && JAgamecanvas.testFlag(value = this.mineField[r][c], 128)) {
                    adjMines = JAgamecanvas.getAdjMines(value);
                    int cFlags = 0;
                    int uFlags = 0;
                    int eCells = 0;
                    int sr = r - 1;
                    while (sr <= r + 1) {
                        int sc = c - 1;
                        while (sc <= c + 1) {
                            if (sr >= 0 && sc >= 0 && sr < this.rows && sc < this.cols) {
                                byte subValue = this.mineField[sr][sc];
                                if (JAgamecanvas.testFlag(this.status[sr][sc], 2) || JAgamecanvas.testFlag(this.status[sr][sc], 8)) {
                                    ++uFlags;
                                } else if (JAgamecanvas.testFlag(this.status[sr][sc], 1) || JAgamecanvas.testFlag(this.status[sr][sc], 4)) {
                                    ++cFlags;
                                } else if (!JAgamecanvas.testFlag(subValue, 128) && this.noFlag(this.status[sr][sc])) {
                                    ++eCells;
                                }
                            }
                            ++sc;
                        }
                        ++sr;
                    }
                    if (cFlags == adjMines) {
                        return false;
                    }
                    if (cFlags + uFlags + eCells == adjMines) {
                        return true;
                    }
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    public byte[] getStatus() {
        byte[] data = new byte[this.rows * this.cols];
        int pos = 0;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (this.noFlag(this.status[i][j])) {
                    data[pos++] = 0;
                } else if (JAgamecanvas.testFlag(this.status[i][j], 2)) {
                    data[pos++] = 1;
                } else if (JAgamecanvas.testFlag(this.status[i][j], 1)) {
                    data[pos++] = 2;
                } else if (JAgamecanvas.testFlag(this.status[i][j], 8)) {
                    data[pos++] = 3;
                } else if (JAgamecanvas.testFlag(this.status[i][j], 4)) {
                    data[pos++] = 4;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }

    public void setStatus(byte[] data) {
        int pos = 0;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (data[pos] == 1) {
                    byte[] byArray = this.status[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] | 2);
                } else if (data[pos] == 2) {
                    byte[] byArray = this.status[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] | 1);
                } else if (data[pos] == 3) {
                    byte[] byArray = this.status[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] | 8);
                } else if (data[pos] == 4) {
                    byte[] byArray = this.status[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] | 4);
                }
                ++pos;
                ++j;
            }
            ++i;
        }
    }

    public void clean() {
        this.status = null;
        this.riskProbs = null;
        this.moves.removeAllElements();
        this.moves.trimToSize();
        this.moves = null;
    }
}

