/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.custom.media.MMAPI;

import JAMine.JAgamecanvas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class gamesounds
implements Runnable,
PlayerListener {
    Thread thethread;
    boolean noThread = false;
    long mediaPosition = -1L;
    JAgamecanvas canvas = null;
    private static boolean themeStarted = false;
    public static boolean playingTheme = false;
    public static boolean musicstate = false;
    public static boolean soundstate = false;
    public static boolean midsupport = false;
    public static boolean amrsupport = false;
    public static boolean mmfsupport = false;
    public static boolean wavsupport = false;
    private static Player currentPlayer = null;
    private static String soundPath;
    private static final String SOUNDPAK = "SND.PAK";
    private static int themeIndex;
    private static final String[] Themes;
    private static final String[] FXfile;
    private static Vector FXbuff;
    String FXType = "amr";
    String FXMime = "amr";
    boolean started = false;
    boolean forcedestroy = false;
    int newTune = -1;

    static {
        themeIndex = -1;
        Themes = new String[]{"0.mid", "1.mid", "2.mid", "3.mid", "4.mid"};
        FXfile = new String[]{"nuke", "uncover", "flag", "timebonus", "freemine", "radar", "buy"};
        FXbuff = new Vector();
    }

    public gamesounds(String Path, JAgamecanvas c) {
        this.canvas = c;
        soundPath = Path;
        soundstate = true;
        musicstate = true;
        String[] sup = Manager.getSupportedContentTypes(null);
        int i = 0;
        while (i < sup.length) {
            if (sup[i].indexOf("mid") != -1) {
                midsupport = true;
            }
            if (sup[i].compareTo("audio/amr") == 0) {
                amrsupport = true;
            }
            if (sup[i].compareTo("audio/mmf") == 0) {
                mmfsupport = true;
            }
            if (sup[i].indexOf("wav") != -1) {
                wavsupport = true;
            }
            ++i;
        }
        if (!amrsupport) {
            if (wavsupport) {
                this.FXType = "wav";
                this.FXMime = "x-wav";
            } else if (mmfsupport) {
                this.FXType = "mmf";
                this.FXMime = "mmf";
            }
        }
        playingTheme = false;
        themeStarted = false;
        if (!(amrsupport || wavsupport || mmfsupport)) {
            soundstate = false;
        }
        if (!midsupport) {
            musicstate = false;
        }
        if (this.thethread == null && !this.noThread) {
            this.thethread = new Thread(this);
            this.thethread.start();
        }
    }

    public void playSoundFX(int nT) {
        if (!soundstate) {
            return;
        }
        this.newTune = nT;
        themeIndex = -1;
        playingTheme = false;
        if (this.noThread) {
            this.stopCurrentSoundFX();
            this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
            try {
                currentPlayer.start();
            }
            catch (Throwable ex) {
                this.stopCurrentSoundFX();
            }
        } else {
            this.started = true;
        }
    }

    public void stopCurrentSoundFX() {
        if (currentPlayer != null) {
            try {
                currentPlayer.removePlayerListener((PlayerListener)this);
                currentPlayer.stop();
                currentPlayer.deallocate();
                currentPlayer.close();
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentPlayer = null;
        }
    }

    public void pushMediaTime() {
        if (playingTheme && musicstate && currentPlayer != null) {
            this.mediaPosition = currentPlayer.getMediaTime();
            this.destroyTheme();
        }
    }

    public void popMediaTime() {
        try {
            if (this.mediaPosition != -1L && musicstate) {
                this.playTheme();
                currentPlayer.setMediaTime(this.mediaPosition);
                Thread.sleep(250L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mediaPosition = -1L;
    }

    public void playTheme(int index) {
        if (!musicstate) {
            return;
        }
        this.newTune = -1;
        themeIndex = index + FXfile.length;
        playingTheme = true;
        themeStarted = false;
        if (this.noThread) {
            this.playTheme();
        }
    }

    public void playTheme() {
        this.stopCurrentSoundFX();
        this.createPlayer(0, themeIndex, "mid", "midi");
        try {
            if (themeIndex >= FXfile.length) {
                currentPlayer.addPlayerListener((PlayerListener)this);
            }
            currentPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyTheme() {
        playingTheme = false;
        themeStarted = true;
        if (this.noThread) {
            this.stopCurrentSoundFX();
        }
    }

    public boolean getThemeState() {
        return musicstate;
    }

    public boolean getSoundState() {
        return soundstate;
    }

    public static void setSoundState(boolean soundsstate) {
    }

    public void bgm(int theme) {
        this.playTheme(theme);
    }

    public static void managesounds(boolean aMusicstate, boolean aSoundsstate) {
        musicstate = aMusicstate;
        soundstate = aSoundsstate;
    }

    public boolean createPlayer(int i, int ttp, String type, String mime) {
        InputStream bis = null;
        if (ttp >= 0 && FXbuff.size() > 0 && FXbuff.elementAt(ttp) != null) {
            bis = new ByteArrayInputStream((byte[])FXbuff.elementAt(ttp));
        }
        if (bis == null) {
            if (ttp < FXfile.length) {
                String string = String.valueOf(soundPath) + FXfile[ttp] + "." + type;
                Class<?> clazz = this.getClass();
                InputStream inputStream = null;
                Object var10_12 = null;
                inputStream = JAgamecanvas._m(clazz, string);
                bis = inputStream;
            } else {
                String string = String.valueOf(soundPath) + Themes[ttp - FXfile.length];
                Class<?> clazz = this.getClass();
                InputStream inputStream = null;
                Object var10_13 = null;
                inputStream = JAgamecanvas._m(clazz, string);
                bis = inputStream;
            }
        }
        try {
            currentPlayer = Manager.createPlayer(bis, (String)("audio/" + mime));
            currentPlayer.setLoopCount(1);
        }
        catch (Exception _E) {
            this.stopCurrentSoundFX();
            return false;
        }
        try {
            currentPlayer.realize();
        }
        catch (Exception _E) {
            this.stopCurrentSoundFX();
            return false;
        }
        return true;
    }

    public void run() {
        int loopDelay = 50;
        while (true) {
            Object var7_6 = null;
            long l = 0L;
            Object var10_8 = null;
            long loopStartTime = l = JAgamecanvas._n();
            if (playingTheme) {
                if (!themeStarted) {
                    this.playTheme();
                    themeStarted = true;
                }
            } else if (themeStarted) {
                this.stopCurrentSoundFX();
                themeStarted = false;
            }
            if (this.started && this.newTune != -1) {
                this.started = false;
                this.stopCurrentSoundFX();
                this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
                try {
                    currentPlayer.start();
                }
                catch (Exception ex) {
                    this.stopCurrentSoundFX();
                }
            }
            var7_6 = null;
            l = 0L;
            var10_8 = null;
            l = JAgamecanvas._n();
            long loopTime = l - loopStartTime;
            var7_6 = null;
            l = 0L;
            var10_8 = null;
            l = JAgamecanvas._n();
            if (l - loopStartTime >= (long)loopDelay) continue;
            try {
                Thread.sleep((long)loopDelay - loopTime);
            }
            catch (Exception exception) {
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        Object var4_4 = null;
        if (JAgamecanvas._a0()) {
            return;
        }
        if (!playingTheme || themeIndex < FXfile.length) {
            return;
        }
        if (event.equals("endOfMedia") || event.equals("stopped")) {
            try {
                currentPlayer.setMediaTime(0L);
                currentPlayer.stop();
                this.playTheme();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

