/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.game;

import com.JavArt.game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR = 2;
    public int refX;
    public int refY;
    public int frames;
    public int[] rawFrameSequence;
    public int[] customFrameSequence;
    public int currentFrameIndex;
    public int transform = 0;
    public int rawHeight;
    public int rawWidth;
    public int collisionX;
    public int collisionY;
    public int collisionWidth;
    public int collisionHeight;
    private Image sprite;

    public Sprite(Sprite sprite) {
    }

    public Sprite(Image image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        this.setImage(image, frameWidth, frameHeight);
    }

    public Sprite getSprite() {
        return this;
    }

    public final void paint(Graphics g) {
        int index = this.getFrameSequence()[this.currentFrameIndex];
        int xpos = -this.rawWidth * index;
        int ypos = 0;
        if (this.transform == 2) {
            g.drawRegion(this.sprite, this.rawWidth * index, ypos, this.rawWidth, this.rawHeight, 2, this.getX() + this.refX + this.refX - this.rawWidth, this.getY(), 0);
        } else {
            g.drawRegion(this.sprite, this.rawWidth * index, ypos, this.rawWidth, this.rawHeight, 0, this.getX(), this.getY(), 0);
        }
    }

    public final boolean collidesWith(Sprite s, boolean pixelLevel) {
        return false;
    }

    public void defineCollisionRectangle(int x, int y, int width, int height) {
        this.collisionX = x;
        this.collisionY = y;
        this.collisionWidth = width;
        this.collisionHeight = height;
    }

    public int getRefPixelX() {
        return this.getX() + this.refX;
    }

    public int getRefPixelY() {
        return this.getY() + this.refY;
    }

    public void defineReferencePixel(int x, int y) {
        this.refX = x;
        this.refY = y;
    }

    public void setRefPixelPosition(int x, int y) {
        this.setPosition(x - this.refX, y - this.refY);
    }

    public void setTransform(int transform) {
        this.transform = transform;
    }

    public void setImage(Image image, int frameWidth, int frameHeight) {
        this.rawWidth = frameWidth;
        this.rawHeight = frameHeight;
        this.setWidth(frameWidth);
        this.setHeight(frameHeight);
        this.defineCollisionRectangle(0, 0, frameWidth, frameHeight);
        if (image != null) {
            this.frames = image.getWidth() / this.rawWidth * (image.getHeight() / this.rawHeight);
        }
        this.sprite = image;
    }

    private int[] getFrameSequence() {
        if (this.customFrameSequence != null) {
            return this.customFrameSequence;
        }
        return this.rawFrameSequence;
    }

    public int getFrameSequenceLength() {
        return this.getFrameSequence().length;
    }

    public final int getFrame() {
        return this.currentFrameIndex;
    }

    public void nextFrame() {
        ++this.currentFrameIndex;
        this.currentFrameIndex %= this.getFrameSequenceLength();
    }

    public void prevFrame() {
        this.currentFrameIndex = --this.currentFrameIndex;
        if (this.currentFrameIndex < 0) {
            this.currentFrameIndex = this.getFrameSequenceLength() - 1;
        }
    }

    public void setFrame(int sequenceIndex) {
        this.currentFrameIndex = sequenceIndex;
    }

    public void setFrameSequence(int[] sequence) {
        this.currentFrameIndex = 0;
        this.customFrameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.customFrameSequence, 0, sequence.length);
    }
}

