/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public abstract class MainCanvas
extends Canvas
implements Runnable {
    Thread thread;
    protected boolean isRunning;
    private boolean isAppEnd;
    protected static int rate;
    public int inputPressed;
    public int inputReleased;
    public int inputRepeated;
    public static final int INPUT_NONE = 0;
    public static final int INPUT_UP = 1;
    public static final int INPUT_DOWN = 2;
    public static final int INPUT_LEFT = 3;
    public static final int INPUT_RIGHT = 4;
    public static final int INPUT_FIRE = 5;
    public static final int INPUT_SELECT = 6;
    public static final int INPUT_CANCEL = 7;
    public static final int INPUT_NUM3 = 8;
    public static final int INPUT_NUM1 = 9;
    public static final int INPUT_NUM7 = 10;
    public static final int INPUT_NUM9 = 11;
    public static final int INPUT_POUND = 12;
    public static int width;
    public static int height;
    private boolean isPausing;
    public boolean isLoading;
    public static final int ANCHOR_MID = 3;
    public static final int ANCHOR_TOP = 17;
    public static final Font defaultFont;
    public static final int fontHeight;
    Image keyPadImg;
    boolean isShowKeyPad = false;
    protected byte[] saveData;
    public static final int[] SOFT_LFFT;
    public static final int[] SOFT_RIGHT;
    public static final int[] SOFT_NUM1;
    public static final int[] SOFT_NUM3;
    public static final int[] SOFT_NUM9;

    public MainCanvas() {
        this.setFullScreenMode(true);
        width = this.getWidth();
        height = this.getHeight();
        width = 240;
        height = 320;
        this.isRunning = true;
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.keyPadImg = Image.createImage((String)"/ui/anj.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        rate = 80;
        while (this.isRunning) {
            Object var4_3 = null;
            long l = 0L;
            Object var7_5 = null;
            long start = l = Engine._n();
            if (!this.isPausing) {
                this.gameLoop();
            }
            this.repaint();
            this.serviceRepaints();
            var4_3 = null;
            l = 0L;
            var7_5 = null;
            l = Engine._n();
            if (l - start >= (long)rate) continue;
            try {
                var4_3 = null;
                l = 0L;
                var7_5 = null;
                l = Engine._n();
                Thread.sleep((long)rate - l + start);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Game.isExitConnect) {
            Game.connect();
        }
        if (this.isAppEnd) {
            GameMIDlet.midlet.notifyDestroyed();
        }
    }

    public void exit() {
        this.isAppEnd = true;
        this.isRunning = false;
    }

    public abstract void gameLoop();

    protected abstract void gamePaint(Graphics var1);

    protected abstract void gameInput();

    public final void paint(Graphics g) {
        if (this.isPausing) {
            g.setColor(0);
            g.fillRect(0, 0, width, height);
            Tools.drawColorStr(g, "\u6309\u4efb\u610f\u952e\u7ee7\u7eed", width >> 1, height >> 1, 17, 0xFFFFFF, 0xFF0000);
        } else if (this.isLoading) {
            g.setColor(0);
            g.fillRect(0, 0, width, height);
            Tools.drawColorStr(g, "\u52a0\u8f7d", width >> 1, height >> 1, 17, 0xFFFFFF, 0xFF0000);
        } else {
            this.gamePaint(g);
        }
        if (this.isShowKeyPad) {
            g.setClip(0, 0, width, 320);
            g.drawImage(this.keyPadImg, 0, 320, 36);
        }
    }

    public final void keyPressed(int keyCode) {
        if (this.isPausing) {
            this.isPausing = false;
            this.resume();
            return;
        }
        if (this.isLoading) {
            return;
        }
        this.inputRepeated = this.inputPressed = this.changeKeyCode(keyCode);
        this.input();
        this.inputPressed = 0;
    }

    public final void keyReleased(int keyCode) {
        this.inputReleased = this.changeKeyCode(keyCode);
        if (this.inputRepeated == this.inputReleased) {
            this.inputRepeated = 0;
        }
        this.input();
    }

    private final int changeKeyCode(int keyCode) {
        Object var2_2 = null;
        if (Engine._a0()) {
            return 0;
        }
        switch (keyCode) {
            case 50: {
                return 1;
            }
            case 56: {
                return 2;
            }
            case 52: {
                return 3;
            }
            case 54: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case -21: 
            case 21: {
                return 6;
            }
            case -22: 
            case 22: {
                return 7;
            }
            case 49: {
                return 9;
            }
            case 51: {
                return 8;
            }
            case 55: {
                return 10;
            }
            case 57: {
                return 11;
            }
            case 35: {
                return 12;
            }
        }
        switch (this.getGameAction(keyCode)) {
            case 1: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return 0;
    }

    private final void input() {
        if (this.inputPressed != 0 || this.inputReleased != 0 || this.inputRepeated != 0) {
            this.gameInput();
        }
    }

    public static final Game getGame() {
        if (GameMIDlet.game == null) {
            GameMIDlet.game = new Game();
        }
        return GameMIDlet.game;
    }

    public void hideNotify() {
        this.isPausing = true;
        this.pause();
    }

    protected void pause() {
    }

    protected void resume() {
    }

    public void save() {
        if (this.saveData == null) {
            System.out.println("Save erro: No save data.");
            return;
        }
        byte[] data = this.saveData;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Game0xFF05F0", (boolean)true);
            if (rs.getNumRecords() > 0) {
                rs.setRecord(1, data, 0, data.length);
            } else {
                rs.addRecord(data, 0, data.length);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public boolean load() {
        if (this.saveData == null) {
            System.out.println("Load erro:saveData == null");
            return false;
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Game0xFF05F0", (boolean)true);
            if (rs.getNumRecords() <= 0) {
                return false;
            }
            byte[] data = rs.getRecord(1);
            this.saveData = data;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        for (int i = 0; i < this.saveData.length; ++i) {
            System.out.print(this.saveData[i] + ",");
        }
        return true;
    }

    public static int bytesToInt(byte[] src, int offset) {
        return (0xFF & src[offset + 0]) << 24 | (0xFF & src[offset + 1]) << 16 | (0xFF & src[offset + 2]) << 8 | 0xFF & src[offset + 3];
    }

    public static void intToBytes(int i, byte[] dest, int offset) {
        dest[offset + 3] = (byte)(0xFF & i);
        dest[offset + 2] = (byte)((0xFF00 & i) >> 8);
        dest[offset + 1] = (byte)((0xFF0000 & i) >> 16);
        dest[offset + 0] = (byte)((0xFF000000 & i) >> 24);
    }

    public void pointerPressed(int x, int y) {
        if (MainCanvas.inHere(x, y, SOFT_LFFT)) {
            this.keyPressed(-21);
        } else if (MainCanvas.inHere(x, y, SOFT_RIGHT)) {
            this.keyPressed(-22);
        } else if (MainCanvas.inHere(x, y, SOFT_NUM1)) {
            this.keyPressed(49);
        } else if (MainCanvas.inHere(x, y, SOFT_NUM3)) {
            this.keyPressed(51);
        } else if (MainCanvas.inHere(x, y, SOFT_NUM9)) {
            this.keyPressed(57);
        }
    }

    public void pointerReleased(int x, int y) {
        this.keyReleased(0);
    }

    public static final boolean inHere(int inputX, int inputY, int[] input) {
        int x = input[0];
        int y = input[1] + 256;
        int w = input[2];
        int h = input[3];
        return inputX > x && inputX < x + w && inputY > y && inputY < y + h;
    }

    static {
        defaultFont = Font.getFont((int)0, (int)0, (int)8);
        fontHeight = defaultFont.getHeight() + 1;
        SOFT_LFFT = new int[]{0, 0, 59, 64};
        SOFT_RIGHT = new int[]{178, 0, 64, 64};
        SOFT_NUM1 = new int[]{89, 2, 28, 28};
        SOFT_NUM3 = new int[]{128, 2, 30, 30};
        SOFT_NUM9 = new int[]{130, 33, 30, 30};
    }
}

