/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScriptText {
    public static final boolean ENGLISH = false;
    public static int COLOR_COMMON = 0xFFFFFF;
    public static final int COLOR_ONE = 0xFF0000;
    public static Image arrowImg;
    public static final int FONT_OFFSET_HEIGHT = 5;
    private int x;
    private int y;
    private int w;
    private int h;
    private Font font;
    private String[] showString;
    private int lines;
    private int pages;
    private int totalLines;
    public int curPage;
    private int curLine;
    private int fontHeight;
    private boolean isChangePage;
    private static final char[] SIGN_ALL;
    private boolean isShowUp;
    private boolean isShowDown;

    public ScriptText(String s, int x, int y, int w, int h, Font font) {
        this.font = font;
        this.fontHeight = font.getHeight() + 5;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.parse(s);
        this.lines = this.getLine();
        this.totalLines = this.showString.length;
        this.pages = this.getPages(this.showString.length, this.lines);
        this.curPage = 0;
        this.isChangePage = true;
        if (arrowImg == null) {
            arrowImg = Tools.createImage("/ui/ah.png");
        }
        this.isShowUp = true;
        this.isShowDown = true;
    }

    protected final void paint(Graphics g) {
        g.setColor(COLOR_COMMON);
        int posY = this.y + (this.h - this.lines * this.fontHeight) / 2;
        boolean isShowUp = true;
        boolean isShowDown = true;
        if (this.isChangePage) {
            this.curLine = this.curPage * this.lines;
            if (this.curPage >= this.pages - 1) {
                isShowDown = false;
            }
            if (this.curPage <= 0) {
                isShowUp = false;
            }
        } else {
            if (this.curLine + this.lines >= this.totalLines) {
                isShowDown = false;
            }
            if (this.curLine <= 0) {
                isShowUp = false;
            }
        }
        ScriptText.drawArrayString(g, this.showString, this.curLine, this.curLine + this.lines, this.x, this.y, this.w, this.h, this.fontHeight, this.font);
        if (isShowDown && this.isShowDown) {
            int arrowY = posY + (this.lines - 1) * this.fontHeight + 23;
            ScriptText.drawArrow(g, 1, this.x + (this.w >> 1), arrowY);
        }
        if (isShowUp && this.isShowUp) {
            ScriptText.drawArrow(g, 0, this.x + (this.w >> 1), posY - 10);
        }
    }

    public static final void drawArrayString(Graphics g, String[] array, int start, int end, int x, int y, int w, int h, int fontHeight, Font font) {
        int arrayIndex;
        int posX = x;
        int posY = y + (h - (end - start) * fontHeight >> 1);
        g.setColor(COLOR_COMMON);
        for (int i = start; i < end && (arrayIndex = i) < array.length; ++i) {
            String s = array[arrayIndex];
            int length = s.length();
            if (length > 0) {
                posX = x;
                if (s.charAt(0) == '~') {
                    s = s.substring(1, length);
                    posX = x + (w - font.stringWidth(s) >> 1);
                    length = s.length();
                }
                for (int j = 0; j < length; ++j) {
                    char ch = s.charAt(j);
                    if (ch == '[') {
                        g.setColor(0xFF0000);
                        continue;
                    }
                    if (ch == ']') {
                        g.setColor(COLOR_COMMON);
                        continue;
                    }
                    g.drawChar(ch, posX, posY, 0);
                    posX += font.charWidth(ch);
                }
            }
            posY += fontHeight;
        }
    }

    protected void input() {
        if (MainCanvas.getGame().inputPressed == 2) {
            ++this.curPage;
            ++this.curLine;
        } else if (MainCanvas.getGame().inputPressed == 1) {
            --this.curPage;
            --this.curLine;
        }
        this.curPage = Math.min(this.curPage, this.pages - 1);
        this.curPage = Math.max(this.curPage, 0);
        this.curLine = Math.min(this.curLine, this.totalLines - this.lines);
        this.curLine = Math.max(this.curLine, 0);
    }

    protected boolean nextPage() {
        ++this.curPage;
        if (this.curPage > this.pages - 1) {
            this.curPage = Math.min(this.curPage, this.pages - 1);
            return true;
        }
        return false;
    }

    protected boolean previousPage() {
        --this.curPage;
        if (this.curPage < 0) {
            this.curPage = Math.max(this.curPage, 0);
            return true;
        }
        return false;
    }

    private final void parse(String str) {
        this.showString = ScriptText.changeToArray(str, this.font, this.w);
    }

    private final int getLine() {
        int rowNum = this.h % this.fontHeight == 0 ? this.h / this.fontHeight - 2 : this.h / this.fontHeight - 1;
        rowNum = Math.max(2, rowNum);
        return rowNum;
    }

    private final int getPages(int totalLine, int lines) {
        if (totalLine % lines == 0) {
            return totalLine / lines;
        }
        return totalLine / lines + 1;
    }

    public static final String[] changeToArray(String str, Font font, int w) {
        return ScriptText.changeToArrayCn(str, font, w);
    }

    private static final String[] changeToArrayCn(String str, Font font, int width) {
        int nowWidth = 0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int chWidth = font.charWidth(ch);
            if (ch == '[' || ch == ']' || ch == '~' || ch == '^' || ch == '\n') {
                chWidth = 0;
            }
            if (ch == '^' || ch == '\n') {
                result.addElement(buffer.toString());
                buffer = new StringBuffer();
                nowWidth = 0;
                continue;
            }
            if ((nowWidth += chWidth) >= width && !ScriptText.isSign(ch)) {
                result.addElement(buffer.toString());
                buffer = new StringBuffer();
                nowWidth = chWidth;
            }
            buffer.append(ch);
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)result.elementAt(i);
        }
        return s;
    }

    private static final String[] changeToArrayEn(String str, Font font, int width) {
        int nowWidth = 0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int chWidth = font.charWidth(ch);
            if (ch == '[' || ch == ']' || ch == '~' || ch == '\n') {
                chWidth = 0;
            }
            if (ch == '^' || ch == '\n') {
                result.addElement(buffer.toString());
                buffer = new StringBuffer();
                nowWidth = 0;
                continue;
            }
            if ((nowWidth += chWidth) >= width) {
                char pre = str.charAt(i - 1);
                if (ch == ' ') {
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = 0;
                    continue;
                }
                if (ScriptText.isSign(pre)) {
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                } else {
                    boolean backSuccesfully = false;
                    for (int b = buffer.length() - 1; b >= 0; --b) {
                        char chB = buffer.charAt(b);
                        if (chB == ' ') {
                            i -= buffer.length() - b;
                            buffer.delete(b, buffer.length());
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            backSuccesfully = true;
                            break;
                        }
                        if (!ScriptText.isSign(chB)) continue;
                        i -= buffer.length() - b;
                        buffer.delete(b + 1, buffer.length());
                        result.addElement(buffer.toString());
                        buffer = new StringBuffer();
                        nowWidth = 0;
                        backSuccesfully = true;
                        break;
                    }
                    if (backSuccesfully) continue;
                    buffer.append('-');
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                }
            }
            buffer.append(ch);
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)result.elementAt(i);
        }
        return s;
    }

    private static final boolean isSign(char ch) {
        for (int i = SIGN_ALL.length - 1; i >= 0; --i) {
            if (ch != SIGN_ALL[i]) continue;
            return true;
        }
        return false;
    }

    protected final void setChangeLine() {
        Object var1_1 = null;
        if (Engine._a0()) {
            return;
        }
        this.isChangePage = false;
    }

    protected void setUp(boolean is) {
        this.isShowUp = is;
    }

    protected void setDown(boolean is) {
        this.isShowDown = is;
    }

    public static final void drawArrow(Graphics g, int id, int x, int y) {
        int w = arrowImg.getWidth() >> 1;
        int h = arrowImg.getHeight();
        g.setClip(x - (w >> 1), y - (h >> 1), w, h);
        if (id == 1) {
            g.drawImage(arrowImg, x - (w >> 1), y - (h >> 1), 0);
        } else {
            g.drawImage(arrowImg, x - (w >> 1) - w, y - (h >> 1), 0);
        }
    }

    static {
        SIGN_ALL = new char[]{',', '.', '?', '!', ' ', ';', '\uff0c', '\u3002', '\uff1f', '\uff01', '\uff1b', '\u3001'};
    }
}

