/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private int iNowTilePosY;
    public int iNowPosY;
    private int iBgMapSizeY;
    private int iMapPrev = -1;
    private int iMapSizeX;
    private int iMapSizeY;
    private int iMapStep = 0;
    private final int MAX_MAP;
    private final int MAX_OBJ;
    private final int MAP_WIN_ROAD;
    private final int MAP_SPR_ROAD;
    private final int MAP_SPR_ROAD2;
    private final int MAP_SPR_ROAD3;
    private final int MAP_DOWN_REPLAY;
    private final int MAP_UP_REPLAY;
    private final int MAP_ONCE;
    private final int MAP_STOP;
    private final int MAP_TALK;
    private byte[][] iMapData;
    private byte[][] iObjData;
    private Image[] imgMap;
    private Image[] imgObj;
    private Image bgImg;
    private Image bgSideImg;
    private Basic bi;
    Graphics bg;
    Graphics bsg;

    public Map(Basic _bi) {
        this.MAX_MAP = 100;
        this.MAX_OBJ = 100;
        this.MAP_WIN_ROAD = 0;
        this.MAP_SPR_ROAD = 35;
        this.MAP_SPR_ROAD2 = 55;
        this.MAP_SPR_ROAD3 = 56;
        this.MAP_DOWN_REPLAY = 0;
        this.MAP_UP_REPLAY = 2;
        this.MAP_ONCE = 1;
        this.MAP_STOP = 3;
        this.MAP_TALK = 4;
        this.bi = _bi;
        this.bgImg = Image.createImage((int)195, (int)1500);
        int dx = ((this.bi.wc - 95) / 15 + 1) * 15;
        this.bgSideImg = Image.createImage((int)dx, (int)this.bi.h);
        this.bg = this.bgImg.getGraphics();
        this.bsg = this.bgSideImg.getGraphics();
    }

    private byte[] loadFile(String _fname) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(_fname);
        byte[] BI = new byte[is.available()];
        is.read(BI);
        is.close();
        is = null;
        return BI;
    }

    public boolean setMap(Graphics g, int _nowmap) {
        if (this.loadMap(_nowmap)) {
            this.drawTileMap(g);
            this.setInitMap();
            return true;
        }
        return false;
    }

    private void drawTileMap(Graphics g) {
        int j;
        int bgx;
        int i;
        int strX = 0;
        this.imgMap = new Image[100];
        this.bi.getClass();
        this.iBgMapSizeY = this.iMapSizeY * 15;
        int bgy = 0;
        for (i = 0; i < this.iMapSizeY; ++i) {
            bgx = strX;
            for (j = 0; j < this.bi.iLcdTileWidthCount; ++j) {
                if (this.iMapData[i][j] > -1) {
                    if (this.imgMap[this.iMapData[i][j]] == null) {
                        try {
                            this.imgMap[this.iMapData[i][j]] = Image.createImage((String)("/image/m/" + this.iMapData[i][j] + ".png"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.bg.drawImage(this.imgMap[this.iMapData[i][j]], bgx, bgy, 20);
                }
                if (this.iMapData[i][j] != 0 && this.iMapData[i][j] != 35 && this.iMapData[i][j] != 55 && this.iMapData[i][j] != 56) {
                    this.iMapData[i][j] = -1;
                }
                this.bi.getClass();
                bgx += 15;
            }
            this.bi.getClass();
            bgy += 15;
        }
        int mapnum = 5;
        if (this.imgMap[16] != null) {
            mapnum = 16;
        } else if (this.imgMap[18] != null) {
            mapnum = 18;
        } else if (this.imgMap[26] != null) {
            mapnum = 26;
        } else if (this.imgMap[57] != null) {
            mapnum = 57;
        } else if (this.imgMap[5] != null) {
            mapnum = 5;
        }
        for (bgy = 0; bgy < this.bi.h; bgy += 15) {
            if (mapnum == 16 || mapnum == 18) {
                for (bgx = 0; bgx < this.bi.wc - 98; bgx += 30) {
                    this.bsg.drawImage(this.imgMap[mapnum + 1], bgx, bgy, 20);
                    this.bsg.drawImage(this.imgMap[mapnum], bgx + 15, bgy, 20);
                }
            } else {
                while (bgx < this.bi.wc - 98) {
                    this.bsg.drawImage(this.imgMap[mapnum], bgx, bgy, 20);
                    bgx += 15;
                }
            }
            this.bi.getClass();
        }
        this.imgMap = null;
        System.gc();
        this.imgObj = new Image[100];
        bgy = 0;
        for (i = 0; i < this.iMapSizeY; ++i) {
            this.bi.getClass();
            bgx = strX + 8;
            for (j = 0; j < this.bi.iLcdTileWidthCount; ++j) {
                if (this.iObjData[i][j] > -1) {
                    if (this.imgObj[this.iObjData[i][j]] == null) {
                        try {
                            this.imgObj[this.iObjData[i][j]] = Image.createImage((String)("/image/o/" + this.iObjData[i][j] + ".png"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.bg.drawImage(this.imgObj[this.iObjData[i][j]], bgx, bgy, 33);
                }
                this.bi.getClass();
                bgx += 15;
            }
            this.bi.getClass();
            bgy += 15;
        }
        this.imgObj = null;
        this.iObjData = null;
        System.gc();
    }

    public void setInitMap() {
        this.iNowTilePosY = this.iMapSizeY - this.bi.iLcdTileHeightCount - 1;
        switch (this.iMapStep) {
            case 0: 
            case 1: 
            case 2: {
                int n = this.bi.h;
                this.bi.getClass();
                this.iNowPosY = n - this.iMapSizeY * 15;
                break;
            }
            case 3: {
                int n = -((this.iMapSizeY - this.bi.iLcdTileHeightCount) / 2);
                this.bi.getClass();
                this.iNowPosY = n * 15;
            }
        }
    }

    private boolean loadMap(int _nowmap) {
        try {
            byte[] lmf = this.loadFile("/data/" + _nowmap + ".map");
            DataSet ds = new DataSet(lmf);
            ds.clear();
            this.iMapPrev = this.iMapStep;
            this.iMapStep = ds.readShort();
            if (this.iMapStep == 4) {
                return false;
            }
            byte[] lbf = this.loadFile("/data/" + _nowmap + ".obj");
            DataSet os = new DataSet(lbf);
            os.clear();
            int i = ds.readShort();
            this.iMapSizeX = ds.readShort();
            this.iMapSizeY = ds.readShort();
            int s = (this.iMapSizeX - this.bi.iLcdTileWidthCount) / 2;
            int e = s + this.bi.iLcdTileWidthCount;
            this.iMapData = new byte[this.iMapSizeY][this.bi.iLcdTileWidthCount];
            this.iObjData = new byte[this.iMapSizeY][this.bi.iLcdTileWidthCount];
            for (i = 0; i < this.iMapSizeY; ++i) {
                int j;
                int k = 0;
                for (j = 0; j < s; ++j) {
                    ds.readByte();
                    os.readByte();
                }
                while (j < e) {
                    this.iMapData[i][k] = ds.readByte();
                    this.iObjData[i][k] = os.readByte();
                    ++k;
                    ++j;
                }
                while (j < this.iMapSizeX) {
                    ds.readByte();
                    os.readByte();
                    ++j;
                }
            }
            lbf = null;
            os = null;
            ds = null;
            lmf = null;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void setMapStap(int step) {
        this.iMapStep = step;
    }

    public void drawMap(Graphics g) {
        switch (this.iMapStep) {
            case 0: 
            case 2: {
                g.drawImage(this.bgImg, this.bi.wc - 98, this.iNowPosY - this.iBgMapSizeY, 20);
                break;
            }
            case 4: {
                switch (this.iMapPrev) {
                    case 0: 
                    case 2: {
                        g.drawImage(this.bgImg, this.bi.wc - 98, this.iNowPosY - this.iBgMapSizeY, 20);
                    }
                }
            }
        }
        g.drawImage(this.bgImg, this.bi.wc - 98, this.iNowPosY, 20);
        g.drawImage(this.bgSideImg, this.bi.wc - 98, 0, 24);
        g.drawImage(this.bgSideImg, this.bi.wc + 97, 0, 20);
    }

    public void moveMap(int mv) {
        switch (this.iMapStep) {
            case 0: 
            case 2: {
                this.iNowTilePosY -= mv;
                this.bi.getClass();
                this.iNowPosY += mv * 15;
                if (this.iNowPosY <= this.iBgMapSizeY) break;
                this.iNowPosY -= this.iBgMapSizeY;
                this.iNowTilePosY = 0;
                break;
            }
            case 1: {
                this.iNowTilePosY -= mv;
                if (this.iNowTilePosY < 0) {
                    this.iNowTilePosY = 0;
                }
                int n = -this.iNowTilePosY;
                this.bi.getClass();
                this.iNowPosY = n * 15;
            }
        }
    }

    public byte[][] getMap() {
        return this.iMapData;
    }

    public void freeMap() {
        this.iMapData = null;
    }
}

