/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class PingPinSound {
    private Player media = null;
    int vol;
    boolean loopFlag = false;
    public int musicNum;
    public boolean restoreLoop;
    Player[] mPlayer = new Player[8];
    int nwavNum = 8;

    public PingPinSound() {
        this.loadSound();
    }

    void loadSound() {
        for (int i = 0; i < this.nwavNum; ++i) {
            try {
                this.mPlayer[i] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/eff_" + i + ".wav"), (String)"audio/x-wav");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void play(int x, boolean bl) {
        this.musicNum = x;
        this.restoreLoop = bl;
        try {
            this.closep();
            if (x > 5 && x != 19 && x != 22) {
                this.loopFlag = bl;
                this.media = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/" + x + ".mid"), (String)"audio/midi");
                this.media.prefetch();
                VolumeControl w = (VolumeControl)this.media.getControl("VolumeControl");
                w.setLevel(this.vol);
                this.media.setLoopCount(this.loopFlag ? -1 : 1);
                this.media.start();
            } else {
                if (x == 19) {
                    x = 6;
                }
                if (x == 22) {
                    x = 7;
                }
                this.mPlayer[x].prefetch();
                VolumeControl w = (VolumeControl)this.mPlayer[x].getControl("VolumeControl");
                w.setLevel(this.vol);
                this.mPlayer[x].setLoopCount(1);
                this.mPlayer[x].start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void closep() {
        this.loopFlag = false;
        try {
            if (this.media != null) {
                this.media.stop();
                this.media.close();
                this.media = null;
            }
            for (int i = 0; i < this.nwavNum; ++i) {
                if (this.mPlayer[i] == null) continue;
                this.mPlayer[i].stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVolums(int x) {
        this.vol = x;
        try {
            if (this.media != null) {
                this.media.prefetch();
                this.media.getState();
                VolumeControl w = (VolumeControl)this.media.getControl("VolumeControl");
                w.setLevel(x);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMaxVolume() {
        return 127;
    }
}

