/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris.graphic.midlet;

import de._3DTetris.graphic.IColor;
import de._3DTetris.graphic.IGraphics;
import de._3DTetris.graphic.IImage;
import de._3DTetris.graphic.IPolygon;
import de._3DTetris.graphic.midlet.MidletColor;
import de._3DTetris.graphic.midlet.MidletImage;
import de._3DTetris.graphic.midlet.MidletPolygon;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MidletGraphics
implements IGraphics {
    private static final int _BLOCK_EDGE_COLOR = 0xD3D3D3;
    private static final int _GRID_LINE_COLOR = 0xFFFFFF;
    private Graphics _Graphics;

    public MidletGraphics(Graphics graphics) {
        this._Graphics = graphics;
    }

    public void drawImage(IImage puffer, int left, int top) {
        MidletImage img = (MidletImage)puffer;
        this._Graphics.drawImage(img.getImage(), left, top, MidletGraphics.getAnchorPoint());
    }

    private static int getAnchorPoint() {
        return 20;
    }

    public void drawLine(int left, int top, int right, int bottom) {
        this._Graphics.drawLine(left, top, right, bottom);
    }

    public void drawPolygon(IPolygon poly) {
        MidletPolygon mPoly = (MidletPolygon)poly;
        int pointCount = mPoly.getCount();
        int[] xPoints = mPoly.getXPoints();
        int[] yPoints = mPoly.getYPoints();
        for (int i = 0; i < pointCount; ++i) {
            int x1 = xPoints[i];
            int y1 = yPoints[i];
            int x2 = xPoints[0];
            int y2 = yPoints[0];
            if (i < pointCount - 1) {
                x2 = xPoints[i + 1];
                y2 = yPoints[i + 1];
            }
            this._Graphics.drawLine(x1, y1, x2, y2);
        }
    }

    public void drawString(String string, int left, int top) {
        this._Graphics.drawString(string, left, top, MidletGraphics.getAnchorPoint());
    }

    public void fillPolygon(IPolygon poly) {
        MidletPolygon mPoly = (MidletPolygon)poly;
        int[] xPoints = mPoly.getXPoints();
        int[] yPoints = mPoly.getYPoints();
        this._Graphics.fillTriangle(xPoints[0], yPoints[0], xPoints[1], yPoints[1], xPoints[3], yPoints[3]);
        this._Graphics.fillTriangle(xPoints[2], yPoints[2], xPoints[3], yPoints[3], xPoints[1], yPoints[1]);
    }

    public void fillRect(int left, int top, int width, int height) {
        this._Graphics.fillRect(left, top, width, height);
    }

    public IColor getGraphicsColor() {
        return new MidletColor(this._Graphics.getColor());
    }

    public void setBlockEdgeColor() {
        this._Graphics.setColor(0xD3D3D3);
    }

    public void setColor(IColor linien) {
        this._Graphics.setColor(linien.getRGB());
    }

    public void setColor(int rgb) {
        this._Graphics.setColor(rgb);
    }

    public void setFont() {
        this._Graphics.setFont(Font.getFont((int)64, (int)0, (int)0));
    }

    public void setGridLineColor() {
        this._Graphics.setColor(0xFFFFFF);
    }

    public void setGraphics(Graphics graphics) {
        this._Graphics = graphics;
    }
}

