/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.Gitter3D;
import de._3DTetris.TetrisRaum;
import de._3DTetris.TetrisSzene;
import de._3DTetris.graphic.Dim;
import de._3DTetris.graphic.IColor;
import de._3DTetris.graphic.IGameCanvas;
import de._3DTetris.graphic.IGraphics;
import de._3DTetris.graphic.IImage;
import de._3DTetris.util.ISystemInfo;
import de._3DTetris.util._3DTetrisClassFactory;
import java.util.Vector;

public class TetrisSzeneCanvas {
    private IImage _Image;
    private IGraphics m_GPuffer = null;
    private Gitter3D m_TGitter;
    private TetrisRaum m_TFeld;
    private int m_Ebenen;
    private int m_Spalten;
    private int m_Zeilen;
    private TetrisSzene m_TSzene;
    private Dim m_DimAlt;
    private short m_PlayLevel = 0;
    private final IGameCanvas _AppCanvas;
    private final ISystemInfo _SystemInfo;

    public TetrisSzeneCanvas(IGameCanvas gameCanvas) {
        this._AppCanvas = gameCanvas;
        this._SystemInfo = _3DTetrisClassFactory.instanceSystemInfoClass();
        this.m_Spalten = this._SystemInfo.getGridColumnCount();
        this.m_Zeilen = this._SystemInfo.getGridRowCount();
        this.m_Ebenen = this._SystemInfo.getGridPlanCount();
        this.m_TGitter = null;
        this.m_DimAlt = new Dim(0, 0);
        this._AppCanvas.setGameBackground();
        this._AppCanvas.setTetrisSzeneCanvas(this);
    }

    public void gesamtRot(double alpha, double beta, double gamma) {
        this.m_TGitter.rotieren(alpha, beta, gamma);
        this.m_TSzene.neu();
        this._AppCanvas.repaint();
    }

    public void gesamtGroesse() {
        Dim d = this._AppCanvas.getCanvasSize();
        this._Image = this._AppCanvas.createImage(d);
        this.m_GPuffer = this._Image.getGraphics();
        if (this.m_TGitter == null) {
            this.neuesSpiel();
        } else {
            if (this.m_DimAlt.equals(d)) {
                return;
            }
            this.m_DimAlt = d;
            this.m_TGitter.setParam(d.getWidth(), d.getHeight());
            this.m_TGitter.erzBildpunkte();
        }
    }

    public synchronized void rotateTetrisBlock(int axisId) {
        if (!this.m_TFeld.dreheBlock(axisId)) {
            this.m_TSzene.setABlock(this.m_TFeld.ermABlock());
        } else {
            this.m_TSzene.blockSortieren();
            this._AppCanvas.repaint();
        }
    }

    public synchronized void moveTetrisBlock(int direction) {
        int x = 0;
        int z = 0;
        switch (direction) {
            case -2: {
                z = -1;
                break;
            }
            case -1: {
                x = -1;
                break;
            }
            case 1: {
                x = 1;
                break;
            }
            case 2: {
                z = 1;
            }
        }
        if (!this.m_TFeld.verschiebeBlock(0, z, x)) {
            return;
        }
        this.m_TSzene.blockSortieren();
        this._AppCanvas.repaint();
    }

    public int moveBlockDown(boolean allPlanes) {
        int returnWert = 0;
        if (!allPlanes) {
            if (!this.m_TFeld.verschiebeBlock(-1, 0, 0)) {
                Vector v = this.m_TFeld.pruefEbenen();
                this.m_TSzene.setFlaechen(this.m_TFeld.ermFlaechen());
                this.m_TSzene.setABlock(null);
                returnWert = v.size();
                if (returnWert != 0) {
                    this._AppCanvas.repaint();
                } else {
                    returnWert = -1;
                }
            } else {
                this.m_TSzene.blockSortieren();
                this._AppCanvas.repaint();
            }
        } else {
            while (this.m_TFeld.verschiebeBlock(-1, 0, 0)) {
            }
            Vector v = this.m_TFeld.pruefEbenen();
            this.m_TSzene.setFlaechen(this.m_TFeld.ermFlaechen());
            this.m_TSzene.setABlock(null);
            returnWert = v.size();
            if (returnWert == 0) {
                returnWert = -1;
            }
        }
        return returnWert;
    }

    public boolean setNextBlock(int nextBlockId) {
        if (!this.m_TFeld.setBlock(nextBlockId)) {
            return false;
        }
        this.m_TSzene.setABlock(this.m_TFeld.ermABlock());
        this._AppCanvas.repaint();
        return true;
    }

    public void beginNewPlay(int ebenen, int spalten, int zeilen) {
        this.m_Spalten = spalten;
        this.m_Zeilen = zeilen;
        this.m_Ebenen = ebenen;
        this.neuesSpiel();
    }

    public void gameOver() {
        this.m_PlayLevel = (short)2;
        this._AppCanvas.repaint();
    }

    public void gamePause() {
        this.m_PlayLevel = (short)3;
        this._AppCanvas.repaint();
    }

    public void gameStart() {
        this.m_PlayLevel = 1;
        this._AppCanvas.repaint();
    }

    public IGameCanvas getAppCanvas() {
        return this._AppCanvas;
    }

    public void paint(IGraphics g) {
        int alt = this._AppCanvas.getCanvasBackground().getRGB();
        if (this.m_GPuffer != null) {
            Dim size = this._AppCanvas.getCanvasSize();
            this.m_GPuffer.fillRect(0, 0, size.getWidth(), size.getHeight());
            IColor alteFarbe = g.getGraphicsColor();
            if (!this._AppCanvas.isScreenBigEnough()) {
                this.m_GPuffer.setColor(~alt);
                this.m_GPuffer.drawString(this._SystemInfo.getLocaleString("window"), 10, size.getHeight() / 2);
                this.m_GPuffer.setColor(alteFarbe);
                g.drawImage(this._Image, 0, 0);
                return;
            }
            this.m_TSzene.darstellen(this.m_GPuffer);
            this.m_GPuffer.setColor(~alt);
            this.m_GPuffer.setFont();
            if (this.m_PlayLevel == 2) {
                this.m_GPuffer.drawString(this._SystemInfo.getLocaleString("end"), 10, size.getHeight() / 2);
            }
            if (this.m_PlayLevel == 3) {
                this.m_GPuffer.drawString(this._SystemInfo.getLocaleString("pause"), 10, size.getHeight() / 2);
            }
            this.m_GPuffer.setColor(alteFarbe);
            g.drawImage(this._Image, 0, 0);
        }
    }

    public void neuesSpiel() {
        this.m_PlayLevel = 1;
        this.m_DimAlt = this._AppCanvas.getCanvasSize();
        this._AppCanvas.setGameBackground();
        this.m_TGitter = new Gitter3D(this.m_Spalten, this.m_Zeilen, this.m_Ebenen, this.m_DimAlt.getWidth(), this.m_DimAlt.getHeight());
        this.m_TGitter.rotieren(0, 0, 0);
        this.m_TGitter.rotieren(0, -50, 0);
        this.m_TGitter.rotieren(40, 0, 0);
        this.m_TSzene = new TetrisSzene(this.m_TGitter);
        this.m_TFeld = new TetrisRaum(this.m_Spalten, this.m_Zeilen, this.m_Ebenen);
        this.m_TSzene.setBgrL(this.m_TFeld.ermGrenzLinien());
    }

    public void reset() {
        this.m_TGitter.reset();
        this.m_TSzene.neu();
        this._AppCanvas.repaint();
    }
}

