/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris.graphic.midlet;

import de._3DTetris.TetrisControler;
import de._3DTetris.graphic.ITetrisControlerPanel;
import de._3DTetris.graphic.midlet.MidletCanvas;
import de._3DTetris.graphic.midlet.MidletGameCanvas;
import de._3DTetris.util.ISystemInfo;
import de._3DTetris.util._3DTetrisClassFactory;
import de._3DTetris.util.midlet.IKeyListener;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class MidletControlPanel
implements ITetrisControlerPanel,
IKeyListener,
CommandListener {
    private boolean _PauseSet = false;
    private TetrisControler _TetrisControler;
    private Display _Display;
    private final ISystemInfo _SystemInfo;
    private Form _ExampleScreen = new Form("");
    private Form _NextLevelScreen = new Form("");

    public MidletControlPanel() {
        this._SystemInfo = _3DTetrisClassFactory.instanceSystemInfoClass();
        this._ExampleScreen.setTitle(this._SystemInfo.getLocaleString("help"));
        this._ExampleScreen.addCommand(new Command("Start", 4, 0));
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("1") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("2") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("3") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("4") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("5") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("6") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("8") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("*") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("0") + "\n");
        this._ExampleScreen.append(this._SystemInfo.getLocaleString("#") + "\n");
        this._ExampleScreen.setCommandListener((CommandListener)this);
        this._NextLevelScreen.setTitle(this._SystemInfo.getLocaleString("nextlevel"));
        this._NextLevelScreen.addCommand(new Command("Start", 4, 0));
        this._NextLevelScreen.append(this._SystemInfo.getLocaleString("nextleveltext") + "\n");
        this._NextLevelScreen.setCommandListener((CommandListener)this);
    }

    public void gameOver() {
    }

    public void pause() {
        if (!this._TetrisControler.isCanStartNew()) {
            this._TetrisControler.gamePause();
            this._PauseSet = true;
        }
    }

    public void start(Display display) {
        this._Display = display;
        Form currentDisplayable = this._ExampleScreen;
        if (!this._TetrisControler.isCanStartNew() && this._PauseSet) {
            this._TetrisControler.beginPlay();
            this._PauseSet = false;
            currentDisplayable = this.getGameCanvas();
        }
        this._Display.setCurrent((Displayable)currentDisplayable);
    }

    private Displayable getGameCanvas() {
        return (MidletGameCanvas)this._TetrisControler.getGameCanvas();
    }

    public void setRemovedPlanCount(int planCount) {
    }

    public void setTetrisControler(TetrisControler controler) {
        this._TetrisControler = controler;
    }

    public void commandAction(Command command, Displayable displayable) {
        System.out.println("commandAction");
        if (displayable == this._ExampleScreen || displayable == this._NextLevelScreen) {
            switch (command.getCommandType()) {
                case 4: {
                    System.out.println("OK");
                    this._TetrisControler.beginPlay();
                    this._Display.setCurrent(this.getGameCanvas());
                }
            }
        }
    }

    public void keyPressed(Canvas canvas, int code) {
        int game_code = canvas.getGameAction(code);
        switch (game_code) {
            case 1: {
                this.moveCurBlock(-2);
                break;
            }
            case 6: {
                this.moveCurBlock(2);
                break;
            }
            case 2: {
                this.moveCurBlock(-1);
                break;
            }
            case 5: {
                this.moveCurBlock(1);
                break;
            }
            case 8: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.reset();
                    break;
                }
                this._TetrisControler.moveBlockDown(true);
            }
        }
        switch (code) {
            case 49: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.gameRotation(50.0, 0.0, 0.0);
                    break;
                }
                this.rotateCurBlock(1);
                break;
            }
            case 50: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.gameRotation(0.0, 50.0, 0.0);
                    break;
                }
                this.rotateCurBlock(2);
                break;
            }
            case 51: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.gameRotation(0.0, 0.0, 50.0);
                    break;
                }
                this.rotateCurBlock(3);
                break;
            }
            case 52: {
                this.moveCurBlock(-1);
                break;
            }
            case 53: {
                this.moveCurBlock(-2);
                break;
            }
            case 54: {
                this.moveCurBlock(1);
                break;
            }
            case 56: {
                this.moveCurBlock(2);
                break;
            }
            case 42: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.beginPlay();
                    break;
                }
                this._TetrisControler.gamePause();
                break;
            }
            case 48: {
                if (this._TetrisControler.isGamePause()) {
                    this._TetrisControler.reset();
                    break;
                }
                this._TetrisControler.moveBlockDown(true);
                break;
            }
            case 35: {
                Form current = null;
                current = this._ExampleScreen;
                this._TetrisControler.gamePause();
                this._Display.setCurrent((Displayable)current);
            }
        }
    }

    private void rotateCurBlock(int axis) {
        this._TetrisControler.rotateTetrisBlock(axis);
    }

    private void moveCurBlock(int direction) {
        this._TetrisControler.moveTetrisBlock(direction);
    }

    public void startNextLevel() {
        this._TetrisControler.gamePause();
        this._Display.setCurrent((Displayable)this._NextLevelScreen);
    }

    class ExampleCanvas
    extends MidletCanvas {
        private String _ShowString = "";

        ExampleCanvas() {
        }

        protected void paint(Graphics g) {
            g.setColor(0xFFFFFF);
            int quaterX = this.getWidth() / 4;
            int quaterY = this.getHeight() / 4;
            g.fillRect(quaterX, quaterY, quaterX * 2, quaterY * 2);
            g.setColor(255);
            g.drawString(this._ShowString, (int)((double)this.getWidth() * 0.01), (int)((double)this.getHeight() * 0.01), 20);
        }
    }
}

