/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class GameMap {
    public int[][] trapData;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static byte tileWidth;
    static byte tileHight;
    int[] mapSize = new int[2];
    short[] tileProperties;
    String[] name;
    static int setOffX;
    static int setOffY;
    byte[] mapData;
    byte gameRank;
    public static final byte SCEEN_MOVE = 4;
    int posX;
    int posY;

    public void free() {
        this.mapData = null;
        System.gc();
    }

    public GameMap(int sw, int sh) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
        GameMap.setOff(0, 0);
    }

    public static void setOff(int x2, int y2) {
        setOffX = x2;
        setOffY = y2;
    }

    public void init(int GameRank) {
        this.gameRank = (byte)GameRank;
        this.free();
        switch (this.gameRank) {
            case 0: {
                this.loadMap("map_0.dat");
                Tools.createImage(this.name, 1);
                break;
            }
            case 1: {
                this.loadMap("map_1.dat");
                Tools.createImage(this.name, 1);
            }
        }
    }

    public void setTile() {
        int n2 = setOffX / tileWidth * this.mapSize[1] + setOffY / tileHight;
        int nw = SCREEN_WIDTH / tileWidth + 2;
        int nh = SCREEN_HEIGHT / tileHight + 2;
        int j2 = 0;
        while (j2 < nw) {
            int s2;
            int i2 = s2 = n2 + j2 * this.mapSize[1];
            while (i2 < s2 + nh) {
                if (i2 < this.mapData.length && i2 >= 0 && this.mapData[i2] != -1) {
                    int dataTemp = GameMap.getIndex(this.mapData[i2]);
                    int x2 = i2 / this.mapSize[1] * tileHight;
                    int y2 = i2 % this.mapSize[1] * tileWidth;
                    Tools.addImage(300 + dataTemp, x2, y2, 0, 0, tileWidth, tileHight, 20, (byte)GameMap.getTrans(this.mapData[i2]), Tools.getProperties(this.tileProperties[dataTemp], (byte)1) ? 30 : 20);
                }
                ++i2;
            }
            ++j2;
        }
    }

    public void setMap(Graphics g2) {
        if (this.mapData != null) {
            this.setTile();
        }
    }

    public void AdjustSrceen(GameRole role, int x2, int y2) {
        this.posX = 80;
        this.posY = 100;
        setOffX = Math.abs(x2 - setOffX - this.posX) > 4 ? (x2 - setOffX - this.posX >= 4 ? (setOffX += 4) : (setOffX -= 4)) : (int)((short)(x2 - this.posX));
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, this.mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = Math.abs(y2 - setOffY - this.posY) > 4 ? (y2 - setOffY - this.posY >= 4 ? (setOffY += 4) : (setOffY -= 4)) : (int)((short)(y2 - this.posY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, this.mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public boolean canMove(int x2, int y2) {
        return this.inMapData(x2, y2) != -1 && Tools.getProperties(this.tileProperties[GameMap.getIndex(this.inMapData(x2, y2))], (byte)1);
    }

    public byte inMapData(int x2, int y2) {
        int tx = x2 / tileWidth;
        int ty = y2 / tileHight;
        if (tx < 0 || tx >= this.mapSize[0] || ty <= 0 || ty >= this.mapSize[1]) {
            return -1;
        }
        int n2 = tx * this.mapSize[1] + ty;
        return this.mapData[n2];
    }

    public void setTrans(int x2, int y2, int trans) {
        int v2 = this.getIndex(x2, y2) + (trans << 6);
        this.setTileValue(x2, y2, v2);
    }

    public void setTileValue(int x2, int y2, int value) {
        int tx = x2 / tileWidth;
        int ty = y2 / tileHight;
        if (tx < 0 || tx >= this.mapSize[0] || ty <= 0 || ty >= this.mapSize[1]) {
            return;
        }
        int n2 = tx * this.mapSize[1] + ty;
        this.mapData[n2] = (byte)value;
    }

    public void setIndex(int x2, int y2, int index) {
        int v2 = (this.getTrans(x2, y2) << 6) + index;
        this.setTileValue(x2, y2, v2);
    }

    public static int getTrans(int v2) {
        return v2 >> 6 & 3;
    }

    public int getTrans(int x2, int y2) {
        return GameMap.getTrans(this.inMapData(x2, y2));
    }

    public static int getIndex(int v2) {
        return v2 & 0x3F;
    }

    public int getIndex(int x2, int y2) {
        return GameMap.getIndex(this.inMapData(x2, y2));
    }

    static int bToi(byte byte0) {
        int i2 = byte0;
        if (byte0 < 0) {
            i2 += 256;
        }
        return i2;
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        Tools.addRect((byte)1, 100, 100, 200, 200, true, 20, 0, 0);
    }

    public void loadMap(String file) {
        this.mapData = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(file));
        try {
            this.mapSize[0] = GameMap.bToi(in.readByte());
            this.mapSize[1] = GameMap.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = this.mapSize[0] * this.mapSize[1];
            this.mapData = new byte[size];
            in.read(this.mapData);
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i2 = 0;
            while (i2 < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i2] = new String(names);
                this.tileProperties[i2] = in.readShort();
                ++i2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

